# Launcher program for CASANOVA Version 1.0
# Cluster Analysis by Subgroups using ANOVA
#
# This is the launcher program for running the CASANOVA algorithm for clustering
# compound-specific dose-response patterns. This requires the Fx_cluster subroutine
# found in the CASANOVA.R program.
#
# Variables should be defined in the section noted below. 

#clear console
rm(list=ls())

# --------------------------- Variables to be defined by the user ---------------------------------------------
home.dir = "C:/Users/shockleykr/Desktop/CASANOVA.R"               # Directory where CASANOVA program file is located
input.output.dir = "C:/Users/shockleykr/Desktop/CASANOVA.R/data"  # Directory where input and output files are located
dset = "ExampleData.txt"                                          # Filename for input file
dose.levels = 5                                                   # Number of dose levels desired
dose.groupings <- c(1,1,1,2,2,2,3,3,3,4,4,4,5,5,5)                # How to break up the doses when checking profiles
col.names <- c("conc", "resp")                                    # Column names in the input file to identify concentrations and responses
start.conc.idx <- 0                                               # The starting number for the above columns (0 means the sequence is conc0, conc1, ...)
detection.limit.pos <- 7.928*3;                                   # The upper assay detection limit
detection.limit.neg <- -7.928*3;                                  # The lower assay detection limit
# -------------------------------------------------------------------------------------------------------------

source(paste(home.dir, "CASANOVA_v1_0.R", sep = "/"))

ptm <- proc.time()

# Call main clustering function with the above parameters
results <- Fx_cluster(DIR = input.output.dir, dataSetName=dset, DetLim_pos = detection.limit.pos, DetLim_neg = detection.limit.neg, dose.groupings = dose.groupings, col.names = col.names, start.conc.idx = start.conc.idx)

print(proc.time() - ptm)

#Output columns:
#"allNoise"		-	Takes value of "0" if at least one response is outside of assay noise, "1" if all responses are inside assay noise
#"cluster"		-	Takes value of "NA" for repeats within the assay noise, integers identify the distinct clusters
#"CODE"		-	Designation for the chemical ("CASE1_CONCL", "CASE1_INCONCL", "CASE2", "CASE3_CONCL", "CASE3_INCONCL", see Shockley et al., 2019)
#"MSE.vec"		-	Mean Squared Error of the ANOVA model fit to the chemical
#"Range.vec"	-	Mean value of the range of the response values in the chemical (mean of the range for each repeat profile)
#"CV.vec"		-	Coefficient of Variation (sqrt(MSE.vec)/Range.vec) of the chemical	

