//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
//ART_ILLUMINA -- Artificial Read Transcription 
//Copyright(c) 2008-2011 Weichun Huang All Rights Reserved.
//___________________________________________________________________________
#pragma once
#include <iostream>
#include <vector>
#include <sstream>
#include <fstream>
#include <string>
#include <map>
#include <cmath>


#define HIGHEST_QUAL 80

#define QUAL_DIST_ONE36 ".	0	3	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	40\n.	0	39375	355755	395136	415685	1227131	1338634	1522001	1851208	2165909	2436839	2608538	3151544	3638628	4218935	4552017	4936868	6093912	6810203	7762413	8336676	9740769	11066722	13282828	16958345	28105900	72514851	93003507	107259823	112268937	122560993	138449311	148388962	183462055	192213544	212042638\n.	1	2	3	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	40\n.	1	15243	108576	117984	518824	605021	651426	1649518	1764372	2042272	2429745	2936975	3294066	3555517	4265891	4849912	5560341	5946181	6719762	8355788	9375144	10726899	11536692	13375711	15038386	18861613	25132232	38004972	78004701	100158136	113104865	117874830	128520434	144627832	155160635	187369444	195241192	212042638\n.	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n.	2	8289	153216	531455	931040	995566	1505415	1565530	2270425	2610073	3061110	3344949	4283816	4580697	5008541	5334093	5725911	6578896	7762182	8736896	10578899	11800685	13216231	15768605	18760247	23890740	35004259	68854441	94729486	98627663	116540635	129934254	145732234	161340087	183427596	185580596	198396898	212042638\n.	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n.	3	13622	36125	80915	408184	714581	900792	1573190	1779376	2253594	2777744	3259319	3893808	4287471	4891393	6200120	6819687	8431755	9036675	10281258	11083684	13046129	14563366	16875635	18849507	25659866	34362472	54115926	80266497	109281369	119706162	131234853	138437857	161050144	184721633	196420755	201447523	212042638\n.	4	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n.	4	287940	302159	356484	527302	728934	1201611	1368933	1824798	2291335	2483379	3534279	3975263	4180261	4984018	5444585	6115721	7592554	8753784	9970523	11276508	12465637	14098966	17297813	19457540	22494230	28783923	60042655	88697340	108156516	117053139	129985631	138262449	160912370	191165027	197586731	200488881	212042638\n.	5	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n.	5	83731	231237	740647	820708	1056631	1088935	1234065	2079234	2325112	2767960	3253528	3797048	4058220	4945245	5528956	6011906	7215943	9096291	10052056	11122686	11843742	13994530	15316372	16388317	18788353	21290780	31958731	47071008	82236953	101039585	112917038	129394287	139426365	155425723	192129074	195563491	201692200	212042638\n.	6	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n.	6	5349	164973	269610	471235	636066	1007134	1458071	1532484	2074939	2407128	2490863	3321071	4414032	5533715	6104893	7893366	8423737	9900791	10848652	11906948	12887576	13940421	16015302	18776852	20592373	23243210	34945229	60040080	77849911	103283607	115432024	134602275	143666117	156371267	190752229	196771415	203312599	212042638\n.	7	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n.	7	17367	33750	416645	639412	678767	1137364	1626460	1932836	2078806	2868019	3438169	3733398	4165298	5429469	5673005	6848413	7759871	8567236	10074725	11473771	13701531	16143198	18699187	21583905	27714231	32236038	49659233	77571503	104736736	113780703	128241502	141453349	153303552	191275901	196449226	204943025	212042638\n.	8	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n.	8	203677	215947	526975	578552	598763	1470538	2324119	2453112	2992252	3544903	4106329	4502845	4838412	6014976	7005496	7602612	8762402	9821729	10940378	11601731	12492406	14754732	17006493	19601417	22704399	30992256	49428537	82611867	99194079	117706460	130175669	141627464	161155413	192973910	201890094	205237193	212042638\n.	9	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n.	9	330282	336164	414257	464350	1173646	1262693	2102590	2322758	2713359	2787283	3990194	4644235	5731017	6037944	6206698	6783342	8182683	8489146	10560074	12061055	14827032	17340066	19350198	20419212	25297034	39216179	54413326	85440663	94805281	109083793	134233962	141513944	155053918	191477652	200053320	207147265	212042638\n.	10	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n.	10	10070	34825	103427	493593	974437	1268150	1584695	2270382	3063397	3341586	4153780	4943692	5379280	5588209	6771090	7829307	9038202	9817181	11364875	12412163	14219690	16704437	19668818	21172557	23496312	32409251	51150927	75324627	90302575	116854564	125079256	138866004	158358279	188928792	199990765	207437593	212042638\n.	11	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39\n.	11	117495	147132	218321	751688	778916	1585116	1970396	2302577	3373253	3442197	3860752	4725455	5316704	6172623	6519486	8029702	10509565	12249443	12585310	15300671	15876818	18368545	21999396	25072180	30893935	37722230	62334737	77772605	102167335	120747522	129872921	144002734	161244063	191483845	202344668	212042638\n.	12	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n.	12	27947	44802	110519	639114	687585	1321313	1437320	2017252	2762109	2935868	3054246	3627896	4838795	6196874	6841579	7275886	8458010	9819679	11379340	12983865	15236478	17832951	20505316	24576041	27320281	32341280	49572631	83814373	99717038	115324898	131792537	137835120	156984388	183108183	202957628	208175013	212042638\n.	13	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n.	13	10501	399696	621154	672243	720221	1548649	1970395	2333611	2856368	3139680	3751712	5680578	6680670	7263407	8038062	9179750	9790477	10432160	11727186	14335670	16873602	21402824	22726736	25416278	29673144	37282242	53397652	90789114	103667367	118710192	126455844	139961844	152744730	191713215	207355178	210493082	212042638\n.	14	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39\n.	14	9469	257617	295513	817869	930825	1684430	2214236	2659660	2979329	3095828	5044060	5550948	7029631	7586831	8443650	9908603	11450745	11679947	13681521	14680304	15936545	18683703	22136018	25464527	28640507	33682355	58732360	77516933	97647664	112574599	128771488	142094316	152837263	182714433	204968910	212042638\n.	15	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n.	15	18363	53081	101673	916112	976315	1119579	1627191	2830833	3087390	3689091	5397691	5746276	7736586	8668837	10175410	10506155	12208600	12941361	14088596	17195970	19509993	21379536	24811694	27804314	31829214	43788868	63064275	82014924	103161773	115891368	130319329	144547028	155276648	183669982	207222716	210479482	212042638\n.	16	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39\n.	16	12980	23113	402778	988585	1276583	1776590	2119698	3027004	3613671	4977641	6023054	6585328	6956420	7594438	9266188	11346289	12579016	14076995	15289418	16140022	18656169	22537957	25795524	28871522	32828079	39916038	59196622	90413762	98516976	117404616	135247434	147103504	158313512	185324843	207604127	212042638\n.	17	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39\n.	17	9795	31701	118062	1125273	1553442	1684737	3316430	4194369	4315377	4414570	4671832	7998061	8303718	9261122	10034454	12121989	13721767	15642107	16834941	17682880	20185916	24921842	27810962	33063527	37240274	49559661	64710231	87844309	105418433	123418974	132744474	148669122	155157938	182374694	209507902	212042638\n.	18	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39\n.	18	47452	585652	642662	1800071	1889139	2122970	3710470	3828927	4406827	4735775	6615176	7361192	9080799	11596400	12454368	15686699	17549748	18451829	19950785	21906708	26470416	30942862	34903077	37292356	50046987	62895774	90688448	100604719	114598271	133094212	149540054	158857092	180273506	210053032	212042638\n.	19	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39\n.	19	10604	22177	638941	1734679	2304607	2541534	2750468	3243114	4425797	5044908	5292662	6069452	8291669	9100074	10255162	11400610	15865992	16616454	20468305	20986274	24236077	27370565	30686188	35569279	41960332	48917007	62212223	87341472	98834651	121078722	127936292	148088555	163127905	180197040	209589945	212042638\n.	20	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\n.	20	27015	43658	724703	736964	1341776	2489076	2831536	2946521	5310378	6159227	8036263	8589841	9292983	11586355	12626599	13691497	17159346	18823708	20573442	23342185	25349488	28112829	31515714	37303472	45759960	60442768	70974036	93911169	110503881	123530363	129160713	142159162	158322297	181261888	212042638\n.	21	4	5	6	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39\n.	21	11290	55453	224165	1555776	2705788	2885866	3494295	4250063	5855843	7528951	9178346	11401613	12022985	12527518	14389893	15588138	17339843	21014929	25097309	28169853	29277416	31871353	38092987	43097927	52942519	70263500	83579721	105118132	118466275	130553687	144346047	155574633	169895103	211442599	212042638\n.	22	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\n.	22	12520	48321	194407	954053	1700767	2025835	3235685	3478248	5062696	5900692	6099992	7145098	9591549	12991546	13780728	15910757	19181915	20059958	21504404	24680174	27179870	29832083	31894201	40124496	45920521	56543611	70783914	100580912	112013931	123781857	135054582	146458114	162682444	178730548	212042638\n.	23	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\n.	23	13536	47677	1015337	1068996	1866847	2346375	3791046	3913740	4632889	6232737	6675694	7672271	9073671	10096760	13914650	15914458	17051512	21305281	24221668	27287168	30281828	34286770	37314612	45304361	48710150	59268749	75246433	103177523	120936260	133412215	140915378	148750393	159035406	175165804	212042638\n.	24	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39\n.	24	16156	63603	214473	1339380	2171981	2550698	3977237	4624557	4750825	4982445	7688413	9790690	11369279	14510606	16005628	17275163	19785190	21504608	24144893	26465058	28709975	36109983	41033503	47541646	52759536	59949211	80021462	95470655	114920687	125696704	138474825	148486748	162137188	174506015	211737724	212042638\n.	25	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39\n.	25	38701	324342	799574	1850326	2476889	3569444	3992092	5732221	6329132	7633088	10858376	11477945	13808186	15304052	17828418	19928880	23304637	26556631	29419665	33411133	37248696	43529558	47434578	51138323	58649633	66665882	79326497	99092830	113401841	128632242	140821533	148120206	158045696	176700336	208483406	212042638\n.	26	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39\n.	26	110307	270439	1817279	2097618	2761468	3818782	5689245	6042287	6475960	7753927	10314557	11675974	13555814	16141967	19389635	22804157	25081310	30960787	34498714	36935861	42347548	47131008	51456365	54575103	61947894	70529985	86869250	99806488	114001591	129971214	140464432	150937086	160650189	174634228	205291960	212042638\n.	27	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39\n.	27	72366	294331	717251	2279088	2907181	4146515	4272066	6411332	7663577	7753125	10521605	11269792	14544298	16333437	21056693	23186553	28212761	30280802	31814949	39689026	41590203	47358710	52837046	55566742	59545509	74678948	90507019	102872620	124099848	134112608	137922982	151668606	161649833	184557207	205951116	212042638\n.	28	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\n.	28	2367151	4030890	4226913	7851616	11281502	16524096	20812300	25053951	26658512	28440414	32807237	35442660	37068124	40092250	43291509	47383615	49640421	54145840	60985378	64639310	68671106	72277125	75107914	80523022	85093575	90293362	101978066	117091566	137521934	160438437	174561853	183220208	191041402	198830169	205793210	209541547	212042638\n.	29	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\n.	29	1356814	3735374	8099366	10400026	16700710	21131448	23838123	27198700	29109411	32025794	37546446	39410760	41937166	45536747	48439644	50971188	55211539	61564613	65444224	68299772	72270001	75407270	80189337	83740793	90919307	97528716	115615832	137752223	157400208	180188804	186696237	192608623	200778798	206579647	211895555	212042638\n.	30	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\n.	30	1134080	5065653	10833506	13247744	18684362	24173946	27954681	30821225	33404267	36093928	41078464	43675383	48174261	50048583	54147525	57611164	60803175	66478422	70020915	75315654	80289755	85974837	89694974	93161385	98034657	103554628	125299092	149987930	168796890	188653483	192843010	196413887	201474995	207746521	210237145	212042638\n.	31	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\n.	31	975361	1629803	5166503	8928967	11903347	16942642	24368917	25877818	31601371	32822009	35744864	42180648	44140653	48642638	51132332	54734167	59441342	61608199	70304752	73463996	75764733	80747933	82417634	87870803	92643192	98000039	106142731	121741841	147008386	177544790	185862988	192214147	200902217	203610021	206496371	210290521	212042638\n.	32	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\n.	32	1008276	3408040	7599663	12353145	18215806	24529287	29618271	33571131	35344059	36371620	42212910	48288357	50639618	54286571	56187935	59787351	66421734	72403902	75393172	79639765	82680162	87125522	91343801	96329380	107281504	120575843	131931139	157212223	177510127	189103416	196571823	201512320	205969511	208515483	211359907	212042638\n.	33	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\n.	33	1060831	1424101	9509049	14117480	18507991	25942422	29534786	35451671	37833578	39236925	44796104	50204766	53454219	56530675	59437653	63301806	68845402	75058879	79486236	82155489	85805906	92066500	96975144	99147389	106728735	125212694	139519921	164798144	186426430	194034012	199479077	204356199	207729969	208727503	210302213	212042638\n.	34	1	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\n.	34	1126815	3187212	8520556	13655771	21820080	26314237	33699603	36088486	39687400	41692082	45088411	49166441	54951873	58989367	61733104	64950863	71415929	78074212	80782444	83774138	89640637	94829852	98454652	106490537	113797928	131161273	147649343	168068009	185390831	192726565	197823018	203962243	207282428	210431140	211885982	212042638\n.	35	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	20	21	22	23	24	25	26	27	28	29	30	31	32	33	35\n.	35	434262	1341151	1725690	2979293	3478620	3592624	3672807	3873754	4096922	4983957	6111261	6898402	7597361	8486640	9406962	11743595	13338069	14845232	15537173	18514328	20186793	24806540	27108933	34777580	44718061	64200761	77403976	77414015	77460475	77509561\nA	0	3	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	40\nA	0	560	99637	111485	119727	389899	412150	458066	572958	665153	745916	793532	967311	1156756	1361967	1507033	1639146	2055795	2280361	2681133	2895237	3389786	3940804	4762405	6007891	10038371	24261751	31018851	35715045	37864716	41682782	47748833	52383931	64626869	67231056	71741846\nA	1	2	3	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	40\nA	1	3326	5905	8203	117622	139587	151872	428292	451839	511790	625329	752644	852609	919420	1117899	1287226	1496630	1624098	1759431	2239122	2492497	2873390	3126529	3687350	4227648	5371352	7259243	11385016	23779003	30492699	34659139	36438644	39999778	45161591	49153358	59017215	61135588	64947919\nA	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nA	2	1489	16247	118581	205078	219308	343784	359166	541251	588063	701989	780675	1036943	1126194	1239733	1323128	1423469	1607416	1936266	2190589	2633161	3023781	3431411	4156412	5051954	6508040	9396200	18586269	26565808	27889413	33197694	37612206	42667647	47321374	54977735	55668940	58839305	62388759\nA	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nA	3	2924	7935	17644	104625	185426	227195	333735	384025	519491	651148	789909	970381	1076313	1243668	1637710	1811669	2163726	2352202	2753846	2924640	3308145	3733325	4448209	5136188	6981268	9350585	14674843	22397596	30643833	34131151	37937739	40685801	46797805	54781532	57829796	58975193	61399530\nA	4	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nA	4	79351	83043	94676	138553	193096	313360	350812	457572	594740	647378	934789	1057889	1106807	1348200	1474630	1665882	1995109	2351477	2676049	3033898	3259019	3804595	4790418	5427220	6413733	8126567	16902156	24716705	30617337	33556308	37945841	41120185	47428854	57323344	58921237	59642767	61895365\nA	5	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nA	5	8381	48613	138307	153748	159647	167780	200524	402602	473932	587044	723774	863882	945192	1186161	1340508	1480093	1840805	2382261	2625432	2865949	3118907	3576623	3982762	4301507	5013000	5826358	8398574	12687624	22441654	28049868	31868367	37418863	41187835	46161169	57239135	58289599	59738090	61431625\nA	6	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nA	6	1552	44451	58519	63920	99008	202474	326308	340744	456906	547977	563682	817740	1160284	1477856	1635587	2166418	2322668	2707526	3026687	3223649	3469657	3772825	4246138	5057452	5659362	6539240	9400100	16963501	22328084	29272116	33037979	38714281	42049233	46935467	57402497	58926090	60227367	61561670\nA	7	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nA	7	3944	7315	112588	170325	181590	311039	427701	496419	532425	712091	866765	933984	1050440	1422118	1483472	1850765	2050127	2305781	2672688	3020394	3614636	4395595	5190276	6065079	7706215	8986651	13870238	21948266	29076492	32233886	37199356	41139432	45681101	57086187	58748475	60276840	61050601\nA	8	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nA	8	55117	58272	128316	138242	143177	369204	583008	608376	775622	917666	1004642	1107387	1197305	1542662	1829583	2006848	2200362	2518706	2836124	2993085	3231005	3851316	4403053	5195628	6218899	8475103	13393857	22477042	27265226	32607621	36360808	40118456	46134491	56730077	59278799	59800579	60583513\nA	9	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nA	9	78122	79866	95504	105935	291322	309995	460920	509426	595374	611484	1016957	1177441	1471858	1541823	1585534	1737806	2149596	2227566	2763783	3230923	3956400	4689443	5319200	5649607	7111655	10506499	14612101	23712609	26789325	30999090	38265424	40775732	45831464	56650667	59208203	60234988	60929192\nA	10	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nA	10	2029	7551	21440	125509	261571	320074	386862	520488	730061	820650	1010708	1248023	1352199	1402754	1716904	2073185	2416531	2674035	3055544	3308918	3554723	4304819	5265442	5678189	6410216	8798718	14030389	21180374	25148427	32486051	35374756	39621024	45243482	55458942	59127897	60426451	60876384\nA	11	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39\nA	11	30091	37723	50995	200603	206545	394528	480356	552353	848527	861408	973907	1201811	1353527	1620306	1719796	2145636	2980449	3453788	3543956	4309117	4470985	5061340	6105694	7093454	8793660	10521249	16636478	21308910	27895429	33640080	36592038	40894717	45467294	55351317	58878708	60338530\nA	12	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nA	12	6238	10401	22540	152145	163348	342767	363725	484922	704025	746793	772178	856802	1211487	1575059	1732893	1837021	2108633	2503599	2942778	3391685	3933720	4723607	5335556	6650627	7437875	9101588	13456136	23203386	28097500	32144048	37135750	39127122	44561344	53236079	59175871	60042456	60473843\nA	13	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nA	13	2126	112684	168425	178391	187444	409391	482889	560739	673225	733683	883830	1476679	1769371	1912863	2100981	2446714	2564430	2765879	3155008	3773140	4481322	5756503	6179058	6941742	8167145	10122612	14372398	24721027	28291159	32367761	34769099	38934049	43000570	54911097	59399751	59669238	60053628\nA	14	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39\nA	14	1886	50590	58622	200636	212586	430940	547065	639651	660193	688709	1272302	1381144	1761394	1890153	2141109	2577441	3034820	3086442	3634109	3904661	4142021	5006794	5943281	7044401	7973789	9423505	15628550	21087510	27216259	30851208	35860041	39856238	43119421	52704759	59129950	60099499\nA	15	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nA	15	4245	11242	19911	227232	238684	266683	381836	698204	709780	840177	1332359	1413280	1960782	2187425	2654395	2736158	3190863	3393210	3665046	4640135	5261997	5633771	6664455	7538429	8669185	11931050	16693723	22098817	28455740	31620502	36121091	39975277	42831945	51847114	59380300	59641857	59917622\nA	16	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39\nA	16	3105	5041	100205	269523	280744	384075	453208	715795	837594	1238434	1553576	1705830	1789968	1995790	2455541	2967988	3352427	3781643	4077957	4310158	4859952	6023540	6819521	7722480	8963460	10727956	15642259	24555739	26925262	32179776	37301153	40935951	43670302	52198595	59428727	60008765\nA	17	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39\nA	17	1859	6806	22658	306010	393593	417462	828304	917905	940845	961307	1016557	1965363	2033750	2266700	2487581	3217503	3675118	4201199	4501590	4781813	5432595	6742340	7591026	9109484	10325833	13037739	17221191	24094436	28773544	33634578	36415920	40716157	42289550	50676677	59310656	59523479\nA	18	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39\nA	18	9458	121728	133578	456948	472743	517652	939810	961200	1125597	1202103	1748241	1889470	2344255	3172429	3392629	4304668	4865633	5048044	5352457	5934640	7326784	8479591	9508004	9993011	12983201	16012593	24177303	26973889	30581973	36022956	40838574	43342163	49837340	59309539	59539451\nA	19	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39\nA	19	2091	4759	136528	415556	562882	608974	646989	694567	1047793	1191091	1242850	1426573	2109327	2263247	2560518	2838910	4146403	4380556	5544477	5666241	6611771	7671062	8475898	9754252	11284124	12833576	16061905	23046608	26273112	32992464	34856431	40416058	44374635	49250124	59008959	59356909\nA	20	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nA	20	5603	8317	159047	161890	322001	638518	705451	727916	1368968	1590707	2150113	2272812	2440341	3075306	3295759	3621635	4712626	5208954	5630379	6528243	7138167	7935225	8872296	10322936	12327201	15821051	18403306	24687016	29669036	33509225	35031597	38484269	42655280	49381666	59245013\nA	21	4	5	6	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39\nA	21	2272	10945	43676	371937	697651	730284	858512	1002097	1445393	1782218	2284168	2944886	3075868	3190118	3766513	4019005	4533821	5588458	6708607	7705233	7994286	8546908	10277742	11279854	13734576	17938291	21483138	27888882	31462085	34692638	38985881	41684997	45355723	59044044	59246620\nA	22	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nA	22	2525	10167	39206	218819	422651	480672	836373	885470	1356959	1543833	1584521	1836842	2523951	3502636	3623989	4235413	5029726	5318965	5701163	6631810	7427026	8063455	8480196	10642092	11966268	14662231	18329143	26826060	29950452	33052407	36490322	39659622	43758342	48248854	59293440\nA	23	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nA	23	2851	9785	239014	249444	473999	560567	977153	1000687	1149264	1639909	1749026	1935431	2285161	2501630	3600411	3986182	4226518	5503846	6460019	7316247	8206475	9161371	9963933	11885010	12679086	15228469	19449931	27324236	32385872	36027909	37827311	40044856	42316992	46722250	58949081\nA	24	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39\nA	24	3245	13009	42145	311964	558289	629366	1055670	1193148	1219206	1263735	2062501	2558887	2909468	3819625	4264562	4537094	5207191	5601852	6360353	7012301	7644541	9435456	10674140	12261039	13436400	14961350	20159683	24561299	29982288	32871265	36773612	39666119	43711450	46918668	58984923	59084961\nA	25	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39\nA	25	7817	57074	151115	420948	542257	853952	942891	1397529	1526050	1827393	2759539	2916615	3552411	3965759	4699677	5237893	6129704	6855402	7723398	8856836	9867443	11454605	12364699	13245034	14725374	16668171	19887179	25539543	29740492	33966024	37407320	39379401	42029979	47396861	57432530	58744622\nA	26	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39\nA	26	19911	46550	425156	479829	609591	926829	1477388	1549571	1642305	1928315	2676803	3053781	3453418	4106491	5025015	6022983	6578414	8182880	9147825	9711824	10954687	12074557	12965199	13627908	15377809	17600064	21716853	25361509	29545223	34172254	37081381	39839402	42521447	46372724	55922232	58346862\nA	27	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39\nA	27	12993	51893	136323	533048	656629	1022398	1049213	1666807	1908601	1926227	2721322	2911205	3740692	4197760	5404713	6020017	7304657	7835639	8207237	10074369	10366123	11700550	12914410	13592879	14527473	18372451	22918950	26160976	31960706	35064266	36115149	39949940	42799136	49589968	56328339	58490018\nA	28	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nA	28	585255	952854	987095	1865253	2734577	4117554	5238289	6491450	6923008	7227671	8532416	9296621	9683070	10516660	11416250	12460335	13000295	14076884	15808984	16750098	17585121	18468361	19084099	20487550	21910141	23391270	26908058	30649535	36429994	43472465	47161003	49831496	52196921	54428991	56196698	57141080	57981586\nA	29	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nA	29	274524	862728	1982063	2545525	4204672	5345316	5861640	6893639	7384606	8227466	9821905	10306172	10894164	11824410	12601096	13181747	14309229	15819941	16798360	17412184	18347136	19170635	20396374	21311790	23440006	25480518	30432128	36954934	42640193	49275212	51072659	52641362	54997313	56350190	57883083	57918705\nA	30	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nA	30	224310	1268958	2585881	3328022	4737029	6056106	7151564	7948033	8722462	9409007	10908745	11478563	12556150	13005670	14241637	15013329	15830990	17080083	17906670	19308091	20749101	22475348	23457779	24432017	25951661	27718518	33751230	40250340	45692297	51848851	53025874	53854389	55084287	56421358	56906705	57317949\nA	31	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nA	31	202356	315262	1241193	2159908	2922114	4145338	6090441	6507057	8183464	8442296	9219671	11081989	11571731	12721969	13213071	14010139	15126103	15555078	17684492	18313393	18808228	20220242	20610098	22234784	23598042	25179035	27293434	31732548	39015714	48324867	50745204	52590732	55056420	55537951	56143790	57118729	57612599\nA	32	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nA	32	205412	787474	1882350	3003067	4444406	6276206	7549519	8586508	8956886	9246126	10820650	12380585	12937288	13714233	14129091	14930072	16628340	17978872	18635294	19857500	20597250	21907292	23000721	24445838	27928471	31418883	34851782	42090262	48163053	51548469	53722085	54983720	56102058	56575033	57213308	57368699\nA	33	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nA	33	209509	277286	2335770	3525070	4445439	6420717	7283836	9031474	9449902	9781878	11074698	12641962	13257360	13982026	14572980	15464715	16661763	18356732	19501926	20240734	21165862	23024345	24366377	24979702	27167405	32529666	36703145	43525223	50283827	52450874	54073307	54988597	55846314	56025486	56357175	56926148\nA	34	1	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nA	34	238442	773228	2117543	3328434	5678460	6559053	8607049	9302752	10154572	10437907	11284753	12413557	13875653	14768806	15234532	15798739	17413626	19161848	19843468	20475528	22193030	23597754	24505593	26989697	29204504	34028138	38563426	44177864	49636088	51787835	53212866	54742344	55583234	56332283	56728224	56767678\nA	35	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	20	21	22	23	24	25	26	27	28	29	30	31	32	33	35\nA	35	83546	269565	351742	601833	711346	731909	746740	789576	840660	1034073	1298828	1465769	1609719	1782181	2004967	2529651	2889213	3234232	3444601	4182534	4559115	5783218	6474340	8352115	11117463	16366582	20462583	20465833	20482538	20499799\nT	0	3	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	40\nT	0	580	64185	72157	74814	250603	280764	325240	397639	466770	527223	561355	688456	793263	920899	988590	1037774	1274255	1406779	1589232	1692297	1946754	2218190	2595134	3335142	6104994	16994004	22190062	25319591	26597057	29336240	33335197	35722635	46291074	49017530	54872644\nT	1	2	3	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	40\nT	1	4757	7529	9999	116675	143217	156836	427702	462633	548820	653198	802710	884801	959005	1146392	1310275	1502069	1601144	1700865	2130282	2365099	2646472	2833624	3265235	3710238	4565815	6012612	9280886	18628317	24510769	27384579	28682782	31604389	36013344	38945808	48708592	51149238	55787613\nT	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nT	2	2638	16114	126202	228912	248143	386599	405021	617587	672859	809367	881650	1128800	1217486	1337218	1434420	1560226	1720857	2067047	2274126	2684692	3004495	3396480	4071023	4938094	6271479	8967586	17965212	25084524	26153990	31408177	35193603	39674238	44860036	51168814	51814470	55726676	59490219\nT	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nT	3	3913	11164	26539	123112	212625	272568	425509	489101	629534	784306	903886	1084199	1189217	1356948	1699314	1890089	2282932	2454382	2786101	2943968	3343138	3767990	4356842	4909113	6669184	8793441	13581311	21057730	29666036	32414431	35653214	37440084	44671555	51441643	55088032	56525572	59663907\nT	4	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nT	4	79562	83442	101406	150328	207924	345395	398271	529268	642237	696216	967418	1093428	1154304	1369834	1500357	1681420	2007763	2303513	2539528	2908046	3104475	3495794	4356947	4883089	5647644	7203866	15312743	23429093	28784902	31147202	34700115	36787377	44092177	52595686	54836809	55805164	59198300\nT	5	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nT	5	9669	45954	129879	156809	162764	172191	211897	454549	516413	640094	750686	902383	964680	1199011	1367606	1483148	1798779	2264829	2548011	2749073	2895057	3309604	3642346	3917623	4534991	5149045	7553005	11485309	21173191	26198981	29162160	33541374	35974365	40767114	51595484	52599616	54530087	57758132\nT	6	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nT	6	1333	43045	58871	70726	113588	213837	339854	364402	529023	615610	644029	843443	1113187	1392485	1541386	2017712	2154605	2467513	2698683	2904028	3153679	3430990	3861357	4526668	4974900	5627042	8350231	15098610	19925910	27417679	30365619	36258063	38647461	41761354	51820026	53921630	56166648	59106173\nT	7	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nT	7	4828	9491	114419	173809	185242	310947	453885	545256	582351	726915	885034	968730	1090885	1421802	1489730	1787859	1971698	2187389	2495374	2806008	3225823	3845206	4477867	5232746	6697877	7853630	12376684	19970045	27859959	30259036	34229560	38352111	41256566	52518441	53988465	57095769	59819515\nT	8	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nT	8	52194	55461	137052	154097	159849	399846	647508	685622	833093	976628	1093872	1188508	1274063	1569630	1833036	1982351	2192633	2453854	2725044	2890041	3080699	3579032	4061341	4735038	5549567	7621310	13221303	21891835	26143227	32390544	35562497	38878710	44386157	53459228	56057198	57224463	59959824\nT	9	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nT	9	73880	75393	98272	114977	304248	328633	518824	579214	698181	719685	976807	1154977	1441965	1530139	1570295	1720979	2040784	2127368	2575073	2914748	3553762	4021581	4520179	4785304	6031034	9246241	12828752	22382068	24748041	28173166	36307470	38173934	41389179	52246502	54930969	57807919	59540342\nT	10	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nT	10	2809	9572	29288	132615	263777	353802	449187	567226	769657	840410	1065683	1243070	1363694	1415600	1729141	1957179	2278524	2480685	2868381	3124809	3325283	3952170	4667858	5040967	5620705	7733447	12556715	19233222	23663903	31325306	33480276	37517524	43191603	51698567	54841366	57728055	59522228\nT	11	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39\nT	11	29959	37738	59001	207630	215928	439215	548272	643620	932468	956198	1058372	1292281	1447541	1635565	1724424	2127704	2698403	3133971	3200156	3905119	3999192	4476092	5330295	6094824	7397745	8954443	15922974	19873045	27632837	32816313	35199793	39510134	44751674	53352297	56323299	60017258\nT	12	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nT	12	7814	12420	32268	161458	175547	349313	386805	559615	762998	807061	841051	946042	1244635	1594935	1769123	1888974	2175921	2524592	2847099	3166314	3726449	4396773	4972697	5967781	6689239	7902358	11893911	21665770	26385827	30775662	35657175	37509395	43219364	50594101	56816566	58950318	60527096\nT	13	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nT	13	2797	104559	162098	177624	194013	424100	519929	627431	779428	858324	981696	1458627	1699048	1859246	2080160	2345163	2488810	2642795	2981544	3542611	4000418	5148717	5484442	6113824	7234529	9006274	12989353	23214888	27821996	32290689	34356713	38532331	41959862	53544684	58670124	59985335	60437369\nT	14	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39\nT	14	2854	54464	64663	208129	222205	426091	576063	710726	751329	781305	1256375	1406180	1730781	1886878	2098929	2441589	2795812	2863634	3366093	3635491	3889424	4500089	5212420	6033593	6875296	8148307	13904707	19836969	26060003	30253034	34947670	38653215	41704692	50130971	57081421	60046593\nT	15	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nT	15	5089	15165	30402	233846	248138	286235	435550	770227	781570	954826	1338438	1424025	1875632	2130132	2475280	2565497	2992601	3178026	3486440	4228865	4793481	5162987	5847300	6614613	7681533	10585613	15870586	21302650	27573713	31119648	35383210	40079868	43385541	51428283	58305825	59700720	60292657\nT	16	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39\nT	16	3868	6933	109773	266786	288753	408937	511662	752268	928921	1281193	1524454	1650411	1752950	1910341	2353639	2890313	3156635	3545357	3863240	4094109	4659486	5610722	6305144	7070197	7992339	9767351	14702485	24271315	26221518	31444598	36752737	40385789	44227079	52265632	58662166	60425363\nT	17	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39\nT	17	2995	9794	37230	309704	402111	446228	868906	993120	1034156	1062412	1130739	1971360	2052171	2282409	2491442	2963359	3359432	3853187	4152790	4351606	4933314	6096621	6825072	7985534	9111026	12777293	17180632	23911258	28120093	33509238	36344678	41849793	44040503	51878539	59806498	60930624\nT	18	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39\nT	18	15236	140595	160057	467876	496491	554278	1000460	1041365	1170690	1257448	1741486	1890003	2291607	2858105	3106474	3903797	4358484	4582324	4892975	5382858	6544413	7728587	8630099	9291618	12607947	16070281	24427491	27075838	30507987	36603128	41997087	45067345	51441317	59948451	60852095\nT	19	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39\nT	19	3389	6271	153985	434443	583075	632790	703075	779762	1097833	1270044	1335674	1529383	2075965	2242002	2465625	2777838	3881762	4052327	4990149	5142536	5934668	6689027	7387539	8506363	10520588	12543663	15816400	22908020	26023316	32627839	34840336	41226608	46095212	51612380	59807589	60979007\nT	20	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nT	20	8556	14364	175039	178331	336256	633628	743050	779388	1438372	1639013	2092446	2236826	2431772	3014466	3248743	3528566	4319868	4724990	5114922	5782195	6276688	6959456	7826052	9606910	11649742	15271609	18055654	24836851	29816091	33516368	35302402	39657005	45128734	52264704	61008774\nT	21	4	5	6	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39\nT	21	3617	16876	64719	399301	714651	759153	944360	1124195	1532553	1924251	2299874	2852038	2975601	3128667	3497109	3802002	4237178	5145997	6178519	6918280	7206111	7815532	9478834	10884132	13476722	17602336	21496269	28116960	31560583	35470929	40151591	44304531	49352700	60850345	60987727\nT	22	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nT	22	3799	14251	49245	236758	437402	525591	852903	927615	1345153	1584338	1642855	1930475	2555221	3353254	3496347	3999107	4849110	5064381	5398904	6166967	6763145	7623818	8141847	10554974	11972937	14609854	18210659	26832694	30151545	33180775	37081377	41151959	46773003	52150373	61409192\nT	23	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nT	23	4015	13362	252580	265229	489808	597921	1009493	1046792	1257530	1669977	1785565	1976662	2290093	2527179	3496438	3859955	4133745	5176213	5895267	6651034	7446656	8575449	9354607	11693830	12853916	15467232	19737502	27582838	32865320	36429201	39212217	41868611	45899393	51166740	61250524\nT	24	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39\nT	24	4556	17608	52651	332936	565705	649669	1058472	1254616	1286244	1358268	2037939	2460203	2851387	3669160	4023959	4394376	4996087	5429390	6043955	6595007	7205831	9458895	10962214	12811574	14480883	16040720	21667445	26187295	31830421	34341048	38725781	42070918	46029476	50487278	61265325	61341980\nT	25	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39\nT	25	10338	68777	195084	456648	603689	919532	1042440	1471006	1638244	2009427	2875161	3038693	3602254	3964964	4622473	5066486	5888918	6570882	7293467	8357334	9451012	11365564	12623015	13660952	15727378	18223340	21313793	26952125	31325558	35840334	39502890	42169085	45745741	51710687	60831330	61597934\nT	26	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39\nT	26	25066	60738	438547	520834	676898	984176	1529946	1625368	1751107	2133674	2812522	3151602	3577507	4261622	5094974	5989017	6545501	8066031	8971249	9770970	11559696	13124743	14648020	15593259	17543212	19671540	23932214	27286115	31450471	35866549	39400786	43311873	46582559	51354210	60198407	61770922\nT	27	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39\nT	27	15990	66544	172633	569151	717356	1083719	1117908	1751757	2104074	2126192	2872499	3068064	3907892	4358870	5508190	6019919	7361175	7902894	8300612	10532647	11261845	13071305	14951089	15754261	16922148	20577699	25110091	28149607	34114685	37560743	38840264	43162958	46342275	53854435	60662195	62094777\nT	28	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nT	28	599383	1085229	1128260	2010868	2876888	4253359	5305339	6473915	6889221	7206829	8402740	9057341	9497714	10255398	11174018	12287781	13018243	14299699	16354277	17442441	19069185	20293102	21289531	22802505	24013383	25211215	28178675	31851400	37591767	45006274	49310313	51992651	54575687	57498751	60299493	61879182	62569436\nT	29	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nT	29	330998	1042912	2214903	2739644	4348112	5491502	6011022	6957661	7461472	8236062	9729992	10246221	10859432	11890505	12724926	13499985	14617463	16548576	17739575	18909456	20149613	21113857	22409807	23569350	25377684	26993235	31845795	37543114	43543863	50167038	52589528	54867571	57961530	60689117	62678359	62745544\nT	30	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nT	30	244449	1348235	2794666	3407398	4806820	6095878	7193457	7969106	8630513	9390367	10742495	11488108	12779118	13423320	14460913	15655688	16598413	18440912	19807644	21379780	22709055	24306525	25342356	26256416	27390431	28753470	34224064	40494643	46092033	53000965	54657182	56242016	58220532	61072372	62308962	62953280\nT	31	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nT	31	219395	409348	1430681	2409996	3188053	4378176	6236049	6649619	8313169	8628314	9522720	11253663	11737822	13052224	13808068	15092121	16606685	17376893	20174735	21396844	22210367	23477321	24178754	25488693	26686751	27929045	29820973	33743577	40732817	50144096	52812534	55051701	58254415	59628477	61009309	62610452	63196196\nT	32	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nT	32	230464	928459	2113338	3263382	4731148	6563665	7868501	8942538	9474386	9761771	11514224	13212357	13976310	15093592	15779131	16987047	19122033	21139882	22212511	23416101	24314731	25476334	26598051	27851692	30402432	33564737	37157697	44458770	50208327	53900482	56780255	58882198	60798116	62164674	63446300	63725230\nT	33	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nT	33	240910	325431	2660451	3856765	4893875	6828771	7811785	9570829	10303845	10744816	12500314	13897855	15064513	15968582	17102549	18247338	20458870	22096578	23319040	24061231	25134741	26783125	27908504	28548000	30524680	35028340	39321307	45829265	52984183	55763924	57767607	60373905	61834350	62403685	63150288	63785908\nT	34	1	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nT	34	267266	890952	2307041	3699479	6022601	6961352	9176412	9846782	10899204	11640703	12814312	13811100	15578913	16868454	18004071	19387690	21301857	23180864	23834861	24941583	26301008	27750479	28790819	30942894	32832896	37362358	41402280	46918845	52900984	55571258	57497196	60297464	61871756	63244331	63917779	63991547\nT	35	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	20	21	22	23	24	25	26	27	28	29	30	31	32	33	35\nT	35	104603	326719	437731	746239	885615	918582	938953	1009026	1067605	1298883	1578608	1784826	1976144	2191131	2432616	3017049	3433422	3833506	4021574	4797167	5253231	6418244	7074548	8891228	11666155	16663217	20629652	20634968	20654511	20675373\nG	0	3	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	40\nG	0	570	69727	77907	83795	263076	292068	348824	421167	507576	560617	607692	723597	841468	995459	1056818	1116347	1427103	1608601	1784860	1947816	2351684	2671128	3368625	4369990	7046147	18874849	24252871	27885280	28670629	31161421	34297421	35702629	42862138	44889076	52607439\nG	1	2	3	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	40\nG	1	2946	5171	7639	76577	90505	101468	287700	314997	381114	454942	560921	626974	684229	821797	937440	1103066	1165383	1232125	1599958	1816192	2018810	2222775	2680017	3028850	4032344	5634577	8915215	20129030	25631000	28738957	29468595	31799770	34956736	36347794	43005220	44952571	51403560\nG	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nG	2	1773	11642	75937	132673	150214	252900	261846	400941	441975	531577	592045	757417	811028	896872	970752	1065970	1175402	1412116	1563140	1890432	2119589	2370951	2921354	3546525	4586593	7455111	15226013	20591719	21168680	25016261	27677725	30672977	33497666	36846909	37168374	41217870	46109156\nG	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nG	3	3094	7588	15316	75402	127807	161992	274656	312159	399936	509236	596508	733824	801027	917935	1155403	1276939	1547972	1659724	1887642	1996054	2294184	2614924	3092504	3430008	5118229	7119986	12061219	17581273	23710633	25571803	27928126	28952778	33806746	37579760	40724314	42421104	46556221\nG	4	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nG	4	49835	53382	62506	90615	128699	219836	252868	350022	436717	474640	681720	760898	801879	965163	1068349	1195549	1442451	1674051	1838214	2150198	2279545	2565566	3152170	3533124	4184061	5799833	13214817	19904425	23611100	25280326	28034612	29234142	34007695	39806815	41252323	42235421	46906706\nG	5	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nG	5	6033	28902	86487	99190	105605	110917	139123	317336	360728	446922	536077	651345	710215	884315	1013803	1105704	1344737	1680772	1876723	2043028	2188299	2538788	2790015	2984740	3591931	4017676	6894150	10232630	18273589	22223978	24579927	27897240	29448090	32504448	39629247	40226179	42456216	46964634\nG	6	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nG	6	1317	26558	37034	41504	72962	143925	227117	240207	365482	431181	445793	611996	813581	1052964	1162617	1510886	1617286	1847306	2032736	2184930	2373110	2585077	3063822	3651500	4016469	4467972	7500079	13050828	16878188	22185015	24874380	29079552	30562678	32554652	39202681	40465726	42848276	46558177\nG	7	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nG	7	3614	5875	70974	106990	116499	194972	289495	359261	389898	499112	614969	672510	749300	982579	1037975	1238760	1372969	1520851	1762906	2011307	2348365	2781391	3257002	3776734	5222409	6118449	10130972	16277067	22420056	24016722	26853116	29557280	31291073	38310848	39163697	42333757	45415929\nG	8	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nG	8	31393	34209	97895	109095	114254	287992	459490	483212	570411	688164	776406	859490	938387	1146368	1344415	1452465	1607736	1811460	2017908	2160746	2304022	2745851	3184559	3706170	4239861	6108999	10359155	17843149	21604052	25213094	27847488	29929156	33596686	39017892	41183794	42538132	45461436\nG	9	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nG	9	45734	47153	59348	68747	209114	225784	376716	418100	505932	517668	733922	876364	1085532	1152256	1185924	1283902	1529426	1621205	1964011	2210986	2729725	3095386	3428782	3647387	4660053	8331335	11802356	18528898	20376471	23546937	28636637	29895479	31998112	39051813	40635234	43379667	45516900\nG	10	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nG	10	1514	6200	16900	78751	163760	228727	302533	396711	525160	578608	771495	922565	1002651	1043752	1299305	1477180	1708881	1857542	2138080	2343027	2516679	2982075	3585799	3898471	4328764	6347865	10694333	16256347	19500011	25180710	26583973	29471680	33158641	38649858	40566646	43475743	45524602\nG	11	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39\nG	11	16891	22733	33036	130508	137125	300861	374944	446660	671364	680433	761887	941098	1063161	1204099	1266631	1556973	2018705	2345697	2393698	2949906	3027891	3376959	3987712	4615835	5658348	7572704	13110226	16671936	21910935	25408331	27127908	29951198	33281268	38891888	40814553	44877254\nG	12	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nG	12	6060	9005	17847	96556	110009	225034	243699	372421	499931	532329	550430	648284	865374	1124779	1269347	1365387	1620642	1889567	2165393	2388684	2804823	3283772	3692582	4492032	5014618	5958597	10317548	17854619	20688152	24104878	27573419	28688139	32459917	37350381	41009831	43059239	44717101\nG	13	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nG	13	1557	64967	102591	110273	119267	275811	342463	421882	548996	599557	698443	1057749	1240580	1364091	1527401	1761652	1847435	1977032	2227972	2682906	3011110	3872804	4163375	4636395	5530482	7299723	11265335	19786332	22157545	25388845	26775315	29495961	31707034	39427294	42777185	44139394	44842883\nG	14	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39\nG	14	1450	35717	42116	130396	140752	280514	376951	470626	487619	511707	893720	1002312	1281775	1412636	1597654	1871373	2167104	2205593	2613042	2822925	3009890	3473254	4044185	4711698	5285115	6339358	12654475	16803275	20497870	23893978	27262417	29928153	31966035	37742733	42121150	45023889\nG	15	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nG	15	3476	10552	17251	146207	157510	183210	279182	522508	530892	669866	1007744	1063247	1399761	1623370	1862097	1944904	2274787	2409293	2624171	3265261	3706035	4000817	4543095	5185028	5976960	8592923	13327487	17199947	21996232	24895837	27799622	30689074	32841126	38531278	42871319	44365706	45019468\nG	16	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39\nG	16	3117	4724	63970	168042	179697	264602	329447	499645	623592	902641	1088348	1196874	1273467	1401463	1742562	2165522	2375156	2674552	2930650	3126626	3530875	4282972	4773613	5327367	6000612	7575147	12257443	19106127	20935285	25027044	28735728	30696463	33432541	38836395	42936191	44925766\nG	17	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39\nG	17	1677	6991	19298	192219	254800	286252	583696	677204	695838	714171	753338	1432737	1500737	1670886	1830769	2223110	2514432	2946018	3175700	3334951	3821830	4671098	5164865	6051619	6916253	9584561	12735152	18011965	22283258	25970283	27637340	30958103	32480698	38065962	43428612	44569330\nG	18	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39\nG	18	9705	90602	102013	303555	325605	353238	683550	704275	814069	866218	1238732	1338131	1683736	2130590	2304879	2970862	3365466	3493085	3744440	4135854	5045195	5872552	6515148	6987445	9784438	13090973	19025185	21480270	24840002	28502569	31439146	33433200	38001593	43970040	44720985\nG	19	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39\nG	19	1783	4361	97340	288128	385394	413471	456382	508035	733562	867021	902979	1066277	1489184	1601636	1773364	2009858	2911056	3032475	3744870	3849230	4426252	5002289	5521448	6397024	7698112	9180085	12840478	18650670	21082617	25450227	26701054	31023677	34210220	38008190	43649062	44548160\nG	20	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nG	20	6029	8702	112951	115506	218024	412468	486565	514059	1020579	1163712	1549676	1669866	1811174	2242861	2424837	2628840	3270854	3586908	3835580	4350279	4683520	5252901	5801018	6805880	8233511	11951732	14584763	19906543	23259813	25934721	27038618	29746351	33345218	38234441	44491658\nG	21	4	5	6	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39\nG	21	1941	10971	41625	263467	467876	496751	638076	761643	1057655	1392872	1673622	2101018	2186792	2302438	2583324	2791931	3161951	3840147	4645297	5185453	5399959	5864100	7021419	7892402	10226366	14697908	17987367	22489166	25485040	28124730	30302100	32793681	36293349	44457611	44565423\nG	22	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nG	22	2149	10781	38465	161849	291381	349763	559931	614973	919393	1092380	1136755	1360992	1882516	2493117	2610078	2988372	3645879	3811737	4041071	4587248	5047991	5562192	5921835	7408597	8667820	11137478	14123211	21247145	23866734	26532107	28418342	30711100	34313053	37864493	44517638\nG	23	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nG	23	2432	10270	174736	187020	333795	403044	680109	709350	860874	1161422	1248111	1399706	1651021	1823980	2561758	2860415	3028977	3844990	4404496	4906631	5501984	6343614	6864423	8249236	8935482	11204132	14956785	21548234	25274731	28039787	29826226	31202332	33504174	37235932	44506182\nG	24	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39\nG	24	2631	14854	44042	237652	394392	445938	719173	873339	901747	944540	1438842	1745412	2051508	2692338	2958266	3247297	3706122	3986558	4448789	4837347	5273120	6707501	7675821	8791839	9819601	11295945	15984681	19855848	24253375	26875610	29409997	31250112	34040665	36977839	44576130	44631090\nG	25	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39\nG	25	6646	56536	143155	340087	445559	655191	745874	1015387	1156039	1418500	2063726	2206869	2644117	2931696	3416243	3766513	4383860	4847634	5380339	6124584	6816099	8056438	8738201	9447736	11001101	12746104	15870025	20890847	24004213	27404059	30148310	31398551	33391419	37284205	44076047	44706789\nG	26	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39\nG	26	22194	51400	329303	395344	507217	709248	1072044	1130119	1244902	1522687	1987142	2215829	2516396	3086129	3707684	4302186	4697878	5704341	6373909	6825233	7733358	8563698	9429730	10021163	11487323	13610977	17046724	20544861	23716152	27370995	29760164	31721843	33668545	36734086	43178787	44421287\nG	27	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39\nG	27	16256	56484	135657	439378	543141	784481	811918	1232441	1460204	1481287	1996293	2156147	2765913	3108806	3884128	4319915	5197343	5590881	5853092	7057192	7411412	8452108	9548887	10101363	10917854	14393595	18727867	21729975	26495401	28381013	29176346	32022475	33986487	38559291	43229199	44354054\nG	28	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nG	28	424619	726687	765184	1402315	2041212	2990151	3665937	4480620	4789775	4994201	5799038	6285992	6575925	7135794	7684547	8480389	8812913	9619183	10712793	11453570	12143162	12812794	13302776	14299623	15139830	16349141	18902977	22776760	27300868	32446963	35789240	37643944	39266865	40984751	42649798	43576226	44076179\nG	29	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nG	29	178543	688954	1568565	1938776	3042639	3781975	4240990	4839189	5196897	5735662	6754029	7090721	7607118	8289126	8744827	9202463	10053386	11201803	11790512	12259940	13007824	13534604	14510360	15129587	16669533	17942356	22113727	27791002	32088649	37149073	38552902	39762399	41663557	42970169	44180960	44221049\nG	30	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nG	30	140136	866169	1872938	2295822	3224892	4079520	4771713	5320440	5776931	6252005	7196768	7591276	8483716	8734940	9482930	10076145	10648535	11531103	12105881	13102988	14040572	15040069	15781340	16474426	17417632	18583659	23495109	30430495	34779097	38888874	39731919	40534283	41646932	43020782	43602963	44045813\nG	31	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nG	31	131589	208237	899536	1680337	2217733	3036067	4232445	4544939	5596541	5830988	6334992	7481183	7811469	8658942	9155860	9661403	10521076	10894573	12369697	12856316	13236628	14198823	14422641	15492810	16426197	17521171	19551031	23596522	29330996	36436572	38233580	39590891	41502570	42136550	42841814	43729613	44131109\nG	32	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nG	32	133555	581027	1503894	2297358	3240845	4432105	5224431	5924009	6263675	6413598	7419983	8470169	8868277	9582705	9897636	10486707	11656900	12565608	13122614	13930694	14458200	15319218	16127673	17113077	19584672	22895829	25580794	31554919	36308506	38777373	40376910	41433296	42425990	42978442	43650693	43828598\nG	33	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nG	33	141191	220429	1827926	2617072	3203333	4577747	5142933	6247585	6672217	6875788	7749043	8809790	9291128	9915390	10341846	11007746	11873516	12978692	13831062	14266212	14955936	16178078	17239078	17658363	19250218	23759957	27132966	33832744	38288877	39943077	41069536	42074480	42777753	42993372	43378630	43763758\nG	34	1	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nG	34	154274	553766	1693581	2554976	4053057	4722947	5923357	6334629	7043562	7371703	7851132	8640295	9618193	10388540	10756785	11237642	12446262	13577005	14164518	14600381	15844815	16851526	17530804	19167875	20847076	25054242	29434954	34570272	38111842	39679250	40757334	42126753	42836318	43582107	43892237	43931079\nG	35	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	20	21	22	23	24	25	26	27	28	29	30	31	32	33	35\nG	35	96859	278036	368700	605850	695063	721986	744269	776633	820997	1009478	1145634	1326472	1475684	1630665	1811558	2230633	2567355	2822498	2919624	3567905	3894721	5147729	5596525	7619218	10177792	15376500	18472312	18473550	18479594	18486067\nC	0	3	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	40\nC	0	1564	86105	97486	101248	287452	317551	353770	423343	490309	566982	609858	736079	811040	904509	963475	1017189	1210347	1320677	1458752	1552890	1804109	1988164	2308228	2996886	4667952	12135811	15293287	18091471	18888099	20132114	22819424	24331331	29433538	30827446	32572273\nC	1	2	3	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	40\nC	1	4214	7744	9916	125722	149484	159022	423596	452675	518320	614048	738472	847454	910635	1097575	1232743	1376348	1473328	1579113	1938198	2125497	2368315	2533852	2923197	3251738	4072190	5405888	7603943	14648439	18703756	21502278	22464897	24296585	27676249	29893763	35818505	37183883	39083634\nC	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nC	2	2385	20627	122149	211008	224532	368762	386127	557276	603412	714413	786815	1056892	1122225	1230954	1302029	1372482	1505810	1777342	1950777	2258379	2540585	2905154	3507581	4111439	5412393	8073127	15964712	21375200	22303345	25806268	28338485	31605137	34548776	39321903	39816577	41500812	42942269\nC	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nC	3	3677	9424	21401	105030	188708	239021	364639	419440	529981	658402	794364	930752	1046262	1198190	1533041	1666338	2001908	2135150	2418452	2583319	2878156	3224621	3755574	4151692	5668679	7875954	12576047	18007392	24038361	26366271	28493268	30136688	34551532	39696192	41556107	42303148	43200474\nC	4	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nC	4	79191	82291	97895	147805	199214	323019	366981	487935	617640	665144	950351	1063047	1117270	1300820	1401248	1572869	1864531	2142043	2348854	2616488	2807087	3156754	3922021	4352606	4987291	6392156	13351438	19385616	23881676	25807802	28043562	29859244	34122143	40177681	41314861	41544028	42780766\nC	5	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nC	5	14878	62998	154319	179306	184701	194133	238607	460833	530125	649984	799075	935522	994217	1231842	1363123	1499045	1787706	2226836	2460297	2680405	2857248	3268888	3600622	3883820	4347804	4997074	7812375	11364818	19047892	23266131	26005957	29236183	31515448	34692365	42364581	43147470	43667180	44587620\nC	6	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nC	6	1147	50918	71351	84057	139480	235870	353764	376103	512500	601332	626331	836864	1115952	1399382	1554275	1987322	2118150	2440331	2652431	2836259	3077453	3302642	3623281	4274476	4674886	5342200	8428063	13660385	17450973	23142041	25887290	29283623	31139989	33853038	41060269	42191213	42803552	43549862\nC	7	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nC	7	4981	11068	118663	188287	195435	320405	455378	531899	574131	765413	906913	993686	1110185	1438482	1497340	1806541	2031646	2219784	2556416	2831356	3289809	3846901	4499937	5235241	6813625	8003203	12007234	18102020	24106124	25996954	28685365	31130421	33800707	42086320	43274484	43962554	44482488\nC	8	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nC	8	64969	68001	163708	177114	181479	413491	634108	675897	813121	962440	1066467	1182518	1263715	1591374	1833520	1996006	2247707	2523745	2800554	2963236	3159229	3672835	4062229	4669270	5400761	7491533	11158911	19104530	22886263	26199890	29109565	31405831	35742768	42471402	44074992	44378708	44742554\nC	9	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nC	9	95982	97188	124568	138124	332395	361714	536617	606505	704358	728932	1052994	1225939	1522148	1604212	1655431	1831141	2146423	2196553	2682204	3068505	3701559	4203447	4751828	5006705	6164083	9801895	13839908	19486879	21561235	25034391	29694222	31338590	34504954	42198461	43948705	44394482	44725995\nC	10	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nC	10	3658	11442	35738	156657	285268	365486	446052	616196	830792	894191	1098167	1322307	1453009	1518376	1818013	2114036	2426539	2597192	2992275	3262552	3513434	4155802	4802327	5207538	5789235	8181829	12522098	17307292	20642842	26515105	28292859	30908384	35417161	41774033	44107464	44459952	44772032\nC	11	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39\nC	11	40554	48938	75289	212947	219318	450512	566824	659944	920894	944158	1066586	1290265	1452475	1712653	1808635	2199389	2812008	3315987	3408909	4097938	4231093	4718624	5608428	6300800	7652900	9282552	15273777	18527432	23336852	27491516	29561900	32255403	36352545	42497061	44936826	45418314\nC	12	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nC	12	7827	12968	37855	189441	199167	364685	403576	560779	755640	810170	851072	936224	1276755	1661557	1829672	1943960	2269134	2618241	2938194	3253377	3863103	4520416	5096626	6057746	6770694	7970882	12497181	19682743	23137704	26892455	30018338	31102609	35335908	40519767	44547505	44715145	44916743\nC	13	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nC	13	3872	117337	187890	205804	219346	439196	556524	654969	786129	879526	1077873	1577653	1861801	2017337	2219650	2516351	2737090	2893742	3209950	3717313	4239263	5405691	5680752	6302203	7318874	9431519	13348452	21644753	23974553	27240783	29132603	31577389	34655150	42408026	45086004	45277001	45286644\nC	14	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39\nC	14	3275	76078	89344	237939	254555	446158	613430	737930	773907	807826	1315382	1455031	1747149	1888632	2097426	2509668	2944477	3015746	3516640	3765590	4000793	4742050	5499902	6238605	7070077	8334955	15108398	18352949	22437302	26140149	29265130	32220480	34610885	40699740	45200159	45436427\nC	15	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nC	15	5551	16120	34107	268597	291753	343221	490392	799663	819414	978488	1473416	1599990	2046161	2273660	2729388	2805346	3258796	3469279	3821386	4533309	5134871	5579045	6309375	7018775	8054067	11231813	15725010	19966041	23688619	26807912	29567937	32355340	34770567	40415838	45217803	45323730	45365422\nC	16	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39\nC	16	2890	6326	128741	284145	302990	457341	563746	797661	961929	1293738	1595041	1770578	1878400	2025209	2452811	3060831	3433163	3813808	4117126	4308684	4961416	5908207	6636817	7491049	8408876	10382792	15131643	21017789	22972119	27290406	30995024	33622509	35520798	40561429	45114251	45219952\nC	17	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39\nC	17	3259	8105	38871	317335	454991	486848	920885	1047159	1085557	1117699	1212217	2069620	2158079	2482146	2665681	3159036	3613804	4082722	4406780	4616429	5141431	6463202	7243949	8404733	9375005	12647911	16061099	20314493	24729381	28792718	30834379	33632912	34835030	40241359	45449979	45507048\nC	18	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39\nC	18	13049	180437	194723	519401	542009	645511	1034359	1069796	1244180	1357715	1834426	1990695	2442644	3116719	3331829	4188815	4641608	4963042	5338795	5831238	6931906	8045762	8955436	9473377	13124496	16175022	21511564	23527817	27121404	30418654	33718342	35467479	39446351	45278097	45383202\nC	19	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39\nC	19	3338	6783	199352	492562	669266	782309	840032	907827	1193686	1363829	1458236	1694296	2264270	2571717	2837198	3155547	4308314	4532639	5570352	5709810	6644929	7389730	8286092	9326923	10872791	12774966	15908723	21151457	23870889	28423475	29953754	33837495	36863121	39741629	45539618	45573845\nC	20	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nC	20	6824	12271	225825	229396	413653	752620	844628	873316	1430617	1713953	2192186	2358495	2557854	3201880	3538758	3793954	4737496	5184354	5826735	6515642	7085287	7799421	8586297	9932659	11925541	15774411	18306348	22856794	26134976	28946084	30164131	32647572	35569100	39757112	45673228\nC	21	4	5	6	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39\nC	21	3420	16618	74102	475068	779605	853673	1007342	1247731	1666992	2022129	2513201	3096190	3377243	3498814	3941285	4373538	4805231	5838665	6963224	7759225	8075398	8686489	10281412	11411957	13875273	18395383	20983365	24993542	28328985	30635808	33276893	35161842	37263749	45461017	45613286\nC	22	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nC	22	4038	13113	67481	294213	506918	627394	944063	1007775	1398776	1637726	1693446	1974374	2587446	3600124	3749800	4316950	5286285	5493960	5992351	6885112	7532671	8173581	8679012	10756153	11945589	14690736	18488293	24042405	26412592	29383960	31431933	33302825	36205438	38834220	45189760\nC	23	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nC	23	4184	14206	305589	323885	525827	741425	1080873	1113492	1321802	1718010	1849573	2058551	2545475	2874700	3886772	4274671	4729037	5846997	6528651	7480021	8193478	9236891	10162204	12117072	12882453	15740096	19473395	25093395	28781517	31286498	32420804	34005774	35686027	38412062	45708031\nC	24	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39\nC	24	5078	17486	74989	416428	613195	785324	1103521	1263053	1303227	1375501	2108730	2655036	3185764	3958331	4387689	4725244	5504638	6115656	6729806	7458413	8024493	9914486	11127683	12824597	14080435	16022939	20581396	23237956	27226346	29980524	31937178	33871342	36727340	38493973	45283089	45356350\nC	25	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39\nC	25	11675	93401	261634	545176	797799	1053169	1173257	1502302	1662738	2031674	2813825	2969631	3663263	4095490	4743879	5326333	6370500	7173562	7913310	8963228	9939591	11478400	12502080	13578018	15630053	17426112	20574867	24029682	26650945	29741192	32082380	33492536	35197924	38627950	44462866	45312660\nC	26	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39\nC	26	26065	68447	532940	610264	876258	1107023	1518349	1645640	1746052	2077625	2746416	3163077	3853347	4532571	5406808	6334817	7104363	8666651	9664846	10286949	11758922	13027125	14072531	14959935	17075691	18882481	22491781	24932325	27608067	30879738	32540423	34382290	36195960	38491530	44310856	45821889\nC	27	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39\nC	27	14236	73798	218389	643719	896123	1161961	1199060	1666347	2066023	2094732	2806762	3009613	3943859	4482059	5637974	6205013	7727897	8329699	8832319	10815567	11341572	12925496	14213409	14908988	15968783	19761953	22141979	25151728	29848722	31426252	32110889	34852899	36841601	40873179	44051049	45423455\nC	28	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nC	28	695320	1172443	1216909	2197494	2999000	4370710	5548231	6517219	6965737	7328934	8390261	9119847	9628547	10501525	11333819	12472229	13126089	14467193	16426443	17310320	18190757	19019987	19748627	21250463	22347340	23658855	26305475	30130990	34516424	37829854	40618416	42069236	43319048	44234795	44964340	45262178	45732556\nC	29	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nC	29	477156	1010328	2141429	2795204	4367644	5515177	6061777	6812073	7370177	8130337	9544160	10071248	10880052	11836301	12672389	13390587	14535055	16297887	17419371	18021786	19069022	19891768	21176390	22033660	23735678	25416201	29527776	33766767	37431097	41901075	42784742	43640885	44459992	44873765	45456747	45460934\nC	30	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nC	30	428571	1452929	2914169	3550624	5148466	6224197	7119701	7865383	8555950	9324111	10511982	11398899	12636723	13166099	14243488	15147445	16006680	17707767	18482163	19806238	21072470	22434338	23394942	24279969	25556376	26780424	32110132	37093895	40514906	43196236	43709478	44064642	44804687	45513452	45699958	46007039\nC	31	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nC	31	344736	583804	1441382	2250937	3147640	4501147	6149712	6515932	7847880	8224624	8971658	10667878	11323694	12513559	13259381	14274552	15491526	16085703	18379876	19201491	19813558	21155595	21510189	22958564	24236250	25674836	27781341	30973242	36232907	40943303	42375718	43284871	44392860	44611091	44805506	45135775	45406782\nC	32	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nC	32	373407	1014108	1943151	3175447	4803311	6261123	7283938	8386963	8917996	9218875	10726679	12493849	13126345	14164643	14650679	15652126	17283062	18988141	19691354	20704071	21578582	22691279	23885957	25187374	27634530	30964995	32609467	37376873	41098842	43145693	43961174	44481707	44911948	45065935	45318207	45388712\nC	33	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nC	33	407754	497036	2475414	3717617	4965728	6473889	7544928	8850240	9656003	10082795	11720245	13103342	14089394	14912852	15668453	16830182	18099428	19875051	21082382	21835486	22797541	24329126	25709359	26209498	28034606	32142905	34610677	39859086	43117717	44124311	44816801	45167391	45519726	45553134	45664294	45814998\nC	34	1	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nC	34	410072	872501	2023461	3458730	5451503	6449448	8257061	8868423	9854120	10505804	11402181	12565370	14142979	15227425	16001574	16790650	18518042	20418353	21203455	22020504	23565642	24893951	25891294	27653929	29177310	32980393	36512541	40664886	43005775	43952080	44619480	45059540	45254978	45536277	45611600	45616192\nC	35	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	20	21	22	23	24	25	26	27	28	29	30	31	32	33	35\nC	35	108010	416186	516829	974334	1135362	1168913	1191606	1247279	1316378	1590169	2036720	2269845	2484322	2831171	3106329	3914770	4396587	4903504	5099882	5915230	6428234	7405857	7912028	9863527	11705159	15742970	17787937	17788172	17792340	17796830\nN	0	3	20	22	23\nN	0	36101	126412	193785	248436\nN	1	3	6	20	22	23\nN	1	82227	82228	448228	575859	819912\nN	2	4	5	7	9	12	20	22	23\nN	2	4	88586	153369	153370	303764	569411	758264	1112235\nN	3	4	6	9	10	12	20	23	24\nN	3	14	15	16	174651	174652	435217	635703	1222506\nN	4	4	20	22	24	25	27\nN	4	1	282700	567878	1015511	1076257	1261501\nN	5	3	5	7	12	20	22	24\nN	5	44770	231655	443914	443916	541593	784231	1300627\nN	6	4	5	6	20	22	23	24	25	26\nN	6	1	43835	211028	438115	758082	813677	848887	1220704	1266756\nN	7	5	13	20	22	23	24	25\nN	7	1	164488	333431	587341	804706	1222898	1274105\nN	8	4	9	14	20	22	23	24	25	26\nN	8	4	5	164942	513964	560748	594623	717451	905698	1295311\nN	9	4	6	7	10	12	20	22	23	24	25\nN	9	36564	36565	36567	209513	209514	316454	575003	635893	885586	1330209\nN	10	4	6	11	12	22	23	24	26\nN	10	60	61	169761	207727	310595	372857	1309571	1347392\nN	11	22	24	25	26	28\nN	11	38591	147657	735530	967267	1391282\nN	12	4	6	7	10	15	20	22	23	24	26\nN	12	8	9	39514	39515	240544	283680	485876	783805	908383	1407855\nN	13	4	6	7	10	14	20	23	24	25	27\nN	13	149	150	151	68590	109870	152712	619700	1141489	1219109	1422114\nN	14	4	5	7	8	12	16	22	24	25	26\nN	14	4	40768	40769	100727	306281	508532	551637	894417	961516	1436230\nN	15	4	7	10	12	16	20	23	24	25	26\nN	15	2	40230	40231	245734	454250	491553	528400	613609	1002916	1447469\nN	16	5	8	9	22	24	25	26	28\nN	16	89	224399	261635	300445	644440	712516	1260429	1462792\nN	17	4	8	10	11	22	24	25	26	27\nN	17	5	47947	114639	558981	598081	856746	948581	986050	1512157\nN	18	5	6	7	16	17	22	23	26	27	28\nN	18	4	52290	52291	252893	318557	365334	622118	816370	1294390	1546905\nN	19	4	6	7	11	17	18	26	27\nN	19	3	51736	103990	352923	421472	618457	1015211	1584717\nN	20	4	5	6	8	18	22	26	27	28\nN	20	3	4	51841	51842	118502	165826	430051	635087	1623965\nN	21	4	5	8	9	12	13	14	19	26	27	28\nN	21	40	43	46003	46005	114397	153250	407481	601662	958324	1033580	1629582\nN	22	4	6	7	8	18	19	23	26	27	28	29	30\nN	22	9	10	42414	42415	300514	370915	409037	671311	762680	1367907	1443312	1632608\nN	23	4	6	11	15	17	19	25	27	29\nN	23	54	43418	43419	301921	369271	933235	969445	1359213	1628820\nN	24	4	7	9	15	22	25	27	28	29\nN	24	646	40400	40401	371152	561990	593645	852597	942217	1628257\nN	25	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	21	24	26	28	29	30\nN	25	2225	48554	48586	87467	87585	87600	87630	345997	346061	346094	346125	346137	346141	346143	346146	531655	1109151	1174551	1206583	1565727	1602155	1680633\nN	26	4	5	6	7	8	9	10	11	12	13	14	15	16	17	21	22	27	28	29	30\nN	26	17071	43304	91333	91347	91504	91506	91518	91589	91594	91626	91674	91685	155146	155154	340884	340885	372838	463859	764923	1681678\nN	27	4	5	6	7	8	9	10	11	12	13	14	15	16	18	19	23	29	30	31\nN	27	12891	45612	54249	93792	93932	93956	93967	93980	124675	124687	124729	124763	185942	621688	621689	1209251	1573250	1608132	1680334\nN	28	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17\nN	28	62574	93677	129465	375686	629825	792322	1054504	1090747	1090771	1682779	1682782	1682859	1682868	1682873	1682875	1682881\nN	29	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17\nN	29	95593	130452	192406	380877	737643	997478	1662694	1696138	1696259	1696267	1696360	1696398	1696400	1696405	1696406\nN	30	2	4	5	6	7	8	9	10	11	12	13	14	15	17\nN	30	96614	129362	665852	665878	767155	1718245	1718246	1718263	1718411	1718438	1718474	1718537	1718554	1718557\nN	31	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16\nN	31	77285	113152	153711	427789	427807	881914	1660270	1660271	1660317	1695787	1695823	1695935	1695937	1695944	1695952\nN	32	2	4	5	6	7	8	9	10	11	12	13	14	15	18\nN	32	65438	96972	156930	613891	996096	996188	1691882	1731113	1731116	1731250	1731374	1731397	1731398	1731399\nN	33	2	4	5	6	7	8	9	10	11	12	13	14	15	16	20\nN	33	61467	103919	209488	400956	999616	1641298	1751304	1751543	1751611	1751648	1751804	1751817	1751824	1751825	1751826\nN	34	1	4	5	6	7	8	9	10	11	12	13	14	15	16\nN	34	56761	96765	378930	614152	614459	1621437	1735724	1735900	1735942	1735965	1736033	1736119	1736135	1736142\nN	35	4	5	6	7	8	10	11	12	13	14	15	16\nN	35	41244	50645	50688	51037	51234	51239	51240	51282	51354	51471	51490	51492"
#define QUAL_DIST_TWO36 ".	0	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35\n.	0	24169	108679	230878	432989	531637	687985	724072	757448	827457	1045400	1182089	1284825	1364606	1444283	1592857	1765902	2020367	2511428	3007139	3455841	4698345	6564440	7237939	26839079	54160047	75144180	75682608	82040869	82063067	82204505	82254207\n.	1	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35\n.	1	111162	206396	401928	632112	775230	853716	922689	954291	1067517	1310598	1432631	1590962	1745214	1880401	2093889	2314970	2716675	3273191	3898551	4497929	5992606	8434082	9290540	29947207	59379370	77119851	77926714	81280341	82027873	82194240	82254207\n.	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\n.	2	12976	66551	160910	402216	526845	651279	912091	1052371	1148009	1323127	1468386	1674165	1875230	2001675	2192339	2437040	2693812	3268715	3772388	3972031	4333886	5529218	6153684	8515562	14752057	32486195	54232139	66366146	79355339	79987426	81665696	82033214	82254207\n.	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35\n.	3	13469	124341	166829	439437	629318	799195	916263	1135121	1188670	1305090	1493106	1620449	1810134	1943197	2113563	2611808	2831400	3088128	3246099	3789108	4284867	4919799	5423139	8301296	12027477	27259906	37416662	65154274	76635309	81159738	82211328	82254207\n.	4	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\n.	4	18413	119103	172027	400714	601464	696866	978707	1049357	1161901	1280982	1582298	1697490	1877462	2058806	2196321	2349214	2579799	3058686	3548292	4015411	4324787	4768266	6290874	6572668	7877618	10587330	32713611	55682918	75761283	77748332	81894831	82156164	82254207\n.	5	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\n.	5	79444	233846	417268	619233	737841	953680	1017326	1157088	1315626	1592687	1762868	1949894	2122275	2387556	2487561	2792698	2970933	3127888	3814639	4406980	5214711	5891668	6783493	7964924	14373178	22671461	37830939	69769878	76615133	79769657	81436359	82254207\n.	6	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	6	18015	116664	233005	462072	635341	767711	980887	1072217	1233950	1345988	1506390	1598351	1715668	1958442	2332179	2487525	2792790	3214496	3550084	3982704	4835344	5272845	6107562	6494369	7597463	11176905	18258760	41340798	61419214	77091256	81087366	81485951	81569592	82254207\n.	7	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	7	20766	125413	240076	317050	610271	817226	988104	1110064	1342941	1421886	1609200	1739281	2037327	2149681	2282486	2612341	2703663	3147229	3731656	4044568	4437812	5073673	5984077	7541826	8211639	10944101	23445660	47338273	55573879	70209462	75905381	80274229	82067732	82254207\n.	8	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	8	95717	293163	402842	654474	825574	936246	1177475	1336511	1506759	1666284	1765576	2106552	2280381	2396358	2623773	3067140	3330701	3979587	4349649	4759006	5222425	5942256	7057532	8098551	10399233	31896805	39474190	65750735	79466159	79926486	80513480	81642674	82254207\n.	9	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\n.	9	25303	146228	213085	492524	677382	915015	1133690	1229671	1278572	1505906	1669284	1778658	2175721	2304019	2457226	2600873	2975737	3049378	3562035	3732488	4363629	5523780	6051803	7150187	9107399	12416820	26138631	48433162	63409196	69841996	79349024	80037433	82254207\n.	10	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	10	157868	247216	404166	630598	894677	1190213	1233233	1323291	1494150	1763319	1976862	2202495	2371108	2494216	2676748	2915925	3083505	3400361	3949791	4458134	5015267	5563687	6816121	7505606	11974505	18487708	44901463	58096131	65248452	79587321	81227824	81936171	82254207\n.	11	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	11	140482	255046	447978	794073	927236	1151357	1228447	1447432	1540724	1686311	1877680	1981320	2160538	2481087	2928033	3243382	3344453	3784450	4388248	4726131	5912011	6293581	7569587	9966713	10666687	23071724	40228220	58898907	62653467	76592529	79954876	81395142	82254207\n.	12	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	12	29594	151807	253533	434120	725385	886899	1142063	1321157	1491486	1693096	1760286	2000530	2293932	2460974	2613061	2832562	3087560	3619223	3660831	4020623	4460642	5258206	6494733	7154985	8420270	10466990	16080246	43761317	62854964	75137602	78592064	79458546	81331130	82254207\n.	13	5	6	7	8	9	10	11	12	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\n.	13	155507	243271	433763	710830	1001241	1185428	1383891	1592266	1793328	1960958	2092389	2382270	2820555	3311873	3840226	4055707	4479282	4853250	5299968	5755816	7457889	8298631	8713805	9699407	20455530	42599813	54625500	65549937	79223281	81283619	82254207\n.	14	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\n.	14	196769	347000	526273	786089	1036883	1119133	1402643	1547917	1633334	1844291	2015321	2395125	2608762	2998443	3310931	3793085	4129217	4306971	4807966	5207071	6017695	6860125	8071291	9659676	12206502	21103482	42244615	59855521	74998641	81018772	81391178	81501707	81704403	82254207\n.	15	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	15	30699	167556	275517	574135	948316	1055878	1339706	1534305	1584439	1738914	2003070	2119245	2204524	2614378	2844458	3275775	3492937	3745456	4650882	5169186	5938712	6523858	7054549	8507740	10062778	15711390	23114158	35190499	53571289	63081271	72756505	78880489	81696656	82254207\n.	16	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	16	192813	319836	605387	868741	1098691	1245094	1474840	1687056	1802360	2051650	2273786	2660592	2826011	3060958	3257676	3754135	4104762	4830476	5154245	5692599	6656856	7089762	8081348	10119388	12342485	22822871	36124810	50190529	59630567	72232495	79719115	80290291	82254207\n.	17	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\n.	17	241422	344575	581096	844612	1244995	1382883	1600483	1809251	1930981	2085621	2453094	2525170	2806447	3210387	3705477	3885561	4686185	4829734	5256081	6172105	6950651	8355223	9097587	11331223	15176221	22704153	38792408	55598695	72549018	79130776	81282273	82254207\n.	18	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\n.	18	210314	396018	601516	943826	1184268	1348724	1614276	1780073	1979657	2143719	2560701	2661793	2992688	3289456	3463869	3954488	4373482	4781077	5614598	6715560	7508122	8087532	9170519	10684223	13829870	21094100	33961804	55027705	78018023	79965689	80021555	80110603	80854994	82254207\n.	19	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	38\n.	19	262240	437048	699727	1019085	1280168	1541539	1779027	1867710	2019172	2174968	2352527	2615837	3007423	3177592	3393278	4023401	4438772	4843733	5658279	6927402	7845133	7879020	8715234	10561514	14152439	28313659	44939505	58477674	72043453	79100550	81073371	81731138	82254207\n.	20	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	20	48937	231216	464105	749145	1125496	1389917	1645051	1792077	1924999	2119144	2527877	2756725	2874973	3120540	3572634	3952304	4144727	5057235	5254062	6129417	7157510	8213601	9318756	10308093	12518627	14894379	21127066	37259126	51308602	69579709	80270668	80711980	81680244	82254207\n.	21	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	21	158205	466081	712125	1041707	1411287	1746183	1843044	2053214	2183066	2353005	2861049	3153472	3393717	3832339	4263227	4933836	5287364	5582953	6402775	7274630	7440351	9383587	10351088	12228218	14458604	16527595	41940903	57564733	74043329	79301162	81452450	81547357	82254207\n.	22	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35\n.	22	314101	486124	725966	1128916	1399552	1662743	1919238	2197213	2380834	2654703	2957943	3268777	3783786	4057448	4392712	4734996	5134550	5791723	6389801	7537088	8375357	9145429	10815042	11512585	13903801	24513292	45862503	60333701	70468801	80543800	82254207\n.	23	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	23	333326	422576	755240	1130685	1634725	1951604	2140729	2261934	2468318	2527830	2896798	3394166	3703374	4014126	4471761	4996677	5446474	6625493	7243051	8187350	8911643	10250572	11784474	14286066	15439910	25012155	47589966	55368721	75895570	80631681	81690881	82061030	82254207\n.	24	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	24	355914	572708	910804	1348654	1586484	1905943	2184289	2221891	2531767	2792601	3206331	3578239	3860876	4110166	4477105	5254279	5966817	6649968	7511159	7936011	9847587	10680013	11757125	14705925	16551422	22311536	44143954	58321844	69114966	76791918	79648097	81107534	82254207\n.	25	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	25	336265	657786	1106342	1455198	1747027	1983304	2258154	2526086	2656731	3208931	3432018	3872686	4052736	4496715	4936262	5412758	6464130	6999206	7720316	8078309	10119282	11948884	13459263	15399047	15709489	21449571	40627094	57255182	67081036	79654788	81049271	81282535	82254207\n.	26	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\n.	26	440222	754104	1139007	1519099	1856617	2061884	2303670	2578151	2761252	3066140	3494372	4034386	4283688	4757480	5294256	5996326	6794987	7136230	8754199	9518310	10156697	12023108	13787306	16859376	20439328	26588388	50985460	60042847	75641824	78491983	80734009	82254207\n.	27	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\n.	27	460595	790774	1187659	1684127	1910595	2296456	2384782	2641362	3045258	3431057	3537337	3981044	4585282	5252872	5624064	6498536	7146372	7901193	8459810	9055974	10144555	12948069	14964914	16561586	21927003	31824757	52251541	73212210	78731563	80029516	81345217	82254207\n.	28	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	28	378372	589822	936744	1456436	1899051	2218289	2515314	2780399	3110349	3397134	3597820	4062658	4607924	5186799	5902030	6479413	6951580	8147981	8669784	9260899	10861946	13170537	15088880	21986800	26345438	37179663	48667117	61340596	69609334	79504575	81022906	81361539	82060409	82254207\n.	29	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\n.	29	424289	598001	1075364	1515826	1966625	2386692	2508081	2873839	3041296	3522944	3766959	4184502	4646184	5158678	5589731	6240511	7198350	8162508	8916908	9882179	11836798	13783295	16407843	20365022	27339330	28741620	43600789	52420315	72794120	79435316	80148796	80720392	82254207\n.	30	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\n.	30	424596	678738	1009539	1446001	2063336	2443942	2629525	3084175	3249003	3586529	3923607	4641299	5206178	5455207	6105041	6902242	7775501	8118474	8866613	9754554	11891272	14035150	16733705	19217651	23976411	31478048	46185354	62310923	73487259	75286695	81154262	81203992	81569124	81875524	82254207\n.	31	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\n.	31	457381	721303	1274279	1536780	2057651	2633467	2737032	2988566	3434905	3761197	4346218	4852491	5431449	5710778	6218717	7277405	8023699	9656622	10072031	10923882	12775568	14382558	17899613	22295698	25758923	34354671	50859121	65188076	74993006	78709049	81831991	81880143	82254207\n.	32	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	37\n.	32	475537	803128	1208643	1997279	2235961	2748523	2933803	3207009	3483350	3700102	4259195	5201958	5637587	6065826	7357349	7760815	8399391	9508367	10992237	12165245	13615518	15458679	17427395	21452156	29370835	31599823	50551091	66660228	78654974	81985146	82043679	82254207\n.	33	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\n.	33	258706	760018	1375197	1898890	2482822	2764444	3031447	3361484	3677812	4021833	4592232	5416907	5975270	6538797	7110517	8265958	8681435	9245658	11052310	12653039	13960418	17135940	21004174	25509434	32635167	36286657	55736526	62010533	73603922	80279757	81298775	81988013	82254207\n.	34	4	5	6	7	8	9	10	11	12	13	14	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	37\n.	34	521741	966705	1430778	2066308	2646121	2968833	3070745	3312901	3790911	4175095	5076887	6320064	6757566	7386132	8335543	9088965	10632369	11998013	13997628	15971987	18318998	21187888	27611868	39687269	47657070	62662405	78555700	80561161	81435106	81712453	82101367	82254207\n.	35	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	37\n.	35	553980	1072241	1667002	2548127	3088422	3126091	3170926	3638294	4009492	4300318	4871911	5515688	6113142	6876646	7675976	8200027	9679956	11255869	12372020	13097262	15717026	19429706	21177893	31639731	42191933	49808732	66573628	79194287	80703719	81464498	81761702	82082845	82254207\nA	0	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35\nA	0	4863	26982	57934	118410	151048	186336	198010	204496	225104	280533	311047	336808	363907	398659	441259	500982	588629	726011	900078	1020094	1296645	1730309	1922899	8043835	16313313	21919019	22095546	24312091	24320153	24369622	24389677\nA	1	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35\nA	1	27031	51013	101792	167112	212354	228744	248473	254911	289129	357429	395029	436709	484891	537526	595889	672128	817783	978594	1193144	1360381	1710632	2313366	2562020	8869072	17372876	22396832	22672873	23852592	24107974	24166058	24189487\nA	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nA	2	3218	16522	37592	96911	129970	157541	226145	261840	288703	346902	385905	440933	493001	532215	588330	673241	737154	928098	1083065	1135900	1252834	1635171	1783669	2338449	3985233	9362397	14994744	18559495	21896037	22079396	22561592	22677705	22750205\nA	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35\nA	3	3371	28489	38195	105785	154603	193277	220174	288360	299834	324912	377499	414865	462134	501395	554917	707795	767497	832884	863989	1037393	1188052	1386638	1530986	2330104	3394108	7020926	9539213	17547212	21150754	22249375	22588618	22603067\nA	4	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nA	4	3894	27486	39661	92494	144899	165873	240556	254991	292675	317375	401877	437061	489121	534980	573945	612875	693133	838142	988243	1129475	1206060	1340690	1780781	1866083	2210851	2838549	8305532	14875142	21439236	21993090	23058408	23147240	23181468\nA	5	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nA	5	18171	54048	97041	144062	169018	227190	241480	278578	324742	397012	434243	489539	529637	608875	634551	727572	785844	833016	1047256	1213344	1421862	1636310	1838124	2198291	3834721	6023476	9715002	18914582	21007517	21938271	22457368	22725329\nA	6	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	6	4825	26213	52410	106418	146189	180622	233656	260976	300742	331808	376064	404714	441471	501337	600902	642675	738606	840951	941250	1062845	1307881	1446598	1673792	1787616	2097530	3199488	5190261	10844787	16360426	21026799	22277424	22418209	22442837	22644920\nA	7	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	7	4279	28400	55095	71916	139116	196062	240771	268264	332671	356327	406212	446228	519990	551419	582878	680331	704470	831819	1006296	1107494	1209380	1378604	1594021	2049964	2241831	3080559	6263268	12445553	14793249	18958871	20671806	22118807	22630019	22683908\nA	8	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	8	19815	63817	90246	150331	185196	215614	276374	314530	356577	404937	430656	518040	555773	594153	647826	779546	844282	1032986	1131454	1237767	1380729	1574501	1876488	2137252	2820962	8345180	10183660	17782447	21588908	21702118	21849232	22197142	22388762\nA	9	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nA	9	5374	32989	48200	111963	157284	216142	267484	297706	308547	367305	409232	438967	543616	576111	620161	660516	776914	793589	935109	992250	1176414	1493859	1637150	1946927	2495391	3501977	7348276	13397332	17439346	19531253	22110674	22311730	22788295\nA	10	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	10	35329	56174	92979	141237	202975	277594	292506	315340	360061	425377	485513	545940	587284	626758	676284	754001	796203	869174	1036864	1185576	1321659	1468115	1799392	1973493	3218101	5323754	11970140	15116872	17215428	21892059	22360065	22568174	22681449\nA	11	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	11	31753	58420	102282	182183	211831	268289	289536	350931	371466	402600	455737	480434	521068	610880	740708	827334	850348	976976	1133337	1227693	1519759	1626785	1947413	2596507	2803214	6317944	10611638	15137728	16083833	20655470	21830135	22280851	22523241\nA	12	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	12	7622	33630	58298	95702	166835	201002	268148	308069	347278	402054	427114	488668	558922	604253	643460	688685	760334	913148	924412	1026246	1159307	1368454	1705360	1855703	2196611	2819865	4449034	11091876	16113938	20238268	21453124	21700377	22253051	22533984\nA	13	5	6	7	8	9	10	11	12	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nA	13	34977	54969	94936	157504	222401	273860	318988	370591	425545	467357	502489	572440	678329	817964	957801	1008204	1102594	1192163	1315389	1454374	1877408	2087777	2202930	2465583	5255022	10867073	13981524	16979629	21629986	22195881	22448644\nA	14	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nA	14	44609	79234	120884	180284	232266	253287	331347	366908	389672	443686	485338	576232	630875	722405	797094	920191	1009264	1070697	1194402	1306331	1533312	1762862	2092929	2475653	3201173	5493926	10730139	15572038	20154011	22029700	22157884	22193213	22233431	22406214\nA	15	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	15	7380	38360	62382	126176	216209	235340	311095	354419	363241	406433	474171	499286	514928	620735	677532	787641	837184	891831	1121234	1259378	1479891	1617200	1737148	2124631	2525168	3818282	5913623	9015923	13818916	16364221	19304873	21354224	22204656	22359530\nA	16	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	16	42815	71843	136779	194660	244101	281510	332442	391284	417396	477951	525956	626610	668654	725479	769337	887476	974636	1154338	1243014	1408099	1634815	1727384	1942731	2440407	3109179	5465759	8728040	12707688	15268740	19304804	21684641	21821231	22384626\nA	17	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nA	17	53116	77418	130234	185513	272474	300093	355145	409236	435511	477863	558881	577358	645549	738226	848680	894789	1117822	1142130	1243185	1460033	1653595	1996345	2152156	2704364	3876532	5667302	9644320	14082022	19042582	21305201	21957808	22264800\nA	18	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nA	18	48245	89841	137556	211583	261852	296499	366428	406723	454662	495857	594995	621116	695823	769871	816523	925320	1025932	1125098	1326528	1561210	1742280	1897699	2185605	2614164	3525168	5417374	8771962	13994488	20929666	21488977	21506848	21533121	21753655	22203460\nA	19	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	38\nA	19	59533	100402	157763	223476	283300	344562	407834	428110	468524	515357	552981	615679	700193	746396	799599	948883	1045819	1123288	1335610	1666643	1896899	1909232	2086179	2549124	3492315	7042029	10927156	14827629	18999159	21271153	21849891	22011386	22170499\nA	20	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	20	11972	53034	106312	167965	250566	306880	372580	405965	435593	492404	584367	635952	661608	722006	828597	916530	961165	1183206	1226264	1416648	1698911	1970561	2233082	2441047	3031728	3663175	5449980	9542123	12801757	18018110	21654072	21799975	22072476	22206263\nA	21	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	21	35768	103235	161438	230291	310871	390638	415015	466143	494811	537412	662812	725157	780034	866863	977932	1148915	1230311	1302386	1485321	1703098	1752407	2202047	2431810	2928856	3520927	4069423	10758915	14743478	19539325	21262545	21965695	21993634	22184846\nA	22	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35\nA	22	71759	109368	164814	256501	311083	374135	436828	504447	544428	611920	684633	758791	869301	934040	1017220	1107376	1193570	1358781	1503251	1799129	1992971	2163830	2599600	2774212	3437474	6643356	11547697	15271659	18313772	21697404	22222872\nA	23	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	23	76160	97436	172657	253592	363988	446835	484381	516048	567357	580728	669814	788052	858518	920514	1034640	1162029	1264920	1577202	1691725	1946686	2116497	2423141	2750986	3509344	3785765	6644819	12097857	14151192	20468071	21695208	21986462	22094094	22142677\nA	24	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	24	81453	130585	200474	299495	351321	423341	495416	506391	580655	644612	736287	822601	878467	935473	1027045	1223251	1379378	1542852	1746409	1837272	2285051	2479562	2738790	3487792	3959594	5653271	10864092	14924689	18230734	20629522	21399321	21855691	22220883\nA	25	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	25	69103	140993	240049	310918	376688	436310	502544	567834	593587	726335	780182	882454	916079	1020901	1126840	1231464	1493989	1626020	1787904	1855768	2336187	2763524	3139050	3616074	3675071	5227542	10107506	14647339	17823511	21469422	21902993	21972350	22214217\nA	26	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nA	26	90021	162253	245842	327603	410029	457149	517238	580143	621300	694368	797269	920980	974971	1089835	1208626	1371504	1571025	1645026	2042250	2198812	2357802	2798705	3281615	4074439	5088470	6901737	12870776	15567448	20405768	21208463	21730119	22188156\nA	27	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nA	27	94786	171058	257249	363606	418747	509115	535977	596847	696656	783677	809694	913086	1035365	1198326	1287728	1510451	1661977	1857604	1981495	2128708	2372384	3021062	3520275	3977234	5467769	8057508	13211371	19437590	21241671	21622820	22039997	22307051\nA	28	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	28	79747	125856	204808	318102	415115	492088	567908	629004	708229	779276	821612	920296	1055846	1183385	1354540	1486704	1595002	1889694	2021075	2148778	2503139	3053202	3515401	5465976	6896237	9664693	12374137	15971201	18411541	21423266	21903045	21990279	22189449	22237944\nA	29	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nA	29	87878	124735	230599	330975	424402	518873	554152	634649	680467	791182	838089	934133	1046797	1161050	1255664	1399403	1630628	1858744	2006651	2222084	2704167	3150110	3896312	4958586	6891601	7241527	11093348	13129946	19402767	21255799	21473459	21621375	22072622\nA	30	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nA	30	88185	142193	219667	314283	450359	540013	584188	692447	732202	814293	894109	1051364	1170023	1226901	1370425	1579768	1760766	1850733	2043389	2257639	2750553	3209198	3910170	4571966	5878039	8230583	11977160	15770675	19275907	19814715	21844603	21859204	21957055	22035929	22157419\nA	31	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nA	31	94823	153031	278558	334362	447080	583281	605494	666157	771176	850274	987786	1091374	1208291	1276249	1391923	1644284	1819461	2192639	2289266	2492955	2902937	3342542	4303395	5449371	6501586	9132405	12871315	16864574	20213771	21152608	22046445	22060605	22181403\nA	32	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	37\nA	32	99716	168344	267825	427507	483067	609350	650148	706653	772325	829852	963953	1167059	1248525	1353459	1646315	1731024	1890493	2153250	2484284	2751301	3126169	3573420	4088553	5162921	7461128	8074711	12798910	17330284	21090163	22111674	22131466	22204474\nA	33	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nA	33	56030	157522	301014	409594	541230	611184	675058	747905	824814	904182	1035163	1219485	1340450	1456594	1602224	1873550	1968912	2124134	2538795	2890701	3186237	3975071	5069831	6221136	8335103	9566387	14259696	15813962	19466699	21749900	21974524	22181911	22249374\nA	34	4	5	6	7	8	9	10	11	12	13	14	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	37\nA	34	108038	210315	313207	448469	576935	659601	686447	739381	853854	943210	1149810	1410016	1506084	1668951	1863863	2042872	2421338	2729499	3194536	3654285	4254881	4997303	7027120	10295297	12321355	15825655	20990921	21595868	21830297	21927879	22052780	22098795\nA	35	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	37\nA	35	115314	233372	369304	562906	686006	698156	708846	816403	906669	971315	1104359	1242892	1377068	1562344	1737511	1856788	2202467	2555237	2829241	3001712	3574495	4498152	4965876	8197819	10994699	12916925	17385821	21211642	21637876	21861985	21962359	22066764	22117890\nT	0	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35\nT	0	3581	24823	48982	96785	113952	165042	171196	176906	190654	230544	266180	288650	300151	311125	346754	383381	422769	557680	657232	728999	979970	1359541	1484588	6814071	14119348	19267252	19402214	21457779	21464426	21502345	21512621\nT	1	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35\nT	1	27777	54312	98871	158772	189856	217124	231026	237875	264055	319006	349035	389598	425456	449876	506629	556699	632711	785758	921454	1041662	1379558	1913702	2098888	7436601	14833133	19255412	19476121	20466320	20764549	20811464	20827076\nT	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nT	2	3312	17659	46126	109517	146119	181744	253254	290015	313705	359150	395752	456247	509926	545235	594506	647626	705955	850216	986391	1044063	1121273	1401559	1561755	2129084	3832737	8642441	13647751	17253734	20661048	20826236	21315884	21454713	21531159\nT	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35\nT	3	3474	34307	46954	120267	175942	224722	263154	316865	329309	362761	415169	450191	502745	539857	589116	721715	785244	858718	899534	1018790	1140626	1307385	1417953	2191530	3115322	6385629	8762680	15957904	19876063	20924718	21294147	21312339\nT	4	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nT	4	4942	33566	50782	116379	177641	206311	287009	309966	338223	374167	458498	485259	542725	590122	629613	675874	731861	871721	1006875	1124171	1214725	1340455	1718558	1785275	2081828	2717895	7735873	13762868	19651151	20299377	21290987	21395337	21435947\nT	5	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nT	5	21864	66712	118787	176417	212253	275396	294238	325134	369242	451165	492688	544801	600656	670749	698787	779468	819120	862519	1032374	1199136	1407836	1568950	1797989	2113274	3658677	5752552	8996087	16862183	19007564	19904687	20456729	20774922\nT	6	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	6	4722	32707	69210	139274	186874	223719	287627	309276	357030	389392	431307	450692	480842	557202	665074	710354	789320	912814	1001123	1112201	1329260	1432589	1652572	1755739	2039885	3020859	5002032	10306137	15576209	19675303	21130076	21227871	21255770	21570978\nT	7	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	7	5478	35098	70865	94951	180710	239421	284154	324608	384495	405631	459742	490672	580191	618511	654364	739928	767191	893719	1050326	1132296	1235696	1402001	1635732	2060901	2190889	2895702	6100461	11987397	14157870	17899944	19833939	21259137	21833917	21885319\nT	8	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	8	27824	88784	119032	195966	251107	280529	350596	398730	449875	489213	515527	620395	673669	706042	767427	889785	972907	1136857	1233903	1344121	1456845	1653848	1958621	2226902	2803601	8074919	9748871	17371084	20894504	21037435	21221080	21679970	21941724\nT	9	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nT	9	6677	40403	60311	141471	199830	263081	328810	352412	368641	424466	473087	501949	619982	650264	690169	728845	829434	853701	1007462	1045628	1195734	1491779	1620210	1919440	2394081	3334518	6931387	12593220	16417728	18167239	20804710	21130783	21629431\nT	10	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	10	43831	69929	112797	186884	262922	347259	358000	383437	427846	504918	564383	621670	669538	707100	759675	820723	866865	968680	1096185	1233336	1383564	1534705	1853834	2021074	3260456	5212249	11472653	14192739	16195978	20712400	21242231	21576443	21650063\nT	11	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	11	38074	71459	126202	230909	272505	335600	355929	414025	442151	486644	537168	564593	625312	714149	833849	918281	949258	1076135	1248615	1332511	1667850	1769933	2104698	2751702	2935569	6216891	10139752	14487765	15439926	19908509	21012825	21429289	21788985\nT	12	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	12	7725	42231	71698	124772	213149	260482	332792	386507	434472	491441	505573	571866	658428	709115	752272	807960	883188	1035385	1048751	1142916	1257406	1456617	1802312	1969849	2322653	2875932	4352752	10876604	15689890	19730400	20869835	21103057	21690772	22061695\nT	13	5	6	7	8	9	10	11	12	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nT	13	42228	67645	123757	210307	295054	343413	401903	457793	514620	557872	596750	679307	809675	942747	1104726	1165618	1289039	1384848	1511282	1617055	2089001	2320004	2445431	2687333	5299030	10769025	13612993	16672261	21041533	21718040	22015900\nT	14	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nT	14	53708	96367	148250	229143	303996	325622	402927	444735	466474	525051	568587	682682	744171	853276	941698	1086965	1174120	1215383	1364355	1460319	1668984	1896106	2230765	2648504	3325521	5529240	10469532	15198592	19588759	21441089	21544326	21595387	21640589	21881478\nT	15	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	15	8150	46399	75917	165752	275589	309357	384323	442090	454684	496221	566317	604134	626498	742270	808470	920344	984304	1054549	1307535	1455855	1651982	1826253	1987515	2381506	2835448	4102991	5950831	8834324	13445408	16021870	18574593	20627830	21643802	21910801\nT	16	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	16	52534	87087	168764	251068	320366	358367	425686	483005	511404	576682	642107	749487	795128	860337	918911	1063284	1158391	1354036	1445440	1582055	1836346	1947775	2225905	2771057	3369013	5561356	8552449	12436194	14879594	18561754	21063268	21219072	21908070\nT	17	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nT	17	65289	95363	159075	245111	358329	402218	456148	516244	545944	585009	681642	704054	791422	901116	1049250	1089673	1308952	1343343	1474946	1724689	1916317	2295134	2492132	3106149	4221581	5895553	9632559	13800873	18673287	20687083	21541742	21917362\nT	18	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nT	18	58993	109166	163688	271311	343923	396176	463677	504299	563423	603706	726446	752022	850190	931809	983306	1125532	1230534	1352706	1592979	1897414	2112664	2265412	2564733	2955301	3767577	5592475	8784223	13744501	20489864	21077835	21102651	21135389	21342138	21906496\nT	19	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	38\nT	19	70736	119303	190771	294879	369801	444987	507184	528024	566253	608720	660617	735312	853804	892233	954946	1125606	1256925	1373213	1601003	1921670	2173828	2187408	2398970	2873737	3794366	7176328	10841239	14473927	18616114	21025441	21539892	21738247	21879965\nT	20	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	20	12628	61541	125788	204081	322633	400599	473688	513359	547838	597467	710531	776461	813907	886165	1007602	1113451	1169356	1419880	1470398	1717571	1992688	2270791	2563725	2842742	3452495	4015950	5689760	9528502	12616368	17627591	21227701	21357626	21627468	21785672\nT	21	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	21	40770	126313	192246	299257	404827	500368	524919	581659	613904	657756	794713	879697	950375	1077592	1191029	1368120	1469616	1542633	1774520	2005960	2055400	2575603	2857016	3366747	3949317	4535086	10735254	14365796	18916514	20711608	21542817	21578034	21770464\nT	22	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35\nT	22	83713	131315	193316	323417	404411	475439	547487	615988	671082	749838	829464	920612	1057127	1139922	1235662	1321444	1423558	1614429	1780289	2069544	2318021	2552989	2984341	3181313	3797889	6814549	11598033	15072776	18046718	21246627	21824148\nT	23	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	23	88326	112708	214029	321580	468605	550318	602884	636326	688761	706256	809215	946571	1028771	1113356	1232558	1379085	1505755	1806884	1992656	2250625	2428115	2812002	3234984	3954077	4223705	6769934	11847812	14041373	19954473	21159869	21527899	21639118	21690997\nT	24	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	24	94603	151852	253444	386281	454740	543920	616007	623196	706227	774152	887016	1001740	1075886	1140369	1240705	1447987	1652697	1834699	2061755	2173201	2721316	2939493	3236804	3969596	4496217	5947120	10751531	14612055	17695826	19979689	20763680	21302551	21696508\nT	25	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	25	78908	161578	292280	399007	485229	550499	624190	693919	731042	878920	937129	1066033	1126319	1249030	1368306	1495785	1785769	1923804	2113302	2221468	2792585	3324396	3670040	4229369	4314235	5698175	10059257	14329570	17367928	20746428	21198905	21284314	21619483\nT	26	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nT	26	103271	186769	294664	413327	508540	567128	629819	699150	753114	826511	946470	1094847	1169429	1306123	1445327	1644504	1855481	1955789	2395030	2606561	2769784	3287244	3745410	4521216	5483396	7087189	12545029	15156969	19639880	20408123	20911607	21527924\nT	27	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nT	27	109034	197149	308793	462401	525777	633082	653845	718693	824714	925766	956838	1085808	1261809	1438832	1542456	1774365	1953220	2131777	2288884	2449287	2751559	3511816	4056039	4519739	5875157	8345773	12854841	18544119	20345547	20747816	21213178	21527570\nT	28	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	28	90774	143727	238655	390985	524298	609885	686316	757363	843418	912639	972369	1099525	1249962	1409085	1603396	1760661	1879853	2213037	2360061	2512959	2931029	3567453	4105047	5897983	7243215	9667402	12142617	15552410	17823391	20689334	21185707	21337032	21528618	21580820\nT	29	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nT	29	102902	143056	275311	407136	539513	651947	682522	780450	815817	944147	1015444	1127414	1264503	1400177	1511390	1688355	1939888	2214672	2407952	2678178	3198516	3731795	4468954	5553565	7413791	7774383	11205579	13039232	18932118	20670525	20890621	21111707	21573391\nT	30	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nT	30	102316	167895	254854	381567	559000	664894	713835	831695	875643	963027	1046858	1251972	1405294	1473315	1653191	1859020	2097574	2182990	2384007	2594730	3171540	3763923	4475654	5112350	6357987	8514864	11755892	15227438	18592780	19177787	21041744	21064751	21184134	21319612	21486046\nT	31	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nT	31	111244	176643	320988	407819	560941	714279	743429	805763	924512	1003281	1163182	1305939	1472318	1543318	1684692	1956347	2143994	2604029	2726626	2942588	3443729	3865139	4744833	5963679	6890715	9401796	12572785	16226122	19394478	20323649	21284495	21306695	21469837\nT	32	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	37\nT	32	115357	198934	299121	538667	607149	740875	788381	863644	932530	979955	1135250	1388907	1510221	1622386	1951448	2065835	2227907	2525851	2896655	3222903	3601493	4098823	4646881	5744174	7877992	8519568	12725068	16566705	20288192	21365921	21388549	21445280\nT	33	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nT	33	65163	185893	345115	508980	670238	745449	814416	897020	980901	1065147	1219654	1444059	1593258	1746322	1890318	2201029	2315924	2459250	2923385	3351564	3699097	4539555	5575321	6726528	8710102	9862700	13756484	15228545	18842903	20848736	21069712	21330535	21446792\nT	34	4	5	6	7	8	9	10	11	12	13	14	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	37\nT	34	126366	235034	358483	550469	712628	801562	827363	889259	1009162	1108127	1354083	1699767	1820562	1985239	2232993	2438599	2841544	3206244	3746423	4280023	4902981	5588996	7356156	10220850	12282138	15408134	20239357	20842298	21150110	21230914	21400480	21456086\nT	35	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	37\nT	35	134037	263393	414604	671514	827063	836558	849093	963890	1058887	1131787	1292841	1470249	1626338	1829441	2047464	2177571	2580051	3002423	3284626	3491583	4197506	5222292	5647432	8514945	10919004	12809683	16786209	20500920	20881885	21102526	21195777	21336244	21397973\nG	0	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35\nG	0	9249	28173	59812	105861	132183	165678	174763	189908	208872	260096	290823	321969	347793	369041	408768	451203	533249	654209	784297	951195	1429763	2066804	2260876	6272622	12131697	17225514	17360173	18368882	18373045	18400468	18410442\nG	1	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35\nG	1	26517	47518	95931	147828	183155	201944	221404	234316	263009	319470	348143	393975	434943	472232	529863	584468	701384	845995	1011284	1215203	1764790	2540648	2780168	7456945	14335820	18709978	18894466	19476357	19574700	19607516	19620317\nG	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nG	2	3106	14774	32625	89815	117105	149010	211069	251040	271387	308866	347778	387500	445692	476340	522207	589990	684991	831100	951067	999969	1101651	1420182	1632490	2353985	3994252	7707003	13419746	15855741	19026245	19165941	19517357	19576005	19619937\nG	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35\nG	3	3198	26694	35423	100075	138975	185271	210995	258017	272095	306839	353985	381934	434755	463768	496057	627022	680059	746478	807953	963246	1099881	1253888	1412790	2157081	3184190	7537800	10391527	16706476	18838814	20050217	20236661	20241456\nG	4	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nG	4	4421	24750	35290	88686	130600	154233	219096	236716	260047	293529	357199	386535	423738	476363	507888	542496	599820	713264	823020	945982	1038643	1146975	1566145	1640039	2036633	2847640	9131626	14459757	18324734	18766041	19791767	19830721	19845549\nG	5	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nG	5	16302	50849	93039	140518	170373	215973	232549	269272	304846	360317	410440	455846	493298	555430	582653	660466	705295	740690	914425	1062444	1291464	1455614	1750993	2029694	3812766	5912409	10135519	17204480	18567896	19274507	19650950	19772205\nG	6	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	6	4162	24280	47130	96709	141372	173300	216754	240491	279556	304441	337025	356689	387937	439995	526193	567733	644245	761418	848981	960533	1192208	1311123	1537165	1626557	1933709	2735635	4329451	10665943	15325949	18541803	19290556	19378730	19395244	19491876\nG	7	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	7	5127	26009	48973	64691	133346	176086	218128	243156	297478	316249	352140	380526	451119	471391	514177	588822	608084	716247	850106	921340	1038728	1208099	1493517	1848973	2029671	2690128	5958894	11926278	13663647	16697165	17804459	18569260	18936737	18988223\nG	8	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	8	20351	62000	87320	141254	179904	206180	260774	299062	331782	369090	391556	468453	513818	538157	601837	706379	775508	941654	1038691	1142179	1268008	1449323	1729921	2029228	2569123	8086415	10090650	15694129	18610740	18705777	18836063	19011763	19092621\nG	9	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nG	9	6482	32039	45969	109278	148440	201417	255156	274713	284067	341295	377296	405295	485615	521725	565400	598012	682892	699703	821691	870378	1045153	1346633	1485291	1755784	2268880	3003012	6233719	11710628	15119572	16260531	18408678	18502644	19171742\nG	10	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	10	35232	55636	90461	141005	205567	271785	281229	299249	342518	402378	452940	511940	552833	578503	618075	675161	712694	790897	932485	1050775	1212074	1338159	1692060	1884063	2878755	4162604	11309208	14763041	16315624	18814359	19159390	19256750	19327875\nG	11	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	11	30969	55746	97745	177342	205501	256310	276680	322531	345199	379390	422983	450416	486665	564715	668269	740074	766272	875193	1017449	1107630	1411060	1500484	1837310	2430887	2593884	5574004	10093393	14885290	15806294	18161934	18686504	18997358	19151640\nG	12	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	12	7131	33481	55477	98130	159734	197408	252820	295770	336335	383022	397449	443224	514006	549872	582486	647493	703235	823357	830707	929989	1028616	1236211	1529148	1722753	2003442	2462142	3789303	11071227	15596744	17666566	18205047	18415612	18813323	18966390\nG	13	5	6	7	8	9	10	11	12	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nG	13	35163	53841	98976	157556	226183	263131	309875	363612	404159	443013	471757	534223	635342	754841	873031	924946	1028837	1126322	1223400	1333612	1747341	1967304	2057405	2284562	5035967	10464952	13602716	16155094	18354065	18803622	18996159\nG	14	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nG	14	43970	77863	118126	172514	232835	247815	309022	342962	366592	415311	455340	535029	580429	674187	749365	857120	945195	989729	1103481	1196807	1403199	1601944	1859997	2285375	2864514	5216816	10704933	14638620	17713553	18809279	18884909	18898643	18969708	19042903\nG	15	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	15	7021	36323	61634	131783	208189	236305	297630	343977	361012	393913	453486	476256	502720	597326	645560	751042	801355	870171	1096063	1210052	1405517	1540719	1667792	1992527	2312240	3890982	5718320	8794086	13168427	15377889	17358039	18450411	18976283	19059030\nG	16	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	16	44088	73525	134713	192150	244663	279961	329696	375846	406357	461586	514110	598242	634454	694726	740631	851493	923312	1104905	1177534	1306239	1560864	1692078	1947768	2413134	2880303	5819624	9372514	12504398	14796521	17183612	18550197	18667172	19056357\nG	17	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nG	17	55626	78105	131230	189624	275329	309048	360924	403709	436801	475776	557797	574854	631533	722589	829184	874339	1055747	1100785	1189049	1405642	1608195	1938601	2116587	2617218	3412379	5498824	9568098	13887683	17372418	18444069	18880507	19021932\nG	18	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nG	18	44777	89010	134974	207141	261681	300289	358208	399301	439836	477012	569871	587888	662160	728774	766670	869825	978781	1072380	1252752	1520304	1728315	1851977	2115728	2439953	3154828	4886950	8162019	13723724	18232845	18637506	18646103	18660605	18796691	19071486\nG	19	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	38\nG	19	59965	98403	159497	229173	284432	338329	392003	417242	448553	481555	521000	581098	669825	709346	757918	890319	978702	1072685	1269757	1561614	1787751	1791518	2014102	2500599	3357288	7095221	11571698	14656468	17219082	18457121	18891052	19021640	19118710\nG	20	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	20	12316	53904	108177	172874	248194	308065	363715	399080	431906	474894	567517	619852	641452	693968	802433	884183	924193	1134840	1190032	1397130	1625029	1901014	2160431	2379996	2862200	3496011	4923307	9073510	12876995	17043645	18783046	18859318	19081223	19202457\nG	21	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	21	39796	107088	161626	232026	308921	388905	408483	453399	486872	528446	630970	698069	750325	845515	944193	1090723	1165289	1245476	1436909	1634779	1667976	2121514	2327680	2757292	3269629	3683399	10118118	14345829	17714514	18620368	19017868	19032941	19200116\nG	22	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35\nG	22	71962	110471	166935	247386	305866	360457	419563	488676	524738	585441	644934	710522	823541	884643	954978	1027671	1124989	1273349	1414829	1682612	1855578	2008385	2360728	2521443	3093035	5397524	11180668	14935066	17060085	18747530	19153392\nG	23	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	23	77327	96434	166805	250416	354688	425087	472368	499136	545793	558351	636527	745757	812803	882547	980482	1094760	1180753	1442824	1566737	1777935	1955723	2243193	2599303	3146760	3443880	5662399	11792490	13628749	17711924	18958506	19143270	19203557	19253921\nG	24	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	24	82903	134219	207605	302677	350330	420702	480808	489866	561180	620313	704540	787013	853712	913283	988068	1165118	1322139	1483232	1666378	1762320	2162276	2344480	2615395	3350787	3719808	5114345	11066545	14234103	16433440	17904387	18650023	18968900	19264131\nG	25	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	25	71132	143927	242020	317523	375243	427359	489068	554338	584572	705111	755635	859259	886942	983130	1077226	1179507	1415847	1549117	1727271	1800467	2240116	2614061	2985259	3396846	3484111	5044079	10202351	14093192	16067860	18866318	19112948	19149467	19340313\nG	26	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nG	26	91633	163771	247337	327886	392416	440007	494637	563148	599921	671176	765101	875113	922758	1017145	1139727	1285061	1473331	1550392	1879046	2068723	2228217	2653542	3030165	3784367	4622644	6080997	12597204	14535509	17695023	18412195	19022909	19354398\nG	27	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nG	27	96710	172754	259084	363850	404567	495077	513217	576031	658713	747836	770173	867258	995290	1134825	1221034	1415895	1568972	1727858	1847885	1963774	2226604	2870656	3294610	3633764	4927636	7356396	12979333	17566325	18583158	18849706	19154865	19323814\nG	28	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	28	77799	124478	203607	312552	409143	474230	540450	603097	676894	743155	782527	889116	1003229	1120850	1269222	1387337	1502105	1749646	1865219	1994436	2394190	2862622	3297920	4846362	5770829	8722588	11853348	14844526	16684894	18734999	19080996	19149545	19312725	19361161\nG	29	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nG	29	91950	131255	240357	330751	427845	517439	544943	630943	668438	778602	823128	918755	1013171	1130146	1229377	1352808	1569943	1766028	1935157	2152784	2580888	3026783	3620255	4459651	6105821	6417893	10440679	12971735	17027946	18832538	18980472	19103586	19471470\nG	30	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nG	30	90394	146118	224009	317845	443792	527743	573120	678908	712261	790103	867217	1021274	1145020	1203107	1334160	1503216	1690490	1768781	1940753	2150880	2623934	3103919	3701831	4275905	5360792	7040154	11197724	15644568	17867860	18280310	19289313	19297377	19392494	19456362	19510854\nG	31	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nG	31	100990	159591	286918	338981	450204	576153	598074	659911	760329	836316	965208	1076737	1191409	1254046	1365146	1610111	1747363	2106356	2188175	2396501	2804854	3168538	3996216	4954700	5744161	7649056	12597549	16038045	17745079	18765558	19440529	19448310	19502201\nG	32	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	37\nG	32	104835	178622	270457	445823	494434	602700	645604	708392	777297	824328	953056	1153972	1244960	1340248	1636397	1713450	1850207	2118498	2431232	2683086	3028172	3406174	3814680	4692440	6534830	6975781	12107895	16375821	18728384	19457428	19465119	19496177\nG	33	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nG	33	58151	170123	311877	425636	539950	605395	665353	744239	818480	896780	1028152	1202135	1313116	1442399	1559076	1816293	1901353	2032638	2412816	2796839	3056130	3779728	4636058	5691875	7315238	8054350	13800985	15463751	17809770	19024433	19320873	19455627	19514412\nG	34	4	5	6	7	8	9	10	11	12	13	14	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	37\nG	34	115041	218218	323255	458484	577223	650506	671892	732517	838610	931079	1135574	1388507	1482671	1622837	1827512	1973869	2327357	2600042	3078581	3507278	4057788	4818187	6305837	9523383	11273845	15672188	18780870	19251724	19466487	19504515	19560973	19583541\nG	35	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	37\nG	35	123396	241973	376935	571665	681166	688768	699166	812323	889984	959414	1083396	1231310	1360407	1525236	1697842	1798661	2121453	2450300	2714775	2847977	3459542	4276557	4714586	7136767	9992211	11876539	16157218	18980820	19332877	19483462	19526171	19571456	19597631\nC	0	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35\nC	0	3857	26056	61335	109118	131639	167708	176882	182917	199429	270768	310442	333770	349060	361763	392337	426595	471979	569777	661781	751802	988216	1404035	1565825	5704800	11591938	16728644	16820924	17898366	17901692	17928319	17937716\nC	1	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35\nC	1	28700	52410	104117	157183	188648	204486	220368	225771	249807	313141	338816	369063	398271	419114	459836	500003	563125	661168	770993	879007	1135950	1664690	1847788	6182913	12835865	16755953	16881578	17483396	17578974	17607526	17615651\nC	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nC	2	3340	17596	43257	104660	132338	161671	220084	247838	272576	306507	337249	387702	424824	446098	485488	524375	563904	657493	750057	790289	856318	1070496	1173960	1692234	2938025	6772544	12168088	14695366	17770199	17914043	18269053	18322981	18351096\nC	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35\nC	3	3426	33435	44772	111815	158303	194430	220231	270085	285638	308784	344602	371589	408617	436288	471547	553347	596671	648110	672685	767741	854370	969950	1059472	1620643	2331919	6313613	8721304	14940744	16767740	17933490	18089964	18095407\nC	4	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nC	4	5156	32045	44967	101822	146991	169116	230503	246141	269413	294341	362983	386894	420095	455558	483086	516157	553173	633746	728341	813970	863546	938333	1223577	1279458	1546493	2181433	7538767	12583338	16344349	16688011	17751856	17781053	17789430\nC	5	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nC	5	21843	60894	107052	156887	184848	233518	247456	282410	315102	382388	423692	457903	496837	550654	569722	623322	658804	689793	818711	930183	1091676	1228921	1394514	1621792	3065141	4981151	8982458	16786760	18030283	18650319	18869439	18979878\nC	6	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	6	4306	32130	62843	118258	159493	188657	241206	259830	294896	318591	360195	384457	403619	458067	538142	564895	618751	697444	756861	845256	1004126	1080666	1242164	1322588	1524470	2219054	3735147	9522062	14154761	17845482	18387441	18459272	18473872	18544564\nC	7	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	7	5882	34546	63705	84051	155658	204216	243501	272253	326514	341896	389227	419976	484128	506417	529124	601298	621956	703479	822963	881473	952043	1083004	1258842	1580023	1747283	2275747	5121072	10977080	12957148	16651517	17593212	18325060	18665094	18694792\nC	8	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	8	26304	77040	104722	165401	207845	232401	287991	322382	366573	401092	425885	497659	535111	555996	604673	689400	735972	866058	943569	1032907	1114811	1262552	1490470	1703137	2203515	7388259	9448977	14901043	18369975	18479124	18605073	18751767	18829068\nC	9	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nC	9	6770	39301	57014	128215	170231	232778	280395	302995	315472	370882	407611	430389	524395	553806	579383	611366	684363	700251	795637	822096	944192	1189373	1307016	1525900	1946911	2575177	5623113	10729846	14430414	15880837	18022826	18090140	18662603\nC	10	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	10	42014	63922	106363	159906	221647	291781	299704	323393	361781	428665	472045	520959	559420	579822	620677	664002	705705	769570	882217	986396	1095919	1220657	1468784	1624925	2615142	3787050	10147411	14021428	15519371	18166452	18464087	18532753	18592769\nC	11	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	11	38195	67846	120170	202060	235820	289330	304474	358022	379985	415636	459751	483836	525400	589250	683111	755583	776465	854035	986736	1056186	1311231	1394268	1678055	2185506	2331909	4960774	9381326	14386013	15321303	17864505	18423301	18685533	18788230\nC	12	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	12	7116	40866	66365	113818	183969	226309	286482	328713	371303	414391	427962	494532	560298	595451	632560	686141	738494	845021	854649	919160	1013001	1194612	1455601	1604368	1895252	2306739	3486845	10719298	15452080	17500056	18061746	18237188	18571672	18689826\nC	13	5	6	7	8	9	10	11	12	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nC	13	41515	65111	114380	183749	255889	303187	351028	398173	446869	490489	519166	594027	694915	793998	902342	954613	1056486	1147591	1247571	1348449	1741813	1921220	2005713	2259603	4863185	10496437	13425941	15740627	18195371	18563750	18791178\nC	14	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nC	14	52836	91801	137266	202401	266039	290662	357327	391183	408467	458033	503846	598863	650968	746251	820432	926463	998292	1028816	1143382	1241268	1409854	1596867	1885254	2247798	2812948	4861154	10337665	14443925	17539972	18736358	18801713	18812118	18858329	18921266\nC	15	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	15	8148	44881	73917	148745	246650	273197	344979	391734	403417	440262	506932	537364	558173	651776	710620	814448	867794	926604	1123745	1241596	1399017	1537381	1659789	2006771	2387617	3896830	5529079	8543861	13136233	15314986	17516695	18445719	18869610	18922541\nC	16	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	16	51631	85535	163280	229012	287710	323405	384877	434660	464942	533077	589211	683810	725332	777967	826329	949412	1045953	1214724	1285784	1393733	1622358	1720052	1962471	2492317	2981517	5973659	9469334	12539776	14683239	17179852	18418536	18580343	18902681\nC	17	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nC	17	65700	91903	158760	222567	337066	369439	426181	477858	510521	544769	652457	666587	735559	846052	975959	1024356	1201259	1241071	1346496	1579336	1770139	2122738	2334307	2901087	3663324	5640069	9945026	13825712	17458326	18692018	18899811	19047708\nC	18	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nC	18	56522	106224	163512	252005	315026	353566	423769	467556	519450	564858	667046	698424	782128	856609	894953	1031393	1135817	1228473	1439919	1734212	1922443	2070024	2302033	2672385	3379877	5194881	8241180	13562572	18363228	18758951	18763533	18779068	18960090	19070345\nC	19	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	38\nC	19	70344	117187	189938	269799	340877	411603	469817	492145	533653	567063	615612	681416	781228	827244	878417	1056194	1154927	1272148	1449510	1775076	1984256	1988463	2213584	2635655	3506071	6997682	11597013	14517251	17206699	18344436	18790137	18957466	19082634\nC	20	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	20	12021	61090	122071	202459	302337	372607	433029	471510	507499	552216	663170	722168	755698	816051	931649	1035787	1087644	1316937	1364996	1595696	1838510	2068863	2359146	2641936	3169832	3716871	5061647	9112619	13011110	16887991	18603477	18692689	18896705	19057443\nC	21	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	21	41871	127726	195083	278401	384936	464255	492610	549996	585462	627249	770288	848235	910644	1040026	1147703	1323707	1419777	1490087	1703652	1928420	1962195	2482050	2732209	3172950	3716358	4237314	10326243	14107257	17870603	18704268	18923697	18940375	19096408\nC	22	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35\nC	22	84727	132965	198896	299596	376176	450696	512945	585687	638095	704931	796339	876231	1031196	1096216	1182224	1275877	1389805	1542512	1688780	1983151	2206135	2417573	2867721	3032965	3572751	5655211	11533453	15051548	17045574	18849587	19051143\nC	23	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	23	89800	114181	199920	303268	445318	527127	578859	608187	664170	680185	778872	911365	1000854	1095281	1221638	1358359	1492602	1796136	1989486	2209657	2408861	2769789	3196754	3673438	3984113	5932556	11849360	13544960	17758655	18815651	19030803	19121814	19164165\nC	24	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	24	95255	154352	247485	358405	428297	515905	589877	600257	681424	751243	876158	964486	1050412	1118642	1218888	1415499	1610176	1786758	2034190	2160791	2676517	2914051	3163709	3895323	4373376	5594373	11459359	14548570	16752539	18275893	18832646	18977965	19070258\nC	25	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	25	79673	161739	282426	378115	460151	519092	592088	659480	696985	847799	908281	1014075	1072529	1192745	1312946	1455054	1717567	1849307	2040881	2149648	2699436	3195945	3613956	4105800	4185114	5428817	10207022	14134123	15770779	18521662	18783467	18825446	19029236\nC	26	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nC	26	105801	191707	301552	400584	495857	547483	611633	685208	736292	823426	934628	1092479	1165558	1293352	1449523	1644183	1844074	1933947	2386793	2593134	2749814	3232537	3679036	4428274	5193738	6467385	12921371	14731841	17850073	18412122	19018294	19132649\nC	27	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nC	27	110511	200147	312859	444435	511656	608831	631351	699141	814376	922867	949677	1063871	1241731	1429780	1521699	1746666	1911044	2132793	2290385	2463044	2742847	3493374	4042829	4379688	5605280	8013919	13154835	17613015	18510026	18758013	18886016	19044611\nC	28	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	28	91905	145806	239700	384740	500323	591399	669715	739880	830622	910769	969952	1102302	1247370	1421929	1623277	1793115	1923024	2244008	2371833	2553126	2981988	3635660	4118911	5724878	6383556	9073379	12245414	14920858	16637907	18605375	18801557	18833082	18978016	19022681\nC	29	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nC	29	103161	149259	279301	397161	524908	648091	675940	777017	825730	957941	1039186	1152992	1270448	1415958	1541943	1748563	2006505	2271676	2515760	2777745	3301839	3823219	4370934	5341832	6876729	7256429	10809795	13228014	17379901	18625066	18752856	18832336	19085336\nC	30	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nC	30	106577	172357	260805	382100	559793	660489	707214	829634	877376	967453	1063683	1264855	1433956	1499983	1695327	1908291	2174722	2264017	2446509	2699350	3293290	3906155	4594095	5205475	6327638	7640492	11202623	15616287	17698757	17961928	18926647	18930705	18983486	19011666	19047933\nC	31	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nC	31	110685	180821	336576	404379	547998	707710	737944	804325	926328	1018631	1177205	1325593	1506513	1584213	1723979	2013671	2259875	2700590	2814956	3038830	3571040	3953331	4802161	5874940	6569453	8118406	12764464	16006327	17586670	18414226	19007514	19011525	19047758\nC	32	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	37\nC	32	115935	205917	319890	533734	599746	743340	797303	875837	948506	1013258	1154045	1438975	1580833	1696652	2070072	2197380	2377655	2657636	3126933	3454822	3806551	4327129	4824148	5799488	7443752	7976630	12866085	16334285	18495102	18996990	19005412	19055143\nC	33	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nC	33	65366	195971	366536	503895	680459	750881	824834	920330	1001532	1103564	1256884	1498752	1675955	1840977	2006356	2322537	2442697	2577081	3124756	3561377	3966396	4789028	5670406	6817337	8222166	8750662	13866803	15451717	17431992	18604130	18881108	18967382	18991071\nC	34	4	5	6	7	8	9	10	11	12	13	14	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	37\nC	34	125703	244918	377599	550536	720754	797968	825649	892145	1029602	1132772	1377368	1761607	1888063	2048874	2350938	2573386	2981889	3401987	3917847	4470160	5043107	5723161	6862514	9587498	11719491	15696187	18484311	18811030	18927971	18988904	19026893	19055544\nC	35	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	37\nC	35	134761	275460	448012	683463	835118	843540	854598	986132	1094376	1178073	1331425	1511259	1689244	1899481	2132979	2306822	2715791	3187714	3483183	3695795	4425288	5372510	5789804	7730005	10225824	12145390	16184185	18440710	18790886	18956330	19017200	19048186	19080518\nN	0	5	6	7	10	13	14	15	16	17	19	20	22\nN	0	2619	2645	2815	3221	3398	3459	3597	3628	3695	3739	3741	3751\nN	1	5	6	7	10	13	14	15	16	17	19	22\nN	1	1137	1143	1217	1418	1517	1552	1608	1617	1653	1672	1676\nN	2	6	7	10	11	13	15	16	18	23\nN	2	1310	1313	1539	1638	1702	1783	1787	1808	1810\nN	3	5	6	7	10	11	14	15	16	17	18	19	21\nN	3	1416	1485	1495	1709	1794	1851	1870	1883	1889	1926	1929	1938\nN	4	5	6	7	10	13	14	16	18	19	21\nN	4	1256	1327	1333	1543	1570	1741	1783	1789	1812	1813\nN	5	5	6	7	10	12	14	17	18	20	23\nN	5	1264	1343	1349	1603	1694	1805	1847	1848	1870	1873\nN	6	5	6	7	10	12	13	14	17	18	21\nN	6	1334	1412	1413	1644	1726	1756	1799	1841	1868	1869\nN	7	5	6	7	10	11	14	16	17	19	21\nN	7	1360	1438	1441	1550	1783	1879	1899	1943	1962	1965\nN	8	5	6	11	12	13	16	17	20	21\nN	8	1423	1522	1740	1807	1952	2005	2010	2030	2032\nN	9	5	6	7	10	13	14	16	19	22\nN	9	1496	1591	1597	1845	1958	2058	2113	2134	2136\nN	10	5	6	7	10	12	13	14	16	17	19	20	22	24\nN	10	1462	1555	1566	1794	1872	1944	1981	1986	2033	2037	2038	2040	2051\nN	11	5	6	7	10	12	14	17	19	20	22\nN	11	1491	1575	1579	1828	1923	2041	2093	2096	2110	2111\nN	12	5	6	7	10	11	13	15	16	17	20	21\nN	12	1599	1695	1698	1821	2098	2188	2240	2278	2283	2309	2312\nN	13	5	6	7	10	11	14	15	17	18	19	20\nN	13	1624	1705	1714	1837	2097	2135	2227	2273	2294	2323	2326\nN	14	5	6	7	11	12	14	16	18	19	20\nN	14	1646	1735	1747	2020	2129	2210	2319	2324	2342	2346\nN	15	5	6	7	11	14	15	17	18	19	21	22\nN	15	1593	1667	1679	2085	2164	2205	2271	2276	2300	2301	2305\nN	16	5	6	7	11	12	14	15	16	18	19	20	22\nN	16	1745	1846	1851	2139	2261	2354	2402	2443	2449	2468	2470	2473\nN	17	5	6	7	10	12	15	17	18	21\nN	17	1691	1786	1797	2085	2204	2317	2384	2404	2405\nN	18	5	7	10	13	15	17	18	19	20	22\nN	18	1777	1786	2194	2286	2343	2387	2393	2417	2418	2420\nN	19	5	6	7	10	11	14	15	16	17	19	20\nN	19	1662	1753	1758	2058	2189	2273	2317	2332	2373	2398	2399\nN	20	5	6	7	10	11	14	16	17	18	20	21\nN	20	1647	1757	1766	2039	2163	2292	2308	2350	2353	2369	2372\nN	21	6	7	10	14	15	16	17	18	19	20	23\nN	21	1719	1732	2017	2142	2266	2314	2339	2343	2370	2371	2373\nN	22	5	6	8	11	13	14	16	18	19	22\nN	22	1940	2005	2016	2415	2491	2573	2621	2627	2628	2652\nN	23	5	6	7	9	10	14	15	16	17	19	20	22\nN	23	1713	1817	1829	2126	2237	2310	2370	2421	2428	2443	2444	2447\nN	24	5	7	10	11	13	15	16	20	21\nN	24	1700	1796	2075	2181	2281	2330	2399	2424	2427\nN	25	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21\nN	25	37449	49549	49567	49635	49716	50044	50264	50515	50545	50766	50791	50865	50867	50909	50944	50948	50958\nN	26	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	23\nN	26	49496	49604	49612	49699	49775	50117	50343	50502	50625	50659	50904	50967	50972	51025	51053	51074	51076	51080\nN	27	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	22\nN	27	49554	49666	49674	49835	49848	50351	50392	50650	50799	50911	50955	51021	51087	51109	51147	51159	51161\nN	28	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	23	26\nN	28	38147	49955	49974	50057	50172	50687	50925	51055	51186	51295	51360	51419	51517	51550	51595	51596	51600	51601\nN	29	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21\nN	29	38398	49696	49796	49803	49957	50342	50524	50780	50844	51072	51112	51208	51265	51347	51357	51382	51386	51388\nN	30	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22\nN	30	37124	50175	50204	50206	50392	50803	51168	51491	51521	51653	51740	51834	51885	51901	51938	51947	51949	51953	51955\nN	31	4	5	6	8	9	10	11	12	13	14	15	16	17	18	19	20	21\nN	31	39639	51217	51239	51428	52044	52091	52410	52560	52695	52837	52848	52918	52952	52977	52992	53006	53008\nN	32	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22\nN	32	39694	51311	51350	51548	51565	52258	52367	52483	52692	52709	52891	53045	53048	53081	53117	53126	53129	53132	53133\nN	33	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	21	22\nN	33	13996	50509	50655	50785	50945	51535	51786	51990	52085	52160	52379	52476	52491	52505	52543	52549	52555	52558\nN	34	4	5	6	7	8	9	10	11	12	13	14	16	17	18	19	20	21\nN	34	46593	58220	58234	58350	58581	59196	59394	59599	59683	59907	60052	60167	60186	60231	60237	60239	60241\nN	35	4	5	6	7	8	10	11	12	13	14	15	16	17	18	19	20	21\nN	35	46472	58043	58147	58579	59069	59223	59546	59576	59729	59890	59978	60085	60144	60180	60185	60194	60195"
#define QUAL_DIST_ONE44 ".	0	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\n.	0	142168	225190	337248	610393	758015	1064016	1194136	1310320	1440508	1659231	1819983	1843960	1929737	2089621	2249375	2392228	2597911	2896726	3140627	3330665	3567790	3869834	4058388	4251364	4695430	4912779	5379557	23180714	33282826	43682286	62663081	71719322	72048535	72127610	72288600\n.	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\n.	1	170677	245417	372718	714926	906886	1271619	1427209	1564995	1728437	2007629	2214348	2239113	2339784	2532352	2739004	2920811	3174907	3556322	3828401	4064056	4342746	4732156	4975598	5183750	5726032	5970872	6493324	24360145	34528136	44950402	63235495	71660972	72021461	72094599	72288600\n.	2	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\n.	2	164482	310532	403909	811100	1051481	1256636	1422962	1607552	1839071	2069130	2279158	2540292	2692966	2919090	3158147	3397725	3666839	3889799	4200199	4369603	4542486	4927429	5085220	5428802	5868577	6230007	6546678	25386259	33725812	43968487	62769037	71948498	72001007	72208817	72288600\n.	3	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	35	36\n.	3	109602	193666	292747	710329	1056750	1255110	1483556	1719570	1900230	2106843	2287163	2464136	2739696	2869633	3136112	3272642	3417986	3677264	3916284	4307612	4750491	5011385	5145475	5294632	5568679	5888269	6104682	15412438	33683424	43941089	62814126	71920315	72109174	72288600\n.	4	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	33	34	35	36\n.	4	213457	333136	541765	899561	1146729	1362090	1459269	1689492	1932022	2071331	2311108	2543898	2765890	2842197	3060207	3428012	3599101	3863987	4051668	4444653	4769210	4775527	5197350	5769235	6063348	6587567	7146466	7830679	25338880	45623082	71827829	71946509	72166569	72288600\n.	5	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	5	152351	311256	476281	762664	1082805	1306645	1583452	1837584	1988943	2226238	2415568	2515969	2720493	3039476	3148655	3252732	3593198	4005419	4258467	4703697	4864384	5234981	5697804	5993395	6159255	7019071	7946301	8380021	36028698	47029895	47542875	48274747	71232942	71900623	72122210	72288600\n.	6	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	37\n.	6	199552	249243	390542	769412	1044756	1243586	1476174	1809881	1919319	2065265	2326277	2477270	2513416	2828274	3166123	3431362	3674323	3932906	4299514	4562619	4883448	5301986	5723570	6012942	6908768	7179681	7704926	8766752	10491251	37631059	48462889	57245714	64892214	72117413	72288600\n.	7	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	7	82916	267207	410974	807309	1080162	1252867	1542750	1779391	1908663	2066926	2270339	2460232	2670779	2898542	3179776	3401798	3578946	3838318	4186972	4438123	4856538	5247421	5795024	5995515	6103062	6751359	7316180	7738241	17052529	35800917	47070497	47398145	55851804	71873593	72001369	72288600\n.	8	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	37\n.	8	170199	184673	327632	747295	1154959	1259692	1503205	1874274	1963960	2205255	2401262	2682474	2757969	3046305	3573333	3641475	4012052	4176404	4796997	4922705	5272679	5461806	6122049	6462806	6959180	7999535	8555156	8862553	10245334	37503788	48652253	50057234	63628464	72127809	72288600\n.	9	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	9	88401	140265	507798	751552	1191518	1346420	1577178	1941314	2122605	2307275	2414882	2606317	2905155	3031172	3518093	3608216	3980733	4150248	4436677	4932501	5242173	5391713	5898349	6269989	6728528	7282040	7525618	8595713	9352907	36500775	46749895	48493540	55711595	70437142	70690556	72288600\n.	10	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	10	96899	367013	539201	762304	1190208	1489655	1586473	2024602	2049347	2156659	2692805	2738090	2900653	3204356	3348114	3516259	3891649	4213405	4572629	4992793	5390300	5636163	6224414	6472624	6856975	7189361	8194690	8930943	9817351	20753266	30085058	49190559	62475771	70996024	71122794	72288600\n.	11	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	11	220459	258058	410074	758059	1291843	1541229	1667008	1976191	2249249	2398029	2574526	2896930	3062185	3400946	3537193	3739810	4154972	4679404	5064076	5334616	5641259	5974780	6649109	7219752	7537968	7899095	8571779	9272718	10388504	20833897	37529801	48965447	54963395	63370850	69081603	72288600\n.	12	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	12	160697	370838	453687	956309	1315942	1737890	1978212	2077617	2501938	2590534	2677863	3109191	3372906	3596824	3926247	4091358	4267563	4587899	5205503	5625993	6240467	6654016	7003590	7614726	8448846	8910336	9381571	9995464	11495692	12707636	40161367	50728120	53457060	63977118	70938310	72288600\n.	13	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	13	209354	307640	602872	954311	1129143	1595891	1836523	2131336	2482326	2633245	2838430	3158708	3251491	3622054	3761956	4011200	4209348	4531892	4776209	5424935	5941127	6688185	7345053	8084865	9315258	9976365	10868696	11801119	13663909	14279614	32801116	50625582	58401525	63819458	70836903	72288600\n.	14	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\n.	14	181516	233674	571809	872167	1275647	1593373	1904403	2111839	2231581	2805258	2979825	3041047	3206442	3575307	4193830	4287213	4580468	4659449	5351761	6201158	6416938	7001044	7714835	8345164	9244613	10037452	10640734	12477039	14932044	16915618	35063380	45680097	54946355	63622420	69646545	71509151	72288600\n.	15	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\n.	15	58525	174520	417612	982062	1531392	1725989	1856527	2032110	2291686	2743118	3141311	3242722	3485245	3802190	4221392	4429067	4745605	5173765	5828921	6281132	7458398	7899539	8224380	9316101	10151470	10964699	11578216	12826968	13797942	15317851	43527192	53811290	63214589	66248158	72019389	72288600\n.	16	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\n.	16	88210	110220	239443	414987	1164303	1254280	1986584	2096767	2280894	2734550	2934060	3263216	3571939	3739106	4031815	4397938	4905682	5348389	5767067	5914544	6716513	7427261	8301942	8716281	9173822	10047917	10544237	13474020	15143397	17614363	35438716	45101021	57025063	61535433	62893788	69243483	72288600\n.	17	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\n.	17	169638	251301	822901	1290855	1568090	2124424	2374566	2516522	2579952	3169292	3502865	3687451	3882450	4509814	4643047	4878910	5484718	5745495	6019661	6448311	7100214	8773654	9316043	10090494	11273568	12394245	14576040	16645980	21130237	31102647	41413584	58383591	62800244	67397068	69782718	72288600\n.	18	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\n.	18	237515	295077	786543	1236362	1948010	2048438	2268701	2807150	3037668	3072469	3351980	4140134	4223013	4357275	4674056	5022055	5475050	6329970	6694431	7429623	8017359	8432325	9620848	11032417	12233677	15195772	15736877	17207520	19889314	25293954	42537976	51723197	62521363	67084292	71902302	72288600\n.	19	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\n.	19	176829	234472	297919	654763	1040426	1907055	1968450	2116650	2820126	2953853	3126547	3191807	4214143	4354626	4458998	5109232	5392818	5749618	6223630	6921708	7477100	8296696	9630706	9720624	10950402	12575337	14210880	16111622	18371838	21864651	23632274	39515667	50608539	60930838	65473093	69361401	72288600\n.	20	4	5	6	7	8	9	10	11	12	13	14	15	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\n.	20	67116	377523	1002306	1327424	1921144	2382197	3051545	3092425	3178351	3634316	4336264	4651673	5278993	5600419	6319068	6575941	7040405	7593038	8715931	9449042	10238433	10976435	13158359	13696722	14988191	17329758	21623863	24328030	34525232	56380677	60852342	66790998	71469816	72288600\n.	21	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\n.	21	76929	178693	339866	658312	1240903	1877420	2309354	2457376	3098077	3524389	3619731	3775375	4664793	4805104	5257780	5352945	6340386	6524485	6846125	7580670	8142377	8691199	9461039	10810885	11972261	13133792	14865698	16466443	18837921	21657968	31963172	43472536	56158457	63980550	68672748	71606924	72288600\n.	22	2	4	5	6	7	8	9	10	11	12	13	14	15	16	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\n.	22	72697	178125	631489	1044213	1612136	2336965	2503423	2884772	3539315	3798168	3925174	4071376	5127654	5553329	6050135	6709684	7049799	8293479	8590853	9032230	10057688	10650213	12203079	13489991	14544172	16495522	20162184	21667963	25851511	43295764	58500315	62832754	68380973	71289270	72288600\n.	23	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\n.	23	93559	250745	475398	1357492	1759268	2438947	2685164	2911378	3522922	4044018	4291955	4468586	4643106	5516181	6177796	6436265	6972041	7156264	8202898	8703075	9451574	10813000	12175426	13560467	15821268	17486638	20013359	22669611	24711131	29080287	44985655	59101839	62818695	67272863	69470782	72288600\n.	24	2	4	5	6	7	8	9	10	11	12	13	14	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\n.	24	146520	274292	718355	1222726	1753814	2168374	2841669	2874101	3186435	4177990	4455680	4757139	5457716	6190388	6785841	7298444	7927453	8612864	9303367	10435068	11484789	12812371	15009173	15817021	17188557	19941830	22620418	25858946	29488754	44200561	55041589	62214764	66621789	70963485	72288600\n.	25	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\n.	25	126273	263230	906645	1453894	1996847	2680908	2965828	3245342	3702010	4670241	4752512	4982445	5331265	5800152	6704270	7298067	7543258	8441890	9317892	10227699	11482677	12331050	13282320	14660079	15989273	17683785	19398477	23271556	27962232	39048798	43409559	58620389	66447121	69068413	72050308	72288600\n.	26	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\n.	26	74738	184346	722630	1645558	2107053	2636018	3316245	3546866	3997291	4182300	5045724	5335901	5602483	6022406	7812903	7867267	8312382	9265595	10121336	11649746	12487180	13302697	15253456	16653698	18374375	19594063	22100504	25168186	28493011	37075747	48289106	58028199	65280333	70344299	71771028	72288600\n.	27	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\n.	27	73566	236501	661424	1576604	2144762	2702771	3445031	3566685	3938021	4855925	5486920	5661763	6007727	6930628	7235703	8574443	9072961	9619599	10250526	11258291	12083146	14088514	15742007	17238630	19481654	22376584	25415558	30295232	33440006	36415553	44931225	58560011	65380526	67667488	71409410	72288600\n.	28	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39\n.	28	74843	197850	396847	1437284	1746988	2749812	3405703	3867382	4279172	4865781	5424375	6297436	6574763	6959384	7880961	9270188	9685955	10092421	11813926	12968134	14082754	15407523	17433562	18513801	20545885	22991562	26286723	30396925	33270311	35539387	45240806	57277404	60422707	66843739	69398074	70969356	71810215	72288600\n.	29	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\n.	29	128590	431014	1526788	2104283	2715602	3717706	4099119	4605089	4800638	5394052	6810210	6935592	7524372	7981724	9384870	10574290	11025271	12416647	13558093	14733464	16739286	18031843	19759209	22055696	24549427	27615582	31399996	35246057	39468842	47380334	56752687	63574464	67360815	71132920	72037299	72288600\n.	30	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\n.	30	76946	124219	560883	1589102	2121559	2997759	3531504	4490286	4748249	5046222	5830467	7217026	7605516	7878164	8361654	9564992	11656454	12068621	13300385	14001757	14946041	16820676	18723212	19970471	23844044	26222344	29857987	34070519	38339134	39335601	51170202	62502165	67112074	68836675	69826086	71873130	72288600\n.	31	2	4	5	6	7	8	9	10	11	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\n.	31	131080	407552	1521996	2252436	2786878	3785349	4436348	5011539	5563387	7025761	8066230	8516577	8930900	9984649	11378832	12956108	13400572	15159924	16208416	18369256	20664037	22722377	24168125	27180622	29649709	33438781	37642067	42825384	54097123	58231050	65082300	67536318	69807957	71852923	72288600\n.	32	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\n.	32	126580	438469	1330390	2282639	2784770	3495330	4368973	5314628	5720032	6230965	6840181	8597751	9118343	9349837	10315834	11472366	12191356	14645676	15739850	17343526	19418095	20301050	22644896	25782938	28071988	31070327	33794191	37723578	41456925	49481813	60937956	62899096	68595462	70098984	72103637	72288600\n.	33	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	33	496997	2058320	2561261	3132378	4183253	4927435	5981138	6213317	6899510	7897200	10065640	10172715	11051394	11376991	13255250	15931814	16831120	18095924	20312076	22368032	23850805	26401680	28610278	30061222	36285037	41068413	45981782	50838342	60903354	62555246	64719397	68492993	71405329	72288600\n.	34	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\n.	34	99538	191035	645943	1969667	2716860	3344055	4496680	5068312	6442962	6739227	7462384	8539888	9487790	10906952	11510992	11990462	14110175	14571022	18514965	19417714	20987713	22453892	26135563	28117884	32050418	35333739	37903451	42452961	47495574	50392754	63151043	66552163	68469345	70233297	71448148	72048380	72288600\n.	35	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\n.	35	156283	706002	2221015	3050757	4066186	4392493	5887608	7153235	7479029	8161861	9437063	10539824	12047584	12636334	13223875	15529314	17281005	20485264	20951676	23816272	25669413	28287196	31142469	34351494	36795463	41200316	44400316	50022072	54962716	62806363	65848851	67654131	69209598	70544903	72074994	72288600\n.	36	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\n.	36	219508	589028	2703811	3238210	4000110	4710771	6067583	7176309	8078527	8192287	10238204	11391278	13066475	13757840	14804911	16768074	18552649	21982286	22635735	26821499	28432690	30478490	33814451	37382525	39318946	43930080	47298894	50205317	56493441	61107229	66538890	68268796	70051693	71240466	71616221	72288600\n.	37	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	37	228692	481404	2995503	3586425	4820060	5208573	6609437	7734161	8738038	9772860	11312385	13544960	14610981	15132695	15782631	18187300	22113702	23779408	25404230	28315007	31335662	35092796	36902748	41011512	45628333	48672120	53595929	56505447	60591386	66845646	67806132	69023895	70894416	71596734	72288600\n.	38	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	38	134256	249719	537909	2795490	3538919	4792892	5655772	7171336	9147303	9503940	10085314	11042788	12840428	15633025	16599181	17395220	19697750	21886803	26003565	28116423	29089446	32554872	35793908	39536512	44057005	48849583	52171226	54490246	57429316	61290579	64076733	68359366	69728244	70478877	71376681	72288600\n.	39	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\n.	39	186327	604520	2869791	3908165	4971412	6142119	7176771	8686777	10427979	10955326	12165476	13888191	17393336	17838237	19532677	21501373	23230032	27484619	29209085	31080419	35073747	37998307	41583412	45502682	49200795	52903144	57251926	60128836	62640365	66726049	69420492	71070886	71800454	72288600\n.	40	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	40	282152	643860	3508613	4018069	5248844	6396619	8309061	10132371	11399124	11842699	13216654	15914144	18070743	19544634	20047011	24755473	27166711	30188369	31445213	34557341	38675820	40459061	46472032	49595961	53060143	55425200	57619575	62472025	67190351	68407441	70293152	71113744	71493199	71984697	72288600\n.	41	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	41	199143	707489	3716454	4276483	6019332	6880139	8960719	10947390	12312029	13049814	14549688	15791747	19587360	20718167	22581403	24550599	27741790	31619052	35615281	36523250	41375063	44390640	46034773	53930557	56915281	59471649	61674572	63350103	67649426	69215938	70537999	71164735	71478433	72105025	72288600\n.	42	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\n.	42	69041	781611	3451876	4695673	6167922	8084609	8636193	10858541	13339660	14127705	15419856	17496064	21576065	22338591	23880318	26520587	29882702	34470091	36500829	38037344	42947904	46712003	52307236	55285570	57780024	60214307	63078455	64330652	68615595	70119945	70590872	71474770	71900065	72288600\n.	43	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	43	141135	833985	3662824	4990410	6521422	7956203	8570932	10959972	13804133	14327311	15410131	18484277	20447290	24189735	24689528	26778817	28578913	35276418	36851124	37825472	41988159	48262706	51603270	54966947	56597284	59583447	61342808	64504729	68038673	69451564	70209732	70954460	71314087	71745675	72288600\nA	0	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nA	0	6196	25885	58020	117506	159129	244736	284348	320875	362885	435318	487381	493770	522352	581448	642368	696576	783315	910616	979759	1064669	1175821	1312859	1399304	1491134	1691201	1789289	2000677	7430447	10474982	13705239	19384962	21951880	22091647	22127679	22198192\nA	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nA	1	6466	23896	56963	126459	178278	275293	319554	358582	406207	493406	554700	561389	593437	657714	733753	798223	896841	1041190	1114119	1212209	1333950	1505986	1612599	1705295	1952547	2062365	2296765	7639438	10689807	13734647	18919366	21268044	21421617	21453208	21540598\nA	2	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nA	2	35098	62674	75825	170198	226959	283429	328700	379797	441898	507436	568564	647616	693569	766010	848302	932149	1030750	1112342	1207108	1272381	1341706	1473695	1537217	1682115	1864151	2015880	2147642	7713580	10179680	13134993	18600040	21252637	21273013	21360457	21393690\nA	3	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	35	36\nA	3	17167	29879	56779	150480	241047	273679	335194	398465	447229	504408	553068	604476	683118	722548	805942	848874	897763	991471	1052641	1190556	1328099	1424569	1472784	1526673	1627063	1743244	1824633	4554269	9777561	12672614	18078616	20613893	20682245	20750706\nA	4	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	33	34	35	36\nA	4	17710	47604	82375	160521	225634	283035	311280	374538	442152	479499	547445	618529	686745	712133	782338	911232	972259	1073729	1129126	1284431	1412339	1414161	1587755	1829810	1955361	2175149	2409658	2696179	7888845	13865913	21011897	21061977	21155164	21205297\nA	5	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	5	16241	49623	97739	164007	249887	315287	392055	463266	506472	568044	625169	656211	716487	820050	856554	889739	1012572	1165183	1242567	1422646	1464121	1618612	1816537	1945591	2019811	2397843	2787532	2974521	11206691	14518466	14720313	15025689	20873324	21159023	21255062	21322684\nA	6	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	37\nA	6	28917	33507	68967	170418	218240	271449	337099	432761	466789	509473	586604	635907	646955	751805	865872	962507	1052930	1151999	1263037	1376120	1521012	1707333	1901872	2032547	2455681	2575430	2814714	3287449	4051059	12004131	15198973	17495837	19392560	21030206	21095630\nA	7	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	7	24182	37846	78064	173019	248941	294133	375761	445344	483578	530023	591678	652136	717261	796332	892170	972388	1038703	1141600	1240424	1345553	1504046	1674810	1919752	2009879	2061201	2360196	2626757	2822076	5634972	11143344	14469281	14627514	16893496	20854813	20911180	21027684\nA	8	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	37\nA	8	26790	29424	45538	157535	250421	278220	346495	451939	478167	549756	610050	699937	726437	825033	1018758	1044940	1197987	1262836	1485966	1540729	1697234	1784376	2096019	2251658	2481283	2972865	3246815	3361176	4000964	11853117	15100979	15686109	18575570	20697042	20762317\nA	9	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	9	14152	16690	92894	142768	246715	288122	352346	458571	511566	566754	602459	662604	759581	801975	975302	1007579	1148980	1222984	1319809	1526770	1659919	1728943	1964865	2134513	2337464	2591986	2701758	3166640	3517557	11445596	14330901	15035781	16680724	20204450	20325861	20963163\nA	10	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	10	16471	29828	59187	106513	219348	299674	326589	447346	454038	488688	647491	662384	714349	813805	860661	919932	1051445	1173729	1307029	1474663	1592355	1693005	1948988	2056382	2221582	2367715	2805686	3102317	3485130	6685900	9461351	14954340	18004120	20302727	20360426	20822038\nA	11	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	11	20965	29049	72298	152338	291873	326386	361746	446476	523794	568167	617175	714424	765945	872282	914511	984095	1127626	1310054	1441122	1542237	1658665	1796293	2070925	2307249	2444971	2602265	2886904	3170774	3617498	6626310	11493202	14773837	16156454	18398311	19647798	20829756\nA	12	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	12	12282	22118	47607	149101	246678	361071	428186	457315	582893	610053	636348	776287	859917	936229	1050347	1112712	1186538	1310088	1550638	1728541	1995506	2178106	2343055	2613037	3004487	3216887	3439611	3725703	4392003	4912541	12754969	15628183	16641828	18746090	20346221	20835090\nA	13	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	13	26809	34486	74182	169238	212652	341403	409717	499008	601566	651524	716943	828303	861199	993545	1044749	1140676	1221942	1351816	1455797	1737420	1968788	2307053	2625359	2987169	3582769	3891420	4326240	4738441	5487835	5727368	10861315	15636839	17707049	18755373	20386780	20829788\nA	14	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nA	14	11492	26203	81519	156862	252860	343922	431912	496612	534797	712197	771182	793594	850990	987968	1228168	1271756	1398834	1435930	1737625	2114767	2221588	2502660	2829630	3139876	3592097	3986713	4286955	5116462	6160762	6877732	11885598	14977757	17189705	18724956	19977859	20487217	20793682\nA	15	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nA	15	17489	35538	94114	234077	370919	425169	447163	501872	579175	715988	850074	883496	968536	1080128	1239552	1323971	1453486	1622807	1890968	2105516	2600600	2779457	2927618	3434090	3830378	4215221	4497119	5076208	5490256	6087358	14119985	16716637	18616289	19588319	20629776	20734676\nA	16	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nA	16	3581	9044	37743	86126	257789	280886	484448	497976	537181	671240	735160	840313	942472	998216	1102252	1234471	1431893	1605856	1791295	1859928	2189684	2499452	2886489	3076268	3290153	3694460	3926051	5262960	5937130	6889293	11682312	14550134	17184643	18702453	19072212	20468186	20838449\nA	17	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nA	17	5400	28655	155956	267312	344923	507492	567909	613862	634498	827253	939118	1009827	1089051	1332662	1382257	1478822	1743596	1845388	1966539	2168873	2471263	3266779	3543915	3918906	4499214	4968207	6023232	6907724	8758148	11326468	14116276	18336444	19059190	19839918	20426235	20772658\nA	18	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nA	18	6992	25184	146727	215441	401972	431759	494895	651527	724972	736218	823161	1084611	1114357	1169057	1288323	1428313	1593302	1941136	2110429	2416506	2670269	2866134	3404389	4060893	4588047	5971494	6200127	6846709	7726285	9742678	14227344	16328070	19253794	19852107	20632209	20787775\nA	19	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nA	19	6325	19235	38624	130343	209818	426004	444630	490643	699522	744174	806089	827615	1181568	1236641	1280092	1542801	1659020	1829991	2025332	2325673	2585818	2971472	3620358	3664122	4261090	5032440	5796502	6641164	7670072	9028538	9577019	13276932	16062731	18742192	19558238	20428879	20749301\nA	20	4	5	6	7	8	9	10	11	12	13	14	15	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nA	20	20014	81965	222839	292154	462433	580390	784047	798202	826944	962908	1204033	1325019	1566816	1694521	1994579	2099412	2324966	2556797	3038167	3383373	3750699	4071882	5083743	5331636	5875869	6884170	8688892	9686824	12287598	17388832	18443187	19781448	20607966	20784243\nA	21	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nA	21	611	2619	30142	120681	205369	379070	503995	548989	736185	864498	897606	948590	1242011	1295148	1453458	1492953	1864846	1943030	2066755	2347788	2614351	2845738	3159526	3765898	4274537	4783281	5536047	6187660	7130838	8275341	11015194	14353662	17561482	18962420	19933884	20591447	20790530\nA	22	2	4	5	6	7	8	9	10	11	12	13	14	15	16	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nA	22	616	28890	151161	224968	347848	561058	613087	730005	932944	1010815	1055698	1112540	1498970	1652594	1877489	2146505	2288580	2825700	2964808	3162003	3643049	3924903	4614121	5190394	5647042	6508667	7989991	8565646	10065624	14336177	17981385	19155389	20179626	20558653	20788981\nA	23	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nA	23	5720	36432	96420	255455	367652	546208	620981	690908	872052	1037106	1124291	1191127	1263579	1554851	1810899	1898652	2126986	2182487	2604802	2830775	3154341	3720665	4315403	4917376	5882839	6573896	7575557	8625913	9366269	10940542	14703075	17881069	18708014	19602953	20045390	20748236\nA	24	2	4	5	6	7	8	9	10	11	12	13	14	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nA	24	6949	25550	131696	251943	385893	506456	712729	722518	829494	1137033	1238008	1354150	1616857	1895865	2129563	2356707	2599484	2900421	3197099	3690424	4154607	4746725	5705342	6022991	6569935	7691243	8789820	9946854	11161767	14467473	17289490	18637452	19686402	20441121	20784717\nA	25	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nA	25	1725	37202	175820	301293	440351	643591	726667	813769	954167	1266754	1299877	1380102	1522593	1675279	2015874	2240777	2346547	2677250	3034377	3417600	3965847	4327386	4730126	5290353	5833972	6514865	7172290	8635766	10389450	13249038	14626966	18196444	19739388	20203147	20710158	20750937\nA	26	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nA	26	1043	31009	131718	317576	449134	609120	816662	894845	1033336	1099623	1379682	1486662	1593790	1774363	2429682	2450727	2652507	3023462	3377603	4040165	4389756	4753891	5586807	6174757	6852271	7305209	8253959	9452293	10539737	12620226	15517323	17699640	19089216	20277078	20590605	20704365\nA	27	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nA	27	1198	42822	136260	341545	489243	653058	877919	917139	1040550	1327063	1538984	1596878	1728473	2069262	2195080	2688274	2902978	3097404	3336205	3754395	4117640	4942489	5604206	6192123	7085440	8194763	9316730	10990356	12034714	12795475	14709461	17909668	19157516	19618668	20484511	20709421\nA	28	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39\nA	28	8649	21326	73456	302752	372722	663833	862375	1002674	1135734	1317856	1495830	1789711	1886948	2044550	2356524	2867020	3037180	3197516	3852508	4296507	4728905	5261181	6063922	6477476	7268830	8163521	9384026	10838799	11805161	12393771	14790144	17701048	18403214	19627477	20170139	20417095	20604295	20676609\nA	29	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nA	29	21812	82354	338309	483460	664274	968779	1088762	1253987	1325479	1517684	1987950	2042083	2280639	2453175	2950054	3422275	3605324	4107283	4580232	5051576	5844442	6359927	7012076	7891487	8826968	9937952	11166786	12474804	13785269	15509183	17554336	19061090	19759281	20467102	20579057	20620939\nA	30	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nA	30	1947	3111	73135	327181	460652	729752	899359	1206704	1296447	1397097	1662871	2155483	2304989	2410873	2616940	3062949	3895536	4068846	4535135	4804250	5186925	5946977	6696146	7146402	8654209	9455202	10706377	12091544	13529285	13700706	16273271	18614330	19851327	20122347	20199124	20524457	20600141\nA	31	2	4	5	6	7	8	9	10	11	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nA	31	3904	76974	334623	528178	687621	1002702	1205342	1397493	1589023	2069344	2438509	2616355	2792245	3166097	3698323	4307481	4436239	5127522	5545828	6376805	7252723	8022936	8558739	9641594	10491752	11743794	13181225	14658417	17111269	17900231	19356626	19817602	20208131	20498812	20588811\nA	32	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nA	32	13983	83990	274448	506744	649423	870286	1140324	1439552	1578902	1753381	1940483	2539005	2738412	2818899	3213479	3613274	3894273	4760729	5185712	5783594	6560713	6891341	7752927	8876758	9670283	10682316	11580934	12862835	14011999	15691989	18515862	18854356	19935567	20196721	20578391	20622008\nA	33	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	33	97459	460370	581919	744530	1079396	1300324	1640708	1719339	1951730	2278535	3025647	3062262	3401165	3529772	4201912	5191571	5478422	5941820	6765746	7525444	8039974	8964190	9736311	10231090	12276794	13837706	15300848	16246849	18611791	18922054	19308570	19958259	20414949	20547205\nA	34	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nA	34	16174	20080	143292	463749	669057	853732	1235679	1410962	1860867	1968484	2224311	2592801	2917539	3431835	3678487	3854860	4644817	4814950	6246046	6580797	7166820	7706905	9034698	9751788	11153114	12176627	13021904	14440234	15849677	16585245	19087011	19622358	19884530	20190623	20385238	20466803	20507221\nA	35	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nA	35	19985	159978	492812	739557	1048077	1164173	1628867	2054933	2170731	2405037	2833976	3209917	3755549	3963241	4198858	5028913	5679812	6815285	6982745	8023428	8694178	9632137	10640771	11707164	12489902	13913541	14866744	16384121	17243276	18763707	19334889	19667875	19903686	20096901	20341195	20380821\nA	36	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nA	36	25244	126670	680409	843164	1067078	1309395	1750559	2130085	2422961	2458406	3176262	3586402	4174464	4446070	4823826	5547201	6200432	7398419	7635743	9139332	9710662	10418879	11556809	12732719	13352350	14710155	15692000	16413872	17721444	18642235	19553360	19814947	20046709	20213277	20253061	20407587\nA	37	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	37	28964	97934	753078	929978	1314721	1445060	1893474	2264202	2604205	2962853	3477917	4245375	4628740	4835168	5067484	5919907	7343393	7876998	8450492	9493045	10533058	11813077	12370988	13699008	15089692	15900554	17252090	17804210	18428526	19537581	19644373	19847915	20116375	20180437	20318278\nA	38	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	38	25368	32751	111314	731782	937407	1308826	1612880	2100236	2764110	2887611	3089518	3425757	4021543	5005016	5361000	5646082	6464670	7249759	8651464	9392439	9707920	10929211	11989534	13187883	14618656	15968305	16722136	17306314	17897792	18443452	18951170	19668941	19861702	19943830	20054581	20228989\nA	39	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nA	39	13391	128238	754715	1052898	1380684	1772136	2106256	2601470	3199108	3401860	3805456	4393823	5620670	5774676	6374629	7073177	7674632	9110777	9700710	10322960	11646038	12573667	13723950	14925708	15998299	16865601	17837280	18231253	18669811	19322356	19810681	20016250	20127940	20168254\nA	40	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	40	42523	143781	910420	1046356	1435842	1801797	2440302	3049987	3483757	3641398	4116724	5028650	5773124	6299193	6476975	8129542	8977745	9934717	10358295	11387147	12765602	13310965	15163674	16020660	16867754	17415690	17946382	18707735	19417817	19588729	19882347	19978626	20030886	20071896	20112129\nA	41	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	41	18146	162426	1013025	1163083	1700618	1987244	2683837	3345483	3814491	4068389	4583840	4990984	6297099	6695710	7339694	8029243	9112596	10372580	11676524	11951664	13546467	14435203	14902099	17030490	17692718	18191425	18456006	18714380	19375955	19596212	19803680	19897495	19932671	19993335	20019977\nA	42	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nA	42	6648	184582	906922	1278787	1749653	2385917	2578469	3290744	4157127	4427301	4866652	5569178	6966908	7229071	7760818	8670800	9817389	11275179	11937926	12387303	13943200	15067592	16502948	17217580	17821291	18266444	18608278	18815378	19446779	19640824	19703976	19799635	19839805	19893721\nA	43	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	43	38255	196429	978337	1385605	1880512	2355273	2579027	3368927	4357015	4539475	4913928	5953660	6626534	7896879	8068989	8797776	9393886	11579590	12095832	12388790	13660213	15438339	16344884	17119372	17509632	18129111	18370636	18849853	19371297	19539377	19627499	19722790	19746713	19813001	19875565\nT	0	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nT	0	10322	29021	53155	107110	141914	214961	247118	274886	305157	355367	394601	401208	422245	459358	496134	529060	573130	632590	668118	708787	752627	806477	843179	873721	946758	980410	1048575	6562821	9464937	12463559	18557048	21214059	21258494	21269537	21298980\nT	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nT	1	10836	29283	61771	130699	181674	276623	317572	353539	395943	467529	524266	531103	557652	608491	661168	708057	771748	865034	912897	972373	1036101	1120034	1176488	1220114	1328114	1376778	1476078	6561667	9273548	12170471	17858713	20336439	20398487	20412999	20453263\nT	2	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nT	2	37145	57229	70158	171189	224744	280699	326222	376351	443518	506567	565935	637767	680656	741700	807038	870231	942796	1002913	1064717	1107518	1151639	1231968	1265908	1340814	1438885	1518663	1582751	7008365	9443431	12365045	18144668	21126116	21140607	21192476	21210878\nT	3	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	35	36\nT	3	16822	34085	60398	159652	256682	290928	355253	423266	473968	532445	586050	637390	717093	756132	834217	872143	912349	980003	1032706	1138739	1248517	1317264	1353112	1393917	1464878	1547005	1597958	4379578	9495127	12367479	18233410	20931434	20979941	21014997\nT	4	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	33	34	35	36\nT	4	20374	54847	92863	176057	245021	304708	331269	397827	468142	508008	578576	647014	710273	731726	796313	905721	957394	1031121	1070989	1175740	1266145	1268460	1383928	1532587	1606942	1736634	1884456	2053949	7247029	12860298	20956208	20980136	21038259	21063068\nT	5	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	5	18006	46659	82943	138738	220092	273761	343564	409760	449103	501305	550478	576891	632418	713332	739744	766896	857134	961208	1012382	1115304	1142762	1234538	1330467	1391036	1426017	1579486	1753754	1844817	9424012	12319109	12424522	12559332	19953625	20055286	20098397	20127388\nT	6	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	37\nT	6	30849	34614	68852	163925	214025	266668	329410	417051	445654	486270	559053	600132	610100	693074	784686	855854	919514	990572	1064101	1128639	1202277	1305998	1406666	1472777	1670141	1736067	1851480	2083085	2431316	10223312	13255006	15975778	18293027	20851180	20885588\nT	7	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	7	18584	32433	68327	161806	226912	273020	347285	407643	441266	481632	534074	582293	637345	692083	765782	819597	862577	923305	986737	1050654	1134320	1219311	1334681	1383467	1402544	1541061	1652061	1731512	4430992	9700279	12824832	12887321	15461111	20852757	20878199	20934875\nT	8	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	37\nT	8	21221	26560	42456	141195	233616	261144	321261	419371	443739	508014	558857	632622	652313	728640	865398	881882	973283	1013467	1136131	1166611	1247301	1290322	1438534	1523861	1645449	1888895	2002341	2076234	2349723	10203309	13338625	13639771	18111966	20978717	21014319\nT	9	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	9	14151	17199	90657	137521	232397	272880	331156	422352	467409	511666	537551	586010	658726	689552	805025	824577	912678	948516	1003755	1112350	1176900	1208904	1316432	1392979	1490817	1606548	1662672	1878041	2019218	9695055	12571579	12905371	15351384	20276083	20326501	20652035\nT	10	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	10	21579	38036	66092	113889	227797	308996	332692	448640	454701	480945	613058	624362	663714	737054	771750	808062	890990	966685	1044279	1140149	1198858	1251096	1362139	1406245	1479506	1552211	1750618	1904052	2067361	4992843	7702191	13069889	17629067	20504020	20528349	20760723\nT	11	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	11	30372	44875	86011	162526	310511	345147	375907	455913	527053	564434	608568	686609	725686	803116	836998	883115	981922	1092175	1167494	1224051	1285045	1349744	1477228	1600928	1661497	1733209	1862108	2000583	2221591	5081464	9959927	13100482	15126400	17848648	20190800	20832747\nT	12	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	12	15441	28436	52415	148350	241045	350810	413913	437361	541610	562121	581282	685821	747024	801649	879700	918574	956286	1031319	1149085	1243969	1380180	1470368	1538638	1647095	1809835	1911623	1995416	2109518	2417989	2657181	10573234	13627807	14200956	18216367	20548481	20860929\nT	13	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	13	25094	35130	81113	166286	212196	333095	392293	466016	552105	588026	637301	713612	735710	823966	853525	908020	952481	1024087	1074298	1219408	1313859	1452334	1565083	1703661	1957905	2090962	2245323	2444141	2847280	2982405	8366031	13617135	15958007	17926239	20500722	20864520\nT	14	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nT	14	16104	28499	88214	153000	241891	320573	397975	445907	472397	612995	651657	665435	705182	786024	929752	945877	1009822	1025582	1152559	1331633	1372993	1492339	1620913	1725547	1901755	2049024	2150956	2523968	3053375	3485219	8716886	11716446	14536015	17844404	20183455	20701112	20875117\nT	15	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nT	15	19346	44030	100328	234568	365007	415781	434121	474996	534002	646139	733466	753986	808746	873315	964377	1007464	1068124	1151465	1272596	1350862	1555261	1619813	1682445	1875041	2023732	2157671	2253365	2475526	2656839	2984207	11097401	14187436	17959926	18700707	20989125	21045893\nT	16	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nT	16	6111	14615	38486	83083	239846	261053	444776	455631	485697	591084	635834	714115	780463	818682	877965	957608	1057574	1147226	1220621	1246287	1400621	1511999	1665124	1739481	1813859	1969411	2048318	2522401	2831413	3328838	8665167	11394501	15563219	16625314	17028824	19403750	21002400\nT	17	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nT	17	8556	30125	148242	250310	315963	451326	504935	535595	550272	690441	763262	799555	838633	968583	993410	1040633	1151479	1196885	1248276	1324792	1448598	1740417	1825622	1951360	2125863	2336912	2693962	3077072	3936146	6857692	9917892	15211714	17108749	19065097	19829936	20978470\nT	18	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nT	18	10724	23664	130737	199273	353559	376676	433090	558758	608775	616539	674411	850951	867960	892045	955852	1023402	1105497	1263834	1322345	1457978	1551772	1614682	1786282	2010484	2182721	2656694	2735712	2958366	3590555	4719546	10016675	13150569	16431938	18780585	20889512	20956116\nT	19	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nT	19	9783	33103	47726	127827	195713	374962	388295	422192	594080	622300	658075	671893	894076	922935	941375	1065168	1123513	1182756	1266421	1399534	1486103	1615479	1839789	1854672	2050842	2316584	2558313	2879803	3230444	3966661	4434926	9565503	13042051	16258310	18055316	19373878	20978225\nT	20	4	5	6	7	8	9	10	11	12	13	14	15	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nT	20	16502	73133	204623	272010	410440	503593	666488	675505	693706	777701	932059	993946	1112434	1174861	1302785	1347028	1419178	1523158	1699861	1817298	1950188	2050654	2408329	2489966	2735240	3069570	3814766	4344935	7464227	14922756	16508163	18725399	20744545	21002023\nT	21	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nT	21	963	4019	30712	114034	198272	346085	451045	484617	632208	734084	753280	786063	965760	992901	1090947	1106524	1291078	1319906	1374733	1506915	1587797	1680288	1789925	1994726	2173956	2351997	2646989	2877301	3291852	3783491	6817314	10155671	14460094	17756332	19673118	20791849	20979936\nT	22	2	4	5	6	7	8	9	10	11	12	13	14	15	16	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nT	22	993	27819	133697	214705	318368	492928	529988	614397	774212	820733	846345	874142	1080544	1176007	1258053	1374190	1431160	1650341	1700508	1774979	1940615	2030980	2268154	2478166	2650142	2960153	3672900	3960544	4849959	10473249	15600291	16862852	19347601	20745043	21070502\nT	23	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nT	23	7774	37254	99211	236858	331118	482851	541697	591931	732405	854624	903246	935806	964507	1137020	1268782	1310199	1401000	1437056	1614551	1692296	1812922	2035199	2241242	2454665	2841879	3076013	3513761	4009828	4414930	5357152	10702270	15844052	17228142	19065459	19966085	21032730\nT	24	2	4	5	6	7	8	9	10	11	12	13	14	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nT	24	9377	29553	129604	235588	352075	445851	608836	615778	681783	914238	968211	1024121	1148840	1297861	1412665	1496191	1598433	1717279	1834074	2012749	2179818	2373936	2746828	2890268	3127187	3572269	4038166	4764659	5577430	10695896	14103475	17171464	18725126	20682198	21113091\nT	25	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nT	25	2687	37963	176857	284017	403374	564548	637992	696535	791671	1009207	1022276	1065176	1121678	1202130	1366065	1483466	1520483	1668349	1817077	1942597	2137094	2264346	2406341	2606588	2807694	3091705	3381848	4141745	4997992	8439940	9594144	15287389	18512726	19715568	21112261	21208001\nT	26	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nT	26	1456	28635	136560	298162	410704	533021	702214	749494	843791	879195	1079541	1131252	1178083	1243878	1584965	1593662	1660251	1815873	1963162	2187960	2330119	2450897	2749693	2972085	3272597	3495782	3935382	4426925	5229466	8040351	11739836	15476452	18629323	20488958	20998206	21173297\nT	27	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nT	27	1682	44575	141332	324942	450561	583818	769281	792796	866374	1059769	1196565	1228029	1285334	1429421	1477349	1729889	1799511	1895910	1988017	2139875	2253765	2567254	2816429	3038132	3387645	3868006	4397590	5454447	6171112	7155149	10237194	15425815	18510302	19550091	21046763	21340960\nT	28	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39\nT	28	10187	25266	79863	298632	363557	613994	767166	877429	957277	1067117	1192971	1359969	1406816	1461281	1605218	1854166	1913968	1970594	2247515	2406091	2564369	2749646	3045211	3188158	3521666	3904814	4428940	5247471	5861683	6582416	9875605	14541600	15870206	18875678	20011972	20849692	21212646	21497837\nT	29	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nT	29	24855	89522	326142	454803	605274	842877	935164	1032955	1067475	1176793	1467932	1486150	1574212	1646040	1873284	2076292	2139437	2360090	2532490	2703702	3000269	3188790	3450500	3810020	4243489	4777718	5637420	6421299	7477560	10399519	14372004	17275967	19107563	20885887	21398596	21509434\nT	30	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nT	30	2353	4263	76367	308704	423526	638487	755480	987751	1036410	1093696	1237626	1521565	1583198	1628812	1695734	1882407	2240541	2301052	2504491	2603353	2757391	3041769	3338836	3563770	4178237	4660777	5371370	6349477	7298181	7747644	12307958	17136398	18639811	19584906	20271957	21298216	21466927\nT	31	2	4	5	6	7	8	9	10	11	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nT	31	5018	77641	312958	476925	610425	838126	994433	1122025	1222275	1513323	1706772	1776684	1833120	1988359	2230025	2479935	2576747	2818874	2976287	3320706	3684374	3992122	4220802	4765399	5290092	6094361	6954732	8395362	12883990	14850441	17885233	19061868	20200186	21315870	21506172\nT	32	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nT	32	14918	84298	266613	462546	585835	760914	949640	1178257	1251527	1342892	1452955	1802889	1881371	1918992	2053643	2227059	2330523	2781054	2949764	3177146	3522030	3653800	4027166	4555121	4987111	5584656	6164053	7133317	8087558	11287785	15896767	16903105	19717303	20510021	21481879	21545371\nT	33	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	33	102929	431899	539766	681996	925288	1090643	1340885	1380608	1498668	1666175	2073147	2088486	2212419	2255613	2516732	2958186	3132250	3304258	3638990	3963063	4199513	4606302	5009396	5297998	6682157	7754620	9117575	11279175	15568412	16410017	17496282	19594175	21280718	21788782\nT	34	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nT	34	17396	21579	142141	425015	595152	747687	1010676	1137722	1453627	1504403	1624613	1803103	1997468	2244233	2330742	2399011	2698403	2766104	3449335	3597597	3810095	4045649	4679209	4993253	5717925	6452467	7045012	8234006	9710543	10777108	16737462	18640996	19798114	20707196	21332432	21673458	21816694\nT	35	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nT	35	21601	160010	467936	665633	918457	999224	1311805	1598083	1653817	1764864	1970911	2177425	2431730	2516363	2594766	2912298	3196130	3732472	3810798	4239867	4528405	4965745	5434178	6068220	6597676	7623329	8540664	10385531	12797431	16893334	18525341	19400414	20289731	21112022	21957165	22078082\nT	36	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nT	36	28124	133055	617146	745962	930941	1109380	1388538	1616470	1816805	1835199	2164151	2387287	2670438	2768067	2917513	3189215	3491397	4082321	4185645	4852538	5124452	5492319	6131295	6872122	7297648	8623644	9571716	10597059	13318229	15667091	18799837	19803213	20923813	21645820	21897066	22140112\nT	37	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	37	31751	101547	687187	830628	1132580	1231069	1516694	1757274	1970781	2136410	2378730	2807494	2961108	3033427	3120948	3465550	4106379	4434014	4690500	5157168	5712003	6422428	6839491	7766258	9100369	10128313	11710054	13103731	15340150	18946491	19599326	20276547	21456830	21974524	22315483\nT	38	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	38	28577	37146	117284	660802	836547	1134348	1347589	1651916	2076484	2134722	2226912	2372842	2654483	3150978	3290363	3413337	3733627	4092082	4820745	5151694	5350903	5941184	6599095	7424092	8565999	9948814	11310593	12203009	13659623	15950346	17554491	20104190	20964765	21492345	22082838	22516537\nT	39	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nT	39	16707	135576	693696	919230	1181507	1461475	1654729	1946876	2323377	2399399	2591559	2856878	3479928	3547553	3805380	4080232	4363233	5175081	5474866	5824173	6618560	7247209	8056939	9059701	10162724	11730029	13543539	15252910	16566164	19046325	20596021	21729860	22180937	22549917\nT	40	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	40	47894	149829	783966	926950	1222711	1488958	1888948	2252629	2514590	2582590	2794340	3254825	3643165	3862052	3938575	4678550	5095750	5718652	5951478	6546955	7390055	7809994	9313353	10356953	11682639	12678278	13545533	16481547	19354792	20127335	21287161	21826279	22066430	22439152	22626904\nT	41	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	41	21883	165587	869162	1025407	1439803	1638197	2068998	2463020	2741228	2857694	3084678	3284161	3959151	4133066	4427692	4725762	5290127	6078971	6865941	7076951	8121810	8902886	9477665	12084580	13411517	14687877	16097182	17103751	19888960	20915985	21700898	22082002	22305842	22772717	22888836\nT	42	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nT	42	9767	189574	805103	1121702	1472127	1917614	2015540	2445164	2953619	3080426	3279303	3602440	4355274	4473048	4717546	5149392	5754625	6718109	7138792	7521951	8683804	9744139	11718674	12799370	13778275	15144314	17040666	17754177	20591481	21602147	21913508	22552145	22874235	23125179\nT	43	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	43	41876	201622	845988	1180470	1535113	1854598	2000751	2446267	3024589	3106039	3273837	3755993	4091530	4788716	4861294	5195918	5520506	6905988	7198921	7434923	8461905	10441938	11441177	12783736	13448239	14810502	15921915	17795582	20138428	21141262	21674037	22176581	22469758	22740143	23124824\nG	0	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nG	0	4362	16103	36255	74207	104229	163725	187135	207198	231546	274191	304657	308622	323716	348765	376917	401351	433064	481207	506232	534218	564969	610767	640543	660701	720741	746178	798867	3825524	5832266	7821285	12042846	14147803	14184397	14190370	14212138\nG	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nG	1	4548	16664	38089	79897	112260	175688	201868	224957	252314	298226	331920	336794	353697	382245	412654	439398	474067	524428	548559	578863	611206	658252	688781	709062	770568	796122	848709	4546293	6854479	9157478	13205431	15082838	15119024	15124917	15147725\nG	2	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nG	2	19911	33099	40718	100567	132310	167259	194358	223830	263755	301593	335606	377316	400143	435002	468849	502473	537460	567703	601183	622630	642652	684874	703312	739406	788721	826424	856844	4843089	6572741	8811677	12882055	14868717	14876022	14901084	14910368\nG	3	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	35	36\nG	3	11729	17880	34091	95482	154712	174845	213042	253819	284612	318104	349454	377441	423048	444718	485005	504670	523854	556133	583096	637602	691702	725720	740690	759491	794508	838774	865887	2779447	6896627	9275654	13546413	15626045	15652684	15672032\nG	4	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	33	34	35	36\nG	4	12995	30736	50794	102379	143776	181338	196926	235812	275777	300386	340261	377660	412684	423877	456477	509148	534670	568779	588894	638273	681803	682637	737022	811401	845902	910807	980951	1065009	4761328	9372625	15398264	15411341	15436880	15450612\nG	5	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	5	9268	29690	54097	92535	146581	182254	230014	271812	297108	330964	361381	377596	409556	459271	475421	491386	538462	598180	625510	682580	696081	743738	796822	826173	841515	927049	1028813	1077465	7108862	9530514	9592897	9674480	15424266	15484168	15503683	15522119\nG	6	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	37\nG	6	15903	18588	41397	105872	135539	169737	209670	267752	285202	308559	353968	377005	382937	433003	488992	526467	563201	600335	640828	673505	714520	769329	826357	858950	967889	1003317	1063515	1201165	1402319	7281601	9649532	11743577	13523310	15382989	15405475\nG	7	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	7	12335	19814	41130	103362	146970	178580	229305	268887	290086	317349	352424	384642	420129	456787	502360	535764	561235	599075	637629	676039	725927	778782	849882	879443	891546	973396	1038441	1085387	3004787	7011465	9417988	9451991	11307190	15152285	15166254	15203945\nG	8	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	37\nG	8	12746	14532	26402	93189	153587	171938	214630	279434	295524	336076	369610	417358	428309	474535	559074	569280	626058	650576	719996	736078	785536	809058	890111	938870	1010429	1147964	1207993	1258323	1427536	7170605	9560431	9741572	13112491	15080526	15101378\nG	9	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	9	9427	11176	52797	86902	152465	181842	223114	289680	322622	357569	375391	409928	463059	486880	568636	585187	649383	673620	711202	786495	835394	854296	920415	973237	1045009	1125432	1164873	1310503	1408511	7179356	9449816	9697028	11491189	14958718	14989136	15223249\nG	10	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	10	10914	18567	36854	69620	147718	201068	219523	305594	310895	329137	437038	444787	474713	530672	559752	592685	666217	721573	787261	858922	913839	953133	1044393	1082581	1144538	1199327	1361026	1477343	1608092	3964144	5893052	10005162	13152006	15017681	15035064	15219044\nG	11	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	11	13822	22518	45253	95584	194085	218979	243767	305891	361311	388904	427973	493127	528696	599227	628061	671109	753765	862307	926788	981637	1041214	1100641	1220883	1324656	1375510	1434188	1546678	1667176	1862508	4122265	7606898	10089341	11427803	13291192	14642933	15189078\nG	12	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	12	7987	16201	26746	92474	157691	237480	280876	299874	380854	398431	415745	496054	549201	592009	655380	686503	715103	770442	887771	960201	1062794	1131700	1181903	1284904	1409905	1485463	1551038	1645920	1865946	2053510	7833054	10172181	10615327	13173191	14844237	15078753\nG	13	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	13	13254	18809	48962	103860	134938	217708	264417	320180	390283	417801	456116	514512	532097	598554	624339	672822	708023	765760	804785	912899	980516	1101983	1204499	1308504	1493031	1598831	1718759	1859662	2165692	2268658	6235457	10141527	11781909	13189790	14792008	15065610\nG	14	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nG	14	10293	19180	58051	99060	163298	220706	277924	315102	339316	446179	476853	488534	518448	585802	696427	714292	760706	773106	886077	1018681	1054204	1150268	1247361	1339710	1462968	1577160	1655652	1941112	2337038	2681266	6518850	8694017	10850920	13053516	14502023	14890676	15020456\nG	15	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nG	15	7093	18225	53152	148496	249101	287832	304745	339109	396857	491347	572708	595114	646402	715016	793599	833557	896902	980970	1105313	1184725	1390708	1458669	1518674	1702014	1835637	1970252	2069147	2263425	2417328	2694380	8484708	10801781	12966809	13551853	14989807	15039309\nG	16	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nG	16	3839	6581	20918	49162	155566	172161	313610	324312	348572	440237	480608	547091	605254	640156	697496	769454	862581	938373	1005364	1026484	1159401	1277637	1429131	1491350	1565184	1710146	1775110	2184002	2443237	2862206	6711068	8628072	11513610	12332164	12633642	14184694	15025639\nG	17	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nG	17	6839	20324	91017	162581	209881	321168	359504	389458	399719	513338	576398	615499	650069	764669	789496	832644	941472	986556	1033879	1110326	1212465	1472641	1551928	1673774	1856766	2036694	2361513	2696337	3405915	5490092	7706741	11503421	12674149	13826694	14364451	14989487\nG	18	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nG	18	8707	17707	83118	134224	248492	266938	312405	417926	464626	470124	524210	679317	696237	721656	775665	843622	926156	1072256	1129152	1258044	1350919	1421663	1593273	1801722	1994738	2419378	2517424	2735174	3234993	4191456	7881842	10168344	12435440	13626579	14881876	14942244\nG	19	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nG	19	7968	18263	28278	80511	127058	264787	278762	305221	446389	474998	506832	523023	724311	747407	771094	887324	941855	1004433	1079396	1202030	1294154	1429685	1654110	1665424	1827473	2088312	2338505	2653285	3004873	3597811	3965942	7443847	9970802	12179383	13271319	14210529	14952902\nG	20	4	5	6	7	8	9	10	11	12	13	14	15	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nG	20	10754	45406	137590	183115	288244	373496	506825	513582	532082	619775	763958	825146	950459	1008894	1141193	1187628	1268858	1369993	1571434	1679367	1811016	1935404	2278084	2374702	2600955	2994201	3682324	4139968	6247338	11304976	12276295	13619889	14817912	15009792\nG	21	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nG	21	1173	3540	22275	73693	127000	243294	320395	347013	477970	569137	588664	620521	802144	826290	919356	940852	1127284	1168856	1226771	1360067	1457591	1546140	1676862	1891188	2089288	2276110	2568656	2828933	3223818	3666127	5779240	8101772	10916843	12976954	14078373	14795684	14943878\nG	22	2	4	5	6	7	8	9	10	11	12	13	14	15	16	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nG	22	1180	19112	84909	139679	227204	357505	391520	472327	608725	651504	679078	711117	922426	1012228	1107024	1227245	1287605	1524670	1568064	1645295	1836110	1924271	2178523	2415375	2611399	2928472	3602044	3885196	4615047	8342372	11725121	12630256	13845062	14654762	14890438\nG	23	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nG	23	4161	24319	63211	167772	243143	359646	406604	452350	577198	687688	741405	779604	820985	998499	1135814	1192546	1290140	1325143	1527732	1620057	1759470	1996273	2248153	2489475	2906407	3211200	3627832	4108944	4500694	5317953	8760948	11961366	12783712	13809256	14355466	14934406\nG	24	2	4	5	6	7	8	9	10	11	12	13	14	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nG	24	5406	18890	93668	162143	248484	331721	466609	475902	538093	749893	813223	881145	1031207	1186667	1303201	1405586	1533973	1670334	1807772	2025285	2223257	2477026	2886795	3036422	3289483	3769406	4261408	4907531	5606516	8710751	10884264	12615668	13569092	14581163	14888403\nG	25	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nG	25	2540	27526	127432	206623	291627	432958	493954	561751	667874	883601	905033	960090	1039167	1152260	1348943	1484250	1541955	1728554	1916358	2124096	2368189	2534818	2728488	3012656	3300531	3639505	3976140	4741810	5619746	7782947	8645637	11678113	13517410	14111862	14802075	14854595\nG	26	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nG	26	1533	21180	89547	208823	298460	408416	545514	595305	698801	743625	929353	1005943	1062609	1162422	1546242	1562384	1666380	1848025	2032081	2346148	2519462	2667197	3077596	3361489	3728024	3988616	4465775	5037457	5707081	7367102	9548687	11620685	13274864	14372658	14696729	14816431\nG	27	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nG	27	1673	32300	93944	229518	328761	448372	603409	638968	728403	940633	1089057	1139163	1224688	1449790	1519408	1820972	1948834	2051573	2195272	2408722	2601616	3041867	3414878	3719068	4181281	4749029	5373537	6356090	7007039	7624555	9290273	11862751	13359683	13823452	14585351	14784444\nG	28	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39\nG	28	5240	15852	52827	214349	261666	460411	615883	729016	836083	991164	1125944	1343875	1415342	1513719	1752195	2080465	2177751	2290296	2669441	2945597	3211282	3496032	3950179	4205733	4643300	5175659	5853970	6701502	7288162	7775330	9554099	11715296	12331266	13659665	14142831	14459882	14641586	14717918\nG	29	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nG	29	15631	60227	215608	325299	448887	675306	757682	890030	939456	1089452	1437654	1470451	1620161	1730901	2066616	2349198	2470337	2764802	3047893	3317298	3772867	4052408	4434005	4917355	5451095	6078357	6881262	7680869	8540326	10015326	11890145	13007276	13735953	14474645	14654887	14704181\nG	30	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nG	30	2212	3773	56937	213360	314311	488594	614312	824963	895919	968890	1165534	1483019	1593601	1653571	1789905	2074729	2549128	2653398	2914092	3076235	3297903	3709503	4133509	4411233	5233851	5755904	6514197	7363075	8227350	8433921	10635809	12708957	13663237	14011690	14185273	14596503	14684476\nG	31	2	4	5	6	7	8	9	10	11	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nG	31	4094	56310	217986	350819	460538	673789	822927	953262	1090900	1442750	1692390	1798240	1911053	2165674	2500579	2863778	2933544	3345066	3575770	4070237	4571202	5042568	5346124	5995844	6521309	7324015	8192766	9300974	11406243	12219884	13343982	13825745	14270782	14686272	14782281\nG	32	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nG	32	9234	61942	191440	338573	448585	583870	790843	998137	1094057	1234088	1376258	1796712	1916873	1980312	2224804	2490483	2660656	3189300	3443810	3800862	4263105	4472318	5009014	5684020	6163819	6808807	7385047	8197060	8977582	10489645	12474216	12847744	13970744	14244597	14646886	14690802\nG	33	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	33	72525	291863	390367	517153	745815	919357	1152759	1224069	1404348	1652724	2178668	2214434	2441444	2532486	2989925	3601019	3780206	4088226	4581976	5047181	5394339	5962357	6441939	6759239	8072724	9087273	10077944	10838618	12516495	12820632	13203033	13892466	14405699	14559876\nG	34	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nG	34	9671	12697	98951	297836	434221	572234	821898	952918	1263439	1339398	1535021	1796903	2023352	2367311	2516701	2648572	3147469	3271915	4154599	4362186	4723256	5040939	5880572	6313225	7153598	7860970	8403708	9350107	10376268	10966744	12955008	13549220	13881221	14179039	14391943	14505381	14549057\nG	35	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nG	35	11903	106327	313625	471309	690648	744760	1110658	1397465	1483138	1665193	1989341	2279801	2628824	2781043	2939641	3506350	3934075	4628766	4736702	5393952	5811350	6394646	7028824	7727235	8249900	9183322	9835836	10985124	11770970	12857049	13360577	13694057	13946842	14155872	14426880	14459844\nG	36	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nG	36	15609	79122	407875	527207	698047	829848	1155616	1406492	1628725	1667848	2176169	2457551	2863801	3035484	3304123	3787295	4207335	4948737	5107085	6045612	6405254	6867930	7598249	8362127	8777952	9741614	10433779	11014866	12077211	12807094	13503851	13789063	14066036	14257006	14315266	14446674\nG	37	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	37	17229	61653	450947	586156	842060	919015	1250351	1508042	1759723	2028371	2418592	2931707	3214349	3346228	3520395	4101651	5014865	5344537	5721560	6383560	7052740	7884833	8274156	9143509	10095729	10686299	11689364	12201454	12807162	13600217	13727608	13907749	14174759	14257108	14388318\nG	38	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	38	14391	19213	69554	439466	549458	848603	1006364	1365954	1821099	1926760	2087509	2337200	2790903	3442461	3690720	3881788	4444568	4968120	5851167	6329905	6550158	7330339	8041760	8852268	9822707	10808409	11426821	11862836	12372767	12890399	13279020	13776175	13982817	14070031	14189350	14348613\nG	39	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nG	39	9505	81289	463310	647216	847436	1103343	1371799	1733426	2131695	2267631	2572452	3004012	3821327	3936831	4347600	4813178	5219473	6127247	6520762	6942094	7820976	8455081	9222832	10054363	10815281	11518569	12333038	12712073	13150161	13630838	13983873	14189914	14283341	14338027\nG	40	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	40	23850	85968	491190	610763	856691	1118463	1563272	1970356	2288043	2412826	2758541	3368083	3907292	4270597	4398198	5494006	6061272	6672862	6955890	7649652	8561288	8939616	10233513	10871785	11542375	11976449	12378749	13003256	13566773	13741899	14021503	14123936	14170456	14221305	14262605\nG	41	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	41	10436	93884	538453	668610	1028805	1225164	1707464	2152513	2493402	2689568	3066845	3355966	4253691	4536011	4983014	5453765	6184180	6989647	7885974	8084109	9157946	9791004	10122948	11740248	12259187	12697543	12959509	13195139	13647634	13836034	14014472	14096836	14129625	14203107	14226136\nG	42	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nG	42	4307	105303	484204	725468	1018777	1447816	1594332	2111134	2689902	2897326	3216628	3724847	4669288	4850490	5225769	5849598	6631475	7572309	8028135	8349739	9420300	10213857	11338093	11918213	12373509	12745200	13055726	13236053	13687135	13875642	13933884	14027962	14074268	14127131\nG	43	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	43	20779	111823	509547	764609	1068575	1398041	1528495	2092027	2751141	2892661	3173433	3909612	4382798	5238318	5356624	5857144	6277601	7712776	8077595	8291045	9181359	10523419	11228226	11828222	12127910	12652068	12885317	13318667	13662691	13821856	13914143	14001992	14034598	14087473	14149194\nC	0	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nC	0	18039	50932	86569	161183	202356	290207	325148	356974	390533	443968	482957	489973	511037	549663	583569	614854	658015	721926	760369	796842	848224	913582	949213	999659	1110581	1170753	1305289	5135773	7284492	9466054	12452076	14179431	14287848	14313875	14353141\nC	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nC	1	16139	42886	83207	171869	228672	338013	382213	421915	467971	542466	597460	603825	628996	677900	725427	769131	826249	919668	965525	1013310	1074188	1160583	1210429	1261978	1387502	1448306	1584471	5325446	7423001	9600505	12964684	14686350	14795032	14816174	14859713\nC	2	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nC	2	40281	73362	91414	201249	267319	325100	373533	427425	489751	553385	608904	677444	718449	776229	833809	892723	955684	1006692	1071090	1110973	1150388	1235672	1277563	1365247	1475600	1567820	1658221	5520005	7228740	9355552	12841054	14399808	14410145	14453580	14472444\nC	3	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	35	36\nC	3	21479	37059	66716	176163	275757	312446	376855	440808	491209	548674	595379	641617	713225	743023	807736	843743	880808	946445	989492	1082366	1177178	1238837	1273894	1309556	1377235	1454251	1511209	3394149	7209114	9320347	12650692	14443948	14489309	14545870\nC	4	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	33	34	35	36\nC	4	25689	63260	106449	196105	267799	328510	355295	416816	481452	518939	580327	636196	691689	709962	760580	837412	870279	925859	957375	1040925	1103639	1104985	1183361	1290153	1349859	1459693	1566117	1710258	5136394	9218962	14156176	14187771	14230982	14264339\nC	5	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	5	22265	56361	112579	190811	289672	358770	441246	516173	559687	620415	673030	699761	756522	841313	871426	899201	979520	1075338	1132824	1237983	1265333	1342006	1457891	1534508	1575825	1818606	2080115	2187131	7993046	10365719	10509056	10719159	14685640	14906059	14968981	15020322\nC	6	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	37\nC	6	35336	41336	90128	207999	265117	323897	388160	480482	509839	549128	614817	652391	661589	738557	814738	874699	926843	978165	1037417	1090224	1151508	1225195	1294544	1354537	1520926	1570736	1681086	1900922	2312426	7827884	10065247	11736391	13389186	14558907	14607776\nC	7	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	7	27815	47366	93705	205292	293509	343304	426569	493687	529903	574092	628333	677331	732214	789510	855634	910219	952601	1010508	1066224	1109919	1187447	1269720	1385911	1417928	1442973	1571908	1694123	1794468	3676980	7641031	10053598	10126521	11885209	14708940	14740938	14817298\nC	8	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	37\nC	8	26711	31426	57054	199194	307482	338537	410966	513677	536677	601556	652892	722704	741057	808244	920250	935520	1004871	1039672	1151219	1175602	1238923	1274365	1393700	1444732	1518334	1686126	1794322	1863135	2163426	7973072	10348533	10686097	13524752	15067839	15106901\nC	9	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	9	18718	23059	107627	173177	292399	336034	403020	503169	553466	603744	631939	680233	756247	785223	901588	923331	1002150	1037586	1096526	1201501	1264575	1294185	1391252	1463875	1549853	1652689	1690930	1935144	2102236	7875383	10092214	10549975	11882913	14692506	14743673	15144768\nC	10	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	10	20758	38450	76300	136539	259602	344174	371926	487279	493970	522146	659475	670814	712134	787082	820208	859837	947254	1015675	1098317	1183316	1254451	1308132	1438097	1496619	1580552	1639311	1846563	2016434	2225971	4679582	6597667	10730371	13259781	14740799	14768158	15055998\nC	11	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	11	27431	33747	78643	174658	322421	363099	397970	480293	549473	588906	633192	715152	754240	838703	870005	913873	1004041	1127250	1201385	1259404	1329048	1400815	1552786	1659632	1728703	1802146	1948802	2106898	2359620	4676571	8142487	10674500	11925451	13505412	14272785	15109732\nC	12	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	12	16410	32274	55110	179545	283689	401690	468398	496228	609742	633090	657649	764190	829925	880098	953981	986730	1022797	1089211	1231170	1306443	1415148	1487003	1553155	1682851	1837780	1909524	2008667	2127484	2432915	2697565	8613271	10913110	11612110	13454631	14812532	15126989\nC	13	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	13	25982	35524	89564	205876	260306	394634	461045	537081	629321	666843	719019	793230	813434	896938	930292	980631	1017851	1081178	1132278	1246157	1330481	1479332	1602629	1738048	1934070	2047669	2230891	2411392	2815619	2953700	6990830	10882598	12607077	13600573	14809910	15181199\nC	14	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nC	14	15585	31750	93285	184654	297562	388136	476556	534182	565035	713851	760097	773448	811786	895477	1019447	1035252	1091070	1104795	1255464	1416041	1448117	1535741	1640848	1763948	1911710	2048472	2171088	2519414	3004786	3495318	7565963	9915794	11993632	13623461	14607125	15054063	15223262\nC	15	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nC	15	14597	35371	105964	268464	407500	458342	479481	525116	590635	698627	794046	819109	870544	942714	1032847	1073058	1136076	1227506	1369027	1449012	1650870	1720722	1774765	1984078	2140845	2300677	2437707	2690931	2912641	3231028	9504220	11784558	13350687	14086401	15089803	15147844\nC	16	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nC	16	5717	11018	42513	96833	293071	322149	525719	539619	577431	699976	750445	829684	911737	950039	1022089	1104392	1221621	1324921	1417774	1449832	1634794	1806160	1989185	2077169	2172613	2341887	2462745	3172644	3599604	4202013	8048156	10196301	12431578	13543489	13827097	14854840	15090099\nC	17	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nC	17	10474	33828	180440	311426	398097	545212	602591	637980	655836	798633	884460	922943	965070	1104273	1138257	1187184	1308544	1377039	1431340	1504693	1628261	1954190	2054951	2206827	2452098	2712805	3157706	3625220	4690401	7088768	9333048	12992385	13618529	14325732	14822469	15208358\nC	18	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nC	18	14511	31941	168056	249551	464338	493416	548662	699290	759646	769939	850549	1045606	1064810	1094868	1174567	1247069	1370446	1573095	1652856	1817446	1964750	2050197	2357255	2679669	2988522	3668557	3803965	4187622	4857832	6160625	9932466	11596565	13920542	14345372	15019056	15122816\nC	19	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nC	19	12079	23197	42617	143386	240862	485363	500824	542655	724196	756442	799612	813337	1058249	1091704	1110498	1258000	1312491	1376499	1496542	1638532	1755086	1924121	2160510	2180467	2455058	2782062	3161621	3581431	4110510	4915702	5298448	8873446	11177016	13395014	14232281	14992176	15252233\nC	20	4	5	6	7	8	9	10	11	12	13	14	15	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nC	20	19846	84758	247734	320656	500538	611690	781157	792108	812591	922027	1084309	1155657	1297379	1370238	1528606	1589968	1675498	1791185	2054564	2217099	2374625	2566590	3036298	3148513	3424222	4029912	5085976	5804398	8174164	12412208	13272792	14312357	14947488	15140637\nC	21	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nC	21	2341	8020	41044	134211	248608	447317	572265	615103	790060	895016	918527	958547	1193224	1229111	1332365	1350962	1595524	1631039	1716212	1904246	2020984	2157379	2373072	2697419	2972826	3260750	3652352	4110895	4729759	5471355	7889770	10399777	12758384	13823190	14525719	14966290	15112602\nC	22	2	4	5	6	7	8	9	10	11	12	13	14	15	16	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nC	22	2637	35033	165243	261464	398530	605288	648642	747857	903248	955975	984912	1014436	1266573	1353359	1448428	1602603	1683313	1933627	1998332	2090812	2278773	2410918	2783140	3046915	3276448	3739089	4538108	4897436	5961740	9784825	12834377	13825116	14649543	14971671	15179538\nC	23	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nC	23	6677	41839	105655	293556	413504	592744	658384	718691	883769	1007102	1065515	1104551	1136537	1368313	1504803	1577370	1696417	1754080	1998315	2102449	2267343	2603365	2913130	3241453	3732645	4168031	4838711	5467428	5971740	7007142	10361864	12957854	13641329	14337697	14646343	15115730\nC	24	2	4	5	6	7	8	9	10	11	12	13	14	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nC	24	9044	33261	136729	280213	425818	542802	711951	718359	795521	1035282	1094694	1156179	1319268	1468451	1598868	1698416	1854019	1983286	2122878	2365066	2585563	2873140	3328664	3525796	3860408	4567368	5189480	5898358	6801497	9984897	12422816	13448636	14299625	14917459	15160845\nC	25	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nC	25	4978	46196	191937	337019	483438	661754	729158	795230	910241	1132622	1147269	1199020	1269770	1392426	1595331	1711517	1756216	1989680	2172023	2365349	2633490	2826443	3039308	3372425	3669019	4059653	4490142	5374178	6576987	9198816	10164755	13080386	14299540	14659779	15047757	15097010\nC	26	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nC	26	3767	36583	141745	360219	487977	624683	791077	846444	960585	999079	1196370	1251266	1307223	1380965	1791236	1799716	1872466	2117457	2287712	2614695	2787065	2969934	3378582	3684589	4060705	4343678	4984610	5790733	6555949	8587290	11022482	12770644	13826152	14744827	15024710	15133729\nC	27	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nC	27	4216	52007	140932	376426	519713	661039	837938	861298	946210	1171976	1305830	1341209	1412748	1625671	1687382	1978824	2065154	2218228	2374548	2598815	2753641	3180420	3550010	3932823	4470804	5208302	5971217	7137855	7870657	8483890	10337813	13005293	13996541	14318793	14936301	15097291\nC	28	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39\nC	28	8443	28244	83539	334255	412951	675482	824187	922171	1013986	1153552	1273538	1467789	1529565	1603742	1830932	2132445	2220964	2297923	2708370	2983847	3242106	3564572	4038158	4306342	4775997	5411476	6283695	7273061	7979213	8451778	10684866	12983368	13481929	14344827	14737040	14906595	15015596	15060144\nC	29	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nC	29	26341	91074	376011	506788	663234	896811	983578	1094184	1134295	1276190	1582741	1602975	1715427	1817675	2160983	2392592	2476240	2850539	3063545	3326955	3787775	4096785	4528695	5102901	5693942	6487622	7380595	8335152	9331754	11122373	12602269	13896198	14424085	14971353	15070826	15120113\nC	30	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nC	30	6251	8667	89154	357728	486209	704065	825492	1034007	1082612	1149678	1327575	1620098	1686867	1748047	1822214	2108046	2534388	2608464	2909806	3081058	3266961	3685566	4117860	4412205	5340886	5913600	6829182	7829562	8847457	9016469	11516303	13605619	14520838	14680871	14732871	15017093	15100195\nC	31	2	4	5	6	7	8	9	10	11	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nC	31	10057	88620	357358	546148	677928	920366	1063280	1188393	1310823	1649978	1878193	1974932	2044116	2314153	2599539	2954548	3103676	3518096	3760165	4251142	4805372	5314385	5692094	6427419	6996190	7926245	8962978	10120265	12345255	12910128	14146093	14480737	14778492	15001603	15060970\nC	32	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nC	32	19172	97687	298608	548519	674670	854003	1061909	1272425	1369289	1474347	1644228	2032888	2155430	2205377	2397651	2715293	2879647	3488336	3734307	4155667	4645990	4857334	5429532	6240782	6824518	7568291	8237900	9104109	9953529	11586137	13624854	13867634	14545591	14721388	14970224	15004162\nC	33	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	33	112610	489300	608561	748051	992106	1176463	1406138	1448653	1604116	1859118	2347530	2366885	2555718	2618472	3106033	3740390	3999594	4320972	4884716	5391696	5776331	6428183	6981984	7332247	8812714	9948166	11044767	12033052	13766008	13961895	14270864	14607445	14863315	14952089\nC	34	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nC	34	17675	28743	153623	469491	658845	810817	1068842	1207125	1505444	1567357	1718854	1987496	2189846	2503988	2625477	2728434	3259901	3358468	4305400	4517549	4927957	5300814	6181499	6700033	7666196	8484090	9073242	10069029	11199501	11704072	14011977	14380004	14545895	14796854	14978950	15043153	15056043\nC	35	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nC	35	27863	168333	513376	716713	951459	1026791	1378733	1645209	1713798	1869222	2185290	2415136	2773936	2918142	3033065	3624208	4013443	4851196	4963886	5701480	6177935	6837123	7581151	8391330	9000440	10022579	10699527	11809751	12693494	13834728	14170499	14434240	14611794	14722563	14892209	14912308\nC	36	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nC	36	36889	136539	661987	785483	967650	1125754	1436476	1686868	1873642	1894440	2385228	2623644	3021378	3171825	3423055	3907969	4317091	5216415	5370868	6447623	6855928	7362968	8191704	9079163	9554602	10518273	11265005	11843126	13040163	13654415	14345448	14525179	14678741	14787969	14814434	14957833\nC	37	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	37	42619	112141	734803	870175	1161211	1243941	1579430	1835155	2033841	2275738	2667658	3190896	3437296	3548384	3704316	4330704	5279577	5754371	6172190	6911746	7668373	8602970	9048625	10033249	10973055	11587466	12574933	13026564	13646060	14391869	14465337	14622196	14776964	14815177	14897033\nC	38	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	38	29760	49970	129118	691780	890536	1176144	1363968	1728259	2160639	2229876	2356404	2582018	3048528	3709599	3932127	4129042	4729914	5251871	6355218	6917414	7155494	8029167	8838548	9747298	10724672	11799084	12386705	12793116	13174163	13681411	13967081	14485089	14593989	14647700	14724941	14869490\nC	39	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nC	39	31939	144632	710485	959010	1231974	1475354	1714176	2075194	2443988	2556625	2866198	3303667	4141600	4249366	4675257	5204975	5642883	6741703	7182936	7661381	8658362	9392539	10249880	11133099	11894680	12459134	13208258	13602789	13924418	14396719	14700106	14805051	14878425	14902591\nC	40	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	40	64469	160866	855134	966097	1265697	1519498	1948636	2391496	2644831	2737982	3079146	3794683	4279259	4644889	4765360	5985472	6564041	7394235	7711647	8505684	9490972	9930583	11293589	11878660	12499472	12886880	13281008	13811584	14383066	14481575	14634238	14717000	14757524	14784441	14819059\nC	41	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	41	41684	178598	940831	1064400	1495123	1674551	2145437	2631391	2907925	3079180	3459342	3805653	4722436	4998397	5476020	5986846	6799904	7822871	8831859	9055543	10193857	10906564	11177078	12720256	13196876	13539821	13806892	13981850	14381894	14512724	14663966	14733419	14755312	14780883	14798668\nC	42	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nC	42	12860	198817	869601	1152290	1509939	1915836	2030426	2594073	3121586	3305226	3639847	4182173	5167169	5368556	5758759	6433371	7261787	8487068	8978550	9360925	10483174	11268989	12330095	12932981	13389523	13640923	13956359	14107618	14472774	14583906	14622078	14677602	14694331	14725143\nC	43	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	43	40225	219659	931277	1228919	1606415	1917484	2031852	2621944	3240581	3358329	3618126	4434205	4915621	5835015	5971814	6497172	6956113	8647257	9047969	9279907	10253875	11428203	12158176	12804810	13080696	13560959	13734133	14109820	14435450	14518262	14563246	14622290	14632211	14674251	14708210\nN	0	2	5	20\nN	0	103249	150387	226149\nN	1	2	5	20\nN	1	132688	206002	287301\nN	2	2	3	4	5	6	20	23\nN	2	32047	84168	125794	167897	200149	256101	301220\nN	3	2	3	5	7	20	22\nN	3	42405	74763	128552	203212	258349	304995\nN	4	2	4	5	20\nN	4	136689	209284	264499	305284\nN	5	2	3	5	11	20	22\nN	5	86571	128923	176573	205510	245184	296087\nN	6	2	3	6	20\nN	6	88547	121198	211835	294131\nN	7	3	5	20	22\nN	7	129748	163830	255958	304798\nN	8	2	4	6	20\nN	8	82731	156182	209853	303685\nN	9	2	3	4	5	6	20\nN	9	31953	72141	163823	211184	267542	305385\nN	10	2	3	4	5	22\nN	10	27177	242132	300768	335743	430797\nN	11	2	5	7	20\nN	11	127869	172953	287618	327287\nN	12	2	3	5\nN	12	108577	271809	386839\nN	13	2	3	4	22\nN	13	118215	183691	309051	347483\nN	14	2	4	5	6	24\nN	14	128042	250740	278591	320036	376083\nN	15	4	5	6	7	9	23	24\nN	15	41356	64054	96457	138865	191017	260959	320878\nN	16	2	4	6	9	10\nN	16	68962	99783	218031	279229	332013\nN	17	2	5	6	9\nN	17	138369	247246	299226	339627\nN	18	2	5	6	7\nN	18	196581	257905	437873	479649\nN	19	2	5	6	7\nN	19	140674	172696	266975	355939\nN	20	5	6	7	9	13\nN	20	92261	189520	259489	313028	351905\nN	21	2	3	4	6\nN	21	71841	160495	215693	461654\nN	22	2	5	6	7	12\nN	22	67271	96479	203397	320186	359141\nN	23	2	4	6	8\nN	23	69227	110901	403851	457498\nN	24	2	4	5	6	7\nN	24	115744	167038	226658	292839	341544\nN	25	2	5	6	7\nN	25	114343	234599	324942	378057\nN	26	2	5	6\nN	26	66939	223060	460778\nN	27	3	5	6	7\nN	27	64797	148956	304173	356484\nN	28	2	3	5	6\nN	28	42324	107162	287296	336092\nN	29	2	4	5	6\nN	29	39951	107837	270718	333933\nN	30	2	3	4	5	6\nN	30	64183	104405	265290	382129	436861\nN	31	2	5	6\nN	31	108007	299071	350366\nN	32	2	4	5	6\nN	32	69273	110552	299281	426257\nN	33	4	5	6\nN	33	111474	384888	440648\nN	34	2	3	5	6\nN	34	38622	107936	313576	359585\nN	35	2	4	5	6\nN	35	74931	111354	433266	457545\nN	36	2	5\nN	36	113642	336394\nN	37	2	5\nN	37	108129	369488\nN	38	2	3	5	6\nN	38	36160	110639	271660	324971\nN	39	2	5	6\nN	39	114785	247585	329811\nN	40	2	5\nN	40	103416	467903\nN	41	2	5\nN	41	106994	354983\nN	42	2	4	5	6\nN	42	35459	103335	386046	417426\nN	43	4	5	6\nN	43	104452	397675	430807"
#define QUAL_DIST_TWO44 ".	0	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	26	27	28	29	30	31	32	34	35\n.	0	77034	90389	156882	216994	369038	421292	554772	561283	659949	729973	758421	880149	1103459	1122957	1165256	1190910	1281622	1361618	1621770	1657792	1923995	2049928	2143423	2432383	2538265	2852646	3230695	12876012	21669241	29964189	30096345	30226613\n.	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	26	27	28	29	30	31	32	34	35\n.	1	74110	86563	156072	218376	375162	426009	566467	573070	675248	749177	777894	906041	1156286	1175241	1216876	1242203	1345639	1440708	1741218	1776128	2079613	2230521	2347729	2709923	2843991	3239208	3663884	13348867	22135191	29938725	30077376	30226613\n.	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	34\n.	2	56542	114912	278908	425966	501998	642682	680721	816512	837180	916403	1000360	1059181	1094383	1270214	1281341	1495619	1661423	1807019	1834349	2035028	2121395	2226418	2522547	2882613	2895895	3014168	3373378	3927046	22385713	30103573	30226613\n.	3	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	29	30	31	32	33	34	36\n.	3	61852	97378	118102	171893	483797	530559	620589	734462	830193	928965	968678	995695	1165520	1297273	1343181	1418401	1511526	1616188	1741501	1968486	2063444	2218643	2430174	2438794	2518529	2806003	2924070	3122486	21866708	29373686	29483803	29857419	30226613\n.	4	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	36\n.	4	135379	160516	320008	465614	485333	680768	726717	755513	849053	992792	1045489	1151380	1313562	1516020	1551783	1735229	1829964	1862166	2016942	2106254	2308125	2326679	2933000	3080033	3428347	3645807	3758786	12599554	22756656	22769655	30099723	30226613\n.	5	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	35	37\n.	5	39862	105402	129325	393465	428649	598204	668907	677679	748297	787342	934566	1041567	1249152	1293642	1326774	1534999	1660910	1913867	2076856	2213227	2353751	2365205	2676545	2775907	3137739	3276721	3863722	4413928	13242019	22937388	29482716	29929958	30226613\n.	6	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	28	29	30	31	32	33	34	35	37\n.	6	95171	147189	274462	533762	684099	715505	835324	868113	1022509	1143568	1339311	1382351	1503104	1538861	1686313	1895162	1924930	2056158	2178056	2436038	2717780	2767802	3066445	3345852	3795857	4092031	4664271	13349367	23442031	23453308	23583710	30079819	30226613\n.	7	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	30	31	32	33	34	35	37\n.	7	136831	149980	207083	224817	474557	566534	603086	742096	851300	952426	977064	987743	1176332	1284309	1310636	1364275	1415720	1606344	1924961	2071606	2276526	2550870	2605157	2781482	2987862	3487978	3645272	3835494	4001706	12750881	22750129	28883488	29896401	30226613\n.	8	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	31	32	33	34	35	37\n.	8	8126	22320	50617	150783	575721	613331	643169	812071	950428	989550	1048486	1143726	1190222	1288138	1407245	1586413	1639416	1677813	1934412	2376635	2397724	2534923	2676693	2845295	3118497	3446743	3648780	4198886	5059569	23118280	23482754	29210785	30064303	30226613\n.	9	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	37\n.	9	245025	274961	438159	524435	703869	779712	953226	966275	995114	1128181	1193780	1390514	1450317	1586556	1637564	1676530	1907870	2078136	2272053	2413497	2463017	2747449	3031424	3287611	3636483	3950637	4233915	4988341	5101908	22813102	23553951	28861035	29843606	30226613\n.	10	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	28	29	30	31	32	33	34	35	36	37\n.	10	23341	126156	186187	641359	658958	691497	752941	939574	1020921	1106893	1141801	1188199	1378554	1435609	1605818	1687090	1752956	2027119	2280494	2499704	2750747	2909602	3083074	3428642	3718045	4219850	4583375	5055798	14653258	23315345	28751858	29154838	29682707	30226613\n.	11	3	4	5	6	7	8	9	10	11	12	13	14	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	11	15409	92080	141818	446842	779817	811683	827526	898691	1116254	1174483	1190689	1408405	1632121	1716351	1856924	1895523	1952815	2049924	2525787	2557117	2889512	3062415	3150359	3479722	3804139	4182216	5243000	5925454	15295721	23766135	28917421	29457209	29797129	30226613\n.	12	3	4	5	6	7	8	9	10	11	13	14	15	16	17	18	19	20	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	12	203419	238007	399620	531584	626623	809666	885831	1085922	1193607	1336500	1399819	1437756	1602584	1759215	2011005	2067825	2449906	2536968	2780376	3036761	3578071	3654555	3788018	3996916	4992358	5221890	5982118	14384065	23660744	25351931	29214724	30014135	30226613\n.	13	3	4	5	6	7	8	9	10	11	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\n.	13	99053	128025	303337	447364	533210	745624	907577	988839	1199294	1254349	1322224	1579561	1623760	1709766	1907257	2097636	2175551	2561151	2597968	2762426	3306443	3570784	3886259	3988887	4332859	4787972	5229073	5589372	6280288	14952019	26813921	27650139	28832790	29196339	30226613\n.	14	3	5	6	7	8	9	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\n.	14	21967	221110	397740	628785	810889	877282	1151140	1193768	1267372	1376932	1486087	1673348	1762158	1913257	2044264	2115797	2518133	2828429	3010253	3288678	3618342	4112067	4470936	4811375	5396572	6588923	7227974	8080291	16495616	24939106	26169560	29395595	29989063	30226613\n.	15	4	5	6	7	8	9	10	11	12	14	15	16	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\n.	15	35311	113368	421974	584938	681514	873092	984265	1057636	1300627	1428609	1524809	1767723	1933193	2038434	2082909	2510529	2885991	2979170	3247643	3463161	3556106	3920595	4836402	5895700	6412190	6780601	7387519	16039181	26660155	28597240	29570752	29967352	30226613\n.	16	3	4	5	6	7	8	9	10	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\n.	16	35987	177625	261174	440315	594142	729522	931798	986976	1158646	1473609	1501030	1533088	1798431	1878042	2014564	2187896	2292702	2478065	2773278	2848811	3618528	3742698	4068239	4238475	4841776	5205172	6220051	7872404	8284956	9452823	24054848	25587186	26105702	29659706	30226613\n.	17	2	4	5	6	7	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\n.	17	14224	155726	274142	416717	751548	1082918	1117086	1143874	1207452	1510027	1579565	1653719	1691583	1957720	2176811	2315747	2431097	2663474	2939603	3703759	3903547	4006075	4439435	4622352	4858470	5794383	6451014	7703489	8302653	23317063	25085344	25561775	26789141	29975717	30226613\n.	18	2	4	5	6	7	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	18	117564	148435	375424	470488	822700	1160869	1190920	1221914	1333556	1675165	1720024	1804531	1996663	2035815	2187076	2419160	2672949	3045244	3172683	3382266	3535454	4614169	4665486	4969700	5699818	7567319	7939659	8751277	8983598	10082678	24977796	26079054	27504194	30226613\n.	19	2	4	5	6	7	8	9	10	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\n.	19	82060	160031	386834	547012	623939	852763	956436	1237266	1270601	1386690	1749141	1885210	1926508	2252538	2483301	2526562	2765542	2929299	3080694	3347983	3687467	4513586	4765048	5297935	6120508	6258606	6995685	7487952	9286148	9930932	25152544	26029171	28147830	29925397	30226613\n.	20	3	5	6	7	9	10	11	12	13	14	15	16	17	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	20	211653	406898	511363	915049	993924	1061980	1407350	1445068	1492741	1573667	1939979	1997685	2086464	2501038	2787912	2947068	3061249	3637016	3858092	4194209	4613483	4738723	5341143	6794161	7732233	8996502	11456338	17482241	25278993	27858061	28972849	30226613\n.	21	2	3	4	5	6	7	8	10	11	12	13	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\n.	21	132007	212916	272064	426271	540785	913352	984433	1147588	1432966	1515434	1618097	2051546	2228939	2277987	2483987	2541222	2864199	3374828	3731297	3801182	3997601	4365119	5188715	5566093	5786137	7844188	8532481	9609690	10202025	12441182	25641126	27055098	28589778	29923948	30226613\n.	22	2	4	5	6	7	8	10	11	12	13	14	16	17	18	19	20	21	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\n.	22	136761	179516	367865	490204	573333	1050516	1184964	1490214	1577879	1678394	1736979	2275824	2347958	2462610	2692198	3114798	3505224	3818737	4291581	4382716	4899627	5524213	6037498	7965231	8802578	9863452	11275591	13122495	25739669	26966582	29135291	29991745	30226613\n.	23	3	4	5	6	8	9	11	12	14	15	16	17	18	19	20	22	23	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	23	213006	239065	328356	608121	1139292	1186343	1341624	1727615	1845160	1913333	2110642	2658396	2744457	2822691	3388574	3687910	4565826	5281571	5651867	6146059	7368284	8696986	10741461	11307784	12222984	14516469	25250187	27322964	29102889	30226613\n.	24	3	4	5	6	8	9	11	12	13	14	15	16	17	18	19	20	21	22	23	24	26	27	28	29	30	31	32	33	34	35	36	37	38\n.	24	86991	186135	350576	656931	986584	1237577	1409679	1823542	1881060	2013579	2149477	2229178	2394190	2947463	3116877	3166039	3623725	3858781	4483321	5126116	5863948	6105048	6840421	8553418	10640688	11324731	12125626	14824640	25926722	27743847	29083618	29533122	30226613\n.	25	4	5	6	8	9	11	12	13	15	16	17	18	19	20	21	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\n.	25	59235	356088	717085	1079284	1352908	1410258	1605923	2064226	2214813	2460189	2962259	3049053	3256503	3413752	4200837	4423392	5375462	5990491	6430022	7456837	7809869	9230557	9598374	10992674	14336387	15943199	22761105	26849404	28502114	29563971	30226613\n.	26	5	6	7	8	9	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\n.	26	291334	566036	755502	1035795	1439205	1499935	1716351	2139391	2209430	2376712	2546067	2649238	3408684	3509418	3704092	3810909	4119412	4828451	4946692	5837084	6835399	7207969	7615115	9100201	9394010	11786469	13587489	18923118	21075697	26531275	28587546	29984646	30226613\n.	27	4	5	6	7	8	9	11	12	14	15	16	17	18	19	20	21	22	23	24	25	27	28	29	30	31	32	33	34	35	36	37	38\n.	27	231410	405859	610421	819076	1119226	1246308	1628223	1867653	2401438	2499509	2587148	2782881	3273868	3867669	3936047	4052092	5030117	5478297	5781157	6778733	7963651	8909097	9611824	11910377	14165551	15018617	20741179	22233425	27118697	28794783	29970662	30226613\n.	28	4	5	6	7	8	9	10	12	13	14	15	16	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	28	270469	434608	884106	1069350	1352770	1693999	1771276	2036890	2623689	2721749	2959580	3321274	4139669	4388906	4466418	4989337	5546595	6119644	6509986	7461784	8290937	9224632	10093081	12256397	15067028	15828609	18997096	26851401	27800293	28403594	29120356	30226613\n.	29	4	5	6	8	9	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\n.	29	299516	464389	956682	1472317	1838910	1925410	2224079	2325164	2862998	3098028	3342543	3486526	3784146	4641952	4909542	5634560	5797864	6497175	6664278	8114376	8894743	10793344	11075959	12621240	15616450	17040612	18735982	21895809	26666095	27637831	29346075	29941317	30226613\n.	30	4	6	8	9	10	12	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	30	490140	1031550	1251018	2000216	2097538	2433287	3133773	3399408	3560820	3837009	4019647	4952355	5411572	5749801	6710209	7346037	7986037	8987399	10347991	10714058	11861467	13469718	15878068	17245703	18971319	26177726	27465268	28324967	29725008	30226613\n.	31	4	5	6	8	9	10	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\n.	31	326223	539504	1143450	1383568	1788635	2329982	2450124	2725421	3496532	3636311	4114042	4305437	4473389	4687548	6064024	6440090	6627927	7693770	8570067	9364069	10852617	11394871	12944627	14691286	18041659	19053309	22611024	24722478	25649048	28223083	29115800	30047498	30226613\n.	32	4	5	6	8	9	10	11	13	14	15	17	19	20	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	32	341184	576930	1221781	1481019	1926226	2391281	2511155	2945695	3088446	4122401	4672107	5597643	6583242	7547433	7753612	9153414	9361277	11302852	12002636	13321124	14638896	16779174	19248510	21090023	24557417	28694188	29375220	30015305	30226613\n.	33	4	5	6	7	8	9	10	12	13	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	38\n.	33	360417	622164	1126510	1324355	1607359	1837263	2602285	2733768	3221059	4136764	4304601	4751709	5121977	5322157	5715243	7211504	8042091	9210618	9979155	10531397	11417522	13266582	14661580	16999902	18469714	20926091	22979445	25701981	28925500	29135289	29957019	30226613\n.	34	4	5	6	7	8	9	10	11	12	13	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\n.	34	210939	674598	1220968	1439570	1740505	1997760	2291357	2832984	2980079	3533657	4525744	4712450	4951919	5361714	5847826	5988385	7906526	8370161	8602716	9946567	11694381	12373654	14432585	15158255	17094339	18934098	20672982	24017849	26173023	27147261	28059043	29742625	30061246	30226613\n.	35	4	5	6	7	8	10	11	13	14	15	16	17	18	19	20	21	22	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	35	406599	740989	1108295	1575077	1904441	3113678	3276684	3454706	3647469	4090667	5189553	5458829	5904248	6201614	6591464	8319865	9156695	11313722	11923565	12125419	14117688	16650769	17925427	19602888	23037719	23680062	27943610	28532300	28917601	30078021	30226613\n.	36	4	5	6	7	8	10	11	12	14	15	16	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	36	435374	812167	1207615	1727788	2085528	2403336	3417062	3598783	3795319	5469960	5695154	6474768	7053836	7574711	9080194	9706711	10219969	11236550	12858106	14218468	15038269	18529096	19645294	20648850	23532733	25065856	25943817	28833448	29662088	30122278	30226613\n.	37	4	5	6	7	8	10	12	14	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	37	273847	886822	1307273	1875247	2263299	3714862	3910272	4661117	5940912	6502628	6849418	7362354	8182091	8837286	10160283	11211370	12772763	13842861	15549992	17202624	19469010	20080225	23696630	24623962	25197024	25898655	28485624	29831663	30127313	30226613\n.	38	4	5	6	7	8	10	11	12	13	15	16	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	38	507471	981975	1424303	2061120	2476931	2859442	4066638	4283986	4517817	5367516	6757100	7663333	8045828	8241909	10609300	11304904	12389961	13631075	14543351	17119530	18177770	20487562	22375459	23823868	24691132	26875886	27106370	28752696	28992103	29964744	30226613\n.	39	4	5	6	7	8	10	11	12	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\n.	39	553330	1088879	1559918	2271281	2719377	3140709	4466162	4703435	4956700	5892234	7107126	7775872	8353838	8764456	9267892	11312462	12180523	12711614	14921099	15335083	16597980	18899282	20975585	22036144	25231452	25816977	26636594	29101324	29453443	29892762	30226613\n.	40	4	5	6	7	8	10	11	13	14	15	16	18	19	20	21	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	40	598120	1196792	1693325	2083481	2955283	3417471	4848858	5107983	5383499	6385685	7983513	9004720	9433900	10262267	12993643	14143116	15775778	17688718	19658730	20592217	23397268	24360330	25515165	25934673	27470639	27994048	29357998	29752604	29994450	30226613\n.	41	4	5	6	7	8	10	11	12	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\n.	41	666534	1333284	1855163	2282913	3230837	3734946	5291309	5571558	5867345	6938873	7254858	8647797	9712673	10158133	10710434	13535402	14700383	15246083	16371766	17816573	19683980	22849847	24082461	25412238	26964723	28706381	29106742	29399866	29770191	30037531	30226613\n.	42	4	5	6	8	10	11	12	14	15	16	17	18	19	20	21	22	24	25	26	27	28	29	30	31	32	33	34	35	36\n.	42	723396	1120117	2011169	3503693	4045484	5728178	6027043	6340527	7485847	7815701	9304221	10417063	10885427	12238440	14378470	15835011	17591533	18742173	21921809	24012514	24951567	26294846	26951884	27805963	28055479	29636721	29981195	30171761	30226613\n.	43	4	5	6	8	11	13	15	17	18	19	20	21	22	24	25	26	27	28	29	30	31	32	33	34	35	36\n.	43	488064	1223418	2153936	3745825	6123907	6442173	7977945	11058604	11540897	11543026	13157617	13956511	16301086	17682890	19206032	21858542	23812647	24629159	26080446	27093646	27513804	28826877	29427716	29453961	29667458	30226613\nA	0	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	26	27	28	29	30	31	32	34	35\nA	0	12916	17452	34538	50451	90619	104069	138846	140402	166769	186433	193537	228452	295842	302506	315956	324182	355248	384844	455223	469300	527377	580985	618867	739972	785259	919601	1063191	3971959	6684544	8936650	8982192	9032874\nA	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	26	27	28	29	30	31	32	34	35\nA	1	12611	16572	35024	50791	93353	106231	144913	146577	175194	197644	204934	244093	327552	334067	347574	356055	394799	434022	528811	542601	623240	692504	745726	911665	973850	1156941	1326878	4312528	7058358	9338743	9388392	9448599\nA	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	34\nA	2	14912	28517	45368	83109	101844	138699	147935	184502	189457	211952	236685	253127	262569	317622	321601	393792	454566	463899	474479	553232	585824	629646	751599	897075	902126	949730	1090521	1308649	6908856	9060272	9108066\nA	3	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	29	30	31	32	33	34	36\nA	3	7768	16850	21746	34364	82538	93714	116050	144378	168353	193561	202895	210293	257438	292445	305474	328352	356693	390823	406594	481665	515459	571557	649280	651783	679886	786929	829889	904283	6326683	8295649	8336832	8463250	8592429\nA	4	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	36\nA	4	5702	11348	49547	85440	90123	132266	143052	149937	174064	211881	225108	253811	299866	360937	372391	434134	439041	448627	501129	533760	608822	614509	844423	898981	1030693	1113402	1157222	3792161	6796741	6800891	8760909	8808907\nA	5	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	35	37\nA	5	9515	18568	24629	90127	98193	141458	158340	160453	179055	188789	229272	259610	321320	334239	344590	416441	458038	479341	537326	586961	641458	644784	769024	807556	954882	1010602	1228838	1422807	4062810	6916156	8585429	8749689	8854975\nA	6	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	28	29	30	31	32	33	34	35	37\nA	6	15506	27359	58846	105218	144198	151502	181936	189802	231943	264397	321170	332882	369057	379166	425973	496353	505653	550756	595936	646023	751743	768086	880515	988559	1156409	1258613	1471849	4030368	6987680	6991603	7042589	8704314	8753646\nA	7	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	30	31	32	33	34	35	37\nA	7	4335	7964	20879	24936	87157	100860	109495	145944	173047	200080	206492	209256	263888	295209	302540	318213	334011	398553	478796	530066	604719	710557	730969	801910	882918	1083866	1134888	1210239	1274037	3884816	6845541	8381603	8753357	8870776\nA	8	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	31	32	33	34	35	37\nA	8	1672	5479	12217	34758	101098	109796	116718	159541	194361	204679	219667	245290	258331	285645	319625	374564	391533	402926	463578	616355	622907	671613	722092	784833	886480	1012354	1089165	1287745	1590243	6857549	6984912	8380332	8674628	8725247\nA	9	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	37\nA	9	10564	17616	46257	67674	113059	131499	176726	180191	187706	223466	241608	298667	316644	358896	375669	389177	465138	523745	593080	646268	664895	772841	885583	983760	1123512	1248533	1361000	1640507	1684102	6790816	7042964	8283297	8628816	8762120\nA	10	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	28	29	30	31	32	33	34	35	36	37\nA	10	4954	21606	34738	117978	121978	129758	144892	193778	216142	238459	247626	261274	316743	332597	385421	413063	433993	525976	615185	669133	760697	822042	883549	1018809	1130581	1321145	1461288	1642503	4507976	6962216	8263868	8405139	8587231	8749635\nA	11	3	4	5	6	7	8	9	10	11	12	13	14	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	11	3510	21285	32038	79267	132611	140297	144129	161462	219353	234181	238683	300056	365216	392967	437215	449900	467310	497112	665331	674791	796769	860264	892295	1018521	1145025	1286181	1676440	1910295	4675169	7079435	8334976	8486704	8612850	8759610\nA	12	3	4	5	6	7	8	9	10	11	13	14	15	16	17	18	19	20	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	12	2504	10922	40977	73780	95999	143402	161717	215711	244292	283342	302143	314182	362938	411222	491448	510004	642956	674270	763723	861885	1070438	1099467	1152046	1227103	1602356	1668786	1939086	4373866	7059977	7639406	8459380	8714090	8777779\nA	13	3	4	5	6	7	8	9	10	11	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nA	13	5253	11472	44798	80955	101278	156417	166982	187866	245822	260504	280076	354684	369098	394607	457805	520723	545680	682575	698642	754045	961981	1067031	1185663	1226402	1363583	1548130	1718296	1857803	2106284	4605466	7667540	7957671	8329183	8424406	8771456\nA	14	3	5	6	7	8	9	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nA	14	5519	43772	88007	114184	162470	178856	252503	263965	283993	314955	347013	402348	429948	478552	524150	548005	690832	804725	863794	939033	1066777	1267345	1400134	1511170	1687152	2123613	2372950	2691742	5073804	7457800	7875318	8525758	8699246	8769828\nA	15	4	5	6	7	8	9	10	11	12	14	15	16	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nA	15	8508	26152	63228	104310	127034	177399	184097	202469	268715	303514	328700	401303	451007	484877	498440	636414	769608	801854	900064	978219	1010890	1144759	1489053	1888223	2076803	2215035	2438987	4869889	7610946	8257765	8563452	8666897	8745138\nA	16	3	4	5	6	7	8	9	10	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nA	16	7855	14625	33329	66935	106069	138480	191868	205357	228483	315036	323276	334282	410916	434918	476496	532360	563789	624704	732855	757925	1035771	1082084	1210446	1276243	1510755	1647781	2029684	2608095	2760923	3122937	7086712	7600134	7754881	8548981	8730996\nA	17	2	4	5	6	7	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nA	17	3048	8904	36051	60917	124789	209289	217506	224503	240904	326199	345145	366117	380049	457356	527560	575348	611292	685252	785344	1060082	1138823	1182680	1338110	1409111	1504188	1855372	2081186	2532328	2751217	6793416	7389995	7561190	7967244	8667351	8737036\nA	18	2	4	5	6	7	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	18	604	8001	39689	53869	141323	228287	236026	244107	271440	368871	379666	402756	461350	474343	516691	586940	668753	793752	835258	913250	967489	1354167	1374333	1488772	1752113	2405905	2554494	2848716	2933585	3249418	7385197	7732602	8140585	8735989\nA	19	2	4	5	6	7	8	9	10	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nA	19	338	18346	42457	73413	92650	150791	176052	250377	259265	289870	393068	431970	445367	544227	618862	633394	705750	770037	825717	919003	1039137	1338066	1438495	1643595	1950279	2000330	2287759	2471136	3090633	3303399	7392218	7624675	8290921	8619618	8707404\nA	20	3	5	6	7	9	10	11	12	13	14	15	16	17	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	20	1261	45648	63124	165114	184345	201968	294195	304797	317383	341823	445869	461864	491197	620210	711303	761027	805000	997456	1080360	1214731	1385732	1430747	1645597	2186300	2537664	2987610	3858338	5382564	7400711	8058748	8387124	8727252\nA	21	2	3	4	5	6	7	8	10	11	12	13	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nA	21	1031	1531	15448	50469	70709	166901	183989	225291	302356	325297	352111	478724	531304	547293	611611	632307	736041	904354	1022379	1050519	1124535	1269712	1577767	1719255	1803404	2546661	2799918	3166660	3358114	4104495	7400830	7828251	8230796	8642861	8727066\nA	22	2	4	5	6	7	8	10	11	12	13	14	16	17	18	19	20	21	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nA	22	1222	11314	54338	76948	96276	200096	234306	316561	340137	367991	384057	541597	562795	601159	675002	805959	939247	1051135	1214295	1252270	1460327	1685966	1881364	2578132	2885240	3258345	3747049	4370601	7450310	7826452	8431545	8657534	8716311\nA	23	3	4	5	6	8	9	11	12	14	15	16	17	18	19	20	22	23	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	23	2043	7966	28825	87623	224969	237156	276543	382468	415139	433210	492846	660747	685565	715407	888990	1000314	1311030	1557245	1702336	1898338	2343866	2812837	3519135	3716798	3994970	4727037	7333404	7965934	8405878	8723011\nA	24	3	4	5	6	8	9	11	12	13	14	15	16	17	18	19	20	21	22	23	24	26	27	28	29	30	31	32	33	34	35	36	37	38\nA	24	856	24286	32528	98292	181461	250607	294179	408721	425542	462947	508072	529608	581266	744835	808835	819617	976160	1049491	1279982	1494216	1767895	1870054	2153933	2773214	3511921	3726984	3992598	4875242	7584445	8025919	8411116	8522661	8731863\nA	25	4	5	6	8	9	11	12	13	15	16	17	18	19	20	21	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nA	25	14163	54571	111804	204955	281369	297111	349385	479570	523588	603339	755451	787602	857959	900028	1168313	1260331	1605427	1817553	1991063	2379628	2515131	3021177	3133113	3610342	4734213	5213866	6797979	7730073	8218482	8517341	8728856\nA	26	5	6	7	8	9	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nA	26	39759	84005	120848	194055	304015	321196	379956	497576	519989	570592	632155	661752	896197	935926	990356	1033804	1135181	1396354	1446051	1758508	2116530	2259777	2405491	2939296	3041627	3840597	4482270	5867770	6521012	7645193	8235226	8675517	8734086\nA	27	4	5	6	7	8	9	11	12	14	15	16	17	18	19	20	21	22	23	24	25	27	28	29	30	31	32	33	34	35	36	37	38\nA	27	4456	48040	97352	137412	219037	252452	359099	428871	580984	610873	640309	711402	879772	1055678	1070873	1116878	1463538	1638824	1767393	2125629	2548052	2885864	3162859	3937622	4659234	4935974	6242920	6688697	7834555	8312620	8663677	8726509\nA	28	4	5	6	7	8	9	10	12	13	14	15	16	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	28	34236	54358	154461	207971	282968	379583	402364	481307	650412	684502	759324	887961	1140021	1239217	1256757	1451627	1639359	1854437	2006623	2361751	2682269	3007270	3307040	4066171	5016584	5262064	6209976	7842893	8113358	8240539	8405937	8709231\nA	29	4	5	6	8	9	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nA	29	19222	61868	173866	316797	420752	446598	536716	570572	721430	799078	890563	937628	1045349	1317760	1400653	1676748	1744763	1975300	2045012	2559658	2869405	3521149	3593464	4109169	5108501	5561935	6112857	6812565	7782162	7995096	8432434	8608842	8680198\nA	30	4	6	8	9	10	12	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	30	70514	195604	261689	473829	503325	607093	813847	903497	957383	1060948	1123633	1420846	1579347	1717423	2040888	2289524	2538638	2886576	3369944	3515031	3913392	4450351	5241696	5649676	6159707	7649374	7987239	8176911	8572031	8676074\nA	31	4	5	6	8	9	10	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nA	31	25986	80077	220852	295015	402018	562977	602049	678520	907684	957627	1124304	1183309	1249082	1316875	1753895	1906940	1983924	2330334	2667431	2951728	3446184	3630267	4168837	4718986	5808030	6087295	6757940	7416203	7632428	8175389	8374114	8624417	8674397\nA	32	4	5	6	8	9	10	11	13	14	15	17	19	20	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	32	30918	93568	251996	332972	457305	596110	634132	769818	819924	1137790	1337572	1624759	1972332	2333612	2417731	2902485	2985842	3658400	3915977	4352713	4779404	5475895	6207957	6738129	7552524	8347811	8479758	8623699	8667600\nA	33	4	5	6	7	8	9	10	12	13	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	38\nA	33	35369	105438	231408	280987	371448	438733	663481	705652	857658	1136757	1198618	1342822	1486419	1565954	1686664	2181220	2480355	2877729	3167366	3369002	3675120	4298594	4734554	5505091	5905007	6680222	7264919	7842975	8364837	8399078	8602301	8664987\nA	34	4	5	6	7	8	9	10	11	12	13	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nA	34	32937	123115	261429	317998	415487	493467	573453	740054	788666	963184	1268037	1338124	1414054	1574298	1749139	1784775	2418527	2604199	2697149	3138352	3756260	3978201	4684951	4889454	5506109	6064571	6540159	7129236	7768631	7993144	8216431	8536675	8610610	8653202\nA	35	4	5	6	7	8	10	11	13	14	15	16	17	18	19	20	21	22	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	35	48942	141132	234819	358226	465269	825936	880723	943411	1013616	1146715	1487071	1571579	1745005	1841197	1973126	2539279	2848004	3590154	3804308	3873681	4523010	5348649	5666315	6157179	7180294	7346512	8107759	8247141	8333435	8592367	8618400\nA	36	4	5	6	7	8	10	11	12	14	15	16	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	36	56966	162191	266150	406009	525597	624097	929691	991201	1061106	1579007	1664338	1946610	2153232	2313672	2808640	3031972	3230727	3583066	4124467	4569613	4830835	5926236	6254082	6522845	7328754	7731220	7918884	8321959	8492078	8589501	8612434\nA	37	4	5	6	7	8	10	12	14	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	37	50830	187467	302509	460732	593985	1047373	1114701	1363144	1765076	1961711	2077652	2276108	2552985	2787258	3206296	3572387	4111779	4479427	5020835	5534251	6219569	6373972	7367764	7594413	7720706	7871996	8279902	8509816	8561717	8582430\nA	38	4	5	6	7	8	10	11	12	13	15	16	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	38	76974	214400	335838	514988	657595	782254	1153078	1229723	1314828	1597525	2037570	2366041	2491406	2543623	3337028	3580248	3932629	4337510	4653650	5450379	5797538	6482830	6969696	7365956	7549499	8031265	8071960	8252463	8291246	8506653	8557263\nA	39	4	5	6	7	8	10	11	12	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nA	39	89255	246364	381585	583555	742484	879985	1293786	1376942	1468445	1778796	2146244	2376160	2597578	2731545	2900759	3580083	3863342	4056289	4783511	4913725	5283401	5966017	6543989	6828195	7662459	7802281	7963201	8321760	8384147	8461121	8524693\nA	40	4	5	6	7	8	10	11	13	14	15	16	18	19	20	21	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	40	103319	280494	424185	537818	821053	974075	1423189	1515250	1615920	1948187	2455916	2819698	2958864	3247197	4131931	4513030	5037996	5624878	6208904	6487509	7227239	7463029	7723978	7805535	7975957	8072777	8336437	8420407	8467256	8511486\nA	41	4	5	6	7	8	10	11	12	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nA	41	120287	322992	480484	605813	926086	1094238	1594523	1693548	1801135	2160893	2279237	2704242	3082507	3228157	3412703	4323637	4706759	4897529	5234378	5659869	6219175	7049960	7367461	7672138	8006704	8195192	8263251	8313189	8380033	8428595	8459994\nA	42	4	5	6	8	10	11	12	14	15	16	17	18	19	20	21	22	24	25	26	27	28	29	30	31	32	33	34	35	36\nA	42	135818	262653	531367	1019888	1203245	1744012	1850707	1965441	2347287	2470619	2923376	3313365	3464215	3914879	4581537	5057505	5601718	5918187	6808228	7339486	7555837	7837634	7962840	8097221	8137690	8325992	8385329	8416281	8425934\nA	43	4	5	6	8	11	13	15	17	18	19	20	21	22	24	25	26	27	28	29	30	31	32	33	34	35	36\nA	43	59323	298427	584114	1119285	1906484	2020656	2544747	3559342	3714131	3714534	4213517	4479358	5225327	5648617	6086373	6776007	7293576	7474324	7790548	7959541	8031784	8179855	8274645	8278080	8313654	8407368\nT	0	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	26	27	28	29	30	31	32	34	35\nT	0	12219	15560	31580	44450	82536	95680	129581	131044	155966	173810	180872	210770	266313	271713	282108	288086	310162	329486	374266	383613	420962	450585	472208	537976	562078	633407	723387	3667130	6422952	8963394	8996537	9026787\nT	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	26	27	28	29	30	31	32	34	35\nT	1	12113	15168	31105	44667	83036	95576	130551	132095	157472	176076	183070	214399	276553	281714	291671	297567	322970	345837	398964	407878	452794	487109	513504	594523	623802	710989	810026	3476147	6003267	8230770	8264540	8298613\nT	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	34\nT	2	13878	29901	47956	86836	106818	145956	156302	193254	198317	220200	244173	259503	268609	319116	322433	381357	426183	434269	441708	495092	518138	545178	622467	715471	719184	749865	843302	988865	6235440	8526326	8558236\nT	3	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	29	30	31	32	33	34	36\nT	3	9584	18087	22848	37011	90745	103553	128353	159768	185241	213787	224333	232422	281101	318224	331933	353688	380017	410020	424768	489268	515941	559096	615765	617860	640143	718256	749455	803168	6210681	8418617	8447989	8549556	8648494\nT	4	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	36\nT	4	7068	13973	57775	99073	104202	152912	166475	175473	203216	246056	261845	293645	342206	402951	414529	472075	477789	488519	534602	560675	620191	624919	794126	835408	932674	993796	1025477	3694488	6640660	6645237	8845075	8880024\nT	5	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	35	37\nT	5	10218	20918	26957	97737	107720	152510	172166	174292	193192	204364	244443	274102	330324	344024	352953	410244	445033	462102	505463	542025	579188	582919	662120	688022	778718	812510	956381	1096590	3638674	6295619	8228878	8338803	8412560\nT	6	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	28	29	30	31	32	33	34	35	37\nT	6	18782	32141	66025	118087	158573	167275	201448	211333	253439	287840	342083	355013	389300	400701	440801	498245	508117	543916	577285	617564	694334	710313	789484	862224	979142	1057963	1206153	3788883	6664512	6666989	6700398	8684785	8724517\nT	7	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	30	31	32	33	34	35	37\nT	7	7309	10298	24622	29813	97446	113629	123395	162329	193037	221095	228207	230890	282586	312536	320232	335777	352864	407226	474847	516444	571632	644189	657798	703418	759707	887727	931131	980160	1022290	3609017	6416583	8326986	8590111	8676900\nT	8	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	31	32	33	34	35	37\nT	8	2570	5932	12618	39861	116788	127648	137145	183606	223475	234276	252814	278722	293063	319619	353050	402818	414714	427240	476885	599429	606093	642061	681816	726494	799408	884529	936627	1079872	1308151	6605806	6700297	8513118	8738765	8784152\nT	9	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	37\nT	9	12866	19639	54533	77313	126198	145330	193579	196636	204489	240418	259689	314632	329658	365960	378642	388518	448029	491466	541562	575946	588315	661819	730458	795801	882620	960726	1028847	1216761	1246001	6386091	6577229	8267841	8517171	8614398\nT	10	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	28	29	30	31	32	33	34	35	36	37\nT	10	7983	25479	42369	134136	139270	148150	163893	214813	236922	260894	270577	280979	331086	347506	391158	410335	428127	496272	561083	596009	657910	693892	738336	823931	894613	1015929	1100868	1216138	4030621	6502033	8256013	8359988	8492542	8642897\nT	11	3	4	5	6	7	8	9	10	11	12	13	14	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	11	5497	25096	39139	90347	150092	157650	161310	180537	238357	254871	258519	315685	374308	393273	427934	438272	452667	479617	591467	600376	682611	721017	740561	817169	894262	984566	1233539	1405092	4164856	6593637	8267298	8422006	8502701	8609801\nT	12	3	4	5	6	7	8	9	10	11	13	14	15	16	17	18	19	20	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	12	3963	13977	50266	85020	110843	160363	180692	234823	260769	300134	315427	323227	364580	403999	467722	481414	571754	590900	647236	706488	827696	844464	871815	921907	1154761	1221944	1405088	3941389	6610949	7031364	8422623	8631489	8689683\nT	13	3	4	5	6	7	8	9	10	11	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nT	13	4936	14950	53991	91485	115192	171648	183355	202987	258290	273780	289481	355819	364382	386222	433810	480091	498093	588354	594187	633907	756723	808698	882164	903054	977558	1070445	1167535	1248924	1412785	4049110	7816212	8020741	8334070	8447487	8702509\nT	14	3	5	6	7	8	9	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nT	14	5124	51156	100848	129617	179729	196302	268837	277917	295071	321417	349183	397190	416762	452408	478819	492645	585648	649165	694115	738591	807944	903871	982796	1068703	1231818	1507776	1647096	1836957	4328809	6945892	7248594	8478024	8646316	8711985\nT	15	4	5	6	7	8	9	10	11	12	14	15	16	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nT	15	9169	29947	77102	120265	145186	197740	206080	223974	288191	316427	340460	401004	437357	459294	468405	569981	655150	674455	728399	771934	793002	868817	1064486	1294022	1403893	1485629	1620805	4215365	7776083	8259548	8523175	8648608	8718347\nT	16	3	4	5	6	7	8	9	10	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nT	16	11920	18992	40989	79924	121095	156944	212576	226276	249932	329519	334711	340324	403882	421261	454810	491827	515387	557833	618147	635407	799547	824019	889129	922624	1043111	1122787	1340856	1727110	1817863	2133058	6761485	7136555	7283092	8600189	8747063\nT	17	2	4	5	6	7	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nT	17	4150	13848	44644	74972	142035	230513	239704	245225	260348	335712	351703	368469	374795	438482	487145	514249	538880	594293	651975	816943	853154	868350	964910	1000503	1043229	1246604	1402784	1684824	1817592	6626112	7051915	7159425	7467501	8667999	8743180\nT	18	2	4	5	6	7	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	18	1427	9039	50655	66678	161098	251152	257422	263905	291118	373828	385151	403550	447925	454456	487647	541663	597622	675704	701141	738549	768735	990821	998430	1062131	1220115	1646902	1712359	1882898	1931045	2261753	6975696	7273827	7700468	8764145\nT	19	2	4	5	6	7	8	9	10	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nT	19	676	22719	52456	88399	109240	170378	196001	270553	277181	303836	391142	419774	426663	498960	549173	556201	607250	630894	657284	712374	780487	948942	989874	1085536	1245236	1272808	1409724	1507360	1919485	2083727	7053110	7339868	7899890	8680058	8766976\nT	20	3	5	6	7	9	10	11	12	13	14	15	16	17	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	20	2436	55941	75312	183188	203197	217419	307220	314411	325458	339637	430987	443715	458076	544934	607101	639486	656164	782396	818732	871532	935553	959908	1087518	1374250	1558294	1825172	2365045	4444608	7128782	8032870	8352071	8763678\nT	21	2	3	4	5	6	7	8	10	11	12	13	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nT	21	1953	2801	18499	61472	83573	186796	203012	240321	316870	332094	355808	456951	492048	499899	538169	546523	614845	715160	790389	799752	832243	888571	1040057	1108129	1145634	1568762	1702715	1957945	2107553	2664820	7373519	7783717	8317673	8682453	8777145\nT	22	2	4	5	6	7	8	10	11	12	13	14	16	17	18	19	20	21	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nT	22	2291	13272	65652	89817	112126	219209	250322	332891	349528	369692	382109	505287	519639	537082	577575	667114	742398	795028	887357	899506	975258	1092333	1180541	1562607	1729581	1951125	2264649	2714961	7378303	7726866	8429014	8718306	8804440\nT	23	3	4	5	6	8	9	11	12	14	15	16	17	18	19	20	22	23	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	23	3621	10771	35722	102768	244606	253933	288402	386843	409963	424349	458557	578586	595578	606123	722153	767602	931222	1069442	1126104	1201628	1434340	1725478	2157304	2278397	2539156	3149678	7182117	7778099	8443894	8809759\nT	24	3	4	5	6	8	9	11	12	13	14	15	16	17	18	19	20	21	22	23	24	26	27	28	29	30	31	32	33	34	35	36	37	38\nT	24	1184	28578	39543	112668	195819	266381	304728	409935	419878	445272	465705	482256	510589	639000	661540	674228	760092	803733	908496	1034904	1158158	1189671	1317872	1660604	2089146	2273414	2475035	3147747	7335249	8026605	8445158	8615798	8812554\nT	25	4	5	6	8	9	11	12	13	15	16	17	18	19	20	21	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nT	25	15191	65153	124719	215070	291802	302520	343864	457639	485359	525109	644157	655904	689603	723334	867019	894646	1062942	1186306	1252642	1431855	1493113	1787535	1884396	2186106	2990667	3456910	6154695	7799452	8293464	8636179	8810544\nT	26	5	6	7	8	9	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nT	26	45820	97578	133781	207243	313647	325002	369902	481745	492922	523047	546460	566311	730334	743215	783782	796989	852068	973575	988160	1151900	1335923	1398757	1484260	1778000	1843650	2412310	2781222	4694217	5305332	7683344	8329297	8718403	8815672\nT	27	4	5	6	7	8	9	11	12	14	15	16	17	18	19	20	21	22	23	24	25	27	28	29	30	31	32	33	34	35	36	37	38\nT	27	6477	53028	107710	146824	224374	250560	351045	397764	530020	548362	561324	587607	665800	805825	822982	837261	1005450	1067515	1106584	1281483	1498544	1679793	1791713	2303295	2882416	3099005	5435617	5876066	7829671	8369091	8722951	8825687\nT	28	4	5	6	7	8	9	10	12	13	14	15	16	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	28	37314	58757	160693	209564	273358	369289	382947	433877	575975	589937	633070	686156	863473	894165	913795	993505	1098836	1188492	1247876	1406784	1541204	1724477	1918065	2355991	2978681	3162953	4135989	7577873	7886146	8153004	8450012	8845711\nT	29	4	5	6	8	9	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nT	29	21703	66737	179418	302189	405304	420238	475307	490137	629572	666912	698211	722272	765286	945022	995255	1097552	1117598	1254339	1275164	1535424	1649934	2026459	2123111	2482156	3175829	3552590	3966317	5315960	7517222	7944632	8605507	8771902	8888888\nT	30	4	6	8	9	10	12	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	30	75658	198465	256125	442328	458727	519243	684658	725580	751937	786928	815670	1007793	1082480	1124472	1301340	1393720	1489590	1675108	1924333	1981786	2217379	2578315	3142797	3568002	4087704	7375558	7834927	8200856	8673339	8914743\nT	31	4	5	6	8	9	10	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nT	31	30112	89579	227900	289996	377032	513353	531385	586057	764036	782588	851790	885652	906316	943982	1218193	1264854	1288137	1494439	1628807	1775179	2090845	2216839	2552809	3033778	3825487	4167149	5931648	6522286	6908317	8104280	8522739	8861930	8918518\nT	32	4	5	6	8	9	10	11	13	14	15	17	19	20	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	32	34269	99523	248201	315197	407390	533695	552820	628174	647178	871104	946592	1145422	1300507	1444441	1470757	1729036	1758324	2139094	2268010	2584018	2890082	3423657	4166932	4746845	6180706	8234372	8571715	8860076	8964781\nT	33	4	5	6	7	8	9	10	12	13	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	38\nT	33	39270	112347	226305	273130	345824	387603	582097	602230	686471	893584	914391	990846	1034786	1058512	1135440	1422663	1557879	1777530	1902353	1999873	2167601	2561465	2926204	3487345	3999012	4655786	5356007	6620439	8421375	8542867	8876383	9001441\nT	34	4	5	6	7	8	9	10	11	12	13	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nT	34	30855	127511	250879	301956	378459	424196	488286	633470	655584	749516	974056	996952	1038646	1087706	1159211	1193911	1558573	1619883	1650779	1915983	2239565	2397306	2815587	3052305	3538966	4078384	4695732	6495169	7167417	7584335	7947282	8822311	8953893	9013837\nT	35	4	5	6	7	8	10	11	13	14	15	16	17	18	19	20	21	22	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	35	52395	145393	218391	335239	418618	698337	722390	746559	771127	852394	1096142	1143492	1197578	1249273	1316940	1649952	1780080	2183355	2299099	2343401	2789168	3392468	3895237	4399552	5450410	5691627	8015226	8257120	8439937	8977513	9062593\nT	36	4	5	6	7	8	10	11	12	14	15	16	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	36	61046	164908	243237	371641	460814	515785	764101	790435	816698	1170337	1198161	1309890	1399317	1504969	1804422	1907620	1985459	2176765	2512141	2814475	3022547	3924305	4263906	4635134	5629865	6218741	6641555	8443903	8844351	9060487	9106152\nT	37	4	5	6	7	8	10	12	14	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	37	46156	184088	266487	404402	499035	821646	849606	971625	1252818	1337201	1396281	1459498	1604343	1711167	1989226	2181701	2475830	2701893	3115731	3540476	4182608	4414403	5693412	6082705	6336666	6654805	8173337	8924959	9094411	9140708\nT	38	4	5	6	7	8	10	11	12	13	15	16	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	38	81584	212568	298761	451136	552346	615146	903968	934311	964459	1104526	1411947	1546181	1616364	1665208	2119182	2243643	2470283	2741360	2929289	3598980	3857106	4523728	5220794	5744719	6160418	7179361	7306984	8450413	8592453	9054169	9192340\nT	39	4	5	6	7	8	10	11	12	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nT	39	96231	245583	336043	504826	610906	680304	992666	1026119	1059573	1213718	1507312	1614511	1690171	1766774	1860597	2264017	2437547	2534605	3036151	3136291	3477198	4131925	4818442	5186634	6421658	6663163	7089333	8631593	8830809	9081229	9254901\nT	40	4	5	6	7	8	10	11	13	14	15	16	18	19	20	21	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	40	111184	275971	371971	455870	668951	743475	1080945	1116689	1152867	1323605	1678092	1838338	1921139	2070351	2637822	2885635	3254250	3748732	4334238	4594343	5631526	6020173	6553587	6776000	7860537	8142915	8861268	9047591	9171681	9298821\nT	41	4	5	6	7	8	10	11	12	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nT	41	129616	311770	411550	502097	727516	808827	1170715	1210113	1249870	1429672	1471985	1807680	1979377	2065450	2175113	2765752	3017984	3129831	3409222	3827474	4338401	5500654	5954479	6524563	7271464	8514975	8739190	8909185	9115276	9257169	9364694\nT	42	4	5	6	8	10	11	12	14	15	16	17	18	19	20	21	22	24	25	26	27	28	29	30	31	32	33	34	35	36\nT	42	148586	256600	454473	795754	883512	1276597	1319370	1362526	1562654	1608498	1971679	2160408	2255123	2528559	3006709	3334394	3799916	4140541	5127010	5930729	6335294	6985130	7335486	7851017	7995793	9095987	9296887	9407827	9437911\nT	43	4	5	6	8	11	13	15	17	18	19	20	21	22	24	25	26	27	28	29	30	31	32	33	34	35	36\nT	43	84110	280100	483986	841362	1352954	1397777	1656547	2300797	2400281	2401495	2785606	2951953	3469153	3850798	4264925	5211687	5878741	6253242	6907453	7477583	7707916	8641157	9008449	9026772	9146860	9469989\nG	0	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	26	27	28	29	30	31	32	34	35\nG	0	7318	8802	18755	27464	52312	60058	82093	83062	98436	109390	113652	131544	164754	167189	172595	175886	187974	198205	221468	225506	244985	258139	268619	299484	310199	342464	382843	2070922	3534144	5346947	5361750	5375044\nG	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	26	27	28	29	30	31	32	34	35\nG	1	8186	9861	21088	31285	58211	66969	91047	92241	109487	121673	126738	147663	185858	188678	195381	199314	213799	225913	254957	259799	283477	300605	314023	354236	368731	411921	464641	2446781	4193271	6006364	6025565	6043426\nG	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	34\nG	2	9053	18992	30927	57916	71567	97102	104047	128516	132429	146108	160384	170771	176987	205560	207292	239814	263028	268236	272602	299061	310636	322789	357720	399959	402018	415802	458801	526318	4440201	6337508	6352279\nG	3	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	29	30	31	32	33	34	36\nG	3	5523	11337	15059	24334	61279	69816	86703	108474	126582	144588	152136	156833	186127	209999	217761	230101	245308	261578	269485	303617	316902	338337	365979	367492	378650	415840	430784	455983	4447814	6394338	6408223	6458705	6506692\nG	4	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	36\nG	4	4198	8460	36072	62989	66766	97979	106762	111932	128953	154304	164115	182348	208894	240781	246597	274189	276985	282236	303330	314644	339782	343011	413462	431084	471761	497321	510195	2347155	4477531	4479608	6306070	6320475\nG	5	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	35	37\nG	5	6861	13725	17998	66892	73391	105446	119387	121288	134350	141976	168369	187398	222732	230675	236626	268589	288772	300362	325485	346229	365638	367705	407549	420676	464215	480665	554923	629922	2497355	4613330	6329449	6386501	6425675\nG	6	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	28	29	30	31	32	33	34	35	37\nG	6	11465	20939	43885	79497	108294	114729	137507	143850	172441	195314	230601	239185	260515	267510	293105	326313	331952	352780	370584	393356	434431	444235	487424	524832	584597	626006	700353	2562856	4730328	4732405	4748873	6438121	6459416\nG	7	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	30	31	32	33	34	35	37\nG	7	4187	6493	16729	19428	66175	76927	84227	110233	132220	151482	156440	158816	193039	213022	218289	228738	238643	272251	315161	338826	368806	408564	418452	442467	474375	543945	568578	594435	615697	2433072	4531848	6148509	6287884	6333769\nG	8	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	31	32	33	34	35	37\nG	8	1808	4279	9595	27387	79037	86624	92403	126033	153008	161261	173227	191478	201000	219626	242102	272935	283895	291810	324586	397142	401511	429466	458912	485320	526149	573573	602930	680314	805911	4545413	4598250	6132017	6256496	6283150\nG	9	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	37\nG	9	8548	14336	37995	53717	88986	104395	137846	140768	146801	173589	187150	224045	236927	262606	273431	281287	321909	352315	386258	414462	424192	468034	514827	559972	608983	651272	697011	803073	827108	4554851	4670909	6143286	6294895	6352482\nG	10	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	28	29	30	31	32	33	34	35	36	37\nG	10	4565	18074	28529	95523	99179	106283	120166	157556	173168	192266	200299	211005	247710	260670	295071	313080	327676	376566	426378	447696	493731	527206	558222	611510	660684	740903	803794	877814	2801997	4640279	6078884	6147498	6238983	6339521\nG	11	3	4	5	6	7	8	9	10	11	12	13	14	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	11	2701	17055	26799	64720	108410	115768	119580	135818	181191	194947	198874	243313	293298	312928	340844	351060	364144	389852	476618	484793	543097	583125	603630	666037	716173	789082	968137	1088400	2996679	4757979	6098763	6208349	6271180	6343069\nG	12	3	4	5	6	7	8	9	10	11	13	14	15	16	17	18	19	20	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	12	3409	9532	34819	60418	79472	117289	134750	175792	202043	232483	247863	257062	292887	325940	381486	396189	470318	491089	538692	585884	686866	704637	734541	785869	953429	1005694	1153919	2871911	4730920	5023442	6109210	6265453	6305928\nG	13	3	4	5	6	7	8	9	10	11	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nG	13	4405	9892	37985	66021	82861	127236	137569	157558	200310	214308	231252	283075	293946	316039	357372	396335	414615	487281	494404	537769	638990	698862	761049	784064	844332	923217	1004555	1073308	1202108	2960014	5666910	5818003	6035409	6115679	6291087\nG	14	3	5	6	7	8	9	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nG	14	4102	37273	69014	95193	131986	148163	207016	218255	237593	266870	288310	330641	354697	385002	418358	434525	512328	590533	628476	660896	724521	818603	907543	976397	1110965	1321565	1426039	1564959	3229214	4955722	5188204	6092960	6222989	6269426\nG	15	4	5	6	7	8	9	10	11	12	14	15	16	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nG	15	6992	22340	53488	85851	109352	148815	156584	175904	227868	263412	291820	340642	388292	418073	428049	524307	593850	619475	690417	747950	772913	864220	1046496	1241131	1363913	1430433	1535126	3206501	5564864	5946716	6139342	6227442	6277763\nG	16	3	4	5	6	7	8	9	10	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nG	16	6948	12672	29701	61265	92087	121324	163115	177757	203932	275701	283334	291917	358326	382149	409326	459749	488071	525960	587126	609613	781957	814585	874472	914086	1040199	1110280	1302094	1626542	1704649	1963767	4835713	5139403	5247752	6165524	6271927\nG	17	2	4	5	6	7	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nG	17	3037	8589	32787	55189	105271	179556	188800	196256	214359	280741	301064	322817	332694	399998	448356	487520	518014	571265	627634	797365	846695	869792	965881	1009209	1064158	1251751	1398198	1664724	1778965	4703032	5042571	5132755	5375927	6201256	6254679\nG	18	2	4	5	6	7	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	18	1086	7424	38588	49393	121214	198653	207211	216349	250105	327456	342042	368977	411385	422815	472887	529316	581652	671144	711039	769204	813462	1066931	1080264	1132947	1294037	1680367	1762544	1940370	1987672	2239894	5038192	5254078	5553968	6236226\nG	19	2	4	5	6	7	8	9	10	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nG	19	801	16266	40080	66931	79956	128647	156597	217897	228017	262179	345274	387097	399498	483732	534379	547133	618322	661820	704083	760020	834041	1010412	1072629	1200395	1381430	1414044	1559440	1662091	1995603	2120176	5089125	5281799	5717550	6193545	6255991\nG	20	3	5	6	7	9	10	11	12	13	14	15	16	17	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	20	2015	43588	56518	140629	162032	182214	261431	273053	287790	312535	395100	413977	440783	551126	612026	663490	694302	817370	878915	963627	1064339	1098356	1211722	1517032	1700847	1953259	2433200	3584688	5121504	5724594	5964988	6254222\nG	21	2	3	4	5	6	7	8	10	11	12	13	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nG	21	1309	2248	14257	47971	62991	135930	156202	203894	263916	290002	322204	422968	480307	495286	562388	578999	648024	784100	866992	885215	938529	1032073	1218576	1312384	1368887	1774288	1920493	2140016	2259510	2711430	5270525	5560620	5902340	6174582	6239082\nG	22	2	4	5	6	7	8	10	11	12	13	14	16	17	18	19	20	21	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nG	22	1519	10436	51336	67740	88032	170282	209395	273220	301091	332585	351494	483240	506898	542237	615597	717297	807838	898857	1009783	1031387	1155904	1297932	1417466	1815923	1977461	2186751	2456443	2837909	5277391	5532603	5998736	6179524	6232966\nG	23	3	4	5	6	8	9	11	12	14	15	16	17	18	19	20	22	23	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	23	2805	8023	26064	80166	196068	210975	259046	345245	383191	406359	470797	598429	627995	649926	796717	880240	1072381	1246528	1337628	1453617	1704693	1975749	2408383	2517944	2708390	3178329	5140038	5573387	5973063	6214938\nG	24	3	4	5	6	8	9	11	12	13	14	15	16	17	18	19	20	21	22	23	24	26	27	28	29	30	31	32	33	34	35	36	37	38\nG	24	1230	20888	28502	88443	167336	215375	269362	360299	378520	421698	463400	490825	544370	672690	719689	726785	831094	909419	1048750	1208665	1403429	1455373	1616016	1941725	2389956	2536360	2699697	3226763	5275360	5686540	5968570	6071688	6217067\nG	25	4	5	6	8	9	11	12	13	15	16	17	18	19	20	21	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nG	25	12715	46481	98313	186712	239670	257833	319767	421261	470007	547418	651283	676204	740379	783021	986583	1041437	1268319	1402365	1508496	1721710	1799235	2085717	2152841	2438445	3116913	3434301	4738204	5503524	5844070	6072730	6203416\nG	26	5	6	7	8	9	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nG	26	32777	79552	105449	167780	256687	275367	344074	428886	450352	503939	552822	588023	764981	791917	844195	871586	968174	1123311	1151705	1363537	1589252	1674067	1770367	2064552	2120039	2590331	2944027	3959717	4396304	5440309	5858398	6148293	6206474\nG	27	4	5	6	7	8	9	11	12	14	15	16	17	18	19	20	21	22	23	24	25	27	28	29	30	31	32	33	34	35	36	37	38\nG	27	4135	38323	88808	117097	182520	221670	303855	376713	491347	521461	548331	605760	751181	871212	880965	912123	1145927	1260466	1325942	1549376	1806073	1994990	2141194	2587895	3035365	3214090	4265763	4570094	5546418	5897923	6141754	6202102\nG	28	4	5	6	7	8	9	10	12	13	14	15	16	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	28	28440	42594	129872	163657	245077	310629	334997	415830	542289	571664	645112	751049	931288	997543	1008549	1148183	1265793	1412322	1504556	1701804	1884690	2069485	2245566	2675352	3222320	3369978	4040089	5474111	5670886	5797876	5953733	6198256\nG	29	4	5	6	8	9	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nG	29	14461	46963	144189	273241	343950	371104	463119	494419	600316	671807	741261	785583	870793	1052155	1117064	1307070	1345573	1495922	1533968	1851588	2024901	2410495	2461711	2761071	3361890	3652197	3982815	4569919	5419809	5630239	6003434	6116264	6181995\nG	30	4	6	8	9	10	12	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	30	53280	161716	202239	382679	413572	515573	665547	744820	792739	870634	923854	1122794	1233955	1315543	1536893	1682636	1826521	2040466	2328301	2402127	2634731	2949938	3429613	3717014	4061138	5338176	5599531	5770540	6064681	6178868\nG	31	4	5	6	8	9	10	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nG	31	18789	64026	193217	237868	364772	482598	519930	612287	778295	819088	960788	1023318	1067188	1134793	1440055	1528169	1571795	1825620	2026220	2208827	2516468	2627931	2925768	3266858	3937969	4127892	4687178	5105372	5278547	5738946	5940381	6132153	6162054\nG	32	4	5	6	8	9	10	11	13	14	15	17	19	20	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	32	20128	67637	203544	252163	386025	476465	513602	647572	690137	927068	1081914	1271382	1519309	1757674	1804178	2110180	2154548	2558495	2699518	2960859	3222422	3655427	4151384	4506183	5159490	5834727	5967529	6104878	6151189\nG	33	4	5	6	7	8	9	10	12	13	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	38\nG	33	22530	75834	169096	228271	283020	354833	529870	570675	721522	916273	963388	1098731	1196605	1246652	1340308	1674079	1881916	2135223	2305066	2425330	2609066	2988077	3252945	3703860	3978785	4469016	4897600	5380095	5867216	5909331	6071129	6130544\nG	34	4	5	6	7	8	9	10	11	12	13	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nG	34	19448	86435	193153	257953	316238	395055	485038	590344	634825	806790	1016527	1068136	1141891	1248011	1381003	1400667	1845532	1949287	2001187	2304685	2674212	2812004	3244683	3373992	3749595	4105500	4446126	4961627	5412738	5579995	5744133	6036882	6087976	6114936\nG	35	4	5	6	7	8	10	11	13	14	15	16	17	18	19	20	21	22	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	35	28765	98250	160777	288967	354459	658601	707185	758710	812670	952880	1183930	1265774	1379280	1466710	1545494	1935453	2136228	2611688	2744909	2783746	3194920	3700015	3927095	4246134	4928951	5044624	5697316	5792105	5869818	6087202	6116295\nG	36	4	5	6	7	8	10	11	12	14	15	16	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	36	32362	110524	179137	322271	394626	489909	728639	781869	837718	1239149	1298783	1506284	1658296	1777110	2096981	2250533	2360355	2593477	2930561	3212854	3370581	4060073	4257309	4450076	5026233	5328092	5488905	5864743	6002226	6075749	6092680\nG	37	4	5	6	7	8	10	12	14	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	37	27181	118976	193558	344751	423914	781218	837525	1053635	1323858	1476337	1570239	1696649	1880274	2036584	2318101	2557681	2887764	3104890	3453933	3796889	4258778	4364037	5094781	5271985	5364526	5477612	5822755	6035148	6088927	6104626\nG	38	4	5	6	7	8	10	11	12	13	15	16	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	38	40323	138323	219654	393772	480860	592368	879898	941320	1005473	1249557	1541442	1774500	1877405	1905107	2435886	2597741	2826481	3099465	3284850	3789822	3992528	4459815	4769873	5073528	5219898	5593774	5628765	5806081	5844481	6024998	6071098\nG	39	4	5	6	7	8	10	11	12	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nG	39	45130	154492	242750	437020	532394	652277	967759	1033415	1101768	1366627	1608989	1785985	1923366	2031282	2127666	2571784	2780490	2889948	3341571	3426024	3678862	4118544	4521809	4728715	5359748	5451517	5582154	5878480	5932078	6000790	6047377\nG	40	4	5	6	7	8	10	11	13	14	15	16	18	19	20	21	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	40	51070	175545	271743	381908	587575	718642	1058608	1130017	1203358	1479063	1816539	2070319	2179638	2344858	2956099	3200403	3536956	3925950	4282261	4480730	5032472	5185476	5390444	5458971	5613286	5688854	5905249	5964471	5999184	6038705\nG	41	4	5	6	7	8	10	11	12	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nG	41	56834	192061	295865	415462	637519	777393	1139396	1214832	1292378	1578362	1655309	1936240	2193605	2303091	2406329	3035646	3282411	3393001	3627068	3899407	4274819	4904259	5137247	5348826	5621018	5810347	5866552	5912187	5967307	6006080	6031973\nG	42	4	5	6	8	10	11	12	14	15	16	17	18	19	20	21	22	24	25	26	27	28	29	30	31	32	33	34	35	36\nG	42	64010	140935	326932	697503	843632	1237290	1315478	1395357	1694687	1773598	2076380	2339902	2453016	2733408	3206132	3507062	3845903	4075255	4701850	5118759	5267820	5485783	5585781	5707766	5740769	5913867	5968991	5995417	6003255\nG	43	4	5	6	8	11	13	15	17	18	19	20	21	22	24	25	26	27	28	29	30	31	32	33	34	35	36\nG	43	26472	150831	352967	747782	1317918	1400897	1787821	2458465	2571729	2572094	2900549	3072259	3582845	3845735	4152073	4675806	5051432	5186286	5436617	5582839	5645245	5785401	5869572	5872893	5903092	5988372\nC	0	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	26	27	28	29	30	31	32	34	35\nC	0	17816	21810	45244	67864	116806	134720	177487	180010	212013	233575	243595	282618	349785	354784	367832	375991	401473	422318	473159	481719	522197	551745	575255	646477	672255	748700	852800	2957527	4819127	6508724	6547392	6583434\nC	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	26	27	28	29	30	31	32	34	35\nC	1	17948	21710	45603	68381	117310	133981	176704	178905	209843	230532	239900	276634	343071	347530	358998	366015	390819	411684	462046	469410	510442	540643	564816	639839	667948	749697	852679	2903751	4670635	6153188	6189219	6226315\nC	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	34\nC	2	18699	37502	60033	103481	127145	166301	177813	215616	222353	243519	264494	281156	291594	333292	335391	386032	423022	431721	436666	478749	497903	519911	581867	661214	663673	689877	771860	894320	4592322	5970573	5999138\nC	3	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	29	30	31	32	33	34	36\nC	3	9953	22080	29425	47160	106696	120937	146944	179303	207478	234490	246775	253608	298315	334066	345474	363721	386969	411228	423059	476341	497547	532058	581555	584064	602255	667383	696347	741457	4663935	6047487	6073164	6168313	6261403\nC	4	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	36\nC	4	6433	14757	64636	106134	112264	160608	173425	181168	205817	243548	257418	284573	325593	374348	381263	417828	421896	428531	463628	482922	525077	529987	666736	700307	778966	827035	851639	2551497	4627471	4629666	5973416	6002954\nC	5	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	35	37\nC	5	13268	27000	34550	113518	124154	173599	193823	196455	216509	227022	267291	295266	349585	359513	367414	414534	443876	458419	494939	524369	553824	556154	624209	646010	726281	759301	909937	1050966	2829537	4898640	6125317	6241322	6319760\nC	6	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	28	29	30	31	32	33	34	35	37\nC	6	20457	37789	76745	129115	171189	180154	212588	221283	262841	294172	343612	353426	382387	389639	424589	472406	477363	506861	532406	562781	620958	628854	692708	753923	859395	933135	1069602	2750946	4843197	4845997	4875536	6036285	6072720\nC	7	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	30	31	32	33	34	35	37\nC	7	5650	9875	29503	35290	108429	127480	138331	175952	205358	232131	238287	241143	289181	315904	321937	333909	342564	380676	436378	466491	511590	567781	578159	613908	651083	752661	790896	830881	869903	2604197	4736378	5806611	6045270	6125389\nC	8	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	31	32	33	34	35	37\nC	8	2076	6630	16187	48777	128290	138755	146395	192383	229076	238826	252270	277728	287320	312740	341960	385588	398766	405329	444634	538980	542484	567054	589144	623919	681731	751558	795329	926226	1130535	4884783	4974566	5960589	6169685	6209335\nC	9	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	37\nC	9	15358	25681	66069	92426	142321	165183	211770	215375	222813	257403	272028	319865	333783	365789	376517	384243	439489	477305	517848	543516	552310	611450	667251	714773	788063	856801	913752	1094695	1111392	4848039	5029544	5933306	6169419	6264308\nC	10	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	28	29	30	31	32	33	34	35	36	37\nC	10	5839	29399	48953	146623	151432	160207	176891	226328	247590	268175	276200	287842	335916	347737	387069	403513	416061	481206	530749	561988	613531	641584	678089	749514	807289	916995	992547	1094465	3087786	4985939	5928215	6017335	6139073	6269682\nC	11	3	4	5	6	7	8	9	10	11	12	13	14	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	11	3701	28644	43842	104413	161840	171104	175643	194010	250489	263620	267749	322487	372435	390319	424067	429427	441830	456479	565507	570293	640171	671145	687009	751131	821815	895523	1138020	1294803	3232153	5108220	5989520	6113286	6183534	6287269\nC	12	3	4	5	6	7	8	9	10	11	13	14	15	16	17	18	19	20	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	12	4178	14211	58290	97098	125041	173344	193404	244328	271235	305273	319118	328017	366911	402786	455081	464950	549610	565441	615457	667236	777803	790719	814348	846769	1066544	1110198	1268757	2981631	5043630	5442451	6008243	6187835	6237955\nC	13	3	4	5	6	7	8	9	10	11	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nC	13	7410	14662	62578	104918	129894	186338	198700	219457	273901	284786	300444	365012	375363	391927	437299	479516	496192	581970	589764	615734	727778	775222	836412	854396	926415	1025209	1117716	1188366	1338140	3116458	5442288	5632753	5913157	5987796	6240590\nC	14	3	5	6	7	8	9	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nC	14	7222	61104	112066	144340	191253	208510	277333	288180	305264	328239	356130	397718	415300	451844	477486	495171	583874	638555	678417	724131	793073	896221	954436	1029078	1140610	1409942	1555862	1760606	3637762	5353665	5631417	6072826	6194485	6249347\nC	15	4	5	6	7	8	9	10	11	12	14	15	16	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nC	15	10642	34929	86231	132587	158017	207213	214669	232454	293018	322421	340994	401939	433702	453355	465180	556992	644548	660551	705928	742223	756466	819964	1013532	1249489	1344746	1426669	1569766	3524591	5485427	5910376	6121948	6201570	6262530\nC	16	3	4	5	6	7	8	9	10	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nC	16	9264	18967	44786	90451	133151	171034	222499	235846	256849	333903	340259	347115	405857	420264	454482	484510	506005	550118	615700	626416	781803	802560	874742	906072	1028261	1104874	1327967	1691207	1782071	2013611	5151488	5491644	5600527	6125562	6257177\nC	17	2	4	5	6	7	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nC	17	3989	12047	48322	83635	157588	241695	249211	256025	269976	345510	359788	374451	382180	440019	491885	516765	541046	590799	652785	807504	843010	863388	948669	981664	1025030	1218791	1346981	1599748	1733014	4972638	5378998	5486540	5756604	6217246	6269853\nC	18	2	4	5	6	7	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	18	2085	11609	53516	74404	172921	256633	264117	271409	294749	378866	387021	403104	449859	458057	483707	535097	598778	678500	699101	735119	759624	976106	986315	1059706	1207409	1608001	1684118	1853149	1905152	2105469	5352567	5592403	5883029	6264109\nC	19	2	4	5	6	7	8	9	10	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nC	19	1264	23719	55825	96680	120504	181358	206197	276850	284549	309216	398068	424780	433391	504030	559298	568245	612631	644959	672021	734997	812213	994577	1042461	1146820	1321974	1349835	1517173	1625776	2058838	2202041	5396502	5561240	6017880	6210587	6274653\nC	20	3	5	6	7	9	10	11	12	13	14	15	16	17	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	20	3624	59404	84849	194558	212790	228819	312944	321247	330550	348112	436463	446569	464848	553208	625922	651505	674223	808234	848525	912759	996299	1018152	1164746	1485019	1703868	1998901	2568195	3838821	5396436	5810289	6037106	6249901\nC	21	2	3	4	5	6	7	8	10	11	12	13	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nC	21	2733	4337	21861	64360	93182	193395	210900	247752	319494	337711	357644	462573	494950	505179	541489	553063	634959	740884	821207	835366	871964	944433	1121985	1195995	1237882	1724147	1879025	2114739	2246518	2730107	5365922	5652180	5908639	6193722	6252990\nC	22	2	4	5	6	7	8	10	11	12	13	14	16	17	18	19	20	21	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nC	22	3137	15902	67947	98891	120091	225723	255735	332336	351917	372920	384113	510494	523420	546926	588818	689222	780535	838511	944940	964347	1072932	1212776	1322921	1773363	1975090	2232025	2572244	2963818	5398459	5645455	6040790	6201175	6237690\nC	23	3	4	5	6	8	9	11	12	14	15	16	17	18	19	20	22	23	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	23	5850	13618	39058	113412	249497	260127	293481	388907	412715	425263	464290	596482	611167	627083	756562	815602	1027041	1184204	1261647	1368324	1661233	1958770	2432487	2570493	2756316	3237273	5370476	5781392	6055902	6254753\nC	24	3	4	5	6	8	9	11	12	13	14	15	16	17	18	19	20	21	22	23	24	26	27	28	29	30	31	32	33	34	35	36	37	38\nC	24	2581	31243	44515	125683	210123	273369	309565	412742	425275	451817	480455	494644	526120	659093	694968	713564	824534	864293	1014248	1156486	1302621	1358105	1520755	1946030	2417820	2556128	2726451	3343043	5499823	5772938	6026929	6091130	6233284\nC	25	4	5	6	8	9	11	12	13	15	16	17	18	19	20	21	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nC	25	17166	67131	137619	227917	295437	308164	348277	461126	491229	539693	666738	684713	723932	762739	934292	982348	1194144	1339637	1433191	1679014	1757760	2091498	2183394	2513151	3249964	3593492	4825597	5571725	5901468	6093091	6239167\nC	26	5	6	7	8	9	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nC	26	50118	100494	149023	220316	318455	331969	376018	484783	499766	532733	568229	586751	770771	791959	839358	862129	917588	1088810	1114375	1316738	1547293	1628967	1708596	2071952	2142293	2696830	3133569	4155013	4606648	5516028	5918224	6196032	6223980\nC	27	4	5	6	7	8	9	11	12	14	15	16	17	18	19	20	21	22	23	24	25	27	28	29	30	31	32	33	34	35	36	37	38\nC	27	10650	60776	110859	163058	238610	266941	359539	409620	544402	564128	582499	623427	722430	880269	906542	931145	1160517	1256807	1326553	1567560	1856297	2093765	2261373	2826880	3333851	3514863	4542194	4843883	5653368	5960464	6187595	6217630\nC	28	4	5	6	7	8	9	10	12	13	14	15	16	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	28	43566	67182	177590	226668	289877	373008	389478	444386	593523	614156	660584	734618	943397	996491	1025827	1134532	1281117	1402903	1489441	1729955	1921284	2161910	2360920	2897393	3587953	3772124	4349552	5695034	5868413	5950685	6049184	6211925\nC	29	4	5	6	8	9	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nC	29	30320	75011	194073	314954	403768	422334	483801	504900	646544	695095	747372	775907	837582	1061879	1131434	1288054	1324794	1506478	1544998	1902570	2085367	2570105	2632537	3003708	3705094	4008754	4408857	4932229	5681766	5802728	6039564	6179173	6210396\nC	30	4	6	8	9	10	12	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	30	84859	213486	268686	439101	459635	529099	707442	763232	796482	856220	894211	1138643	1253511	1330084	1568809	1717878	1869009	2122970	2463134	2552835	2833686	3228835	3801683	4048732	4400491	5552339	5781292	5914381	6152678	6194649\nC	31	4	5	6	8	9	10	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nC	31	41179	95665	235951	295159	379283	505524	531230	583027	780987	811478	911630	947628	985273	1026368	1386351	1474597	1518541	1777847	1982079	2162805	2533590	2654304	3031683	3406134	4204643	4405443	4968728	5413087	5564226	5938938	6013036	6163468	6206114\nC	32	4	5	6	8	9	10	11	13	14	15	17	19	20	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	32	46952	107285	256964	319611	414430	523935	549525	639055	670131	925363	1044953	1295004	1530018	1750630	1799870	2150637	2201487	2685787	2858055	3162458	3485912	3963119	4461161	4837790	5403621	6016202	6095142	6165576	6181967\nC	33	4	5	6	7	8	9	10	12	13	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	38\nC	33	52655	117952	236289	278555	343655	392682	563425	591799	691996	926738	964792	1055898	1140755	1187627	1289419	1670130	1858529	2156724	2340958	2473780	2702323	3155034	3484465	4040194	4323498	4857655	5197507	5595060	6008660	6020601	6143794	6166229\nC	34	4	5	6	7	8	9	10	11	12	13	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nC	34	43012	133268	259703	305859	374517	429238	488776	613312	645200	758363	1011320	1053434	1101524	1195895	1302669	1353228	1828090	1940988	1997797	2331743	2768540	2930339	3431560	3586700	4043865	4429839	4735161	5176013	5568433	5733983	5895393	6090953	6152963	6188834\nC	35	4	5	6	7	8	10	11	13	14	15	16	17	18	19	20	21	22	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	35	70189	149906	238537	336874	410324	675033	710615	750255	794285	882907	1166639	1222213	1326614	1388663	1500133	1939410	2136612	2672754	2819478	2868820	3354819	3953866	4181009	4544252	5222293	5341528	5867538	5980163	6018640	6165168	6173554\nC	36	4	5	6	7	8	10	11	12	14	15	16	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	36	79617	169161	262691	371467	448091	517145	738231	778878	823397	1225067	1277472	1455584	1586591	1722560	2113751	2260186	2387028	2626842	3034537	3365126	3557906	4362082	4613597	4784395	5291481	5531403	5638073	5946443	6067033	6140141	6158947\nC	37	4	5	6	7	8	10	12	14	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	37	62630	188569	287057	407700	488703	806963	850778	1015051	1341498	1469717	1547584	1672437	1886827	2044615	2388998	2641939	3039728	3298989	3701831	4073346	4550393	4670151	5283011	5417197	5517464	5636580	5951968	6104078	6124596	6141187\nC	38	4	5	6	7	8	10	11	12	13	15	16	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	38	101103	209197	311351	442525	527431	610975	870995	919933	974358	1157209	1507442	1717912	1801954	1869272	2458505	2624573	2901869	3194041	3416863	4021650	4271899	4762490	5156397	5380966	5502618	5812787	5839962	5985040	6005224	6120225	6147213\nC	39	4	5	6	7	8	10	11	12	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nC	39	115169	234895	340936	487276	574989	669539	953347	1008355	1068310	1274489	1585977	1740612	1884119	1976251	2120266	2637974	2840540	2972168	3501262	3600439	3899915	4424192	4832741	5033996	5528983	5641412	5743302	6010887	6047805	6091018	6141038\nC	40	4	5	6	7	8	10	11	13	14	15	16	18	19	20	21	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	40	130047	262282	372059	454518	624337	727912	1032749	1092660	1157987	1381463	1779599	2022998	2120892	2346494	3014424	3290681	3693209	4135791	4579960	4776268	5252664	5438285	5593789	5640800	5767492	5836135	6001677	6066768	6102962	6124234\nC	41	4	5	6	7	8	10	11	12	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nC	41	148039	294703	405789	498066	678241	793013	1125200	1191590	1262487	1508471	1586852	1938160	2195709	2299960	2454814	3148892	3431754	3564247	3839623	4168348	4590110	5133499	5361799	5605236	5804062	5924392	5976274	6003830	6046100	6084212	6108477\nC	42	4	5	6	8	10	11	12	14	15	16	17	18	19	20	21	22	24	25	26	27	28	29	30	31	32	33	34	35	36\nC	42	165962	250909	442475	734626	859173	1214357	1285566	1361281	1625297	1707064	2076864	2347466	2457151	2805672	3328170	3680128	4088074	4352268	5028799	5367618	5536694	5730377	5811855	5894037	5925305	6044953	6074066	6096314	6103591\nC	43	4	5	6	8	11	13	15	17	18	19	20	21	22	24	25	26	27	28	29	30	31	32	33	34	35	36\nC	43	100766	276667	467223	771750	1280905	1357197	1723184	2474354	2589110	2589257	2992299	3187295	3758115	4072094	4437015	4929396	5323252	5449661	5680182	5808037	5863213	5954818	6009404	6010570	6038206	6095238\nN	0	2	20	22\nN	0	26765	97654	208474\nN	1	2	20	22\nN	1	23252	96440	209660\nN	2	5	20\nN	2	94624	208894\nN	3	2	6	20\nN	3	29024	142539	217595\nN	4	2	8	20\nN	4	111978	137003	214253\nN	5	4	20\nN	5	25191	213643\nN	6	2	6	22\nN	6	28961	101845	216314\nN	7	2	7	20\nN	7	115350	147638	219779\nN	8	6	20\nN	8	150508	224729\nN	9	3	5\nN	9	197689	233305\nN	10	4	6	22\nN	10	31598	147099	224878\nN	11	6	7\nN	11	108095	226864\nN	12	3	5\nN	12	189365	215268\nN	13	3	5	9\nN	13	77049	103985	220971\nN	14	5	7	24\nN	14	27805	145451	226027\nN	15	6	10\nN	15	141925	222835\nN	16	4	6	12\nN	16	112369	141740	219450\nN	17	4	6	7\nN	17	112338	142004	221865\nN	18	2	5	6\nN	18	112362	192976	226144\nN	19	2	5	6\nN	19	78981	196016	221589\nN	20	3	6\nN	20	202317	231560\nN	21	2	3	6\nN	21	124981	201999	230330\nN	22	2	6	8\nN	22	128592	156808	235206\nN	23	3	6\nN	23	198687	224152\nN	24	3	5	6\nN	24	81140	205488	231845\nN	25	5	6\nN	25	122752	244630\nN	26	5	6	7\nN	26	122860	204407	246401\nN	27	4	7\nN	27	205692	254685\nN	28	4	5	6\nN	28	126913	211717	261490\nN	29	4	6\nN	29	213810	265136\nN	30	4	6\nN	30	205829	262279\nN	31	4	6\nN	31	210157	265530\nN	32	4	6\nN	32	208917	261076\nN	33	4	6\nN	33	210593	263412\nN	34	4	5	6\nN	34	84687	204269	255804\nN	35	4	6\nN	35	206308	255771\nN	36	4	6\nN	36	205383	256400\nN	37	4	5	6\nN	37	87050	207722	257662\nN	38	4	6\nN	38	207487	258699\nN	39	4	6\nN	39	207545	258604\nN	40	4	6\nN	40	202500	253367\nN	41	4	6\nN	41	211758	261475\nN	42	4	6\nN	42	209020	255922\nN	43	4	6\nN	43	217393	265646"
#define QUAL_DIST_ONE50 ".	0	7	8	12	14	15	16	19	20	22	25	26	27	28	29	31	33	34	36\n.	0	69185	652059	1060003	1270010	1534276	1755038	2458510	2468885	2724930	2974082	3554732	3862344	4412767	5570179	14766465	17123570	17724519	18909340\n.	1	7	8	12	14	15	16	19	20	22	25	26	27	28	29	31	33	34	36\n.	1	111009	931279	1502559	1792951	2151483	2451174	3379974	3393360	3718812	4040145	4693789	5034460	5707291	6971379	14570647	17050064	17647962	18909340\n.	2	5	8	9	11	13	15	16	20	21	24	26	27	29	30	31	33	34	36\n.	2	260074	881276	989414	1554036	1839789	2127906	2421178	2732978	3657512	4307859	4958976	5633522	6303862	7568261	14731942	17160188	17452782	18909340\n.	3	4	6	7	13	16	20	23	25	26	28	29	30	31	34	36\n.	3	117364	399402	976700	1938918	2549547	3529288	4209586	4937483	5190661	6283974	7181416	8294259	9594421	17121128	18909340\n.	4	5	6	8	10	11	13	16	17	20	24	25	27	29	30	31	32	33	34	36\n.	4	125705	427895	1031551	1113095	1737305	2387490	2725515	3072541	3814627	4589520	5390424	5623323	6009298	7192221	9494873	15288681	16055068	17773518	18909340\n.	5	7	8	12	14	17	18	20	22	24	25	27	28	30	31	32	33	34	36	37\n.	5	470522	1208728	1875499	2220580	2575388	2941714	2963452	4141676	4560608	5017352	5479111	6305518	8152062	8907276	10602110	15202211	17756384	18486537	18909340\n.	6	7	8	11	15	16	18	20	21	22	24	25	27	28	29	30	31	32	33	34	36	37\n.	6	340581	1127070	1898606	2259316	2610022	2982561	3004813	3392484	4208120	4634961	5074414	5531084	6318440	8087221	9299921	9764337	10188238	14658892	16911534	18541437	18909340\n.	7	7	9	11	18	20	24	25	26	28	29	30	31	32	33	34	36	37\n.	7	346767	1102680	1929640	2643449	3422452	4226349	4646561	5957456	6404728	6814975	7483323	8378181	10355563	14832048	15999132	18123017	18909340\n.	8	7	9	11	12	16	17	19	20	23	24	25	26	27	28	29	30	32	33	34	35	36	37\n.	8	372042	1175214	1902312	2060736	2440582	2834817	3242384	3693865	4590336	5057769	5535630	6020832	6510972	7004370	7751250	8243753	14264065	14928985	16392169	16875034	17731961	18909340\n.	9	7	8	9	13	16	19	20	21	24	25	29	30	32	33	34	35	36	37\n.	9	545715	662841	1358211	2090315	2473225	2868285	3321668	3732484	4626394	5092968	5575675	6036203	8295183	12425926	14179614	15451724	17241288	18909340\n.	10	9	11	13	17	18	20	21	22	24	27	29	30	31	32	33	34	35	36	37\n.	10	1116587	1242541	2164874	2558020	2965621	2995576	3417233	3853352	4764864	5258632	5741563	6850695	7906981	10023836	10957592	15927765	17211353	18075088	18909340\n.	11	7	9	10	12	16	18	20	21	22	24	26	28	30	31	32	33	34	35	36	37\n.	11	421357	559231	1476501	2257734	2666645	3089514	3122043	3559491	4014004	4966049	5459421	5880170	6591104	7322424	13772035	14252056	14510619	16112646	18161791	18909340\n.	12	7	8	9	15	17	20	23	27	28	29	30	31	32	33	35	36	37\n.	12	342652	795876	1569064	2396340	2832117	3796337	4289735	4840097	5682364	7558707	8045460	13369100	14978680	15379058	16497448	17398249	18909340\n.	13	9	10	12	16	18	20	21	23	24	28	29	30	31	32	33	34	35	36\n.	13	488349	1474818	1686399	2567508	3038145	3080871	3574330	4090467	4629902	5765855	6360855	6946774	9698264	10397596	12984885	14211843	17610100	18909340\n.	14	8	9	11	12	15	20	21	23	26	27	28	29	30	31	32	33	34	35	36	37\n.	14	524287	716965	1573521	1801997	2741311	3323700	3830444	4393776	6217389	6857909	7610708	8905383	9892033	10020103	11170036	13127199	14275823	16969887	17954419	18909340\n.	15	8	9	10	16	18	20	22	23	26	27	28	30	31	32	33	34	35	36\n.	15	543997	786211	1859343	2804484	3312919	3365875	3898407	4456363	6260651	6778317	7406862	7602167	9417503	9927220	13862500	14429895	17899674	18909340\n.	16	9	10	11	16	19	20	22	23	30	31	32	33	34	35	36\n.	16	271573	874479	2045166	3070530	3629483	3694283	4283955	5552867	7096100	7873990	8151878	10599679	14187098	16998777	18909340\n.	17	9	11	12	16	20	21	24	25	27	28	29	30	31	32	33	34	35	36\n.	17	927668	1191586	2160964	3241462	3312939	3906593	4569626	5197410	6025187	6711606	8565581	9479847	9984594	12777584	13242221	14642562	15890989	18909340\n.	18	9	10	11	17	19	20	23	26	30	31	32	33	34	35	36	37\n.	18	630038	1320767	2342361	3490791	4123146	4209393	4881702	6329658	9496254	10377421	13228780	14106746	15144613	15479022	18176684	18909340\n.	19	9	10	13	17	20	22	26	27	29	30	31	32	33	34	35	36	37\n.	19	1068161	1390134	2453637	3662716	3755000	5135741	5913779	6664686	9085779	10375487	12358584	13225901	14191247	15224126	16654352	17920997	18909340\n.	20	10	11	13	18	20	21	25	26	28	29	30	31	32	33	34	35	36	37\n.	20	1108384	1450123	2531182	3752551	3853657	4524746	5235398	5980825	6795760	6925879	9795747	10585882	11371070	12503315	14367967	14958714	17000587	18909340\n.	21	9	10	13	18	20	24	25	27	28	29	30	31	32	33	34	35	36\n.	21	778806	1581133	2716125	4008764	4125952	5604940	6560011	7384754	7486490	8331085	9938889	12218919	13015604	15061029	16230741	16783886	18909340\n.	22	10	11	14	20	21	26	29	30	31	32	33	34	35	36	37	38\n.	22	1262979	1672230	2855572	4345082	5101221	5902003	6297834	9486655	12765889	12891470	13685083	14807852	15860249	16911115	17376880	18909340\n.	23	11	14	19	20	22	23	25	28	29	30	31	32	33	34	35	36	37\n.	23	1737614	2930635	4301414	4441366	5199966	6001666	6888451	7044348	7788993	8701451	10278363	13357228	14304047	15602879	17338884	17938643	18909340\n.	24	10	11	15	19	20	23	25	26	27	30	31	32	33	34	35\n.	24	473222	1840502	3088928	4531359	4683749	5486067	6329681	7211238	8109051	8268204	11940202	13901436	16836343	17683702	18909340\n.	25	10	11	14	18	20	22	24	27	29	30	31	32	33	34	35	36	37	38\n.	25	1435072	1917366	3193396	4662804	4828038	5640303	6522312	6602373	7982793	9717975	11584280	12528060	12834407	14864953	16395745	16773370	17370227	18909340\n.	26	10	11	14	19	20	24	25	27	29	30	31	32	33	34	35	36	37\n.	26	534480	2039031	3373748	4919365	5100938	5954597	6849032	7984891	9786305	10018154	11514699	12300718	14020252	15370465	16575261	18164883	18909340\n.	27	10	11	14	20	23	26	27	29	30	31	32	33	34	35	36\n.	27	547825	2138925	3511300	5299935	6172715	8350268	11081587	11144317	12037326	13725151	15715835	16303644	17881691	18578921	18909340\n.	28	6	8	12	18	20	21	22	25	26	28	29	30	31	32	33	34	35	36\n.	28	606227	2252559	3675839	5317611	5536025	6432462	7360874	8303430	9354936	11611705	13209062	13815818	16261116	16576359	17451443	17667246	18740046	18909340\n.	29	7	8	9	12	18	20	22	25	26	27	28	30	31	32	33	34	35	36\n.	29	649251	1265995	2381176	3857768	5562116	6731462	7690132	8764552	9802740	11605963	12592278	14436352	14829349	16561727	17368412	17416792	18220905	18909340\n.	30	6	7	9	13	18	20	21	24	25	27	28	29	30	31	32	33	34	35	36\n.	30	697617	1360070	2534571	4085329	5874531	6136317	7106779	8100005	9097137	10899880	11541620	12663328	13329792	14945424	15718048	16287183	16465056	18567488	18909340\n.	31	7	8	9	13	17	20	21	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	31	742458	1437524	2646114	4220785	6026390	6315399	7289522	8284191	9278377	10250878	10278511	10363293	12896030	13914924	13981945	14931233	16139963	16877043	17683421	18009882	18553587	18909340\n.	32	7	8	9	13	17	20	21	23	26	27	28	29	30	31	32	33	34	35	36\n.	32	796672	1533784	2791505	4421190	6289386	6607652	7613125	9690304	10169715	11157214	12981411	13754418	15215533	16565075	17238080	17536189	17790016	18744410	18909340\n.	33	7	8	9	13	18	20	22	25	26	28	29	30	31	32	33	34	35	36\n.	33	855244	1632457	2945293	4637235	6560330	6914961	8967538	9940715	11043295	12563865	13965550	14124840	17154954	17944845	18550681	18609377	18749554	18909340\n.	34	7	8	10	13	17	20	21	22	24	26	27	28	29	31	32	33	34	35	36\n.	34	906794	1729447	3094807	4846635	6836970	7216581	8269016	9320200	10347301	11375316	13286397	14900471	15571562	17091390	17132375	17236633	18332312	18609330	18909340\n.	35	6	7	9	13	17	20	21	24	26	27	28	29	30	31	32	33	34	35	36\n.	35	974771	1842351	3270739	5085714	7122415	7543489	8606938	10675712	12354186	12471604	14301422	15151465	15482071	16624461	17349964	17618110	18612218	18721860	18909340\n.	36	6	8	9	13	17	20	21	22	23	24	25	27	28	29	30	31	32	33	34	35\n.	36	1030307	1943597	3424974	5297488	7383838	7838572	8921385	10011528	11033214	11987017	14199187	14660958	15793061	16289761	17408116	17877583	18230714	18614151	18807020	18909340\n.	37	7	8	9	13	18	19	20	23	24	25	26	27	28	29	30	31	32	33	35	37\n.	37	1097780	2051465	3580270	5494771	7604837	8688182	9192144	10284975	12322476	13929482	14058165	16119204	16375365	16484865	17508267	17854608	18462847	18494273	18607341	18909340\n.	38	6	8	9	13	18	20	21	24	25	26	27	28	29	30	31	32	33	34	35	36\n.	38	1161605	2164630	3752162	5727678	7890344	9536264	10600754	11606119	13173741	14203251	15481816	15925286	16767821	16848405	17610830	17692987	18015349	18246527	18726639	18909340\n.	39	6	8	10	14	17	20	22	23	25	26	27	28	29	30	31	32	33	34	35	36\n.	39	1224229	2275443	3919296	5950106	8155854	9858270	10923222	11918944	12021779	14492020	15047605	16594185	16955999	17535469	18048013	18137985	18244140	18637201	18735956	18909340\n.	40	7	8	10	13	17	20	22	23	24	25	26	27	28	30	31	32	33	34	35\n.	40	1295777	2395520	4092778	6170513	8399182	10160128	11219001	12234417	12536011	13479342	15308548	16211983	17175117	17606708	18115958	18624635	18683910	18815453	18909340\n.	41	6	8	10	14	17	20	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\n.	41	1375790	2535921	4304951	6457511	8737587	10551304	12571045	12584474	13845186	15711837	16610438	16817107	17189226	17520730	17959933	17987035	18065862	18161838	18279621	18490299	18909340\n.	42	6	8	10	13	17	19	20	21	22	23	24	25	26	27	28	29	31	32	33	34	37\n.	42	1449422	2661840	4489542	6687147	8977936	10090799	10850876	11887023	12829543	13669401	15024425	16223597	16303378	16908690	17159491	17625479	17934296	18142909	18385296	18598767	18909340\n.	43	6	8	10	13	16	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34\n.	43	1525477	2786585	4669953	6917770	9233088	10344827	11165036	12190931	12202682	13129255	14435739	14783875	16715032	17332267	17777914	17997011	18414586	18454207	18795990	18860575	18909340\n.	44	6	8	10	13	17	20	21	22	24	25	26	27	28	29	30	31	32	33	34\n.	44	1605731	2921012	4866406	7162517	9494290	12520534	13420495	14212167	15468362	16369247	16814030	17255453	17705043	18000876	18011953	18144900	18211483	18838119	18909340\n.	45	6	8	10	13	17	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34\n.	45	1693896	3064419	5066702	7407552	9746546	11798141	11807985	13671311	16123858	16697181	17212423	17279040	18004850	18446398	18503128	18580539	18631158	18833459	18860875	18909340\n.	46	6	8	10	13	16	17	18	20	21	23	24	25	27	28	30	31	32	34	35\n.	46	1773186	3200051	5259066	7647928	7657143	10006364	11089922	13938188	13971577	16692041	17083916	17239317	18008977	18396835	18406677	18445761	18510605	18810663	18909340\n.	47	6	8	10	13	16	19	20	22	24	25	26	27	28	30	31	32	33	34\n.	47	1866158	3353586	5479520	7912114	10265209	11332182	14206025	15340652	16447491	17220533	17508731	17987925	18271091	18505702	18557078	18768695	18795286	18909340\n.	48	6	8	10	13	17	19	20	22	23	24	25	26	27	29	30	31	32	33	34\n.	48	1959947	3508803	5699567	8169790	10512459	12483520	13674996	15776929	16871555	17276469	17862341	17890087	18205810	18317690	18620752	18732667	18796259	18865752	18909340\n.	49	6	8	10	13	14	17	20	21	22	23	24	25	26	27	28	29	30	31	32	34\n.	49	2013033	3610712	5872517	5879870	8417244	10786697	14743932	15772222	16552188	16639135	17011665	17466642	17647296	18159759	18468281	18619713	18647359	18670246	18856405	18909340\nA	0	7	8	12	14	15	16	19	20	22	25	26	27	28	29	31	33	34	36\nA	0	9640	182018	317799	392242	484106	569630	863287	865051	981988	1092295	1350638	1493105	1753403	2250427	4760938	5760555	5996875	6511393\nA	1	7	8	12	14	15	16	19	20	22	25	26	27	28	29	31	33	34	36\nA	1	12804	238134	408526	499936	613169	716656	1065446	1068063	1203360	1333704	1593965	1735113	2024802	2513790	4346713	5279936	5483473	5972131\nA	2	5	8	9	11	13	15	16	20	21	24	26	27	29	30	31	33	34	36\nA	2	69082	242231	254991	422932	512003	606228	705765	814193	1169067	1440376	1714242	2001108	2289825	2790174	4501372	5382101	5482303	5993324\nA	3	4	6	7	13	16	20	23	25	26	28	29	30	31	34	36\nA	3	14690	89600	253780	538098	736225	1083471	1348019	1648383	1726162	2165924	2470504	2930112	3404823	5375965	5992029\nA	4	5	6	8	10	11	13	16	17	20	24	25	27	29	30	31	32	33	34	36\nA	4	16808	99599	276510	298204	492982	713929	837636	970008	1267336	1602231	1952615	2014241	2181038	2679475	3601846	4905868	5121228	5735170	6082257\nA	5	7	8	12	14	17	18	20	22	24	25	27	28	30	31	32	33	34	36	37\nA	5	112930	329249	538002	652517	775349	907489	912414	1374280	1548507	1745390	1943844	2273351	2973617	3265900	3935151	4862322	5795867	6004526	6169257\nA	6	7	8	11	15	16	18	20	21	22	24	25	27	28	29	30	31	32	33	34	36	37\nA	6	94287	306283	543616	670306	787395	924139	929020	1077843	1410821	1591857	1781722	1981102	2286143	2990490	3373923	3574914	3736009	4574736	5411911	5949597	6074397\nA	7	7	9	11	18	20	24	25	26	28	29	30	31	32	33	34	36	37\nA	7	96538	315201	548839	790432	1076164	1398487	1573973	2126789	2319888	2476145	2719629	3104355	3848915	4680851	5119313	5728204	6017362\nA	8	7	9	11	12	16	17	19	20	23	24	25	26	27	28	29	30	32	33	34	35	36	37\nA	8	104059	340521	575397	598667	730601	874891	1031666	1207955	1586525	1789920	1999437	2212664	2426813	2640369	2891930	3101562	4552178	4702845	5194145	5391701	5583471	5980715\nA	9	7	8	9	13	16	19	20	21	24	25	29	30	32	33	34	35	36	37\nA	9	132560	164006	372979	609833	742638	886787	1062302	1218761	1592526	1792839	2003338	2184023	3101158	3924506	4507747	4973889	5401917	6009373\nA	10	9	11	13	17	18	20	21	22	24	27	29	30	31	32	33	34	35	36	37\nA	10	324409	357534	623610	757573	902853	909206	1067280	1237160	1609646	1817246	2022196	2419619	2783432	3570567	3879836	4975409	5440679	5642926	5939927\nA	11	7	9	10	12	16	18	20	21	22	24	26	28	30	31	32	33	34	35	36	37\nA	11	117995	154722	400153	647914	786639	937009	943936	1106758	1282624	1668114	1872973	2017978	2273019	2536949	4218666	4403261	4468965	5056592	5666311	5905597\nA	12	7	8	9	15	17	20	23	27	28	29	30	31	32	33	35	36	37\nA	12	71839	198506	428993	695079	845941	1200927	1398197	1632659	1915787	2585372	2761979	4120492	4658063	4738568	5117025	5317328	5909455\nA	13	9	10	12	16	18	20	21	23	24	28	29	30	31	32	33	34	35	36\nA	13	137398	430505	466051	759294	929369	938164	1126042	1331323	1553597	2036437	2290055	2527384	3002131	3158014	4072786	4485948	5598397	5885200\nA	14	8	9	11	12	15	20	21	23	26	27	28	29	30	31	32	33	34	35	36	37\nA	14	148709	200134	465618	505531	827984	1049523	1239729	1473167	2260243	2533591	2823952	3274495	3625283	3641730	4060536	4694770	4937862	5402179	5565133	5872256\nA	15	8	9	10	16	18	20	22	23	26	27	28	30	31	32	33	34	35	36\nA	15	153569	195487	510451	820000	1000072	1011170	1208682	1424778	2160495	2337843	2598651	2634192	3283826	3401321	4383394	4515770	5606404	5823629\nA	16	9	10	11	16	19	20	22	23	30	31	32	33	34	35	36\nA	16	49626	220976	567927	908124	1107788	1121526	1343325	1846893	2439953	2728332	2769637	3589464	4534103	5350297	5942760\nA	17	9	11	12	16	20	21	24	25	27	28	29	30	31	32	33	34	35	36\nA	17	237597	307335	607569	977101	992342	1213415	1482360	1727723	2031878	2294169	2969134	3158835	3313244	4058250	4191867	4700170	4967877	5859407\nA	18	9	10	11	17	19	20	23	26	30	31	32	33	34	35	36	37\nA	18	141119	337764	651146	1035348	1263489	1281768	1536713	2112562	3288857	3488450	4505540	4766033	5037180	5081497	5660623	5949053\nA	19	9	10	13	17	20	22	26	27	29	30	31	32	33	34	35	36	37\nA	19	277042	362153	696320	1118271	1138234	1672324	1994785	2300179	3161210	3574580	4080514	4358953	4677353	4976347	5265239	5578040	5863471\nA	20	10	11	13	18	20	21	25	26	28	29	30	31	32	33	34	35	36	37\nA	20	289187	379471	712117	1125411	1147159	1391401	1661348	1953484	2223673	2241258	3345424	3571800	3882595	4227247	4727537	4840949	5279838	5850566\nA	21	9	10	13	18	20	24	25	27	28	29	30	31	32	33	34	35	36\nA	21	179802	409032	756622	1190621	1215755	1761870	2095297	2421908	2434842	2651920	3276896	4087523	4305650	4813871	5129206	5202317	5901534\nA	22	10	11	14	20	21	26	29	30	31	32	33	34	35	36	37	38\nA	22	335332	444063	815338	1317192	1600502	1912759	1978134	2948073	4174575	4190168	4465480	4761947	4982169	5157798	5284558	5847544\nA	23	11	14	19	20	22	23	25	28	29	30	31	32	33	34	35	36	37\nA	23	456825	822616	1282020	1312307	1584086	1884370	2212646	2233237	2480556	2808784	3365865	4311613	4631654	4947501	5443585	5546622	5832003\nA	24	10	11	15	19	20	23	25	26	27	30	31	32	33	34	35\nA	24	104215	492633	882492	1379063	1412678	1707949	2030285	2375000	2728876	2751461	4053833	4704468	5434152	5573421	5819903\nA	25	10	11	14	18	20	22	24	27	29	30	31	32	33	34	35	36	37	38\nA	25	381151	510653	900146	1391689	1428273	1718330	2054593	2063968	2496758	3158901	3852864	4086488	4138178	4675220	5118526	5180366	5374668	5797343\nA	26	10	11	14	19	20	24	25	27	29	30	31	32	33	34	35	36	37\nA	26	120509	549583	967231	1499239	1539788	1852755	2191380	2578293	3263315	3294585	3756842	3984289	4595934	4848188	5176015	5593830	5772490\nA	27	10	11	14	20	23	26	27	29	30	31	32	33	34	35	36\nA	27	150026	579195	1003259	1586854	1901669	2673253	3711574	3718755	3987959	4574097	5086826	5222242	5571060	5703712	5752000\nA	28	6	8	12	18	20	21	22	25	26	28	29	30	31	32	33	34	35	36\nA	28	139566	608436	1042805	1591955	1640850	1959475	2299841	2655758	3021783	3827616	4344084	4516207	5234626	5306456	5478556	5504823	5698020	5722786\nA	29	7	8	9	12	18	20	22	25	26	27	28	30	31	32	33	34	35	36\nA	29	150953	320822	645683	1101810	1677070	2064215	2418775	2794760	3168185	3838664	4154796	4613304	4711395	5203192	5439945	5445682	5579941	5700835\nA	30	6	7	9	13	18	20	21	24	25	27	28	29	30	31	32	33	34	35	36\nA	30	165584	349707	699216	1190798	1811250	1870513	2225764	2596464	2972126	3628979	3734009	4008250	4143627	4709056	4953734	5079134	5099381	5648173	5697177\nA	31	7	8	9	13	17	20	21	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	31	177258	371434	725038	1209947	1814202	1880136	2224576	2587553	2955822	3317054	3321104	3330784	4226771	4543801	4551664	4771654	5004330	5156931	5377873	5416538	5581305	5666319\nA	32	7	8	9	13	17	20	21	23	26	27	28	29	30	31	32	33	34	35	36\nA	32	188094	392498	760641	1263919	1891566	1962948	2319997	3078641	3208939	3576697	4237486	4443454	4949161	5301572	5449815	5495104	5525566	5697795	5721833\nA	33	7	8	9	13	18	20	22	25	26	28	29	30	31	32	33	34	35	36\nA	33	204953	421909	804816	1323920	1966831	2047429	2785494	3146513	3532953	4029247	4357392	4375527	5331899	5537329	5628224	5635173	5653283	5675260\nA	34	7	8	10	13	17	20	21	22	24	26	27	28	29	31	32	33	34	35	36\nA	34	219274	451699	854583	1398690	2071048	2157200	2530688	2913096	3291315	3658183	4301982	4729785	4857993	5239765	5246246	5260078	5533833	5567894	5629503\nA	35	6	7	9	13	17	20	21	24	26	27	28	29	30	31	32	33	34	35	36\nA	35	239479	487007	910380	1473394	2163097	2259726	2637451	3396012	3983883	3997015	4607499	4841638	4913884	5172484	5352858	5387468	5569000	5580834	5607679\nA	36	6	8	9	13	17	20	21	22	23	24	25	27	28	29	30	31	32	33	34	35\nA	36	253721	513866	950470	1531987	2237349	2342120	2726622	3119383	3495932	3844123	4602169	4718326	4941893	5084863	5367711	5465358	5510373	5568571	5589961	5601107\nA	37	7	8	9	13	18	19	20	23	24	25	26	27	28	29	30	31	32	33	35	37\nA	37	270017	540653	989638	1578240	2286140	2668117	2782515	3171506	3895697	4463643	4479767	5066686	5100402	5113033	5340141	5397677	5515103	5519391	5532152	5595585\nA	38	6	8	9	13	18	20	21	24	25	26	27	28	29	30	31	32	33	34	35	36\nA	38	288543	574974	1044227	1656222	2385441	2900067	3287186	3656287	4203613	4551224	4850659	4926967	5150188	5158902	5379395	5392594	5439966	5466208	5563164	5588719\nA	39	6	8	10	14	17	20	22	23	25	26	27	28	29	30	31	32	33	34	35	36\nA	39	307989	608556	1092642	1721089	2465415	2994161	3380540	3745141	3757122	4613680	4718547	5174593	5227691	5330467	5435977	5450129	5463824	5527290	5537750	5560499\nA	40	7	8	10	13	17	20	22	23	24	25	26	27	28	30	31	32	33	34	35\nA	40	327911	645155	1148950	1796723	2554781	3101714	3490492	3856944	3917721	4246141	4833398	5081323	5311097	5398432	5484255	5548406	5556657	5570820	5580696\nA	41	6	8	10	14	17	20	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nA	41	353177	690138	1220190	1895336	2669386	3227077	3952936	3955465	4354364	4942124	5181219	5211681	5287497	5326438	5395707	5400913	5413849	5426826	5440100	5463129	5526650\nA	42	6	8	10	13	17	19	20	21	22	23	24	25	26	27	28	29	31	32	33	34	37\nA	42	374400	727696	1274961	1967057	2747747	3143427	3319914	3694426	4033458	4326691	4766660	5069722	5079554	5197575	5224723	5306093	5361313	5388129	5418909	5441977	5510310\nA	43	6	8	10	13	16	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34\nA	43	396725	765310	1331655	2040445	2830086	3224228	3415582	3784364	3786717	4117989	4533646	4603857	5148749	5277848	5351832	5384320	5433668	5441246	5483234	5491941	5497664\nA	44	6	8	10	13	17	20	21	22	24	25	26	27	28	29	30	31	32	33	34\nA	44	419910	805501	1390951	2114427	2911524	3873714	4193554	4462727	4853962	5082874	5151526	5229326	5311508	5355816	5358098	5376312	5386581	5465788	5473301\nA	45	6	8	10	13	17	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34\nA	45	449101	855191	1463501	2206783	3010750	3620875	3622898	4278355	4982553	5110647	5195063	5202093	5320705	5384874	5391056	5399108	5408498	5433257	5437042	5442589\nA	46	6	8	10	13	16	17	18	20	21	23	24	25	27	28	30	31	32	34	35\nA	46	472481	896033	1523586	2285906	2287840	3095109	3476027	4353057	4357381	5113629	5167713	5185317	5296369	5341062	5343053	5350409	5360390	5418292	5428203\nA	47	6	8	10	13	16	19	20	22	24	25	26	27	28	30	31	32	33	34\nA	47	501986	946443	1598936	2377640	3183620	3553591	4416936	4717382	5010771	5163965	5212273	5272353	5303191	5335145	5344658	5370159	5373943	5386473\nA	48	6	8	10	13	17	19	20	22	23	24	25	26	27	29	30	31	32	33	34\nA	48	535502	1003131	1682231	2476803	3278979	3953674	4240603	4809210	5097942	5165270	5249902	5253843	5293048	5304982	5342738	5354711	5364514	5373279	5378317\nA	49	6	8	10	13	14	17	20	21	22	23	24	25	26	27	28	29	30	31	32	34\nA	49	560285	1053255	1762986	1764575	2578708	3377662	4568922	4814768	5016103	5029199	5102216	5163267	5181792	5261717	5313778	5330060	5335783	5340183	5362890	5368950\nT	0	7	8	12	14	15	16	19	20	22	25	26	27	28	29	31	33	34	36\nT	0	10758	153201	252134	302856	366015	418358	580418	583130	640147	695989	836108	908225	1029987	1321618	4597280	5207567	5373490	5673401\nT	1	7	8	12	14	15	16	19	20	22	25	26	27	28	29	31	33	34	36\nT	1	13086	224531	373037	448096	539059	614906	840675	843531	919363	994702	1153539	1234387	1388707	1701158	4079197	4706484	4865491	5178539\nT	2	5	8	9	11	13	15	16	20	21	24	26	27	29	30	31	33	34	36\nT	2	65927	231077	244373	395496	471060	546241	621687	700441	925292	1077058	1227881	1384542	1538828	1850195	4288781	4919150	4997697	5384196\nT	3	4	6	7	13	16	20	23	25	26	28	29	30	31	34	36\nT	3	14168	82646	233331	480077	634263	870718	1027490	1187622	1263083	1508284	1749395	1993675	2320304	4750447	5228327\nT	4	5	6	8	10	11	13	16	17	20	24	25	27	29	30	31	32	33	34	36\nT	4	15630	87988	243853	262647	422720	585636	668247	751498	923880	1097908	1276704	1351139	1437606	1709068	2258613	4236837	4472480	4919404	5248407\nT	5	7	8	12	14	17	18	20	22	24	25	27	28	30	31	32	33	34	36	37\nT	5	91051	268990	431344	513455	596354	680017	683924	940124	1027387	1118220	1210873	1392506	1832100	2008995	2383481	4090805	4719373	4951861	5046087\nT	6	7	8	11	15	16	18	20	21	22	24	25	27	28	29	30	31	32	33	34	36	37\nT	6	79620	262712	454855	542575	629499	718371	722578	813264	996377	1089687	1184353	1281880	1474136	1883972	2240745	2340407	2442999	4199935	4775467	5240469	5340316\nT	7	7	9	11	18	20	24	25	26	28	29	30	31	32	33	34	36	37\nT	7	80667	272580	463767	637719	817929	995481	1085428	1362806	1455095	1551673	1725513	1910579	2386304	4283611	4566894	5250805	5443557\nT	8	7	9	11	12	16	17	19	20	23	24	25	26	27	28	29	30	32	33	34	35	36	37\nT	8	85193	284725	464851	484785	576497	669716	763319	863373	1058117	1156917	1258057	1360084	1463490	1567840	1769725	1875781	4033429	4278545	4678635	4785871	5106108	5419055\nT	9	7	8	9	13	16	19	20	21	24	25	29	30	32	33	34	35	36	37\nT	9	108698	133428	311334	492708	584523	676514	775232	867680	1055893	1152232	1250395	1353900	1854103	3623799	4110775	4420436	5086876	5497580\nT	10	9	11	13	17	18	20	21	22	24	27	29	30	31	32	33	34	35	36	37\nT	10	281575	308371	519191	613595	708630	714892	810118	905818	1098510	1199024	1297363	1583344	1871799	2380656	2652015	4740977	5052343	5387072	5593956\nT	11	7	9	10	12	16	18	20	21	22	24	26	28	30	31	32	33	34	35	36	37\nT	11	100500	130144	349278	546772	645385	744610	751653	850701	950971	1152366	1254291	1362208	1551265	1743558	4212800	4320594	4415138	4811629	5472149	5682767\nT	12	7	8	9	15	17	20	23	27	28	29	30	31	32	33	35	36	37\nT	12	59772	167023	367852	574125	678154	897202	1004492	1117227	1347392	1849797	1969417	4013576	4465172	4640052	4952748	5319558	5666864\nT	13	9	10	12	16	18	20	21	23	24	28	29	30	31	32	33	34	35	36\nT	13	113448	355814	385770	599771	708361	716469	826942	938888	1053317	1288799	1411341	1538597	2828719	3107184	3793368	4140296	5109884	5623514\nT	14	8	9	11	12	15	20	21	23	26	27	28	29	30	31	32	33	34	35	36	37\nT	14	121177	161570	376895	410105	634882	760724	876058	996241	1373222	1507045	1699802	2048454	2306845	2373292	2653243	3193461	3641248	4883007	5334224	5600692\nT	15	8	9	10	16	18	20	22	23	26	27	28	30	31	32	33	34	35	36\nT	15	128614	164494	431200	660065	776994	787542	905375	1024688	1394206	1528697	1655918	1750831	2215457	2422974	4024445	4252006	5329598	5760963\nT	16	9	10	11	16	19	20	22	23	30	31	32	33	34	35	36\nT	16	41460	180893	463946	707134	832041	844122	972274	1235399	1601133	1798940	1950819	2679098	4076387	5044650	5659472\nT	17	9	11	12	16	20	21	24	25	27	28	29	30	31	32	33	34	35	36\nT	17	193381	247586	489588	742592	755556	886526	1023690	1157949	1375187	1532139	2023061	2419525	2571459	3624286	3773260	4130381	4664351	5661200\nT	18	9	10	11	17	19	20	23	26	30	31	32	33	34	35	36	37\nT	18	112269	271361	522640	788261	926668	942160	1084035	1378165	2166442	2556521	3326961	3627871	4038765	4231740	5477053	5639791\nT	19	9	10	13	17	20	22	26	27	29	30	31	32	33	34	35	36	37\nT	19	222405	288868	550439	827295	843891	1138000	1295759	1449697	2096227	2496600	3287947	3549099	3832576	4177348	4822204	5318207	5639923\nT	20	10	11	13	18	20	21	25	26	28	29	30	31	32	33	34	35	36	37\nT	20	239296	312099	580466	862664	882308	1029154	1179881	1333805	1572753	1648083	2296834	2575123	2742799	3119599	3833746	4119546	5048723	5673235\nT	21	9	10	13	18	20	24	25	27	28	29	30	31	32	33	34	35	36\nT	21	148917	338273	616888	912121	933985	1247735	1500448	1669921	1731617	2073121	2430440	3042945	3344976	4215403	4673334	5003196	5647823\nT	22	10	11	14	20	21	26	29	30	31	32	33	34	35	36	37	38\nT	22	273611	361676	652023	984461	1146137	1312746	1522436	2588582	3380992	3456226	3671247	4098655	4581729	5133810	5302686	5677373\nT	23	11	14	19	20	22	23	25	28	29	30	31	32	33	34	35	36	37\nT	23	380930	672953	983909	1011263	1174274	1341266	1543282	1639610	1860920	2097914	2512393	3556242	3833622	4395843	5032502	5360617	5700202\nT	24	10	11	15	19	20	23	25	26	27	30	31	32	33	34	35\nT	24	87453	405944	710306	1034813	1065088	1236840	1412152	1592968	1780345	1874872	2847920	3414139	4640013	5108523	5713128\nT	25	10	11	14	18	20	22	24	27	29	30	31	32	33	34	35	36	37	38\nT	25	317260	422339	732665	1060567	1093246	1265087	1444359	1498417	1933425	2311990	2758114	3177596	3355752	4204053	4782160	5005414	5192202	5813433\nT	26	10	11	14	19	20	24	25	27	29	30	31	32	33	34	35	36	37\nT	26	100074	452905	773916	1115793	1151870	1331375	1515981	1835417	2234104	2381029	2880119	3166450	3610876	4339963	4822330	5466610	5794809\nT	27	10	11	14	20	23	26	27	29	30	31	32	33	34	35	36\nT	27	121467	477728	807478	1195753	1377376	1915406	2514469	2557968	2879240	3352237	4222345	4504771	5295119	5683519	5895062\nT	28	6	8	12	18	20	21	22	25	26	28	29	30	31	32	33	34	35	36\nT	28	116262	507802	848867	1207255	1252140	1437847	1627997	1829275	2099525	2694152	3227380	3474921	4420931	4582211	5078596	5230903	5879397	5991315\nT	29	7	8	9	12	18	20	22	25	26	27	28	30	31	32	33	34	35	36\nT	29	126385	265197	538530	890920	1263868	1507762	1706459	1996345	2247278	2672512	3000972	3857305	4037936	4728433	5035156	5068927	5562350	5973938\nT	30	6	7	9	13	18	20	21	24	25	27	28	29	30	31	32	33	34	35	36\nT	30	137650	287622	573109	938381	1326927	1380604	1584471	1792676	2005636	2448335	2839063	3352887	3717576	4150441	4402815	4685941	4810470	5714729	5937624\nT	31	7	8	9	13	17	20	21	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	31	145988	305347	602638	975215	1368958	1429152	1634281	1843739	2058693	2279278	2297030	2358130	3051883	3415255	3463088	3946585	4647630	5053460	5398758	5632949	5838118	6014967\nT	32	7	8	9	13	17	20	21	23	26	27	28	29	30	31	32	33	34	35	36\nT	32	158956	329427	639474	1024475	1433153	1499548	1714109	2181632	2396050	2626957	3114607	3471493	3921169	4557703	4923501	5120404	5301607	5888184	5999941\nT	33	7	8	9	13	18	20	22	25	26	28	29	30	31	32	33	34	35	36\nT	33	171951	353659	678060	1072841	1489783	1563848	2002361	2235454	2526422	3071287	3824875	3943643	5070677	5457286	5870153	5913277	6014650	6127995\nT	34	7	8	10	13	17	20	21	22	24	26	27	28	29	31	32	33	34	35	36\nT	34	184510	378032	714588	1124408	1557269	1637946	1864574	2095371	2330037	2603697	3213764	3959929	4363872	5113628	5139275	5210824	5749716	5950688	6124694\nT	35	6	7	9	13	17	20	21	24	26	27	28	29	30	31	32	33	34	35	36\nT	35	201070	408365	763628	1188270	1633342	1725235	1955944	2429769	2928763	3016502	3626823	4017758	4205483	4836635	5205924	5399193	6029715	6113240	6245224\nT	36	6	8	9	13	17	20	21	22	23	24	25	27	28	29	30	31	32	33	34	35\nT	36	216113	436922	805639	1244561	1702244	1802208	2041181	2299057	2545716	2799046	3530499	3768642	4465465	4689224	5252354	5531098	5788981	6053359	6198958	6277086\nT	37	7	8	9	13	18	19	20	23	24	25	26	27	28	29	30	31	32	33	35	37\nT	37	233154	467184	851412	1302877	1772741	2017794	2129863	2403200	2985885	3502596	3597258	4563270	4751484	4834225	5433896	5669825	6052757	6075057	6162005	6346289\nT	38	6	8	9	13	18	20	21	24	25	26	27	28	29	30	31	32	33	34	35	36\nT	38	250438	498094	897358	1362814	1848037	2224427	2480008	2738979	3263643	3608753	4329297	4628056	5060345	5122755	5471731	5526684	5755716	5931422	6231284	6364152\nT	39	6	8	10	14	17	20	22	23	25	26	27	28	29	30	31	32	33	34	35	36\nT	39	270390	533844	949366	1429087	1929101	2324262	2586374	2851083	2928910	3763757	4122468	4833988	5094512	5481528	5797529	5858500	5935798	6207625	6284590	6413559\nT	40	7	8	10	13	17	20	22	23	24	25	26	27	28	30	31	32	33	34	35\nT	40	288464	565541	992571	1483193	1990971	2405310	2672931	2968893	3161049	3477500	4230331	4692189	5234653	5508308	5859579	6243514	6286168	6388751	6462629\nT	41	6	8	10	14	17	20	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nT	41	310840	605818	1054144	1568579	2100194	2535644	3090049	3098545	3602185	4377517	4839989	4989737	5222924	5476921	5785136	5802154	5855141	5924549	6014940	6179453	6479616\nT	42	6	8	10	13	17	19	20	21	22	23	24	25	26	27	28	29	31	32	33	34	37\nT	42	335214	649207	1117501	1647765	2193703	2476493	2656281	2939402	3223281	3511369	4064451	4724996	4785144	5178814	5375886	5694816	5903883	6060166	6243748	6411471	6600611\nT	43	6	8	10	13	16	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34\nT	43	358096	687620	1170967	1717251	2276834	2567161	2763863	3053379	3060826	3351015	3906863	4129677	5072963	5459878	5772148	5932490	6255988	6281481	6542668	6590091	6627583\nT	44	6	8	10	13	17	20	21	22	24	25	26	27	28	29	30	31	32	33	34\nT	44	384513	732835	1237190	1802655	2379736	3211722	3506892	3805574	4369257	4874380	5195958	5498142	5803490	6019947	6026913	6125661	6172961	6654213	6710800\nT	45	6	8	10	13	17	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34\nT	45	409783	776043	1295363	1876055	2467179	3011672	3017812	3623530	4820328	5168733	5533348	5586316	6098323	6423586	6468518	6530440	6563599	6719269	6739372	6777145\nT	46	6	8	10	13	16	17	18	20	21	23	24	25	27	28	30	31	32	34	35\nT	46	437507	823755	1362818	1963152	1968989	2576908	2890911	3767760	3792923	5185123	5479312	5601939	6173644	6478131	6484370	6510226	6556530	6755295	6835078\nT	47	6	8	10	13	16	19	20	22	24	25	26	27	28	30	31	32	33	34\nT	47	468713	876297	1435725	2057651	2683829	3005139	3916415	4523110	5105791	5610912	5814850	6183917	6409776	6586548	6620851	6785361	6804932	6895332\nT	48	6	8	10	13	17	19	20	22	23	24	25	26	27	29	30	31	32	33	34\nT	48	496606	921315	1498807	2138123	2777440	3430092	3737681	4824125	5407727	5693727	6129143	6149609	6394387	6483354	6717580	6806917	6852536	6905502	6939589\nT	49	6	8	10	13	14	17	20	21	22	23	24	25	26	27	28	29	30	31	32	34\nT	49	511527	952197	1556853	1561440	2229620	2891303	4196328	4784962	5195976	5258387	5501526	5845194	5990251	6359585	6576163	6696883	6714369	6729210	6872855	6914116\nG	0	7	8	12	14	15	16	19	20	22	25	26	27	28	29	31	33	34	36\nG	0	7760	136109	230215	278517	336678	385454	534471	536063	585238	635422	734128	783573	882371	1080471	3484292	3875335	3974494	4169891\nG	1	7	8	12	14	15	16	19	20	22	25	26	27	28	29	31	33	34	36\nG	1	8267	156511	262951	316553	379532	432378	591457	593189	644905	697278	802759	855265	958830	1169237	3356771	3776984	3884293	4093185\nG	2	5	8	9	11	13	15	16	20	21	24	26	27	29	30	31	33	34	36\nG	2	43068	155397	163504	267411	319530	371347	422834	475591	627632	726943	826402	926293	1025637	1226336	3265089	3676311	3727899	3983837\nG	3	4	6	7	13	16	20	23	25	26	28	29	30	31	34	36\nG	3	9363	56645	166975	345550	456311	623272	731648	839534	895274	1059760	1231084	1393371	1618996	3826049	4162258\nG	4	5	6	8	10	11	13	16	17	20	24	25	27	29	30	31	32	33	34	36\nG	4	10274	59766	171868	183797	298044	412616	470023	527588	644200	759482	875401	931305	988738	1166245	1527757	3341531	3515002	3819468	4056679\nG	5	7	8	12	14	17	18	20	22	24	25	27	28	30	31	32	33	34	36	37\nG	5	64618	197873	320504	382112	444126	505683	508316	694204	756266	819183	882796	1012347	1332018	1460266	1725489	3334960	3794068	3975687	4042417\nG	6	7	8	11	15	16	18	20	21	22	24	25	27	28	29	30	31	32	33	34	36	37\nG	6	54035	184662	320662	382513	444230	506246	508955	571666	697194	760067	823411	887933	1019148	1290843	1540126	1605260	1674019	3157067	3547709	3868964	3937393\nG	7	7	9	11	18	20	24	25	26	28	29	30	31	32	33	34	36	37\nG	7	54729	188602	323940	449079	576979	702446	765263	957513	1021639	1088372	1208565	1337024	1667747	3050992	3248018	3726107	3860834\nG	8	7	9	11	12	16	17	19	20	23	24	25	26	27	28	29	30	32	33	34	35	36	37\nG	8	58319	198552	327268	340395	405612	471221	537203	606884	741046	809075	877466	946592	1016567	1087552	1226013	1297195	2866285	3033477	3306176	3378718	3595082	3809526\nG	9	7	8	9	13	16	19	20	21	24	25	29	30	32	33	34	35	36	37\nG	9	73914	89840	216528	347417	413908	480671	552433	620288	758020	827926	898302	972561	1330225	2475162	2814128	3033962	3471123	3762556\nG	10	9	11	13	17	18	20	21	22	24	27	29	30	31	32	33	34	35	36	37\nG	10	198478	216104	369729	440012	511978	515703	587810	660609	807917	885935	961415	1166382	1370977	1748990	1935420	3170791	3404105	3614758	3768872\nG	11	7	9	10	12	16	18	20	21	22	24	26	28	30	31	32	33	34	35	36	37\nG	11	68639	87863	241267	384336	458037	532188	536098	611826	688212	844265	923822	1003356	1134784	1269122	2681164	2764140	2823620	3111942	3545104	3695433\nG	12	7	8	9	15	17	20	23	27	28	29	30	31	32	33	35	36	37\nG	12	39773	114138	258019	409910	487513	650702	731839	817706	978835	1322088	1409267	2608958	2919700	3018914	3230760	3446166	3701447\nG	13	9	10	12	16	18	20	21	23	24	28	29	30	31	32	33	34	35	36\nG	13	80138	254716	274887	433516	515719	520982	604486	689791	776406	955001	1047739	1143451	1858806	2023193	2496866	2732818	3389563	3698637\nG	14	8	9	11	12	15	20	21	23	26	27	28	29	30	31	32	33	34	35	36	37\nG	14	86062	113530	270665	293332	461093	556299	643592	734410	1020492	1121509	1251505	1489193	1669765	1703452	1907907	2284646	2553487	3242838	3489432	3673931\nG	15	8	9	10	16	18	20	22	23	26	27	28	30	31	32	33	34	35	36\nG	15	92594	117527	312932	490936	583781	590378	686071	784186	1092292	1192558	1298648	1344077	1682301	1796999	2616469	2744743	3433365	3666014\nG	16	9	10	11	16	19	20	22	23	30	31	32	33	34	35	36\nG	16	29380	131938	341368	529524	628897	637026	738026	948779	1214349	1350356	1418499	1891125	2667529	3259872	3650048\nG	17	9	11	12	16	20	21	24	25	27	28	29	30	31	32	33	34	35	36\nG	17	140865	179477	361546	558071	566872	670484	780651	887144	1033715	1154183	1488743	1702714	1806063	2398544	2497429	2751305	3035808	3655283\nG	18	9	10	11	17	19	20	23	26	30	31	32	33	34	35	36	37\nG	18	81377	201291	395036	604615	715072	726138	840665	1079096	1659012	1862372	2384592	2577049	2801405	2881023	3518368	3645826\nG	19	9	10	13	17	20	22	26	27	29	30	31	32	33	34	35	36	37\nG	19	168221	216796	418183	638458	650381	888128	1016642	1141957	1587469	1834353	2258962	2427609	2613158	2825642	3147757	3422265	3629841\nG	20	10	11	13	18	20	21	25	26	28	29	30	31	32	33	34	35	36	37\nG	20	177737	229355	439563	669499	682213	803888	930668	1061235	1223041	1252805	1774545	1939935	2080246	2313741	2708940	2846197	3318016	3733605\nG	21	9	10	13	18	20	24	25	27	28	29	30	31	32	33	34	35	36\nG	21	109361	254745	475057	717067	732417	997836	1172585	1315622	1337397	1526673	1818378	2250038	2427802	2880272	3124581	3244604	3679798\nG	22	10	11	14	20	21	26	29	30	31	32	33	34	35	36	37	38\nG	22	209828	274370	504511	777717	914744	1056787	1144278	1787800	2390860	2417627	2570531	2803839	3031647	3265804	3366384	3655883\nG	23	11	14	19	20	22	23	25	28	29	30	31	32	33	34	35	36	37\nG	23	288639	527325	794211	812330	955615	1105201	1269511	1299267	1450622	1625623	1933643	2558978	2746085	3021592	3386855	3515293	3727474\nG	24	10	11	15	19	20	23	25	26	27	30	31	32	33	34	35\nG	24	64621	312697	562739	844861	865125	1017254	1175442	1339417	1506205	1537713	2249768	2650095	3268498	3436097	3686247\nG	25	10	11	14	18	20	22	24	27	29	30	31	32	33	34	35	36	37	38\nG	25	252287	332753	597027	895795	917693	1080291	1253990	1265925	1538011	1880886	2243469	2431756	2486210	2881373	3177245	3245944	3369471	3681605\nG	26	10	11	14	19	20	24	25	27	29	30	31	32	33	34	35	36	37\nG	26	77026	357466	631895	944147	968485	1136699	1312552	1529043	1882417	1920728	2216780	2371374	2708117	2966853	3189628	3505549	3654705\nG	27	10	11	14	20	23	26	27	29	30	31	32	33	34	35	36\nG	27	95129	381700	671496	1030018	1209564	1645960	2195152	2203174	2374549	2706765	3086726	3190594	3466459	3581393	3631241\nG	28	6	8	12	18	20	21	22	25	26	28	29	30	31	32	33	34	35	36\nG	28	90610	407935	714888	1066411	1095682	1285437	1480449	1674433	1883927	2335539	2637759	2747191	3195882	3248971	3383954	3407884	3574371	3597142\nG	29	7	8	9	12	18	20	22	25	26	27	28	30	31	32	33	34	35	36\nG	29	98539	209011	436955	755854	1121590	1350403	1550430	1759112	1967574	2332200	2518421	2849816	2919705	3234842	3381795	3387413	3502617	3607224\nG	30	6	7	9	13	18	20	21	24	25	27	28	29	30	31	32	33	34	35	36\nG	30	108395	229110	470244	803822	1184137	1220406	1422174	1627859	1832726	2194788	2287081	2480561	2599397	2919662	3066672	3160515	3181181	3544843	3590856\nG	31	7	8	9	13	17	20	21	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	31	112933	238253	487910	832627	1228659	1266978	1478126	1692062	1903856	2109135	2112894	2122199	2640083	2835100	2842443	3000976	3198054	3313743	3456668	3493111	3597614	3658744\nG	32	7	8	9	13	17	20	21	23	26	27	28	29	30	31	32	33	34	35	36\nG	32	123997	259260	520429	876371	1284494	1327157	1543655	1980398	2064995	2270624	2639306	2770398	3058392	3299644	3404605	3442492	3470073	3599129	3619294\nG	33	7	8	9	13	18	20	22	25	26	28	29	30	31	32	33	34	35	36\nG	33	133937	277839	554125	933466	1365064	1412222	1861922	2066103	2292932	2571290	2778257	2792944	3353286	3478116	3546835	3552481	3566447	3583147\nG	34	7	8	10	13	17	20	21	22	24	26	27	28	29	31	32	33	34	35	36\nG	34	143892	297988	587645	978792	1422972	1473737	1704086	1931580	2149636	2358464	2724207	2984216	3074109	3327262	3333007	3344889	3514696	3542531	3584108\nG	35	6	7	9	13	17	20	21	24	26	27	28	29	30	31	32	33	34	35	36\nG	35	153985	317594	623086	1037267	1500049	1555281	1792360	2239404	2568961	2579551	2921635	3055661	3100549	3257243	3364295	3390400	3518356	3527580	3546420\nG	36	6	8	9	13	17	20	21	22	23	24	25	27	28	29	30	31	32	33	34	35\nG	36	166826	342168	663906	1092399	1566906	1628088	1867402	2101033	2314164	2505776	2911003	2976431	3123089	3200137	3359880	3417716	3450108	3489235	3505500	3513659\nG	37	7	8	9	13	18	19	20	23	24	25	26	27	28	29	30	31	32	33	35	37\nG	37	175748	356823	688187	1129782	1615663	1858523	1924126	2159157	2568090	2873161	2885033	3200664	3223450	3232631	3360880	3395967	3478227	3481466	3490240	3526416\nG	38	6	8	9	13	18	20	21	24	25	26	27	28	29	30	31	32	33	34	35	36\nG	38	188001	381452	727550	1184467	1681701	1996341	2226644	2437084	2727812	2920928	3086341	3131659	3251109	3257129	3374721	3384486	3415332	3434464	3499356	3515581\nG	39	6	8	10	14	17	20	22	23	25	26	27	28	29	30	31	32	33	34	35	36\nG	39	201326	405758	768290	1242445	1751453	2075491	2305147	2510526	2519223	2975043	3045871	3281666	3313756	3373196	3432754	3442971	3453103	3491351	3498752	3513138\nG	40	7	8	10	13	17	20	22	23	24	25	26	27	28	30	31	32	33	34	35\nG	40	213320	427602	804725	1293324	1812891	2144421	2371933	2576024	2609267	2787003	3090410	3217993	3341812	3398376	3448269	3490165	3496041	3506083	3512879\nG	41	6	8	10	14	17	20	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nG	41	229287	459172	852851	1353749	1873554	2208264	2621879	2623632	2835594	3138281	3271223	3288813	3329908	3355234	3395577	3399219	3408436	3417802	3427161	3442159	3478658\nG	42	6	8	10	13	17	19	20	21	22	23	24	25	26	27	28	29	31	32	33	34	37\nG	42	243680	483069	891491	1405029	1928880	2168064	2265716	2480351	2665461	2818586	3040692	3192310	3199119	3261733	3279548	3323550	3353821	3371560	3390678	3405970	3449666\nG	43	6	8	10	13	16	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34\nG	43	258116	509007	930970	1456565	1987142	2225809	2331288	2541959	2543465	2722473	2930562	2975407	3252133	3318875	3359008	3376872	3407090	3412039	3438621	3444592	3448423\nG	44	6	8	10	13	17	20	21	22	24	25	26	27	28	29	30	31	32	33	34\nG	44	273622	537357	977380	1518165	2049872	2605746	2775846	2912909	3104049	3214437	3251693	3300350	3342287	3366241	3367657	3379232	3385853	3431187	3436047\nG	45	6	8	10	13	17	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34\nG	45	289335	565951	1021059	1572325	2102945	2456340	2457672	2817003	3168369	3232611	3277737	3282275	3353693	3389548	3393528	3398615	3404804	3420125	3422748	3426376\nG	46	6	8	10	13	16	17	18	20	21	23	24	25	27	28	30	31	32	34	35\nG	46	307342	599153	1068615	1628522	1629681	2157678	2381057	2854130	2856970	3225033	3255071	3265476	3324684	3351421	3352695	3357197	3363580	3399718	3405842\nG	47	6	8	10	13	16	19	20	22	24	25	26	27	28	30	31	32	33	34\nG	47	325757	630682	1115668	1681574	2203951	2420048	2886694	3033800	3181399	3264018	3288467	3323290	3341335	3359478	3365356	3380532	3382942	3390796\nG	48	6	8	10	13	17	19	20	22	23	24	25	26	27	29	30	31	32	33	34\nG	48	346878	667951	1168532	1739051	2251124	2626772	2782017	3064274	3206027	3246975	3291450	3293905	3315372	3323154	3344963	3352399	3358476	3364208	3367427\nG	49	6	8	10	13	14	17	20	21	22	23	24	25	26	27	28	29	30	31	32	34\nG	49	367850	705639	1219894	1220814	1797904	2305833	2960340	3082781	3186332	3194808	3231354	3265130	3276757	3324349	3350505	3360149	3363592	3366386	3380275	3384182\nC	0	7	8	12	14	15	16	19	20	22	25	26	27	28	29	31	33	34	36\nC	0	14825	154529	233653	270193	321275	355394	454132	458439	491355	524174	607656	651239	720804	891461	1897753	2253911	2353458	2528453\nC	1	7	8	12	14	15	16	19	20	22	25	26	27	28	29	31	33	34	36\nC	1	21027	256278	402220	472541	563898	631409	826571	832752	895359	958636	1087701	1153870	1279127	1531369	2732141	3230835	3358880	3609660\nC	2	5	8	9	11	13	15	16	20	21	24	26	27	29	30	31	33	34	36\nC	2	81997	252571	273396	415047	484046	550940	617742	689603	882371	1010332	1137301	1268429	1396422	1648406	2623550	3129476	3191733	3494833\nC	3	4	6	7	13	16	20	23	25	26	28	29	30	31	34	36\nC	3	23827	115195	267298	519877	667432	896511	1047113	1206628	1250826	1494690	1675117	1921785	2194982	3113351	3471410\nC	4	5	6	8	10	11	13	16	17	20	24	25	27	29	30	31	32	33	34	36\nC	4	26229	123778	282556	311683	466795	618545	692845	766683	922447	1073135	1228940	1269874	1345152	1580669	2049893	2747681	2889594	3242712	3465233\nC	5	7	8	12	14	17	18	20	22	24	25	27	28	30	31	32	33	34	36	37\nC	5	144703	355396	528429	615276	702339	791305	801578	1075848	1171228	1277339	1384378	1570094	1957107	2114895	2500769	2856904	3389856	3497243	3594359\nC	6	7	8	11	15	16	18	20	21	22	24	25	27	28	29	30	31	32	33	34	36	37\nC	6	112639	315819	521879	606328	691304	776211	786666	872117	1046134	1135756	1227334	1322575	1481419	1864322	2087533	2186162	2277617	2669560	3118853	3424813	3499640\nC	7	7	9	11	18	20	24	25	26	28	29	30	31	32	33	34	36	37\nC	7	114833	326297	532640	705765	890926	1069481	1161443	1449894	1547652	1638331	1769162	1965769	2392143	2756140	3004453	3357447	3527133\nC	8	7	9	11	12	16	17	19	20	23	24	25	26	27	28	29	30	32	33	34	35	36	37\nC	8	124471	351416	534796	572018	663001	754118	845325	950782	1139777	1236986	1335799	1436621	1539231	1643738	1798711	1904344	2747302	2849247	3148342	3253873	3382429	3635173\nC	9	7	8	9	13	16	19	20	21	24	25	29	30	32	33	34	35	36	37\nC	9	163891	208915	390718	573705	665504	757661	865049	959103	1153303	1253319	1356988	1459067	1943045	2335807	2680312	2956785	3214720	3573179\nC	10	9	11	13	17	18	20	21	22	24	27	29	30	31	32	33	34	35	36	37\nC	10	312125	360532	587274	681770	777090	790705	886955	984695	1183721	1291357	1395519	1616280	1815703	2258553	2425251	2975518	3249156	3365262	3541515\nC	11	7	9	10	12	16	18	20	21	22	24	26	28	30	31	32	33	34	35	36	37\nC	11	134223	186502	418735	611644	709516	808639	823288	923138	1025129	1234236	1341267	1429560	1564968	1705727	2592337	2696993	2735828	3065415	3411159	3558475\nC	12	7	8	9	15	17	20	23	27	28	29	30	31	32	33	35	36	37\nC	12	107833	252774	450765	653791	757074	984071	1091772	1209070	1376915	1738015	1841362	2562639	2872310	2918089	3133480	3251762	3568139\nC	13	9	10	12	16	18	20	21	23	24	28	29	30	31	32	33	34	35	36\nC	13	157365	433783	491358	706594	816363	836923	948527	1062132	1178249	1417285	1543387	1669009	1940275	2040872	2553532	2784448	3443923	3633656\nC	14	8	9	11	12	15	20	21	23	26	27	28	29	30	31	32	33	34	35	36	37\nC	14	168339	241731	460343	523842	748165	887967	1001878	1120771	1494245	1626577	1766262	2024054	2220953	2232442	2479163	2885135	3074039	3372676	3496443	3693274\nC	15	8	9	10	16	18	20	22	23	26	27	28	30	31	32	33	34	35	36\nC	15	169220	237039	533096	761819	880408	905121	1026615	1151047	1541994	1647555	1781981	1801403	2164255	2234262	2766528	2845712	3458643	3587070\nC	16	9	10	11	16	19	20	22	23	30	31	32	33	34	35	36\nC	16	82949	272514	603767	857590	992599	1023451	1162172	1453638	1772507	1928204	1944765	2371834	2840921	3275800	3588902\nC	17	9	11	12	16	20	21	24	25	27	28	29	30	31	32	33	34	35	36\nC	17	288865	390228	635301	896738	931209	1069208	1215965	1357634	1517447	1664155	2017683	2131813	2226868	2629544	2712705	2993746	3155993	3666490\nC	18	9	10	11	17	19	20	23	26	30	31	32	33	34	35	36	37\nC	18	224532	439610	702798	991826	1147176	1188586	1349548	1689094	2311202	2399337	2940946	3065052	3196522	3214021	3449899	3603929\nC	19	9	10	13	17	20	22	26	27	29	30	31	32	33	34	35	36	37\nC	19	332688	454512	720890	1010887	1054689	1369484	1538788	1705048	2173068	2402149	2663356	2822435	3000355	3176984	3351347	3534680	3708300\nC	20	10	11	13	18	20	21	25	26	28	29	30	31	32	33	34	35	36	37\nC	20	339861	466895	736733	1032674	1079674	1238000	1401198	1569998	1713990	1721430	2316641	2436721	2603127	2780425	3035441	3089719	3291707	3589631\nC	21	9	10	13	18	20	24	25	27	28	29	30	31	32	33	34	35	36\nC	21	278346	516703	805178	1126575	1181415	1535119	1729301	1914923	1920254	2016991	2350795	2776033	2874796	3089103	3241240	3271389	3617805\nC	22	10	11	14	20	21	26	29	30	31	32	33	34	35	36	37	38\nC	22	384736	532649	824228	1206240	1380366	1560239	1593514	2102728	2759990	2767977	2918353	3083939	3205232	3294231	3363780	3669068\nC	23	11	14	19	20	22	23	25	28	29	30	31	32	33	34	35	36	37\nC	23	554962	851483	1185016	1249208	1429733	1614571	1806754	1815976	1940637	2112872	2410204	2874137	3036428	3181685	3419684	3459853	3593403\nC	24	10	11	15	19	20	23	25	26	27	30	31	32	33	34	35\nC	24	161687	573982	878145	1217376	1285612	1468778	1656556	1848607	2038379	2048912	2733435	3077488	3438434	3510415	3634816\nC	25	10	11	14	18	20	22	24	27	29	30	31	32	33	34	35	36	37	38\nC	25	428762	596009	907946	1259141	1333214	1520983	1713758	1718451	1958987	2310586	2674221	2776608	2798655	3048695	3262202	3286034	3378274	3561347\nC	26	10	11	14	19	20	24	25	27	29	30	31	32	33	34	35	36	37\nC	26	182558	624764	946393	1305873	1386482	1579455	1774806	1987825	2352156	2367499	2606645	2724292	3051012	3161148	3332975	3544581	3633023\nC	27	10	11	14	20	23	26	27	29	30	31	32	33	34	35	36\nC	27	181203	646721	975486	1433729	1630525	2062068	2606811	2610839	2741997	3038471	3266357	3332456	3495472	3556716	3577456\nC	28	6	8	12	18	20	21	22	25	26	28	29	30	31	32	33	34	35	36\nC	28	207779	676376	1017269	1399980	1495343	1697693	1900577	2091954	2297691	2702388	2947829	3025489	3357667	3386711	3458327	3471626	3536248	3546087\nC	29	7	8	9	12	18	20	22	25	26	27	28	30	31	32	33	34	35	36\nC	29	220252	417843	706886	1056062	1446466	1755960	1961346	2161213	2366581	2709465	2864967	3062805	3107191	3342138	3458394	3461648	3522875	3574221\nC	30	6	7	9	13	18	20	21	24	25	27	28	29	30	31	32	33	34	35	36\nC	30	233854	441497	739868	1100194	1500083	1612660	1822236	2030872	2234515	2575644	2629333	2769496	2817058	3114131	3242693	3309459	3321890	3607609	3631549\nC	31	7	8	9	13	17	20	21	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	31	252913	469124	777162	1149630	1561205	1685767	1899173	2107471	2306640	2492045	2494117	2498814	2923927	3067402	3071384	3158652	3236583	3299543	3396756	3413918	3483184	3515944\nC	32	7	8	9	13	17	20	21	23	26	27	28	29	30	31	32	33	34	35	36\nC	32	271290	498264	816626	1202090	1625838	1763664	1981029	2395298	2445396	2628601	2935677	3014738	3232476	3351821	3405824	3423854	3438435	3504967	3513937\nC	33	7	8	9	13	18	20	22	25	26	28	29	30	31	32	33	34	35	36\nC	33	289037	523684	852926	1251642	1683286	1836096	2262395	2437279	2635622	2836675	2949660	2957360	3343726	3416748	3450103	3453080	3459808	3467572\nC	34	7	8	10	13	17	20	21	22	24	26	27	28	29	31	32	33	34	35	36\nC	34	301578	544188	880451	1287205	1728141	1890158	2112128	2322613	2518773	2697432	2988904	3169001	3218048	3353195	3356307	3363302	3476527	3490677	3513495\nC	35	6	7	9	13	17	20	21	24	26	27	28	29	30	31	32	33	34	35	36\nC	35	318486	567634	911894	1325032	1764176	1941496	2159432	2548776	2810828	2816785	3083714	3174657	3200404	3296348	3365136	3379298	3433396	3438455	3448266\nC	36	6	8	9	13	17	20	21	22	23	24	25	27	28	29	30	31	32	33	34	35\nC	36	333252	590246	944564	1368146	1816944	2005761	2225785	2431660	2617007	2777677	3095121	3137164	3202219	3255142	3367776	3403016	3420857	3442591	3452206	3457093\nC	37	7	8	9	13	18	19	20	23	24	25	26	27	28	29	30	31	32	33	35	37\nC	37	355394	623338	987566	1420405	1866826	2080281	2292173	2487645	2809337	3026615	3032640	3225117	3236562	3241509	3309883	3327672	3353293	3354892	3359477	3377583\nC	38	6	8	9	13	18	20	21	24	25	26	27	28	29	30	31	32	33	34	35	36\nC	38	372842	648329	1021246	1462394	1913384	2353648	2545135	2711988	2916892	3060565	3153738	3176823	3244398	3247838	3323202	3327442	3342554	3352652	3371054	3379107\nC	39	6	8	10	14	17	20	22	23	25	26	27	28	29	30	31	32	33	34	35	36\nC	39	386223	668984	1050697	1499184	1951584	2406055	2592860	2753893	2758223	3081239	3102418	3245637	3261739	3291977	3323452	3328084	3333114	3352634	3356563	3363843\nC	40	7	8	10	13	17	20	22	23	24	25	26	27	28	30	31	32	33	34	35\nC	40	407449	698589	1087899	1538640	1981906	2450050	2625012	2773923	2789341	2910065	3095776	3161845	3228922	3242959	3265222	3283917	3286411	3291166	3294503\nC	41	6	8	10	14	17	20	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nC	41	423269	721576	1118549	1580630	2035236	2521102	2846964	2847615	2993826	3194698	3258790	3267659	3289680	3302920	3324296	3325532	3329219	3333444	3338203	3346341	3365199\nC	42	6	8	10	13	17	19	20	21	22	23	24	25	26	27	28	29	31	32	33	34	37\nC	42	440125	745865	1149586	1611293	2051603	2246812	2552962	2716841	2851340	2956752	3096619	3180566	3183558	3214565	3223331	3245017	3259276	3267051	3275958	3283346	3292750\nC	43	6	8	10	13	16	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34\nC	43	458221	770329	1182042	1649190	2084707	2273310	2599984	2756910	2757355	2883459	3010349	3020615	3186868	3221347	3240607	3249010	3263521	3265122	3277148	3279632	3281351\nC	44	6	8	10	13	17	20	21	22	24	25	26	27	28	29	30	31	32	33	34\nC	44	472369	790002	1205568	1671953	2097841	2774035	2888886	2975640	3085777	3142239	3159536	3172318	3192441	3203555	3203968	3208378	3210771	3231614	3233875\nC	45	6	8	10	13	17	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34\nC	45	488555	810112	1229657	1695267	2108550	2652132	2652481	2895301	3095486	3128068	3149153	3151234	3175007	3191268	3192904	3195254	3197135	3203686	3204591	3206108\nC	46	6	8	10	13	16	17	18	20	21	23	24	25	27	28	30	31	32	34	35\nC	46	499852	825106	1248043	1714344	1714629	2120665	2285923	2907237	2908299	3112252	3125816	3130581	3158276	3170217	3170555	3171925	3174101	3181354	3184213\nC	47	6	8	10	13	16	19	20	22	24	25	26	27	28	30	31	32	33	34\nC	47	515595	846057	1275084	1741142	2139702	2299297	2931873	3012253	3095423	3127531	3139034	3154258	3162682	3170424	3172106	3178536	3179362	3182632\nC	48	6	8	10	13	17	19	20	22	23	24	25	26	27	29	30	31	32	33	34\nC	48	528917	864362	1297953	1763769	2152872	2420938	2862651	3027276	3107815	3118453	3139802	3140686	3150959	3154156	3163427	3166596	3168689	3170719	3171963\nC	49	6	8	10	13	14	17	20	21	22	23	24	25	26	27	28	29	30	31	32	34\nC	49	519091	845341	1278504	1278761	1756732	2157619	2964062	3035431	3099497	3102461	3122289	3138771	3144216	3159828	3173555	3178341	3179335	3180187	3186105	3187812\nN	0	7\nN	0	26202\nN	1	7\nN	1	55825\nN	2	9\nN	2	53150\nN	3	4\nN	3	55316\nN	4	5\nN	4	56764\nN	5	7\nN	5	57220\nN	6	8\nN	6	57594\nN	7	11\nN	7	60454\nN	8	12\nN	8	64871\nN	9	7\nN	9	66652\nN	10	13\nN	10	65070\nN	11	10\nN	11	67068\nN	12	7\nN	12	63435\nN	13	12\nN	13	68333\nN	14	12\nN	14	69187\nN	15	9\nN	15	71664\nN	16	9\nN	16	68158\nN	17	9\nN	17	66960\nN	18	9\nN	18	70741\nN	19	9\nN	19	67805\nN	20	10\nN	20	62303\nN	21	9\nN	21	62380\nN	22	10\nN	22	59472\nN	23	11\nN	23	56258\nN	24	10\nN	24	55246\nN	25	10\nN	25	55612\nN	26	10\nN	26	54313\nN	27	11\nN	27	53581\nN	28	6\nN	28	52010\nN	29	7\nN	29	53122\nN	30	6\nN	30	52134\nN	31	7\nN	31	53366\nN	32	7\nN	32	54335\nN	33	7\nN	33	55366\nN	34	7\nN	34	57540\nN	35	6\nN	35	61751\nN	36	6\nN	36	60395\nN	37	7\nN	37	63467\nN	38	6\nN	38	61781\nN	39	6\nN	39	58301\nN	40	7\nN	40	58633\nN	41	6\nN	41	59217\nN	42	6\nN	42	56003\nN	43	6\nN	43	54319\nN	44	6\nN	44	55317\nN	45	6\nN	45	57122\nN	46	6\nN	46	56004\nN	47	6\nN	47	54107\nN	48	6\nN	48	52044\nN	49	6\nN	49	54280"
#define QUAL_DIST_TWO50 ".	0	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n.	0	760694	783617	1485449	1600097	1662316	1971976	2034444	2445582	2508624	2539770	3109145	3141712	3174655	3241687	3807595	3841661	9006619	9290988	11840973	14379434	17584568	18283898	18641549	18712479	19209942	19996643	20793620	22795440	23471373	34368792	34916488	35931130	37064566	37710799	37732732	37751977	37879391\n.	1	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n.	1	1292	776830	782998	816730	1567549	1689801	1768116	2077401	2161404	2581077	2668284	2717394	3289443	3340626	3391188	3481160	4060111	4067663	4116020	9108553	9403393	11915032	14465249	17616916	18383192	18771238	18864296	19437489	20313254	21113435	23001331	23687412	34432642	34986852	36006853	37076644	37740087	37759243	37775879	37879391\n.	2	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n.	2	2459	9214	19932	43265	769082	1658746	1739279	1792077	3775887	4298419	4355766	4380541	5032887	5089129	5108004	5194859	5841829	5855468	5942830	9084850	9472163	14554699	16858657	17981170	17989776	18075828	18812171	19388388	20088123	20094653	20661042	31151610	32828754	35252075	36459485	37159074	37759070	37776021	37790493	37879391\n.	3	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n.	3	3394	12446	26750	79406	491464	1032093	1123557	2229932	2501500	2934960	3400439	3500108	4025063	4086603	4146101	4168810	4223917	4851095	4904971	9114388	9489873	13333512	17116924	18555750	18603661	18614905	18825745	19516414	19525790	20498541	20830832	21863205	34042164	34964472	36074775	37137520	37777145	37791829	37804183	37879391\n.	4	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n.	4	4468	16183	1450557	1477005	1711008	1813446	2793940	2945255	3391763	3472547	4066268	4183532	4782662	4855548	4884865	5031633	5140227	5884345	5991201	10959912	11338942	14817173	17091556	19316632	19379586	19393293	19495050	20201153	20937812	21430941	22714747	23350350	23698264	33392982	34373985	36494857	37793512	37806202	37817200	37879391\n.	5	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n.	5	5400	577537	598449	629312	954752	1880619	2370053	2847351	3063707	3690066	3789866	3883547	4179487	4885673	5018019	5098091	5226826	5455405	6082345	9643943	9820530	12351375	16261797	19891776	19908275	20245491	20259823	20602827	20825494	20955194	30528319	31405017	33118525	35044578	36579771	37216712	37811300	37821802	37830654	37879391\n.	6	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n.	6	6634	644687	668454	997976	1050349	1324922	2079678	2125025	2621331	3491131	3540182	3707485	3808402	4662861	4752015	4838788	4921716	5685627	5711260	9260562	9283207	13161683	17185345	19714132	20181020	20197022	20975346	21173988	22298620	23052119	23587777	23785375	24833605	34377299	36428939	37145612	37822520	37831413	37838827	37879391\n.	7	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n.	7	8282	657898	685356	725665	1668559	1900815	2429866	2569352	2878877	4184198	4460992	4654963	4843241	5162662	5988324	6291365	6589991	6750781	7887700	9872178	9895444	13470838	17422946	21386614	21404097	21799070	29060843	29865911	30127990	30770161	31300703	31713866	32374172	33810794	35865436	36428120	37830469	37838459	37845150	37879391\n.	8	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n.	8	9215	705591	735406	935871	1239495	2905927	4480270	6178804	7134532	7247695	8053815	8273007	8482926	9348677	9386726	9581544	9845380	9951083	10827346	13147403	13246986	17161642	19574192	21221290	21383611	21399807	22253728	22267171	23095289	23762475	23844005	31695045	32938128	34436429	35666399	36168571	37840255	37846616	37852005	37879391\n.	9	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n.	9	10646	935985	969245	1293392	2393441	2689257	2861557	3033821	3316240	4616969	5523175	6369864	6606944	6926696	7238398	8046680	8253333	8454593	8652985	14954979	15228123	17186628	17815779	20530833	22512685	23307148	23321562	23519948	25171622	32206556	33961155	33968999	34645212	34974169	35818588	36837380	37845321	37850954	37855613	37879391\n.	10	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n.	10	11832	866968	1115002	1472951	1843195	2172483	2772892	3084861	3813205	4046402	5197536	5355060	5715765	5957718	6289142	7225133	7534865	7566053	7858110	12982028	13094788	14264380	17858740	22866719	22883833	22899320	22913270	23713454	29385400	30802471	30810921	30818146	32510448	34869449	35587553	37418612	37853106	37857610	37861349	37879391\n.	11	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n.	11	742792	943540	981979	1278091	2854366	3233956	3450663	3814121	3879188	5167805	5626681	6492629	6659827	6703437	7622738	7994457	8351671	8587631	8720922	12408830	13328697	14869671	17053269	22441719	22741220	22843933	23809538	23909482	24005898	24982024	25404850	26650302	31942448	33580467	35140012	37133289	37859322	37862878	37865761	37879391\n.	12	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n.	12	14484	879719	921280	1635969	1725336	3148468	3378181	4228581	6014550	6430658	6487989	7493540	8063422	8355625	8395477	9422990	9456941	9945731	10303152	14574906	14900039	16969286	19248205	23959578	23975214	24821985	25268259	25278471	25722315	30622707	30865488	31719294	32829001	34560728	35750706	37420873	37863658	37866481	37868724	37879391\n.	13	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n.	13	15462	1278234	2242796	2753863	3588054	4492708	4745475	7106488	7339022	8548580	8911936	10062661	10377409	10689361	10860120	12018966	12287206	12546310	12795283	17763978	18786353	20685957	20916011	23642845	25410291	25422982	25434020	25902964	30086740	31488418	32125457	32458137	33476765	35419946	36513557	37077841	37866975	37869241	37871085	37879391\n.	14	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n.	14	17349	436753	484020	554980	831325	1746574	1813586	1883942	2120927	2847891	3538851	4377776	4503102	4630108	4670343	5488204	5696920	5727261	6036385	9457171	9580966	10499213	13230506	18732393	20673002	21233459	21243120	21749653	22564724	22696058	23159466	25203390	26192576	33422228	34979824	35901972	37869408	37871344	37872857	37879391\n.	15	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n.	15	20198	58662	110260	186259	1337749	1428025	1632237	1702945	2347102	2614637	3545386	3675249	3722664	3850960	4688965	4806044	4838499	4957865	5815976	8874858	8896294	11091783	14463079	20740979	21211147	21469377	22043649	22279647	22788493	24122166	25468175	27169202	27815901	28603327	29498146	31057912	31456386	37872450	37873736	37879391\n.	16	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n.	16	20921	61613	115733	196116	1444457	3237516	3540771	4448989	4520289	5878281	6092613	6894807	7114720	7157504	7196220	8069829	8198311	8319670	8453869	11954058	11974040	13480528	16179809	20346593	20611378	20759549	21387785	21394551	21697388	22563267	23000786	24106676	26601533	33683007	34563232	36925330	37400736	37874275	37875228	37879391\n.	17	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n.	17	23373	66730	124264	208872	326196	796855	869488	1098446	2186516	2314928	3347456	3398967	3445597	3488101	3623629	4551825	4792464	4820914	4937458	7578778	7597992	12531160	14426747	18971007	20186742	20837048	20981223	21554375	22616027	23398785	23915493	24909160	27665932	29079488	29705335	31848631	32398124	32399081	37876187	37879391\n.	18	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n.	18	25503	71768	133293	223900	346283	542621	617241	1636815	4369164	4826866	5781045	6010909	6056161	6195679	6233210	7339130	7369169	7396132	7419752	9184809	9317584	14899037	18811255	21749609	21901049	21908905	22195134	22868973	23021565	23533855	24974001	26071093	27855452	29770135	30927913	32526247	32770004	37875919	37876589	37879391\n.	19	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n.	19	28173	77373	142216	1255148	2796597	2965691	3084910	4050522	6104006	6231590	7189690	7239226	7477469	7623260	8636265	8780922	8810060	8953965	9975307	11388314	12194974	14940950	17657536	20483101	22559837	23241103	24657147	24830400	25276806	25637725	27122658	27773400	29552511	30610295	31556263	33184214	33184997	37876772	37877295	37879391\n.	20	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n.	20	30388	82844	151773	252231	1216573	1292872	1663081	1739201	2598671	3363201	3417463	4704743	4748815	5000319	5036223	5191744	6263532	6288170	6440683	10544729	10560319	12541568	15323790	15599867	18722803	21424223	22007810	22958851	23665877	23843374	24871245	26161042	27186297	30400720	30585843	32634255	37876956	37877444	37877793	37879391\n.	21	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n.	21	33103	89177	162408	268153	406199	679938	1195810	1272160	1883448	2693917	2747955	3039512	3980401	4019148	4186479	4217013	4384074	5547697	5567390	7072421	7417021	10214614	11910326	18821275	20797147	20999299	21614944	21801227	22372684	22750981	23622507	24864952	25565210	27995536	31115241	33382207	37877380	37877745	37878012	37879391\n.	22	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n.	22	36246	95449	2945186	3058759	3282005	4159912	8294214	8618488	9298239	10108205	10160576	10482243	11426224	11463416	11644611	11830583	11855329	12882712	13066049	13910352	13923038	15311389	19172087	21564829	22755417	22759889	22998636	24376084	24939885	25332828	25641683	26810949	26893275	28963189	33299060	36575932	37877699	37878028	37878249	37879391\n.	23	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n.	23	37661	98551	179063	296680	1360674	1444191	3078721	3894758	3967568	5374965	7518057	7739862	7963491	9055046	9475886	9915856	10153419	10612091	11725180	14487619	14721977	19798160	23313149	25501152	27625667	29900715	30258683	30260966	31656844	31873773	35074096	35268078	36093900	36806468	37242538	37877808	37878107	37878316	37878490	37879391\n.	24	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n.	24	40779	693515	780722	2836969	4877190	7339162	7804461	8642403	9112923	10452242	10502758	10759787	11890754	12143052	12394595	12871787	14236437	14486256	14733232	17556476	17566684	20898882	22842740	25644484	27978783	29309390	30028968	30935785	31765774	32920794	34079901	34272377	36854206	37371379	37472627	37878035	37878259	37878436	37878588	37879391\n.	25	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n.	25	43559	693310	784660	1680234	3006820	3092328	3581623	3659522	3731409	5106619	5379512	6513810	6779947	7047818	7076772	8530063	9283144	9299739	9559278	10224764	10968106	16935819	19603839	22976838	23666086	26649415	26671433	27877159	28717791	29177926	29820285	31325596	32044876	33406529	34693256	37597003	37878468	37878609	37878730	37879391\n.	26	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n.	26	47348	120667	217062	2210200	3272462	3358821	3440745	3924825	4832198	6264447	6313216	6590717	8027364	8309487	9116574	9139384	9423257	10950375	11228669	12703638	12969319	13622385	18554322	26089123	26517410	26947946	28604889	29249841	29429606	29430358	31578726	33688084	34916506	35962062	36150647	37435647	37878655	37878767	37878852	37879391\n.	27	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n.	27	49949	126482	227424	1881958	3371603	5766206	8420760	9689087	13045638	13161481	13693927	13735261	15277532	15307723	15592927	17404985	18062804	18626761	18637765	20532396	20816977	23906194	27806775	29576619	30726161	30940890	32103740	33265930	34239014	34440977	34969306	36832476	37299024	37825217	37878524	37878661	37878776	37878851	37878928	37879391\n.	28	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n.	28	53216	1083016	3368123	3911382	5153634	6648411	7614289	11802182	11870829	14376915	14700076	14739617	16379812	16408204	16715755	18076501	18663475	18964424	19665579	22752662	23385926	24690423	27989897	28850290	30086292	30766599	31319971	32462200	32823454	33829624	34108792	34464621	36520782	36866438	37311817	37878752	37878831	37878915	37878952	37879391\n.	29	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n.	29	55723	1178959	1291966	3696129	3872805	4976860	9500370	10834991	10901998	11310758	12617105	12956434	13605515	13631667	14275641	15783693	17723767	19107002	19779472	21309266	21773652	25271729	28942611	29017062	31132391	31174092	31921586	32706112	34497199	35819066	35906817	36784394	36846202	36913686	37019928	37878889	37878949	37878989	37879023	37879391\n.	30	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n.	30	59330	1217306	1336582	4679250	5323323	5973749	8138408	11994186	12061204	13742852	14093352	14442601	14787478	15442440	17185872	17201846	17826243	18410695	20434195	21821354	22854665	24765158	30267161	31074336	31674562	32459844	34000765	34892407	35328234	36553511	36882953	37410894	37588498	37654188	37878876	37878943	37878984	37879015	37879048	37879391\n.	31	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n.	31	61718	1239446	3790449	6919135	7785078	9935599	11495430	11569300	13586077	15602780	15958984	16314756	16671794	18520573	18539014	19219190	19562392	21435203	22061610	23447241	24581618	28722894	31299096	33319375	33590212	34766696	35884432	36527488	36536659	37130475	37217875	37587468	37742730	37818033	37878968	37879015	37879050	37879080	37879103	37879391\n.	32	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n.	32	69583	575547	706248	5964727	6946577	7649122	10041739	10114676	10824664	10926593	12688917	13060127	13429938	13451105	13812576	14505804	16058678	16731879	17045810	20454486	21041301	21849660	24399001	24679281	29511931	30088992	31015115	32019229	32327219	33369238	33787072	34828173	35543430	37472199	37729255	37878819	37878868	37878923	37878957	37879391\n.	33	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n.	33	34651	116269	264301	4541740	8617957	9444645	10511811	11195922	11259651	12003170	12037563	13538980	14250530	14266562	14634000	15001591	16639822	17356751	18052624	19914584	20235731	22690768	23886537	28636601	28637110	29133323	29539063	30830725	31147783	32247732	32931314	34051107	34324544	35993976	36880327	37879007	37879039	37879056	37879079	37879391\n.	34	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n.	34	76679	990476	4020481	8867612	9548013	10203859	11942336	11992813	12040238	12825726	12863540	14842176	15244156	15647295	16048442	16070613	18551996	18930065	19295945	22012201	22025044	25400144	26812874	29204556	31095492	31982485	32065171	33615277	33911436	33971150	34903752	36089742	36857622	37415821	37600669	37824257	37831014	37836972	37842054	37879391\n.	35	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n.	35	1191483	13767990	13791498	16072157	16956929	16963066	17983461	17987191	18644540	18648481	20953931	20954931	21332568	21333252	21716722	22107486	22500329	24240276	25011655	25903412	27261274	27538732	28540858	30854225	30973584	31014005	31891126	32283057	33103852	34589278	35919514	36483983	37075058	37339758	37671495	37870551	37870847	37871123	37871374	37879391\n.	36	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n.	36	99398	2785762	4822884	7790173	10057234	11799274	12963483	13700436	13750451	13839440	16375570	16410531	16837676	17267764	17700779	18131535	20823940	20841578	21593069	23545334	24204108	25652685	27933635	30688666	30973830	31503131	33180482	34076390	34554858	34653982	35567240	36521699	37343241	37562663	37759338	37855395	37858586	37861310	37863692	37879391\n.	37	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n.	37	47364	151883	569740	6335020	9799804	11743012	12966462	16742555	16800097	16881254	19536376	19556874	19983828	19995299	20419764	20846215	20850525	23246918	24056675	26074712	26444171	26897965	27246370	27573431	30805979	31304193	32301369	33376450	34175399	34984318	35827198	36052848	36850971	37051480	37248725	37661142	37878183	37878219	37878247	37879391\n.	38	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n.	38	91549	225276	411056	3431656	9083406	9815163	11098310	14954757	15010492	15090872	17894668	17916097	18358226	18800558	21313673	21749346	22967470	22970645	23343432	27798394	28332239	29983444	31049279	34322235	34485365	35111685	35838552	35935567	36730460	36855373	37316504	37343778	37492040	37610975	37879031	37879052	37879069	37879078	37879090	37879391\n.	39	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n.	39	86296	222146	2821272	4630838	9086493	9922888	11163629	13928847	13982543	17656047	17681988	20120084	20570542	21012340	21443529	22248571	22252324	24743242	25425604	26542574	26799930	28873274	29211576	31881044	32062234	32064952	33269082	33878261	34815267	35656202	35679148	35977947	36920558	37051585	37380178	37380198	37879053	37879065	37879075	37879391\n.	40	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n.	40	88291	1258604	3933187	4962615	6785184	8185864	10407406	13217491	14171888	19301017	19777877	22357981	23222145	23231418	24015478	24379198	25022941	25307972	27781831	30143811	30406509	30752287	30808395	31007157	33437405	33438973	34471777	34725582	35456622	35575798	36050624	36345162	36953700	37027285	37027305	37027317	37879070	37879080	37879092	37879391\n.	41	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n.	41	90241	1317638	1532682	8735783	10377842	10467120	12758539	15919916	19445718	19511739	19996577	22646113	23095380	23524012	24303710	24307600	24608107	25290082	28244688	30410910	30636634	31400157	31431020	31573181	33707901	33807209	33853536	35494831	36080351	36199942	36777695	37013638	37653479	37732368	37879025	37879041	37879053	37879070	37879080	37879391\n.	42	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n.	42	91488	4039946	10454459	11618183	13186253	14585629	17494231	18505140	18551366	19084636	19559040	22309207	22737124	22744176	23511458	24464618	24466918	24968694	28115280	29126573	29435708	31629807	31813301	33892942	33909548	33944210	33996497	34896330	35118773	37306494	37369136	37483671	37623681	37691662	37750249	37879081	37879093	37879101	37879107	37879391\n.	43	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n.	43	90778	1395736	5142053	12262117	13431957	14021435	16475971	16531706	17562834	18105567	18589740	21453972	21887820	22659684	22663692	23322429	23604468	23891785	26959197	27918486	28338093	30256872	32075443	34145031	34147579	34164874	34168296	34863857	36411517	36630398	36656532	36781500	37751303	37815986	37879070	37879079	37879086	37879095	37879105	37879391\n.	44	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n.	44	89435	1390671	3289188	4594937	11743203	11828036	14317633	15663428	16708910	16762009	17269660	20216375	20672880	21104764	22209998	22212206	22520629	23022536	26052096	27383489	27605213	28563185	28650865	28742658	32457109	35201007	36556048	36561900	36568576	36943245	37117442	37195870	37235014	37280161	37774556	37879030	37879043	37879052	37879066	37879391\n.	45	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n.	45	90437	2491863	13331821	13598401	15551054	16718026	18264529	19350829	19889107	19937788	20872544	23893983	24644431	25270578	26079683	26427577	26906331	27142829	29736931	30316619	30562017	31039204	32696341	32697308	34786638	34955964	36097881	36924137	37271000	37736684	37827327	37837058	37879036	37879046	37879057	37879072	37879077	37879085	37879089	37879391\n.	46	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n.	46	90501	5195065	5457756	10127559	11712184	13346616	17439337	17487472	20139455	20691367	21177567	24329994	24750672	25477857	26076911	26078376	26444363	29681359	30160859	30609789	30821796	32317791	32779687	32880416	35406117	35738792	37119442	37500711	37503312	37554193	37578746	37672443	37788307	37820551	37879057	37879076	37879087	37879103	37879114	37879391\n.	47	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n.	47	89701	2705759	9781012	11736033	13118686	16355651	16414694	17541603	18086784	18600714	19054758	22243152	22952896	23261843	23533541	24140572	24756553	25232265	27999105	28402216	28472679	28764714	28765083	33449889	35519207	35947804	36243777	37762506	37767239	37776347	37790463	37790482	37790494	37826680	37879040	37879050	37879060	37879080	37879090	37879391\n.	48	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\n.	48	104423	1452666	10105306	12073919	13515664	17671555	20582393	21722743	21754867	22311025	23252094	27289160	27293662	27296577	27871631	28122939	28649225	32106207	32106523	32879520	32892239	33261940	33270975	35661611	35673126	36038074	36808041	37767358	37772661	37785392	37808082	37826656	37879009	37879020	37879036	37879043	37879057	37879064	37879078	37879391\n.	49	2	4	5	6	7	9	10	11	12	13	15	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32\n.	49	1742592	3058749	4261636	5964962	7163769	8278655	8805958	8806231	13389589	13801316	13805038	14385671	17072629	17484622	18065883	19508378	22582917	22715695	22875443	22963145	23003738	23119465	23122939	23125151	23142681	23160950	23188946\nA	0	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nA	0	283165	289550	486761	500948	519090	603671	622995	758876	779777	789169	968115	980074	992537	1018235	1202025	1215566	2534555	2629607	3213558	4093489	5133473	5391357	5518420	5547259	5747706	6050623	6344754	6686192	6901877	10501940	10679021	11040289	11362405	11605953	11606060	11606163	11607081\nA	1	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nA	1	306	286776	288890	299269	512480	531111	557190	646968	677825	820624	855192	873544	1061188	1082542	1103829	1141767	1336500	1338515	1358549	2623976	2725945	3301385	4176604	5211116	5508456	5653774	5693813	5939385	6296975	6597492	6888214	7110302	10756063	10940636	11315834	11604395	11867106	11867223	11867290	11868221\nA	2	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nA	2	540	2658	6396	14214	224277	558943	585821	605903	1309853	1491385	1515206	1527688	1741041	1765655	1773705	1809013	2024914	2028908	2063126	2571022	2707393	4349609	4901551	5259176	5259684	5293796	5544042	5741843	6010562	6010689	6223156	9606942	10263977	10689591	11126156	11302258	11521228	11521304	11521367	11522231\nA	3	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nA	3	685	3389	8250	24413	37654	180796	212656	561366	591387	730380	880742	921852	1083588	1109671	1134050	1142805	1163644	1362726	1382616	2284500	2409009	3720195	4815457	5347109	5362921	5363359	5450967	5697755	5697941	6056576	6180449	6512216	9931134	10250567	10648799	10926885	11160740	11160825	11160903	11161815\nA	4	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nA	4	885	4423	544094	553432	576598	609292	926739	978611	1108793	1151251	1352812	1400433	1593103	1624114	1636458	1692268	1735293	1983679	2024498	3444920	3572028	4162888	4870638	5669633	5691086	5691586	5730166	6004458	6281038	6439358	6930402	7113143	7236257	10205782	10516993	10833275	11331116	11331175	11331240	11331915\nA	5	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nA	5	1137	21743	28640	39296	133040	363391	415821	552764	628018	856238	898271	940856	1054468	1292546	1346401	1377971	1428863	1520754	1722870	2356297	2424879	3290528	4520357	5752521	5753168	5863181	5863523	5980671	6046066	6072941	9030030	9292914	9955562	10266788	10824662	10971154	11188380	11188446	11188490	11189140\nA	6	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nA	6	1304	31572	39337	136796	157104	238525	462880	484372	633406	910237	936080	1003679	1046283	1335031	1371295	1405107	1435717	1688370	1692864	2515312	2517664	3547186	4808702	5735270	5901021	5901362	6191154	6250745	6662247	6917146	7094424	7130028	7533293	10057966	10770017	10944205	11198600	11198652	11198706	11199193\nA	7	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nA	7	1599	28307	37297	51382	334514	406145	474110	525592	634512	1063875	1173489	1254927	1330545	1459478	1737829	1856353	1971100	2029196	2409180	2697001	2699077	3470901	4847929	6200646	6201120	6343812	8318288	8623525	8705786	8938097	9109606	9227961	9440167	9618222	10291675	10422397	10958680	10958716	10958745	10959193\nA	8	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nA	8	1793	35348	45360	106487	204041	740708	1280604	1863650	2137963	2196576	2481097	2570961	2656620	2944316	2957178	3031246	3131411	3167173	3457044	3740750	3772581	4825222	5650543	6236443	6292043	6292363	6591595	6591803	6903014	7138592	7149315	9265740	9715940	9931467	10332249	10438711	11010926	11010974	11011004	11011482\nA	9	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nA	9	2114	93358	104337	205969	590480	692675	758001	826069	937964	1264571	1602613	1913768	2011502	2142869	2268991	2536911	2614957	2689105	2760684	4453016	4552114	4902395	5071535	5957434	6629068	6908035	6908236	6958827	7324441	9145877	9762320	9762372	9976315	10054524	10299338	10583043	10910428	10910461	10910487	10910911\nA	10	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nA	10	2457	44898	116731	223874	340058	448012	539259	654824	887400	991485	1399562	1464614	1605919	1698544	1822987	2131702	2241228	2245735	2344347	3510826	3544466	3732090	4960309	6625680	6626002	6626252	6626426	6907212	8236703	8717009	8717054	8717097	9314843	9956452	10097594	10633256	10753752	10753774	10753802	10754225\nA	11	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nA	11	11082	55441	68243	159232	682148	810542	890670	1027180	1059724	1318295	1498435	1808272	1874166	1888406	2197677	2340168	2474836	2558907	2603006	3493981	3798863	4045363	4740622	6448481	6552336	6582894	6917142	6947816	6977251	7327154	7483143	7702344	8882201	9512563	9912887	10525235	10747069	10747098	10747122	10747492\nA	12	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nA	12	3098	62501	76587	287311	323064	795626	878255	1045219	1634200	1799409	1825866	2178887	2388743	2494593	2504330	2840288	2845249	3014689	3134200	4065091	4167868	4808642	5379150	6907552	6907788	7194727	7349776	7349874	7511269	8598244	8668635	8923878	9300172	9717834	10035248	10572735	10740876	10740889	10740915	10741266\nA	13	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nA	13	3161	160188	493828	647742	856482	1046351	1136424	1947904	2038010	2331966	2464813	2863757	2974928	3082313	3137357	3513067	3596986	3675770	3749697	4978073	5303619	5826902	5894239	6738619	7349553	7349696	7349799	7514884	8360222	8885439	9097633	9210146	9360539	10057298	10289662	10405035	10649641	10649666	10649688	10650045\nA	14	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nA	14	3614	15790	31959	57922	120270	416582	447787	481297	573700	665699	867860	1166154	1213132	1260822	1269107	1527998	1611492	1614164	1747306	2396717	2445445	2718674	3541583	5369383	6050695	6249734	6249831	6411633	6754184	6777977	6947334	7705446	7891402	9656864	10123972	10406845	11038740	11038766	11038781	11039099\nA	15	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nA	15	4107	15770	33459	61225	153955	188712	264603	298670	484150	545827	878120	927595	941992	988772	1256009	1294627	1298172	1340107	1615392	2114166	2114834	2787831	3895018	5914250	6082562	6194785	6408541	6515720	6734173	7206742	7690595	8271990	8495949	8704163	8931181	9445523	9471022	10992938	10992961	10993346\nA	16	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nA	16	4356	17067	35626	65180	395047	1000085	1034708	1318708	1352452	1608591	1688892	1962681	2046836	2056268	2062807	2341222	2387505	2429921	2482198	3339397	3339925	3639924	4476010	5864863	5983815	6042361	6272395	6272455	6395935	6678249	6823190	7079383	7961850	9644710	9868058	10724075	10854688	11027305	11027321	11027629\nA	17	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nA	17	5081	18796	39184	71161	120497	183681	217735	303811	542617	598823	960681	976618	988424	996867	1043975	1339776	1436651	1438330	1476772	2127583	2128015	3541784	3943561	5457657	5888520	6121668	6185574	6441119	6801226	7086143	7280834	7571916	8479536	8908320	9012977	9699402	9860495	9860509	11050380	11050689\nA	18	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nA	18	5752	21106	43402	78787	130864	197300	231953	360198	1224090	1279866	1612320	1693503	1703818	1751035	1755942	2116528	2118661	2120004	2120945	2495886	2547478	4138850	5352206	6201026	6266797	6266845	6396032	6641251	6708485	6917605	7443967	7760546	8384131	8917953	9219480	9720285	9789201	10885137	10885155	10885434\nA	19	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nA	19	6416	23034	47090	125584	371143	431591	478481	756107	1440333	1491513	1828018	1840880	1923523	1973190	2295827	2346245	2347991	2400924	2725640	2894514	3189206	3976648	4702811	5637971	6372272	6619300	7117488	7192276	7307080	7455088	7985977	8200215	8753928	9059777	9297961	9817128	9817148	10778669	10778687	10778965\nA	20	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nA	20	6963	24618	50632	91254	316283	350613	479127	513938	597452	824583	840835	1142262	1150473	1237299	1240898	1297146	1650337	1651323	1710161	2680397	2680638	3242700	4225473	4252969	5212534	6116172	6308814	6657286	6892120	6970646	7332884	7767962	8085624	9116364	9136936	9763827	10851110	10851116	10851129	10851386\nA	21	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nA	21	7512	26747	54542	97611	157790	246137	284772	318816	462852	697591	712596	814836	1131162	1136138	1193225	1195263	1255590	1642626	1643141	1850785	1997460	2766243	3374861	5324600	5991508	6073055	6263892	6343993	6587220	6742762	6994933	7377302	7592879	8394092	9341369	10018727	10928233	10928243	10928250	10928523\nA	22	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nA	22	8532	29485	918481	966201	1047954	1139956	2499467	2615087	2687670	2925147	2938267	3051892	3367488	3371580	3434623	3502633	3503670	3834784	3906499	4012250	4012390	4330189	5392671	6155033	6597312	6597349	6684396	7146154	7348954	7478234	7558998	7956695	7962031	8541844	9389939	10372034	10726322	10726332	10726343	10726582\nA	23	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nA	23	8938	30597	62618	111416	257680	293965	470166	704581	732637	1231730	1886263	1962142	2039774	2391447	2551269	2722061	2809759	2983734	3339459	3890136	3972235	5618190	6588118	7358532	7941270	8670817	8769815	8769843	9156753	9199321	9783346	9807322	10031835	10204919	10297359	10442170	10442181	10442190	10442200	10442448\nA	24	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nA	24	10018	43261	78980	219744	987348	1730481	1884031	2116583	2276566	2752125	2762543	2848374	3215662	3300897	3387797	3564604	4014612	4103558	4193886	4806994	4807109	5706880	6293740	7007400	7783304	8195579	8426815	8677782	8880407	9216440	9520841	9565682	10027967	10152638	10164379	10262486	10262492	10262499	10262509	10262761\nA	25	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nA	25	10791	44764	82495	190950	523443	559384	721801	751631	776753	1187068	1278780	1672285	1763461	1856459	1858048	2342657	2629623	2629982	2723993	2831629	3095291	4685984	5508097	6559062	6778760	7665581	7667114	8027039	8291575	8400413	8548312	8993157	9137662	9512603	9854415	10388083	10463384	10463392	10463397	10463638\nA	26	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nA	26	12435	40474	81520	764856	923538	959253	991992	1150007	1227507	1648858	1657031	1749334	2265034	2362803	2662693	2663413	2763802	3266699	3365088	3641758	3729490	3838633	5082516	7424712	7543869	7664560	8163517	8323254	8367533	8367543	9002725	9364738	9691100	9959059	9982595	10278766	10418065	10418072	10418079	10418309\nA	27	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nA	27	12883	41854	84893	198140	432130	1220972	2085829	2420354	3668200	3695323	3873182	3877857	4390239	4392002	4490388	5094509	5296298	5503905	5504067	5900225	6000293	6697093	7695957	8270725	8629401	8687326	9005664	9307712	9556984	9593535	9721773	10021152	10105135	10213510	10220538	10220553	10220561	10220573	10220591	10220811\nA	28	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nA	28	14296	122721	990470	1173474	1302576	1757971	1989534	3415361	3434984	4132386	4244672	4248642	4792334	4793794	4903269	5324715	5541003	5647168	5858813	6544408	6739038	6881043	7926675	8203870	8595542	8781246	8936360	9255454	9350044	9602449	9659454	9739834	10100785	10171119	10254479	10362637	10362644	10362658	10362661	10362892\nA	29	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nA	29	14896	134033	183758	1009172	1082704	1331366	2722187	3054821	3072214	3190557	3644372	3748595	3960131	3961336	4174376	4657205	5269337	5641766	5798982	5976165	6065670	6940024	7909326	7921227	8466894	8471418	8699982	8927178	9481409	9866911	9878083	10085470	10091040	10099395	10112759	10323171	10323181	10323188	10323195	10323399\nA	30	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nA	30	16126	147281	200749	1102777	1306302	1509925	2090116	3367161	3383538	3955119	4064356	4173715	4282893	4496859	5066239	5066597	5263881	5439751	6065291	6274605	6586243	6987290	8491209	8725235	8860875	9079711	9526145	9742017	9854114	10081966	10155911	10253233	10276657	10285289	10336279	10336291	10336302	10336308	10336318	10336533\nA	31	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nA	31	16856	162919	1143065	2128926	2268693	2672786	3161223	3181764	3879566	4580036	4693575	4809446	4927904	5534842	5535326	5768705	5882124	6473184	6672435	6941161	7272299	8216599	8860426	9405142	9457412	9705615	10031899	10197457	10198298	10353765	10364596	10429603	10454196	10463110	10473372	10473379	10473387	10473394	10473403	10473586\nA	32	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nA	32	19307	160775	220001	1554496	1777754	1910165	2488653	2507843	2737859	2752759	3363900	3483555	3604196	3604903	3724176	3955037	4462243	4677360	4770884	5694504	5863577	5969211	6713208	6767710	8256029	8370824	8626780	8901500	8953568	9212587	9296404	9595307	9777378	10221052	10270699	10300864	10300874	10300883	10300889	10301108\nA	33	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nA	33	10451	46304	119284	1502177	2713386	2814567	3145187	3358724	3368446	3604186	3606277	4132499	4379663	4380028	4507130	4634582	5166258	5414208	5643244	5906203	6004863	6739949	6923070	8156333	8156349	8275427	8372438	8724166	8779939	8990278	9140540	9441178	9487681	9915654	10147043	10414375	10414384	10414386	10414393	10414551\nA	34	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nA	34	14924	82010	949881	2142097	2358434	2450070	3009575	3025297	3040156	3310591	3321757	4027543	4170221	4311340	4450092	4455578	5273966	5395663	5509938	6135178	6137215	7009286	7342727	8010237	8536802	8785751	8798121	9169690	9243870	9251750	9505616	9823351	10023554	10154458	10181634	10222486	10222565	10222628	10222685	10224045\nA	35	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nA	35	441	9406	16465	251979	516284	517172	844692	845222	1063117	1063636	1880865	1880977	2015907	2015976	2153845	2292767	2430327	2991719	3254989	3478504	3887980	3962135	4216460	4867172	4889152	4895010	5135527	5213325	5435168	5849691	6122650	6255792	6414969	6462962	6515111	6550269	6550318	6550370	6550405	6553223\nA	36	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nA	36	19402	767650	1345587	1999380	2450502	2864965	3245660	3488532	3505070	3533218	4426393	4435876	4581524	4727335	4872246	5013157	5881092	5883416	6104504	6470715	6646341	7050571	7668612	8424000	8475421	8565092	8961108	9193124	9297598	9310327	9550903	9777006	10000898	10041003	10070132	10086638	10086675	10086720	10086746	10087909\nA	37	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nA	37	14899	61722	169406	1572985	2908025	3289951	3676636	4777033	4783163	4788822	5724911	5725566	5871669	5871888	6018578	6165248	6165352	6943447	7208139	7452003	7561984	7683104	7783867	7874287	8740145	8848222	9052842	9329002	9540593	9740720	9956135	10000912	10186053	10213090	10243544	10337559	10387857	10387883	10387902	10388884\nA	38	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nA	38	28086	85955	171236	794150	2489011	2710455	3118887	4492329	4498655	4504577	5484309	5485009	5629338	5774687	6579245	6718017	7089088	7089124	7193516	8226659	8350807	8658217	8915167	9508442	9533697	9664264	9853147	9866495	10052300	10075714	10163568	10168095	10190713	10206397	10262090	10262099	10262107	10262112	10262119	10262319\nA	39	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nA	39	27226	86577	1040235	1371826	2742865	2995693	3407217	3995518	4001075	4991581	4992626	5851173	5993468	6131900	6263690	6504278	6504331	7294355	7474557	7598862	7656904	8073183	8135506	8842662	8866977	8867449	9164356	9287535	9501626	9693161	9695743	9751349	9977577	9993503	10059489	10059501	10186740	10186745	10186751	10186976\nA	40	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nA	40	28443	139613	1116488	1433310	1862301	2181215	2894377	3586955	3880352	5358191	5503508	6409968	6673196	6673337	6899835	6997566	7159925	7226084	7995746	8296279	8340400	8389929	8396955	8424581	9088992	9089288	9347751	9389752	9581427	9598591	9720148	9776778	9932688	9943450	9943458	9943463	10154370	10154377	10154386	10154596\nA	41	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nA	41	28818	151677	250273	2477711	2879994	2896588	3623673	4197243	5405189	5408793	5554707	6489049	6623494	6749147	6970190	6970246	7042816	7219035	8085176	8361000	8396911	8506773	8510574	8531760	9103813	9116600	9122391	9525230	9659218	9680362	9820977	9866331	10009411	10019980	10042558	10042567	10042572	10042579	10042584	10042804\nA	42	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nA	42	29512	1076578	3079094	3430747	3836697	4138933	4944022	5240662	5244254	5389432	5526032	6489001	6606764	6606873	6812799	7038969	7039008	7143348	8026717	8127128	8200459	8485617	8510079	9076505	9078861	9083243	9089459	9308286	9350154	9875334	9882751	9901128	9923628	9933023	9941083	9966122	9966128	9966135	9966139	9966338\nA	43	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nA	43	29197	161820	1535803	3580693	3912990	3974223	4749799	4755133	5047224	5190466	5324865	6317199	6432333	6628542	6628610	6778893	6837743	6892494	7770580	7862765	7923306	8293794	8542180	9106763	9107335	9109688	9110317	9275520	9633436	9668238	9672495	9692320	9912801	9920166	9930223	9930227	9930232	9930237	9930245	9930432\nA	44	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nA	44	29024	166321	499076	892883	2916243	2929367	3727698	4003418	4302084	4304401	4446639	5473462	5596085	5707358	5967532	5967569	6030800	6122457	6992703	7116670	7148351	7280481	7290885	7303698	8612621	9324323	9630732	9631745	9632757	9716014	9748189	9760913	9765726	9771424	9884896	9903789	9903798	9903805	9903815	9904053\nA	45	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nA	45	29797	497546	3805537	3892909	4340898	4653174	5183804	5479562	5618881	5620751	5867745	6911741	7089982	7221963	7367497	7423280	7492027	7522155	8322463	8362380	8429233	8470742	8686240	8686467	9234368	9263623	9511482	9702899	9777695	9881519	9896482	9897707	9903188	9903196	9903201	9903210	9903214	9903219	9903222	9903433\nA	46	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nA	46	29590	1522615	1639573	2763276	3147729	3703678	5041843	5045494	5535655	5674865	5799897	6889196	6988293	7148922	7263791	7263830	7322021	8223675	8283666	8307859	8330371	8639293	8678818	8689482	9321362	9389631	9703114	9780139	9780549	9787676	9791830	9807021	9827612	9831474	9840335	9840352	9840360	9840372	9840380	9840569\nA	47	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nA	47	29242	574358	3065581	3467097	3851153	4779111	4784898	5084740	5220508	5342864	5451664	6546108	6697213	6756002	6804042	6899331	6985788	7078144	7901500	7921626	7932224	7954429	7954515	8796253	9321924	9411927	9472859	9800827	9801572	9802820	9805435	9805452	9805460	9810587	9818337	9818345	9818351	9818365	9818373	9818577\nA	48	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nA	48	34557	206298	2904201	3426284	3788878	4633655	5540370	5833202	5834888	5968670	6197641	7491204	7491285	7491358	7600028	7642884	7719912	8669540	8669561	8733018	8734787	8764752	8766153	9332687	9334206	9402504	9565232	9762612	9763389	9765244	9769016	9771197	9777721	9777726	9777736	9777743	9777756	9777760	9777769	9777989\nA	49	2	4	5	6	7	9	10	11	12	13	15	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32\nA	49	167910	577282	931554	1535074	1866524	2173865	2313471	2313544	3769244	3865941	3866617	3976724	4786344	4885086	4982333	5245301	5935368	5953026	5974491	5987095	5992981	6007277	6007895	6008296	6011861	6014529	6018646\nT	0	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nT	0	154992	160905	331526	345865	362492	443912	460417	568258	584771	593183	743499	751577	759717	776208	924364	932436	2508339	2583387	3462420	4120940	4826051	5009284	5101797	5118612	5248029	5455845	5727587	6433092	6670603	10006622	10199686	10537525	11001009	11201356	11206782	11211336	11233010\nT	1	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nT	1	372	159359	161592	170494	353470	369152	388793	461457	482539	582437	604075	617249	755609	768329	780857	801756	939255	942137	953523	2474639	2544218	3396058	4055695	4762526	4935421	5024013	5044271	5171781	5367692	5605156	6197556	6404948	9360884	9532383	9827081	10218931	10395480	10400081	10403861	10420894\nT	2	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nT	2	698	2728	6274	13119	189149	382259	402680	416218	896567	1028088	1043352	1050770	1214915	1230151	1237099	1260157	1422271	1428438	1451730	2518806	2615717	3934563	4588288	4864533	4868742	4890332	5085698	5242489	5416288	5419129	5585070	8569224	9022914	9798000	10144107	10400962	10565603	10569602	10572906	10587615\nT	3	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nT	3	847	3444	7925	21499	30045	217973	239544	511439	533421	640909	761477	786702	924744	942024	959631	968836	985942	1149773	1166559	2453454	2552269	3545305	4596910	4972754	4987180	4992810	5043322	5231505	5235738	5495615	5586947	5911694	9372201	9621072	9927180	10302374	10477760	10481046	10483648	10495792\nT	4	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nT	4	966	4064	377939	385284	475453	499991	698914	735427	852582	871249	1026273	1057049	1213193	1234620	1245955	1287110	1318381	1511798	1543025	2922056	3023095	4000762	4608976	5187129	5206199	5212951	5240476	5430582	5619170	5762339	6112361	6331020	6434054	9232431	9547012	10233859	10593992	10596925	10599256	10609629\nT	5	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nT	5	1160	28272	34007	42042	115368	434830	474433	594127	643838	798544	823115	846823	919172	1092519	1127695	1151938	1187743	1245877	1402477	2551341	2598198	3190631	4242862	5182071	5190438	5275090	5281933	5365001	5437485	5486153	8120017	8404659	8835255	9434658	9843403	10075349	10236659	10239057	10240945	10248866\nT	6	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nT	6	1368	37675	44104	125046	136519	198293	429954	439309	567446	774251	787094	828288	855541	1074088	1100802	1127562	1153906	1353288	1366799	2469143	2481327	3623363	4652076	5241225	5361341	5369074	5568794	5630921	5937050	6163799	6319098	6396081	6681240	9559216	10163578	10428199	10615481	10617433	10619000	10625589\nT	7	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nT	7	1418	37447	44561	54281	331285	383443	433358	464045	536068	869848	937501	986433	1035690	1117213	1334721	1416320	1497947	1546075	1842694	2459266	2471612	3666519	4710610	5627583	5636164	5738491	7938976	8140962	8225542	8406020	8557448	8698502	8898125	9378247	10001125	10209270	10588712	10590659	10592207	10598511\nT	8	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nT	8	1713	44104	51613	102458	167602	567659	1005104	1381197	1605832	1632781	1843244	1898384	1953341	2176938	2193395	2248267	2321618	2355969	2582458	3347088	3379151	4591141	5205015	5603165	5649969	5657421	5870357	5876011	6083055	6274565	6307428	8730009	9072997	9592192	9964560	10158904	10666571	10668017	10669175	10673854\nT	9	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nT	9	1789	95401	103504	170270	442492	501499	535489	570921	629877	877413	1085272	1298586	1357743	1437926	1518548	1717441	1776079	1833945	1891347	3713572	3790240	4384805	4604979	5349311	5796283	5982881	5989129	6060023	6556700	8717529	9185665	9188432	9401172	9521292	9796325	10141203	10453857	10455143	10456147	10460165\nT	10	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nT	10	2065	61010	126685	206570	286453	357335	418904	487981	667105	723246	1015507	1057517	1149263	1215510	1305758	1556794	1644890	1660695	1746186	3220576	3256520	3721188	4581291	5932251	5940059	5946788	5952587	6151029	7957047	8361365	8364481	8366930	8838981	9535949	9808722	10412052	10561831	10562843	10563664	10567117\nT	11	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nT	11	11746	67990	77109	151928	546198	623026	666319	740587	755401	958224	1059209	1284355	1328896	1347537	1584748	1679379	1772739	1839593	1879960	2997967	3235855	3676777	4273443	5731999	5815978	5847183	6090045	6119805	6148205	6404799	6509296	6906803	8650375	9073966	9621635	10263188	10499938	10500656	10501234	10503447\nT	12	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nT	12	2378	78050	87679	264381	281719	629552	679837	795358	1240817	1343835	1362311	1632255	1781827	1864474	1883134	2150397	2167516	2307119	2412961	3650386	3749281	4340564	5069471	6305433	6312158	6516583	6624556	6628572	6738198	8348753	8429935	8712387	9020599	9576908	9987916	10504402	10616033	10616677	10617142	10619091\nT	13	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nT	13	2672	183130	405786	519028	763190	1055892	1111149	1646203	1701248	1950161	2043261	2354282	2442380	2530486	2583565	2892125	2974084	3054545	3132449	4553539	4823921	5389984	5460868	6235918	6665911	6671109	6675334	6789554	8198887	8545788	8741760	8842462	9225566	9766642	10184340	10409776	10667301	10667769	10668144	10669614\nT	14	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nT	14	2910	11371	22146	37214	119491	382556	396372	412258	467851	533026	726486	957290	994159	1030926	1049947	1261815	1313402	1328354	1398034	2404669	2435217	2695480	3479441	4904803	5378146	5510726	5514370	5646141	5828666	5882215	5995620	6523020	6865487	9330964	9798659	10085920	10699684	10700108	10700398	10701595\nT	15	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nT	15	3242	11287	22752	38349	104390	123355	170641	186841	368401	407125	660456	698195	718327	756206	972561	1007646	1023464	1056813	1270431	2248197	2258024	2870146	3729831	5385704	5502109	5559395	5692425	5741945	5856002	6206977	6575862	7075593	7257470	7527337	7843142	8301982	8451049	10630182	10630443	10631443\nT	16	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nT	16	3409	11948	24122	41043	454445	902783	919015	1191246	1210161	1450317	1507736	1740618	1798453	1818153	1836446	2068901	2104072	2137432	2170933	3269570	3278650	3640559	4357715	5382417	5437956	5473055	5622131	5624593	5696006	5929329	6059710	6422814	7104307	9546698	9857018	10488406	10651948	10778158	10778354	10779120\nT	17	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nT	17	3657	12711	25368	42709	65184	107226	123015	178282	407211	448109	735387	756857	777553	797262	836016	1079412	1136538	1150203	1181801	2006230	2014926	3456017	3961531	5070813	5387105	5540734	5571158	5692094	5953554	6154118	6291391	6618293	7369283	7799457	8054812	8690886	8872719	8872928	10816502	10817048\nT	18	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nT	18	3877	13199	26676	45273	68878	114113	130805	225657	900331	943908	1217258	1279255	1299687	1339815	1357897	1633896	1648203	1660793	1671732	2224429	2255220	3890814	4783327	5648053	5679626	5682579	5740207	5895278	5926517	6044120	6396411	6738569	7209070	7812277	8204197	8685538	8766889	10617021	10617198	10617740\nT	19	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nT	19	4066	13894	27906	83646	293420	331655	359026	626591	1106815	1150201	1423862	1445233	1508837	1549919	1807213	1845680	1859467	1895313	2143802	2715414	2896661	3679351	4531695	5245700	5788522	5944038	6303588	6339686	6489674	6571657	6962680	7156473	7673996	7999439	8328355	8792463	8792673	10543903	10544031	10544425\nT	20	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nT	20	4412	15134	29934	50154	385605	402007	490494	510364	576516	799734	822168	1086949	1107323	1172632	1189590	1229521	1509673	1521148	1556580	2657136	2663993	3226327	3939756	4058231	4951731	5583020	5731103	5958012	6152653	6188124	6456345	6829927	7144515	8057277	8139419	8744852	10699835	10699963	10700047	10700360\nT	21	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nT	21	4950	16270	32084	53937	81486	147131	169566	190274	298907	537063	559502	634174	911400	929394	973243	987608	1028100	1323865	1332700	1932572	2001959	2829683	3282827	5027154	5535284	5579278	5737118	5774359	5891099	5971791	6227565	6581573	6781216	7443601	8387619	9066560	10787380	10787487	10787553	10787846\nT	22	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nT	22	5037	16770	642522	666157	715245	855239	1883352	1963141	2022074	2259714	2282042	2361561	2644684	2662100	2707158	2751123	2762440	3039622	3079324	3404038	3409349	3888077	5019333	5662394	5932480	5934158	5992205	6342484	6480885	6583667	6683197	6985098	7021591	7633324	9341920	10347685	10792008	10792121	10792184	10792423\nT	23	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nT	23	5248	17465	34774	59746	230288	249680	379728	612633	637119	1026954	1547797	1605839	1663030	1943385	2037917	2134025	2188607	2290264	2563644	3555558	3611762	4939896	5749152	6343100	6942147	7549619	7657012	7657879	8097712	8181841	9477017	9561118	9833634	10083530	10249471	10486189	10486290	10486360	10486404	10486598\nT	24	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nT	24	5623	31119	49844	172897	707343	1310123	1421669	1670899	1783372	2162293	2184746	2248442	2540938	2601493	2660761	2765038	3094230	3152712	3208336	3932570	3936811	4952227	5453312	6318036	6933258	7310101	7501367	7778686	8061273	8421433	8807632	8873042	9942454	10119336	10162419	10304449	10304514	10304562	10304618	10304766\nT	25	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nT	25	6224	31753	51673	121609	519366	540559	656025	680547	706258	1082373	1149667	1484216	1547368	1609217	1622503	1987263	2145065	2152397	2210381	2446018	2619372	4205615	5019893	5917389	6099193	6839245	6849253	7180367	7393989	7553503	7787015	8221029	8497232	8922896	9351508	10543824	10641588	10641622	10641661	10641796\nT	26	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nT	26	6416	21175	41981	548594	671523	693665	716854	837491	907146	1306589	1328788	1397001	1789492	1855892	2031573	2041633	2107514	2484618	2549123	3074414	3141913	3388709	4636105	6690024	6820955	6951987	7380727	7600465	7661338	7661589	8286313	9171249	9586266	9909277	9989704	10462127	10591435	10591469	10591495	10591569\nT	27	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nT	27	6851	22378	44443	116414	320626	957275	1682345	2049526	2968626	3017505	3142812	3161831	3539102	3552915	3617725	4036188	4195434	4317056	4321720	4959519	5025265	5822782	6904302	7372707	7686047	7753143	8129072	8524014	8845002	8926564	9108137	9919335	10109789	10308738	10331091	10331128	10331162	10331174	10331189	10331253\nT	28	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nT	28	7218	111372	713071	841578	922816	1320470	1605705	2712928	2739902	3372528	3447557	3465743	3870533	3883493	3951802	4284995	4412130	4481937	4653793	5433067	5589772	6151378	7053851	7278420	7612101	7828306	8005543	8362556	8482351	8835248	8943480	9074419	9964663	10099819	10277516	10514142	10514171	10514189	10514202	10514257\nT	29	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nT	29	7645	139283	164198	794249	834791	1036190	2354207	2745867	2773128	2887467	3278345	3361636	3512566	3524477	3673158	4042267	4566478	4984614	5216910	5863425	6048927	6917150	8110081	8142354	8679446	8697446	8886489	9100121	9578254	9980469	10017743	10333193	10360883	10389943	10434717	10734935	10734949	10734961	10734968	10735007\nT	30	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nT	30	8224	149103	175412	909163	1073754	1233281	1671273	2710509	2738448	3229977	3318093	3405115	3491049	3649927	4120825	4127845	4289403	4451422	4990768	5536386	5810362	6472684	8050445	8277120	8505064	8743558	9213480	9538967	9689261	10205934	10326311	10543735	10620274	10648565	10735507	10735521	10735534	10735543	10735547	10735568\nT	31	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nT	31	8469	145292	814240	1652874	1736642	2299231	2718861	2746882	3309187	3864959	3951136	4034958	4117493	4611713	4619930	4773440	4855192	5334718	5496975	5984851	6300163	7573813	8369705	9018823	9130083	9620488	9952583	10175013	10179257	10380939	10419754	10568275	10633343	10665837	10694829	10694849	10694856	10694866	10694871	10694904\nT	32	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nT	32	9618	136163	165479	1236943	1536210	1785247	2255819	2283955	2449721	2495644	3000810	3085845	3169870	3179559	3261306	3417576	3852409	4015880	4099979	5186532	5352885	5695537	6424606	6543052	7849604	8088692	8360403	8657841	8793212	9131925	9290068	9599578	9838870	10573119	10674908	10731594	10731617	10731640	10731658	10731787\nT	33	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nT	33	4659	24512	60599	1008727	2137156	2235745	2540938	2711391	2739954	2922380	2938809	3390057	3542320	3548844	3628357	3708774	4165739	4324435	4492786	4913693	4999269	5790636	6216579	7457679	7457820	7642335	7792302	8175098	8316467	8824179	9084336	9433764	9557952	10115796	10388361	10676656	10676663	10676671	10676678	10676740\nT	34	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nT	34	18463	91230	919649	2134631	2321054	2380308	2842021	2858130	2873270	3050857	3063616	3621376	3708771	3797427	3888219	3896711	4550973	4645584	4740960	5728018	5733855	6834147	7356659	8072854	8651372	8891791	8933188	9494330	9596128	9626942	9895104	10262090	10510243	10717066	10801846	10892262	10897213	10901646	10905482	10932719\nT	35	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nT	35	944	15131	21662	215920	438797	439673	729515	730138	879393	880172	1507691	1507944	1584421	1584652	1661922	1742657	1826538	2316460	2488206	2698138	3070915	3161711	3520731	4206456	4262909	4285015	4530331	4696548	4929597	5345264	5921935	6116560	6292010	6399229	6558004	6655527	6655658	6655782	6655891	6658191\nT	36	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nT	36	20921	708860	1284864	1881911	2384454	2737198	3069793	3242675	3257947	3286293	3986305	3998579	4093019	4188654	4287223	4388832	5115132	5123358	5329554	6170198	6377889	6803325	7486744	8322304	8454617	8710768	9331039	9599336	9781506	9830993	10098273	10434008	10678646	10768629	10859359	10898638	10901345	10903676	10905704	10917120\nT	37	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nT	37	6021	31636	185103	1612266	2524945	2992225	3353752	4364347	4392820	4431828	5161888	5170805	5261958	5266422	5355090	5446317	5447847	6098290	6288391	6872860	6973905	7105811	7206027	7306318	8319694	8553794	8978752	9308926	9525257	9773849	10039295	10121367	10410970	10518343	10605376	10748699	10822651	10822656	10822658	10822691\nT	38	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nT	38	12042	41147	85010	511960	2042404	2245038	2627575	3635732	3662877	3702920	4479970	4490733	4590781	4690704	5370917	5475012	5788823	5790468	5899149	7319491	7515443	8189747	8529953	9512942	9597070	9881488	10097826	10150409	10425009	10471911	10659696	10670455	10736448	10793111	10889721	10889723	10889725	10889727	10889729	10889751\nT	39	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nT	39	11472	41577	778182	1078818	2232144	2469418	2834797	3583050	3609604	4617951	4630973	5336121	5441717	5548763	5656905	5867417	5869200	6583404	6796054	7300823	7398565	7873082	8026898	8850600	8949852	8950950	9327349	9608803	9917220	10202328	10211939	10326031	10607430	10673203	10802603	10802607	10952236	10952240	10952242	10952263\nT	40	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nT	40	11373	108316	873929	1146371	1647714	1847668	2453968	3275037	3501630	4915162	5028102	5770768	5982193	5986752	6195639	6304096	6509699	6609616	7332634	8369301	8495453	8677874	8710160	8816922	9541170	9541816	9842125	9961020	10154628	10212239	10358210	10474778	10648471	10680985	10680990	10680994	10954724	10954726	10954727	10954734\nT	41	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nT	41	11701	124917	176582	2159125	2504820	2539415	3179669	3880595	4866787	4900409	5020646	5783579	5897800	6011023	6228292	6230196	6332863	6547426	7446539	8385548	8496339	8870476	8888267	8961079	9548085	9603885	9630351	10082832	10269320	10314382	10473026	10561431	10769696	10802581	10863410	10863412	10863415	10863417	10863422	10863432\nT	42	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	39	40\nT	42	11692	904877	2670547	2983833	3349679	3547065	4418737	4669128	4692950	4835947	4955761	5754292	5871233	5874764	6094721	6414668	6415847	6611073	7631309	8126323	8268614	9004843	9106325	9654925	9664275	9682407	9712342	9963711	10053446	10685905	10721099	10770431	10831113	10860502	10887744	10934833	10934836	10934837	10934847\nT	43	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	39	40\nT	43	11722	138802	1125398	3115114	3459735	3689749	4386469	4413547	4676382	4825294	4951579	5793587	5916399	6147420	6149480	6375971	6480947	6599976	7570310	8037067	8250916	8717152	9271115	9809736	9810720	9820345	9821802	10013379	10475510	10570753	10582038	10636072	10938451	10975865	11001359	11001360	11001361	11001363	11001368\nT	44	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	39	40\nT	44	11473	147777	687653	1040473	3078353	3113143	3822775	4009695	4285636	4312800	4449389	5313700	5443926	5574923	5946149	5947206	6064596	6276509	7230137	7899345	8014472	8444809	8492077	8534808	9551857	10269077	10674315	10676763	10679517	10799665	10867872	10899325	10917396	10938839	11079643	11118616	11118618	11118620	11118631\nT	45	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	35	36	37	38	40\nT	45	11356	455735	3332104	3409165	3952485	4271069	4739558	5025207	5175127	5200660	5460881	6359055	6601329	6831225	7174927	7334249	7575214	7698482	8440100	8750304	8849818	9044290	9531146	9531547	10072398	10141468	10494684	10720310	10835394	10971802	11010589	11015298	11034440	11034442	11034443	11034444	11034446	11034453\nT	46	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	40\nT	46	11718	1167891	1233111	2495836	3018860	3518938	4750365	4774726	5521926	5680423	5818635	6749083	6882596	7131743	7368488	7369241	7537980	8571334	8830667	9077025	9201604	9454063	9644294	9702993	10374582	10488498	10861780	10990395	10991444	11013614	11025475	11062345	11106255	11122032	11146593	11146594	11146596	11146597	11146604\nT	47	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	39	40\nT	47	11869	536690	2556143	2833089	3249279	4235869	4263591	4568951	4725865	4881156	5020584	5972221	6221751	6343500	6456006	6739211	7049409	7287352	8094907	8316794	8355707	8498723	8498870	9916763	10447433	10579481	10679997	11119747	11121765	11126109	11132415	11132416	11132418	11148287	11171081	11171082	11171083	11171084	11171091\nT	48	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	37	38	39	40\nT	48	14278	197579	2688862	3168291	3646361	4657228	5523883	5847704	5865230	6033375	6321159	7563409	7565892	7567441	7801060	7912139	8171560	9291759	9291939	9704590	9711554	9864601	9869350	10524059	10529677	10665384	10885471	11174000	11176733	11183283	11194461	11205060	11230762	11230763	11230768	11230769	11230771	11230774	11230786\nT	49	2	4	5	6	7	9	10	11	12	13	15	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32\nT	49	175237	534298	895981	1416535	1736775	2026196	2169846	2169952	3551198	3685696	3687239	3909554	4648549	4823333	5094277	5630875	6490423	6565481	6657340	6699407	6717447	6786458	6787867	6788814	6796926	6806710	6823020\nG	0	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nG	0	90949	93938	193069	208306	216924	269753	278109	336442	344087	348317	428921	432633	436018	443106	517723	521117	1836016	1871281	2578161	3005729	3462755	3537006	3577686	3584487	3630071	3706516	3797862	4621348	4729714	6747298	6840599	6983780	7199216	7280524	7296917	7311496	7416210\nG	1	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nG	1	111	95776	96300	100213	209235	222577	232649	279420	289233	349513	359238	365048	453693	459577	465471	475755	562007	564208	570585	1860936	1903792	2601283	3046117	3517369	3611246	3662585	3673181	3733642	3832856	3956473	4843642	4982907	7221446	7332921	7508463	7778178	7877370	7891798	7904580	7989949\nG	2	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nG	2	210	944	2000	4235	104960	219735	229601	234875	563498	642661	648230	649673	752278	757946	760159	770275	869468	872353	882980	1948358	2003348	2881903	3414483	3563313	3567156	3578524	3699860	3792199	3882422	3885970	3971020	6236439	6460987	7499340	7705837	7893303	7989779	8002648	8013744	8086888\nG	3	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nG	3	267	1191	2648	8850	10630	156095	166980	315428	330896	394070	464990	476107	562624	569534	576713	579991	587743	686398	694788	1895539	1952065	2648575	3416185	3670911	3680204	3685348	3711492	3814883	3819829	3954748	4003208	4205730	7450169	7597757	7777801	8050181	8150090	8161388	8171049	8232998\nG	4	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nG	4	339	1502	264236	266295	374010	387222	516780	535943	615225	618686	711941	725227	822798	830672	834321	853129	866641	979989	994029	2105337	2162565	3016223	3446378	3815753	3826886	3833318	3848207	3943842	4042614	4131595	4311733	4459351	4518297	6673482	6876213	7857603	8044390	8054084	8062681	8113733\nG	5	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nG	5	366	23431	25580	27991	74186	342472	374349	458369	484149	574103	583974	592332	625789	734912	749673	759529	775057	801211	903094	2037277	2059674	2449136	3205162	3856876	3864322	3919138	3926273	3980611	4031367	4072411	6125210	6319586	6554810	7420869	7675772	7863144	7961053	7969083	7975998	8016070\nG	6	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nG	6	476	30164	32703	82000	84904	123700	300072	301917	387296	516926	520094	540314	552144	684714	696066	708034	720642	840481	847691	1916626	1924562	2885163	3524796	3911745	3982137	3990052	4098167	4145867	4316156	4451940	4546704	4615222	4764440	7324176	7679067	7873339	7977184	7984067	7989857	8023274\nG	7	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nG	7	567	28994	31678	34696	234502	264382	300248	315016	352957	549881	581652	603064	625158	662979	790283	828866	867684	891119	1066590	1745730	1754456	2822237	3533196	4088748	4097138	4156670	5789160	5899948	5952413	6054250	6149801	6240340	6368386	7056114	7457007	7612253	7817728	7823731	7828843	7856241\nG	8	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nG	8	591	34927	37813	67966	107843	339040	669045	898389	1063618	1070530	1196328	1223996	1251175	1388729	1395765	1423641	1461549	1479974	1618721	2488972	2508056	3522451	3895745	4168237	4196465	4204873	4332388	4339961	4454006	4566973	4599884	6300577	6493908	7152493	7393931	7541456	7829305	7834169	7838364	7860512\nG	9	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nG	9	770	69965	73404	116047	304891	343129	362635	381815	416964	597788	735016	868111	901138	946673	992042	1122084	1155556	1189322	1223688	2771982	2818121	3379134	3558236	4063909	4344915	4459199	4467157	4517277	5104877	6621928	6913074	6918095	7052334	7140856	7334378	7572639	7762069	7766382	7770007	7789264\nG	10	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nG	10	882	47583	87017	136823	185810	230084	276100	315583	433562	458189	631776	652751	703933	740373	791255	945004	996719	1007251	1059153	2367392	2391519	2868448	3405854	4404314	4413281	4421777	4429744	4547965	5830778	6077895	6083176	6087906	6360507	7034529	7262625	7661396	7759910	7763378	7766265	7780335\nG	11	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nG	11	11842	53797	57527	100925	328315	380856	407929	457170	461056	607855	676697	815437	842105	850959	1001865	1064124	1125397	1168650	1196055	2274860	2425890	2850632	3310472	4348166	4402844	4425907	4573988	4595413	4616130	4769882	4830695	5323134	6499154	6731095	7134121	7548896	7699045	7701853	7704133	7715104\nG	12	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nG	12	1084	62073	66013	177532	182340	426992	457111	547618	866188	922445	929285	1093438	1181188	1228349	1238826	1407025	1418528	1500409	1563269	2706741	2766983	3226915	3840637	4676915	4685574	4814335	4881907	4887998	4953046	6075770	6129031	6312680	6505140	7040040	7335021	7661739	7723705	7725870	7727618	7735915\nG	13	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nG	13	1178	132693	284469	356109	556275	828735	860922	1207643	1237125	1420508	1474274	1660039	1710332	1761302	1792154	1983146	2031571	2079998	2127550	3408597	3576779	4014751	4059139	4614928	4906301	4913642	4920343	4990181	5897640	6095090	6214018	6275758	6688233	7009017	7333996	7498987	7659488	7661258	7662700	7669088\nG	14	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nG	14	1344	5588	10064	14844	90113	283988	287918	292505	322965	374568	517023	656642	678510	701788	714002	850008	886578	899120	948737	1988729	2013026	2231793	2850809	3855547	4136375	4220257	4226173	4316677	4433233	4475057	4541827	4857273	5220054	6943663	7278502	7469082	7847933	7849418	7850625	7855569\nG	15	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nG	15	1532	5690	10409	15493	70725	78227	103606	108498	245127	260542	416267	438377	449654	474311	612545	637641	650520	676179	814432	1881863	1892772	2338287	2975180	4173759	4245118	4286581	4371040	4408074	4484690	4700700	4935227	5259840	5376354	5575544	5817425	6123316	6336432	7844149	7845149	7849323\nG	16	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nG	16	1652	6106	11093	16467	365894	624307	629637	834105	840670	1029097	1064062	1202859	1241466	1254214	1267586	1414454	1442247	1469037	1497125	2467433	2477781	2848948	3419750	4158755	4202123	4228575	4325545	4329784	4385985	4544028	4644412	4969830	5402298	7069660	7301269	7706634	7817437	7890113	7890847	7893870\nG	17	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nG	17	1831	6594	11706	17197	24195	45758	50740	82005	271932	290094	464623	476724	489570	503185	532127	687049	732614	745627	771970	1547663	1557728	2720436	3187210	3936821	4183787	4282595	4307281	4396682	4563236	4702120	4791749	5011058	5572750	5865342	6076146	6501859	6622042	6622774	7929062	7931346\nG	18	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nG	18	2081	7242	12707	18429	25742	48597	53958	139789	636397	656545	822808	865324	878764	908777	922955	1106553	1120023	1132971	1144655	1694330	1722309	3081828	3726417	4422002	4449534	4454384	4501490	4604240	4630031	4721979	4949914	5186143	5498246	5966452	6252249	6592081	6647870	7874239	7874710	7876621\nG	19	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nG	19	2236	7726	13430	73340	283503	302539	315007	523219	866139	887950	1055905	1069672	1116682	1148890	1316510	1349263	1362768	1394536	1558625	2183234	2313271	2976167	3705811	4176793	4503359	4609220	4837045	4867048	4977513	5048289	5319050	5455767	5869546	6112181	6355157	6685346	6685898	7801162	7801537	7802898\nG	20	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nG	20	2428	8235	14230	20779	313115	318590	373017	380951	442269	610333	623698	782433	797147	848494	863582	898292	1078271	1090409	1123454	2203879	2212358	2685146	3125396	3250512	3924961	4379135	4474985	4640703	4796329	4827302	5011368	5247912	5490794	6123597	6196237	6615944	7916599	7916951	7917202	7918159\nG	21	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nG	21	2682	9081	15510	22641	31959	67334	76571	85352	182795	366272	380729	438154	608187	623599	661522	675515	712834	906153	916474	1533380	1598585	2344761	2620022	4035611	4350682	4387873	4492472	4526327	4627390	4694082	4873268	5116201	5251751	5738463	6403359	6865786	7987744	7987989	7988181	7988924\nG	22	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nG	22	2956	10003	461374	469006	491602	611971	1307260	1359552	1420644	1605230	1620435	1684729	1855320	1870713	1911689	1953348	1965689	2134684	2173802	2549175	2556393	3011783	3920469	4462071	4659682	4662438	4717071	4956454	5059999	5132282	5191585	5389869	5427326	5857278	6900953	7594411	7922830	7923033	7923178	7923767\nG	23	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nG	23	3210	10517	17561	25799	150287	157910	272741	459075	471702	721878	1124299	1171709	1219940	1398259	1481826	1568035	1617908	1706203	1881817	2841285	2886824	3878561	4544425	4911139	5377692	5776413	5843091	5844476	6148385	6216679	6941894	7014920	7206756	7393210	7525404	7705805	7705992	7706120	7706237	7706626\nG	24	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nG	24	3576	22115	29692	140555	458470	905719	979891	1180117	1262186	1498289	1514662	1568375	1747871	1800834	1854050	1946462	2164954	2215286	2264380	2985654	2991500	3910524	4281939	5000441	5387097	5664796	5788410	6005390	6230950	6468674	6742809	6787863	7410768	7522221	7561937	7641413	7641564	7641685	7641770	7642106\nG	25	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nG	25	3930	22020	30105	104447	399593	408528	488560	501160	515623	826080	882594	1085206	1141959	1199272	1213239	1451051	1594331	1603218	1655398	1919247	2057306	3468400	4077200	4702711	4827944	5379683	5389222	5596160	5733446	5820248	5962467	6269260	6453135	6745309	7070584	7774153	7845396	7845494	7845568	7845785\nG	26	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nG	26	4110	13323	21726	444939	514212	523482	534914	618939	705696	1042706	1060132	1119579	1378501	1438415	1593036	1605014	1662985	1908172	1963366	2470382	2521217	2753187	3802698	5297254	5376405	5455287	5720379	5841679	5875664	5876150	6310516	6800844	7098310	7345087	7419296	7751655	7842505	7842571	7842622	7842787\nG	27	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nG	27	4607	14449	23398	107503	235376	646633	1288045	1582094	2153057	2188195	2294436	2311676	2561077	2575573	2636974	2935756	3039085	3150260	3156428	3732293	3788391	4546796	5417619	5775275	6005938	6046256	6331726	6611856	6798999	6854847	6957488	7386821	7498943	7632265	7652701	7652786	7652857	7652908	7652949	7653061\nG	28	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nG	28	5038	80246	456845	536118	628911	969853	1196636	1935328	1952426	2481034	2552870	2569886	2837377	2851254	2918388	3129429	3248721	3310847	3421509	4206108	4312235	4846965	5620219	5778987	6026711	6155447	6292647	6501519	6604096	6853921	6925699	7014881	7506269	7579754	7719997	7828155	7828195	7828243	7828263	7828345\nG	29	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nG	29	5501	92878	103246	627267	646349	825377	1820696	2133438	2151213	2241074	2475722	2546444	2672210	2685162	2808064	3086895	3404479	3659931	3787805	4356869	4448372	5155453	5889414	5905480	6354232	6371621	6486349	6639853	6991224	7283739	7318589	7580809	7607055	7633221	7675743	7930810	7930845	7930865	7930883	7930939\nG	30	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nG	30	5907	101459	112471	646396	746245	860198	1359920	2101632	2120317	2434522	2510110	2585524	2659538	2789609	3075386	3083952	3203966	3314738	3648020	4114115	4284010	4803247	6101702	6245962	6359639	6540313	6894514	7095168	7219202	7525913	7632814	7783361	7853009	7878454	7946169	7946206	7946222	7946237	7946252	7946295\nG	31	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nG	31	6407	98086	527964	1083120	1184761	1807953	2167249	2185393	2551588	3065268	3143622	3221564	3299205	3606223	3615928	3750824	3820074	4128945	4248307	4665589	4857779	5822994	6350852	6740082	6818848	7109870	7372978	7550894	7554651	7726297	7760387	7894633	7952175	7983075	7996197	7996217	7996235	7996246	7996255	7996276\nG	32	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nG	32	7280	93911	106321	1001319	1232716	1432255	1881826	1901199	2041841	2080620	2397783	2478140	2556614	2567343	2642190	2778220	3025001	3153883	3213856	4192329	4301067	4585978	5018770	5071344	6020384	6130950	6287927	6470114	6544708	6770461	6912103	7160252	7366626	7803764	7889653	7940982	7940996	7941018	7941026	7941053\nG	33	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nG	33	6028	20679	36182	637482	1423180	1560966	1838798	1971149	1990590	2151562	2166792	2433313	2579200	2588272	2664545	2740053	2999673	3140888	3276029	3821991	3884682	4597465	4928397	5839274	5839621	5935378	6013312	6245387	6324393	6557384	6750072	7036630	7101895	7529142	7711749	7930718	7930734	7930739	7930745	7930770\nG	34	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nG	34	8551	54785	852746	1758620	1881948	1991629	2409717	2424088	2438207	2600658	2613139	2968190	3052221	3136494	3219173	3227139	3650293	3726162	3799369	4605142	4610064	5557133	5939097	6351772	6784061	6943122	6961333	7272956	7362704	7377521	7594240	7924265	8098872	8258433	8316634	8395830	8397535	8398976	8400144	8406863\nG	35	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nG	35	1193	18589	23703	227335	381293	381932	660427	660819	786905	787424	1201967	1202173	1277637	1277798	1355485	1434197	1512718	1789114	1942120	2118566	2381792	2435444	2628399	3031780	3055520	3064109	3215239	3309713	3463403	3812934	4146136	4318451	4458035	4546287	4635717	4675668	4675758	4675833	4675915	4677682\nG	36	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nG	36	13631	653304	1186804	1728251	2148549	2536000	2859188	3005536	3021150	3050615	3509707	3522373	3612380	3702649	3792225	3880343	4342062	4349077	4493981	5114551	5239994	5666418	6356538	6840309	6894942	6996219	7309129	7485725	7629723	7659084	7879972	8122353	8348161	8421513	8483549	8518371	8518794	8519117	8519424	8520597\nG	37	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nG	37	8588	28257	136118	1341140	1924037	2357413	2697912	3439664	3459606	3494081	3980238	3991046	4083204	4089953	4180431	4269381	4272033	4675396	4839060	5562269	5635175	5743704	5811828	5875462	6459321	6558377	6754916	6949253	7114225	7302428	7535092	7614535	7799433	7847597	7912313	8044349	8115831	8115832	8115835	8115843\nG	38	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	40\nG	38	13096	36636	58094	595331	1948020	2082694	2448357	3158128	3178651	3211989	3716351	3726244	3818371	3909497	4332401	4419912	4656271	4657756	4729122	5718475	5818714	6179805	6390857	7178907	7209765	7334892	7543429	7563418	7768604	7813929	7949421	7958804	8007702	8044616	8137327	8137333	8137339	8137340\nG	39	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	39	40\nG	39	13369	38751	720167	899058	1791115	1944443	2291771	2925751	2945646	3706080	3717835	4142941	4235943	4325073	4411519	4568344	4570248	4984966	5114272	5478376	5526099	6129348	6190427	6672533	6705585	6706388	6930697	7057686	7284863	7532960	7541969	7647821	7867134	7904571	7999551	7999552	8127719	8127720	8127723\nG	40	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	39	40\nG	40	14192	80606	789603	963680	1416369	1846680	2399347	2986777	3183639	4240633	4340340	4791749	4964183	4968738	5120526	5189740	5309464	5362142	5773754	6404882	6449482	6507838	6517538	6551145	6990610	6991110	7210232	7279658	7433080	7468114	7594293	7699653	7842094	7870134	7870138	7870140	8139034	8139035	8139036\nG	41	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	40\nG	41	15456	88560	115284	1471585	1815493	1839191	2407717	3289813	4199814	4227762	4328389	4784540	4876192	4962247	5115517	5117438	5174589	5305229	5805599	6355816	6396012	6594774	6599991	6625127	7018853	7036212	7044232	7376818	7547734	7591326	7730085	7807647	8007646	8037719	8090677	8090679	8090681	8090683	8090687\nG	42	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	40\nG	42	16381	819464	2032312	2233822	2594045	3060454	3788322	3988689	4006261	4120954	4216272	4683941	4767333	4770725	4915190	5090196	5091269	5180643	5706945	5981966	6030610	6594543	6623576	7015561	7018351	7027305	7036039	7213895	7282931	7855374	7866712	7906024	7953312	7979303	7999721	8047250	8047251\nG	43	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	38	40\nG	43	17210	97632	753457	2458711	2678247	2838493	3441892	3462202	3668140	3785069	3882357	4368317	4452311	4597093	4598962	4717945	4768305	4818014	5336742	5587214	5653646	6269336	6701926	7105754	7106435	7109139	7110148	7271203	7680534	7751230	7759879	7801108	8055330	8064857	8088962	8088963	8088965\nG	44	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	40\nG	44	17882	98192	534662	754863	2506927	2531271	3145879	3645305	3856770	3879820	3981319	4477085	4565489	4647253	4845986	4847094	4900558	4983004	5491990	5835900	5868497	6064529	6084100	6112882	6772000	7338237	7682055	7683954	7686304	7796119	7854850	7884665	7899083	7915113	8044015	8083891	8083893\nG	45	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	35\nG	45	18749	317245	2883749	2929295	3434087	3653896	4100670	4311778	4418713	4439463	4614762	5117908	5252743	5361349	5494980	5551986	5625457	5662028	6110517	6279933	6319784	6446617	6858114	6858345	7285726	7345203	7668007	7847976	7950033	8073647	8104061	8107406	8123048	8123049\nG	46	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	40\nG	46	19997	786268	822229	1857885	2192243	2663385	3714737	3732598	4328429	4441752	4536245	5061577	5138437	5266637	5365957	5366626	5422869	5975124	6041687	6180481	6207772	6747731	6868862	6884098	7433711	7528778	7845098	7974019	7974920	7993422	7999043	8034240	8075341	8086238	8107603	8107605\nG	47	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	34	35	37	40\nG	47	21456	362015	1927562	2694264	2967259	3765378	3785846	4004340	4110421	4214118	4297679	4817654	4937141	4986841	5029972	5118425	5203881	5265683	5749252	5879001	5887389	5965057	5965155	7063263	7504771	7624352	7714159	8094937	8096522	8099468	8103494	8117068	8136255	8136256	8136257\nG	48	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	40\nG	48	24312	131735	2070432	2559494	2845950	4001605	4711229	4927427	4939689	5048684	5221397	5891427	5893350	5894631	5990982	6031843	6111926	6702686	6702795	6882907	6884471	6977506	6978558	7542301	7546081	7661177	7836555	8091605	8093078	8095703	8100647	8102896	8120898	8120899\nG	49	2	4	5	6	7	9	10	11	12	13	15	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32\nG	49	286640	530599	751988	1234300	1454951	1668599	1767993	1768050	2548069	2625175	2626360	2774336	3260496	3326880	3426610	3747926	4469772	4489689	4515134	4539767	4553559	4570311	4571230	4571893	4575568	4579244	4583023\nC	0	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nC	0	231588	239224	474093	504548	523380	614210	632493	741576	759559	768671	928180	936998	945953	963708	1123053	1132112	1909260	1988264	2368385	2940827	3675226	3859188	3956583	3975058	4097073	4296596	4436354	4567745	4682116	6625869	6710119	6882473	7014873	7135903	7135910	7135919	7136027\nC	1	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nC	1	406	234822	236119	246657	492267	528225	550748	650820	673071	789767	811043	822817	980217	991442	1002295	1023146	1183613	1184067	1194627	1954250	2034686	2421554	2992081	3723975	3926139	4028936	4051101	4190751	4413801	4552384	4669989	4787325	6692319	6778982	6953545	7073210	7198201	7198211	7198218	7198397\nC	2	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nC	2	803	2676	5054	11489	250488	497601	520969	534873	967422	1097738	1110431	1113863	1286106	1296830	1298494	1316867	1486629	1487222	1506447	1776902	1875943	3118862	3378124	3717937	3717983	3736965	3906360	4035646	4202640	4202654	4305585	6162794	6504665	6688933	6907174	6986340	7106249	7106256	7106265	7106446\nC	3	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nC	3	1326	4153	7658	24375	34050	98144	125292	462614	499967	623772	747401	769618	908278	919545	929878	931349	940759	1106369	1115179	1790952	1886587	2729494	3598429	3875033	3883413	3883445	3930021	4082328	4082339	4301659	4370285	4543622	6598717	6805133	7031052	7168137	7298612	7298627	7298640	7298843\nC	4	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nC	4	1771	5687	263781	271487	284440	316434	613901	657668	777557	793755	937636	963217	1115962	1128536	1130525	1161520	1182306	1371273	1392043	2449993	2543648	3019655	3547919	4026472	4037770	4037793	4058556	4204626	4377345	4480004	4742606	4829191	4892011	6663642	6816122	6952475	7206369	7206373	7206378	7206469\nC	5	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nC	5	2284	39690	45821	55582	167757	275525	346001	482642	548253	701732	725057	744087	820609	1006247	1034801	1049204	1075714	1128114	1294455	1788760	1827511	2510812	3383148	4190040	4190079	4277814	4277826	4366276	4400308	4413421	6342794	6477590	6862630	7011995	7325666	7396797	7514940	7514948	7514953	7515047\nC	6	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nC	6	2992	51333	58367	160191	177879	270461	392829	405484	539240	756056	763253	801543	820773	1035367	1050191	1064424	1077790	1269827	1270245	1825820	1825993	2420835	3514635	4140756	4251385	4251398	4432095	4461319	4698031	4834098	4942415	4958908	5169496	6750805	7131141	7214733	7346119	7346125	7346128	7346199\nC	7	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nC	7	3794	50972	59642	73128	256080	334667	419380	461929	552570	897824	965580	1007769	1049078	1120222	1322721	1387056	1450490	1481621	1766466	2002645	2002763	2543645	3363675	4502101	4502139	4592561	6046883	6233940	6276713	6404258	6516312	6579527	6699958	6790675	7148093	7216664	7497813	7497817	7497819	7497910\nC	8	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nC	8	4324	56550	65958	124298	225347	723858	990855	1500906	1754966	1775655	1960993	2007513	2049637	2266541	2268235	2306237	2358649	2375814	2596970	2838294	2854899	3490529	4090590	4481146	4512835	4512851	4727089	4727097	4922915	5050046	5055079	6666420	6922984	7027978	7243360	7297201	7601154	7601157	7601163	7601244\nC	9	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nC	9	5059	125132	135871	248977	503449	599825	653303	702887	779306	1047903	1270980	1460105	1507267	1569934	1629523	1840950	1877447	1912927	1947972	3187115	3238354	3529198	3589933	4169083	4751323	4965937	4965944	4992725	5194508	6730126	7109000	7109004	7224295	7266401	7397451	7549399	7727871	7727872	7727876	7727955\nC	10	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nC	10	5700	79249	150341	271456	396646	502824	604133	691977	890642	938986	1216195	1245682	1322154	1368795	1434646	1657137	1717532	1717876	1773928	2792159	2811208	2851579	3820211	4813399	4813416	4813428	4813438	5016173	6269797	6555127	6555135	6555138	6905042	7251444	7327537	7620833	7686538	7686540	7686543	7686639\nC	11	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nC	11	30438	88628	101416	188322	620021	741848	808061	911500	925323	1138436	1247345	1439570	1469665	1471540	1693453	1765791	1833704	1875486	1896906	2497027	2723094	2992961	3424794	4609135	4666124	4684011	4924425	4942510	4960374	5176251	5277778	5414083	6606780	6958905	7167431	7492032	7609332	7609333	7609334	7609410\nC	12	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nC	12	7109	96335	110241	325985	357453	715538	782218	944296	1377255	1468879	1474437	1692870	1815574	1872119	1873097	2129190	2129558	2227424	2296632	3098189	3161408	3538666	3904448	5015179	5015195	5241841	5357521	5357528	5465303	6545441	6583388	6715850	6948591	7171447	7338022	7627498	7728545	7728546	7728550	7728620\nC	13	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nC	13	7762	210536	467026	639297	820420	970043	1045293	1713051	1770952	2017332	2100975	2355970	2421156	2486647	2518431	2802015	2855952	2907384	2956974	3839495	4097760	4470046	4517491	5069106	5504252	5504261	5504270	5624071	6645717	6977827	7087772	7145497	7218153	7602715	7721285	7779769	7906271	7906274	7906279	7906370\nC	14	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nC	14	8775	24605	40452	65601	122052	284049	302110	318483	377012	450180	603064	773272	792883	812154	812869	1023965	1061030	1061205	1117890	1691797	1712019	1878007	2383414	3627401	4132527	4277483	4277487	4399943	4573382	4585550	4699426	5142392	5240374	6515478	6803432	6964866	7307792	7307793	7307794	7307869\nC	15	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nC	15	10313	24911	42636	70188	186226	215278	270934	286483	426971	444968	634368	654907	656516	675496	891675	909955	910168	928591	1159546	1517446	1517478	1982333	2749864	4154080	4268172	4315430	4458457	4500722	4600442	4894561	5153305	5448593	5572942	5683097	5793212	6073905	6084697	7291995	7291997	7292093\nC	16	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nC	16	10691	25679	44079	72613	228258	709528	730839	878358	890434	1101775	1143422	1300148	1339464	1340368	1340880	1556751	1575986	1594779	1615112	2189157	2189183	2507653	3082890	4097114	4144040	4172114	4324270	4324275	4376018	4568217	4630030	4791205	5289634	6578495	6693443	7162771	7233219	7335255	7335262	7335328\nC	17	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nC	17	11819	27644	47021	76820	115335	176692	194500	250850	468116	481262	690125	692128	693410	694147	714871	948948	990021	990114	1010275	1400662	1400683	2316283	2679441	3850712	4072326	4237047	4262206	4369476	4643007	4801400	4896515	5052889	5589359	5851365	5906396	6301480	6387864	6387866	7425239	7425304\nC	18	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nC	18	12733	29161	49448	80351	119739	181551	199465	332112	1029287	1045395	1227507	1271675	1272740	1294900	1295264	1581001	1581130	1581212	1581268	1869012	1891425	2886393	3887291	4416514	4443078	4443083	4495391	4666190	4694518	4788137	5121695	5323821	5701991	6011439	6189973	6466329	6504030	7437508	7437512	7437582\nC	19	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nC	19	13780	31044	52115	159317	492747	544122	576612	788821	1334935	1346142	1526121	1527657	1572643	1595477	1860931	1883950	1884050	1907408	2191456	2239368	2440052	2953000	3361435	4066853	4539900	4712761	5043242	5075606	5146755	5206907	5499167	5605161	5899257	6083114	6219006	6533493	6533494	7397254	7397256	7397319\nC	20	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nC	20	14851	33123	55243	88310	199836	219928	318709	332214	421818	567935	570146	739983	740756	788778	789037	813669	1072135	1072174	1097372	1872579	1872592	2256657	2902427	2907417	3502839	4215158	4362170	4572112	4694037	4726564	4939910	5184503	5334626	5972744	5982513	6378894	7278674	7278676	7278677	7278748\nC	21	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nC	21	15847	34967	58160	91852	132852	217224	241817	254634	389128	543225	545362	602582	779886	780251	808723	808861	837784	1125287	1125309	1205918	1269251	1724161	2082850	3700201	4185964	4225384	4387753	4422839	4533266	4608637	4793032	5056167	5205655	5685671	6249185	6697425	7440314	7440317	7440319	7440389\nC	22	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nC	22	17289	36759	730242	764828	834637	914201	1965590	2042163	2118626	2268889	2270607	2334836	2509507	2509798	2541916	2574254	2574305	2824397	2857199	2895664	2895681	3032115	3790389	4236106	4516718	4516719	4555739	4881767	5000822	5089420	5158678	5430062	5433102	5881518	6617023	7212577	7387314	7387317	7387319	7387394\nC	23	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	38	39	40\nC	23	17830	37537	61675	97284	256993	277210	448886	611269	618910	887203	1452498	1492972	1533547	1814755	1897674	1984535	2029945	2124690	2433060	2693440	2743956	3854313	4734829	5191756	5667933	6207241	6292140	6292143	6557369	6579307	7175214	7188093	7325050	7428184	7473679	7547019	7547021	7547024	7547094\nC	24	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nC	24	18891	66909	92095	262227	682483	1351293	1477324	1633258	1749253	1997989	1999261	2053050	2344737	2398282	2450441	2554137	2921095	2973154	3025084	3599609	3599615	4097602	4582100	5086958	5643475	5907265	6080727	6242278	6361495	6582598	6776970	6814141	7241368	7345535	7352243	7438038	7438040	7438041	7438042	7438109\nC	25	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nC	25	19779	70975	96589	219844	521034	540473	671853	682800	689391	967714	1025087	1228719	1283775	1339486	1339598	1705708	1870741	1870758	1926122	1984486	2152753	3338897	3761726	4560753	4723266	5527983	5528921	5836670	6061858	6166839	6285568	6605227	6719924	6988798	7179826	7654020	7691177	7691178	7691181	7691249\nC	26	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nC	26	21013	42321	68461	448437	614344	633576	648140	769543	864685	1139130	1140101	1197639	1467173	1525213	1702108	1702160	1761792	2163722	2223928	2389920	2449535	2514692	3706327	5350457	5449505	5549436	6013590	6157767	6198395	6198400	6652496	7024577	7214154	7421963	7432376	7616423	7699974	7699979	7699980	7700050\nC	27	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	37	39	40\nC	27	22226	44419	71308	189121	444790	1002645	1425860	1698432	2317074	2321777	2444816	2445216	2848433	2848552	2909159	3399851	3593306	3716859	3716869	4001678	4064347	4701823	5651197	6020212	6267075	6316465	6499578	6684648	6900329	6928331	7044208	7367468	7447457	7533004	7536494	7536496	7536499	7536566\nC	28	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nC	28	23047	164828	603888	756363	884190	1184976	1407273	2323424	2328376	2975826	3039836	3040205	3464427	3464522	3527155	3922221	4046480	4109331	4316323	4953610	5129412	5195568	5773683	5973544	6236469	6386131	6469952	6727202	6771494	6922537	6964690	7020018	7333596	7400277	7444356	7558349	7558352	7558356	7558357	7558428\nC	29	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nC	29	23837	216980	244979	669656	713176	976247	1795600	2093185	2097763	2183980	2410986	2492079	2652928	2653012	2812363	3189646	3675793	4013011	4168095	4305127	4403003	5246166	6020854	6035065	6618883	6620671	6835830	7026024	7433376	7675011	7679466	7771986	7774288	7778191	7783773	7877037	7877038	7877039	7877041	7877110\nC	30	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nC	30	24765	218568	247055	933227	1109335	1282658	1720085	2517870	2521887	2826220	2903779	2981233	3056984	3209031	3626408	3626438	3771979	3907770	4433102	4599234	4877036	5204923	6326791	6529005	6651970	6799248	7069612	7219241	7268643	7442684	7470903	7533551	7541544	7544866	7563907	7563911	7563912	7563913	7563917	7563981\nC	31	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	37	38	40\nC	31	25674	218969	691000	1440035	1562383	1915505	2207973	2215137	2605612	2852393	2930527	3008664	3087068	3527671	3527706	3686097	3764878	4258232	4403769	4615516	4911253	5869364	6477989	6915204	6943745	7090599	7286848	7364000	7364329	7429350	7433014	7454833	7462892	7465887	7474446	7474448	7474450	7474501\nC	32	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nC	32	28655	179975	209724	1346926	1574854	1696412	2093145	2099383	2272947	2275274	2604128	2690291	2776962	2777004	2862608	3032675	3396729	3562460	3638795	4058825	4201476	4276638	4920121	4974879	6063618	6176230	6417709	6667478	6713435	6931969	6966201	7150740	7238260	7551968	7571699	7583083	7583085	7583086	7583088	7583147\nC	33	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	38	39	40\nC	33	9556	20817	44279	734729	1685610	1794863	1948384	2116154	2122157	2286538	2287181	2544607	2710843	2710914	2795464	2879678	3269648	3438716	3602061	3951146	4025366	4241167	4496940	5861764	5861769	5958632	6039460	6364523	6405433	6554340	6634815	6817984	6855465	7111833	7311623	7535707	7535709	7535712	7535779\nC	34	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nC	34	27314	134303	670057	1966495	2120808	2208754	2507925	2512200	2515507	2690522	2691930	3051969	3139845	3228936	3317860	3318087	3903666	3989558	4072580	4370765	4370812	4826480	5001293	5596595	5950159	6188723	6199431	6505203	6535636	6541839	6735694	6906938	7051855	7112766	7127457	7140581	7140603	7140624	7140645	7142666\nC	35	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nC	35	873	10472	15276	302444	546076	549810	674348	676533	840646	842770	1288929	1289358	1380124	1380347	1470991	1563386	1656267	2068504	2251861	2533725	2846108	2904963	3100789	3674338	3691524	3695392	3935550	3988992	4201205	4506910	4654314	4718701	4835565	4856801	4888184	4914608	4914634	4914659	4914684	4915816\nC	36	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nC	36	37182	647686	997367	1549208	2200754	2466099	2593830	2768681	2771272	2774302	3258153	3258691	3355741	3454114	3554073	3654191	4290642	4290715	4470018	4594858	4744872	4937359	5226729	5907041	5953838	6036040	6384194	6603193	6651019	6658566	6843080	6993320	7120524	7136506	7151286	7156736	7156760	7156785	7156806	7158753\nC	37	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nC	37	12552	24964	73809	1174924	1809092	2244806	2379545	3302894	3305891	3307906	3810722	3810840	3908380	3908419	4007048	4106652	4106676	4671168	4862468	5120668	5206195	5298434	5377736	5450452	6219907	6276888	6447947	6722357	6928412	7100409	7229764	7249122	7387603	7405538	7420580	7463623	7484932	7484936	7484940	7485061\nC	38	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nC	38	30854	54067	89245	662712	1667778	1840783	1967298	2732375	2734116	2735193	3277845	3277918	3383543	3489477	4094917	4200212	4497095	4497104	4585452	5597576	5711082	6019482	6277109	7185751	7208640	7294848	7407957	7419052	7548354	7557626	7607626	7610231	7620984	7630658	7653700	7653704	7653705	7653707	7653710	7653788\nC	39	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nC	39	26709	47721	275168	637334	1486896	1679861	1796371	2591055	2592745	3506962	3507081	3956376	4065941	4173131	4277942	4475059	4475072	5047044	5207248	5331040	5384889	5731809	5792893	6449397	6473968	6474313	6780828	6858385	7045706	7161901	7163645	7186894	7402565	7414456	7452683	7452686	7546506	7546509	7546510	7546577\nC	40	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nC	40	25984	168606	391704	657791	1028533	1241575	1590988	2299996	2537541	3718305	3837201	4316770	4533847	4533865	4730752	4819070	4975127	5041404	5610971	6004623	6052448	6107920	6115016	6145783	6747907	6748033	7002943	7026426	7218761	7228128	7309247	7325227	7461721	7463990	7463993	7463994	7562216	7562217	7562218	7562299\nC	41	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	40\nC	41	25816	182387	220446	1857265	2168592	2182983	2538537	3303775	3725438	3726285	3844345	4340455	4449404	4553105	4741221	4741230	4809349	4969902	5658884	6060056	6098882	6179644	6183698	6206725	6788660	6802022	6808072	7261461	7355589	7365382	7505117	7529739	7618236	7623598	7633890	7633893	7633895	7633901	7633978\nC	42	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nC	42	25068	363991	1797470	2094745	2418351	2607918	3111891	3375402	3376642	3507044	3629716	4150714	4260535	4260555	4457489	4689526	4689535	4802371	5519050	5659897	5704766	6313545	6342062	6914692	6916802	6919996	6927398	7179179	7200983	7658622	7667315	7674829	7684369	7687575	7690442	7699617	7699620	7699621	7699622	7699696\nC	43	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	40\nC	43	24465	205090	935003	2231971	2505357	2643342	3022183	3025196	3295460	3429110	3555311	4099241	4211149	4411001	4411012	4573992	4641845	4705673	5405937	5555812	5634597	5867009	6450641	7013197	7013508	7016121	7016448	7194174	7512456	7530596	7532539	7542419	7735140	7745517	7748945	7748949	7748950	7748953	7749045\nC	44	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nC	44	23118	211808	801224	1140145	2385406	2397981	2765007	2919033	3178443	3179011	3306336	3866151	3981403	4089253	4364354	4364360	4438698	4554589	5251289	5445597	5487916	5687389	5697826	5705293	6434654	7183393	7482969	7483461	7484021	7545470	7560554	7564990	7566832	7568808	7680025	7686757	7686759	7686761	7686763	7686837\nC	45	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	38	39	40\nC	45	22337	516685	2373160	2429761	2817798	3134101	3234711	3528496	3670600	3671128	3923370	4499493	4694591	4850255	5036493	5112276	5207847	5254378	5858065	5918216	5957396	6071769	6615055	6615163	7188360	7199884	7417922	7647166	7702092	7803930	7810409	7810861	7812574	7812576	7812579	7812584	7812585	7812586	7812670\nC	46	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nC	46	21132	994435	1038987	2217405	2560195	2667458	3139235	3141497	3960288	4101170	4229633	4836981	4948189	5137398	5285518	5285522	5368336	6118069	6211682	6251267	6288892	6454762	6565771	6581901	7254520	7309943	7687508	7734216	7734457	7737539	7740456	7746895	7757157	7758865	7762584	7762585	7762586	7762589	7762592	7762671\nC	47	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40\nC	47	19454	561065	1560095	1777289	2086701	2610999	2616065	2919278	3065696	3198282	3320537	3942875	4132497	4211206	4279227	4419311	4553181	4636792	5289152	5320501	5333065	5382211	5382249	6709316	7280785	7367750	7412468	7782701	7783086	7783656	7784825	7784826	7784828	7786444	7789073	7789074	7789076	7789082	7789083	7789172\nC	48	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	38	39	40\nC	48	23389	250817	1775574	2191770	2506395	3428213	3856057	4163556	4164206	4309442	4561043	5392266	5392281	5392293	5528707	5585219	5694973	6491368	6491374	6608151	6610573	6704227	6706060	7311710	7312308	7358155	7569929	7788287	7788607	7790308	7793104	7796649	7798774	7798779	7798780	7798781	7798783	7798863\nC	49	2	4	5	6	7	9	10	11	12	13	15	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32\nC	49	239494	543259	808802	905742	1232208	1536684	1681337	1681374	2647767	2751193	2751511	2851746	3503929	3576012	3689352	4010965	4814043	4834188	4855167	4863565	4866440	4882108	4882636	4882837	4885015	4887156	4890946\nN	0	6	20	24\nN	0	40430	218449	487063\nN	1	1	6	20	24\nN	1	97	38736	194752	401930\nN	2	1	9	20	23\nN	2	208	38547	269762	576211\nN	3	1	5	9	20\nN	3	269	379085	545829	689943\nN	4	1	7	22\nN	4	507	37606	617645\nN	5	1	2	7	20\nN	5	453	464401	759449	910268\nN	6	1	2	10	22\nN	6	494	493943	533661	685136\nN	7	1	2	7	20\nN	7	904	512178	802770	967536\nN	8	1	2	9	20\nN	8	794	534662	572153	732299\nN	9	1	2	10	22\nN	9	914	552129	829294	991096\nN	10	1	2	7	20\nN	10	728	634228	934496	1091075\nN	11	1	10	22\nN	11	677684	1144995	1303938\nN	12	1	2	8	20\nN	12	815	580760	896090	1054499\nN	13	1	2	10	20\nN	13	689	591687	828613	984274\nN	14	1	2	10	20\nN	14	706	379399	824418	975259\nN	15	1	5	10	20\nN	15	1004	822453	956175	1113186\nN	16	1	7	10	22\nN	16	813	226572	688501	843444\nN	17	1	6	9	23\nN	17	985	283498	496640	655004\nN	18	1	8	10	23\nN	18	1060	579059	901152	1062014\nN	19	1	4	5\nN	19	1675	813261	1355784\nN	20	1	9	12	20\nN	20	1734	560616	953116	1130738\nN	21	1	7	9	24\nN	21	2112	423084	549766	733709\nN	22	1	3	6	9\nN	22	2432	192567	638545	1049225\nN	23	1	5	7	23\nN	23	2435	465426	1507200	1696625\nN	24	1	2	4	20\nN	24	2671	530111	2041546	2231649\nN	25	1	2	4	22\nN	25	2835	523798	1043384	1236923\nN	26	1	5	9	23\nN	26	3374	548845	1127164	1326676\nN	27	1	4	5	22\nN	27	3382	1270780	1938681	2137700\nN	28	1	2	5	20\nN	28	3617	603849	1415141	1615469\nN	29	1	2	6	22\nN	29	3844	595785	807680	1012936\nN	30	1	2	4	7\nN	30	4308	600895	1087687	1297014\nN	31	1	2	5	6\nN	31	4312	614180	1032599	1240124\nN	32	1	4	7\nN	32	4723	825043	1322296\nN	33	1	4	6	20\nN	33	3957	658625	1038504	1321551\nN	34	1	2	4	6\nN	34	7427	628148	865769	1173098\nN	35	1	2	4\nN	35	1188032	13714392	15074479\nN	36	1	4	5	6\nN	36	8262	631423	872975	1195012\nN	37	1	4	6	20\nN	37	5304	633705	858617	1066912\nN	38	1	4	5\nN	38	7471	867503	936193\nN	39	1	4	5	22\nN	39	7520	643802	833473	1065852\nN	40	1	2	5	6\nN	40	8299	761463	830267	1068726\nN	41	1	2	5	8\nN	41	8450	770097	1008943	1248490\nN	42	1	2	5	6\nN	42	8835	875036	987481	1231259\nN	43	1	2	4	22\nN	43	8184	792392	875628	1109581\nN	44	1	2	5	8\nN	44	7938	766573	856274	1085977\nN	45	1	2	3	5\nN	45	8198	704652	937271	1005786\nN	46	1	2	4	22\nN	46	8064	723856	793157	1021942\nN	47	1	2	4\nN	47	7680	671631	964294\nN	48	1	2	4	6\nN	48	7887	666237	728080	950854\nN	49	2\nN	49	873311"
#define QUAL_DIST_ONE75 ".	0	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	34\n.	0	150623	207501	514720	1898368	1934972	2866832	2899437	3573586	4098956	4739589	5004492	5518069	6459433	6721628	7053672	7592206	7952822	9240440	10116858	10410781	11220699	11871980	13597237	14982599	31972672	33118685	42285605	57915567	58204858	59144583	59576517\n.	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	34\n.	1	191746	267031	682094	1995946	2044325	3026373	3064845	3750394	4331826	4978420	5248454	5810911	6814658	7095220	7474605	8059664	8415771	9728406	10746428	11065618	11893789	12577483	14279268	15647810	32341240	33469779	42528824	57938772	58268337	59164168	59576517\n.	2	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	34\n.	2	383465	391119	802021	1515207	2584792	3660293	3730509	4020747	4769323	5381883	5955362	6418489	6852586	7776664	8032647	8299573	9329710	10177095	11571412	12425831	13593797	14604215	16446713	17077467	18419585	33974139	42253493	49740186	50045110	59293459	59576517\n.	3	1	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	34	35\n.	3	24088	669102	768751	2279078	2837883	3928943	3978479	4619657	4919332	5338502	6008800	6297243	7685820	7776256	8337702	9872051	10458274	10837240	12228667	13610708	14179907	14991468	15638834	16645404	17797937	19487081	35223188	58348604	58396538	59150226	59438830	59576517\n.	4	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31\n.	4	337124	374489	1033325	2477645	2530459	3563340	4183529	4459529	5086174	5818333	5848912	6679791	7534011	7989592	8115759	9232839	9980194	11717219	12552406	13161961	14084813	15001300	15966158	17154664	17791058	18960299	41908176	43428209	58967765	59576517\n.	5	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	34\n.	5	144039	397987	1103834	2483990	2614539	3679856	4040022	4288256	5070833	5174012	5781684	6505977	6779227	7886945	8420573	8704428	9884532	10812575	11576818	12605214	14000260	15141029	16349766	16679735	17835630	18804356	19107504	42074115	50708974	58857903	59576517\n.	6	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	34	35	36\n.	6	171683	208024	532926	1783051	2651048	3224371	3879679	4477649	5031798	5374941	5766363	6162693	6756096	7562062	8163816	9755286	10604897	10694599	11707037	12679112	13254465	14767815	15813187	16999725	19196401	20317638	36129606	36703074	43337700	58825086	59100128	59283641	59576517\n.	7	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	34	35	36\n.	7	243643	352018	607626	1823740	2508011	3722681	3788664	4327027	4694016	5809444	5881002	6355455	6800978	7863337	8303244	8901754	9877939	10884511	12485370	12636259	13121234	14167812	15699592	16326864	17249335	18596882	26286692	42039014	57499764	58974016	59243677	59300114	59576517\n.	8	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	34\n.	8	313232	390401	890916	2521041	2795536	3789497	3882437	4472386	4780302	5322897	6123119	6649863	7504349	8036858	8363783	9097711	10163554	11081081	11640046	12191642	14223933	14985394	15432556	16479660	17706419	18345311	19123406	43541676	50563044	59269624	59576517\n.	9	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	34	35	36\n.	9	175164	330212	695557	2153268	2746999	3832678	3928201	4202489	4738544	5356168	5991861	6325259	7681072	8008382	8445503	9033200	9311570	10696805	11344321	12079900	14002954	15240616	15974568	16639433	18496516	19112830	26438916	42429856	57683494	58370871	58979452	59286714	59576517\n.	10	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	34	35	36\n.	10	170597	395305	913484	2209926	2766030	3877378	4176654	4510542	5046501	5367411	6003951	6547791	7097797	8275256	9051039	9894241	10308443	11122032	11592169	13040389	13247437	14076240	15075007	16389583	18103988	18452579	18942753	51168803	51278211	58816520	58923805	59039475	59576517\n.	11	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	33	34	35	36\n.	11	32450	56527	617877	1933901	2526195	3928033	4251737	4554649	4847525	5558121	6078659	6510378	7224992	7900146	7979543	8956467	9817731	10881237	11285439	12378416	13099821	13741985	15374557	16097820	16155833	18124333	33914646	43072584	58059647	58454811	58723624	59112318	59294567	59576517\n.	12	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	34	35\n.	12	13137	131727	305355	695005	2472307	2863034	3409547	4024117	4603275	5415356	5723741	6728978	6936303	7463362	8306236	8683473	9271283	9349698	10076679	11118546	11957747	13112524	14664986	16179034	16433361	17568002	18732501	35226697	50552343	58557700	59396988	59576517\n.	13	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	36\n.	13	44506	80706	121045	865392	2307033	3003478	3554389	4157588	5027503	5619424	5988456	6056526	7120648	7529188	8513232	9127536	9185917	10788904	11088199	11437735	12815649	13654618	14662627	15866881	16360589	17388389	17902672	34123823	42422941	51274574	51288837	57994540	58986516	59576517\n.	14	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	34	35	36\n.	14	31192	45312	72582	365909	2114802	2715344	3063406	4242572	4338170	4917123	5248644	5856468	6902150	7815226	7912367	8776894	9584449	10259197	11263029	11841283	12248035	13181089	14771752	15738653	16301052	17509080	18651568	20349989	42856413	57762126	58321084	59242714	59307019	59576517\n.	15	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\n.	15	353982	434184	502119	1319020	2364257	3097524	3664947	3903059	4758802	5353374	5924155	6262247	6913219	7376267	7899594	8925666	9457875	10428905	10795745	12431681	13329869	13923171	14332957	15612633	16427539	17713953	25217251	33113056	34061428	43523316	57808393	58069531	58598399	58662711	59576517\n.	16	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	34	35\n.	16	28898	111497	211050	737949	1945684	3318121	3502293	4232399	4932793	5589135	6304669	6922504	7627251	7664488	8368183	9289943	10234769	10831217	11815201	12267063	13133877	15000256	16018448	17222484	18045785	19462821	21042351	27531869	34901843	51255365	58129365	58987040	59576517\n.	17	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	34	35	36\n.	17	13225	23841	75388	673817	1980860	3004664	3193583	4126357	4889018	5188962	6178910	6527110	7031716	7086123	7769093	9360074	9671445	10440869	11122120	11808319	12316729	13104510	14499510	15497802	17119514	18767531	19873660	20870286	43255891	44434976	57372413	57707872	58725341	59576517\n.	18	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\n.	18	21083	97339	174764	739479	1394430	3551090	3760432	4463583	5108304	5833960	6257052	6616997	7254958	7976930	8153142	9963153	10157322	10771417	11499758	12477550	13403622	14026311	15362583	16489747	16993690	19202850	21648060	21798969	29342132	44401515	57641845	57708841	58330631	59222116	59576517\n.	19	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\n.	19	36483	109079	528287	1503994	3363251	3683347	4378075	5149618	5612799	6440235	6861508	7226716	7582288	8879945	9737999	10319611	10779087	11695239	13017311	13795303	14868778	16226642	18425001	19596780	20854490	21542312	22952283	38071073	50488734	57773357	58061535	58751803	59237418	59576517\n.	20	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\n.	20	33572	34865	697983	2492626	3791325	3897741	5342836	5390333	5492820	6649713	6951557	7696852	8228482	9553425	9707408	11158127	11593386	12624731	14616477	15460643	15924438	17660764	18181214	20155990	20918069	22367565	23637227	42559305	43284028	57831349	58150083	59030794	59147710	59576517\n.	21	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\n.	21	16955	43355	464319	1842524	2826380	3658659	5130309	5254666	5382305	6390424	6725253	6803933	7850061	9049627	9089188	9813461	10211464	11419296	12635029	12837289	13510774	15179189	16900502	17719493	18619480	21029417	22062008	23077275	38723919	45795215	57834745	57899816	58459940	59576517\n.	22	2	3	4	5	6	7	8	9	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\n.	22	113376	147942	374253	819517	2586894	3880365	3935108	5382005	5830857	6014562	7079746	7629879	8672195	9243196	9513015	10378475	11358048	12488299	12978320	14319953	15728310	16955998	17112096	19152167	21108005	22472733	29235370	31967404	51960774	58157763	58276257	58876698	59390892	59576517\n.	23	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\n.	23	30632	43067	181267	434569	1979593	2636434	3567845	3696780	5457712	5607412	5752727	6836266	7891991	8212839	8928507	9147639	10244111	11160344	11670921	11869726	14660961	15127532	16468097	18123213	19847813	21177774	22538571	25163203	32571881	44944216	51551623	58109826	58945596	59387940	59576517\n.	24	2	3	4	5	6	7	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\n.	24	95642	109422	258264	486939	1986489	3877933	4020222	4788231	5750734	6209447	6966435	7322583	8193913	9082629	9830657	9934938	10453229	12061647	12756995	14130656	15450719	17473591	18669552	19414374	20448747	21794815	24719320	32672739	45471840	51651479	52221298	58531549	59378280	59576517\n.	25	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\n.	25	95922	136580	187199	368002	1247941	3100663	3869603	4953299	5738401	5887045	5992482	7520572	8299282	8629256	9202964	9964393	10020613	11461043	12542370	13527714	14422459	15863071	16838502	18517224	19648599	21785256	23721679	25517438	33495280	52185737	57838977	58169508	59057026	59377977	59576517\n.	26	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\n.	26	93960	186287	1548968	3227383	3977965	4156906	5210630	5926079	6072852	6956646	7677689	8183657	9456162	9929115	10806427	11393659	12302241	13910759	14696704	15656804	17277198	18843109	20991716	22158897	23695443	24919482	32436242	38933852	56726397	57032787	58739878	59361866	59576517\n.	27	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	27	3402	86248	554900	2022358	3981390	4482100	4736701	5524079	6334663	6841689	6991046	7766139	8772612	9477048	10100243	10780122	11890947	11970148	12785795	14430706	15900230	17089124	18184776	20466000	23319716	24834781	26007030	32629758	40806500	51718517	52044181	57849691	58563554	59184456	59576517\n.	28	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\n.	28	215942	237889	323616	1325384	3277534	4409500	4574342	5410197	6269268	6335201	7206132	8078295	8520234	9353339	9647969	11449972	12465443	14044546	14291738	14909145	16116960	17209495	19963313	21635217	22442576	24270235	25499790	27499802	34138684	45987340	47284773	57084578	58308527	58719045	59576517\n.	29	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\n.	29	333408	346596	1443852	3840571	4730176	4780603	5649973	6569476	7053123	7924402	8337409	8811868	9409722	10273403	12032792	12399943	12958524	13763838	14785009	16977820	18187807	20247503	21001496	22844025	23969355	26450425	28840999	34442311	42088925	47631738	56802187	57877605	59002390	59576517\n.	30	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	30	164639	195992	638860	1535179	3490198	4440895	4950449	6582105	6616737	7160438	7761751	8737634	9173261	10344698	10619080	10655647	12747304	12801655	13586062	15539736	16972274	17557334	19350003	21188555	23338746	25741138	27116414	33580123	40409273	45265891	52470548	52703431	58465736	58738137	59203156	59576517\n.	31	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\n.	31	119818	135326	353075	2305542	4026144	5001950	5206151	6002964	6886283	7008269	7940742	8782470	9049854	10174541	10582316	11672722	12629305	13356645	14085302	15867573	16984970	18624051	19861868	20465443	21409112	24224170	27354694	29361300	29830145	47252574	56285979	57206766	58041376	58824960	59576517\n.	32	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\n.	32	25341	170809	1241699	3098804	4338816	5239117	5375329	7029329	7199365	7725296	8776748	9559444	10169664	10648146	11174428	12231956	14126429	14519277	15907021	17808780	19611835	20392539	21229909	22244709	24180013	26331230	27140889	34802434	35907605	52155280	56531887	57060194	58627157	59576517\n.	33	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	33	121215	182163	1491746	3197742	5395860	5578296	5748403	7499015	7600981	7659857	9072342	9678005	10338077	11151300	11753852	12782295	15019167	15624063	16266558	17128388	18814619	20850286	23893583	26062679	26761253	27511568	29595296	35721549	49481779	51053739	52793411	58297875	58846797	59203301	59576517\n.	34	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\n.	34	29688	90714	1576106	3203873	4537438	5429473	5680837	6595891	7612085	8167557	8638922	9461049	10471143	10899536	12185931	13203493	14604358	14719417	16588232	17850122	18615191	19944214	22028816	24360725	25800877	28024540	35512931	37075452	43054029	52057953	57112879	57925670	58038749	59576517\n.	35	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	35	96052	159631	198042	1483431	3634910	4648261	5657340	5768394	6760429	7870579	8409423	8960710	9877077	11057195	11127398	12369093	14041328	14169981	14399412	15675364	17139856	18883326	19523482	20395059	24181867	26116324	27687790	28759471	32677524	39221343	51932713	57322301	58138651	58687964	59041086	59576517\n.	36	3	4	5	6	7	8	9	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	36	146231	377148	595115	3474160	4367824	6039847	6316377	8107246	9119953	9464518	9907964	11152867	12202778	12405950	14358912	15015838	15950251	16666384	18561970	19820601	21913998	22936496	23688425	25617262	29424115	32093320	39058302	42562545	48570169	50173809	57489705	58289677	59283538	59576517\n.	37	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	37	100923	130204	260138	982664	3798058	4574487	6137543	6388042	7377523	8394815	8613887	9615318	10377940	11386600	11533251	12828515	14079423	14844185	16953335	17955152	19178274	20359970	23025462	25702320	27073526	29201336	35751832	37038128	43041922	45024058	56004951	57634907	58417982	59434155	59576517\n.	38	3	4	5	6	7	8	9	10	11	12	13	14	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	38	102660	225596	470819	4056867	5324298	6588913	6756791	6894406	8900821	8980840	10017903	11104880	11448013	13097953	14581546	14655472	16241388	17755868	19223852	20555736	21409487	23432544	24904625	26797331	29035421	35398220	36887101	43907708	48541290	56557821	57769964	58824586	59312407	59576517\n.	39	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	39	103280	241233	621158	3943150	4399595	6405941	6524298	7719208	8704192	8855422	9571916	10841085	11346961	12212366	13111725	13941257	14941403	16686082	17093666	18711535	20549096	22808314	23705288	25885162	29067131	31276779	32490708	38331667	45410107	46763843	53737156	57841834	58301144	59270913	59576517\n.	40	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	40	51415	197842	606627	3065059	4676981	6677815	6893859	7074909	8993878	9243839	10447270	10820892	11791009	12540684	13451351	14672603	15591051	16787446	17372117	18463369	19583538	21920586	23572563	24676872	27264398	28963148	31619033	38526078	42693281	48003834	52365166	56577711	57923314	59430457	59576517\n.	41	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	41	109268	260430	570963	2877761	4668699	6740811	6960628	7244683	8165148	9355752	9806840	10769628	12110029	12631010	13289139	14799232	16112096	16296765	18113287	19419324	20602513	22311356	24854668	25933729	28021188	31614586	33330220	39377869	50136446	51504836	52070596	56250831	57816267	59443545	59576517\n.	42	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	42	83041	359953	665651	3357113	5064940	6123456	7295375	7586164	8714712	9772375	10468148	11030651	12073959	12489522	14202691	15080568	15584789	15935258	16797601	19307068	21194685	22390916	24755722	28701024	30877460	32220260	34360490	39426209	42099846	49044401	53070791	53725121	58133176	59302724	59576517\n.	43	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	43	176309	475070	3421281	5150616	6225851	7273713	7523355	7732201	9878423	10181120	10830011	11506426	13009977	14405260	14829663	14942509	18584074	18803047	20211143	22746506	24073200	25728930	28006803	29954494	33859859	36242431	43421476	48516053	52736062	53473269	54241587	57546765	58721443	59576517\n.	44	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	44	133192	321824	517286	4178469	5434942	7614576	7781642	7890043	9218166	10293713	10623079	11274440	11881578	13227787	13934058	15527443	16118249	17510778	19508257	20895819	22177120	24343329	26790343	28853486	31407229	34108871	38684509	43039892	48105287	52315450	54907429	55863114	58346114	59300552	59576517\n.	45	4	5	6	7	8	9	11	12	13	14	15	16	17	18	19	20	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\n.	45	195158	1160258	2939097	5395105	6739747	7973435	8423000	10437213	10629064	12017432	12704125	13672479	14372022	15321617	17111955	19094130	21741405	22401899	22675794	24115595	25732545	29232717	32115470	34289992	43144143	50412569	55324385	56556389	57251337	58548121	59576517\n.	46	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	46	1508197	3259434	5587276	5792045	8081813	8266859	8382215	10804160	11281138	11771877	12449115	14434972	15187314	16349157	17570027	18200654	20262987	21634877	22560479	23862665	25655647	30107418	32202550	36828605	39796527	42147515	48661576	52884328	54390374	55817466	57503871	58993035	59576517\n.	47	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\n.	47	124215	355558	663918	3786928	5789041	6007696	8390549	8714948	8968222	11246857	11512195	11905173	13126508	14012500	14945414	17060198	18001918	19096840	20512565	21015037	23601877	26814620	28239247	30850047	32645944	34946821	39648844	43418906	47446600	52856858	56038558	56494747	57647203	59576517\n.	48	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	48	124005	216457	713457	3337116	5964117	6188768	7453216	8795278	9187462	10440729	11725455	12154046	13253967	14153374	15243686	16493610	17624648	17929606	20237565	21538320	23276158	24452739	26734240	28821172	34095803	38106298	41759556	47268838	48549411	54224388	55464995	56390972	58081809	59265095	59576517\n.	49	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	49	136746	649975	4001176	6263138	6494744	7791691	9169095	9304969	9696903	12025417	12322991	13721146	14626359	15570305	16815522	18582859	19354923	20815613	22351624	24218070	25820021	27863357	29695316	32219212	37777291	40341102	44012164	46506701	51922672	52848573	56133541	58257439	59445477	59576517\n.	50	5	6	7	9	10	11	12	13	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	50	497704	3805899	6462310	8033247	9458373	9602093	9750577	12426264	14045959	14503257	16574570	17438894	18365149	18733661	20773253	23114783	23865724	27095843	28264182	31558511	34275364	39666544	43065057	44818855	50473158	51292919	53187241	55828903	58000467	59312489	59576517\n.	51	3	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	51	124940	663954	2246269	6319031	6553163	9371215	9632957	9786345	10084015	12676321	13008956	13844683	14836569	15835688	17198336	19017977	20110320	22760386	24289632	25427204	26614074	28155035	31520905	35302617	38023020	42694372	45708051	49024271	52861698	54189297	55126631	56815246	59188363	59576517\n.	52	4	5	6	7	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\n.	52	332996	886625	3839042	6753556	8460638	9663282	9943150	10110823	13097207	13274222	13791038	14832077	16219213	17279585	19160121	21496206	21869781	23089437	25415796	28269319	30917027	33586072	36290660	39580171	41168928	43766899	49929854	51183014	52893339	54385615	56733161	59576517\n.	53	5	6	7	9	10	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	53	602491	3681348	7177691	7446996	10496529	10985577	13754475	14102813	14285703	15899608	17114222	18900269	20301649	20911226	21983875	25246176	26685182	29022140	31009212	33228904	35561437	40657092	43729384	46135393	50090610	53278446	54542358	55775904	56849319	58901403	59576517\n.	54	3	5	6	7	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	54	149362	2310586	4752447	7488252	8987077	9324567	11075541	12747196	13821815	14965096	15526206	17206486	18541275	20303921	22836609	24258686	27318939	30652356	35422452	37850974	39971509	43489666	45199088	46640823	48083706	49136615	51798285	53864625	55060430	58035663	58578303	59290424	59576517\n.	55	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\n.	55	139509	1044095	3990363	7674150	7969904	8648115	11461466	11652401	12023178	13551414	15074107	15483406	16979739	18546358	19988551	21160094	22303467	23539901	25806368	26616739	29408330	31425225	32703941	37528989	43040274	44928178	49245096	50522543	53173706	54597025	56763817	58467752	59576517\n.	56	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	56	139527	826397	4046866	7827606	8136916	8439867	11353084	11702018	12096466	13455767	15394980	15803975	17510331	17734970	19134989	20990542	22732312	23354628	27951273	28539581	30073031	31418775	34191214	37859419	41312229	43860190	46577640	49444741	52519549	54631313	55728432	57778751	59016702	59576517\n.	57	4	5	6	7	8	9	10	11	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	57	329131	892890	3375663	6846208	8279171	8588682	8988763	12181063	12970966	15810463	16024133	17792035	18987270	20431181	21633664	23487573	24996138	27941047	28324374	30819050	34483985	37047635	39472127	41681645	44396554	47246988	51686424	53391177	55377456	57707850	58627817	59426972	59576517\n.	58	4	5	6	7	8	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	58	147924	936274	3984948	7085579	8569356	10666844	12372955	12590214	13202739	16323668	16549005	17586345	19824689	20874880	21839978	23057282	26739916	27141111	27725753	31865480	34038779	38585451	41774843	44082736	46619884	50295013	51168478	54417810	56410978	57868022	58757115	59411915	59576517\n.	59	4	5	6	7	8	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	59	366629	1006928	4875135	7326480	9123018	9899922	13034674	13263978	13496362	15856044	17317735	18375667	19878248	20953704	22465471	24904022	25888212	28069927	30701403	32937224	34258570	37468238	41018996	42785446	46079250	49566409	52481329	54294898	55715305	57255672	58146206	59308381	59576517\n.	60	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	60	396997	2622139	5729025	6164930	9627492	10095354	10455491	13930093	14175526	14422861	16594601	18371098	19687102	20436789	21260076	22587082	25735151	26525108	29282292	29655908	33557943	36022627	39422584	41483394	43975359	46410633	49543433	51215565	51960718	53108077	55904168	57950214	59270524	59576517\n.	61	2	5	6	7	8	10	11	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	61	229118	2707638	4742935	7952792	9895529	12210762	14329141	16133305	18144147	18903011	19519458	20526705	23248154	23472510	26658810	28537243	31026739	32229020	34861901	37423639	40038553	44509574	46923335	49312325	52413121	53403752	54660777	56769922	57480384	58486417	59447532	59576517\n.	62	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	62	435559	1217476	4571435	6462110	10128262	10635798	11024230	14716941	14981193	15515289	16242230	19443658	20225585	21630110	22837458	25558676	27426116	28372201	29508860	31056403	34452400	38813250	40638854	42922665	46376841	48429367	51674424	53070851	54268589	54782036	56076764	57617034	59441078	59576517\n.	63	2	4	5	6	7	8	9	10	11	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\n.	63	185010	371970	1499165	4456518	6805413	9277120	10604174	11134987	15360490	15635313	16953440	18865517	20515886	22236619	23709223	25269703	25772921	28501350	30698845	32451021	36053392	40121680	42790234	44159854	46621280	49634724	52420996	54177107	55208553	56700429	57716382	59032362	59576517\n.	64	4	5	6	7	8	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\n.	64	496548	1376921	6455634	6970117	10891177	11863136	15495412	15776626	16350779	17138064	20759071	21056892	23057863	23948760	26207558	28950945	29919652	32957490	33996345	36882368	40365962	42700688	45669446	48492717	50033585	51227896	53840200	55722768	56747851	57073366	58287697	59576517\n.	65	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\n.	65	190849	1418994	6662242	8427655	9822071	11230855	11786275	15946556	16232296	16821792	17128166	21040393	21620946	23126589	25142610	26027010	28854865	32060041	33462003	35266327	39116911	39866283	43131808	45574471	48359377	49929839	52219546	53825508	55469191	56672548	57814612	59143660	59576517\n.	66	3	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\n.	66	202881	4126286	5679229	9437834	10353560	11802963	14016614	16677122	16977153	18680889	19282939	22839241	24274374	24575536	27185890	29417873	29620444	32889348	34659934	36912250	40332369	41894306	43405578	44390399	47876242	49643445	51331444	52561769	54645297	56141747	56885438	58351025	59576517\n.	67	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	67	205421	3274483	5768097	9078000	10602020	12089866	14340340	15443649	17380794	18004885	19715723	20901471	23656542	25055110	27675739	29784836	31553712	32403050	34465806	38625755	42835904	44699531	47396546	49047447	50118699	51506281	53652305	54473689	55676890	56560417	57648950	58736123	59283585	59576517\n.	68	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	68	574876	2902374	7388079	9316592	10900499	12424362	14710700	17520990	17835528	18145172	20524898	23897580	24218554	26003070	27210958	30624824	31136746	33565828	37921145	40182874	42464220	44675386	46620433	48861053	51574177	52913225	54885307	55311911	55754200	56650329	57726396	58891296	59452650	59576517\n.	69	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\n.	69	1288711	3579524	6257833	9787022	11462284	13024389	15358256	16564061	18592799	19252114	21314548	25075010	25388966	26287594	29449047	30923515	32013302	36512538	37198174	41720245	44874498	47570064	49787222	51734290	52952157	54579405	56283894	57000121	57347323	57673136	58450551	59299491	59576517\n.	70	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\n.	70	659479	3706357	7250067	10752419	11856617	13464940	15822997	17073844	19144051	21547404	21889840	25060184	26567262	27624271	30234767	32228776	33715538	38279580	40522526	44254554	46442924	47640219	48970230	51150428	53320117	54392059	55535474	56461564	57712982	58418002	58965736	59421102	59576517\n.	71	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\n.	71	291910	739025	4848497	8440859	11202422	11879594	14001012	16377032	18005079	20120989	20793714	23499968	26443063	27884453	29671663	32548617	35210803	37318191	42005997	43337822	44631406	47600250	49838233	51580045	53123642	54138396	56112405	56485400	57104849	57479083	57928440	58558369	59507240	59576517\n.	72	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35\n.	72	1559449	4076866	8781530	10895701	12798957	14493304	16896879	18583352	20413135	22848911	23503226	27041503	28276188	31435882	33281379	36280725	38716745	42306462	44332217	46954561	49122350	52434462	52972719	54199580	56134098	56479368	57650505	58306915	58548666	59032264	59498914	59576517\n.	73	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\n.	73	294260	1661672	4646471	9161382	11342445	13300522	15033650	17490270	19224225	21798883	23559787	24876540	28479741	30788463	34116106	34763648	38424835	40855612	44542723	46602019	47591949	50295899	53055052	54510560	55617364	56467765	56927893	58172100	58361918	58733028	58960607	59289590	59431951	59576517\n.	74	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\n.	74	354714	909423	4581483	9163649	11383173	12646888	15190847	17703068	18712537	23229898	24470369	24771987	29474572	31326627	36176501	38026655	40874433	41568382	42680724	44147006	46236351	48686999	50111286	51909249	53180555	55290798	56316065	57423661	58193446	58455884	58707127	59101578	59435067	59576517\nA	0	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	34\nA	0	10809	25183	92911	378227	387796	605483	613841	769646	904933	1057790	1114736	1256067	1525099	1629311	1751860	1922149	1987805	2295857	2601972	2723751	2955983	3161809	3767036	4321773	9682370	9990319	12208627	17185666	17256380	17627675	17757644\nA	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	34\nA	1	9292	26939	135728	462667	475117	740815	750024	938729	1109457	1300504	1371573	1547708	1880651	1992447	2133070	2341624	2446281	2879866	3220165	3351934	3647486	3904441	4541810	5079115	10342936	10711793	12937765	17735923	17849018	18195224	18332609\nA	2	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	34\nA	2	70373	72023	157055	308023	507818	761293	779354	836473	1037900	1200053	1355780	1444372	1528601	1861349	1920032	1979459	2303838	2544806	3016486	3279728	3667013	3932172	4588127	4807097	5261349	10023830	12234859	14497214	14579795	16697640	16785071\nA	3	1	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	34	35\nA	3	7198	135309	160490	531626	609871	880885	893715	1058850	1127144	1225629	1383986	1474532	1891410	1919110	2056845	2523271	2713806	2862212	3312031	3811987	4011925	4293473	4515388	4916351	5312342	5865735	10627367	16918707	16938153	17172465	17259743	17303074\nA	4	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31\nA	4	63503	72270	231786	537917	550745	811877	973755	1002842	1172909	1364508	1372804	1602126	1871958	1986116	2028172	2414777	2655825	3237274	3506978	3703414	4044162	4361376	4713123	5102114	5322995	5704435	12805705	13339641	17439522	17634773\nA	5	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	34\nA	5	31047	53263	189453	504403	538787	791011	873441	941174	1129100	1158235	1342192	1502676	1565934	1909030	2047283	2120870	2471504	2756940	2975396	3333080	3789961	4186827	4599159	4701656	5091560	5387251	5486083	12524521	14514419	16988787	17219609\nA	6	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	34	35	36\nA	6	38808	47756	128275	481162	702587	863414	1074211	1262851	1444810	1561525	1685309	1818422	2030958	2326556	2552155	3176045	3513950	3549373	3899329	4301171	4542050	5168310	5525135	6008731	6795604	7231446	12142706	12320851	14587459	18567117	18647776	18726970	18820783\nA	7	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	34	35	36\nA	7	34122	59690	121314	438843	629563	920879	938434	1094023	1200395	1542936	1563202	1711032	1857444	2218245	2364384	2577550	2938047	3321361	3872090	3931344	4119943	4519692	5105924	5348351	5668874	6165701	8699995	13550870	17544260	18035660	18112325	18135653	18215817\nA	8	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	34\nA	8	30827	49610	164526	517444	542963	773083	797238	940848	1009444	1147340	1369049	1488169	1741133	1896566	1983103	2188974	2528232	2791609	2956605	3091515	3787379	4019170	4150283	4498417	4858278	5071201	5336245	12650586	14707717	16692787	16795998\nA	9	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	34	35	36\nA	9	18572	50124	137076	548007	653953	963598	989082	1068613	1234875	1423891	1625657	1732913	2197476	2310759	2468827	2681283	2779405	3309860	3510465	3801411	4549362	5046947	5348640	5608235	6240925	6465817	8934933	13842841	17796951	18037491	18241118	18368525	18458327\nA	10	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	34	35	36\nA	10	17597	29754	147256	423200	535586	795881	859868	952327	1066369	1159086	1329492	1453850	1605737	1934797	2155453	2398033	2550412	2785141	2893178	3387930	3470373	3741541	4074004	4540957	5090346	5203421	5388368	14609771	14640289	16884533	16914700	16962277	17113090\nA	11	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	33	34	35	36\nA	11	8157	13656	98024	395122	507101	821025	890377	974504	1037284	1245583	1355831	1489279	1644460	1867563	1893686	2169464	2453009	2751594	2835029	3204249	3444554	3662271	4236611	4490411	4514397	5184037	9957622	12797483	16639710	16765939	16842119	16957313	17018759	17101899\nA	12	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	34	35\nA	12	2857	9278	52604	151368	568788	622487	744478	918500	1054177	1264156	1359823	1626876	1690343	1847433	2124495	2257577	2453066	2480333	2709886	3070291	3324737	3701155	4210493	4744386	4828495	5223526	5622566	10722977	14768481	17129876	17391032	17464908\nA	13	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	36\nA	13	9541	18532	28145	157217	438489	589380	704020	863721	1071177	1223556	1313938	1333918	1623987	1735284	2043062	2190412	2211780	2733206	2796471	2886026	3363127	3640077	3998928	4407899	4580449	4931141	5125062	10088474	12615541	14721107	14726378	16666797	16972764	17154068\nA	14	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	34	35	36\nA	14	6888	10473	17184	82174	453866	579628	621006	899655	926312	1068773	1145982	1303858	1605844	1808369	1840855	2107908	2394533	2571991	2848194	3010347	3159887	3494505	4099391	4449321	4643774	5028512	5417322	5965281	12761658	16555219	16762885	17040371	17066852	17142009\nA	15	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nA	15	51788	71719	89215	284252	537064	703204	825394	865602	1053790	1209900	1362502	1445133	1630531	1788436	1912627	2244154	2410101	2739546	2828162	3379032	3676875	3853318	3997102	4443631	4757111	5155197	7430310	9859581	10182879	13075754	16677598	16749702	16911006	16937528	17224062\nA	16	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	34	35\nA	16	6034	25494	26300	148889	452671	708939	730519	925096	1083631	1248882	1437818	1600799	1797989	1809005	1990273	2271721	2553553	2745465	3016662	3183743	3505512	4147158	4493717	4939196	5209378	5707454	6265067	8180316	10395714	14726762	16700118	16953129	17168950\nA	17	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	34	35	36\nA	17	3167	5211	17710	161998	505264	794297	844995	1048212	1279759	1367173	1679197	1793646	1955036	1973035	2201428	2754601	2867650	3148129	3344780	3600838	3802369	4104978	4651621	5028370	5651377	6252015	6696641	7016154	13107818	13490068	17316009	17427222	17844896	18093430\nA	18	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nA	18	4670	8032	27010	169844	293259	764854	795895	992347	1133641	1323985	1452069	1537858	1716393	1923670	1981125	2497473	2567761	2791988	3033876	3378903	3680591	3915162	4361352	4765170	4943226	5712092	6511781	6573781	8820652	12777331	16635033	16663119	16855255	17157538	17267176\nA	19	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nA	19	8472	26492	133322	374591	837447	861406	1055281	1251542	1387149	1577803	1705431	1819671	1915020	2292961	2582043	2784510	2938660	3223806	3686886	3952111	4340085	4841212	5642980	6073042	6533548	6788091	7262718	11743074	14903079	16985201	17101914	17335075	17520711	17626454\nA	20	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nA	20	6942	7117	127953	573955	951747	981074	1410694	1423341	1453220	1821325	1912552	2153162	2332480	2798455	2853196	3360917	3523700	3887308	4655218	4990703	5164739	5832571	6045027	6795206	7050616	7562361	8006109	13087728	13352266	17612323	17741196	18008571	18055210	18196082\nA	21	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nA	21	4112	9715	112019	434848	632351	832861	1174492	1209865	1246648	1501667	1598732	1621328	1922704	2248482	2259544	2494620	2612874	2991803	3368946	3447355	3647419	4240362	4829420	5129505	5453699	6319826	6655999	7009781	11626172	13631379	16661901	16690412	16892174	17250230\nA	22	2	3	4	5	6	7	8	9	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nA	22	4662	11987	41435	147885	512106	819857	833885	1190340	1316247	1368787	1639064	1811900	2087030	2225929	2321688	2605435	2899175	3257968	3425075	3911992	4384648	4800176	4864025	5576526	6223116	6698094	8689429	9633308	14966813	16654193	16699551	16882270	17062439	17135975\nA	23	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nA	23	6534	8988	41042	100881	544541	715092	970522	1003458	1466533	1509546	1553752	1890457	2241514	2355815	2594566	2670685	3062616	3402594	3548339	3624513	4679464	4851535	5387201	6007241	6675220	7205518	7683137	8640460	10789120	14389471	16256023	17663600	17949196	18135222	18209849\nA	24	2	3	4	5	6	7	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nA	24	297	2890	21810	78510	496986	963675	1002949	1221696	1478443	1618466	1855950	1970642	2258656	2559241	2824830	2864579	3061706	3642396	3908265	4443666	4976315	5770472	6229317	6535212	6953960	7468467	8477428	10817753	13974343	15907026	16093467	17785520	18115765	18192831\nA	25	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nA	25	608	10015	20516	62524	274209	739456	919640	1169214	1353061	1394299	1425163	1825932	2079258	2160188	2356828	2566542	2585039	3102522	3452156	3793051	4108405	4577563	4936630	5524235	5925192	6661632	7336344	7954962	10269014	15169824	16666415	16790873	17077096	17189176	17266166\nA	26	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nA	26	21495	43078	321873	709713	876774	925267	1154837	1312285	1353266	1618234	1783604	1918191	2304035	2444074	2746508	2889049	3194933	3725251	3998007	4353118	4927609	5486473	6263086	6665786	7211599	7595859	9731707	11651969	16111718	16228943	16738404	16950610	17034116\nA	27	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	27	427	18549	134229	514984	1011846	1056198	1107270	1338925	1542674	1697065	1743544	1969171	2251934	2468340	2683177	2882080	3279993	3309358	3577472	4159332	4714109	5146222	5553980	6377939	7420566	7905429	8322380	10178493	12591378	15233826	15364737	16923951	17200921	17408740	17539736\nA	28	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nA	28	9559	13773	34716	247949	717795	916938	962388	1191031	1382030	1402208	1630484	1863681	1999499	2233082	2335185	2848592	3154161	3679301	3777810	4006354	4434618	4837455	5777365	6386045	6682719	7313435	7725196	8407043	10241077	13203745	13619106	16196655	16573846	16724677	16958113\nA	29	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nA	29	45402	48245	289541	822379	1038007	1052219	1294994	1527055	1666925	1910554	2014723	2147307	2340635	2601840	3158611	3265358	3439098	3729873	4064840	4826578	5269447	6018928	6311248	6941695	7335501	8190547	8974122	10458454	12727371	14322202	16251626	16600632	17005087	17159422\nA	30	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	30	14802	21967	111396	314698	878828	1161289	1244880	1733339	1742175	1906498	2088736	2408399	2548783	2944036	3041301	3051628	3784636	3806116	4093142	4807439	5342816	5566136	6243219	6941761	7767624	8617440	9119656	10595681	12430078	13826622	15969580	16026591	17478819	17583614	17729679	17844997\nA	31	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nA	31	5227	8673	42602	457329	917034	1151055	1206046	1435418	1648269	1683318	1940459	2179519	2262428	2575513	2709103	3028014	3358712	3596292	3861673	4475981	4840305	5454960	5887194	6104158	6431803	7382677	8428001	9151143	9300501	13795632	16201104	16472164	16729292	17017186	17260122\nA	32	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nA	32	5151	36829	306800	776552	1045982	1319654	1358698	1846355	1895342	2048939	2376088	2635139	2831640	2993971	3166966	3538697	4203197	4353104	4857062	5588410	6274749	6581630	6860443	7266291	7973479	8714398	8990774	11206984	11539538	15889537	16971687	17138075	17726471	18029541\nA	33	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	33	6294	18997	336373	772869	1259176	1310137	1337716	1785262	1813522	1831564	2226904	2389067	2597462	2824439	3002039	3305252	4031098	4226711	4447503	4749437	5342856	6061950	7150619	7930573	8175085	8430210	9169437	10813711	14244028	14809420	15342866	16761282	16957673	17061750	17178028\nA	34	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nA	34	6320	19590	334433	721506	990283	1184518	1254434	1506940	1730141	1893701	1997822	2191373	2503147	2607658	2992841	3282468	3741068	3784534	4392893	4823000	5078179	5558525	6286568	7098823	7609375	8369008	10438226	10987807	12707450	14745343	16178997	16424604	16464588	16961245\nA	35	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	35	812	14551	22276	334691	778048	1009365	1238790	1267235	1543507	1807536	1965816	2104999	2357842	2696944	2722029	3106304	3617868	3661059	3746809	4197392	4622461	5230949	5471382	5796939	7115840	7762851	8279963	8668158	9992151	11677233	14841318	16209254	16470752	16668542	16799583	16973100\nA	36	3	4	5	6	7	8	9	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	36	10885	46420	96135	914581	1150114	1539088	1614953	2142918	2447287	2547038	2682159	3073692	3412118	3475707	4137329	4367019	4705904	4951929	5627564	6087509	6854047	7233090	7515361	8204326	9497657	10413336	12370353	12996150	14748109	15228295	17071383	17350274	17686723	17797718\nA	37	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	37	975	7548	36342	199566	890220	1090834	1407357	1452941	1729154	1977783	2040922	2312417	2546226	2822040	2869425	3270868	3639882	3887725	4604197	4967195	5399178	5808797	6771282	7725771	8207006	8947854	10739064	11189265	12914139	13567614	16089883	16580573	16848175	17156436	17207698\nA	38	3	4	5	6	7	8	9	10	11	12	13	14	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	38	1181	27915	83768	1094115	1377020	1753459	1802446	1837656	2427488	2451503	2759459	3095252	3205244	3718103	4201756	4222913	4755017	5271677	5795248	6254873	6568098	7301501	7842944	8517231	9258359	10988187	11520295	13600246	14604833	16650522	17016997	17380876	17521323	17611852\nA	39	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	39	1342	31435	116473	881345	920863	1379118	1406990	1737561	1953936	1995630	2204651	2557365	2684706	2928409	3190337	3458890	3744552	4322902	4463848	5006052	5634414	6425431	6750417	7487370	8564634	9333383	9730403	11284076	13430959	13864300	15417516	16363095	16534170	16846383	16957264\nA	40	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	40	11535	42909	100073	643585	994346	1481402	1535079	1588828	2067973	2138751	2463900	2581914	2836339	3059934	3324305	3709225	4003418	4404688	4591699	4954113	5347163	6154455	6766218	7171100	8059132	8658273	9546083	11439851	12640340	14175476	15223415	16163095	16630927	17103749	17154810\nA	41	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	41	1744	35884	107527	631189	985626	1428250	1462314	1544791	1800243	2065599	2162509	2445379	2825668	2958925	3170046	3632832	4001777	4054308	4673916	5106057	5487942	6089409	6994991	7380861	8078442	9272209	9836436	11432241	14194580	14658211	14808412	15798396	16286502	16781197	16824634\nA	42	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	42	1966	40840	112687	703484	1055342	1330559	1587766	1671272	1985210	2225742	2428623	2566503	2851001	2983519	3482400	3761716	3936169	4036664	4282641	5138732	5773559	6185114	7000696	8370774	9114946	9589612	10272445	11547832	12412354	14072901	15205596	15422951	16523168	16816392	16910778\nA	43	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	43	17884	85607	795859	1278736	1566525	1897906	1959431	2021578	2660072	2747953	2946295	3155723	3623637	4084531	4227386	4267170	5527901	5598654	6102419	6989377	7476411	8064833	8922224	9595090	10910031	11665813	13302893	14747774	15894558	16138150	16393324	17115382	17429615	17706628\nA	44	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	44	2231	45919	87609	824047	1152017	1689734	1728535	1759294	2142882	2389483	2486721	2686468	2843254	3237404	3443198	3926617	4122915	4537235	5239902	5725719	6159682	6907442	7758849	8460192	9371103	10269262	11350140	12403109	13842760	14880624	15554974	15841144	16604062	16845096	16936466\nA	45	4	5	6	7	8	9	11	12	13	14	15	16	17	18	19	20	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nA	45	45516	241210	595932	1100734	1461328	1723494	1855721	2358625	2406286	2793950	2971343	3284658	3503610	3775167	4294176	4974319	5876200	6089450	6176345	6685631	7245578	8391148	9350188	10013253	12175969	14035522	15507486	15915263	16117300	16509334	16802170\nA	46	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	46	307000	612814	1151391	1208478	1749537	1792305	1825746	2433662	2576098	2685558	2881990	3441256	3680671	4056981	4453854	4650678	5299815	5755651	6072205	6532631	7151483	8679023	9376849	10562979	11492635	12235105	13571640	14764529	15247635	15685018	16191971	16606712	16806162\nA	47	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nA	47	2898	56816	108367	845761	1213462	1275002	1837286	1919354	1995295	2553316	2635134	2753758	3070971	3340304	3609035	4221533	4539051	4860919	5351237	5527883	6419224	7486007	7977412	8826736	9436216	10165862	11424891	12645117	13709594	14884187	15735217	15876810	16230753	16756556\nA	48	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	48	3246	26160	136226	628086	1227000	1289928	1626040	1906165	2022844	2380739	2660217	2799443	3089444	3323904	3678326	4048710	4409901	4521744	5244906	5674496	6266504	6647871	7431176	8153012	9895972	10870842	12064952	13372671	13694919	15146551	15532337	15798979	16328664	16620787	16720985\nA	49	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	49	3656	121313	738625	1279050	1344049	1689372	1977893	2017810	2128781	2719734	2814372	3196391	3435664	3738299	4116192	4652440	4929448	5368800	5876474	6498414	7059636	7771246	8397025	9258721	10749845	11328708	12502729	13288183	14688118	14925474	15697258	16342707	16694682	16733045\nA	50	5	6	7	9	10	11	12	13	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	50	94483	754671	1376169	1800186	2114575	2157046	2203602	2897219	3360601	3493797	4093676	4370708	4645013	4775710	5421061	6218759	6465525	7570767	7979718	9071158	10001192	11455634	12329198	12905417	14395290	14630644	15159020	15722464	16374320	16753408	16829586\nA	51	3	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	51	4501	134334	462969	1338573	1389916	2081404	2143704	2189822	2279839	2944940	3052414	3266808	3564157	3848233	4255657	4807681	5176642	6010028	6524269	6912219	7309342	7857591	8999583	9946719	10852129	12330101	13161931	14000994	14994391	15326458	15615039	16079550	16552191	16670021\nA	52	4	5	6	7	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nA	52	82838	184949	745394	1483527	1955579	2221340	2288975	2339724	3143491	3201904	3361109	3696480	4058608	4395587	4959338	5695515	5818856	6233652	7025001	7997538	8891909	9794051	10688641	11479861	11935145	12582856	14217016	14608942	15130628	15530178	16150612	16768572\nA	53	5	6	7	9	10	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	53	126570	786493	1566877	1643285	2396187	2547511	3276759	3379587	3442181	3912559	4275188	4809681	5248496	5450124	5817490	6887363	7394207	8183464	8879430	9631991	10346591	11667080	12638193	13340025	14373233	15226894	15560435	15738772	15984507	16436481	16624911\nA	54	3	5	6	7	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	54	5958	462215	1049910	1618465	2036606	2132857	2526356	3024582	3351264	3598154	3770264	4265567	4699835	5204402	6033082	6498671	7415749	8340718	9579084	10306907	10922524	11781366	12342339	12834107	13306428	13655268	14332515	14797289	15183615	16022197	16200144	16394710	16477759\nA	55	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nA	55	6640	199222	847299	1701516	1767917	1956998	2658124	2716987	2825534	3288702	3650969	3783259	4214718	4697163	5125794	5519757	5866064	6261782	7031748	7289379	8252826	8953614	9412321	10704915	12314776	12909551	14038005	14433788	15032844	15464443	16023648	16460004	16723341\nA	56	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	56	7097	160305	904672	1822174	1892930	1979285	2746476	2834972	2962498	3298451	3884718	4012551	4509052	4583471	5036176	5598040	6161624	6372013	7922615	8119467	8627233	9108073	9703816	10960704	12073222	12722579	13576882	14263405	15051035	15679422	15999015	16408084	16721288	16868489\nA	57	4	5	6	7	8	9	10	11	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	57	56777	174029	664978	1533621	1931861	2020797	2136626	2964977	3202977	3979438	4038507	4558539	4915402	5378489	5737645	6343453	6827783	7791937	7916349	8777111	10020434	10869408	11418839	11970607	12838676	13689747	14621087	15090179	15656885	16256967	16495077	16749515	16791686\nA	58	4	5	6	7	8	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	58	8382	185451	800815	1646751	2062682	2601898	3080196	3148403	3341035	4206577	4270067	4563628	5247717	5582008	5871371	6258510	7457437	7590445	7783959	9208713	9923349	11158785	12061273	12850096	13556535	14469754	14726834	15477772	16078210	16440418	16674089	16821986	16877227\nA	59	4	5	6	7	8	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	59	66618	203522	1054221	1650449	2153068	2380642	3199042	3271764	3347547	4052588	4422339	4727061	5206415	5546099	6003029	6773608	7088981	7833341	8700857	9467327	9905336	10683357	11731427	12326281	13314131	14111960	14966473	15400796	15759190	16216923	16454040	16745036	16815097\nA	60	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	60	72508	659699	1368801	1482616	2588551	2725973	2829411	3864622	3944763	4027163	4668297	5221864	5644303	5878488	6136450	6557676	7588304	7853594	8782690	8906322	10236383	10835825	11889259	12568083	13288328	14050182	14808853	15305916	15517351	15873888	16489167	16961647	17273733	17343296\nA	61	2	5	6	7	8	10	11	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	61	10965	667050	1058694	2107541	2672582	3401794	4018368	4580321	5185611	5427489	5625112	5951361	6824958	6900145	7926411	8581713	9409469	9822116	10730956	11336233	12208264	13498789	14202914	14858733	15588466	15870377	16256389	16762495	16925595	17153552	17390311	17422889\nA	62	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	62	82721	250875	1179089	1557727	2783230	2932734	3044719	4201904	4287219	4449730	4680616	5686472	5938680	6375583	6788812	7679898	8289183	8604667	8993499	9515473	10643787	11924086	12403792	13139126	14136823	14825290	15657519	16068705	16354478	16478268	16731716	17115809	17507805	17542705\nA	63	2	4	5	6	7	8	9	10	11	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nA	63	15987	29481	296146	1042157	1647002	2528807	2949417	3110167	4449296	4539497	4943549	5532831	6083244	6656350	7134409	7648462	7815142	8705793	9446925	10045996	11287841	12356797	13207982	13630206	14371561	15059895	15912390	16264423	16596455	16891856	17132857	17408689	17563508\nA	64	4	5	6	7	8	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nA	64	96071	291611	1549940	1690127	3019471	3310354	4458023	4548391	4724681	4975171	6121154	6212106	6847500	7149478	7914759	8808127	9123498	10168225	10510815	11460177	12420126	13124692	14084031	14894047	15293421	15611000	16162188	16580836	16837998	16909148	17197462	17498807\nA	65	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nA	65	15929	303861	1583761	2272196	2646817	3090281	3258901	4549426	4641034	4822371	4913945	6141277	6326927	6792199	7477170	7767030	8714069	9745514	10238358	10870230	11921507	12129374	13108805	13877178	14723743	15257441	15720234	16107003	16534810	16813223	17061384	17361587	17451091\nA	66	3	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nA	66	16329	937465	1259701	2519377	2764612	3220259	3946266	4712641	4807646	5357017	5542065	6632718	7102802	7197478	8031197	8754764	8817433	9936173	10515864	11070562	12199470	12723067	13134811	13425055	14451358	14819204	15270729	15602864	16125630	16472366	16621607	16965149	17307443\nA	67	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	67	18367	835293	1318613	2488397	2903392	3375876	4118084	4431419	5010453	5201783	5753504	6123971	6968401	7430593	8282911	8952262	9521087	9786301	10551158	11892874	13102504	13732604	14522773	14903047	15179470	15464878	15987845	16193490	16450292	16632553	16873836	17126321	17235756	17311052\nA	68	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	68	122312	732298	1779720	2542226	2974272	3454167	4200343	5010058	5108742	5207752	5951416	6980528	7079472	7657841	8023505	9128906	9294746	10060835	11476927	12084107	12837706	13510648	14068353	14745822	15478037	15823990	16227709	16322088	16440571	16601438	16869173	17148671	17242077	17272747\nA	69	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nA	69	263640	905624	1424686	2662357	3124719	3612470	4358229	4704258	5302147	5504148	6141733	7284266	7382663	7671807	8666731	9135179	9486504	10963310	11179901	12447807	13478213	14264347	14934488	15489172	15796071	16127110	16448004	16568505	16629706	16688912	16874119	17045182	17103237\nA	70	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nA	70	141259	943928	1805556	2939167	3243003	3747700	4492221	4850281	5461171	6193149	6297417	7255303	7725282	8055465	8889080	9517463	10016162	11457281	12202862	13192220	13831355	14212190	14612590	15229395	15638393	15894687	16138657	16326446	16638036	16814296	16918472	17017171	17071932\nA	71	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nA	71	25302	148169	1119550	2030302	3009035	3180405	3842190	4547719	5023918	5647260	5852416	6636068	7520143	7967680	8510795	9410168	10277232	10931327	12321873	12722594	13089457	13992897	14659733	15097499	15440759	15686189	16134136	16206508	16313378	16384879	16478903	16605470	16798177	16810899\nA	72	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35\nA	72	318997	1036145	2130492	2922256	3451156	3981845	4681293	5177726	5715103	6419376	6620532	7694268	8063942	9029591	9616149	10572382	11324461	12499725	12955750	13702328	14269435	15249405	15376499	15685001	16072996	16139381	16348090	16472945	16531573	16631581	16708398	16719299\nA	73	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nA	73	30441	338928	1059023	2225872	3027206	3574770	4115207	4825253	5332706	6094683	6592846	6986727	8070595	8831999	9855532	10063080	11170870	11927583	13018937	13611361	13892896	14586543	15331637	15712483	15934168	16144852	16226263	16419509	16451313	16514832	16560104	16612594	16636160	16665304\nA	74	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nA	74	31912	185962	1140909	2235707	3034679	3416781	4178270	4893687	5205000	6506120	6878588	6970972	8429156	9002140	10465107	11022021	11934966	12106932	12487982	12788720	13439028	14081929	14494107	14879843	15137163	15595186	15845619	16090024	16286002	16325426	16373177	16441600	16488632	16514427\nT	0	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	34\nT	0	12108	26983	91413	430494	440878	654407	663818	816777	939520	1078604	1141461	1257721	1459828	1512531	1588131	1705242	1774850	2018831	2186903	2246924	2399861	2524556	2867983	3160410	8576017	8808375	11091001	15167281	15222842	15416619	15505898\nT	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	34\nT	1	10077	31001	132954	433024	446704	673498	684671	833501	969889	1104787	1162810	1291404	1513191	1577712	1671960	1802861	1865951	2115972	2309049	2383103	2548901	2689891	3057448	3373528	8155573	8388963	10492690	14185429	14250036	14454901	14543760\nT	2	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	34\nT	2	79463	81841	170168	332308	625536	918369	939594	1018151	1222763	1393315	1551911	1679685	1800745	2052242	2125840	2202705	2483447	2715568	3073152	3305479	3620013	3894386	4384487	4554341	4912411	9603711	11872793	14101552	14184921	16823351	16900333\nT	3	1	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	34	35\nT	3	6889	144400	171963	518972	608078	862703	877539	1033565	1097149	1187004	1338267	1413397	1745325	1773819	1897958	2251611	2391835	2488328	2798437	3132311	3268482	3465984	3621616	3869718	4158836	4581490	9196773	15762586	15775774	15962756	16039630	16070092\nT	4	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31\nT	4	68699	79361	253509	594426	609678	882685	1049963	1085080	1255240	1446987	1456205	1680041	1912470	2030492	2068618	2369382	2566636	3025472	3242929	3403006	3650067	3889186	4150884	4463829	4638781	4949203	11509511	11924169	16366228	16535950\nT	5	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	34\nT	5	36858	63981	225199	577992	615156	888448	980005	1046451	1245586	1276571	1440146	1621596	1691192	1983122	2121467	2195040	2497427	2736484	2918083	3183828	3544297	3821126	4133296	4222191	4522239	4772610	4853050	11255538	13575936	15897618	16086070\nT	6	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	34	35	36\nT	6	41938	52536	135055	441896	602512	754016	905125	1051213	1184503	1266209	1372612	1480098	1631939	1812736	1953842	2336463	2538488	2564639	2779901	3015393	3158315	3532045	3767971	4069648	4652738	4935403	9555922	9712643	11697620	16125121	16201453	16247149	16326791\nT	7	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	34	35	36\nT	7	40937	72952	138409	448449	614918	872386	892005	1025709	1116770	1397429	1417588	1525696	1649818	1915132	2014809	2166713	2420740	2671004	3028137	3071326	3189023	3452792	3852645	4005216	4253985	4587885	6751129	11389847	15878411	16276960	16352787	16367886	16445143\nT	8	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	34\nT	8	38302	60145	197964	623598	654284	913707	940811	1098703	1178566	1322837	1539132	1672363	1904768	2047013	2135357	2328881	2611621	2850294	2982706	3114972	3658171	3853508	3964649	4258428	4591084	4769316	4986618	11839952	13937333	16391613	16476126\nT	9	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	34	35	36\nT	9	25455	71036	172368	538268	649870	927433	955388	1031870	1154665	1328450	1482270	1574169	1915116	1996659	2116552	2268151	2334791	2669712	2798186	2979720	3463701	3762653	3940249	4102974	4602904	4756717	6728070	11492710	15868257	16051614	16215538	16291516	16370146\nT	10	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	34	35	36\nT	10	24756	41753	187433	527996	668126	965737	1040980	1136771	1271126	1361996	1534722	1673485	1822330	2132096	2335020	2550654	2664439	2872188	2969558	3348896	3405783	3615223	3871025	4225743	4674566	4769637	4900689	13892579	13918174	16161820	16186882	16217281	16367138\nT	11	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	33	34	35	36\nT	11	8706	15905	117476	451346	577823	928206	1004347	1086157	1154951	1346183	1465245	1582216	1747605	1925231	1947341	2185522	2400962	2659020	2725603	2999806	3179691	3339855	3758790	3950318	3965455	4461959	8938569	11619035	15942946	16050596	16124928	16226909	16270969	16347779\nT	12	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	34	35\nT	12	4159	12228	56754	158530	624555	687724	823606	989664	1136514	1343861	1426389	1682313	1742896	1877707	2094887	2193560	2345356	2366784	2549689	2812558	3004994	3291253	3657030	4044467	4108831	4394813	4705309	9205919	13665627	16046382	16265749	16314423\nT	13	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	36\nT	13	13579	23733	35208	187294	531657	710491	847376	1009550	1230750	1385030	1482026	1500603	1772688	1879759	2136457	2284561	2300709	2706325	2765880	2848680	3194399	3398468	3650738	3950952	4074293	4338461	4473356	8879954	11335924	13788735	13792086	15816282	16078412	16236957\nT	14	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	34	35	36\nT	14	9200	12972	20156	100464	597392	787121	838702	1189446	1216082	1389061	1496066	1677657	1978382	2285222	2311668	2555872	2769707	2990664	3242899	3428344	3535869	3789949	4202142	4462116	4619086	4982557	5287553	5746201	12572099	16926865	17073546	17339196	17356816	17432523\nT	15	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nT	15	61043	82273	100404	339352	631171	846897	1016646	1055970	1243128	1412557	1573722	1674704	1862081	1982694	2143573	2429377	2580508	2848060	2940118	3396461	3655424	3836836	3956507	4309191	4520100	4900944	7237362	9568887	9826945	12615899	16822845	16896655	17048688	17065796	17312295\nT	16	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	34	35\nT	16	8463	31646	33007	165075	466125	730313	754716	949432	1095584	1248219	1419617	1562982	1733402	1743057	1900204	2123599	2346122	2487004	2691981	2804020	3023205	3474729	3721099	4016701	4204885	4564669	4953343	6723048	9024411	13804755	15877814	16111859	16253495\nT	17	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	34	35	36\nT	17	3653	6916	21411	175851	477285	701634	753781	949874	1113278	1192362	1417162	1490115	1624324	1637746	1800524	2166249	2232473	2416399	2550723	2712244	2820190	3009997	3346301	3588411	3974355	4394089	4636302	4900376	11640349	11943880	15689147	15776015	16000642	16233332\nT	18	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nT	18	6491	10235	30761	172200	320205	795718	828265	1015666	1157174	1334971	1446475	1527810	1681805	1855204	1904194	2330533	2377757	2534151	2708377	2947882	3164454	3313966	3631814	3904620	4021893	4589356	5207871	5247357	7604693	12033244	15775466	15789355	15955862	16152215	16250169\nT	19	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nT	19	10417	29467	135715	339183	771815	797758	982074	1138059	1261733	1411341	1521783	1615934	1687924	1973594	2195269	2343259	2449117	2643101	2957071	3126340	3382824	3695377	4239775	4531508	4846608	5009530	5356131	9994756	13581361	15738831	15808876	15984313	16097453	16193531\nT	20	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nT	20	10658	10925	144076	540102	855365	884784	1239097	1251809	1279892	1552133	1635298	1818773	1944054	2251728	2289667	2657224	2759866	2985306	3452886	3652778	3770298	4195480	4319049	4810858	5012406	5380764	5707665	11396838	11578266	15930872	16007420	16251408	16279001	16398897\nT	21	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nT	21	4529	12370	118052	480779	669751	859482	1190649	1225151	1259650	1492710	1578913	1598886	1852341	2129097	2139248	2321287	2411980	2689439	2965540	3017259	3148016	3545153	3958097	4153951	4370855	4950181	5218528	5483439	10249993	12329498	15679268	15692277	15812693	16113359\nT	22	2	3	4	5	6	7	8	9	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nT	22	5764	16309	49152	163094	571104	891631	906564	1269026	1388840	1436302	1694259	1839992	2092711	2226665	2291755	2514708	2748132	3021565	3139106	3472254	3786387	4075573	4113006	4608292	5106477	5446010	7218135	7930187	14097397	15976743	16007462	16174533	16293146	16342440\nT	23	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nT	23	9509	13466	53276	114553	472439	646082	821274	856454	1220005	1258714	1298245	1553395	1781506	1845980	2027302	2084682	2338541	2523143	2624294	2671317	3288034	3398869	3696996	4093231	4511705	4820125	5161009	5798258	8158586	11826110	13792229	15749151	15959498	16057637	16107291\nT	24	2	3	4	5	6	7	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nT	24	614	4946	27849	92770	455740	861149	901206	1100251	1291866	1409310	1585978	1661500	1865747	2077911	2240821	2263759	2378239	2755651	2922056	3224073	3518458	3978323	4255765	4436250	4668787	5001201	5738705	8239416	12156541	13805630	13967250	15880460	16077391	16130787\nT	25	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nT	25	1266	11973	28025	79444	274758	817096	1036474	1278876	1503382	1543527	1570452	1999021	2200493	2298010	2445103	2660965	2673707	3026908	3316698	3570214	3798635	4159457	4404288	4842074	5140307	5699419	6215414	6677588	9218292	14845371	16580880	16669597	16898561	16988140	17041708\nT	26	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nT	26	27773	52789	361258	756197	921213	971020	1194041	1349063	1388136	1611473	1766132	1882641	2190506	2298145	2507574	2635269	2850449	3215309	3397628	3625652	4004083	4370643	4884455	5150892	5509767	5834140	8234437	9907728	15350675	15433440	15907156	16056816	16114118\nT	27	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	27	644	25571	145245	460326	906972	955201	1007074	1207434	1370033	1498614	1537412	1708501	1929384	2088624	2236072	2378596	2646361	2663284	2839794	3208959	3559427	3824408	4081326	4629178	5290359	5693768	5993663	8162330	10668508	13846582	13931301	15701880	15862784	16036119	16135442\nT	28	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nT	28	14518	21156	43569	265478	739737	939171	985259	1200324	1380189	1398651	1599316	1801527	1910061	2099492	2173437	2577095	2808587	3173152	3229302	3373899	3652379	3912504	4544028	4940827	5131914	5571134	5898333	6391811	8598170	12267054	12597673	15468928	15818160	15909697	16171764\nT	29	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nT	29	60782	64614	312341	835884	1029918	1042967	1266428	1465527	1585837	1789525	1876734	1976830	2122659	2319561	2729368	2807308	2931261	3123033	3349760	3844577	4133669	4604555	4771792	5230025	5496741	6117046	6738563	8685479	11064954	12518554	15366947	15670223	15927465	16105976\nT	30	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	30	22035	30795	120512	322623	776392	976605	1057477	1425979	1435032	1572855	1723259	1925783	2031086	2283874	2353453	2362258	2824448	2835855	3022909	3457139	3780405	3914968	4318426	4740979	5226385	5816421	6155169	8033168	10320818	11668144	13906072	13980102	15764913	15822924	15960877	16060609\nT	31	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nT	31	8192	12529	53120	450890	872215	1083993	1140932	1345018	1529316	1563000	1779535	1973590	2040300	2290479	2391892	2635504	2867923	3032481	3203984	3615304	3849423	4239047	4519379	4642527	4863623	5571338	6348266	6836912	6976053	12603815	15214556	15477014	15718093	15887402	16088952\nT	32	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nT	32	8009	48531	337584	725325	1007768	1197458	1235607	1627799	1672785	1808566	2058789	2221573	2375876	2478499	2607482	2842814	3289535	3389185	3706004	4127240	4537473	4717887	4931606	5162505	5629985	6168412	6370764	8858576	9189002	14095402	15449767	15605969	15964738	16224310\nT	33	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	33	9248	27776	323875	715429	1167509	1217501	1244667	1642122	1667766	1682091	2012092	2143523	2305411	2489002	2622355	2852263	3367458	3501004	3647898	3851322	4222136	4724416	5448463	5961359	6125982	6308379	6804002	8962369	13293905	13667634	14138018	15842765	15973753	16074190	16176020\nT	34	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nT	34	9301	28492	394869	812411	1116999	1318745	1387365	1634820	1866905	2012928	2117727	2288164	2545567	2645770	2954377	3191104	3524608	3554872	3999440	4298866	4480808	4791660	5270597	5861631	6209301	6766383	9282270	9677604	11687172	14398188	15841511	16084697	16113849	16520225\nT	35	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	35	1618	21848	33106	365291	826610	1063494	1293716	1323471	1578340	1831455	1964104	2084607	2300625	2582392	2597431	2892597	3282568	3309390	3369899	3660089	3988765	4391412	4521141	4733928	5646450	6158533	6542479	6794615	7771102	10113880	14148546	15749006	15990163	16121975	16204917	16351062\nT	36	3	4	5	6	7	8	9	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	36	13649	63290	127417	833083	1067697	1365404	1440861	1854323	2088989	2174649	2283551	2567783	2811579	2853869	3309304	3448297	3668062	3833215	4259988	4551859	5020766	5256840	5415526	5881672	6816570	7517844	9928540	10974898	13057019	13495638	15766687	15972763	16217797	16297798\nT	37	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	37	2192	10280	50185	258867	1097021	1317266	1700387	1749995	2022862	2304135	2360768	2626790	2818318	3095874	3126388	3457856	3785091	3969332	4481408	4707632	5008649	5290483	5926490	6572433	6910637	7418448	9742464	10069737	12149636	12705402	15993704	16477078	16684501	16961870	17002037\nT	38	3	4	5	6	7	8	9	10	11	12	13	14	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	38	2443	41589	106135	942074	1202440	1479015	1525972	1561781	2032722	2052153	2292695	2552811	2633991	3023517	3364732	3379361	3755030	4095076	4444372	4743854	4936870	5409612	5725061	6172379	6750222	9023739	9383069	11741620	13117034	15524155	15880718	16166828	16306049	16384637\nT	39	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	39	2882	47068	155918	1147934	1219440	1776663	1808175	2134217	2414855	2451502	2637031	2968538	3106601	3333484	3575401	3784407	4046471	4477502	4564511	4955777	5423942	5960391	6174394	6698543	7500031	8066273	8377813	10596803	12965823	13359391	15445410	16727461	16847149	17075464	17161744\nT	40	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	40	16038	60076	126384	749452	1067829	1536625	1593623	1643511	2080314	2140932	2416810	2503708	2714289	2887632	3099940	3376200	3588804	3868010	4000313	4245188	4491607	5017554	5403145	5646947	6296440	6706090	7346572	9837030	11029358	12993066	14348204	15510925	15872595	16286739	16329762\nT	41	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	41	3289	51779	133615	748023	1146337	1617480	1656111	1733247	1965569	2233033	2331328	2567779	2876173	2991036	3151780	3503108	3795610	3830164	4251752	4531811	4801442	5176236	5776413	6032136	6529922	7419852	7876559	10138542	13643314	14008143	14190100	15459896	15900649	16347099	16387764\nT	42	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	42	2925	59826	142425	895618	1345390	1629151	1953147	2032451	2319422	2603606	2777057	2922078	3183524	3277266	3708359	3915017	4031167	4123176	4343795	4919992	5365765	5634663	6199640	7168587	7687277	7992295	8571374	10596696	11293576	13809953	15008119	15155694	16497383	16877684	16945711\nT	43	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	43	20825	111450	841771	1196409	1477510	1700309	1764574	1821803	2321719	2395258	2556446	2700866	3027359	3352957	3448463	3469739	4310223	4350526	4634866	5217517	5517845	5917597	6450869	6900834	7873265	8566219	11185984	13168036	14415817	14625154	14800351	15850881	16215279	16429642\nT	44	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	44	4571	65189	117048	1111138	1493777	2110778	2153028	2180351	2530577	2833851	2912740	3073125	3241139	3573303	3760182	4144216	4286892	4653079	5122240	5407717	5719557	6225327	6850511	7388915	7996216	8682168	9959983	11840090	13855595	15083478	15862862	16130573	16846957	17142815	17212021\nT	45	4	5	6	7	8	9	11	12	13	14	15	16	17	18	19	20	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nT	45	62392	284768	754187	1298248	1651310	1935788	2052023	2531038	2573804	2898504	3056284	3280302	3441289	3649548	4075092	4526190	5123983	5276269	5322785	5646377	6015260	6876943	7597217	8185282	11277090	13969307	15306048	15665540	15862966	16243572	16552337\nT	46	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	46	399912	783381	1356782	1413629	1979423	2025779	2054485	2645754	2757884	2866606	3031614	3484263	3669958	3930319	4218658	4354541	4847353	5149418	5351868	5654693	6084639	7160346	7686601	9584571	10383511	11024135	12979194	14710656	15127858	15530440	16035867	16498248	16652502\nT	47	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nT	47	6190	81671	146806	1006529	1401711	1462144	2046953	2127125	2195897	2738555	2798302	2888071	3170701	3383984	3588865	4072750	4284178	4527671	4863729	4967209	5546106	6292003	6626203	7287987	7723093	8324198	10284300	11320555	13087010	14658609	15619152	15753603	16094757	16711355\nT	48	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	48	6774	35481	179737	808144	1451379	1513803	1843698	2143624	2246181	2555484	2832891	2931378	3182938	3377477	3626138	3909134	4160891	4217434	4741723	5028946	5406207	5654487	6192088	6654251	8029385	9786574	10786783	12913931	13326494	14962003	15314982	15596894	16058492	16453821	16551881\nT	49	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	49	7226	162436	1067619	1742050	1806410	2162933	2545451	2577990	2677500	3297980	3368906	3712813	3930982	4146458	4451743	4862534	5045310	5399386	5751925	6157172	6522208	7011376	7447785	8087551	10283704	10953526	11954039	12656878	14809585	15108612	16128898	16756311	17125645	17169867\nT	50	5	6	7	9	10	11	12	13	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	50	125410	963346	1625881	2039357	2359546	2393847	2427064	3064604	3437816	3537936	3996757	4204785	4396354	4477915	4953111	5481570	5627435	6388870	6652750	7481075	8151164	10270980	11196337	11694920	13906125	14151641	14737259	15571194	16199871	16616925	16705389\nT	51	3	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	51	9270	170414	661309	1740244	1806486	2591966	2653295	2689788	2770629	3454944	3533541	3742972	3977882	4211701	4561446	4977129	5230344	5907985	6248581	6509714	6786492	7140450	7981649	9639273	10378548	11662023	12553091	13463345	15169794	15620745	15922226	16436605	17188104	17312252\nT	52	4	5	6	7	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nT	52	110647	242910	1013553	1898066	2365822	2729146	2793795	2833297	3641419	3678231	3790858	4029243	4406340	4642309	5150432	5720787	5787084	6078430	6656219	7339844	7995754	8663225	9365060	10949721	11435718	12151739	14539126	14916170	15456448	15957785	16684495	17591754\nT	53	5	6	7	9	10	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	53	158467	1009564	1945592	2020909	2802507	2927419	3606360	3685405	3722812	4109412	4366846	4759414	5105552	5259528	5485751	6265217	6591856	7138737	7631725	8185987	8824152	10862771	11746874	12472914	14209624	15204047	15628333	15989291	16343799	16958005	17166408\nT	54	3	5	6	7	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	54	12696	558287	1317346	2080221	2480413	2567048	3049604	3476793	3724748	4052103	4175011	4589162	4874268	5332878	5884302	6220632	7032942	7946283	9276942	9889954	10482108	12075705	12537148	12928340	13345088	13654900	14987791	15617760	15998503	16876718	17036991	17286735	17382877\nT	55	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nT	55	14022	262042	1060897	1996300	2078382	2264710	2952871	2996129	3102314	3471717	3810504	3908155	4264392	4598002	4922070	5176640	5428067	5706812	6226730	6394158	7046996	7523049	7837592	9785182	11293662	11822589	13626466	14012135	14854692	15298600	15972470	16508970	16917760\nT	56	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	56	15145	213937	1081298	2021271	2106141	2190483	2899398	2976954	3062976	3366440	3841768	3919478	4309104	4365401	4658410	5046408	5464611	5582245	6679309	6797044	7134520	7479045	8870666	9823648	10796962	11516998	12317767	13720604	14669815	15360715	15700231	16330520	16747187	16936332\nT	57	4	5	6	7	8	9	10	11	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	57	78096	240380	969986	1932415	2321064	2407699	2509334	3368998	3555152	4298802	4338018	4778812	5050660	5357014	5637345	6078968	6443050	7147095	7228915	7855000	8773427	9481016	10796965	11420624	12213869	13112471	14975204	15528032	16159756	16925596	17213332	17484873	17536215\nT	58	4	5	6	7	8	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	58	18535	253791	1062304	1943138	2344652	2929504	3357209	3405723	3556337	4350989	4392646	4638304	5161343	5410148	5633688	5931058	6804348	6914664	7043714	8080382	8623824	10496542	11391872	12052934	12855440	14490172	14774941	15759213	16425054	16905432	17200393	17473936	17516546\nT	59	4	5	6	7	8	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	59	91448	278938	1314065	1926673	2410411	2615399	3377286	3428776	3478213	4043317	4371265	4592749	4933798	5185339	5483846	6055355	6284450	6796191	7407608	7965138	8309837	9805773	10807321	11344721	12312673	13899427	14791951	15341526	15831350	16284630	16575586	16992351	17086343\nT	60	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	60	103056	764954	1460433	1592336	2450486	2569425	2670379	3466936	3520066	3572093	4049428	4469309	4758005	4898511	5089537	5367235	6090471	6258057	6921066	7014255	7969779	9213352	10177670	10778234	11494698	12234403	13704560	14231025	14544674	14908608	15768412	16481868	16930697	17035070\nT	61	2	5	6	7	8	10	11	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	61	25906	756825	1172286	1932236	2450185	2968989	3477123	3847429	4344471	4495394	4622905	4835545	5438255	5487087	6189526	6641810	7226879	7534504	8182241	9460790	10213599	11530022	12275920	13026753	14516315	14824390	15224476	15888596	16131381	16496880	16838539	16884455\nT	62	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	62	118880	360685	1278617	1666656	2553515	2681358	2790094	3616112	3673265	3781871	3958585	4667769	4825324	5143288	5394562	5990414	6424479	6657119	6925586	7319036	8178993	9874506	10413365	11071000	12165419	12820712	14269887	14725559	15194460	15392047	15780789	16311268	16945256	16993058\nT	63	2	4	5	6	7	8	9	10	11	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nT	63	19620	52510	409885	1158581	1720170	2276797	2620987	2752605	3709557	3769113	4061305	4514867	4842387	5206825	5534183	5880816	6006613	6639977	7160583	7622898	8535181	10177705	10974944	11431276	12288983	13721609	14560933	15093431	15419856	15936723	16279768	16744788	16937547\nT	64	4	5	6	7	8	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nT	64	135126	410058	1651475	1803159	2744988	2998989	3804236	3867495	3985299	4178204	4976208	5031365	5479816	5669480	6159178	6805355	7050285	7779643	8091996	8855577	10298285	10958374	11863030	12814415	13385555	13805497	15005484	15617341	15978507	16101164	16526373	17034659\nT	65	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nT	65	36339	429867	1700065	2058161	2450571	2815807	2950316	3892089	3955113	4076890	4136118	5025383	5141120	5485096	5910018	6103125	6748482	7544428	7909253	8397324	9903286	10175486	11095935	11892773	12792902	13295501	14401555	14941964	15490715	15920783	16321302	16808077	16972054\nT	66	3	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nT	66	41976	1096863	1462236	2331939	2586464	2961083	3417133	4075134	4144618	4490548	4617516	5440191	5746765	5806819	6402773	6932418	6990877	7769837	8232384	9321640	10200978	10689293	11187546	11552409	12711350	13662457	14252913	14670601	15384225	15849989	16106385	16618501	17008830\nT	67	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	67	44489	980780	1516223	2241081	2671949	3058759	3519702	3790324	4265798	4398017	4744348	5022539	5646330	5955915	6539063	7044825	7478170	7718565	8220886	9327473	10926685	11499109	12400549	12982421	13379462	14192744	14879649	15201442	15622356	15971401	16364133	16760809	16968137	17072105\nT	68	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	68	176651	849882	1933250	2308218	2756673	3154116	3619349	4317116	4389907	4459991	4940653	5735277	5799614	6200774	6489199	7287555	7416241	8069563	9214258	10229611	10851914	11582326	12244726	12959826	13897307	14384766	15381996	15561435	15725073	16053082	16385377	16812717	16978900	17022438\nT	69	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nT	69	402241	1109737	1707135	2490275	2966274	3373612	3863082	4164042	4662457	4808102	5236118	6117863	6186946	6409611	7151523	7490459	7778399	8941293	9151939	10775975	11747949	12723076	13445505	14091153	14516343	15131405	16019313	16298818	16432198	16537461	16800548	17145109	17244774\nT	70	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nT	70	213456	1157258	2024453	2761449	3071876	3492512	3987312	4300614	4813019	5327393	5400304	6168686	6515724	6779647	7386979	7864161	8266677	9447621	10114642	11580477	12326073	12730578	13188514	13991716	15038007	15433480	15846123	16204445	16660985	16883387	17062043	17220052	17261744\nT	71	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nT	71	63705	225979	1421297	2298957	2924998	3103085	3677756	4198283	4604140	5126163	5280741	5868552	6579526	6925318	7354762	8076572	8743307	9339974	10982003	11404252	11819762	12740616	13526641	14163858	14735220	15118109	16078309	16254236	16527310	16684478	16853253	17072657	17378924	17402868\nT	72	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35\nT	72	529083	1325965	2431308	2867488	3414816	3858256	4397022	4823199	5274413	5825033	5984162	6866944	7135276	7905556	8389596	9204437	9872640	10904002	11848644	12730811	13448561	14520701	14785850	15235998	15980635	16155243	16765042	17064987	17153679	17308563	17536650	17577925\nT	73	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nT	73	77666	555601	1365262	2541401	2989913	3551699	4007178	4547645	4988387	5617038	5999595	6300124	7200129	7759104	8548752	8722551	9708177	10373565	11794059	12478320	12859527	13871514	14843401	15326489	15777577	16130962	16341808	17060715	17140698	17251724	17322165	17447480	17494131	17563439\nT	74	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nT	74	88482	296546	1461023	2561280	3027730	3408290	4079622	4637368	4916762	5967058	6302282	6386312	7499683	7954620	9118646	9618075	10365831	10613212	10923420	11731015	12373875	13269287	13724438	14410277	14855255	15807593	16245563	16675047	16974616	17055957	17134676	17262255	17432115	17496123\nG	0	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	34\nG	0	14543	26003	82982	516557	523979	807701	814237	1041327	1197698	1426625	1523163	1679457	1978556	2037049	2107539	2265908	2437295	2980235	3194243	3255691	3554734	3772667	4225838	4479020	7602288	7985370	11016211	15614937	15735994	15916952	16038446\nG	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	34\nG	1	9101	22953	93432	407104	415152	649959	656384	836742	970536	1145859	1222151	1355206	1594750	1649188	1718302	1847201	1960082	2328335	2507827	2565124	2774181	2931388	3298915	3545737	7000459	7288183	10519682	14999710	15085973	15258632	15357204\nG	2	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	34\nG	2	45419	46682	92948	187606	383911	573357	585173	640862	765335	867829	964800	1056583	1141016	1270047	1315644	1364351	1526712	1668106	1858831	1994870	2172206	2354369	2612855	2700679	2900838	6046978	8099036	9727606	9783527	12377973	12420683\nG	3	1	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	34	35\nG	3	4569	96293	113337	354236	414437	593635	601661	704758	752535	808985	913060	961042	1175895	1188534	1275282	1503690	1590418	1641674	1827857	2021948	2102050	2213934	2306222	2440102	2602723	2853292	6168268	11787091	11791725	11908650	11953893	11975250\nG	4	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31\nG	4	40900	48449	165471	415791	425854	627010	745239	770548	889248	1036976	1042514	1202048	1350725	1450891	1469869	1650498	1787404	2094012	2252270	2370263	2507426	2670907	2807467	3023330	3116815	3329621	8590352	8812473	13075698	13171629\nG	5	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	34\nG	5	24608	46908	165340	464048	485864	715079	795858	843166	1018846	1034758	1144819	1322577	1388023	1595731	1718275	1780786	2028306	2219783	2364207	2548587	2820121	2977061	3191307	3244973	3448522	3645554	3694155	9079525	11745677	13536329	13663726\nG	6	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	34	35	36\nG	6	24800	30895	80899	277437	390139	487518	591570	687606	775272	826977	890362	950669	1041705	1161124	1249292	1480873	1600601	1610334	1732567	1871308	1947108	2161360	2307648	2475875	2806315	2974303	6224619	6321340	7869305	12111333	12160052	12185651	12233568\nG	7	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	34	35	36\nG	7	24533	44763	85997	301736	431615	631082	641613	742181	809875	1012291	1026914	1118236	1187734	1372105	1456312	1555605	1705969	1867172	2107448	2123527	2201388	2364178	2583530	2686500	2824351	3059434	4975235	8127449	12236520	12467429	12513644	12518946	12565520\nG	8	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	34\nG	8	29167	42816	129242	502174	524312	747296	765114	891561	964915	1081374	1245225	1381028	1547208	1658364	1730311	1891843	2103918	2310792	2406887	2567773	2930498	3101525	3214094	3376577	3626910	3729139	3844002	9563680	11139389	13750538	13799390\nG	9	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	34	35	36\nG	9	15355	42483	102383	366293	445971	643415	661426	709814	808949	912011	1028144	1085517	1314715	1371042	1436622	1530318	1578220	1803135	1880200	1993301	2282206	2480496	2596893	2701673	2987297	3090913	5013243	8175934	12308891	12410296	12504093	12546270	12593918\nG	10	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	34	35	36\nG	10	15539	31406	116084	382952	532316	782064	860353	917933	1064370	1121678	1257314	1403368	1521274	1789837	1965488	2168126	2228569	2424932	2527621	2802088	2825758	3005400	3210935	3408042	3746184	3801343	3866601	12102830	12136723	13787560	13820747	13832449	13930833\nG	11	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	33	34	35	36\nG	11	4811	9533	75350	312316	399591	653817	717446	766615	822608	940665	1044407	1114018	1252846	1355672	1368514	1540574	1677036	1869416	1912986	2082492	2198566	2302399	2547675	2651616	2657554	2973453	6466423	8248541	12319457	12382836	12430642	12502019	12532970	12580988\nG	12	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	34	35\nG	12	2696	7305	32611	95840	491798	538031	679872	787844	932534	1119179	1172473	1411143	1444076	1555456	1713145	1774539	1885983	1899145	2054406	2251730	2405740	2658403	2981666	3242524	3296180	3510177	3684708	7724338	11761709	13487287	13654029	13671996\nG	13	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	36\nG	13	9924	16254	23192	132713	415399	584966	728691	846549	1053865	1183451	1270409	1284274	1522313	1613651	1804856	1978421	1986754	2311336	2371204	2470920	2730480	2918055	3106639	3344954	3443687	3632867	3702897	7701707	9398710	12073823	12076732	13589262	13776428	13879897\nG	14	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	34	35	36\nG	14	6129	8681	12734	61609	341246	448281	482774	688956	707374	806673	863035	968608	1138572	1301366	1317770	1456304	1576381	1692413	1823649	1924563	1981777	2123585	2341130	2480705	2570782	2774629	2942443	3210105	7994075	12053224	12128640	12293636	12300198	12349537\nG	15	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nG	15	53564	68582	84778	222807	405006	546122	659851	684910	807281	917474	1021727	1087788	1202611	1280361	1385765	1552712	1643496	1795545	1847799	2112127	2264278	2374746	2442367	2646752	2755311	2999408	4387586	6359101	6512860	8352024	12334646	12384397	12484240	12490648	12641212\nG	16	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	34	35\nG	16	6335	24010	24780	114295	331203	546814	565834	702319	831928	952897	1081353	1193553	1317563	1324472	1451094	1611771	1775186	1878574	2050689	2120385	2248461	2557000	2727688	2913712	3063109	3275768	3531169	5266178	6641699	10887041	12450880	12605412	12705609\nG	17	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	34	35	36\nG	17	2225	4102	14277	116615	339184	533881	570310	712711	861212	915283	1094267	1159004	1245104	1256442	1375768	1656633	1714392	1843220	1923890	2036855	2131843	2251174	2475419	2628347	2895233	3134491	3333480	3497437	8882340	9100303	12335173	12387685	12592294	12747742\nG	18	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nG	18	4542	6948	19999	115443	253017	716705	744134	871900	1047705	1208410	1283935	1377701	1520842	1679154	1704442	2126934	2160692	2252485	2396355	2566920	2764677	2872780	3146313	3351794	3463965	3801160	4252992	4268268	5662583	9769314	13262154	13273646	13378316	13623366	13683482\nG	19	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nG	19	7215	19209	87007	237943	574162	602800	723499	866578	947242	1081205	1151849	1212646	1277989	1508177	1638200	1727554	1807533	1979616	2186974	2297830	2458603	2690317	3013329	3183702	3372611	3488265	3750357	6685731	10608590	12261137	12300770	12405219	12498590	12557676\nG	20	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nG	20	7160	7318	83506	393672	630561	648123	910754	921331	941610	1156506	1204474	1333719	1432169	1668539	1696503	1925415	1999655	2167239	2509509	2661247	2723701	2991681	3081584	3373240	3492006	3734295	3933706	9081287	9223090	12367739	12412984	12565714	12591514	12659449\nG	21	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nG	21	2985	8605	81688	385831	590833	805790	1135211	1156742	1181627	1432864	1496794	1512181	1739155	2046029	2053875	2178922	2277386	2490352	2780414	2806267	2951011	3236134	3553431	3693847	3845620	4272508	4442162	4587708	7776975	9478865	13605658	13616417	13769691	13952172\nG	22	2	3	4	5	6	7	8	9	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nG	22	3506	10737	33422	108065	469845	752268	764806	1075767	1153234	1193924	1436043	1523784	1763820	1918056	1970427	2104365	2320409	2552139	2653883	2845298	3123181	3379216	3399825	3774988	4130495	4382311	6358642	6757886	11772725	13287197	13302030	13418553	13553492	13573449\nG	23	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nG	23	6931	9427	39328	74043	342890	459509	606274	633936	919474	954141	978908	1158025	1337552	1393542	1509774	1543871	1715701	1873475	1934677	1966863	2376914	2443002	2657637	2907308	3154339	3353835	3564902	4003438	5347694	8334822	9926903	12246555	12380300	12465157	12485431\nG	24	2	3	4	5	6	7	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nG	24	365	3108	18022	63009	346620	680103	705689	848646	1024458	1108987	1247889	1318915	1481345	1639333	1783059	1804254	1899967	2167323	2273270	2511450	2728438	3046400	3241107	3345111	3514813	3743613	4239151	5653286	9308778	11017391	11110726	12662354	12815751	12838089\nG	25	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nG	25	666	7114	17958	55454	173354	534173	691104	855551	1019435	1049315	1074310	1370325	1493049	1561137	1652828	1806174	1817422	2039287	2230932	2390911	2547091	2792237	2943446	3229594	3420986	3762109	4074109	4360586	5784542	11089053	12537091	12577572	12742148	12808500	12831146\nG	26	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nG	26	19555	34893	300931	649058	853702	887375	1068023	1267942	1296323	1463246	1667709	1798118	2056929	2174202	2325958	2498493	2674612	3030590	3182135	3325695	3624345	3905815	4274990	4535218	4847076	5094464	6469545	8383057	13393425	13429315	13749501	13869130	13893065\nG	27	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	27	368	17405	96651	326518	674677	723989	759597	898284	1038126	1123702	1154195	1284395	1457914	1574106	1686079	1808832	1976383	1992723	2135869	2410828	2606974	2805753	2967321	3316059	3776841	4027822	4224271	5432714	7104393	10727304	10762471	12217138	12356780	12452673	12513164\nG	28	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nG	28	9995	13785	27393	169945	544965	748735	779363	929178	1105028	1114935	1276672	1436556	1509361	1662168	1715697	2040507	2232356	2497044	2538951	2627931	2815156	2978371	3442097	3714365	3839208	4170067	4383069	4709142	5918630	9309517	9564877	12342817	12565671	12647929	12833119\nG	29	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nG	29	46226	48506	212396	702598	926844	939345	1091089	1323505	1412323	1588537	1697877	1820089	1923391	2105947	2446095	2542073	2670803	2793582	3011291	3421848	3615662	3988086	4123965	4493055	4681308	5131416	5563619	6587109	8109524	9774387	12989719	13167993	13387867	13517307\nG	30	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	30	14657	20340	79540	223764	630915	834929	908946	1234757	1242660	1344241	1454627	1659702	1736000	1965738	2012127	2020349	2412039	2423515	2546041	2894171	3122384	3223403	3525331	3839159	4258630	4632872	4875251	7129019	8412359	9815545	11300453	11359506	12903282	12959189	13044957	13111012\nG	31	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nG	31	4851	7545	33096	390847	762165	1016392	1053598	1196822	1430864	1454994	1657196	1836201	1892947	2155435	2233573	2484107	2628115	2785490	2902807	3208875	3493146	3728998	3996042	4130072	4352007	4821243	5388809	5779152	5866749	10230778	12933769	13123351	13280540	13467143	13620202\nG	32	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nG	32	4850	31706	200843	516685	724704	903098	924437	1233106	1267756	1363902	1549201	1702704	1806506	1904784	1993352	2194515	2495345	2547242	2770987	3113153	3409238	3532813	3685500	3870713	4198138	4547100	4697806	6044089	6285829	10933431	12213516	12308911	12615903	12824709\nG	33	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	33	5505	18072	200124	529773	913675	945363	971260	1289118	1314270	1329115	1576078	1696927	1807699	1950817	2067699	2265668	2648757	2767184	2871773	3008975	3330022	3649199	4112241	4509783	4642654	4768512	5162089	6252602	10393314	10692226	11078395	12563653	12689551	12768455	12836949\nG	34	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nG	34	5502	18926	230079	545580	770604	938856	988024	1144031	1346629	1440126	1531680	1679443	1840824	1926240	2151370	2349048	2580475	2594165	2903895	3116262	3257089	3453866	3815463	4219747	4455337	4839400	6207808	6468460	7654697	10765321	12219479	12381910	12407297	12712163\nG	35	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	35	829	14705	21000	231366	718671	885170	1147996	1175922	1347022	1633719	1732657	1878711	2071096	2314136	2330724	2579525	2922068	2952286	2979665	3188431	3581126	3934684	4072705	4211799	4871777	5212291	5498843	5691129	6473457	7739851	11635478	13131727	13270839	13409330	13466959	13556532\nG	36	3	4	5	6	7	8	9	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	36	7623	40629	88181	631684	810189	1092064	1147668	1488994	1675246	1754605	1829596	2070276	2255763	2306040	2635080	2778882	2920269	3044911	3378181	3586728	3975532	4140471	4282759	4611265	5323220	5829031	7013877	8621651	9804116	10197326	12451141	12616395	12823610	12858964\nG	37	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	37	1051	5940	32829	154184	629599	762233	1033126	1079217	1241732	1440185	1487151	1674007	1813601	1996087	2032311	2259924	2491548	2647025	2982174	3145646	3336297	3581060	4054323	4474542	4707863	5090028	6204363	6441807	7637531	8031779	11963990	12299703	12461510	12703001	12721807\nG	38	3	4	5	6	7	8	9	10	11	12	13	14	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	38	1034	26502	65584	670490	869576	1125242	1151269	1187755	1560760	1581957	1780749	1968491	2042858	2349946	2643308	2662539	2924199	3221120	3474707	3733531	3905092	4223659	4470207	4765709	5202920	6320411	6578342	7961775	9725000	12230241	12484014	12689303	12805776	12845443\nG	39	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	39	1196	29819	106319	658988	722443	1075225	1104802	1314873	1502807	1542274	1670694	1904819	2005802	2171812	2323651	2451060	2656962	2941075	3019975	3287245	3601770	3978666	4131120	4511134	5109056	5529432	5762969	6768970	8091498	8364499	11027074	12316688	12400006	12618178	12658666\nG	40	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	40	8775	37165	76096	563566	854742	1255579	1312268	1340009	1711058	1777043	2009482	2091888	2287552	2434978	2603670	2845108	3009796	3199027	3314643	3517068	3706936	4137397	4378977	4598378	5064729	5406616	5962208	7154271	8358188	9373876	10733364	12355381	12603534	12948043	12969189\nG	41	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	41	1350	31179	81150	600132	1029941	1478922	1516275	1570146	1727830	2058771	2185410	2364745	2657198	2799720	2900941	3202452	3555622	3604085	3884844	4153415	4417840	4770686	5170914	5396921	5823651	6501096	6846353	7938330	11104203	11409464	11559728	12857221	13221444	13593434	13615537\nG	42	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	42	1479	35616	84670	590401	909968	1109456	1358462	1414136	1617695	1846620	1964284	2088864	2288944	2380679	2713453	2864107	2950867	3030296	3221433	3622247	3994715	4241930	4640436	5324229	5730244	6001549	6445533	7318689	7849510	9868529	11063682	11193543	12573060	12893041	12939696\nG	43	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	43	11679	67820	613121	912912	1126854	1325457	1390954	1422674	1836142	1901814	2007844	2152037	2463127	2703346	2789290	2814951	3438210	3490875	3789456	4209648	4452227	4728647	5143763	5516262	6239098	6714859	8693619	9639848	10918310	11090179	11245290	12399340	12702582	12867692\nG	44	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	44	1731	38232	70899	729183	960850	1376367	1421204	1450112	1677672	1896944	1969369	2083631	2195486	2459296	2595381	2903434	2993150	3288792	3587078	3842320	4061663	4479089	4903582	5277513	5683926	6221157	7805465	8560802	9450407	10777908	11672851	11882484	12438452	12697199	12748835\nG	45	4	5	6	7	8	9	11	12	13	14	15	16	17	18	19	20	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nG	45	37460	177437	622679	1138021	1390069	1715965	1809106	2245326	2297245	2589821	2755278	2925991	3048231	3271103	3671403	3994158	4490478	4632339	4695086	4930745	5225788	5952641	6521785	7037577	9302657	11127480	12461558	12702645	12866617	13167382	13425623\nG	46	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	46	322702	610337	1027481	1060433	1506225	1555466	1585318	2034117	2142322	2245053	2364632	2774893	2888210	3097401	3314441	3456870	3822824	4088967	4249338	4490862	4835987	5637338	6081280	6845205	7469238	7961646	10611410	11386652	11714973	12012154	12403237	12800952	12903543\nG	47	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nG	47	2077	46078	85922	699258	1051713	1086920	1540504	1626756	1665246	2080849	2148673	2233479	2459492	2607562	2794668	3198738	3359501	3597367	3807777	3896772	4356964	5005918	5279877	5789157	6095135	6582426	7279077	8008197	8745291	10792435	11807100	11902739	12212775	12729043\nG	48	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	48	2256	16561	104624	707947	1251447	1287518	1529221	1885273	1958234	2180503	2527000	2615836	2846587	3068101	3257483	3513614	3715783	3779109	4239293	4491944	4792328	5068954	5465283	5900569	6987973	7674915	8378368	9894526	10260644	12123893	12401556	12608228	13020585	13352552	13408349\nG	49	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	49	2416	92583	743431	1180330	1217439	1459797	1763463	1798098	1871838	2322130	2379057	2657855	2858538	3027050	3259269	3600232	3707165	4040349	4292324	4653411	4910528	5276875	5618556	6080041	7088664	8104205	8861557	9388410	10759055	11037397	12128250	12633507	12933130	12960579\nG	50	5	6	7	9	10	11	12	13	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	50	67540	722257	1209508	1505323	1802326	1838232	1874374	2371666	2676530	2774984	3192854	3324478	3536471	3595988	3999577	4378599	4529648	5072209	5293649	5941752	6526230	7491485	8609373	8924848	10279333	10508938	11004991	11954809	12519272	12826573	12883883\nG	51	3	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	51	3013	93287	425494	1125413	1185583	1712850	1783287	1821181	1865192	2357843	2420032	2604641	2774960	2996456	3228927	3589770	3761020	4247107	4536384	4722062	4972535	5219270	5864984	6451141	6991761	7949887	8876508	9988209	10724085	11105533	11295418	11794364	12711983	12793324\nG	52	4	5	6	7	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nG	52	58014	134441	655404	1193079	1499809	1720536	1794881	1835685	2373751	2414322	2521514	2703721	2973739	3164219	3487224	3925461	4006899	4220849	4628370	5101184	5613061	6110000	6629858	7121518	7504712	8423440	9847866	10135064	10491060	10872369	11552443	12561518\nG	53	5	6	7	9	10	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	53	79984	613885	1242492	1284468	1857326	1944040	2450323	2519472	2559750	2838920	3106292	3450534	3685011	3795870	3986350	4552931	4806676	5228843	5589103	6010851	6543718	7447434	8083731	8682407	9417473	10375432	10708634	11312579	11685122	12464777	12620276\nG	54	3	5	6	7	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	54	3628	341889	857009	1416671	1674237	1755678	2133126	2407951	2612277	2848003	2964197	3264504	3516610	3852109	4318536	4587735	5230628	6024601	7410375	7976731	8462753	9059096	9383986	9673446	9939826	10152186	10565027	11322533	11574854	12496628	12630562	12785072	12849121\nG	55	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nG	55	3890	137671	809391	1603903	1678964	1818141	2437914	2482988	2539939	2807044	3196967	3271989	3556769	3896812	4189993	4390239	4641339	4920702	5321269	5513961	5993610	6334204	6615899	7472338	8866099	9263040	10098603	10403086	11329873	11647721	12393567	12937050	13234688\nG	56	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	56	4203	100862	718463	1407159	1484370	1531983	2080496	2170932	2260655	2546417	2868815	2964476	3277169	3307111	3566383	3966190	4253092	4379732	5169407	5285963	5589765	5858881	6311777	6991361	7718449	8565392	9152369	9662834	10666501	11150320	11413747	12252442	12623244	12773501\nG	57	4	5	6	7	8	9	10	11	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	57	28948	108777	630713	1234611	1490270	1538420	1632232	2240336	2393870	2909014	2964142	3273947	3527267	3790727	4038009	4328120	4639650	5158889	5237369	5702921	6357952	6854384	7164118	7937510	8519914	9194117	10500970	10968314	11441374	12135809	12444393	12601275	12635875\nG	58	4	5	6	7	8	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	58	4832	114456	729203	1299451	1564592	1971435	2290915	2339771	2445017	3027890	3084993	3305283	3720287	3880508	4096011	4318136	4988742	5073619	5187541	5879191	6279812	7064938	7997561	8415715	9054308	9781238	10000054	11212774	11686954	12165264	12442949	12615836	12649559\nG	59	4	5	6	7	8	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	59	33063	123599	1006285	1538076	1859797	2011510	2675726	2726172	2776051	3189007	3542614	3786402	4038876	4205388	4557291	5057302	5255777	5600679	6072520	6480714	6748950	7261068	8191762	8554671	9355032	10179553	10969306	11590280	12006326	12423879	12694505	13023533	13092989\nG	60	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	60	35297	500613	1029871	1129381	1749127	1854143	1909482	2572280	2623717	2673661	3107991	3405057	3647235	3817834	3949128	4220343	4751203	4902408	5421437	5492568	6206707	6531565	7243856	7665476	8325810	8843536	9444304	9886956	10013799	10302044	11402373	12068828	12474508	12573137\nG	61	2	5	6	7	8	10	11	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	61	5887	517845	874419	1468075	1809354	2252034	2655170	3029348	3351907	3516569	3639520	3832267	4341118	4382136	4985941	5321852	5804945	5992540	6501007	6869337	7406309	8562754	9139857	9842832	10441092	10739111	11053507	11763292	12021673	12351480	12649241	12684758\nG	62	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	62	39623	149249	823632	1174515	1810703	1923355	1982994	2661796	2716622	2837902	2956269	3529267	3693539	3935793	4161699	4662325	4981244	5142036	5371140	5646521	6239761	6932303	7458236	7959525	8842993	9231613	9884324	10254606	10585353	10720660	11275740	11749851	12415195	12451905\nG	63	2	4	5	6	7	8	9	10	11	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nG	63	16313	23455	178691	832372	1239045	1692889	1901338	2016973	2784342	2840125	3103719	3425368	3749712	4072582	4331776	4624486	4698777	5186040	5573708	5912617	6556605	7312389	7847888	8110938	8610704	9221164	9938817	10669611	10926112	11505434	11853555	12327548	12474120\nG	64	4	5	6	7	8	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nG	64	43601	166715	1165385	1278953	1961002	2144234	2805088	2863657	2994488	3122551	3779303	3852705	4207954	4372758	4811585	5289566	5456684	6031050	6175876	6718185	7279876	7853876	8501351	9191307	9589394	9933845	10601126	11284219	11582506	11690024	12101780	12469504\nG	65	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nG	65	7886	172475	1242610	1559384	1852447	2077877	2196439	2953915	3012997	3145479	3220430	3904893	4033132	4297098	4686083	4861082	5379633	5943934	6228396	6547760	7186491	7345879	8162120	8654069	9340051	9666804	10230760	10766714	11248274	11633040	12043192	12474806	12622175\nG	66	3	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nG	66	8337	796700	1057944	1745427	1933937	2167631	2580941	3068690	3129548	3453739	3586629	4217908	4508097	4579504	5065658	5454123	5488512	6118051	6456069	6730998	7391128	7676217	8071850	8280904	9097356	9428569	9880485	10231490	10853113	11388312	11686009	12165827	12533163\nG	67	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	67	8817	626154	1095711	1671804	1987767	2225287	2636583	2859757	3195033	3334385	3652024	3867749	4366720	4649083	5159654	5499237	5805935	5976178	6413315	7197999	7912023	8275615	8877240	9422127	9710756	9902301	10605245	10819333	11233942	11524963	11899284	12255366	12449648	12531348\nG	68	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	68	54615	585830	1423825	1765562	2090236	2336072	2763556	3274880	3338746	3401094	3889184	4465217	4544360	4886677	5094196	5740396	5857081	6253689	7109469	7419067	7890468	8381862	8849925	9407170	10153303	10521891	10964784	11091790	11216360	11579401	11970973	12324489	12584519	12621991\nG	69	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nG	69	138372	698930	1228248	1864315	2209936	2467411	2909330	3150854	3507973	3653881	4069279	4741427	4815412	4965674	5583591	5859550	6058461	6917702	7024054	7867018	8463991	9044632	9615639	10129673	10509190	11062072	11439085	11724489	11853462	12001225	12262228	12543689	12641023\nG	70	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nG	70	62811	700301	1401441	2014188	2239696	2503461	2935349	3188073	3549070	4022624	4106201	4659337	4957950	5158423	5674801	6011604	6312174	7185063	7630702	8350591	8839871	9046531	9341566	9863891	10429081	10745340	11160445	11480102	11851820	12100946	12328180	12498235	12540073\nG	71	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nG	71	11742	65334	968779	1629015	2132586	2292373	2641934	3093841	3420066	3791404	3938289	4486989	5002176	5298076	5630618	6175486	6688957	7076564	7940851	8228581	8512231	9220656	9683559	10171946	10660739	10950546	11377467	11480760	11684394	11806896	11968879	12213416	12604807	12632903\nG	72	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35\nG	72	166491	759010	1690171	2054047	2440940	2722701	3175679	3511338	3826138	4315122	4455861	5074350	5321442	5928310	6267132	6828190	7308616	7959681	8363659	8981467	9607855	10413728	10513298	10880303	11535622	11618202	11902703	12091747	12170975	12367370	12508490	12530028\nG	73	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nG	73	13443	176375	958902	1789806	2182298	2577635	2869748	3345153	3692711	4173442	4528131	4807019	5446323	5967100	6606490	6716984	7434976	7964336	8574211	9071153	9295051	9953432	10680287	11111249	11468032	11679150	11825828	12092427	12158152	12342445	12444282	12580453	12644468	12681997\nG	74	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nG	74	14122	79864	863139	1829293	2225795	2455661	2935365	3415325	3577620	4457535	4704732	4758717	5635535	6054002	7026598	7347386	7819929	7994552	8204939	8426598	8891436	9478790	9829436	10377914	10835291	11336801	11578655	11901261	12101300	12229971	12338735	12510780	12612505	12651603\nC	0	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	34\nC	0	19374	35543	153625	479301	488530	705452	713752	852047	963016	1082781	1131343	1231035	1402161	1448948	1512353	1605118	1659083	1851728	1989601	2040276	2165982	2268809	2592241	2877257	5967858	6190482	7825627	9803544	9845503	10039198	10130390\nC	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	34\nC	1	22739	45601	179443	552614	566815	821564	833229	1000885	1141407	1286733	1351383	1476056	1685529	1735336	1810736	1927441	2002920	2263696	2423844	2479914	2637678	2766220	3095552	3363887	6556729	6795297	8293144	10732167	10797767	10969868	11057401\nC	2	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	34\nC	2	96938	99301	218684	412924	793181	1132928	1152042	1250915	1468979	1646340	1808525	1963503	2107878	2318680	2396785	2478712	2741367	2974269	3287559	3510370	3799181	4087904	4525860	4679966	5009603	7964236	9711421	11078430	11161483	13059111	13135046\nC	3	1	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	34	35\nC	3	5432	202015	231876	783159	979946	1366169	1380013	1596933	1716953	1816071	2072674	2147459	2572377	2593980	2806804	3292666	3461402	3544213	3928907	4283027	4436015	4656642	4834173	5057798	5362601	5825129	8869345	13518785	13529451	13744920	13824129	13866666\nC	4	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31\nC	4	88944	99331	307481	705266	719937	1017523	1190327	1236731	1404449	1605534	1613061	1831248	2034530	2157765	2184772	2433854	2606001	2996133	3185901	3320950	3518830	3715503	3930356	4201063	4348139	4612712	8638280	8987598	11721989	11869837\nC	5	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	34\nC	5	51526	93888	302212	715917	753102	1063688	1169088	1235835	1455671	1482818	1632897	1837498	1912448	2177432	2311918	2386102	2665665	2877738	3039509	3260096	3566258	3794127	4064116	4149027	4411421	4637053	4712328	8852643	10511054	12073281	12245224\nC	6	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	34	35	36\nC	6	66137	76837	188697	582556	806120	969733	1159083	1326289	1477523	1570540	1668390	1763814	1901804	2111956	2258837	2612215	2802168	2820563	3006160	3202160	3317912	3617020	3834603	4067641	4563914	4798656	7828529	7970410	8805486	11643685	11713017	11746041	11817545\nC	7	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	34	35	36\nC	7	62261	92823	180116	552922	750125	1066116	1084394	1232896	1334758	1624570	1641080	1768273	1873764	2125637	2235521	2369668	2580965	2792756	3107694	3140061	3240879	3461149	3787492	3916796	4132124	4413861	5490332	8600847	11470572	11823966	11894920	11907628	11980036\nC	8	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	34\nC	8	43527	66421	227775	706416	748348	1029782	1053645	1215645	1301748	1445717	1644084	1782674	1985611	2109286	2189383	2362384	2594154	2802757	2910205	3033739	3464242	3627548	3719887	3962595	4246504	4392012	4572898	9103815	10394962	12051043	12121360\nC	9	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	34	35	36\nC	9	29018	79805	196966	613936	759234	1060261	1084334	1154221	1302084	1453845	1617819	1694689	2015794	2091951	2185531	2315477	2381183	2676127	2779193	2929191	3331408	3574243	3712509	3850274	4289113	4423106	5386393	8542094	11333118	11495193	11642426	11704126	11777849\nC	10	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	34	35	36\nC	10	28662	56602	226921	581954	736178	1039872	1121629	1209687	1350812	1430827	1588599	1723264	1854632	2124702	2301254	2483604	2571199	2745947	2828285	3127948	3171996	3340549	3545516	3841314	4219365	4304651	4413568	10190096	10209498	11609080	11627949	11653941	11791929\nC	11	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	33	34	35	36\nC	11	10776	17433	171086	619176	797652	1280957	1395539	1483345	1588654	1781662	1969148	2080837	2336053	2507652	2525974	2816879	3042696	3357179	3428443	3708491	3893632	4054082	4448103	4622097	4635049	5121506	8168654	10024147	12774156	12872062	12942557	13042699	13088491	13162473\nC	12	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	34	35\nC	12	3425	20689	81159	207040	704939	774226	921025	1087543	1239484	1447594	1524490	1768080	1818422	1942200	2133143	2217231	2346312	2362870	2522132	2743401	2904927	3144364	3441139	3772999	3825197	4064828	4345260	7198805	9981868	11519497	11711520	11750532\nC	13	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	36\nC	13	11462	22187	34500	232434	599824	796977	952638	1116104	1350047	1505723	1600419	1616067	1879996	1978830	2207193	2352478	2365010	2716373	2771339	2848804	3144338	3314713	3523017	3779771	3878855	4102615	4218052	7070383	8689461	10307604	10310336	11538894	11775607	11922290\nC	14	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	34	35	36\nC	14	8975	13186	22508	121662	642577	820593	885077	1228668	1252555	1416769	1507714	1670498	1943505	2184422	2206227	2420963	2607981	2768282	2964861	3094603	3187076	3389624	3745663	3963085	4083984	4339956	4620824	5044976	9145155	11843392	11972587	12186085	12199727	12269022\nC	15	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nC	15	61607	85630	101742	346629	665036	875321	1037076	1083987	1283179	1442019	1594780	1683198	1846572	1953352	2086205	2327999	2452346	2674330	2743646	3108041	3297272	3422251	3500961	3777039	3958997	4222384	5725973	6889467	7102724	9043619	11537284	11602757	11718445	11732719	11962928\nC	16	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	34	35\nC	16	8066	30347	32156	214883	600878	1073874	1106725	1311053	1577151	1794638	2021382	2220671	2433798	2443455	2682113	2938353	3215409	3375675	3647520	3750566	3948350	4413020	4667595	4944526	5160064	5506581	5884423	6953978	8431670	11428458	12692204	12908291	13040114\nC	17	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	34	35	36\nC	17	4180	7612	21990	219353	575676	891401	941046	1166801	1386010	1465385	1739525	1835586	1958493	1970141	2142614	2533832	2608171	2784362	2903250	3058905	3162850	3338884	3626692	3853197	4199072	4587459	4807760	5056842	9225907	9501248	11632607	11717473	11888032	12102536\nC	18	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nC	18	5380	9959	34829	219827	378162	956094	995068	1186600	1372714	1569524	1677503	1776558	1938848	2121832	2166311	2611143	2654042	2795723	2964080	3186775	3396830	3527333	3826034	4071093	4167536	4703172	5278346	5312493	6857134	9424556	11572122	11585651	11744128	11891927	11978620\nC	19	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nC	19	10379	33911	172243	468140	1095690	1170102	1365940	1642158	1765394	2039865	2152424	2248444	2371334	2775192	2992466	3134267	3253756	3518695	3856359	4026251	4294495	4606965	5136146	5415757	5708952	5863655	6190306	9254741	11002933	12395417	12457204	12634425	12727893	12806085\nC	20	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nC	20	8812	9505	171256	645446	1014201	1044309	1442840	1454401	1478647	1780298	1859782	2051747	2180328	2495252	2528591	2875120	2970714	3182309	3596295	3753346	3863131	4238463	4332985	4774117	4960472	5287576	5587178	8590883	8727837	11517846	11585914	11802532	11819416	11919520\nC	21	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nC	21	5329	12665	152560	541066	765267	992348	1377272	1410223	1441695	1710498	1798129	1818853	2083176	2373334	2383836	2565947	2656539	2930868	3203295	3249574	3366207	3759419	4161433	4344069	4551185	5088781	5347198	5598226	8672658	9957352	11489797	11502589	11587261	11862635\nC	22	2	3	4	5	6	7	8	9	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nC	22	6705	16170	74175	224404	690119	1072889	1086133	1503152	1628816	1671829	1966660	2110483	2384914	2528826	2585425	2810247	3046612	3312907	3416536	3746689	4024183	4291122	4325329	4782450	5238006	5536407	6559253	7236112	10713928	11829719	11857303	11991431	12071904	12114742\nC	23	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nC	23	7658	11186	47621	145092	619723	815751	1085402	1118559	1603297	1636608	1673419	1985986	2283016	2369099	2548462	2599998	2878850	3112729	3221895	3265317	3909485	4027062	4319199	4708369	5099485	5391232	5722459	6313983	7869417	9986749	11169404	12043456	12249538	12322860	12366882\nC	24	2	3	4	5	6	7	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nC	24	956	5068	30759	92826	527319	1048371	1085743	1293003	1545032	1661749	1865683	1960591	2177230	2395209	2571012	2591411	2702382	3085342	3242469	3540532	3816573	4267461	4532428	4686866	4900252	5170599	5853101	7551349	9621243	10510497	10638920	11792280	11958438	12003875\nC	25	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nC	25	2494	16590	29812	79692	350843	835161	1047608	1308273	1521138	1558519	1581172	1983909	2185097	2268536	2406820	2589327	2603060	2950941	3201199	3432153	3626943	3926193	4146517	4513700	4754493	5254475	5688191	6116681	7815811	10673868	11646970	11723845	11931600	11984540	12029876\nC	26	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nC	26	25137	55527	413147	866215	1080076	1127044	1383167	1586227	1624565	1853131	2049682	2174145	2494130	2602132	2815825	2960286	3171685	3529047	3708372	3941777	4310599	4669616	5158623	5396439	5716439	5984457	7589991	8580536	11460017	11530527	11934255	12074748	12124656\nC	27	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	27	1636	24396	178448	638184	1305549	1408528	1457598	1674274	1978668	2117146	2150733	2398910	2728218	2940816	3089753	3305452	3583048	3599621	3827498	4246425	4614558	4907579	5176987	5737662	6426788	6802600	7061554	8451059	10037059	11505643	11580510	12601560	12737907	12881762	12983013\nC	28	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nC	28	12656	19853	48616	390921	1023946	1389402	1432078	1674410	1986767	2004153	2284406	2561277	2686059	2943343	3008396	3568524	3855085	4279795	4330421	4485707	4799553	5065911	5784569	6178726	6373481	6800345	7077938	7576552	8965553	10791770	11087863	12660924	12935596	13021488	13198267\nC	29	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nC	29	59639	63872	425950	1043974	1299671	1310336	1561726	1817653	1952302	2200050	2312339	2431906	2587301	2810319	3262982	3349468	3481626	3681614	3923382	4449081	4733293	5200198	5358755	5743514	6020069	6575680	7128959	8275533	9751340	10580859	11758159	12003021	12246235	12358076\nC	30	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	30	19411	29156	166278	428709	958678	1222687	1327939	1776823	1785663	1925637	2083922	2332543	2446185	2739843	2800992	2810205	3314974	3324962	3512763	3969780	4315462	4441620	4851820	5255449	5674900	6263198	6555131	7411048	8834811	9544373	10883236	10926025	11907515	11961203	12056436	12148692\nC	31	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nC	31	8408	13439	63631	601844	1070098	1345878	1400943	1621074	1873202	1902325	2158920	2388528	2449547	2748482	2843116	3120465	3369923	3537750	3712206	4162781	4397464	4796414	5054621	5184054	5357047	6044280	6784986	7189461	7282210	10217717	11531918	11729605	11908819	12048597	12202609\nC	32	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nC	32	7331	53471	396200	847186	1161993	1420538	1458218	1923700	1965113	2105520	2394301	2601659	2757273	2872523	3008259	3257561	3739983	3831377	4174599	4581608	4992006	5161840	5353991	5546831	5980042	6502951	6683176	8294416	8494867	10838541	11498548	11608870	11921676	12099588\nC	33	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	33	9630	26648	464348	1012645	1712499	1762294	1786567	2374320	2397230	2408894	2849075	3040295	3219312	3478849	3653566	3950919	4563661	4720971	4891191	5110461	5511412	6006528	6774067	7252771	7409339	7596274	8051575	9284674	11142339	11476266	11825939	12721982	12817627	12890713	12977327\nC	34	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nC	34	8565	23706	476599	984250	1344768	1672415	1736075	1995161	2353471	2505863	2676754	2896405	3175941	3314204	3681679	3975209	4352543	4380182	4886340	5206330	5393451	5734499	6250524	6774860	7121200	7644085	9178963	9535917	10599046	11743437	12467228	12628795	12647351	12977220\nC	35	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	35	2328	18062	31096	461519	971520	1273885	1560491	1585419	1875213	2181522	2330499	2476046	2731167	3047376	3060867	3374320	3802477	3830899	3886692	4213105	4531157	4909934	5041907	5236046	6131453	6566302	6950158	7189222	8024467	9274032	10891024	11815967	11990550	12071770	12153280	12279476\nC	36	3	4	5	6	7	8	9	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	36	23180	68780	125353	936783	1181795	1623053	1692657	2200773	2488193	2567988	2692420	3020878	3303080	3350096	3856961	4001402	4235778	4416091	4875999	5174267	5643415	5885857	6054541	6499761	7366430	7912871	9325294	9549608	10540687	10832312	11780256	11930007	12135170	12201799\nC	37	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	37	2860	12591	46937	276074	1006468	1229404	1631789	1674832	1952718	2241655	2293989	2571047	2768738	3041542	3074070	3408810	3731845	3909046	4454499	4703622	5003093	5248573	5842310	6498517	6816963	7313949	8634884	8906262	9909559	10288206	11526317	11846496	11992739	12181791	12213918\nC	38	3	4	5	6	7	8	9	10	11	12	13	14	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	38	3262	34850	120461	1110127	1447522	1803457	1849364	1879474	2452111	2467487	2757260	3060586	3138180	3578647	3944010	3962919	4379402	4740255	5081785	5395738	5571687	6070032	6438673	6914272	7396180	8638143	8977655	10176327	10666683	11725163	11960495	12159839	12251519	12306845\nC	39	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	39	3781	38832	148214	1083125	1182916	1753532	1782928	2111154	2411191	2444613	2638137	2988960	3128449	3357258	3600933	3825497	4072015	4523200	4623929	5041058	5467567	6022423	6227954	6766712	7472007	7926288	8198120	9260415	10500424	10754250	11425753	12013187	12098416	12309485	12377440\nC	40	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	40	15067	57281	142710	869992	1339469	1983614	2032294	2081966	2713938	2766518	3136483	3222787	3532234	3737545	4002841	4321475	4568438	4895126	5044867	5326405	5617237	6190585	6603628	6839852	7423502	7771574	8343575	9674331	10244800	11040821	11639588	12127715	12395663	12671331	12702161\nC	41	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	41	4386	43089	149631	799377	1230182	1863472	1902083	1972654	2247661	2574504	2703748	2967880	3327145	3457484	3642527	4036995	4335242	4384363	4878930	5204196	5471444	5851180	6488505	6699966	7165328	7997584	8347027	9444911	10770504	11005173	11088511	11711473	11983827	12297970	12324737\nC	42	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	42	5238	51229	153427	919324	1331748	1631798	1973508	2045813	2369893	2673915	2875692	3030714	3327998	3425566	3875987	4117236	4244094	4322630	4527240	5203605	5638154	5906717	6492458	7414942	7922501	8214312	8648646	9540500	10121914	10870526	11370902	11530441	12117073	12293115	12357840\nC	43	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	43	32767	117039	925558	1335621	1628024	1923103	1981458	2039208	2633552	2709157	2892488	3070862	3468916	3837488	3937586	3963711	4880802	4936054	5257464	5903026	6199779	6590915	7063009	7515370	8410527	8868602	9812042	10533457	11080439	11192848	11375684	11754224	11947029	12145617\nC	44	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	44	5663	53488	121007	1064218	1378415	1987814	2028992	2050403	2417152	2723552	2804366	2981333	3151816	3507901	3685414	4103293	4265409	4581789	5109154	5470180	5786335	6281588	6827518	7276983	7906101	8486401	9119038	9786008	10506642	11123557	11366859	11559030	12006760	12165559	12229312\nC	45	4	5	6	7	8	9	11	12	13	14	15	16	17	18	19	20	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nC	45	49790	352846	784190	1427228	1806166	2167314	2275276	2871350	2920855	3304283	3490346	3750654	3948018	4194925	4640410	5168589	5819870	5972967	6050704	6421968	6815045	7581111	8215406	8623006	9957553	10849386	11618419	11842067	11973580	12196959	12365513\nC	46	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	46	374943	891670	1615324	1673207	2410330	2457011	2480368	3254329	3368536	3538362	3734581	4298262	4512177	4828158	5146776	5302267	5856697	6204543	6450770	6748181	7147240	8194413	8621522	9399552	10014845	10490331	11063034	11586193	11863610	12153556	12436498	12650825	12778012\nC	47	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nC	47	7537	65480	144824	1054413	1688480	1749955	2532131	2608038	2678109	3440462	3496411	3596190	3991669	4246975	4519171	5133502	5385513	5677208	6056147	6189498	6845908	7597017	7922080	8512492	8957825	9440660	10226901	11011362	11471030	12087952	12443414	12527920	12675243	12945888\nC	48	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	48	7944	34470	185121	831320	1598176	1661404	2018142	2424101	2524088	2887888	3269232	3371274	3698883	3947777	4245624	4586037	4901958	4975204	5575528	5906819	6375004	6645312	7209578	7677225	8746358	9337852	10093338	10651595	10831239	11555826	11780005	11950756	12237953	12401820	12459187\nC	49	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	49	9067	157069	1002750	1612957	1678095	2030838	2433537	2462320	2570033	3236822	3311905	3705336	3952424	4209747	4539567	5018902	5224249	5558327	5982150	6460322	6878898	7355109	7783199	8344148	9206327	9505912	10245088	10724479	11217163	11328339	11730384	12076163	12243269	12264275\nC	50	5	6	7	9	10	11	12	13	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	50	109903	1016427	1825158	2262787	2756332	2787374	2819943	3667181	4145418	4270946	4865689	5113329	5361717	5458454	5973910	6610261	6817522	7638403	7912471	8638932	9171184	10022851	10504555	10868076	11466816	11576102	11860377	12154842	12481410	12689989	12732065\nC	51	3	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	51	10874	168637	529008	1687945	1744322	2558139	2625815	2658698	2741499	3491738	3576113	3803406	4092714	4352442	4725450	5216541	5515458	6168410	6553542	6856353	7118849	7510868	8247833	8838628	9373726	10325505	10689665	11144867	11546572	11709705	11867092	12077871	12309229	12374064\nC	52	4	5	6	7	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nC	52	81497	228083	995643	1749836	2210380	2563212	2636451	2673069	3509498	3550717	3688509	3973585	4351478	4648422	5134079	5725395	5827894	6127458	6677158	7401705	7987255	8589748	9178053	9600023	9864305	10179816	10896798	11093790	11386155	11596235	11916563	12225625\nC	53	5	6	7	9	10	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	53	140197	1025493	1994893	2070497	3012672	3138770	3993196	4090512	4133123	4610880	4938059	5452803	5834753	5977867	6266447	7112828	7464606	8043259	8481117	8972238	9419139	10251970	10832749	11212210	11662443	12044236	12217119	12307425	12408054	12614303	12737085\nC	54	3	5	6	7	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	54	14211	679259	1259246	1919919	2342845	2416008	2913479	3384894	3680550	4013860	4163758	4634277	4997586	5461556	6147713	6498672	7186644	7887778	8703075	9224406	9651148	10120523	10482639	10751954	11039388	11221285	11459976	11674067	11850482	12187144	12257630	12370931	12413784\nC	55	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nC	55	15435	269214	1008343	1923559	1995769	2159394	2963685	3007425	3106519	3535079	3966795	4071131	4494988	4905509	5301822	5624586	5919125	6201733	6777749	6970369	7666026	8165486	8389257	9117682	10116865	10484126	11033150	11224662	11507425	11737389	11925260	12112856	12251856\nC	56	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	56	16393	185349	1087179	2135912	2212385	2297026	3185624	3278070	3369247	3803369	4358589	4466380	4973916	5037897	5432930	5938814	6411895	6579548	7738852	7896017	8280423	8531686	8863865	9642616	10282506	10614131	11089532	11356808	11691108	11999766	12174349	12346615	12483893	12557105\nC	57	4	5	6	7	8	9	10	11	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	57	68547	204120	752658	1702772	2093187	2178977	2267782	3163963	3376178	4180420	4240677	4737948	5051152	5462162	5777876	6294243	6642866	7400337	7498952	8041229	8889383	9400038	9649416	9910115	10381306	10807864	11146374	11361863	11676652	11946689	12032226	12148520	12169952\nC	58	4	5	6	7	8	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	58	19478	216761	954949	1758562	2159753	2726330	3206958	3258640	3422673	4300535	4363622	4641453	5257665	5564539	5801231	6111901	7051712	7124706	7272862	8259517	8774117	9427509	9886460	10326314	10715924	11116172	11228972	11530374	11783083	11919231	12002007	12062480	12095508\nC	59	4	5	6	7	8	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	59	77623	233251	1145146	1767345	2255805	2448434	3338683	3393329	3450614	4127195	4537580	4825518	5255222	5572941	5977368	6573820	6815067	7395779	8076481	8580108	8850510	9274103	9844549	10115836	10653477	10931532	11309662	11518359	11674502	11886303	11978138	12103524	12138151\nC	60	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	60	84684	524145	1412526	1503203	2381934	2488419	2588825	3568861	3629586	3692550	4311491	4817474	5180165	5384562	5627567	5984434	6847779	7053655	7699705	7785369	8687680	8984491	9654405	10014207	10409129	10825118	11128322	11334274	11427500	11566143	11786822	11980477	12134192	12167620\nC	61	2	5	6	7	8	10	11	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	61	25415	535398	1109264	1916668	2435136	3059673	3650208	4147935	4733886	4935287	5103649	5379260	6115551	6174870	7028660	7463596	8057174	8351588	8919425	9229007	9682109	10389737	10776372	11055735	11338976	11441602	11598133	11827267	11873463	11956233	12041169	12056143\nC	62	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	62	96103	289123	1121397	1613776	2531378	2648915	2756987	3787693	3854651	3996350	4197324	5110714	5318606	5726010	6042949	6776603	7281774	7518943	7769199	8125937	8940423	9632919	9914025	10303578	10782170	11102316	11413258	11572545	11684862	11741625	11839083	11990670	12123386	12139413\nC	63	2	4	5	6	7	8	9	10	11	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nC	63	46113	76511	353422	974152	1660530	2239961	2593766	2716576	3878629	3947912	4306201	4853785	5301877	5762196	6170189	6577273	6713723	7430874	7978963	8330844	9135099	9736123	10220754	10448768	10811366	11093390	11470190	11610976	11727464	11827750	11911536	12012671	12062676\nC	64	4	5	6	7	8	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nC	64	105087	319763	1619469	1728513	2696351	2940194	3958700	4027718	4176946	4392773	5413041	5491351	6053228	6287679	6852671	7578532	7819820	8509207	8748293	9379064	9898310	10294381	10751669	11123583	11295850	11408189	11602037	11771007	11879475	11903665	11992717	12104182\nC	65	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nC	65	34608	344862	1679643	2081751	2416073	2790727	2924456	4094963	4166989	4320889	4401510	5512677	5663604	6096033	6613176	6839610	7556518	8370002	8629833	8994850	9649464	9759381	10308785	10694288	11046518	11253930	11410834	11553664	11739229	11849339	11932571	12043027	12075034\nC	66	3	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nC	66	36643	855866	1361139	2302882	2530338	2915781	3534065	4282448	4357132	4841376	4998520	6010215	6378501	6453526	7148053	7738359	7785413	8527078	8917408	9250841	10002584	10267520	10473162	10593822	11077969	11195006	11389108	11518605	11744120	11892871	11933228	12063339	12188872\nC	67	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	67	39344	672109	1396228	2235396	2597590	2988622	3624649	3920827	4468188	4629378	5124525	5445890	6233769	6578197	7252789	7847190	8307198	8480684	8839125	9766087	10453370	10750881	11154662	11298530	11407689	11505036	11738244	11818102	11928978	11990178	12070375	12152305	12188722	12220690\nC	68	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	68	134412	586742	1824612	2273914	2652646	3053335	3700780	4492264	4571461	4649663	5316973	6289886	6368436	6831106	7177386	8041295	8142006	8755069	9693819	10023417	10457460	10773878	11030757	11321563	11618858	11755906	11884146	11909926	11945524	11989736	12074201	12178747	12220482	12232669\nC	69	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nC	69	321935	702710	1457475	2329786	2721066	3130607	3787326	4104618	4679933	4845694	5427129	6491165	6563656	6800213	7606913	7998038	8249649	9249944	9401991	10189156	10744056	11097720	11351301	11584003	11690264	11818529	11937203	11968020	11991668	12005249	12073367	12125222	12147194\nC	70	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nC	70	151996	751943	1677278	2601456	2865883	3285108	3971956	4298717	4884632	5568079	5649759	6540699	6932147	7194577	7847748	8399389	8684366	9753456	10138161	10695107	11009466	11214761	11391401	11629267	11778477	11882393	11954090	12014412	12125982	12183214	12220882	12249485	12266609\nC	71	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nC	71	51210	159592	949734	1991880	2645098	2813026	3348427	4046484	4466250	5065457	5231563	6017654	6850513	7202674	7684783	8395686	9010602	9479621	10270565	10491690	10719251	11155376	11477595	11656037	11796219	11892847	12031788	12053191	12089062	12112125	12136700	12176121	12234627	12239142\nC	72	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35\nC	72	388520	799388	2077279	2599630	3039765	3478222	4190605	4618809	5145201	5837100	5990391	6953661	7303248	8120145	8556222	9223436	9758748	10490774	10711884	11087675	11344219	11798348	11844792	11945998	12092565	12114262	12182390	12224956	12240159	12272470	12293096	12296985\nC	73	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nC	73	59028	410486	889805	2125013	2663738	3117128	3562227	4292929	4731131	5434430	5959925	6303380	7283404	7750970	8626042	8781743	9631522	10110838	10676226	10961895	11065185	11405120	11720437	11881049	11958297	12033511	12054704	12120159	12132465	12144737	12154766	12169773	12177902	12186487\nC	74	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nC	74	63109	189962	890032	2020276	2577876	2849063	3480497	4239595	4496062	5782092	6067674	6138893	7393105	7798772	9049057	9522080	10236614	10336593	10547290	10683580	11014919	11339900	11546212	11724122	11835753	12034125	12129135	12240236	12314435	12327437	12343446	12369850	12384722	12397271\nN	0	2	20\nN	0	93789	144139\nN	1	2	20\nN	1	140537	285543\nN	2	2	4	5	20\nN	2	91272	163166	274346	335384\nN	3	2	6	11	20\nN	3	91085	225551	300813	361435\nN	4	2	5	9\nN	4	75078	224245	364328\nN	5	3	4	20	23\nN	5	139947	221630	279623	361888\nN	6	6	20	24\nN	6	149690	289080	377830\nN	7	2	7	20\nN	7	81790	232218	370001\nN	8	2	6	20\nN	8	171409	325629	383643\nN	9	2	6	20\nN	9	86764	237971	376277\nN	10	2	3	5	20\nN	10	84043	235790	293824	373527\nN	11	4	6	20\nN	11	155941	244028	383378\nN	12	3	7	22	24\nN	12	82227	240566	317349	374658\nN	13	5	6	20\nN	13	155734	321664	383305\nN	14	6	8	20\nN	14	79721	235847	383426\nN	15	2	9	10	20\nN	15	125980	212590	371424	436020\nN	16	4	7	8	20\nN	16	94807	258181	344499	408349\nN	17	6	9	20\nN	17	83451	248759	399477\nN	18	3	6	7	8\nN	18	62165	149787	317719	397070\nN	19	6	8	12	22\nN	19	84137	251281	330021	392771\nN	20	5	6	20\nN	20	171192	339451	402569\nN	21	7	9	20	23\nN	21	168178	252685	316834	398121\nN	22	2	4	6	23\nN	22	92739	176069	343720	409911\nN	23	8	10	20	22\nN	23	84373	248403	341716	407064\nN	24	2	4	7	11\nN	24	93410	159824	324635	410935\nN	25	2	6	9	23\nN	25	90888	174777	341385	407621\nN	26	6	7	10\nN	26	151759	246200	410562\nN	27	3	6	8	9\nN	27	327	82346	338184	405162\nN	28	2	3	5	7\nN	28	169214	169322	251091	415254\nN	29	2	5	6\nN	29	121359	203624	435736\nN	30	2	4	5	8\nN	30	93734	161134	245385	411207\nN	31	2	4	5\nN	31	93140	160626	404632\nN	32	4	6	7\nN	32	272	233056	398369\nN	33	3	4	5	7	9\nN	33	90538	90670	167026	343001	408193\nN	34	5	7	8	14\nN	34	140126	314784	314939	405664\nN	35	2	4	6	7\nN	35	90465	90564	340061	416347\nN	36	3	4	8\nN	36	90894	158029	420238\nN	37	2	5	6	8	9\nN	37	93845	93973	174750	364884	431057\nN	38	3	5	6	7\nN	38	94740	94871	240061	427740\nN	39	2	5	6	7	8\nN	39	94079	94234	171758	353933	421403\nN	40	4	5	6	7\nN	40	411	161364	238464	420595\nN	41	2	5	7	8	9\nN	41	98499	99040	276613	352687	423845\nN	42	3	4	6	7\nN	42	71433	172442	248286	422492\nN	43	4	6	7\nN	43	93154	244972	426938\nN	44	2	5	6\nN	44	118996	120723	449883\nN	45	5	6	7\nN	45	103997	182109	430874\nN	46	5	6	7\nN	46	103640	361232	436298\nN	47	3	5	6	7\nN	47	105513	177999	180967	433675\nN	48	2	5	6	7\nN	48	103785	107749	361619	436115\nN	49	2	5	6\nN	49	114381	116574	448751\nN	50	5	6	7\nN	50	100368	349198	425594\nN	51	3	6	7\nN	51	97282	167489	426856\nN	52	5	6\nN	52	96242	429048\nN	53	5	6	7\nN	53	97273	245913	427837\nN	54	3	5	7\nN	54	112869	268936	452976\nN	55	4	5	6	7\nN	55	99522	175946	264433	448872\nN	56	4	5	6	7\nN	56	96689	165944	255254	441090\nN	57	4	5	6	7\nN	57	96763	165584	357328	442789\nN	58	4	5	6\nN	58	96697	165815	437677\nN	59	4	5	6	7\nN	59	97877	167618	355418	443937\nN	60	4	5	6\nN	60	101452	172728	457394\nN	61	2	5	6\nN	61	160945	230520	528272\nN	62	4	5	6	7\nN	62	98232	167544	168700	449436\nN	63	2	4	5	6	7\nN	63	86977	190013	261021	449256	538666\nN	64	4	5	6\nN	64	116663	188774	469365\nN	65	4	5	6\nN	65	96087	167929	456163\nN	66	3	5	6\nN	66	99596	439392	538209\nN	67	4	5	6\nN	67	94404	160147	441322\nN	68	4	5	6\nN	68	86886	147622	426672\nN	69	4	6\nN	69	162523	440289\nN	70	4	5	6	7\nN	70	89957	152927	341339	436159\nN	71	2	5	6\nN	71	139951	389137	490705\nN	72	4	6\nN	72	156358	452280\nN	73	2	4	5	6\nN	73	113682	180282	373479	479290\nN	74	2	5	6\nN	74	157089	226380	517093"
#define QUAL_DIST_TWO75 ".	0	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\n.	0	543307	818625	2509308	4992808	8438377	11672192	13296448	13736670	15917998	17676703	19592490	20442857	22430803	24139678	26624739	29745196	31244672	32704493	35166263	39642628	41752267	45293233	49605769	64252493	77494158	87717704	120721976	146901483	149393136	151625348	153347693	154937276	155953843	156397714	156913174\n.	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\n.	1	750405	1013642	2664817	5263148	7977657	11174654	12793695	13207191	15379692	17130780	18933543	19751330	21736046	23337720	25643981	28584553	30089223	31423198	33799361	38085627	39852462	43240839	47245351	61101269	74003094	83893259	119622924	147591442	149860890	151949343	153559343	155003172	156005355	156430666	156913174\n.	2	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\n.	2	1237082	1421285	2635003	7212072	8156926	9942901	11886233	12785632	15977012	16543592	18523102	20207690	20376865	23216216	25570158	26946722	28671833	30829408	33981651	35042465	41821502	45956280	48350261	57038119	86548360	94146018	113870642	148291330	151434808	152011646	153021431	154725689	156271807	156533367	156913174\n.	3	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\n.	3	311133	872418	2090692	6162260	7545664	9360645	11330527	12344199	14036124	16401041	18438422	19352847	21087821	22300241	24139059	27470227	29584310	31124729	36083384	39495699	43152901	47737420	52841816	70136049	88953752	104397554	120261806	138964594	148323802	150117788	150379200	155591062	156491632	156718479	156913174\n.	4	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	36\n.	4	601091	933522	2562248	6218749	7975093	9850586	11720900	13053565	14971681	16796225	18831926	22163240	23805192	25377858	26351107	28843723	30268931	33827954	34728381	40394883	45475351	50361834	66451744	78487966	101788194	115892627	127335500	139967262	154837679	155221567	156006276	156404118	156718049	156913174\n.	5	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	33	36\n.	5	381394	1051674	2136441	5686348	8266347	9820537	12796885	13674091	15762528	17755425	18880323	20451966	21513841	23300388	26086115	27465353	29949462	33624584	35828711	39635713	42107383	48085681	57108173	73160620	105075699	112698596	131410589	146734211	154862707	155475725	156386983	156913174\n.	6	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\n.	6	646484	1668304	2792712	4806841	7987898	11816943	12434152	12884059	13744920	16768907	18016965	20703851	21892068	24399514	26615013	28967313	30592019	32842909	35973196	38788260	42400017	46805002	59426247	64991881	80692486	105653564	124933204	137663065	145326499	153826336	154255905	154848895	156504571	156715968	156913174\n.	7	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35\n.	7	354853	492958	2028989	5504224	7354062	10043531	11923233	12500947	13584500	16647444	17905181	19670708	22146079	23305895	25574192	27976298	28635218	30033332	31839324	34493047	38708640	41628613	48802970	54158797	62283741	87899656	114735936	127468424	150905152	153170307	154259494	155007607	156542629	156913174\n.	8	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	8	478231	1223133	2470127	5609689	8113174	11790302	12611116	12877229	14750934	17140463	18333669	19937333	21929062	22501625	25394633	26439133	29185076	29823456	34090000	36485375	40459576	42781284	46281571	51236601	56110908	83060089	110497981	131715694	139061012	143034160	151435007	153077120	153793270	154987521	156197537	156913174\n.	9	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	9	462832	952400	1842413	6956708	8621947	10602960	13078322	14002336	16852794	18607358	19971350	20625808	23252211	24391513	25718882	28894676	30248803	35894270	36691801	39684510	41903994	47832190	53052612	58392206	66970188	75484928	95579692	129367214	131325849	145714575	150531315	152888348	154013078	155202346	156373805	156913174\n.	10	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	10	305623	1323449	1373455	4336578	8249395	10977327	14023091	14578112	16901197	17478164	19200901	20584001	22363720	23729766	26340922	27723298	29484534	31802725	34143680	36926816	39936206	42657298	47498536	51144918	57818773	71432996	87186652	120262713	140079502	149105059	150336175	151819867	153063708	155385853	156561030	156913174\n.	11	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	11	553479	866924	2330976	4432768	9119403	10002354	12807631	14870571	15578523	19372218	19546638	21554088	23069367	24023594	26721935	28707380	30620972	34445563	36582026	40580664	42469998	47880828	51248496	57024286	62142798	66491086	81957222	114647818	132151891	148187555	149354458	152008049	153500295	154393089	156378919	156913174\n.	12	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\n.	12	162493	261239	610459	1830416	7886319	8650045	10510006	13396217	13743312	14224778	17589453	18686328	19196626	22377630	24376552	24812617	27219666	29206877	29634047	30788194	33207225	37376348	41695581	46085916	49490147	57293732	67974661	78812828	106665990	124794499	143386920	149992762	152073178	153949708	156913174\n.	13	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\n.	13	67686	181562	254828	1665408	6139259	8800984	10255712	12974012	13257013	13930409	17660279	18172232	20427933	21747303	24395102	26198625	28797402	30730751	33631732	34739249	37948278	40698112	43580040	46618854	54297826	63111358	73029780	86365363	102196032	126388417	142451193	148768903	152459259	154240755	156913174\n.	14	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\n.	14	157628	473893	574213	1981663	6909964	8478940	10459295	12315133	13904748	14280544	17871342	18433011	20794099	22700133	23673365	26062739	27542651	30067671	32876246	34932393	37957405	40849659	43807945	48302479	54062700	59137916	68275701	89953606	110077399	126276373	141833014	150378645	152038992	154375851	156913174\n.	15	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	15	241556	304476	530000	2283057	7214403	9472152	10860885	13773512	14137167	15433032	18484598	19704073	20633939	22334096	23907200	25507333	27217126	29158657	31414509	35019900	37021652	38965402	41695066	44203785	50419835	55697164	65748857	80066240	94938310	126706720	138086267	139562268	151213217	152975695	156529338	156913174\n.	16	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\n.	16	402981	447558	499515	1902974	6341732	9886998	10331606	13912257	14841367	15327750	18907064	19883127	21380590	22961242	23963582	25001100	29416247	32572919	33233465	35262801	40068425	41996107	45792531	48678722	50640637	59946428	69203018	79999976	95960459	120117770	135467083	138570698	153842635	155613506	156913174\n.	17	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\n.	17	92564	226299	632853	1415656	4400149	9063421	9300355	12217954	13514101	14617769	17745465	18731875	20718711	21708049	23547253	25286485	27397631	28420075	31998007	33436282	37763143	40403659	44553032	49619069	52099174	60647713	72195242	81518855	91131182	115944099	134888130	143021141	151942856	153927807	156913174\n.	18	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\n.	18	105935	126960	246913	1281729	4884352	8488939	10134483	13087240	14524797	15233341	17199211	19148085	21598741	23441700	24751945	26368050	28519730	30209378	32965939	36616381	38507442	40563818	45995578	47545160	53371753	62838074	70683100	80006231	90484661	109656243	130147788	138721166	151623173	153726737	156913174\n.	19	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	19	663174	710508	875455	1631825	5691286	9531069	11176198	12081115	15666177	15728653	17684412	19837767	20461094	22061071	25244923	26083793	28185484	29290261	33414815	35449073	37422011	41756166	44202323	47240174	51840630	57229474	64048458	83804963	92239299	107893593	128802508	144346160	150121656	153608512	156341141	156913174\n.	20	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	20	52372	558857	708625	1609140	5042146	9036341	10475656	13039290	14660808	16051398	18201896	20429768	21659959	21898578	24760982	26335868	28160094	31637562	32644823	35330183	39185229	42659234	44928021	47987753	50316494	58995558	67734646	86921238	93295828	122552051	138030726	140567367	150879591	153516223	156243036	156913174\n.	21	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	21	81961	145236	264266	738971	3874431	9100646	10319783	13872910	14798482	15470750	16812304	18761777	21185845	23750775	25880441	27682306	29004711	29211314	32026856	36893084	37886258	40813371	44860003	50318568	53861734	59975689	69168504	79320982	98421857	115560478	132168468	147116444	150843038	153328024	155614480	156913174\n.	22	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	22	499184	594814	677749	1865110	5321340	9940658	10972537	13642695	14421854	17039714	17419698	20506595	22507401	25029767	27470989	29016872	30172529	31316176	35741435	37163387	38747277	42903287	44448708	47381826	52694061	60053179	69242837	80161853	97436799	109922921	134466878	144416363	149427304	152377061	155518014	156913174\n.	23	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	23	86665	235758	331381	904315	5663840	10656109	12809816	15586415	16444250	17263431	18267949	21367083	23281887	25069385	27524414	28105182	30117054	32366460	34515768	38242569	39301330	41180082	46314753	49390096	51965601	61328818	70131939	80726259	92458686	115004266	134299982	139126929	149206200	153566526	156543986	156913174\n.	24	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	24	66254	374974	681340	1492473	5381383	8903120	10991109	14632225	14962663	17820608	18083920	20973585	23564186	24414874	28411482	29952447	31179309	33111228	35768233	38630267	40215392	43599348	48187962	52407829	57128491	63498776	71050338	91515282	104434644	123467899	129303382	138184774	147787154	151755067	155942295	156913174\n.	25	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	25	470340	596259	751317	1328854	4244241	9818411	10784365	13418030	15560691	18306629	18358414	22486067	23522439	23672266	25980895	29514646	30969978	32440937	34188121	38526998	40846236	44639710	48852283	55431829	61155457	67561994	74257393	83189374	99477990	118863929	125389577	141046533	147835810	149868983	154367761	156913174\n.	26	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	26	81171	384490	603997	1032982	4597749	9840527	11852112	14890238	16631555	17634384	17934025	18970342	23193710	23741401	26784580	29797972	31310783	32117072	35508735	37909635	39945785	43043918	50242339	52087819	58226922	66447563	75076154	87618343	107052498	114308391	133858603	136622300	150080249	152826705	156585194	156913174\n.	27	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	27	134595	292016	1532078	3882731	9098050	11235309	13876999	15865649	17279368	18148656	20435778	22275448	23315232	26354929	27886712	28552156	31948621	33467396	37546747	39627537	42947532	47645256	53537041	58618213	66624557	73454886	91493007	100803233	116187805	134971527	144562700	148039885	149822426	152564438	156913174\n.	28	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	28	329307	532295	902960	2784117	8240218	12345613	14790946	18148996	19137085	21276287	23495436	26335582	26931070	28648357	30512123	32962164	35269645	40072631	42494560	42896257	45650073	51238148	54956301	59422776	65578756	72855068	81141927	93172762	107383211	127352125	137449646	145060293	150516681	153269480	155668553	156913174\n.	29	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	29	94869	159133	410863	2831932	8450600	11787803	14545671	17928797	19212782	19595441	21358111	26800835	28127726	29775028	32535093	33963031	37053257	41356593	43591171	44919271	49225898	53562629	55166264	60885106	65776750	73096883	79409738	93929714	104524353	116726084	139857068	142689364	145810931	152627047	155183585	156913174\n.	30	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	30	87959	577534	2374263	8362773	11739533	13305887	17704466	18641012	19175108	21740967	23892893	26447531	28105619	29439694	32267297	32719645	39692296	42011462	44301221	50435510	55790634	58922260	61818366	69033320	76074876	84344514	95510665	108732405	119746518	133998674	142199699	151618340	153338469	155992145	156913174\n.	31	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	31	99275	315989	838127	2772733	10730376	12647890	13867130	17612079	19015905	19285186	21798066	27346547	28043400	28817588	31069948	35329237	36878404	40660544	42507942	45299449	48359176	55520882	58242511	65479689	71733296	78184363	89088486	107740821	110812075	124452581	134721413	147782078	151947535	153036250	156657599	156913174\n.	32	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	32	27894	198997	810589	2967386	8075055	13066076	13168810	17828931	19888955	22145494	23317971	25771845	29398867	30344927	33634397	35569445	38246675	41304749	45028273	46983184	50128181	56274911	61921223	65245549	71301522	78321855	86325548	97394509	116736739	130539987	138304667	146113929	150956578	152728573	156363244	156913174\n.	33	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	33	236454	342546	968812	2684844	8188199	13177636	14118323	16798820	21369222	22747525	23074425	28257724	28819841	29624248	32514553	35835822	40626296	42619794	44445912	46722843	53413227	56232610	59566607	64754839	69382020	73250203	84568819	94710367	107170561	125698371	142378022	145671059	150457072	154245742	156608621	156913174\n.	34	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	34	221831	430431	2939194	6639282	12908697	13881643	15486137	18933761	21035150	22468277	23999869	28348923	29752998	31170583	34742952	37163217	42175559	45549901	47214375	49615852	56087092	58689458	61268657	70312838	75529725	86986892	96146087	114561526	121473110	134668609	141814878	152329850	154332760	156378806	156913174\n.	35	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	35	53516	117251	204592	1463896	8438054	13259406	15198111	18792934	21402597	22738990	23167623	26858674	29356374	30344941	32556491	36843782	40403926	42532274	44747527	47434918	50070183	53353900	60259980	63253846	70376337	77286833	86703396	105347701	112919369	130197899	138525385	147319743	151758867	153860316	156592429	156913174\n.	36	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	36	237778	346990	896478	1998061	10706776	14712395	16548260	20023801	22243393	24936242	26482185	27703713	32002255	32993548	35729432	37945646	39959989	41527237	45906722	49438288	53753827	56283427	61655442	65741870	70667571	75554626	85793707	99360200	111914378	128043677	136375208	146403178	150412621	152134666	155993651	156913174\n.	37	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	37	273657	460786	799595	2010471	9095615	14072242	15767325	17294076	23603430	24986985	25535526	26873137	31198657	35364718	36013363	40941880	42475897	46172256	51171261	54230211	57309529	61408459	66438358	71341946	77345438	82190668	88223093	100962154	117253483	131157363	142834791	144336122	149026639	154319727	155832041	156913174\n.	38	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	38	423562	644563	776271	1801410	8849218	14789044	15775439	16189198	22727031	24110470	24420743	28082315	30990050	33773715	34666083	37767461	40248841	42915847	47408967	49323922	53497538	56299098	61099472	65206618	74327994	78380349	86285994	97284442	116213878	128060126	141169824	148062925	152410193	154585523	156643322	156913174\n.	39	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	39	403549	466998	1408784	2304322	9654744	14932696	18251795	19943593	26365115	26672748	28427456	29112438	33252817	36246726	37915645	39682379	44229291	48224717	53136595	55678371	57487925	60747409	67004943	73988893	80409875	84774292	93366125	102186260	121259160	126945949	135043715	147565658	150201311	153004797	156177710	156913174\n.	40	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	40	541854	633487	715726	2025191	9178647	15583565	16747146	16871074	23344673	25566632	27086808	27640037	33753202	34358765	35553820	38983056	42929353	46551094	49681909	53642924	56001101	59390848	65350150	71052677	77399881	85713144	89827631	103888114	116007250	124960049	139804687	144927021	147829548	152572560	155222559	156913174\n.	41	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	41	169314	315950	365306	2200968	8766932	14590680	18332104	19649961	22533608	25811159	27449245	27979663	34074942	34803160	36567289	39059656	46012603	46671598	48769552	52883790	54923976	59854323	63606567	70461817	77997054	85011012	92099761	105220319	121234343	128415533	137579079	145015981	146717081	153158021	155815700	156913174\n.	42	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	42	139845	179903	639893	1975970	7971666	13288782	16400707	18760186	19742175	25282629	25301700	27037416	28788719	34112338	36043161	37542607	44343751	48265871	51095309	57566814	61035580	62911340	69179860	73158794	78487929	88869278	94510267	109713145	125499416	129397016	136732352	144828061	150722885	153575458	155890119	156913174\n.	43	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	43	255922	409427	632248	3237082	10392072	15878172	18815279	20018576	23424805	27741565	29089938	29891857	31446541	39459265	40985378	42469071	46135968	50176199	53792435	56776150	58810060	64808747	66663673	72913623	79690771	87094004	95801564	111109692	123725684	134221102	138796753	145267531	148251805	154466992	156647915	156913174\n.	44	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	44	433237	464784	759304	2120758	9648099	15429970	18589647	21122091	26792754	27707910	29257763	31495551	33803934	38889349	39844748	42428266	46051147	48863422	53585581	54564468	61421124	64549646	67158090	71925642	78674226	86309046	91192089	101244002	122496127	134169319	139701066	148180690	152071046	154209406	156378173	156913174\n.	45	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	45	342948	723725	1044641	2733645	8155686	14759370	18450754	19665780	20320976	27867935	28171703	29702998	31608476	37079605	40979685	43705853	45216891	47633033	51219094	55162864	60795599	62786730	64932957	77074426	82726773	92776496	99502768	110424224	123551245	133179673	135764679	143741692	150967409	154155672	156325293	156913174\n.	46	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	46	306811	692082	793760	2967662	6893645	15385802	18285619	20086729	21986367	27851995	28565627	30230620	32315889	40898545	41791082	44965548	49563424	52645503	55486165	60378775	62293697	66520161	68064883	80508579	83610922	92208746	97659161	118456206	125845832	135373833	144433900	148719884	152037271	153706725	156633031	156913174\n.	47	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	47	299398	561789	643975	4069995	10179079	16954034	21229100	23094609	25346891	28967818	30265615	32483348	36652441	42118113	46224347	47543780	52977695	54414443	60983427	62509946	66857643	68610106	77293069	83960793	87818545	95940748	103206311	111496110	129146706	135074746	143930141	146705024	151811065	153608456	155975961	156913174\n.	48	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	48	741074	1125847	3198469	9920016	17350847	19864244	22682644	22948684	29991773	31667221	32229253	34440961	39222652	43461893	47098886	50486901	53501533	58466112	61674869	65183885	71093120	78642839	82554918	87222692	96170844	105067923	115530802	128722393	140744121	144004838	146430013	149605630	152112254	156702380	156913174\n.	49	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	49	653211	790306	1236598	2323829	9869602	15692486	19889792	23273936	23369535	30976280	32388077	34441074	35116528	39198244	42069583	44026561	48180308	50768842	56151932	60399163	65769850	70288350	74138820	79752271	85966670	94175937	100273122	114369246	124424873	137312560	140175220	147857637	151479917	154479240	156014185	156913174\n.	50	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	50	264169	548866	827464	2460068	8792301	16190305	19322913	21206181	22532668	28256654	31689721	34509764	38729250	41575600	46523878	48752863	53132365	55309342	59763803	63473371	67035761	71751618	80195201	84282173	88873358	94007342	98539140	115901728	128116668	132103638	143279125	147446126	149933125	151211357	154565779	156913174\n.	51	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	51	44793	612886	3319710	8577937	15647849	21137114	21789568	23275823	30650550	32651296	34126616	35990786	36563079	45203972	47650648	52993824	55401088	58692746	65581486	68405128	75233349	79531059	85627154	91377103	99087444	103290747	116623115	128550078	136893191	141064960	144819415	149594875	153394681	155108292	156913174\n.	52	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	52	428681	473655	728637	4733776	11251613	18774408	22020533	23940849	27160741	33022537	35230606	36727778	39170739	44443316	46667840	48709807	51063015	53252477	59164929	64856770	69126438	74178090	79883083	87402352	96826207	102109403	106529035	121734284	135827224	140564775	142418487	149387189	151718275	153730435	156427585	156913174\n.	53	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	53	666885	715714	925303	3825523	10797997	16561190	22382130	24199685	27203266	32970685	34431904	36460653	38434732	42913232	51086542	53713395	57915044	61683535	67785111	70665499	75773137	78951412	86756325	94668164	100454279	104957007	111832484	118241319	137546062	142756085	145356308	148271305	151745297	153461161	155507054	156913174\n.	54	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	54	333949	646034	1021385	3474483	9897880	18193781	21521459	23702338	25158719	32604641	35501474	37620984	39553931	46949872	51182667	53537699	54743142	59405989	66922826	70303310	73971673	79668112	83765508	90406212	98593155	105403441	113184185	122528416	131518115	139356945	142189148	146968564	150614651	153648259	156277377	156913174\n.	55	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	55	325845	505024	930409	5631198	11171441	17208045	21305698	24114172	29092813	34448896	39455803	41223076	45266747	50151564	51194682	56596059	58657348	59665096	65997176	70446148	76831479	81622487	86876174	92971268	99824177	104891038	112604535	117599184	130454641	139131836	142237658	145674253	151686208	154785703	156336036	156913174\n.	56	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	56	310958	432562	949909	3749462	13266131	14985272	21701879	27513166	27578012	32704961	38342378	40237504	40776093	43149012	49636439	53263390	57985220	62087422	67783868	72218196	74665562	78985366	86390757	95642465	100594150	104796419	112330132	127084132	137433854	139516106	142451344	146423895	149967385	152964022	156652569	156913174\n.	57	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	57	628514	980453	5943864	12356596	19906471	23569957	27123779	27310157	36792105	41514477	42820829	45051752	45681728	53278804	58811888	62333294	66574023	69330395	74164450	79316700	82736895	87758156	93058533	98809035	106639216	113042478	122759373	137730812	141959551	147182193	149908584	151443777	154482298	156639696	156913174\n.	58	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	58	1580522	8024851	13542724	19873217	27826529	36379378	38333824	45036544	45518012	50591320	55698786	57033648	57206877	59655381	64871282	69103048	71220238	74130349	76573563	82710696	84921066	91096213	95892084	102074877	109928190	115438395	118860118	132533444	138072733	140509744	143550424	146014864	151294228	154262344	156098551	156913174\n.	59	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	59	2999096	5634075	6433037	19375202	32166905	37351694	38806996	45394307	45749895	51284967	56384999	57708138	58173110	60727112	67748981	69589386	72009797	76717096	78784088	79896709	86565734	90522504	98729458	103089209	108783762	115301734	125804433	132797181	138958840	143836111	146681032	150173112	152957679	155298178	156569762	156913174\n.	60	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	60	3252311	9370448	12353825	15647945	29405759	37029009	38995575	45902257	46262352	48632766	54976346	57882626	59154306	61507949	65299163	69469470	72668381	74709720	78554311	84961533	89878876	92495580	97396134	103687086	112793529	116639886	120969842	133243134	140775904	143152431	145995471	149954350	152123042	154253814	156178368	156913174\n.	61	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	61	4065987	6678370	8613498	20892335	28875065	37512567	39481830	45721149	46789755	52442674	55751648	59332119	59914449	65539178	69121009	72372818	74224930	75241442	82879323	86780714	91503658	95458143	100309858	105471390	114318736	120163593	129478979	136794451	140817499	145083676	148816849	151514856	152930895	155511760	156590364	156913174\n.	62	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	62	717500	992323	12771740	16759114	32410051	38235924	40759413	46239717	47376109	53244726	56417295	60272211	60464234	63003776	64442218	73131952	75551022	75843807	81830712	87818334	92525731	95053711	100977305	106512607	114433807	117868655	122467374	133633787	137724255	144727100	148447942	150082286	152998518	155467731	156700214	156913174\n.	63	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	63	3496476	7298958	7687604	22770852	29648748	37870305	40676662	47056031	48221718	50744278	58878224	60336927	61757544	63819147	64735618	75314647	76241553	76853620	81182992	85549011	92045380	95173116	103553945	106550033	113169620	119220286	123086315	137779096	144243465	146585994	148978344	151641297	153275683	154930385	156483374	156913174\n.	64	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	64	380656	4151852	10127238	16645327	32733019	36178059	41022319	47969225	49253514	51823306	58635964	61382474	62863175	66024155	66321812	75558155	78092364	79428714	85291831	88736221	93139684	97446601	104724213	111554804	115659574	125935244	131679378	140710419	145484825	148186935	150899037	152281943	153789911	155523686	156695126	156913174\n.	65	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\n.	65	690348	749979	7558838	18713312	27579582	36813055	45742837	48525795	49704379	50761794	59269394	62474835	64091930	66473147	71510415	75361344	79880937	81383479	83281852	91254867	94051857	98496077	102698963	113090430	120253052	122454977	125630338	137669101	145444424	148423391	149885755	151235188	153421414	154594496	156053977	156422118	156913174\n.	66	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	66	784908	3332391	8571672	19104287	29239973	36352947	41808923	48435730	50408149	55287706	60400344	63496665	65255858	65693120	68945574	74573566	80219837	81157272	85428770	90468404	95803632	98622646	109704308	112903929	119624177	122790356	128284688	140607436	146285254	148571403	150120547	151664951	153575882	155064890	156374767	156913174\n.	67	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	67	1026800	3914226	22150048	32885387	41385303	44441333	49725647	50939915	53033152	61901276	65343077	66661255	67997087	74013897	80681476	83172820	85326408	89678027	93393614	100156305	105742656	110379709	121167668	125738280	129108535	135038016	145800654	147670456	150036811	151755443	152722110	153752267	155954255	156506780	156913174\n.	68	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	68	3003253	3283056	17322403	24713842	35205749	41792868	44532272	50185294	52321909	53242440	61637858	66249955	68051913	71375271	72200010	82047584	83033782	87607220	91431479	96705952	104886358	109274579	119172450	121327923	127465359	130299923	135962853	147104941	149030990	150780892	153428810	154220689	154820857	155867106	156647127	156913174\n.	69	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\n.	69	3424701	11001473	24008951	36625662	43165403	44444060	51601331	53583345	58845212	66750096	67441008	69722676	70654890	73573227	80285717	86375908	88318745	96058166	100056308	107095301	115905573	122349507	128440416	133177479	136087358	145183502	148326816	150147056	151624346	153493176	154146276	155160567	156380959	156913174\n.	70	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\n.	70	565686	1461438	14909089	25850826	35084176	39486683	46561857	52210919	55432495	55850728	64851435	68466086	70936147	73887263	75688986	85106140	87388577	92157675	99186103	103164332	113516401	117635610	125793732	131924578	134531613	136888208	146190471	151244979	152257187	152919763	153722204	154766812	155723925	156437284	156913174\n.	71	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\n.	71	3291271	7410200	14757955	23487190	38546570	44571739	48035519	54134592	55415635	56898361	65470547	70584169	72559045	75599151	82388207	86224335	91497733	95576488	103596614	112161754	120747827	124778135	131718587	134205016	137179959	139808310	150834190	153050964	153775459	154131151	154831953	155275970	155808216	156497106	156913174\n.	72	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35\n.	72	3785258	8955068	16449174	24232637	38755239	46043153	46520363	55444205	57862731	58541146	67693998	71899651	74462072	75463959	85641116	90451082	92875460	103723143	112366658	120582796	126553433	131851075	137133859	143064424	144877439	152673584	153378606	154026230	154784932	155770448	156272015	156417059	156769350	156913174\n.	73	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35\n.	73	3595867	8460324	18942232	28529201	39277152	42590317	47753239	56807009	58546703	60049346	69181186	74509793	77291573	80855683	91218405	94689603	99628297	110920802	116803164	126045827	132465083	136823140	145201985	147766878	149552255	153200316	154545372	154928075	155264301	155991503	156100886	156467627	156599198	156913174\n.	74	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\n.	74	368278	7737059	8524498	20327251	28479281	40848395	46934241	51486514	57709526	60583498	69601683	75061528	76841633	78242448	87680818	90213732	99519563	108394243	117548105	121537779	124848840	129984465	134948501	141948752	143753879	148261298	150587855	153418604	154049881	154564243	155088516	155771793	156115230	156706437	156794919	156913174\nA	0	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nA	0	133132	171394	527067	1106962	1753346	2514994	2930898	3040884	3625234	4189250	4702426	4952889	5603308	6128823	6920080	7967103	8550248	9074013	9858760	11492355	12234057	13527044	15081698	19860272	23766685	27349899	37092893	44000096	44868094	45523179	46039321	46599707	46926670	47034835	47203865\nA	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nA	1	141184	177693	539580	1157784	1802408	2602160	3029699	3143338	3766523	4309807	4821375	5069029	5713946	6232554	6971944	7969935	8518419	8997025	9785305	11385232	12001495	13260269	14706186	19321122	23213296	26733532	37799155	45358696	46114359	46741479	47233841	47713573	48037012	48141066	48292731\nA	2	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nA	2	217739	259583	519936	1579900	1727526	2154831	2655349	2857110	3742984	3894286	4429167	4891443	4931388	5786205	6522205	6952272	7479681	8221760	9171331	9519842	11243249	12730845	13568764	16089066	24757741	27336309	33236381	42402415	43415883	43560873	43839800	44428361	44954530	45019571	45132758\nA	3	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nA	3	49931	119913	375065	1328831	1599749	2065481	2572178	2807448	3275564	3931582	4473686	4707190	5186049	5571482	6146559	7198102	7888333	8364394	9782017	10987751	12319403	13991650	15775135	20435586	25835167	30593935	34988391	39741119	42259233	42804614	42875055	44143489	44438494	44496709	44557937\nA	4	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	36\nA	4	101238	157808	465746	1272021	1705492	2184277	2682354	3015291	3532987	4035419	4608437	5558813	6021668	6496046	6805702	7621931	8110218	9327580	9448787	11392670	13177409	14513200	19495755	23166130	29853900	34135276	37592140	40889976	45022054	45126690	45373966	45504214	45606591	45663829\nA	5	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	33	36\nA	5	63904	193544	435380	1252974	1718784	2115399	2845140	3059771	3601520	4130978	4421986	4845472	5148832	5653952	6496413	6879093	7644345	8877667	9552381	10836781	11675369	12969767	15608245	20375410	29375061	31839191	36978548	41138691	43343262	43520325	43791410	43941694\nA	6	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nA	6	89086	333112	582601	1095064	1806609	2797103	2951315	3079401	3308672	4166407	4485181	5272136	5600304	6379845	7069110	7831295	8371738	9108552	10047434	11020360	12284978	13868982	17431422	19323010	23938461	31343694	37245109	40453560	42590157	44919012	45014558	45219018	45749872	45802728	45874620\nA	7	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35\nA	7	59608	69599	388321	1178750	1694746	2401596	2900027	3037171	3326155	4197638	4562432	5077028	5829788	6152929	6896550	7703223	7912234	8348108	8781569	9746597	11072750	12123777	14221038	16037126	18756982	26258603	33939277	38003993	43895183	44623425	44960013	45195314	45683953	45764856\nA	8	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	8	107801	257050	487768	1120013	1719847	2563519	2755657	2823288	3310835	3928671	4212446	4630166	5190635	5332579	6186831	6500937	7331864	7507273	8723952	9475644	10808668	11565342	12741328	14404187	15850580	23117698	30769164	36214439	38206170	39385692	41672043	42151956	42378011	42726350	43084282	43353496\nA	9	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	9	120529	210654	404810	1546648	1915404	2433896	3078411	3309268	4082798	4592983	4951541	5155005	5940923	6302201	6701317	7741188	8175309	10121490	10323270	11360075	12004768	13584701	15471680	17447346	19882737	22710909	28762888	37937911	38616556	42447912	43686689	44471432	44842760	45124710	45486747	45676823\nA	10	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	10	47373	274935	290422	952349	1787149	2456944	3208840	3307997	3921892	4038030	4512767	4896092	5382615	5772339	6583838	7005056	7572105	8297890	8793627	9727579	10723398	11669925	13396749	14628767	16875732	21000223	25435284	34350237	39125371	41723896	42130170	42571999	42979318	43667454	44025380	44139503\nA	11	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	11	68187	132276	421583	841297	1911391	2125059	2863704	3297734	3478879	4509260	4560855	5144156	5532363	5760274	6550139	7189068	7790840	8993748	9491502	10888261	11544591	12967230	14138285	16184020	17895818	19316422	23604472	32263373	36990187	41316634	41680397	42566340	43034654	43219288	43830682	44017031\nA	12	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nA	12	45381	73653	98471	324368	1724641	1868464	2282575	2975071	3058831	3177697	4097751	4377265	4514059	5430697	5994934	6118028	6879000	7492924	7604318	7967546	8788711	10069100	11535316	13117832	14092707	16565094	20174694	23698063	30800407	35359546	40151328	41949002	42601023	43166735	44077784\nA	13	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nA	13	22033	49289	68543	327139	1314257	1907963	2267541	2934754	3003391	3175744	4187650	4278743	4863493	5192973	5948721	6518760	7299737	7925236	8595030	8926807	9993094	10863339	11874635	12983169	15249897	18200729	21483999	25142175	29423221	35458384	39840484	41515488	42706131	43180693	44005727\nA	14	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nA	14	39198	82232	104925	392984	1617190	1892319	2338623	2824643	3221033	3325339	4327136	4486417	5131175	5660731	5914456	6694475	7131422	7908256	8592978	9261021	10274466	11321732	12297627	13878130	15352996	16963201	20019333	26525957	31622894	35879414	40033045	42438201	42988248	43630854	44426495\nA	15	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	15	60256	77362	129101	509774	1508721	2014704	2391854	3121092	3213757	3513740	4373524	4696726	4933221	5436631	5901922	6363818	6898201	7471766	7948870	9179218	9779748	10453511	11434295	12185684	14274048	15832359	18770055	23576772	27635857	35351990	38225041	38659064	42044890	42536986	43650077	43777796\nA	16	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nA	16	43490	54220	70798	273022	1262998	2026322	2098846	3019775	3229979	3360624	4338273	4569859	4990478	5439405	5713107	6038910	7370068	8346071	8428569	9080972	10703697	11365093	12654447	13640714	14266670	16834887	19942616	23523425	27892615	33927352	37770364	38704374	42800960	43195816	43611946\nA	17	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nA	17	26416	42287	116350	254201	952923	1944482	2002974	2773456	3079553	3334929	4215086	4467845	4947607	5238448	5742878	6293650	6938449	7219588	8375956	8789058	10071839	10938420	12325374	14059861	14825926	17180659	20927781	23972365	26807647	32830272	37411339	39672666	42036953	42559976	43451684\nA	18	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nA	18	33827	38762	65566	249045	1038500	1840126	2211691	2993591	3351253	3503032	4076127	4599782	5262365	5765856	6090124	6555447	7228825	7739295	8536658	9778170	10216294	10900928	12799853	13215747	15221517	17936154	20415228	23501258	26672223	31355402	36482640	38853627	42312440	42888068	43840546\nA	19	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	19	72327	86473	111204	309831	1312734	2252640	2710608	2862582	3824874	3848292	4425912	5046999	5229037	5700720	6642680	6897484	7587463	7931448	9135505	9840497	10496677	12061465	12829143	13905241	15428272	17181567	19354916	25884516	28176937	32674813	37499592	41415047	43293047	44328319	45137879	45338492\nA	20	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	20	14318	61386	98040	267093	1075393	1948923	2296750	2955077	3392200	3744815	4349449	4964589	5302563	5379407	6264097	6723906	7306747	8393555	8671032	9598263	10685339	11857812	12678404	13329323	14102158	16821847	19711895	25557507	27656186	34780061	38568131	39398871	42246578	42974976	43829542	44055816\nA	21	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	21	21966	40776	54918	139710	791270	1996996	2275582	3213880	3440830	3601966	3912463	4462635	5126004	5779419	6374436	6912457	7324708	7394166	8231354	9778481	9908414	10903477	12288068	14158095	15299514	17155229	19794614	23069449	28164895	32142457	36549874	40520280	41676645	42452682	43159493	43590680\nA	22	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	22	44672	70035	93468	301475	1071266	2177887	2420995	3142818	3312646	3954391	4060774	4894567	5469692	6120650	6838705	7298573	7654030	8019087	9408359	9839115	10312339	11781880	12130063	12879646	14680843	17053313	20171274	23868253	28472985	32180754	38224024	40389915	41942527	42748034	43651638	44111567\nA	23	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	23	985	47153	74305	191041	1298888	2438103	2987776	3749364	3974484	4203794	4468118	5369109	5861657	6395263	7066544	7241659	7849945	8540684	9153358	10395096	10716038	11368749	13012154	14078997	14926860	17785905	20627682	24183986	27811021	33570923	38480732	39767169	42475357	43744023	44677410	44801576\nA	24	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	24	17983	32894	109535	305106	1262122	2118763	2539764	3501113	3571171	4304064	4387483	5169209	5922501	6172907	7357227	7760155	8147490	8766120	9612431	10565227	11087797	12123219	13650266	15159153	16556195	18650705	21152032	27389492	31508467	35790447	37178543	39708090	42264544	43562749	44850410	45199356\nA	25	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	25	60572	96765	130796	264767	928071	2270544	2494086	3214064	3785372	4494010	4514297	5705083	5997910	6049805	6752227	7778570	8228498	8704419	9260194	10613467	11386809	12697532	14011024	16189916	18049852	20240237	22279365	25278911	29211394	34694889	36624994	40664599	42369120	42892254	44252254	45135769\nA	26	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	26	26919	38753	90096	185428	917940	2138006	2585244	3342329	3814412	4062032	4149704	4408791	5582963	5730950	6523239	7420486	7873734	8108411	9160630	9912371	10565172	11606993	13814246	14437888	16477651	19031735	21894974	25960000	31135017	33296256	37731380	38583071	41848249	42686610	43630077	43740455\nA	27	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	27	36235	59912	289437	780545	2081706	2650400	3363023	3918365	4279975	4537898	5203349	5742832	6051041	6971927	7398081	7603124	8674913	9203068	10537802	11220681	12226736	13867799	15697400	17451554	19986481	22117537	27857603	31046576	35390759	39704818	42117649	43176570	43757175	44617246	45654013\nA	28	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	28	21487	72394	151796	616366	1790996	2725355	3264854	4174703	4416171	4919384	5533924	6322307	6489630	6975439	7528095	8205967	8896081	10423467	11239242	11378610	12194523	14117290	15276381	16596322	18782152	21045442	23577508	27538774	31329666	36497142	38507557	40523263	41830196	42579466	43296686	43736560\nA	29	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	29	29764	47303	89372	650876	1926421	2645396	3272494	4184082	4493380	4607910	5016472	6509532	6863218	7349155	8193782	8617224	9552634	10790729	11508067	11934435	13222961	14636022	15195448	17168066	18796149	21316076	23153611	27784647	30814487	34107083	39303627	40174586	41085000	42741925	43537762	44136832\nA	30	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	30	22728	101989	536586	1820016	2596945	2962176	4119692	4344589	4487764	5067725	5649130	6389900	6829915	7202507	8048627	8186431	10324719	11103113	11764481	13586979	15235831	16184998	17182637	19517698	21831063	24591846	28077276	31771276	34660690	37496448	39506666	41975883	42446319	43258669	43566301\nA	31	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	31	31003	60407	181863	597203	2455499	2771906	3023436	4036838	4354294	4434798	5039890	6534904	6715748	6925433	7550992	8815242	9298325	10417200	10984733	11841732	12772769	14887020	15661209	18037754	20212942	22231973	25507515	31396929	32231565	35801034	38349518	41035113	42260411	42551585	43639544	43723250\nA	32	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	32	12022	51853	168477	690178	1752284	3045606	3075749	4355301	4842458	5414782	5754585	6479690	7446592	7725717	8705237	9257090	10054444	11030821	12256346	12927761	13931084	15713975	17716683	18859723	20773543	23057237	25681128	29166086	34891881	38472428	39960772	41970418	43149773	43670847	44857130	45059754\nA	33	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	33	44379	68760	186654	634823	1660593	2840800	3059825	3684991	4894311	5229287	5313801	6748463	6906215	7112903	7872295	8838674	10161139	10674294	11301888	11974079	14082707	14938061	15982318	17699346	19355334	20585149	24304478	27617671	31175876	36020958	39524245	40416719	41865445	43007123	43690123	43791601\nA	34	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	34	35316	90017	705906	1590658	3047191	3282367	3720636	4688320	5108337	5467672	5902513	7158438	7547483	7967714	9038085	9796656	11269582	12396497	12936832	13547309	15780686	16687966	17575711	20567923	22287493	25999724	29024896	34343752	36324366	39204682	41145289	43644439	44147771	44709768	44887341\nA	35	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	35	17711	35546	58571	315119	1799214	2991770	3316173	4266941	4931096	5275163	5387208	6383071	7114920	7375327	7949480	9122070	10213358	10893317	11572554	12327321	13200663	14252570	16621895	17534215	19935156	22115183	25056017	30577549	32739505	36905979	39178176	40970923	42020611	42571947	43389496	43497511\nA	36	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	36	56919	66437	155198	399989	2356146	3309237	3635182	4509725	5135196	5768916	6157105	6462082	7701422	7970082	8743156	9429312	10039944	10495777	11846513	13014554	14304901	15103320	16894287	18316930	19882869	21474920	24671642	29110677	32836064	36166383	38370461	40605980	41744989	42181647	43336685	43626911\nA	37	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	37	47404	47765	129497	341824	1779235	3058239	3459490	3792358	5433324	5774722	5924666	6265349	7524153	8554324	8743870	10132593	10619277	11753663	13331039	14239714	15228024	16538932	18216590	19916578	21897585	23356244	25252481	29278391	33753657	37263252	40076754	40503201	41685503	42742641	43180654	43525688\nA	38	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	38	67596	78417	102316	301445	1877415	3305420	3535018	3645335	5353173	5686212	5782872	6631676	7443977	8273419	8517901	9420430	10127885	10979264	12395486	12921880	14319966	15196067	16765456	18008786	21062114	22324969	24893359	28272582	33161367	36023374	38984199	40960127	42195021	42764408	43336032	43426070\nA	39	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	39	31395	51867	170067	363950	1903994	3224723	3983858	4374073	6066639	6142431	6598343	6790327	7930483	8786527	9294490	9798573	11176250	12387184	13781268	14614884	15111567	16187725	18218839	20630558	22808850	24202818	26941570	29749538	34800997	36326853	38428808	41062500	41778533	42566380	43338372	43566290\nA	40	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	40	65520	70820	92891	350523	1912793	3484655	3758791	3794774	5405698	6007854	6389995	6547407	8239701	8418626	8721290	9757178	10854880	11911045	12824314	14078380	14780045	15694713	17678048	19592793	21714650	24401314	25768569	29998955	33357235	35672900	38517083	40050791	40853815	42293664	42974003	43512094\nA	41	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	41	46067	78556	90839	402686	1907669	3287007	4134970	4382844	5161709	6039464	6447515	6598583	8302574	8519174	8979165	9604084	11730143	11936570	12605476	13803758	14476808	16153094	17384460	19495057	21819749	24094263	26471071	30541511	34626587	36719060	39197390	40448566	40844207	42293600	43044192	43408844\nA	42	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	42	28206	39252	123186	360633	1724933	2886943	3702244	4229119	4480637	5974768	5981793	6434437	6872661	8432157	8908711	9352966	11114959	12299664	13151945	15213326	16328932	16937133	18824699	20115090	21781274	25231252	27101715	31484552	35550416	36662590	38550629	40187172	41476511	42251914	42912132	43270311\nA	43	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	43	38470	70146	127471	606492	2084241	3553728	4192799	4475897	5418515	6517452	6853911	7075749	7452313	9740174	10222582	10624677	11612162	12854949	13942098	14930694	15540503	17478178	18051185	20124236	22318061	24791084	27604268	32087995	35482877	38015842	39399401	40408926	41216209	42689542	43275290	43363465\nA	44	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	44	64341	70255	145037	382120	2017612	3402857	4123087	4694751	6215952	6468693	6802918	7348184	8024928	9447880	9701913	10367153	11444867	12239824	13660311	13964870	16172068	17245635	18038139	19624332	21764295	24292919	25824352	29024271	34750245	38083791	39630817	41041380	42089376	42693921	43243518	43418246\nA	45	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	45	21283	91315	140288	443707	1714641	3228061	4143260	4430802	4585703	6613833	6709836	7079691	7549564	9115060	10229193	11049798	11511634	12169247	13262677	14376388	16157717	16783624	17450131	21374352	23238423	26426419	28297272	31416885	35142232	37687971	38484520	40189504	41930035	42668433	43291633	43485187\nA	46	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	46	56049	86641	114973	556510	1351788	3413314	4187195	4643032	5136334	6728102	6928176	7365488	7883366	10241348	10503176	11379424	12723604	13718337	14544949	16143974	16728933	18066254	18537649	22530862	23413711	26158836	27861345	33513681	35937415	38459222	40255571	41549856	42371344	42823189	43655873	43745579\nA	47	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	47	64998	65613	89631	839353	2042334	3793419	4686308	5136769	5803973	6785856	7101043	7672191	8841463	10345171	11366909	11734980	13365486	13750889	15822467	16313066	17642294	18181795	21072204	23104488	24339641	26970702	29408113	32067886	36871348	38606572	40253492	41033237	42073255	42564083	43178840	43418743\nA	48	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	48	95461	190194	568635	2054085	3851654	4532396	5223794	5302962	7226241	7633838	7786597	8357255	9785661	10940864	11867736	12883834	13759168	15186129	16188285	17279650	19202613	21651121	22708367	24241424	27147523	30000673	32969645	36683464	39302191	40169494	40859344	41667451	42389450	43422569	43467377\nA	49	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	49	67925	85533	185559	361413	2110258	3528028	4642108	5483636	5511026	7632837	7981858	8514999	8696969	9882966	10713339	11263426	12523645	13210603	14816692	16102619	17700998	18959336	20207506	21978451	24103174	26703440	28630090	32542651	35653082	39026279	39847717	41252787	42209293	43117124	43527073	43745393\nA	50	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	50	38581	62893	107744	460431	1863125	3581653	4423194	4898139	5211190	6851691	7681205	8256720	9286111	10118948	11523281	12115375	13410324	14055088	15408476	16560078	17621510	19105409	21899323	23184679	24668006	26252148	27763969	32982440	36196425	37392909	40045067	41197673	41828536	42152091	43090460	43521582\nA	51	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	51	11758	134724	660197	1920205	3640808	5126014	5305767	5680597	7739560	8244267	8512134	9005637	9171280	11670794	12325791	13858004	14619315	15554661	17656899	18548469	20734461	22105012	24131278	25977403	28523246	29849952	33742362	37102830	39260638	40605979	41557260	42420069	43480187	43934706	44162304\nA	52	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	52	33311	43775	112789	964665	2551389	4350559	5243322	5753830	6573555	8291518	8839830	9113679	9753030	11333423	11931021	12526057	13239530	13865861	15751063	17435062	18687326	20301501	22132786	24767339	27791824	29426246	30679659	34991748	38903641	40372576	40860808	42065336	42635391	43187013	43890276	43998421\nA	53	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	53	70999	82068	134859	668598	2338660	3782910	5366896	5710407	6507361	8199006	8590829	9130493	9658650	10849961	13285458	13995735	15279349	16410203	18298377	19217373	20782958	21793808	24364979	26998489	28723172	30196248	32385471	34339154	39320110	40473870	41129837	41916902	42542078	42947840	43458724	43884832\nA	54	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	54	53620	66290	149191	659336	2229530	4417739	5393875	6028228	6413122	8620657	9413460	10011670	10554979	12702168	13993903	14650692	15011758	16475090	18806498	19830046	20983596	22855340	24157661	26391796	28842809	31063895	33446914	35914171	38521013	40611954	41400528	42272400	43253460	43813625	44583068	44794362\nA	55	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	55	19815	45736	138069	1145665	2447252	4002168	5177619	5911704	7242519	8843786	10062616	10513065	11719735	13204072	13509014	15054249	15685075	16000789	17961254	19368404	21272256	22765146	24477716	26479048	28649838	30298597	32661455	34210818	37423474	39843891	40737195	41651750	42752854	43580804	43899997	44078989\nA	56	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	56	10158	19231	145485	662670	2894486	3256167	5295432	6681623	6703136	8189071	9775604	10259546	10447469	11086439	13084579	14189323	15547590	16815874	18448060	19798539	20541811	21876534	24288541	27441434	29039777	30295284	32565502	36343186	39239339	39845327	40702560	41763227	42337332	43107201	43919603	44001010\nA	57	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	57	59498	158213	1236643	2730209	4714096	5792229	6818698	6882279	9637252	11008547	11368209	12045353	12234243	14519150	16089879	17132525	18461700	19330676	20881448	22502756	23596713	25250390	26960926	28884035	31354642	33470627	36069188	40174960	41468566	42667274	43132516	43530429	44380180	44868288	44953326\nA	58	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	58	173008	2019816	3344386	5069550	7008075	9489317	10052790	12081849	12221632	13724681	15235069	15637778	15693527	16404556	17951585	19246862	19900213	20809183	21569645	23471653	24164677	26122467	27693481	29804175	32450775	34271979	35384061	39088637	40479250	41313341	41818334	42393579	43672121	44301544	44790198	44998659\nA	59	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	59	607473	1320254	1403031	4873016	8270573	9803171	10216157	12218936	12326268	13963985	15490784	15869262	16015829	16760828	18906852	19453615	20195408	21610270	22257818	22649146	24750133	25943350	28587395	30064142	31983001	34158256	37158400	38965618	40503517	41642765	42402527	43478657	43998916	44525035	44833547	44939731\nA	60	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	60	617648	2347632	3128097	3846637	7413577	9653492	10207611	12313579	12416877	13080630	15051553	15949153	16320737	16996271	18168881	19479319	20427377	21046769	22252154	24272692	25799151	26641367	28278255	30336651	33360032	34600746	36092108	39282020	41400793	42020754	42823292	43575361	44072650	44649467	44998206	45167234\nA	61	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	61	1139505	1715885	1994016	5115540	7115975	9601078	10150710	12056992	12350270	14065271	15030103	16086192	16276821	17980721	19099495	20059132	20613552	20942272	23291711	24534298	26051366	27298107	28910973	30588083	33501979	35408522	38124800	39928510	41087485	41969301	42925534	43351850	43650462	44287254	44551933	44649064\nA	62	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	62	132497	133970	3187690	4086012	8100743	9817264	10528355	12269516	12564561	14342557	15295842	16465899	16538683	17273953	17728326	20399115	21146688	21252581	23122403	25045569	26515640	27305670	29207834	31009076	33759465	34817784	36263546	39232666	40486801	41947244	42772702	43127895	43952134	44573767	44822356	44856191\nA	63	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	63	683274	1807386	1914083	5584191	7252515	9603473	10335205	12285647	12624199	13309003	15848198	16277921	16695122	17292735	17590539	20824749	21118808	21322120	22620757	24013296	26055990	27045295	29738535	30717727	32853348	34780163	35904874	39990448	41716845	42370597	42996817	43470447	43738444	44075355	44421664	44490527\nA	64	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	64	57211	1176364	2535563	3985194	8007337	8834822	10319594	12540396	12887079	13585089	15719863	16555109	16994895	17914348	18010824	20832839	21619946	22058527	23834341	24912670	26285430	27695169	30073114	32321459	33596333	36567822	38439539	40535358	41737071	42471489	43167294	43506732	43820847	44181229	44375085	44409249\nA	65	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nA	65	80611	95760	1797205	4510730	6499842	8784117	11619814	12535074	12862172	13139065	15690350	16671583	17159167	17812470	19376951	20559652	21879364	22367776	22949856	25382991	26262592	27628558	28998120	32497642	34819085	35510108	36454364	39523902	41604498	42385879	42722082	43060387	43418031	43642691	43935953	44050500	44083679\nA	66	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	66	69489	685377	1818037	4252452	6808553	8691940	10335393	12489572	13004170	14530812	15999202	16950467	17474210	17613523	18547957	20267870	21974390	22261610	23592427	25156759	26806216	27621653	31216953	32214987	34446946	35425330	37135927	40150204	41547845	42166887	42528974	42777804	43216732	43470727	43856992	43952847\nA	67	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	67	104847	739253	5189999	7643813	10102103	10923959	12715721	13049983	13607759	16344740	17384312	17770972	18192924	20029056	22035842	22804620	23447805	24776490	25930589	28017264	29820676	31238630	34792403	36231481	37167499	38501283	41176139	41649119	42282109	42740805	42974253	43159323	43743853	43882286	43907541\nA	68	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	68	703727	745269	4032994	5578655	8193151	10178228	10956587	12812327	13378093	13628353	16206540	17653542	18116279	19042824	19277549	22313326	22619967	24026117	25150775	26767366	29344400	30763214	34092520	34762584	36765391	37652034	39016065	41721982	42116753	42541164	43062332	43240189	43336304	43488178	43643995	43691256\nA	69	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nA	69	762473	2627920	5385041	8244879	10252429	10552523	12883747	13447274	15073837	17340697	17584921	18228678	18516143	19362449	21422323	23244183	23771980	26130339	27385463	29616478	32500312	34592154	36646722	38073721	38790349	40828390	41476696	41889872	42243007	42558838	42671577	42889521	43065949	43191573\nA	70	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nA	70	109169	206594	3504014	5531285	7807018	8894064	11192093	13075181	13925799	14003204	16704907	17815467	18534510	19370855	19911823	22758451	23427265	24895845	27097442	28300210	31726082	32960952	35646805	37683491	38326012	38996795	41012751	42266081	42414767	42571895	42706634	42859088	43028985	43135668	43230940\nA	71	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nA	71	721074	1867458	3467131	5077548	8355476	10362281	11426556	13323292	13699678	14096158	16705337	18216928	18791992	19619165	21670618	22833789	24390630	25656012	28150474	30875632	33735665	35066546	37320930	38054044	38790682	39390883	41692462	42165796	42274828	42335287	42481120	42563066	42636284	42747959	42803228\nA	72	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35\nA	72	790889	2085459	3660780	5177851	8474865	10788345	10855676	13656291	14344062	14500789	17291080	18597403	19330391	19644312	22722578	24173084	24905441	28263330	31057045	33702627	35597134	37168138	38716517	39864371	40379502	42092774	42224836	42307531	42453738	42575659	42658609	42689054	42738414	42749400\nA	73	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35\nA	73	748757	1958104	3948367	5608556	8373763	9209556	10881719	13704400	14204627	14562225	17321861	18917646	19799607	20793777	23929931	24934693	26450095	29977692	31775717	34696826	36162099	37439082	39577114	40263476	40664019	41361587	41573224	41632489	41677493	41783847	41806674	41854009	41861816	41900556\nA	74	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nA	74	36510	1741738	1810496	4329112	6081988	8918224	11033656	12465697	14443309	15188121	18009999	19725587	20203920	20603345	23431940	24211073	27204367	30158907	32987870	34388325	35402461	36530138	38176427	40043374	40589514	42049735	42655196	43234623	43383807	43528270	43689633	43849152	43914922	43993410	44019359	44033580\nT	0	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nT	0	94936	118589	436060	995746	1469258	2139147	2489658	2580726	3088945	3483619	3890776	4082768	4535212	4872877	5392262	6041694	6368564	6665261	7162048	8117138	8528166	9270972	10258424	13648643	17035999	19596600	28739912	35310639	35922736	36518210	37009495	37396102	37688145	37829672	37966555\nT	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nT	1	94746	115894	446065	1028911	1558342	2247586	2621219	2712314	3227568	3653007	4079499	4267059	4743759	5113574	5678992	6336753	6697823	7008876	7479296	8434877	8843552	9571162	10488355	13830428	16904062	19213294	27888868	34679405	35191670	35699367	36084824	36393531	36637634	36745703	36854198\nT	2	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nT	2	234308	259325	588112	1665856	1836344	2264672	2801129	3028621	3882792	4038280	4575496	5048055	5100298	5838141	6479689	6849705	7309027	7879970	8611285	8893145	10829659	11847757	12456350	14753560	23170955	25235697	30661181	39655824	40499199	40672290	40970427	41396776	41831098	41905392	42007273\nT	3	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nT	3	31139	80303	367715	1281414	1515290	1961553	2465063	2724580	3138616	3738210	4249912	4468855	4897062	5216355	5654465	6507549	7010506	7388390	8430836	9206583	10059561	11151384	12467860	17340688	22309628	26371434	30355199	35005337	37404550	37909021	37991678	39445820	39702860	39774450	39825872\nT	4	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	36\nT	4	85958	122686	489082	1321039	1729797	2225076	2739691	3086070	3586820	4065626	4610565	5490202	5949168	6374929	6634197	7289655	7667480	8602249	8721623	10188260	11546361	12860751	17418972	20712727	27128794	30867306	33993695	37307115	41039505	41149421	41364565	41459860	41547148	41597788\nT	5	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	33	36\nT	5	42651	192643	474594	1335206	1809952	2223463	3011711	3242228	3788449	4311521	4585071	4992687	5274850	5746339	6442782	6806933	7437077	8361626	8853730	9819662	10448649	12081615	14461579	18861473	27346146	29349300	34131863	38039743	40015720	40172960	40412899	40565130\nT	6	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nT	6	61257	280068	563656	1025944	1721164	2690292	2861368	2961345	3191080	4002225	4338029	5060562	5377156	6014413	6609111	7226221	7644710	8202210	8913494	9631460	10541075	11626538	15003409	16532266	21191551	27978801	33025020	36309501	38262577	40407534	40556353	40694764	41172450	41238600	41282697\nT	7	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35\nT	7	37623	47059	362499	1133155	1594763	2303124	2815840	2932692	3204210	4043415	4365111	4835546	5473617	5794227	6378992	6989652	7148277	7513603	7887549	8575676	9556764	10291080	12236696	13697079	15932568	22946825	30735474	34010871	40110628	40720647	41060716	41271068	41726874	41856079\nT	8	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	8	74889	266358	556802	1275785	1946637	2858970	3094358	3164131	3692983	4358216	4682162	5131082	5692470	5831479	6657623	6939981	7668346	7843411	8798056	9438797	10463476	11091390	12006087	13341534	14777787	22566413	30502409	36153485	38098221	39259576	41473626	41937507	42156839	42533770	42880728	43074835\nT	9	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	9	96689	168173	359544	1518785	1847707	2370436	2992810	3242848	3996944	4453898	4812776	4965038	5645951	5946196	6295390	7134859	7476987	8892244	9044994	9802260	10301404	11877960	13196143	14531475	16887014	19202959	24692507	33937665	34449951	38183522	39462527	40066858	40398149	40793690	41141254	41297075\nT	10	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	10	41897	292172	300233	1024047	1875319	2596719	3423299	3524919	4138915	4254058	4703529	5070507	5515633	5884233	6574499	6919829	7366026	7967198	8397839	9106252	9860346	10547207	11759201	12686603	14486097	18166576	22452685	31719695	36726946	39054085	39398180	39818393	40181982	40892760	41212402	41306931\nT	11	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	11	66719	122491	475360	949188	2057858	2289545	3030267	3551735	3735576	4737996	4780897	5309422	5686714	5951095	6656658	7172345	7653010	8648597	9010374	10011844	10478806	11883084	12701569	14207860	15568372	16762460	21089545	29860530	34965940	39102866	39424552	40106694	40564131	40874967	41448952	41603464\nT	12	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nT	12	27648	45692	65111	371803	1844338	2015401	2415984	3154603	3242667	3354135	4262881	4550658	4681854	5529289	6037237	6136615	6761250	7256558	7355697	7662183	8252262	9202947	10260685	11383162	12266508	14392147	17288304	20247745	27863276	32523803	37855008	39611090	40217308	40784273	41593951\nT	13	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nT	13	10892	37441	51771	391563	1587082	2181219	2553068	3324219	3406157	3594953	4624880	4725700	5363952	5731221	6457954	6930759	7642160	8159294	8743184	9039088	9864406	10588747	11310716	12068379	14112601	16516458	19203936	23010258	27641634	34175749	38928881	40607803	41633759	42209529	42991217\nT	14	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nT	14	33150	65718	84649	389105	1620262	1896541	2360522	2833310	3240821	3330728	4284765	4422703	5039855	5550172	5780120	6387416	6765910	7393080	7941893	8437086	9179638	9884567	10596389	11698064	13210322	14587223	17052044	23004635	28360570	32683390	37301738	39565875	39996800	40732607	41432371\nT	15	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	15	50835	60691	110104	571342	1665155	2188565	2556556	3318634	3406619	3745904	4568010	4879924	5123486	5563709	5966915	6370970	6811592	7295350	7707755	8620332	9089482	9560154	10224303	10846374	12450775	13946170	16656847	20392503	24583719	32779493	36161433	36575816	39696176	40224982	41206357	41306537\nT	16	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nT	16	40783	49965	58713	347850	1444529	2290867	2362664	3359946	3624367	3753614	4735062	4992957	5389061	5809628	6081121	6348257	7519107	8350912	8438482	8967329	10195145	10672025	11642079	12387328	12905897	15455127	17935945	20817840	25537987	32005697	36137072	37028893	41580986	42150248	42506784\nT	17	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nT	17	14663	26738	95288	265369	1035585	2067003	2116012	2905944	3237553	3528415	4354571	4617977	5139553	5388366	5868092	6307338	6852730	7086867	7954861	8316430	9218910	9872470	10888204	12173000	12807148	15104005	18173599	20556593	23206310	29781757	34728073	36905909	39793427	40414183	41259175\nT	18	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nT	18	17750	22972	47341	280533	1191161	2018530	2445655	3263110	3650239	3814305	4344192	4875971	5541807	6051556	6411452	6848578	7400925	7836703	8479091	9421596	9803703	10324126	11688025	12107000	13625512	16242184	18379552	20876481	23808821	29183290	34730535	37567509	41026528	41648407	42548642\nT	19	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	19	49977	57383	75666	253175	1247703	2143842	2566336	2712791	3650382	3661192	4166950	4727428	4886045	5298565	6123292	6314453	6844721	7094206	8026835	8537875	9003366	10068534	10656453	11404402	12550184	13975281	15838899	21012721	23468185	27690922	32943008	37695121	39258512	40300993	41118481	41245590\nT	20	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	20	8856	49602	78664	288592	1131112	1995286	2369743	3051756	3485224	3831271	4394827	4972177	5267941	5322077	6062788	6473871	6917215	7785479	7992806	8664717	9430252	10290544	10842857	11659359	12231255	14485391	16820856	21864937	23548183	31370184	35852058	36526600	39345858	40118044	40853627	41020541\nT	21	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	21	13351	24544	33776	121996	836054	2073515	2368939	3324028	3569389	3722755	4068631	4569443	5216351	5866953	6386045	6835304	7161316	7206385	7894637	9087889	9207351	9910243	10911016	12235001	13147308	14761762	17197552	19862946	24815166	29424600	33747593	38145769	39156937	39876845	40532883	40862973\nT	22	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	22	26932	42566	57248	296147	1093901	2215536	2468294	3203888	3387203	4062916	4153109	4961569	5491577	6129085	6752372	7141355	7436904	7724043	8804896	9133246	9502777	10523588	10820229	11571926	12906473	14816828	17206878	20030251	24454824	27703581	34744420	37361399	38747389	39624436	40589070	40938818\nT	23	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	23	1065	26814	42835	147739	1244774	2384565	2906894	3661397	3882624	4066218	4311121	5138351	5623843	6054713	6695163	6825042	7327792	7881929	8333456	9239721	9478570	9935177	11104174	11810937	12455841	14922316	17216195	19913048	22975671	28878408	34285961	35538152	38394589	39677074	40514332	40615916\nT	24	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	24	11545	21375	92622	278141	1213203	2046324	2451924	3396102	3458431	4200141	4259638	5044411	5701790	5903298	6907918	7322931	7633847	8095591	8738441	9445995	9827393	10554449	11692803	12727518	13879029	15525015	17508331	23022850	26333009	31306751	33365707	35665222	38382974	39491811	40719308	40966905\nT	25	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	25	35230	55575	89171	225983	837734	2146730	2379332	3046786	3578293	4274437	4283853	5361206	5606906	5638365	6193304	7102801	7469469	7820002	8224018	9249345	9815800	10731881	11656785	13282399	14686656	16290300	17983618	20261596	24652893	29746429	31480217	35606624	37875976	38483833	39848917	40530784\nT	26	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	26	13914	24057	77729	174435	976023	2193028	2724509	3468585	3933563	4200515	4264600	4502299	5632904	5756632	6549669	7297637	7662063	7851863	8705862	9263128	9755624	10512237	12218450	12667254	14192962	16269497	18540106	21781305	27026549	28878451	34095762	34866858	39012965	39760527	40738028	40832755\nT	27	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	27	24335	42856	252196	713017	1915781	2470687	3110845	3630633	3965308	4154410	4753156	5234023	5469043	6239984	6621164	6778290	7596272	7950959	8934053	9424087	10118406	11240749	12651163	13925729	16040351	17870744	22596816	25059523	28951766	33954963	36616035	37571958	38018915	38792981	40303054\nT	28	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	28	15419	52402	136015	590945	1836969	2841041	3417161	4317287	4575232	5102660	5690748	6414351	6552503	6984057	7448971	8047727	8623271	9792479	10392150	10479482	11113864	12473529	13360713	14325917	15867937	17724946	19866510	22995597	26744919	31923239	34585840	36726416	38557532	39352727	40074629	40406201\nT	29	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	29	20081	32243	62161	698336	1998656	2807184	3497117	4415893	4729973	4818914	5293724	6745015	7098780	7522428	8217915	8580071	9363780	10459167	11014443	11336957	12305613	13354143	13746864	15174590	16387746	18310913	19959499	23773488	26734942	30084037	36337872	37145624	37999588	40087044	40875237	41350076\nT	30	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	30	18733	86229	514908	1937291	2776755	3152804	4346367	4605488	4728135	5379858	5950659	6609081	7023408	7347633	8065843	8169183	9902751	10454686	10993142	12473612	13691755	14397682	15111619	16962380	18797298	20981382	23890350	27497550	30294970	34510352	36601813	39221781	39705740	40478217	40721692\nT	31	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	31	18679	51851	170843	691076	2678236	3046203	3357938	4352464	4703404	4762908	5424213	6912063	7095966	7287785	7877033	8952500	9335264	10281236	10741224	11440706	12181567	13807714	14429015	16250554	17850287	19554351	22445800	27535748	28282761	32145850	35177020	38800237	39896536	40207289	41281392	41352824\nT	32	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	32	4405	41590	157832	663254	1758919	3056745	3076748	4284598	4852745	5449570	5703377	6326628	7306794	7518674	8347512	8826467	9482327	10237809	11124196	11584308	12375216	13704792	15064780	15843670	17350000	19223429	21349395	24283809	29398350	33036048	35127837	37303137	38889293	39395310	40465003	40620131\nT	33	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	33	32307	53570	193767	613799	1737552	2970508	3220568	3876192	5109525	5461879	5537608	6864275	6994500	7196861	7940429	8739843	9860377	10362661	10781816	11350708	12914327	13542791	14326161	15561016	16710244	17707128	20645114	23255974	26616443	31684844	36210672	37083299	38404680	39458404	40149010	40230516\nT	34	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	34	29446	67122	662307	1567855	2961360	3217897	3584050	4511062	4943996	5313374	5653617	6795556	7138969	7455055	8344469	8890603	10132987	10960520	11348415	11809505	13369708	13998319	14621058	16857029	18216651	21149946	23545663	28456175	30216708	33699358	35688450	38876882	39459208	40077122	40234470\nT	35	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	35	11792	25770	41449	339501	1926638	3175496	3562674	4506409	5228544	5569403	5678956	6648323	7297654	7550648	8128623	9256847	10121081	10627572	11165771	11803362	12436999	13240433	14930944	15680211	17448098	19205829	21775343	26838855	28780525	33732606	35905267	38330810	39773383	40407156	41230887	41326498\nT	36	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	36	49683	62314	149324	413737	2511552	3561204	3958810	4815067	5391298	6128669	6532910	6803667	7939296	8184755	8850641	9379158	9880548	10216386	11299787	12139213	13183161	13750800	15016232	16002632	17223359	18510238	21222995	24789687	28134608	32513013	34740228	37735173	38824516	39345477	40539042	40800852\nT	37	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	37	48743	49739	121474	332978	1996567	3312994	3788964	4171619	5893153	6261595	6392433	6727373	7866960	8965886	9123863	10367232	10740746	11657219	12893862	13605096	14359518	15374071	16584614	17802417	19313066	20596238	22229734	25553537	30002606	33926420	37104097	37546766	39009620	40561921	41063713	41351962\nT	38	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	38	60467	68178	100486	332493	1996116	3458906	3722387	3811118	5511368	5866464	5929530	6850617	7602028	8298515	8510743	9237085	9832275	10479509	11539602	11981552	12998215	13666115	14801390	15725087	17962456	19041351	21097287	23894857	28878507	32088316	35609756	37755045	38952720	39587841	40254196	40324605\nT	39	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	39	37183	50345	193895	400792	2050129	3451477	4324459	4778685	6440247	6514294	6951271	7108527	8125618	8894374	9298877	9700002	10816863	11748330	12951174	13559559	13960456	14752842	16188175	17928035	19548982	20685662	22935673	25249851	30282208	31900495	34005441	37454235	38194007	39004576	40127772	40329965\nT	40	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	40	58860	66076	81085	370971	2058746	3675470	3977702	4001410	5646316	6231257	6612490	6735527	8278323	8412181	8689185	9525896	10488793	11337311	12077263	13040955	13554018	14300323	15699236	17070619	18658360	20813447	21886117	25513993	28798458	31120150	35248776	36689300	37500986	38875221	39563667	40028630\nT	41	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	41	35728	67185	77307	417255	2118956	3585291	4603853	4891549	5642180	6510788	6933047	7051836	8635487	8802046	9242839	9869580	11550977	11699869	12201243	13184477	13659494	14865926	15772248	17405986	19225658	21053278	22958540	26290820	30802071	32802653	35276257	37469647	37925910	39735067	40530392	40836175\nT	42	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	42	32891	41394	121717	380933	1796447	3043269	3861618	4471918	4697763	6124991	6128479	6550147	6944874	8299171	8784468	9170507	10841417	11770239	12426702	13972142	14777074	15212834	16618562	17558287	18860138	21521913	23005741	27024006	31241707	32272251	34188985	36430885	38120621	38958663	39663984	39936585\nT	43	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	43	31434	66085	108319	623521	2238749	3740618	4443466	4754706	5612180	6733965	7073970	7252915	7604458	9643912	10003019	10354243	11213604	12149910	12984670	13681447	14165506	15574567	16020479	17534652	19173675	21083619	23376121	27481248	30799685	33604353	34867455	36746367	37586826	39376755	40016751	40088740\nT	44	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	44	64839	74426	133859	421022	2246855	3752876	4508875	5170898	6679760	6879716	7232065	7797640	8395797	9646574	9877107	10557286	11428322	12068858	13187713	13404532	15036293	15786527	16400963	17593141	19260719	21300736	22546497	25140946	30952936	34049014	35574594	37917519	39105288	39724617	40356356	40514991\nT	45	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	45	17668	89779	145877	443185	1834005	3461696	4436298	4754109	4912356	6851715	6912429	7309195	7790063	9127143	10103841	10737510	11106312	11669766	12484792	13456673	14786333	15240853	15759385	18665242	20038771	22637045	24408070	27366465	30818733	33297070	34013556	36213421	38232796	39249553	39943850	40111621\nT	46	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	46	54650	81673	100262	529964	1375840	3534936	4333890	4771768	5245013	6758123	6909430	7317264	7838051	9968413	10164496	10956057	12045873	12742144	13410699	14535331	14992464	15986398	16327446	19237731	19996340	22183903	23624410	29129759	31060282	33574417	36061798	37278058	38210023	38714518	39597000	39686389\nT	47	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	47	66885	68106	84975	843947	2209091	4063413	5046518	5522643	6114553	7033452	7322005	7871869	8956930	10337628	11343793	11663136	12965545	13302800	14823836	15188991	16206821	16632969	18743210	20350236	21296409	23377741	25319850	27508169	32333965	33950942	36298551	37059436	38557887	39084439	39840045	40081891\nT	48	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	48	91505	165941	561732	2148386	4074467	4749448	5453606	5503538	7322330	7692841	7814529	8337047	9557732	10515551	11435728	12256872	12941713	14078965	14822312	15600620	17016612	18801881	19658400	20819651	23164668	25486443	28272995	31731361	34935074	35939489	36655225	37566947	38327805	39712623	39765941\nT	49	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	49	76253	87302	185073	333715	2147408	3637044	4758022	5598039	5616530	7563066	7880854	8369262	8520720	9495120	10217849	10665647	11649643	12292809	13518544	14528535	15775213	16739149	17625548	18992296	20516235	22592661	24227345	28050711	30686294	34063952	34858280	36981120	38042415	38932935	39423071	39660758\nT	50	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	50	47830	72787	119788	486267	2010539	4009290	4886949	5387471	5751240	7234468	8140609	8800873	9903128	10621307	11830441	12386429	13459201	13973443	15010574	15856017	16727448	17860416	19918856	20904018	22079615	23429241	24637204	29327234	32601956	33672862	36669788	37871141	38586862	38967666	39982134	40616096\nT	51	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	51	11800	123472	609078	1942443	3760204	5293322	5441075	5839997	7757387	8233142	8504832	8968394	9097439	11207020	11829167	13187632	13762173	14585648	16193206	16847907	18458293	19495119	20958758	22388877	24444674	25555923	29182272	32415074	34676234	35807971	36984952	38380266	39476891	40000527	40487390\nT	52	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	52	39212	50900	105488	980868	2734624	4705501	5632207	6155172	7010255	8515979	9090010	9384476	9987489	11323355	11851148	12337161	12914804	13417979	14836469	16158288	17220244	18439982	19802219	21671641	24065221	25392564	26592352	30896373	34705352	35985224	36519302	38430583	39117678	39707864	40524024	40684322\nT	53	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	53	75175	87641	132248	678518	2466485	3992784	5620008	5951968	6753209	8234449	8575834	9036175	9516458	10646262	12687984	13286399	14292121	15182094	16586306	17250289	18416163	19161208	21020014	22978154	24446464	25613546	27475427	29200206	34422062	35833075	36587000	37419656	38395076	38913416	39587019	40009962\nT	54	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	54	63520	76776	134930	593203	2209471	4337937	5235349	5782892	6157680	8067772	8729791	9250530	9714978	11526777	12549240	13071896	13359244	14458974	16161073	16931224	17768011	19143159	20099163	21775029	23725319	25529613	27575289	30125657	32561430	34580093	35343578	36723690	37828143	38715583	39507342	39682224\nT	55	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	55	11845	37533	135548	1240956	2617328	4241974	5404211	6181766	7521706	8913430	10064601	10520000	11490178	12687738	12947905	14277021	14752352	15006586	16497070	17516937	19026773	20147399	21411190	22927719	24668781	25998109	28055502	29354844	33130227	35427676	36351677	37393556	39072919	40018921	40473783	40650104\nT	56	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	56	12721	26035	138694	650580	3180595	3531177	5495792	6957473	6971138	8257150	9755181	10243485	10355815	10949052	12564880	13454932	14613775	15574823	16955407	17984994	18542225	19578390	21347923	23645823	24918623	26025231	28037842	32411905	35130850	35725429	36535562	37716701	38730348	39604434	40649531	40727039\nT	57	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	57	71218	147731	1322069	2913005	4783649	5868061	6761354	6798886	9219443	10404136	10711127	11233717	11373697	13216732	14521214	15339699	16320880	16946015	18056147	19222084	20050454	21230947	22552474	24035139	26037588	27760827	30394397	34376851	35502131	36926641	37656250	38141806	39027324	39679437	39759605\nT	58	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	58	164865	1879812	3094248	4591470	6571122	8897414	9430413	11250532	11367811	12627224	13892025	14191940	14226762	14801525	16025070	17033306	17509055	18169095	18734200	20099739	20613481	22027308	23188850	24740019	26670470	28115494	29018706	32785756	34291235	34951151	35859954	36576225	38003532	38845238	39411458	39644184\nT	59	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	59	608006	1261968	1337958	4684776	7976694	9343071	9738779	11518882	11610533	12987200	14227206	14538614	14636383	15233593	16922170	17316845	17859099	18904918	19391241	19627139	21123566	22046152	24018203	25173202	26578352	28364237	31201193	33145272	34803976	36111827	36899930	37908108	38676763	39391049	39769484	39876337\nT	60	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	60	614392	2281258	3013949	3675966	7300332	9395791	9932703	11770837	11842489	12421939	14028623	14653785	14938306	15496715	16404731	17384591	18085893	18535603	19425740	20842545	21916421	22504383	23664718	25305750	27565555	28639064	29811884	33117794	35188573	35847282	36629912	37739399	38401148	39027873	39549184	39752095\nT	61	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	61	1102756	1652398	1891411	5036232	7201142	9522829	10076055	11776352	12046718	13419733	14310579	15130613	15248876	16572768	17428360	18137788	18550760	18767605	20472578	21364863	22413084	23340041	24517577	25807019	28060269	29618998	32134708	34100487	35275992	36437604	37492906	38305011	38700421	39497715	39836713	39938483\nT	62	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	62	125220	127397	3224861	4135846	8457086	9936913	10594710	12108444	12420661	13858471	14702427	15551936	15588504	16185408	16490908	18522661	19054294	19117339	20451010	21810909	22838928	23435854	24899907	26268761	28299527	29220635	30413238	33445272	34552528	36492081	37511930	38018702	38843803	39586871	39969022	40025727\nT	63	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	63	655409	1754522	1833801	6117964	7818701	9971058	10831703	12599488	12869674	13513549	15517778	15840512	16162378	16652115	16842809	19301859	19504302	19625484	20603084	21588924	23046425	23787063	25805224	26541880	28214063	29793897	30876638	34999451	36729414	37372475	38064772	38836380	39310012	39845759	40332787	40449226\nT	64	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	64	72633	1195339	2616825	4280376	8921952	9692416	11077746	12969108	13302442	13918607	15615287	16222198	16550062	17273166	17331452	19471092	20024958	20301094	21623859	22383763	23352698	24398074	26112563	27802350	28862272	31688031	33222052	35732749	37118229	37911716	38667694	39033191	39469040	39980958	40301152	40359559\nT	65	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nT	65	96446	109646	2143151	5324549	7571891	10084415	12629812	13289457	13583833	13827681	16010395	16701518	17055626	17627575	18762403	19665558	20686587	21000367	21409981	23183670	23831013	24828484	25889954	28403354	30254196	30804433	31700327	35098202	37226717	38098281	38509539	38887454	39517495	39885166	40333146	40446552	40557798\nT	66	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	66	85213	660994	2142147	5204724	7995455	9950883	11533180	13371716	13870596	15006966	16346549	17033233	17413302	17504520	18253341	19516983	20821067	21022577	21964813	23048728	24269755	24915444	27521311	28361073	30116880	30996292	32453881	35894584	37454930	38125776	38547985	38982457	39590698	40026135	40397011	40537309\nT	67	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	67	118323	686485	6285509	9245274	11586179	12419046	13887244	14176734	14694450	16896747	17660351	17953682	18230682	19623953	21136934	21691955	22143295	23130554	23965540	25489150	26783991	27876187	30629552	31965437	32805696	34465347	37425256	37935165	38629310	39140266	39453279	39771109	40436589	40611982	40699460\nT	68	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	68	673636	774269	4966561	7186412	10153073	11822438	12510078	14124194	14624019	14854197	16820751	17935145	18381547	19174400	19360007	21591613	21803304	22814694	23661457	24821207	26741949	27778770	30262779	30870931	32522374	33269199	34781866	37984745	38496298	38997680	39743703	39978102	40149979	40460088	40690133	40761267\nT	69	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nT	69	703871	2613555	7111892	10481472	12358879	12668328	14675844	15092522	16375998	18347083	18481501	18985591	19185292	19854694	21332946	22729426	23157691	24892266	25744175	27383621	29562675	31294573	32892976	34208997	34987152	37599308	38430591	38922741	39351361	39850911	40040965	40339926	40701322	40858892\nT	70	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nT	70	107533	454500	4212688	8125950	10552992	11575841	13434379	15039672	15799601	15950388	18079822	19005874	19537347	20232012	20619429	22751528	23261918	24295708	25861251	26771825	29209547	30256340	32446344	34042584	34793220	35390965	38039770	39526167	39849056	40050168	40280638	40558775	40842736	41073028	41214000\nT	71	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nT	71	682247	1962544	3998842	6720014	11509785	13106102	13936592	15647788	15916961	16268400	18265969	19547856	19970489	20701997	22197978	23082204	24231801	25126130	27042694	29004196	31086969	32094159	33927440	34653997	35530599	36235584	39369181	40005469	40214990	40313368	40528342	40660324	40818613	41007213	41125661\nT	72	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35\nT	72	747169	2572243	4900700	7312536	11619196	13545891	13730047	16193747	16744838	16933450	19051867	20106157	20660808	20867407	23138003	24236103	24765496	27163905	29226803	31167362	32774055	34207485	35693528	37341785	37870009	40061129	40288319	40469510	40678915	40965726	41111298	41152445	41272167	41315637\nT	73	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35\nT	73	681883	2106111	5810355	8778281	11710321	12533852	14002869	16500611	16861954	17256605	19368254	20676224	21271112	22095543	24384486	25147071	26166350	28812239	30213670	32430452	34164316	35356447	37739128	38432958	38956413	39967490	40333539	40439683	40536087	40740382	40766290	40866840	40906971	41005240\nT	74	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nT	74	53659	2229454	2476967	6401476	8695923	12575672	14155022	15240525	17059798	17760428	19786671	21122614	21529628	21814585	23900163	24440537	26617046	28692212	30731431	31771101	32547590	33982237	35350247	37502027	38070826	39455464	40071279	40950680	41154805	41336910	41502339	41750581	41880427	42081365	42102144	42140697\nG	0	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nG	0	91928	117784	440122	879779	1295660	1884582	2201540	2307115	2739549	3068984	3475238	3633743	3983445	4319325	4744035	5299379	5550552	5795563	6214760	6911925	7272432	7840529	8597960	11581255	15119909	17038100	25917314	33204450	33744965	34315327	34754352	35122373	35343694	35499990	35633242\nG	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nG	1	88828	110959	421313	880340	1347453	1952975	2288780	2384422	2832294	3183479	3572629	3738572	4111903	4422178	4853867	5407298	5667460	5910779	6335367	7078890	7410134	8020295	8824718	11844964	15532824	17604314	27669152	35967846	36534657	37131903	37609045	37989083	38235439	38407144	38549029\nG	2	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nG	2	147800	167164	378472	1091495	1217998	1513906	1871507	2028023	2584253	2683694	3032834	3318418	3350766	3829555	4184889	4415549	4701542	5019256	5461481	5625361	7863400	8482957	8840717	11042206	17249750	18577302	22933103	32122152	32680101	32880609	33158862	33454057	33744084	33828481	33890331\nG	3	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nG	3	28890	68225	275561	918505	1102083	1424529	1786541	1974061	2262630	2665451	3018583	3184885	3485263	3704473	3995818	4522238	4847366	5093191	5752696	6241579	6759189	7443108	8320435	12659791	16604909	20243376	24037855	28444381	31093543	31478419	31553515	33568567	33753584	33824499	33853869\nG	4	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	36\nG	4	79363	115187	393504	1002598	1285752	1658632	2008101	2282145	2606994	2966611	3323527	3921549	4226495	4498660	4663956	5097933	5327884	5874475	5963954	6860480	7681128	9177428	12656953	15162302	21618914	24720960	27859570	30964006	34862021	34961941	35127452	35198024	35251304	35287662\nG	5	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	33	36\nG	5	42190	159016	368138	1039414	1395488	1695471	2310009	2487159	2892007	3282940	3462561	3769969	3964485	4297492	4784483	5031749	5474015	6049703	6383510	7035481	7472563	9365752	12073802	15600278	23988372	25407030	29674515	33419178	35857613	35968693	36160970	36282812\nG	6	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nG	6	56093	228520	437128	749466	1253136	1969290	2080617	2170088	2334809	2878771	3120748	3622958	3859388	4288127	4638963	5018029	5274818	5636934	6070266	6492228	7066577	7732724	11722297	12799680	16317008	22342479	26912720	30179482	31967477	34487582	34639096	34737706	35074344	35146127	35177585\nG	7	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35\nG	7	34616	41793	270563	813452	1109934	1602112	1945432	2039763	2236575	2753104	2976417	3276328	3680490	3886858	4231832	4597128	4712026	4943631	5190224	5559208	6124036	6536407	8388236	9303768	10752624	17510818	23714728	26140417	32418322	32903407	33151885	33301498	33587555	33717851\nG	8	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	8	74221	213743	430382	938079	1389680	2048106	2203056	2260263	2603593	3053335	3309886	3612126	3954860	4084210	4557526	4738834	5216560	5333707	5898018	6302037	6933180	7291050	7816517	8613539	9550414	17384811	23893095	29074124	30749856	31594659	34098385	34451142	34595129	34895771	35142428	35244034\nG	9	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	9	82519	147197	279745	1078450	1329044	1686033	2139796	2310827	2813672	3134482	3374938	3496193	3952665	4157660	4360350	4891121	5098823	5931011	6046618	6509353	6817452	8832264	9616120	10400695	12751904	14276504	18316682	27060386	27379443	31368772	33071849	33515718	33739149	34152181	34420004	34518958\nG	10	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	10	36591	246736	255640	810463	1447503	2016042	2626495	2715461	3165031	3277220	3618757	3877208	4233940	4482308	4944343	5197451	5512198	5911125	6216408	6677578	7171171	7614651	8394990	8993903	10257176	13903834	17796827	26570251	32187370	34756517	35002353	35325901	35575914	36195626	36449867	36507738\nG	11	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	11	56136	106245	388934	718460	1480461	1647559	2165502	2532473	2662791	3340372	3371454	3716387	3991204	4171181	4614842	4931573	5229043	5829892	6074291	6661437	6934460	8853479	9345453	10225107	11133670	11949074	15658016	24304744	28403017	32666133	32889134	33381683	33711410	34051219	34505619	34604431\nG	12	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nG	12	28637	49606	68641	293640	1388100	1523505	1803067	2384076	2460950	2575783	3208342	3430456	3529797	4112094	4496514	4589914	4994176	5352900	5427366	5627514	6024766	6635489	7302573	8026544	8652192	10219615	12256314	14252533	22291727	26856711	32661630	34916698	35351315	35833903	36426228\nG	13	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nG	13	10536	29873	46138	269971	1043578	1482494	1718384	2244995	2300923	2426194	3098299	3165656	3586804	3838396	4294384	4582276	4999555	5293251	5651362	5835438	6318170	6754657	7175481	7662215	9965676	11582067	13252932	16441575	20572850	26568008	31141326	33100858	33743058	34279518	34839668\nG	14	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nG	14	30084	63621	81714	318764	1174972	1381611	1693301	2049767	2337242	2407564	3047291	3148676	3552584	3882930	4061223	4440703	4687935	5075054	5431002	5749965	6209058	6626547	7086392	7753767	9752712	10772348	12386489	17351625	22875978	26837850	30667159	33073288	33371649	34054758	34571371\nG	15	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	15	46682	58285	101732	433245	1271773	1656612	1909158	2516176	2595796	2879539	3434288	3672212	3862953	4169750	4454849	4759714	5049342	5418235	5715208	6267402	6653089	6948386	7379678	7803663	8911465	10120592	12627438	15128687	19336454	28188612	31986326	32331133	35446245	35967487	36739068	36800196\nG	16	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nG	16	31850	41273	50890	248831	984362	1585643	1654167	2335381	2523663	2614069	3268701	3465610	3730479	4015692	4200827	4370362	5119295	5620345	5678825	6005207	6747934	7053661	7655966	8104066	8445847	10796706	12558904	14508316	18075657	24821492	29730302	30391837	34688146	35342023	35583355\nG	17	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nG	17	15916	26630	85944	228493	759119	1579487	1629175	2197545	2479293	2707015	3289665	3484758	3904469	4086954	4444941	4737531	5107356	5326375	5888443	6155919	6751672	7201602	7855197	8715705	9128339	11428884	13739400	15404270	17558445	24667085	30726794	33208730	35521353	36146593	36810574\nG	18	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nG	18	18458	24403	44571	220887	839590	1410528	1713734	2274332	2549538	2678788	3013927	3382031	3832391	4161374	4413705	4691677	5044108	5337915	5730566	6283346	6532198	6859354	7665980	7980485	8960124	11409383	12910057	14598114	16697453	21525027	27749168	29915627	33931737	34538916	35205606\nG	19	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	19	44426	53009	68907	211613	887696	1550522	1847794	1968775	2651351	2662535	3003716	3395786	3504983	3784636	4330077	4484729	4827729	5026777	5615300	5925512	6236345	6873382	7260833	7747307	8521029	9664144	11043774	14550043	17247688	20836266	27391366	32294769	33420728	34360113	34995743	35090503\nG	20	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	20	9556	46533	74799	261907	842155	1547436	1823250	2337598	2644032	2936561	3339565	3769817	4019901	4065070	4548788	4827854	5149315	5749325	5953445	6377616	6914859	7462763	7811843	8867652	9301489	11026665	12808792	17278172	18530102	26918024	31660373	32151146	35204329	35987566	36537466	36653301\nG	21	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	21	15069	27562	33827	110735	673423	1574151	1854931	2540177	2725287	2884046	3168975	3533675	3991716	4483981	4904888	5229817	5459589	5498204	5991298	6829192	6936688	7413378	8098420	9010001	9725120	11134188	13515032	15476810	20705525	25411980	30660215	35198862	36021640	36665752	37173969	37413370\nG	22	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	22	28314	46115	63417	269977	841027	1680035	1921599	2427027	2562005	3107848	3187129	3767252	4132289	4642643	5081461	5356038	5556119	5746493	6448814	6717285	7016628	7659948	7852450	8820709	9874260	11365724	13155579	15136331	19786237	22450222	30762292	33546966	34738554	35650162	36510037	36792263\nG	23	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	23	1407	29947	48464	142997	991935	1830786	2271517	2792958	2957243	3123205	3321923	3873683	4257140	4582474	5030556	5134172	5483547	5862685	6175208	6774936	6945870	7244492	7979091	8460295	8968020	11294669	13078341	15044467	17476794	23155657	29358070	30936016	34091241	35371579	36042263	36110193\nG	24	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	24	12485	23436	81957	238673	934181	1512558	1832060	2507158	2559857	3114955	3161891	3715851	4188134	4345758	5031135	5304977	5503292	5825761	6261398	6712466	6957745	7433616	8169054	8803973	10073108	11409194	12963789	17819665	20431257	26491178	28316421	30337811	33363254	34292809	35334626	35521087\nG	25	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	25	35725	59308	91008	203870	681981	1625887	1801608	2305981	2736060	3277766	3286733	4030694	4226115	4253836	4667330	5283059	5524092	5764467	6049054	6783160	7146805	7737278	8326899	9419972	10522474	11774574	13460937	15194100	19541753	24789775	26833211	31658406	33662152	34389373	35583814	36083270\nG	26	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	26	14083	24568	70145	155014	780312	1691742	2082973	2690763	3033593	3224117	3283803	3520441	4283317	4402904	4992593	5526504	5800842	5954426	6503639	6938578	7254577	7742907	8869955	9202194	10422650	12401530	14253534	16660648	22133472	24247637	29656571	30324460	34857513	35546152	36912018	36980742\nG	27	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	27	26630	43381	220345	573362	1470514	1853698	2333887	2722527	2970405	3137681	3545157	3864215	4058237	4565966	4835588	4950126	5509837	5754607	6402537	6723548	7185418	7910122	9229157	10157924	12034783	13477818	17206344	19036541	23091187	28886262	32349847	33224022	33620466	34272601	35615099\nG	28	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	28	15182	56052	129747	515724	1461894	2242834	2772356	3417237	3613017	4094547	4495479	5045155	5165625	5487253	5817694	6283387	6678878	7534086	7922564	7994818	8512656	9394094	10294805	11044911	12174175	13923102	15830393	18325970	22559036	28036429	31445322	34003386	35737757	36672655	37303803	37557485\nG	29	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	29	20233	33230	63746	561839	1513390	2056346	2586870	3227890	3451478	3523126	3887015	4880805	5160942	5437608	5906349	6151910	6686902	7413638	7772903	7986238	8614611	9307561	9560864	10584675	11494685	13029932	14765199	18411090	20831617	24033185	30998688	31709302	32517311	34903189	35600724	35972570\nG	30	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	30	18624	81588	433337	1466505	2103320	2468408	3311464	3484117	3595538	4120178	4520559	4985997	5354341	5612342	6149578	6232064	7408719	7835481	8271264	9579183	10443132	10906372	11411224	12880830	14541448	16397131	18845168	22564985	25804359	30074503	32654554	35825887	36407994	37075641	37277569\nG	31	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	31	17852	45492	149396	487159	1920790	2195823	2431293	3137718	3384809	3435837	3913194	4918158	5076114	5262512	5658759	6365501	6620747	7237941	7546869	8003442	8488300	10017483	10713998	12000892	13285565	14691894	17806002	21855635	22856184	26148879	29024006	33509962	34564136	34904591	35928828	35981840\nG	32	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	32	3496	39535	134570	549197	1365329	2259046	2280665	3172915	3548682	3961744	4193446	4637235	5259237	5434770	5986343	6311347	6757181	7255799	7867077	8183572	8670924	9791443	10706849	11275558	12526955	14194597	15989341	19037652	23689460	27587461	29956240	32717725	34240365	34749603	35646347	35783421\nG	33	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	33	32326	54498	173604	526197	1390949	2344529	2520975	3098546	3968664	4230974	4301967	5281248	5392582	5538925	6064063	6729447	7945250	8307863	8613090	9010338	10364654	10785798	11352998	12251719	13247676	14245012	16796755	18942291	22446107	27326847	32770812	33939891	35279674	36418145	37113858	37178069\nG	34	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	34	28418	68340	568019	1249426	2289920	2479210	2805449	3446020	3783619	4072850	4398025	5164799	5412334	5674797	6278609	6753478	7609797	8156208	8433563	8984837	10009361	10439748	10966148	12758728	13989654	16376794	18364971	23261514	25386849	29186916	31158279	34870299	35562281	36189892	36303132\nG	35	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	35	8972	23798	36872	274129	1491467	2339427	2620176	3320811	3812651	4066866	4149561	4818904	5311439	5492363	5921253	6670928	7273137	7635379	8011268	8626988	9054339	9596559	10783547	11403742	12851691	14731948	17025470	21193018	23651936	28659636	30728167	33566556	34971523	35664729	36409350	36488401\nG	36	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	36	50968	61821	136266	338175	1882457	2629001	2907055	3546377	3965311	4476502	4754938	4988122	5735007	5907904	6376111	6753184	7082674	7367554	8068738	8649927	9502140	9938208	10777382	11484017	12632953	13787655	16421426	19254687	22253828	26800668	28964347	32984773	34139905	34681088	35707409	35934733\nG	37	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	37	46623	48080	108905	300997	1510250	2432750	2758781	3052438	4251829	4512344	4619470	4881736	5677185	6455519	6572034	7440130	7750376	8361024	9256471	9918702	10463038	11117332	11947952	12871564	14130473	15521526	17149577	20445985	24848576	28315663	31530767	32007904	33478149	35745635	36161936	36413003\nG	38	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	38	57834	66125	91973	269965	1578177	2622690	2812485	2893098	4128981	4389923	4449162	5157354	5665584	6167636	6333274	6874400	7302751	7787681	8561975	9021990	9703571	10241110	11069042	11770264	13540858	14655085	16514165	18855284	23650548	27417559	31841554	33859773	35061012	35712115	36315588	36362365\nG	39	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	39	34577	47439	174698	357988	1779475	2788297	3514440	3882751	5165070	5231892	5571512	5710995	6523555	7058295	7353721	7692480	8500479	9207009	10143171	10564771	11015819	11562149	12741508	14087227	15435666	16629563	18687049	20967362	26521970	28123100	30289864	34730829	35561590	36397083	37425068	37581845\nG	40	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	40	56790	63290	78688	337161	1772437	3018850	3246961	3272647	4653323	5074565	5361325	5475512	6635548	6754316	6994483	7589129	8321547	8979828	9627346	10299068	10755157	11301180	12433033	13436573	14867495	17003593	18022633	21999111	25044251	27450035	32683650	34205910	35119096	36410056	37270620	37653627\nG	41	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	41	34900	65741	73235	378494	1714135	2772734	3576534	3788147	4335563	4970203	5284311	5393054	6495788	6631989	6950786	7432446	8607074	8737149	9118825	9907413	10255212	11107534	11774387	13325851	14882008	16660707	18447633	21499979	25716280	27523605	29921533	32669456	33209713	35775513	36576158	36842649\nG	42	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	42	30062	38043	112904	342474	1577241	2554916	3183102	3682616	3894662	4990904	4995038	5323739	5712201	6664156	7034596	7401003	8801476	9532397	10049855	11140642	11748260	12108344	13242168	14012920	15259937	17611650	19062614	22889267	27573469	28827021	30815635	33536786	35918845	36741028	37408811	37634926\nG	43	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	43	28128	62504	105165	574249	1960057	3024284	3649794	3880153	4550081	5428270	5677202	5840197	6193636	7714553	7980583	8262003	9026723	9801099	10451252	10954480	11304912	12465512	12842715	14091119	15495004	17250954	19584102	23267173	26556932	29778550	31061249	33503052	34429231	36854228	37468067	37524489\nG	44	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	44	64252	71592	131894	379855	1954564	3109171	3651460	4203808	5302996	5489286	5753045	6209305	6612863	7575148	7757844	8325848	8969472	9543437	10363081	10546027	11717706	12296408	12784696	13731409	15133573	17199633	18608072	21073342	26267389	29077464	30968887	34375888	35531076	36229522	36917745	37032199\nG	45	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	45	15058	86115	134991	432142	1637173	2901114	3603356	3835891	3973309	5425838	5485230	5765975	6135341	7181122	7918849	8398755	8653294	9077907	9724365	10418606	11404633	11739799	12211795	14487246	15725912	18069814	20083527	22667395	25966128	28751655	29481154	32137146	34833213	35959056	36566964	36681821\nG	46	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	46	53329	81208	100134	523774	1318496	3082861	3682005	4027097	4418785	5578404	5750683	6062608	6478748	8133444	8309468	9001810	9813711	10462149	11004579	11842465	12187638	12977934	13290809	15688816	16724720	19176314	20757525	26061920	27720480	30221080	33674255	34868038	35874010	36462185	37470192	37535233\nG	47	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	47	64356	66167	82370	804212	1878876	3226653	4108193	4453452	4871899	5541596	5805613	6204538	6975761	7931953	8694436	8972059	9939682	10234982	11405875	11669132	12419726	12785548	14352243	16065057	16940606	19139374	20952563	23037766	27245161	28876794	31868802	32770807	35023128	35534739	36246262	36475195\nG	48	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	48	88500	166480	543800	1918996	3421534	3879507	4422604	4478953	5769870	6099639	6209111	6644112	7479031	8258226	8907320	9472393	10065478	10921377	11451919	12108394	13261684	14684166	15479413	16550320	18891236	21242610	23956749	27050748	30772013	31798956	32631576	33742977	34433073	36329499	36385717\nG	49	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	49	72080	83257	172493	358069	1932198	3164102	4044504	4721901	4744577	6193180	6511279	6920821	7060085	7831507	8344725	8713343	9436158	9909177	10894604	11697177	12662972	13482771	14164444	15403768	16698907	18952130	20799095	24747112	27289100	30620361	31412107	34462670	35752668	36582652	37061012	37295851\nG	50	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	50	45514	69494	113428	424497	1794479	3291033	3902590	4284816	4526041	5579051	6266468	6725991	7593184	8095949	9062493	9447129	10245298	10622626	11448280	12092899	12761824	13615420	15228593	16055844	17204030	18673068	19967588	24487621	27402969	28590401	31937158	33190596	34017302	34472876	35603732	36723636\nG	51	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	51	8043	113107	593566	1754909	3181981	4226764	4344136	4606201	6003484	6405874	6635408	6981751	7089216	8636120	9056775	10065781	10456869	11058946	12319531	12810904	14066079	14979776	16426597	17908127	19931576	21188634	24478908	27261669	29599628	30839527	32032703	33803144	34874537	35448199	36436909\nG	52	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	52	38556	49424	97819	849873	2276592	3740236	4353901	4713092	5282625	6342727	6761184	6978467	7431283	8355116	8762650	9128610	9591924	9982571	11097542	12073814	12825817	13802471	14921246	16418036	18835268	20331526	21660894	25390697	28846313	30193060	30875443	33690431	34537959	35224845	36135408	36313042\nG	53	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	53	64957	76702	119981	634320	2139359	3333951	4419824	4698851	5233468	6274960	6597087	6980848	7382393	8225173	9707739	10183041	10949256	11668577	12778039	13295476	14191679	14771656	16329556	18138465	19776655	20863463	22660659	24498336	29399032	31259385	32090406	32972459	34571892	35223686	35878926	36247045\nG	54	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	54	60921	70583	124556	601948	2030403	3647302	4253669	4669628	4925415	6270934	6827069	7247045	7582109	8879967	9608993	10047465	10322475	11178331	12499789	13086685	13726344	14768831	15651183	17203123	19032333	20783435	23083698	25573808	27842165	30002769	30832665	32636524	33859210	35260519	36103574	36249147\nG	55	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	55	8489	30556	123642	1200620	2277323	3544993	4290786	4822754	5765614	6731680	7596267	7926022	8654941	9603959	9837076	10781761	11157422	11388171	12524165	13310437	14422854	15328502	16378305	17710283	19535272	20892208	23059218	24467204	27710391	30030776	30837372	31951960	34456561	35473272	36025516	36194680\nG	56	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	56	10153	22212	128560	652979	2823782	3111264	4390087	5462746	5472693	6410086	7415447	7770196	7862329	8269852	9458752	10176124	11053360	11752844	12743413	13553364	13956408	14783171	16163997	18113136	19274853	20462110	22567876	26496031	29228742	29914054	30719821	32064654	33511168	34472059	36026093	36098288\nG	57	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	57	63932	130747	1278624	2653508	4032741	4682810	5343467	5376430	7144158	7987029	8228472	8603960	8725206	10068157	11055757	11698194	12418767	13041964	13963549	14941431	15608265	16514142	17660424	19075285	21252920	22911921	25575987	29447355	30731741	32477052	33735742	34219569	35240099	36036769	36112163\nG	58	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	58	238159	1630612	2684344	4176798	6078838	7980044	8395453	9763933	9890690	10808142	11731596	11968004	12003175	12431655	13354927	14098084	14492211	14992776	15408307	16477551	16897563	18039461	18961542	20277171	22017221	23362613	24312294	27883335	29413357	30066907	31271663	32207669	34255273	35379644	35996436	36233774\nG	59	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	59	541009	1081903	1154183	4409344	7434742	8452647	8704383	10005623	10103932	11132900	12046431	12298507	12390008	12836845	14073740	14398643	14822545	15667954	16042085	16226430	17411197	18242073	19852585	20770212	22077068	23614008	26345792	28197631	29938055	31618020	32575070	33669864	34930666	35777337	36255173	36361444\nG	60	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	60	543369	1958224	2644045	3370395	6723423	8492380	8899706	10262820	10342709	10770429	11894701	12431163	12659041	13068845	13762591	14506777	15071248	15438270	16096682	17214490	18193855	18656037	19539603	20975301	23138046	24087393	25234434	28532969	30538611	31401218	32301520	33818447	34592991	35345923	36279258	36497484\nG	61	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	61	975424	1464240	1743988	4561217	6709623	8586569	9018324	10294146	10515481	11534823	12183534	12873061	12990125	13993614	14624956	15223685	15558235	15770530	17097417	17831825	18720892	19467530	20426751	21790408	23990693	25383642	27900017	29883920	31130534	32488376	33797790	34899884	35459578	36286094	36678497	36781493\nG	62	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	62	117545	119994	2840884	3842707	7876831	8989734	9482503	10560782	10833912	11906274	12498617	13190418	13224227	13671405	13930664	15465550	15885727	15939329	17007478	18073252	18940224	19418552	20637639	21786989	23575315	24426870	25743455	28742066	29958573	32219537	33670415	34277703	35295984	36178253	36651284	36718614\nG	63	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	63	605720	1587481	1661866	5531305	7266656	8951460	9719285	11010295	11227627	11707058	13137312	13449006	13707472	14063929	14243901	16105143	16265118	16386094	17146544	17910902	19138381	19693182	21387302	22067967	23703570	25267174	26362902	30207797	32134724	32871100	33680090	34810763	35621967	36272117	36848994	36984879\nG	64	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	64	69938	1069894	2378042	3945667	8308242	8947026	10054745	11309011	11587963	12047368	13246231	13759261	14020075	14584928	14645131	16270650	16716023	16987465	18026552	18648302	19473425	20308005	21857670	23433639	24481262	27020659	28600541	31188561	32777738	33604908	34587139	35109137	35735159	36444777	37032809	37102115\nG	65	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nG	65	90231	103029	1660660	4744712	7109872	9428174	11168903	11681911	11917221	12152653	13728268	14311262	14602381	15034921	15966900	16660730	17471484	17743828	18096305	19626789	20138883	20988180	21847757	24162773	25984851	26541273	27467267	30830244	33015840	34040073	34634853	35125856	36079771	36537477	37085485	37199238	37538173\nG	66	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	66	82510	637801	1905231	4826704	7467886	9249867	10569633	11771083	12213279	13132143	14070731	14657293	14984459	15073269	15686781	16704521	17718350	17887448	18699764	19608421	20592766	21218230	23655677	24418731	26091664	27056848	28593247	32182495	33945195	34682163	35269365	35985552	36677131	37262322	37648257	37812055\nG	67	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	67	111850	784308	5624595	8637576	10581415	11230836	12185073	12463639	12904289	14463984	15101922	15334911	15602991	16695420	17864655	18319864	18719265	19576348	20256349	21534628	22656386	23808370	26332065	27534148	28494051	30259328	33464101	34177653	34957163	35552221	35920688	36357799	37172518	37385252	37671703\nG	68	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	68	659917	767875	4408492	6629847	9481679	10794230	11284489	12375592	12851521	13018706	14500646	15319846	15696718	16347225	16490347	18255317	18426678	19260011	20026392	20965041	22628572	23601670	25905768	26532315	28153670	29053823	30715742	33891641	34697164	35373471	36434007	36778651	37090247	37503866	37793552	37876354\nG	69	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nG	69	704681	2644010	6485637	9968433	11485744	11787485	13088753	13487893	14530996	15961021	16096412	16535111	16741186	17280037	18527592	19649912	20036185	21490010	22250673	23733918	25771596	27383609	29125566	30432364	31319232	34005777	34996470	35765138	36322570	37046898	37291780	37728712	38273884	38471160\nG	70	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nG	70	102986	441334	3809224	7359891	9886279	10780720	12153807	13194411	13859447	14006548	15649678	16289621	16759824	17296819	17641236	19350637	19769726	20656309	21997621	22685707	25021211	25976685	28238585	29935812	30741360	31522999	34360549	35789033	36193938	36436997	36768012	37307660	37720356	38019828	38210275\nG	71	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nG	71	706709	1876693	3650979	6590931	10938058	12169280	12815857	13956037	14214809	14502614	16059252	16995823	17418421	18015335	19263701	19982924	20977490	21746549	23314370	25187171	27254459	28232789	30301764	31129001	32103297	33058401	36354967	37243108	37524672	37684933	37985706	38205914	38461383	38744116	38894626\nG	72	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35\nG	72	782842	2452783	4419344	6896610	10886312	12380573	12550118	14226708	14695689	14856555	16493635	17250101	17743401	17943502	19767573	20660454	21120431	23270124	25078317	27134204	28837854	30386758	32001347	33994808	34623481	36875486	37111214	37347102	37609336	38017969	38241392	38299704	38443812	38502710\nG	73	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35\nG	73	774739	2312242	5294408	8597483	11416315	12168789	13383328	15136798	15495266	15827505	17523150	18493020	19031712	19714857	21637363	22322522	23300730	25735447	27163938	29414098	31564487	33039637	35617157	36554014	37170737	38374347	38919068	39075763	39236063	39530557	39577711	39742818	39803788	39929046\nG	74	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nG	74	98683	1861175	2029079	5350393	7603234	11197457	12408270	13193186	14400088	14969534	16536713	17522855	17828810	18133368	19740399	20209064	21942755	23624856	25351967	26161353	26977426	28583733	29895686	31781447	32275268	33351924	34022877	34837961	35023562	35155308	35309155	35492483	35596550	35791565	35811317	35850766\nC	0	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nC	0	187950	239285	765243	1594120	2413882	3351556	3807445	3941038	4597363	5067943	5657143	5906550	6441931	6951746	7701455	8570113	8908401	9302749	9929722	11120237	11716639	12653715	13666714	17161350	19570592	21732132	26970884	32385325	32856368	33267659	33543552	33818121	33994361	34032244	34108539\nC	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nC	1	179750	223691	690112	1494288	2213359	3045801	3454342	3567462	4153652	4584832	5060385	5277015	5766783	6169759	6739523	7470912	7805866	8106863	8658442	9645677	10056330	10848162	11685141	14563804	16811961	18801168	24724798	30044544	30479253	30835643	31090682	31366034	31554319	31595802	31676265\nC	2	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nC	2	313952	356225	769495	2166509	2391379	2895008	3443764	3685603	4580708	4741057	5299330	5763499	5808138	6576040	7197100	7542921	7995308	8522147	9262468	9529031	10350655	11360182	11949891	13618748	19835375	21462171	25505438	32576400	33305086	33363335	33517803	33911956	34207556	34245384	34348273\nC	3	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nC	3	64239	171660	640034	2001837	2417185	2997725	3595388	3926753	4447957	5154441	5784884	6080560	6608090	6896574	7430860	8330981	8926748	9367397	10587083	11529034	12483996	13620526	14747634	18169232	22673296	25658057	29349609	34243005	36035724	36394982	36428200	36902434	37065942	37092069	37144744\nC	4	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	36\nC	4	154400	216880	693448	1771740	2312544	2841093	3349246	3728551	4230180	4713869	5274697	6177976	6593161	6993523	7232552	7819504	8148649	9008950	9139607	10499063	11616043	12356045	15425654	17992397	21732176	24714675	26435685	29351755	32459689	32529105	32685883	32787610	32858596	32909485\nC	5	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	33	36\nC	5	91971	286818	638676	1839101	2463949	2908030	3751851	4006759	4602378	5151812	5443324	5876457	6158293	6635224	7395056	7780197	8426644	9368207	9912690	10817389	11384402	12217870	13513870	16872782	22915443	24652398	29174986	32685922	34195435	34363070	34571027	34672861\nC	6	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nC	6	117453	422031	804754	1454574	2323644	3392776	3573370	3705743	3942877	4754022	5105525	5780713	6087738	6749647	7330347	7924286	8333271	8927731	9612066	10314276	11124468	12124419	13816780	14884586	17793127	22536251	26298016	29268183	31053949	32559869	32593559	32745068	33055566	33076174	33125933\nC	7	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35\nC	7	80561	99447	573082	1655085	2230837	3012917	3538152	3684833	4011072	4846799	5194733	5675318	6355696	6665393	7260330	7879807	8056193	8421502	8835218	9466802	10477030	11199289	12478940	13642764	15363507	19705350	24868397	27835083	33002959	33444768	33608820	33761667	34066187	34096328\nC	8	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	8	149751	361374	728546	1631574	2412772	3380625	3618963	3690465	4204441	4861159	5190093	5624877	6152015	6314275	7053571	7320299	8029224	8199983	9116588	9715511	10700866	11280116	12164253	13323955	14378741	18437781	23779927	28720260	30453379	31240847	32637567	32983129	33109905	33278244	33536713	33687423\nC	9	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	9	163095	283510	567991	2129386	2553989	3136792	3812574	4084662	4904649	5371264	5777364	5954841	6657941	6930725	7307094	8072777	8442953	9894794	10072554	10808457	11323502	11996278	13227682	14471703	15907546	17753569	22266628	28890265	29338912	32173382	32769263	33293353	33492033	33590778	33784813	33879331\nC	10	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	10	79115	408959	426513	1397396	2478759	3246957	4103792	4225648	4871272	5009089	5466081	5840427	6331765	6691119	7338475	7701195	8134438	8726745	9180837	9860438	10626322	11270546	12392627	13280676	14644799	16807394	19946887	26067561	30484846	32015592	32250503	32548605	32771525	33075044	33318412	33404033\nC	11	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	11	125823	219139	758326	1418824	2861775	3132273	3940240	4538068	4750716	5834029	5882871	6433562	6908525	7190483	7949735	8463833	8997518	10022765	10436058	11449321	11942340	12607234	13493388	14837498	15975137	16893329	20035388	26649370	30222946	33532121	33790574	34383531	34620299	34677814	35023865	35118447\nC	12	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nC	12	60827	92288	128806	518015	2340512	2561432	3023312	3797392	3895789	4032088	4935404	5242874	5385841	6220475	6762792	6882985	7500165	8019420	8128087	8412372	9022907	9964246	11018035	11979406	12899768	14537904	16676377	19035515	24131608	28475467	31139982	31937000	32324560	32585825	33236239\nC	13	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nC	13	24225	64959	88376	513436	1902117	2634475	3022468	3775793	3852291	4039267	5055199	5166877	5778428	6149457	6858787	7331574	8020694	8517714	9115792	9411552	10198499	10917260	11645099	12330982	13395543	15237995	17514804	20197246	22984218	28612167	30966393	31970645	32802202	32996906	33502453\nC	14	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nC	14	55196	121913	162516	637944	2254674	2641017	3187379	3727943	4226182	4337443	5332680	5495745	6191015	6726830	7038096	7660675	8077914	8811811	9437523	10011471	10788446	11511016	12321740	13466721	14161221	15229695	17232386	21485940	25632508	29290270	32245623	33715832	34096846	34372183	34897488\nC	15	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	15	83783	108138	189063	768696	2181796	2798165	3189211	4003504	4106889	4479743	5294670	5641105	5900173	6349900	6769408	7198725	7643885	8159200	8598728	9509000	10055385	10512817	11166256	11790924	13206407	14220903	16117377	19391138	21805140	28809485	30136327	30419115	32448766	32669100	33356696	33451505\nC	16	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nC	16	71665	86907	103921	475474	1875658	2813095	2916419	3897645	4163848	4299933	5265518	5555191	5971062	6397007	6669017	6944061	8108267	8956081	9058120	9579824	10792180	11275859	12210570	12917145	13392754	15230239	17136084	19520926	22824731	27733760	30199876	30816125	33143074	33295950	33581620\nC	17	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nC	17	35569	59626	178638	414411	1399340	2649410	2729155	3517970	3894663	4224371	5063104	5338256	5904043	6171242	6668303	7124927	7676057	7964206	8850563	9246691	10194031	10864476	11908566	13094812	13762070	15358474	17778771	20009936	21983089	27089294	30446233	31658145	33015432	33231364	33816050\nC	18	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nC	18	35900	40823	89435	390276	1533005	2479078	2945619	3738423	4155983	4338998	4866747	5392083	6063960	6564696	6938446	7374130	7947654	8397247	9035454	9949099	10373372	10897535	12259845	12660053	13982725	15668478	17396388	19448503	21724289	26010649	29603570	30802528	32770593	33069471	33736505\nC	19	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	19	101393	118592	153163	390691	1692054	2750135	3217530	3419745	4422348	4439412	4970612	5550332	5723807	6159928	7031652	7269905	7808349	8120608	9123918	9631932	10172366	11239528	11862429	12589759	13747680	14815017	16217404	20764218	21753024	25098127	29375077	31347758	32555904	33025622	33495573	33645124\nC	20	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	20	19642	98547	154333	438260	1539817	2596600	3037817	3746763	4191256	4590655	5169959	5775089	6121458	6183928	6937213	7362141	7838721	8761107	9041100	9703147	10560305	11453641	12000443	12536945	13087118	15067181	16798629	20626148	21966883	27889308	30355690	30896276	32488352	32841163	33427927	33589042\nC	21	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	21	31575	52354	67952	211945	1183926	2671140	3035487	4009981	4278132	4477139	4877391	5411180	6066930	6760631	7355281	7844937	8199307	8252768	9009725	10297680	10471763	11224231	12200457	13553429	14327750	15562468	17299264	19549735	23374229	27219399	29848744	31889491	32625774	32970703	33386093	33684109\nC	22	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	22	53270	90102	117620	458096	1567488	2856004	3150453	3857766	4074770	4829329	4933456	5797977	6328613	7052159	7713221	8135676	8440246	8741323	9873105	10267480	10709272	11731610	12078666	12542245	13665185	15250014	17141806	19559718	23155453	26021064	29168842	31550783	32431534	32787129	33199969	33503226\nC	23	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	23	2402	51038	84971	256028	1760275	3098701	3739675	4478742	4725945	4966260	5262833	6081986	6635293	7132981	7828197	8000355	8551816	9177208	9694869	10673939	10965783	11436595	12664079	13484612	14059625	15770673	17654466	20029503	22639945	27844023	30619964	31330337	32689758	33218595	33754726	33830234\nC	24	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	24	24241	42535	142492	415819	1641423	2617119	3147653	4123647	4215066	5043310	5116770	5885976	6593623	6834773	7957064	8406246	8736542	9265618	9997825	10748441	11147773	11927490	13115265	14156611	15059585	16353288	17865612	21722701	24601337	28318949	28882137	30913077	32215808	32847124	33477377	33665252\nC	25	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	25	73476	119274	175005	368897	1269308	2830686	3106763	3848623	4369445	5168895	5182010	6297563	6599987	6638739	7276513	8258695	8656398	9060528	9526866	10753037	11368833	12345030	13282138	14964105	16321038	17681446	18958036	20879330	24496513	28057399	28875718	31541467	32353125	32528086	33107339	33587914\nC	26	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	26	26255	39665	108580	260658	1336759	2803921	3384782	4237616	4699042	4996775	5084973	5387866	6543581	6699970	7568134	8402400	8823199	9051427	9987659	10644613	11182460	11993829	13776856	14217651	15570827	17181969	18824708	21653558	25194628	26323215	30812058	31285079	32798690	33270584	33742239	33796390\nC	27	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	27	47395	83316	412714	1115843	2671175	3220667	3955976	4480856	4875257	5130244	5745693	6245955	6548488	7388629	7843456	8032193	8979176	9370339	10483932	11070798	11850468	13060082	14392817	15516502	16996438	18422283	22265740	24094089	27187589	30858980	31912665	32500831	32859366	33315106	33774504\nC	28	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	28	18423	92651	226606	802286	2410621	3533242	4232995	5136189	5429085	6056116	6671705	7450189	7619732	8098028	8613783	9321503	9967835	11219019	11837024	11939767	12725450	14149655	14920822	15887049	17185915	18593001	20298939	22743844	25181013	29326738	31342350	32238651	32822619	33096055	33424858	33644351\nC	29	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	29	24791	46357	114805	840102	2491482	3349839	4117220	5028962	5402770	5510310	6025719	7530302	7869605	8330656	9081866	9478645	10314760	11557878	12160577	12526460	13573209	14719882	15118067	16412754	17553149	18894941	19986408	22415468	24598286	26956758	31671860	32114831	32664011	33349868	33624841	33908675\nC	30	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	30	27874	153415	699056	2498255	3395076	3855062	5059506	5339381	5496234	6239861	6839200	7529208	7964610	8343867	9069904	9198622	11122762	11684837	12338989	13862391	15117165	15870994	16550672	18110198	19342853	20811941	23135657	25336380	27424285	30355157	31874452	33032575	33216202	33617404	33785398\nC	31	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	31	31741	83664	261450	922720	3163008	3666037	3998231	5028827	5442751	5520996	6290122	7850775	8024925	8211211	8852517	10065347	10493421	11593520	12104469	12882922	13749557	15274680	15904304	17656504	18850517	20172160	21795184	25418524	25907580	28822833	30636884	32902781	33692467	33838800	34273850	34321275\nC	32	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	32	7971	66019	233831	866957	2407270	3782227	3813196	5093665	5722618	6396946	6744111	7405840	8463792	8743314	9672853	10252089	11030271	11857868	12858202	13365091	14228505	15597791	16966001	17799688	19184114	20379682	21838774	23440052	27290138	29977140	31792908	32655739	33210237	33445903	33927854	33982958\nC	33	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	33	48276	86552	295815	791053	2436660	3756392	4051548	4873684	6131315	6559978	6655642	8098331	8261137	8510152	9372359	10262451	11394123	12009569	12483711	13122311	14786132	15448540	16387710	17725338	18551346	19195494	21305052	23377011	25414715	29148302	32354873	32713730	33389853	33844650	34138210	34195568\nC	34	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	34	48064	124365	873342	2059372	3678865	3970808	4444641	5356998	5920127	6335310	6766643	7951059	8375141	8793946	9802718	10443409	11884122	12757605	13216494	13743840	15396976	16033064	16575379	18598797	19505566	21930067	23680196	26969724	28014826	31047292	32292499	33407869	33633139	33871663	33957870\nC	35	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	35	15041	32137	67700	487678	2427191	3693887	4178271	5177956	5909489	6306741	6431081	7487559	8111544	8405786	9036318	10273120	11275533	11855189	12477117	13156430	13857365	14743521	16402777	17114861	18620575	19713056	21325749	25217462	26226586	29378861	31192958	32930637	33472533	33695667	34041879	34079947\nC	36	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	36	80208	109403	278897	669367	3262409	4360073	4860769	5888543	6487499	7298066	7773143	8185753	9362441	9666718	10495435	11119903	11692734	12183431	13427595	14370505	15499536	16227010	17518305	18489055	19479154	20332577	22028408	24755913	27240642	31114377	32850936	33628016	34253975	34477218	34961279	35101442\nC	37	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	37	82858	84962	209479	548115	2579052	3911349	4403180	4843945	6591408	7004608	7165241	7564963	8696643	9955273	10139880	11568209	11931782	12966634	14256173	15032983	15825233	16944408	18255486	19317671	20570598	21282944	22157585	24250525	27214928	30218312	32689457	32844535	33419651	33835814	33992022	34188805\nC	38	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	38	113584	127185	176838	545796	2636199	4312055	4615576	4749674	6643536	7077898	7169206	8352695	9188488	9944172	10214192	11145573	11895957	12579420	13821931	14308527	15385813	16105833	17373611	18291832	20351917	20948295	22370534	24851070	29112807	31120228	33323666	34077331	34790791	35110510	35326857	35389485\nC	39	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	39	71031	87984	317983	629451	2701561	4054770	5015609	5494655	7279730	7370702	7892901	8089160	9259732	10094101	10555128	11077895	12322270	13468765	14847553	15525728	15986654	16831264	18442992	19929644	21202948	21842820	23388404	24806080	28240556	29182072	30906173	32904665	33253752	33623329	33873069	34021645\nC	40	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	40	93929	120507	150268	575613	2602793	4320671	4679773	4718324	6555417	7169037	7639079	7797672	9515711	9689723	10064943	11026934	12180214	13238991	14069067	15140602	15827962	16683212	18128413	19541272	20747956	22083370	22738892	24964635	27395886	29305544	31943758	32569600	32944231	33582199	34002849	34307403\nC	41	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	41	52619	104468	123925	636420	2535809	4051906	5123005	5441964	6248699	7145247	7638915	7790733	9495636	9704494	10249042	11008089	12978952	13152553	13698551	14842685	15387005	16582312	17530015	19089466	20599869	21732994	22752747	25418239	28619635	29900445	31714129	32958542	33267481	33884071	34195188	34355736\nC	42	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	42	48686	61214	202595	585094	2245222	3716448	4566537	5289327	5581907	7104760	7109184	7641887	8171777	9629648	10228180	10530925	12498693	13576365	14379601	16153498	17094108	17565823	19085828	20063894	21177977	23095860	23931594	26906717	29725221	30226551	31768500	33264615	33798305	34215250	34496589	34662749\nC	43	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	43	64690	117492	198093	957033	2981465	4357554	5252159	5630759	6566968	7784817	8207794	8445935	8919073	11083565	11502133	11951087	13006418	14093180	15137354	15932468	16522078	18013429	18472233	19886555	21426970	22691286	23960012	26996215	29609129	31545296	32191587	33332125	33742478	34269406	34610746	34659419\nC	44	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	44	123227	131933	231936	671836	2694304	4246148	5066588	5812997	7354409	7630578	8048718	8719405	9349329	10798730	11086867	11756962	12787469	13590286	14953459	15228022	17074040	17800059	18513275	19555743	21094622	22094741	22792151	24584426	29104540	31538033	32105751	33424886	33924289	34140329	34439537	34526721\nC	45	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	45	29763	160051	248852	716503	2200069	4073088	5101457	5478595	5683225	7810166	7897825	8381754	8967125	10489897	11561419	12353407	12779268	13549730	14580877	15744814	17280533	17856071	18345263	21064094	22240175	24159726	25230407	27489987	30140660	31959485	32301957	33718129	34487873	34795138	35039354	35151053\nC	46	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	46	104641	149169	185000	823082	1795358	4123834	4851672	5413975	5955378	7556509	7746481	8254403	8884867	11324483	11583085	12397400	13749379	14492016	15295081	16626148	17153805	18258718	18678122	21498564	21923545	23137087	23863275	28198240	29575049	31566508	32889670	33471326	34029288	34154227	34357360	34393367\nC	47	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	47	103159	106828	131924	1002989	2829901	4545139	5835311	6428975	7003696	8054144	8484184	9181980	10325517	11950591	13266439	13620835	15154212	15573002	17378479	17785987	19036032	19457024	21572642	22888242	23689119	24900161	25973015	27329519	31143462	32087668	33956526	34288774	34604025	34872425	35158044	35384575\nC	48	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	48	164625	302249	900533	2843404	4893307	5513944	6393691	6474282	8484383	9051954	9230067	9913598	11211279	12558303	13699153	14684853	15546225	17090692	18023404	19006272	20423262	22316722	23209129	24111688	25467808	26838588	28831804	31757211	34235234	34597290	34784259	35128646	35462317	35738080	35794530\nC	49	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	49	133421	154185	313444	574334	2721661	4183233	5265079	6290281	6317323	8407118	8834007	9455913	9658675	10808572	11613591	12204066	13390783	14176174	15742013	16890753	18450588	19614351	20648579	21885013	23155611	24434963	25123849	27536029	29303654	32109225	32564373	33668317	33982798	34353786	34510286	34718429\nC	50	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	50	96750	128562	194206	714161	2330374	4220577	5022428	5548003	5956445	7503692	8513687	9326883	10547530	11340099	12708366	13404633	14618245	15258888	16497176	17565080	18525682	19771076	21749132	22738335	23522410	24253588	24771082	27705136	30516021	31048169	33227815	33787419	34101128	34219427	34490156	34652563\nC	51	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	51	13192	205953	933555	2186678	3962740	5388898	5596474	6046912	8048003	8665897	9052535	9613297	9783437	12268331	13017208	14460700	15141024	16071784	17990143	18776141	20552809	21529445	22688814	23680989	24766241	25274531	27797866	30348798	31934984	32389776	32822793	33569689	34141359	34303153	34404864\nC	52	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	52	64983	76937	159922	1230967	2924950	4789496	5602487	6130139	7105690	8683697	9350966	9741888	10489669	11922154	12613753	13208711	13807489	14476798	15970587	17680338	18883783	20124868	21517564	23036068	24624626	25449799	26086862	28946198	31862650	32504647	32653666	33691571	33917979	34101445	34368609	34408121\nC	53	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	53	148272	161821	230733	1037240	2884659	4251661	5775518	6312312	7183081	8736123	9142007	9786990	10351084	11665689	13879214	14722073	15868171	16896514	18596242	19376214	20856190	21698593	23515629	25026909	25981841	26757603	27784780	28677476	32878711	33663608	34022918	34436141	34710104	34850072	35056238	35245188\nC	54	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	54	116908	137233	235376	937832	2529160	4569251	5417014	6000038	6440950	8423726	9309602	9890187	10480313	12619408	13808979	14546094	14828113	16072042	18233914	19233803	20272170	21679230	22635949	23814712	25454272	26488076	27539862	29376358	31055085	32623707	33073955	33797528	34135416	34320110	34544971	34649019\nC	55	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	55	21728	83516	225467	1252240	2829919	4177599	5191771	5956637	7321663	8718689	10171418	10703088	11840992	13094894	13339786	14922127	15501598	15708649	17453786	18689469	20548695	21820539	23048062	24293317	25409385	26141223	27267459	28005417	30629648	32268592	32750513	33116086	33842973	34151805	34375839	34428500\nC	56	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	56	16761	61612	233698	988599	3300390	3848963	5282867	6846425	6866146	8283755	9831247	10399378	10545581	11278770	12963329	13878112	15205596	16378982	18072089	19316400	20060219	21182372	23025397	24877173	25795998	26448895	27594013	30268111	32270024	32466397	32928502	33314414	33823638	34215429	34492443	34521938\nC	57	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	57	133534	243430	1309199	2912428	4803797	5654669	6628072	6680374	9219064	10542577	10940833	11596534	11776394	13902577	15572850	16590688	17800488	18439552	19691118	21078241	21909275	23190489	24312521	25242388	26421878	27326915	29147613	32159458	32684925	33539038	33811888	33979785	34262507	34483014	34515892\nC	58	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	58	215842	1661342	3142039	4612269	6391459	8146927	8589492	10074554	10172203	11565597	12974420	13370250	13417737	14151969	15674024	16859120	17453083	18293619	18995735	20796077	21379669	23041301	24182535	25387836	26924048	27822633	28279381	30910040	32023215	32312669	32734797	32971715	33497626	33870242	34034783	34170881\nC	59	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	59	837646	1484352	1635220	4187101	6891845	8063010	8457882	9961071	10019367	11511087	12930783	13311960	13441095	14206051	16156424	16730488	17442950	18844159	19403149	19704199	21591043	22601134	24581480	25391858	26455546	27475438	29409253	30798865	32023497	32773704	33113710	33426688	33661539	33914962	34021763	34045867\nC	60	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	60	812669	2119101	2822289	3595437	6434057	7856229	8324438	9923904	10029160	10728651	12370352	13217408	13605105	14315001	15331843	16467666	17452746	18057961	19148618	21000689	22338332	23062676	24282441	25438267	27098779	27681566	28200299	30679234	32016810	32252060	32609630	33190026	33425136	33599434	33720603	33865244\nC	61	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	61	809542	1445747	1858255	4539465	5967338	7811898	8246548	9603466	9887093	11432654	12237239	13252060	13408434	15001882	15978005	16962020	17512190	17770842	20027424	21059535	22328123	23362272	24464364	25295687	26775602	27762238	29329261	30891341	31333295	32198202	32610426	32967918	33130241	33450504	33533028	33553941\nC	62	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	62	223082	229504	2711153	3518030	6497857	7824821	8486653	9633783	9889783	11470232	12253217	13396766	13445628	14205818	14625128	17077434	17797121	17867366	19582629	21221412	22563747	23226443	24564733	25780589	27132308	27736174	28379943	30546591	31059161	32401046	32825703	32990794	33239405	33461648	33590360	33645450\nC	63	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	63	731953	1329449	1457734	4299083	5781786	7626382	8072537	9442669	9782286	10496736	12657004	13051556	13474640	14092436	14340437	17364964	17635393	17801990	19094675	20317957	22086652	22929644	24904952	25504527	26680707	27661120	28223969	30863468	31944550	32253890	32518733	32805775	32887328	33019222	33161997	33270610\nC	64	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	64	143231	672612	1833911	3252073	6020410	7038146	7904585	9485061	9810381	10606593	12388934	13180257	13632494	14586064	14668756	17317925	18065788	18415979	20141430	21125837	22362482	23379704	25015217	26331707	27054058	28993083	29751597	31588102	32186138	32533173	32811261	32967234	33099216	33251073	33320431	33376602\nC	65	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38\nC	65	188731	207215	1723493	3482342	5270217	7010660	8818619	9513664	9835464	10136706	12334692	13284783	13769067	14492492	15898472	16969715	18337813	18765819	19320021	21555728	22313680	23545166	24457443	26520972	27689231	28093474	28502691	30711064	32091680	32393469	32513592	32655802	32900428	33023473	33193704	33220139	33227835\nC	66	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	66	172609	591136	1812859	3511148	5505297	6801630	7712090	9144732	9661477	10959158	12325235	13197045	13725260	13843181	14798868	16425565	18047403	18327010	19513139	20995869	22476268	23208692	25651740	26250511	27310060	27653259	28443006	30721526	31678657	31937950	32115596	32260511	32432694	32647079	32813880	32952336\nC	67	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	67	224419	912896	3786973	5706581	7353357	8105243	9175360	9487310	10064405	12433556	13434243	13839441	14208241	15903219	17881796	18594132	19253794	20432386	21478887	23353014	24719354	25694273	27651399	28244965	28879040	30049809	31972909	32146270	32405980	32559902	32611641	32701787	32839046	32865011	32872221\nC	68	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	68	543757	573427	2836779	4008208	5916833	7337901	8121047	9213110	9808205	10081113	12449850	13681351	14197298	15150751	15412036	18227257	18523762	19846327	20932784	22492267	24511366	25470854	27251312	27502022	28363853	28664796	29789109	31846502	32060704	32208506	32528697	32563676	32584256	32754903	32859376	32924226\nC	69	2	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nC	69	592106	1823172	3733565	6145987	7283460	7650833	9168096	9770765	11079490	13316404	13493283	14188405	14427378	15291156	17217965	18967496	19567998	21760660	22891106	24576393	26286099	27294280	27990261	28677506	29205734	30965136	31638168	31784414	31922517	32251638	32357063	32417517	32554913	32606658\nC	70	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nC	70	207799	232892	2296601	3660484	5362114	6564696	8110216	9230293	10176286	10219226	12745666	13683762	14433104	15316215	15845136	18574162	19258306	20638451	22558427	23735228	25888199	26770271	27790636	28591329	28999659	29306087	31106039	31992336	32128064	32189341	32295558	32369927	32460486	32537398	32586597\nC	71	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nC	71	512550	885978	2392961	3541650	5981313	7172138	8094576	9445537	9822249	10269251	12678051	14061624	14616205	15500716	17493972	18563480	20135874	21285859	23327138	25332817	26908796	27622703	28406515	28606036	28993443	29361504	31655642	31874653	31999031	32035625	32074847	32084728	32129998	32235880	32327721\nC	72	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35\nC	72	594642	974867	2248404	3373339	5952150	7505628	7561806	9544743	10255426	10427636	13034700	14123274	14904756	15186022	18190246	19558725	20261376	23203068	25181777	26755887	27521674	28265978	28899751	30040744	30181731	31821479	31931521	32079371	32220227	32388378	32438000	32453140	32492241	32522711\nC	73	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35\nC	73	547510	934145	2685731	3935962	5961801	6863168	7670371	9650248	10169904	10588059	13152969	14607951	15374190	16436554	19451673	20470365	21896170	24580472	25834887	27689499	28759229	29173022	30453634	30701478	30946134	31681940	31904589	31965188	31999706	32121765	32135259	32189008	32211671	32263380\nC	74	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36\nC	74	64590	1333960	1386516	2882351	4427337	6282961	7463212	8713025	9932250	10791334	13394219	14816391	15405194	15817069	18734235	19478977	21881314	24044187	26602756	27342919	28047282	29014276	29652060	30747823	30944190	31530094	31964422	32521259	32613626	32669674	32713308	32805496	32849250	32966016	32988018	33014050\nN	0	2	3	4	5	6	7	8	20\nN	0	35361	171573	340816	416201	1506231	1781913	1866907	2000973\nN	1	2	3	4	5	6	7	8	20\nN	1	245897	385405	567747	701825	1056095	1326132	1399655	1540951\nN	2	2	3	5	6	7	9	20	22\nN	2	323283	378988	708312	983679	1114484	1186275	1475086	1534539\nN	3	2	3	5	6	20\nN	3	136934	432317	631673	911357	1530752\nN	4	2	3	4	5	6	10	20\nN	4	180132	320961	520468	851351	941508	1014700	1454410\nN	5	2	3	6	12	20	23\nN	5	140678	219653	878174	967381	1126400	1450677\nN	6	2	3	5	6	7	20	22	23\nN	6	322595	404573	481793	883345	967482	1329936	1382919	1452339\nN	7	2	3	4	5	9	20	22\nN	7	142445	235060	434524	723782	806488	1144764	1478060\nN	8	2	3	4	5	7	20\nN	8	71569	124608	266629	644238	939082	1553386\nN	9	3	4	5	6	8	20	22	23\nN	9	142866	230323	683439	975803	1054731	1204365	1456868	1540987\nN	10	2	5	6	9	11	20\nN	10	100647	152323	660665	804087	899767	1554969\nN	11	2	3	5	6	9	20\nN	11	236614	286773	504999	807918	950561	1569801\nN	12	4	5	6	7	8	9	20	23	24\nN	12	249430	322590	588728	681243	985068	1085075	1118579	1504566	1578972\nN	13	5	6	7	8	13	20	22\nN	13	163299	292225	594833	694251	835256	1526364	1574109\nN	14	3	5	7	8	20	22	26\nN	14	140409	242866	667452	879470	1472850	1505797	1585449\nN	15	6	7	20	23	25\nN	15	586958	814106	1443948	1490534	1577140\nN	16	2	5	6	7	8	20\nN	16	215193	557797	774185	1171071	1299510	1629469\nN	17	3	4	5	7	20	22	24\nN	17	71018	156633	253182	823039	928184	1526691	1575691\nN	18	5	6	7	8	11	20	22\nN	18	140988	282096	740677	817784	898218	1184170	1581875\nN	19	2	4	6	7	9	20	24\nN	19	395051	466515	551099	833930	1117222	1513257	1593465\nN	20	3	5	6	7	20	22\nN	20	302789	353288	453669	948096	986440	1594474\nN	21	4	5	6	7	15	20	22\nN	21	73793	154585	389758	784844	859791	899842	1362042\nN	22	2	5	6	7	10	20	24\nN	22	345996	539415	747658	1011196	1085230	1206261	1567300\nN	23	2	5	6	7	20	22	24\nN	23	80806	166510	367968	903954	1158877	1195069	1555255\nN	24	3	6	7	8	9	10	22	23\nN	24	254734	330454	608356	1019708	1104205	1158138	1194684	1560574\nN	25	2	6	7	8	10	20	24\nN	25	265337	527147	944564	1002576	1091521	1127989	1575437\nN	26	3	6	7	8	9	22	24\nN	26	257447	586715	1013830	1074604	1150945	1187952	1562832\nN	27	4	5	6	7	8	9	11	23\nN	27	62551	357386	699964	958874	1039857	1113268	1188423	1566504\nN	28	2	6	7	8	25\nN	28	258796	739738	1003141	1103580	1568577\nN	29	4	6	7	8	10	22	23\nN	29	80779	520651	929038	1071970	1135181	1509504	1545021\nN	30	4	5	6	7	12	23	24\nN	30	154313	190376	640706	867437	933345	1302751	1562214\nN	31	3	6	7	8	10	22	23\nN	31	74575	512843	967921	1056232	1130647	1166983	1533985\nN	32	4	5	6	7	23\nN	32	115879	197800	791253	922452	1466910\nN	33	2	4	6	7	23\nN	33	79166	118972	962445	1265407	1517420\nN	34	2	5	6	7	11	22\nN	34	80587	129620	171971	931361	1279071	1530361\nN	35	5	6	7	8\nN	35	47469	793544	1058826	1520817\nN	36	3	4	6	7	8	9	24\nN	36	47015	176793	694212	852880	1186444	1264089	1449236\nN	37	2	3	5	6	7	9\nN	37	48029	230240	486557	1230511	1356910	1433716\nN	38	2	3	5	6	7	25\nN	38	124081	304658	351711	761311	1089973	1410649\nN	39	2	4	6	7\nN	39	229363	552141	1219585	1413429\nN	40	2	3	5	6	7	23\nN	40	266755	312794	390923	831878	1083919	1411420\nN	41	5	6	7	9	26\nN	41	366113	490363	893742	1145457	1469770\nN	42	4	5	6	7	24\nN	42	79491	306836	627823	1087206	1408603\nN	43	2	5	6	7	8\nN	43	93200	475787	1127560	1201988	1277061\nN	44	2	5	6	7	8	12\nN	44	116578	265925	734764	918918	1239637	1421017\nN	45	2	3	4	5	6	7	8	25\nN	45	259176	296465	374633	698108	769798	1095411	1166383	1483492\nN	46	2	3	5	6	7	25\nN	46	38142	293391	534332	1052163	1230857	1552606\nN	47	3	5	6	7	8\nN	47	255075	579494	1218877	1325410	1552770\nN	48	2	5	6	7	8	25\nN	48	300983	623769	955145	1109885	1188949	1499609\nN	49	2	3	5	6	7	23\nN	49	303532	380029	696298	958077	1180079	1492743\nN	50	2	3	4	5	6	7	13\nN	50	35494	215130	292298	374712	793784	1087752	1399297\nN	51	4	5	6	7	13\nN	51	35630	523314	773702	1102116	1421707\nN	52	2	5	6	7	13\nN	52	252619	707403	764058	1188616	1509268\nN	53	2	5	6	7	9\nN	53	307482	806847	968834	1199884	1526147\nN	54	2	3	4	5	6	7	26\nN	54	38980	295152	377332	682164	899316	1221552	1538422\nN	55	2	3	5	6	7	12\nN	55	263968	307683	791717	999619	1241311	1560901\nN	56	2	3	5	6	7	9\nN	56	261165	303472	794634	1066878	1237701	1564899\nN	57	2	5	6	7\nN	57	300332	797329	1147446	1572188\nN	58	2	3	4	5	6	7\nN	58	788648	833269	1277707	1423130	1777035	1865676\nN	59	2	3	4	5	6	7\nN	59	404962	485598	902645	1220965	1593051	1689795\nN	60	2	4	5	6	7\nN	60	664233	745445	1159510	1534370	1631117\nN	61	2	3	4	5	6	7\nN	61	38760	400100	1125828	1639881	1880987	1990193\nN	62	2	3	4	5	6	7\nN	62	119156	381458	807152	1176519	1477534	1667192\nN	63	2	5	6	7\nN	63	820120	1238309	1529090	1717932\nN	64	2	4	5	6	7\nN	64	37643	762897	1182017	1475078	1665649\nN	65	2	5	6	7\nN	65	234329	650979	1127760	1505689\nN	66	2	3	4	5	6	7\nN	66	375087	757083	893398	1309259	1462782	1658627\nN	67	2	4	5	6	7\nN	67	467361	791284	1262972	1652143	1762249\nN	68	2	4	5	6	7\nN	68	422216	1077577	1310720	1461013	1660071\nN	69	2	4	6\nN	69	661570	1292816	1784891\nN	70	2	3	4	5	6	7\nN	70	38199	126118	1086562	1173216	1475773	1671362\nN	71	2	3	4	5	6\nN	71	668691	817527	1248042	1557047	1761938\nN	72	2	4	5	6\nN	72	869716	1219946	1472301	1822716\nN	73	2	3	4	5	6\nN	73	842978	1149722	1203371	1608919	1814952\nN	74	1	2	3	4	5	6\nN	74	114836	570732	821440	1363919	1670799	1874081"
#define QUAL_DIST_ONE100 ".	0	0	2	7	10	12	15	16	18	19	20	22	23	24	25	26	27	28	29	30	31	33	34\n.	0	3905743	45345497	49158122	57009821	59025108	61049836	73186593	74775249	74919293	77067802	83794125	92125932	94625060	109130534	152157667	173621700	228617928	235434409	360506841	924229100	1050788673	1572984495\n.	1	0	2	7	10	12	15	16	18	19	20	22	23	24	25	26	27	28	29	30	31	33	34\n.	1	656238	42553987	46270739	59523316	60829670	63811399	85685424	87500618	87849582	90541237	98878279	107130755	109949995	122776265	161380042	203451500	250205648	255989649	353899708	831992900	886666997	1572984495\n.	2	0	2	7	10	12	15	16	18	19	20	22	23	24	25	26	27	28	29	30	31	33	34\n.	2	398051	42198059	46081160	69030791	70124368	72241217	102005717	103764268	103935340	106764469	116815033	126127923	128986547	144909255	182601025	232783825	279646973	284761753	374832749	802551304	837186800	1572984495\n.	3	0	2	7	10	12	16	17	18	19	20	22	23	24	25	26	27	28	29	30	31	32	33	35	37\n.	3	233992	42186073	45031477	59891489	60738132	68385901	73532113	74935981	90435769	92842607	98900996	101105449	103589380	111590841	125891324	136619749	165387764	167258376	202683922	215977480	282165857	332490950	664305828	1572984495\n.	4	0	2	7	10	12	16	17	18	19	20	22	23	24	25	26	27	28	29	30	31	32	33	35	37\n.	4	2364951	51205459	56536279	69659583	70881666	80366690	85961970	87756625	97500888	100122654	107317029	109253887	111414392	120437430	136195902	146709417	173202663	174539749	209721352	217627724	281571959	339058902	691504942	1572984495\n.	5	0	2	6	7	8	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	5	2308141	54358972	54368148	56536501	62182007	71043174	73104452	73552194	74624903	74803255	77284668	79890318	91211746	94880815	98175788	98811633	100189860	104073514	110523737	111840685	122044929	133885125	144065046	160148133	169487295	201894254	217692686	280883267	328072243	328085528	671559644	695059501	1572984495\n.	6	0	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	6	2343210	57503283	57515587	57529057	59064267	63788418	63788423	72190975	74371775	74710403	75720876	75833198	77907433	80004254	90293240	93429345	96512870	96976494	98121717	101749098	107132200	108284885	117995099	129053872	139352076	154125712	162741556	192979900	208765790	269917593	317934881	317950844	666797141	693881253	1572984495\n.	7	0	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\n.	7	2289285	60620873	60642287	60651516	62106112	66801085	66801112	75937828	78567863	78864927	79837932	79922506	81774921	83836250	93792921	97165286	100879787	101316410	102422960	106287054	112007578	113179372	123218210	135824305	146311554	159572617	169227118	201519632	214248689	273924284	322783252	322799197	665266299	691364145	1572984495\n.	8	0	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39\n.	8	2315891	62981765	62996344	63006885	64261910	68626756	68627059	77900897	80764275	81019227	81989734	82060082	83713289	85638583	95741355	99212799	103063375	103462166	104516367	108381023	113896723	114990495	125090439	130103063	149666497	161260094	170977766	203594035	214274858	257607411	295840732	324132511	440587032	440792639	628187808	724071165	1572984495\n.	9	0	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39\n.	9	2336294	65030544	65046841	65058727	66276725	70611820	70618393	80601532	84096931	84320663	85229854	85287068	86748666	88586031	98605525	102311188	106556603	106898836	107900556	111697231	117361109	118384004	128989490	134002798	155712096	165204961	175432282	209296210	218954921	262528939	303197733	329825973	448886954	449092272	637773090	745508314	1572984495\n.	10	0	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39\n.	10	2201277	66860209	66874293	66883707	67943683	72010932	72030455	81971088	85166314	85369826	86250555	86304325	87791766	89510926	99766834	103408782	107438622	107743963	108702243	112468333	117956566	118927726	129442630	134354671	158131788	165433878	175383532	208952598	218277501	261773785	301556707	328281602	445795781	445969789	631994304	738196593	1572984495\n.	11	0	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39\n.	11	2224435	68561847	68576052	68586773	69614358	73622504	73657194	83737352	86704482	86899014	87737122	87797309	89353149	91195350	101721713	105501276	109211324	109526218	110537406	114281404	119819664	120768136	131290406	136333580	162366536	167811555	177590670	211165310	220324942	265249524	304316025	332434041	451184085	451366222	641034527	747434748	1572984495\n.	12	0	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39\n.	12	2330434	70185855	70202404	70216711	71275941	75432336	75481584	85795882	88553521	88745865	89500096	89566005	91298713	93280410	103300388	107164084	110805461	111124796	112195445	115974262	121746712	122683026	133342368	138577329	164742001	169870092	179748305	213868961	223063526	268754105	308011383	336021902	456714966	456888768	649248956	760051951	1572984495\n.	13	0	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\n.	13	2222684	71562258	71583893	71607164	72618652	76744396	76822140	87408371	90282782	90473798	91189835	91257298	91696725	94475666	105090981	109026634	112815118	113115591	114184120	117968615	120421853	124716574	135627632	141001681	167327869	172395697	182266595	202126002	225117718	261484428	302029507	333532498	354558113	434413227	492396611	649271871	748179768	1053417455	1572984495\n.	14	0	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\n.	14	2331232	72909434	72933989	72967538	73998857	78121267	78236692	89015703	91959848	92165228	92838793	92906609	93384478	96343285	106770951	110932753	114686639	115024717	116097415	119884413	122426583	126934376	137942009	143618126	169795016	174949224	184874662	204986375	228289028	264287572	305657357	336685167	358351212	438533705	496893239	656567795	755960704	1064606224	1572984495\n.	15	0	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\n.	15	2249235	74193759	74219983	74255915	75278059	79491080	79654134	90834079	93859634	94058075	94705226	94776791	95316343	98426043	109023656	113270182	117151877	117473587	118600328	122403338	125043663	129716180	141161841	147003293	173610871	178767661	188890263	209505655	233040619	269729630	312127664	343558714	366017230	447522306	506705642	670837421	771484305	1083889192	1572984495\n.	16	0	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\n.	16	2319550	75485023	75511468	75551503	76479679	80558008	80774292	91792700	94992419	95177937	95822069	95894745	96457721	99407775	110139369	114248557	118236568	118546464	119642198	123351301	125932871	130690264	142062868	147622337	174422173	179416498	189472931	210258188	233313218	270072491	312184417	344149541	366880152	448117657	508674851	672309459	776148544	1085456183	1572984495\n.	17	0	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\n.	17	2359122	76744838	76768514	76817182	77694356	81704083	81998183	92845591	95936909	96116638	96750646	96825135	97444723	100358459	111136691	115204673	119144443	119457781	120551548	124213726	126789300	131610360	142923259	148401244	175183758	180119030	189997599	211055676	233805878	270794400	312462330	345172887	368699230	449672217	510711762	674109886	780595147	1084512954	1572984495\n.	18	0	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\n.	18	2237178	77973088	77999025	78055455	78907852	82956364	83339672	94009498	97023729	97201769	97811822	97889350	98561302	101206784	102612932	116152965	120082272	120404932	121525539	125152760	127897096	132937381	143880156	149726440	175933463	181015956	190899311	212298674	234988064	271267838	298818751	345823204	370047148	435805150	501491590	636196537	764581596	1074960582	1572984495\n.	19	0	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\n.	19	2366117	79214901	79240705	79316740	80161938	84308430	84842337	95765707	98693508	98875822	99476164	99562904	100331084	103178205	104929098	118163467	122206324	122548427	123745752	127343822	130178217	135571428	146715425	152666075	178897354	184008799	193853583	215903449	238637632	274960803	302846398	349913657	374706827	440694214	506667205	641828411	772864626	1079696736	1572984495\n.	20	0	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\n.	20	2345358	80417570	80443722	80530816	81357642	85611973	86331322	97130111	99978730	100159027	100748646	100845604	101708882	104796515	106939414	119491616	123488922	123851241	125106202	128634312	131692009	137494595	148493296	154526658	180334639	185480745	195412797	217912369	240704267	276573177	304822423	351802431	377413969	443582718	510020648	646684037	778527800	1084501680	1572984495\n.	21	0	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\n.	21	2251435	81544977	81576218	81680526	82484762	86766932	87687170	98222912	100807201	100999679	101574338	101680999	102652066	105986090	108538698	120287691	124263566	124686714	125984492	129483268	132650997	138805109	149680389	155705376	180908450	186023176	195813031	218958887	241403477	276838796	305098570	351768771	378043842	443821633	510165851	646143828	780624654	1083074547	1572984495\n.	22	0	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\n.	22	2279780	82695357	82727767	82825002	83610890	87900201	89065295	99106589	101522421	101715250	102277214	102386542	103468425	106996030	110045937	120818750	124692066	125149901	126469103	129901517	133230450	139881820	150391198	156443170	180868181	186000263	195678609	219363469	241575068	276354773	304657228	350802305	377912154	443072493	509431045	645255628	781743380	1081807687	1572984495\n.	23	0	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\n.	23	2390603	83870708	83903499	84017286	84803482	89246268	90751443	100461092	102483396	102676301	103227216	103350986	104560375	108463407	111964773	121662441	125468830	125960054	127340878	130728149	134237162	141546893	151823850	157947312	181534809	186748004	196478429	221112214	243226441	277264852	305909641	351874269	380148918	445541825	511819466	649675735	781136715	1069465336	1572984495\n.	24	0	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\n.	24	2328694	85080970	85117987	85250433	86015622	90630188	92553239	101822010	103576598	103767911	104304030	104445094	105781698	109994396	113930970	122458636	126303362	126816812	128274346	131623373	135368336	143535312	153426991	159601846	182277021	187578824	197494349	223062874	245245372	278210694	307454560	352961608	382499131	447948067	513834474	653425743	783092625	1074776280	1572984495\n.	25	0	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\n.	25	2209782	86378991	86429525	86620767	87257282	92462623	95315264	105604549	107312864	107525446	108061779	108222810	109767495	114638784	119041863	126828284	130872515	131445868	133043159	136443842	140488836	149790583	159889123	166329268	188646680	194230431	204536063	231837156	254577143	287219924	317556720	363514959	394836460	461416402	527262646	669466887	796814833	1090906002	1572984495\n.	26	0	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\n.	26	2266540	87687629	87756563	87961164	88616567	94172048	97754087	107377476	108648668	108869117	109379512	109566174	111389342	116879750	121785665	128679431	132665301	133321298	134997209	138383237	142596448	152676982	162716997	169227577	190878906	196670017	207047061	235644809	258326803	290455118	321566420	367318962	400700082	467233466	533146339	676891083	803568518	1101315106	1572984495\n.	27	0	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\n.	27	2209591	88982450	89038060	89267910	89925228	95844838	100255978	108760979	109700705	109922630	110411368	110624317	112661940	118764252	123719207	129700005	133718433	134425858	136178353	139476037	143803194	154568343	164938313	171428433	192094268	197966546	208359175	238833823	261481340	292526812	324497452	370130491	405375901	472103472	538436050	684177460	810134770	1112104696	1572984495\n.	28	0	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\n.	28	2281010	90301680	90366577	90623635	91340093	97674175	102925981	110514702	111181636	111419366	111906379	112147541	114480149	121153300	125819228	131263661	135247312	136036370	137913055	141170397	145623064	157018415	167944529	174552845	194056614	200037206	210617463	243007239	265832145	295527306	328420507	373854149	411484951	478329233	544741388	693722831	817166522	1122656085	1572984495\n.	29	0	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\n.	29	2265416	91700001	91772763	92053022	92819800	99568396	105943528	112386039	112756210	113006757	113505058	113773209	116443224	123660628	127902520	132922677	136976927	137829672	139729159	142962466	147595532	159671280	171257417	177985819	196381020	202598491	213257828	247747499	270679568	299168297	333188048	378319020	419079253	485730886	552064490	704958539	826159470	1133302105	1572984495\n.	30	0	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\n.	30	2193078	93174098	93258535	93574963	94438772	101666171	109308766	114582325	114793446	115070257	115597662	115908302	118970191	126761923	130321151	135299692	139389935	140292537	142379766	145643988	150273481	162986885	175514275	182356294	199820172	206164041	217164494	253739640	277054591	304212942	339407042	384452207	428013994	494446780	561092912	717448950	835776797	1143377790	1572984495\n.	31	0	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\n.	31	2496299	94721575	94807209	95161994	96111995	103858221	112810916	116868798	117005986	117309019	117863018	118221313	121703334	130049106	132864102	137727550	141917685	142890391	145102385	148399361	153166647	166192069	179637053	186630698	203047952	209636597	220722256	259435660	282980225	308754311	345135183	389875824	436942761	502535246	569706740	729820120	846040330	1153872846	1572984495\n.	32	0	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\n.	32	2074372	96258410	96349730	96744910	97788798	105456797	115056567	117878005	117961864	118294502	118875195	119298547	123201395	131757782	133898305	138663586	142850525	143884728	146240558	149576153	154385175	167617830	181768993	188932979	204382762	211213073	222442301	262678572	286333640	310945783	348778070	392776952	443283080	507522910	574948298	738288799	852133021	1161250205	1572984495\n.	33	0	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\n.	33	2307981	97765654	97864157	98320571	99482491	107560017	118338673	120325185	120413149	120776729	121407367	121892026	126335804	134974298	136583176	141558720	145849849	146917505	149485740	152913388	157906043	171701127	186273995	193694281	208767988	215877145	227445252	269242921	293302319	317270116	356957572	400695040	454995018	518075027	586003223	752695372	863585583	1171154562	1572984495\n.	34	0	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\n.	34	2451055	99414362	99518929	100053953	101358241	109699279	121480588	122736863	122835169	123240696	123916086	124484079	129411122	137951851	139150940	144201956	148588509	149719074	152369408	155891630	161037529	175158112	189985877	197746738	212324329	219815325	231560220	274436318	298578260	322001174	363341289	406517689	464737113	524872011	594627483	763783169	873349289	1180453248	1572984495\n.	35	0	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\n.	35	2210368	101072494	101182040	101802423	103288573	111392410	122993071	123735648	123851790	124310168	125096434	125747691	131266591	139616704	140584423	145540824	149813862	151029447	153921529	157685656	162995917	177179398	192344042	200401844	214517836	222467213	234199154	278563205	302849938	326068193	369145111	411971088	473901080	532272757	603295285	774612297	884825124	1190877171	1572984495\n.	36	0	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\n.	36	2253537	102779492	102894131	103619104	105213943	113273912	125196028	125544079	125673183	126181133	127013480	127763684	133754364	141463448	142217524	147249004	151551981	152831697	155886279	159707269	165149983	179752562	194516494	202876934	216873876	225193776	237223634	282074394	306556922	329676607	375012109	417058257	483059683	539219450	611360059	784624713	894383719	1199726058	1572984495\n.	37	0	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\n.	37	2269900	104524103	104652120	105528547	107361728	115482192	127468884	127654124	127794859	128411514	129327200	130191918	136607307	143719451	144453187	149467871	153857307	155246780	158456046	162437026	168280313	183080625	197258333	206130099	220067213	228952885	241243762	286154848	310841137	334224618	381524657	423187400	492406220	547158321	619758476	794768190	904673268	1209084259	1572984495\n.	38	0	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\n.	38	2354165	106270518	106405835	107352419	109253560	116876293	128432312	128550021	128691968	129360148	130348870	131293096	138085372	144252231	145039570	149886753	154278193	155734630	158780678	162806913	169039553	184010811	197334321	206343928	220162935	229582940	242026024	286246410	310914773	334432431	383614735	424241568	495856611	549093624	622274052	791929623	909090909	1214460673	1572984495\n.	39	0	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\n.	39	2394298	108106352	108264301	109173969	111316719	118709336	130389803	130489952	130642705	131322055	132436873	133488619	140594031	145954783	146797934	151707313	156159520	157684277	160919310	165079552	171518372	186852193	199405295	208545770	222529506	232475542	245328842	289029200	314324803	338278252	389151543	429482334	503315043	556154595	629915404	800940737	917446935	1222156139	1572984495\n.	40	0	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\n.	40	2425295	109979107	110137788	111092608	113430153	120651405	132093781	132198342	132369813	133084348	134310173	135486654	142985959	147649417	148578472	153517809	158075008	159663176	162904935	167367447	174169535	190022934	201776724	211346431	225473400	236075579	249421170	292921406	318595559	343075130	396244622	436667506	512554169	565335135	640159416	812543327	928666804	1232203429	1572984495\n.	41	0	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\n.	41	2202551	111926289	112094820	113145980	115762694	123001434	134512332	134631736	134827275	135613357	136978821	138317786	146270902	150224848	151256925	156348721	160921470	162662918	166056655	170623783	177984947	194317603	205344714	215457005	229653512	240898926	254552732	297771729	324162597	349076790	404484765	444574416	522566646	575249536	651481863	825230554	942591123	1242616692	1572984495\n.	42	0	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\n.	42	2140327	113928493	114098486	115280419	118129533	125236683	136261671	136387223	136604312	137496827	139017193	140518667	148650431	151937998	153056638	158056671	162635947	164499769	167967052	172783425	180589238	197190851	207234824	217693384	231934966	243928258	257820975	300261638	327224352	352527836	409716400	449377712	528409742	581145256	658190213	831630710	949578271	1247537243	1572984495\n.	43	0	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\n.	43	2362444	115994609	116180332	117508798	120661946	127583505	138403641	138539486	138787000	139793087	141482355	143215302	151377548	154142059	155382586	160402353	165109502	167196095	170709441	175809895	184211187	201125420	210218473	221419006	235671564	248575723	262777728	304407333	332114316	358072689	416866528	456838841	536750105	590173682	668068538	841132622	959310975	1253249913	1572984495\n.	44	0	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\n.	44	2384356	118108533	118318160	119700893	123125422	130214412	140794892	140938177	141197699	142223903	144095741	145948001	153997333	156227074	157592448	162428836	167157706	169994156	173101002	178370077	187561751	204628882	213128533	224821486	239131963	252952785	267571911	308136884	336621218	363133165	423252870	464087317	544816796	599413678	678154548	851223557	967256594	1261006375	1572984495\n.	45	0	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\n.	45	2427368	120293199	120509816	122016184	125653521	132455674	142521393	142681276	142989180	144129298	146245577	148297834	156193682	158058880	159458871	164278319	168945123	172015249	175163752	180810858	190608144	207722898	215426064	227514109	241662163	256665293	271414153	310879521	339937702	366863465	427716177	469216562	550251155	605327207	685369306	856414627	974899052	1264251021	1572984495\n.	46	0	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\n.	46	2390696	122458314	122678577	124182139	127960739	134652585	144185264	144352701	144674167	145841097	148209174	150396261	157899710	159466091	160925297	165621580	170196437	173368251	176495014	182352763	192574668	209448435	216239277	228665796	242517874	258598613	273481084	311498574	340993006	368243205	429393062	472001123	553740243	609448648	691122751	859461453	979567151	1265379258	1572984495\n.	47	0	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\n.	47	2446116	124710293	124937937	126567200	130688762	137535740	146726935	146898317	147247678	148479282	151066855	153476230	160533061	161881178	163478830	168207858	172954371	176287699	179498195	185657747	196604673	213469978	219364616	232409617	246409391	263675358	279106596	315703491	346166784	374276946	435871981	480564229	562753547	620561142	702934386	870615526	990655021	1272731612	1572984495\n.	48	0	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\n.	48	2532464	127065948	127309426	128956657	133144537	140071959	148736312	148918690	149285947	150557792	153337048	155830599	162526711	163761870	165401412	170166571	174801307	178311292	181482838	187852735	198338643	215847706	220754867	234305992	248612330	266861842	282675286	318191843	349303511	378044321	440035415	486215383	567881387	627739397	711978439	862129332	999210364	1276932809	1572984495\n.	49	0	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\n.	49	2346141	129505673	129747867	131482454	135787103	142528667	150272933	150464370	150877533	152190815	155192050	157819375	163754872	164861374	166495039	171256931	175843369	179483183	182706643	189339501	200306878	217143608	221373479	235213236	249450570	268783135	284952882	318601188	350647269	380147287	441535116	489804587	572404397	633777724	719696176	869344560	1007055285	1281699695	1572984495\n.	50	0	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\n.	50	2370493	132104038	132358524	134109076	138469970	145286436	152499040	152693345	153095371	154447480	157602694	160288648	165432493	166528635	168128404	173024640	177627749	181498411	184681163	191571239	202829063	219169552	222885470	237406236	251553786	271943229	288731003	320664362	353906324	384217345	445111315	496340889	580031389	643424742	730300301	878521837	1016110069	1287756024	1572984495\n.	51	0	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\n.	51	2486382	134864077	135136698	136936150	141467113	148522063	155112274	155315680	155730715	157123834	160477805	163242099	167813151	168867931	170569065	175489224	180165993	184252969	187541418	194717978	206408442	222259052	225610178	241022329	255099100	276792534	294160176	324578323	359194251	390512629	451425064	505940646	590793233	656786013	745143431	892829512	1029359519	1296897720	1572984495\n.	52	0	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\n.	52	2299037	137758978	138067892	139981893	144781614	152260961	158376497	158594987	159050952	160519773	164133159	166990990	171070150	172152006	173932963	179070699	183810895	188198815	191601664	199140487	211341326	226852901	229980220	246382436	260423841	283562532	301602346	331100354	367165067	399604639	460597409	518554004	604723476	673273193	763021031	910063245	1047153635	1308650209	1572984495\n.	53	0	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\n.	53	2301990	141076165	141407190	143542182	149105693	157884368	164064476	164315651	164824097	166414416	170486102	173600731	177172849	178350816	180327017	186108477	191252539	196044228	199651746	207980652	221131571	236604144	239506950	257587858	272021230	296902524	316224730	344608996	382902363	416855141	477186941	539745942	626600690	697970678	788621225	934509493	1070902460	1323227048	1572984495\n.	54	0	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\n.	54	2467193	144057261	144415021	146659081	152699129	162163050	167696508	167969156	168560633	170146548	174779627	178112041	181368127	182540066	184625946	190506815	195571535	200614572	204640713	213627884	227254333	237462572	245021917	264335968	278177293	305252986	325176505	353016419	393274239	428428096	487647098	554631734	643056479	716958592	804112545	952950027	1089889378	1334973743	1572984495\n.	55	0	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\n.	55	2650373	146908764	147288969	149671564	156026170	165982668	170945169	171267458	171935629	173655666	178780332	182273639	185270859	186411890	188587629	194819744	199799345	205178899	209327660	219059402	233165965	243201816	250821928	271437595	285020150	313667714	334508258	362323325	404660698	441049954	500623949	571635011	662404977	738935307	828000521	974974708	1111723556	1347977983	1572984495\n.	56	0	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\n.	56	2266091	149620365	150022425	152341656	158488434	168368445	172362083	172703330	173449758	175195152	180538915	183878696	186424211	187508669	189623685	195934232	200743056	206534272	210822626	220923366	234982713	244207018	251913454	273395735	286599886	316774304	338267729	365029302	408928486	446612968	505533631	581097367	674344665	753846786	844475161	989983926	1129067179	1358401656	1572984495\n.	57	0	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\n.	57	2580040	152397631	152807706	155216708	161549815	171995004	175419579	175775754	176560738	178351558	183832233	187022749	189150672	190279469	192434018	199130999	203907892	210024313	214411110	225070828	239105051	247484819	255445610	278420752	291424295	322525388	345135336	370963021	416740946	456102913	514494352	594247753	689898403	773258885	864318668	1008190792	1148108870	1370008033	1572984495\n.	58	0	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\n.	58	2264646	155170395	155610462	158027279	164526207	175514543	178409127	178790212	179606781	181295064	187024592	190018763	191832824	192926714	195066127	202130538	206824125	212557989	216765837	228557857	241630073	248971359	256726521	282207351	294853708	327140214	350638081	375625704	422902208	463706176	522043231	606031051	704966941	791607079	883336130	1024621287	1164320815	1379063862	1572984495\n.	59	0	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\n.	59	2248555	158027849	158489009	160838341	167375783	178569778	180734512	181153813	182037596	183695893	189664506	192469493	194071365	195135901	197310084	204568334	209174368	215151200	219479681	231875599	244756970	251608784	259611064	286066416	298426824	331862459	356492632	381386580	430177872	472651759	530636541	619745096	722423977	813366086	905511040	1043805089	1184379791	1390492130	1572984495\n.	60	0	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\n.	60	2420149	160924814	161412467	163552503	169733193	180185221	181687352	182085720	183003347	184600076	190274670	192826557	194242331	195271010	197403955	204817699	209084162	215336164	219680783	232437708	244666758	251189794	259302275	286881165	298884616	332819293	358392929	383524032	433608657	477804357	535853083	629345292	736413457	831834342	925363429	1060344374	1204689538	1401324298	1572984495\n.	61	0	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\n.	61	2386554	163917232	164426543	166648575	173112657	183805362	184942778	185359345	186337936	187861938	193508427	195907229	197193034	198197686	200404314	208206850	212391391	218801993	223335232	236503888	248124476	254250159	262797762	291420539	303315554	337309255	364188809	390083569	441570090	487606749	545520745	643129599	754785550	854147711	949363789	1080305878	1226127952	1412404209	1572984495\n.	62	0	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\n.	62	2563958	167060940	167598401	169756585	176496880	187370523	188298621	188753892	189811624	191325145	197007418	199326063	200588787	201624310	203944412	212088010	216147685	222858962	227438119	241146896	252334097	258491642	267379197	297497930	309189214	343128980	371166461	398481250	451666718	499237106	557727364	659496731	777325415	880308347	978632241	1105150197	1251071863	1426263397	1572984495\n.	63	0	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\n.	63	2744398	170427602	170986328	173123252	180154813	191229631	191856962	192365851	193499550	194976864	200789331	202973042	204185747	205208629	207581435	216270169	220243629	227206354	232000271	246326296	257103259	263094194	272525689	304061432	315754058	349799950	379462907	407657323	462605424	512003135	570542050	677362315	800705191	907014164	1007567707	1128928372	1275270692	1438515528	1572984495\n.	64	0	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\n.	64	2429386	173999525	174623122	176838499	184435251	195657227	196056289	196610305	197849125	199378187	205209034	207241381	208304627	209568384	212033724	220357624	225042076	232487941	237472797	251469758	262582197	268567153	278486375	311355295	321419308	355391343	388419377	418301081	474579271	525875672	585125191	696395879	825581222	935503404	1037292170	1152619138	1299505051	1450492819	1572984495\n.	65	0	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\n.	65	2469709	177749640	178415896	180606252	188642807	199722735	199972222	200589184	201952241	203481429	209388493	211322202	212417836	213738420	216322738	225031442	229596710	237610077	242768565	257200081	268031731	274157194	284455543	319153439	329146211	362668881	397232874	428843183	486932887	539892750	600244896	716363997	853000671	964810192	1068219621	1177578492	1320446608	1460673057	1572984495\n.	66	0	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\n.	66	2402087	181935451	182705882	185221646	194671222	207275427	207457309	208125284	209670875	211251148	217493592	219470564	220638485	221969764	224880272	234685446	239507750	248011104	253573560	269040889	279630869	286280961	297445709	334415615	344637569	378292760	415181151	448470188	508781243	563402056	624827642	746088121	888718089	1002896794	1107535672	1209956772	1345514031	1473117752	1572984495\n.	67	0	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\n.	67	2397828	185814364	186707930	189324129	199650074	212698221	212802070	213579328	215365568	217032919	223756395	225694599	226965270	228316666	231231373	241494753	246224127	255476093	261349835	277385775	287974838	294724168	306386168	345269678	355541561	388735413	427411962	462611157	524450357	580184509	643467084	768929359	918650866	1034651212	1140454682	1235645182	1366831416	1483173607	1572984495\n.	68	0	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\n.	68	2543370	189497870	190500292	193073004	203866386	216433358	216487455	217351922	219345258	221095535	228050268	229919451	231327192	232705949	235668596	246141039	250701857	260720941	266867208	283260480	293652242	300665536	312756516	353383036	363802138	396253319	436887814	473862719	537381778	594417593	659715568	790599531	948299401	1066504932	1172842001	1260902202	1386348875	1492126056	1572984495\n.	69	0	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\n.	69	2600066	193132658	194205078	196845837	208166959	220392501	220419000	221381595	223540463	225296064	232209250	234039523	235520474	236889986	240018787	251069464	255606898	266050332	272489043	287551348	296299005	306653805	319365227	361478597	372136710	403933117	446680031	485860960	550566682	609753143	676707237	813552668	978898381	1099041788	1205118008	1286168603	1407636265	1502057166	1572984495\n.	70	0	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\n.	70	2352282	196769456	197908158	200438764	212992891	225114172	225127745	226173458	228431645	230200425	237037152	238680065	240315249	241782476	245114113	256683162	261019135	272120781	278892438	293810778	302136574	312806936	326173998	369923762	380701771	411736740	456450082	497741223	563383805	624715207	693437946	836017198	1008170049	1130819383	1234976577	1308727988	1427496509	1510869909	1572984495\n.	71	0	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\n.	71	2577182	200435887	201637531	204245513	217670592	229452377	229458779	230634962	233168363	235087362	242127068	243772898	245498410	247006360	250466260	262789014	267177858	279140324	286242509	301277069	309638550	320819825	335276235	381089426	392153988	422564498	470087146	512918285	580246030	644238216	714246381	864290237	1042692237	1166638895	1266469433	1333509433	1448167603	1520361245	1572984495\n.	72	0	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\n.	72	2695670	204077098	205341680	207758095	221214887	231937670	231942155	233197040	235789858	237687206	244280436	245805623	247654252	249136774	252617425	265175851	269441337	282025786	289096058	303749818	312030570	323776427	338856081	385629920	397148735	426722319	476285500	521105160	589390730	655565332	727977075	884960944	1070988302	1196785186	1294247903	1354330685	1464556334	1527481847	1572984495\n.	73	0	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\n.	73	2607252	207673241	209070781	211523769	226480554	237140788	237143894	238512582	241248112	243224343	249664632	251152273	253154961	254687105	258393531	271741511	275947754	289360544	296697126	310934682	319271659	331427952	347585770	395842024	407889150	436129700	488543908	535006071	604440868	672665754	746724951	911038697	1103326243	1229344452	1325039594	1377800010	1482732885	1535304869	1572984495\n.	74	0	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\n.	74	2662972	211209579	212648722	215000793	230060232	239704782	239706784	241190800	244053596	246028206	252066480	253397193	255481298	256953955	260726730	274119013	278200393	292160077	299479057	312799925	321087982	333604381	350285614	395243177	411380976	438137440	491976705	540524329	610387670	680132854	757354572	928063448	1129843557	1254791495	1350330414	1396746742	1497606022	1541874263	1572984495\n.	75	0	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\n.	75	2238296	214770590	215854456	217417927	228970505	236011894	236015189	238382115	242710585	245103219	253885431	254834669	257779565	258762116	262966186	274227178	279266773	302138206	312943823	332282614	344379644	362472183	383242923	452479413	474114698	518949052	595311984	675775630	780020278	883180276	967800849	1170147645	1294812894	1402687397	1448456030	1478706348	1551022657	1567615062	1572984495\n.	76	0	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\n.	76	2569630	216995947	218100173	219579141	230741945	236719993	236721663	238387064	241281627	243094156	248248778	249131637	251398821	252511387	256049227	266782042	270753978	287473755	294577042	307008748	316412831	331064498	348573856	400868349	420294517	449714702	516503272	581674696	671274671	767730384	863873791	1089958519	1249161010	1372380901	1428883174	1458835420	1548581883	1568440995	1572984495\n.	77	0	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\n.	77	2678455	219586486	220726595	222063848	233028520	238245663	238246829	239658891	242013005	243662456	247483832	248322880	250400794	251543936	254875180	265737857	269201484	283646172	289438754	299147992	307331334	320332842	337177114	380492041	398173352	420503967	479848509	534332058	610773212	691791446	785543306	999450275	1216041705	1341388209	1422841605	1450913056	1539547277	1564369480	1572984495\n.	78	0	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\n.	78	2740352	222826036	224160780	225671859	239165498	244956867	244958047	246402984	248768963	250510548	254034687	254957500	257100229	258388230	261901024	274083808	277536240	292011607	297597467	306319256	314249809	327143808	345010698	385644282	403267476	422544949	480023158	530046140	601585251	676168275	766145099	970815621	1224121690	1345167965	1437599524	1462315636	1540316782	1561314576	1572984495\n.	79	0	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\n.	79	2492220	226371751	227730729	229124232	242241849	247359293	247360478	248952243	251499397	253331717	256787383	257628878	259837403	261104413	264604831	276636030	280098513	295000793	300426796	308503866	316647450	329697279	348218993	387738411	405871515	423306208	480603344	529679667	600493045	672817690	763160739	966852236	1243254157	1360266542	1457188377	1477979736	1545154146	1561813482	1572984495\n.	80	0	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\n.	80	2637575	230267533	231597013	232854327	245579134	249859108	249860196	251474930	253920995	255735533	258782766	259582809	261837899	263074503	266612794	278383885	281867053	296854299	301980519	309196307	317520916	330799863	349878970	387921812	406786607	423013201	480450910	529757210	600268974	673084461	764175958	972454558	1263673314	1379197150	1473303987	1490542427	1551884072	1564198877	1572984495\n.	81	0	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\n.	81	2653115	234597449	235892193	237038364	249561365	253215831	253216959	254867248	257254184	259013627	261639543	262385460	264651252	265911678	269474221	281389684	284940731	300002526	304940214	311287778	319898045	333345198	353489235	390649497	410127185	425150868	483858314	533173200	604817684	678807995	771067585	986179161	1288424814	1402337100	1491051136	1504890244	1557882292	1566607059	1572984495\n.	82	0	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\n.	82	2706571	239313219	240682993	241788127	254720287	258036205	258037478	259727765	262110982	263841292	266084559	266818781	269170704	270496842	274081881	286328982	289953663	305343869	309905622	315537648	324414150	338375202	359624717	395444573	415893116	429771913	489398047	539139400	611439896	686350360	780317484	1001300951	1312885463	1422820393	1506456534	1517093484	1563869401	1569044955	1572984495\n.	83	0	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\n.	83	2528349	244417283	245902176	246966996	260573798	263574113	263575370	265454649	267927255	269751135	271812114	272516427	275023242	276403317	280196820	292797513	296771217	312799116	317250023	322349110	331888170	346477416	369120888	404154644	426039958	439114990	499877206	550776151	624246425	699944089	795521743	1020857680	1337405832	1442897598	1520428953	1528695102	1567378334	1570560993	1572984495\n.	84	0	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\n.	84	2304847	249945895	251429704	252460463	266201450	268855842	268857002	270822626	273292162	275075634	276911169	277608938	280130683	281503112	285374541	298118040	302303901	318501035	322750253	327295184	337029689	352046047	376339800	409823569	432488061	444618443	506663781	557234359	631903471	709089098	805617966	1037498002	1358826996	1461079875	1530876776	1537387478	1569566664	1571506418	1572984495\n.	85	0	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\n.	85	2553776	256009885	257529048	258477144	272667775	274984179	274985506	277102996	279571046	281422211	283062788	283706706	286341687	287789214	291913968	304853710	309346654	326021339	330105986	334139637	344412506	360002857	385504717	418240593	442227592	453527837	516772378	568289904	644288454	722923808	820892493	1057655017	1381918927	1478481066	1542830731	1547452166	1570797598	1572048176	1572984495\n.	86	0	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\n.	86	2717755	262638743	264244983	265178321	279707649	281871541	281872906	284142368	286622095	288454145	289883103	290517845	293282634	294778736	298971681	312221949	317110326	334033747	337900095	341462937	352085424	368150382	395405129	426689184	451671872	462164044	526736197	578142733	655485889	735526786	833778643	1076409537	1404582048	1496169376	1551934825	1555175912	1571572743	1572383147	1572984495\n.	87	0	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\n.	87	2586514	269934465	271550752	272439954	287188207	288999947	289001921	291392306	293936447	295802928	297058151	297667977	300548486	302107223	306437731	319859630	325091866	342403240	346027725	349189189	360315470	376895546	405390066	435521596	461593086	471210656	537059462	588806392	667666816	748504927	847427482	1093347134	1423080344	1509499352	1558581983	1560837181	1572081198	1572600363	1572984495\n.	88	0	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\n.	88	2583912	277978984	279639446	280449500	295431126	297081171	297082544	299549109	301942243	303799029	304864762	305441797	308367237	309959840	314419127	328149019	333681149	350898798	354220743	357015953	368520689	385666817	415487291	443940810	471258108	479993093	546717371	598279904	677923943	760231547	858237687	1110416399	1440939024	1521422283	1563638853	1565147922	1572405801	1572738901	1572984495\n.	89	0	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\n.	89	2816016	286932961	288622113	289365701	304322149	305729329	305730936	308338046	310688210	312554749	313461317	313995667	317035943	318653157	323133750	336984799	342947474	360361860	363412731	365863510	377470514	395069304	426513957	453313286	481437943	489700798	557555196	609100884	689650387	773711904	871563714	1127355210	1457778409	1531968406	1567363875	1568244389	1572663646	1572852146	1572984495\n.	90	0	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\n.	90	2649020	297176979	298948081	299643619	315131715	316375034	316376585	319150258	321445866	323332653	324102400	324622311	327791469	329477685	334127644	348517943	354934940	372489467	375292288	377488003	389666511	407726577	440881493	466067132	495410950	503129045	572165731	624137935	705606715	791280877	887947259	1148245493	1475179663	1542584945	1569432463	1569986710	1572850087	1572930213	1572984495\n.	91	0	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\n.	91	2537689	308946984	310742202	311469273	327307807	328461016	328462675	331428351	333681299	335587017	336281457	336834385	340211294	341979353	346846585	361648117	368665700	386538661	389232981	391248026	404127011	422910930	457729121	481915426	512484561	520017702	590309888	643137988	725355582	811962308	907623424	1168008356	1489158546	1549848194	1570644680	1571007841	1572922521	1572959816	1572984495\n.	92	0	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\n.	92	2687221	322049890	323882042	324504321	341324732	342323125	342324886	345486901	347744017	349695337	350364808	350821948	354232256	356103120	361279170	376581705	384192751	402173450	404818633	406574036	420119257	438918637	475641164	498896084	530216275	537274001	608855206	661923307	745097735	833383522	927890576	1188868271	1501542203	1556215624	1571479004	1571710194	1572957663	1572974024	1572984495\n.	93	0	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\n.	93	2540142	336769735	338535899	339043811	355356248	356234819	356237349	359594284	361738723	363640138	364149907	364536975	368028742	369860586	375107981	390718485	398917119	416775919	419062032	420603035	434116391	453428000	491753288	513583094	545371653	552176170	624901239	677767369	761672027	850980761	942909470	1206152156	1511354682	1561388885	1571970720	1572125373	1572969434	1572978570	1572984495\n.	94	0	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\n.	94	2320406	353086180	354567435	354938560	368618811	369280569	369282165	372344355	374071005	374606273	376078136	376395048	379727340	381410179	386456271	401114590	409439541	426143134	427927584	429289614	442724872	461753020	500360675	519952521	551972089	557793085	630763573	683429335	768253458	858654718	949352059	1216128956	1519308128	1565046548	1572340167	1572439619	1572975645	1572981173	1572984495\n.	95	0	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\n.	95	2630941	372886642	374153245	374437603	386156401	386681251	386682563	389285830	390656057	391055029	392340061	392608765	395770304	397440492	402193188	416456488	424605828	439932366	441349827	442611464	455974163	475024762	513520645	530677018	563311405	568390619	640413468	693951627	778773983	869937667	960067358	1227580206	1525947830	1567430312	1572576891	1572639174	1572978787	1572982348	1572984495\n.	96	0	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\n.	96	2753120	396396162	397246819	397411807	405926834	406269199	406269843	408229353	409153355	409433119	410383111	410572260	413367723	414890830	419077785	432089197	439710620	453170261	454172183	455330395	467878363	485853171	523383505	537981852	569946917	574324986	644523121	697233123	782735795	873858445	964255541	1233318871	1532042396	1568663004	1572766181	1572800349	1572980708	1572983047	1572984495\n.	97	0	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\n.	97	2746929	426443011	426867839	426948986	431787260	431970617	431971019	433142209	433656669	433799464	434404585	434527018	436987695	438468483	442171374	454175337	461014431	472645172	473323269	474445560	486522716	503440396	539677706	552088701	583419823	587410939	655255843	708295220	794041506	885246346	976064709	1242658214	1536919241	1569540139	1572874392	1572891246	1572981873	1572983487	1572984495\n.	98	0	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\n.	98	2847791	463795019	463852797	463863655	464784381	464814089	464814149	465062515	465161859	465186025	465362442	465400002	467420363	468806263	471901885	482579536	488271416	497568511	498043650	499056498	510154887	525514894	558573068	568433522	598111302	601665217	664647696	718253367	803398979	894567705	985874846	1251618244	1542239229	1570317513	1572933442	1572941118	1572983003	1572983948	1572984495\n.	99	0	2	7	8	10	11	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\n.	99	2917896	520239568	520239589	520239689	520239697	520239703	520245086	520246173	522458100	523881585	526890506	537891425	543637604	552901662	553276277	554266722	564527960	579103320	610537522	619400998	647120038	649993371	709503576	764243450	852172013	945094536	1031416432	1293115129	1548011559	1571090615	1572962279	1572965966	1572983756	1572984265	1572984495\nA	0	2	7	10	12	15	16	18	19	20	22	23	24	25	26	27	28	29	30	31	33	34\nA	0	4520443	5195956	7046066	7329914	7602598	9802446	10107274	10115995	10472665	11594348	13048823	13411093	15450324	21229208	26102650	32495586	32795652	48801022	126918376	136073469	192793142\nA	1	2	7	10	12	15	16	18	19	20	22	23	24	25	26	27	28	29	30	31	33	34\nA	1	8989834	9939776	12959243	13258323	13833543	18161111	18647818	18683705	19396706	21642119	23740192	24440497	26703721	36268704	48025126	57551843	58396449	79516569	193056588	200341814	351514605\nA	2	2	7	10	12	15	16	18	19	20	22	23	24	25	26	27	28	29	30	31	33	34\nA	2	9430327	10407613	15279384	15545097	16050464	21666785	22127733	22146299	22908511	25873866	28149621	28898386	31917512	41727986	56061957	66666885	67589789	89053840	202574965	208261522	386692553\nA	3	2	7	10	12	16	17	18	19	20	22	23	24	25	26	27	28	29	30	31	32	33	35	37\nA	3	12195622	13061452	17123114	17371690	19987089	21374271	21808012	24893262	25632859	27646767	28316096	29079102	31506655	36200188	39373551	47517607	48087920	59454648	62972701	82618266	97464172	197748129	473929138\nA	4	2	7	10	12	16	17	18	19	20	22	23	24	25	26	27	28	29	30	31	32	33	35	37\nA	4	14634452	16328591	20417878	20757424	24002113	25511562	26071790	28604832	29418848	31823980	32413256	33087396	35835662	41112792	44314670	52198871	52608025	63975466	65999553	85471523	102988495	210359492	477411081\nA	5	2	7	8	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	35	36	37\nA	5	16638530	17318329	19089880	22231156	23082272	23204496	23537306	23580150	24109599	24944973	28351598	29744031	31051229	31213501	31636652	32882719	35048199	35469833	38869834	43232114	46306781	51123874	54718041	65978749	70587731	91786463	107991721	222760531	230830876	526982240\nA	6	2	6	7	8	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	6	9153919	9156891	9490152	10453720	12448323	12978652	13033419	13220848	13243833	13497238	14038357	15608423	16417449	17253394	17342000	17575477	18380669	19671164	19878422	21831169	24566725	26261789	28519896	30556803	36653706	38192870	48383166	57087548	57087753	111549038	115206471	255055029\nA	7	2	5	6	7	8	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nA	7	13055739	13058370	13059861	13423007	14579478	17157652	17966279	18024631	18263942	18280583	18541882	19082734	21210069	22234006	23395601	23485993	23745322	24723644	26281418	26554496	29095615	32730201	34966968	37833362	40565328	48743020	50802216	64551347	76695354	76695966	154599324	160267053	360789217\nA	8	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39\nA	8	12754967	12757631	12759533	13050911	14094401	14094517	16580145	17466783	17509327	17736545	17748454	17953234	18413333	20470950	21473510	22706908	22780541	23009162	23944394	25454288	25697838	28124866	29445309	34062613	36445455	39187720	47093522	48689739	58439107	68792553	73726183	101461484	101505415	143405134	173073649	342026710\nA	9	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39\nA	9	21783785	21788638	21791468	22170872	23616440	23619621	27234631	28690347	28749622	29055047	29068898	29342562	29950936	33053647	34455506	36236622	36329916	36650584	37917738	40016416	40374775	44049019	45874378	53385698	56591918	60686696	73121423	76395147	92000574	108102237	117121080	162402428	162502705	233309441	281167938	570948649\nA	10	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39\nA	10	15321078	15325051	15326403	15567936	16641449	16647668	19515601	20697922	20734540	20970288	20979183	21158622	21574919	24023247	25150889	26581449	26636143	26853443	27841488	29487346	29729961	32579738	33896676	40082094	41866477	45034211	54236473	55921843	66980030	79174601	84618222	116386071	116442933	163826816	200999541	394544894\nA	11	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39\nA	11	14087938	14091175	14092467	14318544	15282698	15291322	18030123	18992359	19024016	19222001	19231972	19414310	19833617	21970886	23039111	24361750	24414206	24626630	25537716	27124108	27336247	29898663	31148401	37175039	38365460	41305928	49695640	51114397	61313361	72351511	77123207	106048641	106091037	149060689	182756515	353984333\nA	12	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39\nA	12	17079215	17083024	17085318	17366323	18429375	18442433	21542450	22505933	22542373	22747018	22759510	23006022	23531343	25877806	27155079	28455945	28526461	28785783	29834274	31611430	31852671	34721574	36318962	43071315	44458935	47686604	57306553	59094375	71144388	83481673	89393560	123276140	123326058	174752030	213429106	411274988\nA	13	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nA	13	16742273	16746585	16750392	17021020	18082748	18104704	21256221	22234244	22272942	22463849	22477462	22557943	23211183	25613652	26837516	28190679	28253080	28511087	29529274	30067227	31542069	34443525	36018558	42751822	44071588	47207584	52136471	58232080	66998867	79104168	86157028	92052538	113157251	127093443	171199500	192820128	275630147	400475774\nA	14	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nA	14	17531922	17537443	17542640	17818522	18888878	18923988	22250006	23216414	23255505	23438562	23452627	23545569	24204947	26630167	28042440	29335598	29401046	29669241	30708657	31255142	32831789	35812017	37563864	44322205	45679421	48930037	54014079	60292324	69294712	81907082	89131606	95286252	117136504	131439264	177148999	199110717	284902276	409789927\nA	15	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nA	15	17247852	17254557	17260448	17548188	18617392	18663730	22011142	23052605	23095788	23269423	23283950	23390693	24095167	26533943	27947734	29273464	29341114	29618885	30644289	31209838	32813623	35855685	37627886	44413284	45752215	48991110	54071957	60323351	69274384	81952335	89092957	95322798	117018908	131209826	177115839	199024828	283485969	401005796\nA	16	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nA	16	18582075	18588939	18596079	18858917	19922519	19985878	23370127	24510305	24552273	24728568	24743323	24856701	25532798	28098102	29487511	30920471	30987871	31255425	32290864	32854628	34531932	37655363	39363699	46537772	47896884	51247870	56613957	63046325	72502874	85654847	93388512	99921474	122737903	137988701	186283003	210559175	299030782	421625530\nA	17	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nA	17	18953011	18958670	18968129	19220744	20301505	20393609	23760523	24841663	24881489	25058206	25076238	25206026	25884982	28471288	29846694	31274774	31344457	31618991	32642229	33235150	34947493	38034813	39718283	46899225	48251576	51548220	57020388	63409393	72870154	85887358	93677738	100260534	122932725	138340224	186308594	210958866	297596092	420295189\nA	18	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nA	18	19035044	19040717	19051274	19297247	20345590	20463743	23750966	24836175	24872895	25044928	25062761	25189920	25824388	26130810	29805375	31196834	31264934	31536260	32545177	33148183	34892728	37853409	39655040	46659120	48013007	51298337	56739609	63058099	72287119	80304830	93043491	99792761	119033751	134832025	174900929	205495945	292325356	415774733\nA	19	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nA	19	18851830	18857291	18872685	19109971	20198309	20357908	23658796	24665903	24703011	24869026	24890364	25041137	25725850	26102429	29611047	31020873	31093508	31387129	32365372	33012510	34793275	37746456	39514599	46395900	47730434	50909976	56392558	62600566	71616034	79540258	91942844	98654352	117556139	132991838	172399217	202759716	287081407	406573895\nA	20	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nA	20	19714852	19720937	19737977	19973335	21062127	21272323	24649779	25648134	25682165	25844365	25865926	26030234	26740187	27205951	30687161	32120398	32196659	32492599	33473131	34147112	36108177	39042421	40869596	47845028	49197902	52521376	58198786	64575362	73771767	81995995	94806990	101853678	121229565	137214611	177814609	208890950	295425466	417976122\nA	21	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nA	21	19932371	19939181	19958899	20189690	21332268	21592679	24927056	25832438	25869691	26031179	26055185	26242532	27003871	27558941	30932029	32353808	32438171	32750587	33719238	34446717	36471985	39384273	41201017	48132575	49479621	52750483	58568555	64920872	74106870	82343489	95126371	102293597	121686378	137778926	178503901	210495616	296952075	420748878\nA	22	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nA	22	21261930	21268613	21287947	21520297	22678034	23024583	26251002	27175313	27213879	27372181	27395570	27616292	28440261	29152122	32347026	33777654	33878113	34191707	35168538	35973214	38200657	41031624	42949440	49847047	51237850	54565647	60713969	67206994	76608855	85113451	98269408	105812647	125691656	142529607	184533360	218319305	307496845	435901563\nA	23	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nA	23	21518411	21525408	21547752	21780520	23012544	23492487	26711032	27431620	27470538	27628838	27655283	27895736	28835415	29694277	32675628	34035415	34152560	34476418	35452534	36333813	38769422	41455186	43446150	50141672	51599127	54917488	61286570	67778983	77027646	85620183	98773414	106560600	126542183	143481701	186385118	218588582	305154545	437378617\nA	24	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nA	24	21273458	21282223	21310417	21536143	22816520	23418132	26411949	27024144	27064242	27212523	27245650	27532000	28531657	29495481	32087540	33426767	33552906	33902295	34840753	35811614	38435457	40923082	42880666	49186427	50635748	53930616	60383616	66736111	75462609	84005982	96712809	104779446	124193130	140503156	182457394	212639006	297083951	422676561\nA	25	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nA	25	21643864	21656759	21697891	21895176	23257367	24144319	27520911	28133166	28178565	28335370	28373315	28721388	29827076	30925995	33410309	34817963	34949941	35343317	36310682	37321296	40314858	42773054	44850580	51163056	52674125	56141925	62934864	69562510	78361127	87318499	100321289	108803644	128824787	145492614	189035904	219824743	306501920	430438617\nA	26	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nA	26	21939482	21952337	21998229	22199640	23700864	24790345	27953516	28413916	28460014	28598878	28646504	29040201	30350834	31621652	33820224	35205283	35369211	35779245	36735107	37860861	41078349	43426776	45525684	51675298	53267074	56695765	63821096	70398073	79084067	88144683	101083787	109891175	129889736	146508838	190110765	220374528	307043048	427729797\nA	27	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nA	27	21703756	21716625	21770377	21963742	23606928	24988938	27728206	28077953	28123582	28257061	28310883	28736597	30197949	31427120	33407220	34805315	34967093	35380792	36299367	37412533	40798409	43189002	45158767	51071931	52619040	56046936	63441553	69931206	78142193	87228855	99927612	108937833	128673534	144890063	188173779	217418553	303102964	418967129\nA	28	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nA	28	22180792	22194048	22247551	22461531	24214192	25826875	28400498	28651945	28696261	28825998	28884377	29367375	30944702	32200008	34048882	35438037	35609604	36047712	36940521	38123753	41748254	44162656	46170350	51915779	53482671	56998980	64772061	71380488	79454154	88826052	101653699	111240861	131223924	147776894	192297255	221211651	308198229	422602889\nA	29	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nA	29	22968669	22986633	23046359	23283384	25260969	27265635	29479351	29604302	29655955	29791413	29856357	30421130	32223861	33401890	35151536	36556964	36767413	37212235	38111277	39373973	43235769	45857458	47989108	53468869	55186338	58752677	67266742	73973331	81894917	91685205	104780462	115279451	135670759	152638359	199203192	228372381	317897028	431648933\nA	30	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nA	30	23031010	23051517	23116780	23364895	25396735	27855351	29622082	29686734	29738281	29876002	29949369	30653118	32560836	33498146	35182751	36622662	36823452	37326901	38215462	39390530	43430595	46282829	48291337	53524290	55181870	58817814	67693854	74421500	81836895	91714216	104478948	115544801	135338725	151911097	198127185	225266578	311867050	419439184\nA	31	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nA	31	22833646	22851511	22928449	23201035	25454999	28340354	29711891	29748320	29802701	29944625	30032243	30782350	32872141	33635756	35332040	36774416	36999317	37507361	38381179	39614934	43720344	46774537	48894929	53813223	55529740	59209083	68546664	75288569	82338118	92430145	105248243	117030180	136785390	153347909	200748966	227578669	314502074	419825480\nA	32	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nA	32	24358994	24379736	24460435	24780411	26976307	30158603	31149591	31164023	31226773	31373298	31479856	32370616	34561843	35200002	36851998	38330390	38563708	39124967	40009904	41265997	45542013	48846979	50975030	55797434	57573952	61344224	71363115	78336287	85269344	95903013	108805977	121550182	141474310	158609307	207727120	234785266	323517711	429483191\nA	33	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nA	33	24481568	24504537	24607486	24931488	27269691	30903940	31593366	31607859	31681639	31841333	31957424	32933730	35230660	35690101	37418507	38955629	39195131	39777695	40691781	41957395	46398009	49896028	52106330	56824020	58675687	62574216	73027513	80149749	86940401	98056610	111137863	124735424	144661974	162125488	212879721	239710036	329567999	435005683\nA	34	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nA	34	23779149	23802433	23924714	24290072	26668394	30507342	30926936	30942458	31019808	31189036	31322422	32432317	34625708	34979857	36646959	38172946	38413766	39036819	39943921	41230244	45616329	49083714	51296694	55767136	57684132	61483008	71797387	78719193	85119932	96179759	108601815	122496074	140941936	158116264	207234134	231976470	316535690	413923289\nA	35	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nA	35	24552140	24580763	24721880	25121850	27453739	31314166	31577466	31595991	31690084	31878301	32040343	33333249	35500417	35789169	37471891	38988369	39255389	39925030	40868810	42246512	46685805	50313937	52648258	57010628	59078393	62935700	73793930	80813973	87206778	98960000	111450674	126784270	144885738	162748060	213565390	238958985	324998530	421269415\nA	36	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nA	36	24872174	24898040	25083826	25515212	27828700	31739668	31842501	31862747	31965105	32155154	32354697	33711109	35743065	35970038	37649771	39159837	39442690	40156904	41105776	42497796	46991740	50470769	52845982	57145150	59255505	63148211	74032529	81003839	87327924	99327658	111643970	127877775	145225759	163018814	213547240	238395186	322372244	414809438\nA	37	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nA	37	25290011	25320244	25496430	26030180	28503716	32352466	32413527	32434510	32548854	32759236	32963528	34426941	36410269	36660545	38323572	39818700	40120649	40884655	41893815	43434478	47912088	51299718	53879574	58124307	60419348	64354778	75363191	82360963	88800374	101280566	113643304	130686451	147850494	165821808	217305250	242504890	327638415	419807664\nA	38	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nA	38	25137057	25167606	25370926	25911684	28102875	31864646	31895700	31920437	32045008	32279106	32510763	34063571	35708969	35964517	37542697	39047254	39346728	40066810	41078890	42630692	47136577	50230792	52713891	56921694	59310414	63251791	73841153	80724311	87024848	99771851	111698119	129087550	145424513	163116177	211516198	237630591	319461320	406298225\nA	39	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nA	39	25549502	25585986	25788519	26404616	28508123	32452029	32473751	32499258	32625728	32879716	33142365	34810442	36274274	36570171	38159950	39732424	40042985	40799129	41826134	43423750	48098985	51073030	53535152	57884873	60347219	64437100	75049206	82218781	88683002	101826092	113670797	131481670	147985396	165903418	215301164	241570775	324705949	411188003\nA	40	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nA	40	25812749	25850928	26076574	26757145	28814282	32594254	32617609	32647441	32788490	33081216	33377495	35133476	36380869	36719645	38296903	39896855	40226919	40992670	42081057	43791676	48556006	51301379	53887221	58218143	60857476	65056341	75409923	82675958	89272637	102798850	114662693	132836855	149112202	166999458	216192206	241950547	323105408	405664789\nA	41	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nA	41	27140336	27179146	27422760	28164466	30244794	34204444	34229746	34263094	34410779	34732912	35073835	36957103	38079400	38428315	40076899	41729808	42066600	42848618	43979648	45814167	50831487	53498690	56189275	60660845	63450761	67843706	78571754	86033756	92854702	107266858	119371664	138534476	155196319	173893424	224973220	252109341	336142898	420387506\nA	42	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nA	42	27085624	27127084	27392868	28198917	30228750	33940094	33967608	34003168	34172152	34526442	34900630	36849865	37783497	38171432	39792014	41352355	41710604	42534005	43699102	45631090	50557992	53009211	55733449	60120660	63046378	67409131	77798073	85308428	92108728	106725433	118480465	137603779	153943435	172424269	222446859	249079513	330034611	410424444\nA	43	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nA	43	27681256	27724300	28014811	28923625	30938386	34579109	34608551	34651631	34847425	35241710	35669499	37700014	38460684	38888699	40430444	42108433	42551141	43366961	44584430	46695851	51738393	53950453	56886159	61296405	64484074	68894319	79236410	86856802	93835214	108944414	120754542	140192351	156663361	175481637	225464184	252298150	331761146	409316518\nA	44	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nA	44	28377458	28423122	28736035	29724924	31867207	35404348	35434980	35480889	35672432	36110446	36568830	38541171	39196508	39685241	41254524	42906996	43482981	44210851	45471793	47825694	52915542	55009784	58101856	62514534	65945853	70539212	80639878	88550270	95689079	111210934	123421801	143141331	160012495	179297813	229929032	256550473	337204866	415145172\nA	45	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nA	45	27866907	27917672	28261206	29292340	31293284	34651624	34685965	34734965	34949841	35441533	35951434	37888602	38415434	38916878	40374756	42014298	42625520	43372958	44684653	47144783	52166598	54000477	57122569	61400691	65030436	69521390	79128145	86947639	94029015	109321393	121286183	140479902	156997155	175985082	224766838	251224790	328031875	401347827\nA	46	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nA	46	28813471	28857851	29198912	30258854	32277899	35519356	35554208	35604988	35823632	36379056	36920685	38760026	39217247	39696455	41163095	42805966	43401721	44154522	45534924	48059659	53067817	54691472	57931429	62166041	66048219	70624440	79953308	87968814	95192000	110573856	122920722	142132687	158972907	178502716	227460855	254411057	331839113	405582398\nA	47	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nA	47	29439305	29492267	29882607	31083945	33162591	36341222	36380586	36440249	36679236	37290380	37926320	39710149	40084968	40646266	42139050	43826376	44489800	45278463	46721329	49520879	54576622	56013543	59442677	63710417	67886680	72663029	81821079	90177511	97647120	113372666	126180312	145938427	163384637	183388393	232292437	259479518	336111749	408741860\nA	48	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nA	48	30090443	30142373	30517003	31735985	33857198	36842352	36883496	36945364	37183900	37847270	38490447	40159219	40503612	41079808	42568358	44220737	44893589	45673355	47186258	49883809	55029210	56239772	59749845	64058201	68436824	73328976	82189311	90692232	98272295	113914944	127152274	146691218	164507713	184983782	228197488	260469063	336200658	407733902\nA	49	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nA	49	30555520	30611639	31025441	32291693	34385993	37081896	37124714	37200266	37464077	38178140	38873867	40408747	40724570	41278759	42769447	44381710	45116856	45937806	47506093	50316046	55346444	56382003	60029450	64255071	68961900	73898304	82367827	91083062	98868456	114422613	128150475	147956903	166080700	187049057	229851332	262274556	336031548	405797868\nA	50	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nA	50	30927867	30986041	31399672	32660095	34743395	37232874	37276127	37346091	37612336	38345263	39056012	40354777	40644468	41187942	42686623	44318826	45068663	45868808	47468550	50325329	55191446	56044108	59748015	63932150	68790442	73845928	81738975	90632664	98568526	113783691	128049050	147693997	166198565	186893233	229023366	260597399	333279947	401416091\nA	51	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nA	51	31901078	31961538	32395071	33693987	35930769	38271572	38317214	38392682	38670853	39487624	40211035	41393617	41678916	42232305	43793748	45465660	46252799	47083034	48815355	51820816	56613388	57414770	61343297	65577412	70808616	76131007	83750506	93100959	101368334	116708800	131902866	151916982	171207108	192791353	235236803	267200837	339500239	406158566\nA	52	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nA	52	32159406	32227296	32671919	34080288	36479059	38517948	38563329	38648748	38943338	39829831	40581186	41543165	41855793	42449864	44044684	45691158	46562874	47418901	49226895	52410153	56940827	57604460	61867284	65948698	71630975	77004489	84046805	93667104	101993042	116912947	132886042	152633595	172265410	193419741	235014428	265840099	335149375	398214121\nA	53	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nA	53	33040346	33112881	33620710	35226072	37988032	40135115	40189627	40280338	40597337	41603802	42417508	43317436	43623373	44273519	46024921	47836541	48748410	49685789	51697481	55076706	59673141	60371072	64977293	69167872	75293020	81030968	87954405	98167323	107066791	121955669	139043905	159077207	179602511	201276838	242969200	274713288	342189578	402067181\nA	54	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nA	54	34435671	34515489	35034471	36765317	39740247	41762723	41824658	41931176	42233280	43374556	44271049	45094374	45394033	46086518	47902264	49718345	50688507	51706492	53831558	57450006	60352632	62695260	67597603	71765728	78527431	84536964	91514579	102355382	111627904	126557113	145144524	165824797	187175939	207823325	251558427	283256213	350726408	409828238\nA	55	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nA	55	34505185	34590121	35116426	36960433	40112099	41860234	41928537	42050126	42375142	43645160	44576701	45295631	45593124	46314100	48189141	49951655	51018136	52103179	54423727	58110132	60822839	63130000	68386597	72335253	79510292	85686168	92406857	103613494	113176676	127670561	147087756	167909423	189710675	210397418	253127115	285349709	349128436	403571919\nA	56	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nA	56	35630161	35715939	36239861	38058759	41234951	42706328	42778076	42908304	43236367	44577485	45511255	46167541	46458963	47177891	49083727	50798464	51901023	53031159	55514137	59270189	61916922	64247720	69688215	73611988	81245824	87571599	94427748	106038931	115919248	130831031	151316453	173354420	195722865	217962857	261054985	293863468	356551971	409438033\nA	57	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nA	57	35186975	35276737	35782071	37657035	41042210	42273743	42350518	42490584	42816279	44207134	45058422	45571785	45885729	46575860	48590622	50273313	51426086	52545662	55189731	58844362	61139343	63523535	69298389	72962494	80841723	87388851	93554241	105491096	115550550	129599463	150984048	172693037	195550454	217099175	259092120	291328675	351017048	399896100\nA	58	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nA	58	37020137	37112322	37624702	39581057	43093983	44274291	44354187	44500743	44834108	46271140	47077056	47539545	47850290	48553728	50689883	52383953	53473150	54600484	57525013	60995692	63181144	65596087	72037381	75736242	83891059	90802295	97063152	109544409	120214311	134632659	157385975	180208879	204504885	226915716	269220998	301910873	361517208	410116748\nA	59	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nA	59	37363136	37463036	37994017	39965773	43605900	44411074	44498790	44666186	45006275	46513771	47292683	47670508	47971518	48682409	50843572	52512617	53708397	54885180	57936629	61386475	63305792	65780448	72496158	76076490	84634769	91819303	97790563	110623637	121759234	135973086	160079973	183493902	208410491	230752099	272111611	305011554	361826645	407024911\nA	60	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nA	60	38164203	38267816	38721484	40575411	44059935	44632891	44718526	44894124	45207043	46692554	47371362	47698060	47974237	48677370	50915325	52415630	53627361	54783550	57918757	61250252	63149855	65612181	72534547	75921584	84670228	92068405	97999631	111055026	122436859	136636008	161745863	185793582	211759766	234584332	274637096	307695521	361372634	404052765\nA	61	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nA	61	39347752	39468978	39972759	41948371	45549911	45973183	46066236	46261980	46572872	48057376	48730984	49031491	49301775	50023061	52454568	53915098	55221969	56430975	59771549	62951789	64700073	67376161	74753671	78113974	86874670	94845090	100943328	114655700	126712948	140878741	167424666	193280186	220367264	244165488	283165074	317442522	368273675	407496701\nA	62	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nA	62	40570162	40693274	41168876	43212182	46935349	47277557	47377073	47576108	47886976	49400959	50014627	50299380	50584391	51338496	53815945	55304902	56647348	57870597	61398090	64412489	66131120	68905962	76684022	79985728	88838075	97067316	103430983	117798155	130348461	144480459	172047406	198980911	227267851	252165839	290929266	325309638	374913331	412570747\nA	63	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nA	63	40458127	40589631	41063520	43198465	46928799	47185456	47291583	47515020	47821831	49350623	49929698	50210635	50478577	51260093	53910013	55309019	56689950	58023441	61647287	64455603	66178531	69026531	77162490	80345597	89056987	97626831	104221294	118803113	131679300	145527045	174094032	202156521	230856574	255777237	291984220	325747972	370769699	404447651\nA	64	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nA	64	41704459	41859423	42328827	44643021	48389667	48548910	48668130	48909632	49237032	50781700	51313873	51541794	51914423	52702806	55360279	56842694	58381688	59747171	63478866	66254850	67931348	70893883	79528767	82405390	91177600	100467297	107620623	122659082	136057655	150190961	179691228	209027917	238760001	264073687	298485508	332366254	373899731	404508882\nA	65	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nA	65	42143611	42305924	42793292	45221212	48961319	49046772	49180597	49444658	49790023	51337985	51862120	52093003	52454170	53274559	56005495	57488945	59140624	60558125	64401116	67083742	68785419	71860961	80931571	83744340	92341341	102030356	109317168	124874243	138745702	152852805	183824554	214987391	245019795	270783448	303760128	336814185	376044514	404701652\nA	66	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nA	66	43498739	43677344	44187953	47030817	51236956	51302780	51450020	51735052	52075724	53699878	54216014	54447870	54816091	55737158	58723150	60358521	62083476	63640266	67745236	70290860	72057463	75421944	85116961	87904835	96637695	106928039	114557535	130766620	145264770	158975762	191341667	223071217	253918642	279816233	311324089	343677723	379847211	405697181\nA	67	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nA	67	44573506	44786857	45334144	48476725	52937166	52979623	53150768	53492452	53883696	55700268	56212196	56464197	56852651	57758912	60964172	62568383	64527589	66147727	70577253	73120493	74937617	78483621	88774539	91585077	100434798	111309498	119378140	136290682	151253148	165371535	199264890	232941544	264538411	290688361	320943174	352183187	386714096	410845756\nA	68	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nA	68	45634165	45842489	46386532	49688948	53905420	53925593	54115552	54500802	54892080	56770111	57255141	57516122	57916250	58853564	62145639	63616103	65692215	67437317	71981578	74364193	76241641	79865514	90704239	93471354	102065364	113442688	122078256	139535577	154797168	169482346	204837617	240882256	273034164	299831353	327457628	357109008	387922672	409386903\nA	69	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nA	69	46311972	46547991	47151380	50635668	54909904	54920797	55131544	55566570	55967339	57881627	58395974	58675917	59055030	60030893	63575822	65076732	67272169	69084125	73423542	75657621	78210448	82044750	93377557	96259753	104847025	116852559	126006587	144002647	159828585	175067028	212003749	249552554	282181426	308408082	335022928	363865662	393205273	413331569\nA	70	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nA	70	47678006	47921116	48452623	52390419	56512137	56516687	56746177	57204895	57618482	59517153	59942968	60237595	60652207	61694300	65380011	66765193	69129178	71093049	75398161	77360636	79965014	83966516	95818214	98656070	107040160	119475505	129327113	147488291	163859040	179392413	217915622	257933993	291365984	317304464	341007021	369542879	394712941	411922403\nA	71	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nA	71	47746832	48021163	48594162	52807384	56766048	56767860	57034501	57554902	58028136	59937680	60376451	60709263	61144928	62245499	66137066	67518106	70141837	72154103	76441249	78414714	81171479	85448538	97718983	100644195	108749439	121910762	132140231	150523181	167502825	183208804	223493900	264881165	298462298	323113065	344639378	372948844	394483851	408699099\nA	72	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nA	72	48572640	48862465	49367230	53507591	57108160	57109276	57393782	57943391	58400172	60193443	60586889	60951340	61365643	62429362	66412889	67720853	70476996	72410209	76607945	78578983	81481767	85909563	98248494	101277791	109170947	122801835	133588512	151927661	169439238	185546475	227203197	270095318	303776372	328018367	347120963	374238586	392752895	404828568\nA	73	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nA	73	48491535	48810929	49312072	53895166	57498552	57499377	57808886	58368564	58847828	60569875	60929556	61312128	61740294	62864148	67124556	68367640	71280523	73264403	77332280	79193449	82133324	86877105	99485582	102580139	109995729	124227643	135263262	153561390	171513799	187677415	230572564	274247430	307730031	331739820	348745161	374933900	390839914	401320882\nA	74	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nA	74	51070670	51386862	51863904	56637249	59870070	59870455	60211361	60802284	61302276	62938566	63271651	63684991	64115069	65289225	69595651	70792115	73913166	75975420	79819565	81755700	84705936	89690043	102100239	106023612	113102715	128043476	140122976	158648336	177563391	194615501	240438883	286946355	321459507	346331644	360876997	387259389	400001555	408287933\nA	75	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nA	75	50314505	50584982	50939118	54753168	57183040	57183348	57769645	58752134	59388192	61958347	62206290	62661151	62945460	64016173	67345738	68709624	73599774	76483358	82212465	84653797	88126138	93736000	111119757	115490412	127177538	146419377	165399264	191235805	217831943	236786579	289564217	320645258	350862052	363086742	372725407	393777862	398897076	400325766\nA	76	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nA	76	51615417	51878504	52206750	55869942	57961123	57961354	58362376	59003347	59491971	60978530	61207855	61633987	61988165	63025111	66468123	67544078	71383452	73430302	77182759	79280079	82451107	87392115	101823021	106055101	113632910	131404856	147195238	170122395	194907304	215511474	273261391	311910729	345669470	361426543	371153312	394992753	401134381	402606175\nA	77	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nA	77	52229051	52522034	52816502	56482049	58293361	58293555	58639880	59178759	59650551	60734792	60953543	61373235	61736468	62718682	66338656	67309636	70777275	72395513	75319598	77136251	80328508	85281836	97361856	101537676	107440873	123858705	137594966	157407956	179331965	199691633	256231207	306977427	341314870	362966954	371634320	395723804	402029138	404192101\nA	78	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nA	78	53449851	53764151	54103199	58394216	60401354	60401562	60735049	61251958	61725674	62724950	62974100	63393520	63775671	64821562	68908899	69842674	73218922	74808713	77470266	79311970	82477182	87755900	99162973	103351207	108584866	124595330	137220492	156057127	176336635	195866919	250576752	308513654	342329642	367630931	376072764	399182476	405061934	408115110\nA	79	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nA	79	53209991	53542449	53860368	58053335	59811644	59811833	60186646	60755335	61260833	62248847	62485363	62935446	63315579	64318753	68336281	69277155	72774270	74330198	76758490	78574546	81859875	87321336	98289614	102723913	107349872	123122207	135481689	153958755	173406722	193362958	247625572	311230291	343035479	368836272	375624515	393769160	398412989	401203104\nA	80	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nA	80	54380967	54703593	54999434	59027963	60428025	60428192	60805442	61374655	61868475	62700134	62929512	63377485	63775343	64785612	68624814	69555968	73099556	74503575	76631879	78550208	81901691	87414171	97784653	102459569	106722084	122273746	134605051	152942142	172345636	192854519	247175843	314312178	344846501	368766948	374487863	390467641	394041405	396274906\nA	81	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nA	81	54918702	55242733	55497165	59583152	60816404	60816589	61206226	61747413	62243196	62982135	63184233	63655595	64072791	65102144	69044789	69956049	73532328	74932293	76845025	78842681	82197380	88017426	98337537	103155445	107004011	122898405	135379843	154139863	173594546	194428591	250573779	319919947	350686410	375612063	380060330	393540007	396056814	397713459\nA	82	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nA	82	56757753	57079733	57337544	61548927	62719226	62719396	63120781	63666900	64144183	64814309	65020854	65489006	65904529	66928298	71068922	72012342	75604583	76918994	78720038	80759001	84208243	90500571	100529020	105480880	109039246	125441107	137920757	156941820	176935147	197698982	255824265	327089543	357330698	381683519	385390704	399052991	400536088	401527083\nA	83	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nA	83	58430467	58793369	59041849	63515497	64501723	64501914	64946233	65533846	66057509	66644192	66844203	67367400	67789286	68897289	73168728	74165685	78070001	79364111	80888467	83114791	86926033	93623298	103456860	108951461	112462791	129249698	142257958	161729031	182430756	203885654	265252598	340147383	368734408	389333375	392101905	402471133	403417410	404058455\nA	84	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nA	84	59421824	59789021	60036613	64496243	65343559	65343736	65803537	66387770	66902953	67403787	67609859	68139429	68571322	69650404	73934632	75003773	78949531	80134924	81468734	83760499	87639196	94858580	103936251	109642260	112675040	129646285	142311046	161696150	182368332	203590582	265810397	341779171	367872847	385552669	387714826	396148039	396725881	397113509\nA	85	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nA	85	60315306	60703003	60920716	65605370	66322581	66322785	66832079	67438933	67960602	68413250	68596213	69164013	69625079	70832627	75171462	76321059	80390410	81543102	82716056	85200540	89330012	96912102	105688892	111849921	114712345	131890540	145055981	164775153	186023147	207899278	271325936	347574501	371970840	387716376	389237586	395112592	395514623	395775198\nA	86	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nA	86	63568302	63967397	64203907	69014838	69729389	69729604	70271283	70885742	71426366	71857878	72057826	72644877	73128692	74338213	78883902	80139911	84334055	85494073	86614077	89239339	93493351	101629663	110490361	116934761	119660591	137702025	150991852	171640771	193711000	216022225	282318352	361116337	385242139	400487370	401556894	405743497	406013222	406189969\nA	87	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nA	87	63555190	63966209	64162556	69036028	69587147	69587434	70157892	70750936	71313701	71692374	71858351	72474505	72971808	74243868	78759681	80062121	84264829	85376581	86337674	89023633	93291698	101482661	110128990	116616319	119078043	137028741	150095253	170823649	192763008	214636142	280552314	357844473	380532158	393868033	394545307	397189881	397344498	397447399\nA	88	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nA	88	66546187	66973179	67144499	72123758	72662143	72662383	73251389	73817786	74387951	74730606	74877381	75516251	76077292	77345110	82021111	83406022	87684369	88724451	89647408	92444563	96940823	105482104	113885651	120886555	123173863	141534102	154937152	175943722	198676663	220244166	288721280	367312428	389850268	401625545	402171227	404309194	404408889	404474057\nA	89	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nA	89	69751493	70188819	70357246	75499720	75933603	75933844	76591778	77182716	77754775	78046361	78196991	78865967	79445883	80753610	85576603	87148461	91550974	92505344	93339165	96296276	100982990	110291941	118266477	125690902	127899248	146861606	160715744	182275510	205891538	227901205	298075351	377692905	398186841	408379008	408677732	409844839	409912426	409956138\nA	90	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nA	90	70841590	71305650	71468487	76666508	77034763	77034989	77689557	78245032	78853682	79099308	79241776	79941647	80511105	81817685	86765206	88380471	92842292	93715425	94426097	97408098	102112457	111693168	119328318	126732486	128690704	147857403	161128244	182646677	206318713	227101722	297998716	375442416	393777122	401715055	401906097	402693944	402721244	402737992\nA	91	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nA	91	74857540	75324666	75495487	80911713	81229504	81229777	81976089	82555298	83141036	83353344	83502638	84274314	84959248	86425679	91484164	93293143	97854432	98676334	99356194	102888226	107925752	117951673	125103312	133305469	135309992	154583591	168998166	190642486	214514137	236294982	305775242	381562624	397266245	403444521	403567846	404103416	404114127	404120633\nA	92	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nA	92	78356742	78838376	79011953	84670316	84933841	84934132	85716851	86308303	86916083	87094884	87246002	88033252	88687507	90165990	95446611	97471346	102113005	102881104	103435681	106986255	112043549	122894221	129780116	137845427	139897634	159698864	173867094	195691043	220149128	241181615	311612835	385804894	399767370	403857979	403937968	404294270	404299014	404301896\nA	93	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nA	93	81534373	81999821	82117594	87767127	87979500	87979847	88796569	89350784	89964928	90155878	90262275	91044690	91691930	93178501	98648184	100775291	105458332	106308108	106786728	110211038	115324285	126558437	133634776	141698474	143538747	164309062	177938406	200394969	225759065	245221109	317828577	389577134	404519465	407175633	407225835	407450512	407453555	407455426\nA	94	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nA	94	87115061	87520089	87609334	92396246	92553008	92553306	93306580	93766492	93928727	94411602	94497689	95263987	95875196	97254058	102418237	104682840	109105800	109649514	110057705	113460336	118601849	130141677	136181941	144372355	145947558	166588051	180358960	202725802	228393515	247805585	321501713	395155354	407485150	409337878	409373481	409533134	409534627	409535459\nA	95	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nA	95	89922103	90271932	90336606	94430956	94545942	94546165	95193269	95540385	95653931	96082404	96152220	96877300	97512513	98848703	103825338	106010175	109924499	110360608	110749730	114219089	119394159	130782240	135773428	144250269	145601475	165479390	179287554	201208816	226447954	245664623	317241192	387215491	397971654	399281147	399299312	399381047	399382363	399383165\nA	96	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nA	96	96402306	96650276	96689120	99673241	99747976	99748080	100223871	100463205	100546080	100885445	100935086	101593742	102165688	103339266	107851580	109865466	113331678	113692778	114051849	117372623	121977016	133095061	137640646	145764053	146837280	166439270	179691243	202099817	227378884	246279843	318239114	388634661	399734555	400775953	400787619	400838989	400839522	400839848\nA	97	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nA	97	104847813	104974742	104996966	106754987	106793269	106793326	107085776	107222877	107265959	107484207	107519471	108110607	108670896	109732736	114006159	115805798	118800980	119015962	119363352	122721106	127202529	138039584	141877802	150049862	151057059	170140596	183967545	206398490	231937278	251024460	323529016	393667113	402649585	403465854	403470861	403493969	403494588	403494975\nA	98	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nA	98	114369095	114388854	114392008	114766668	114774417	114774423	114842483	114874427	114883678	114952402	114963673	115450305	115978221	116857283	120780566	122287277	124794214	124941771	125244385	128235465	132469190	142501496	145711286	153408013	154343627	172303046	185876595	208198172	233586439	252534430	324958404	394326042	401996114	402630734	402633111	402643418	402643672	402643814\nA	99	2	7	8	10	11	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nA	99	130467752	130467766	130467820	130467821	130467824	130469875	130470135	131006123	131555347	132401519	136319863	137801663	140185338	140292577	140581948	143480658	147450477	157062552	159726649	167114885	167863658	184899701	199150602	222492456	248975281	267161885	339064740	400689641	407568451	408055836	408057394	408063698	408063949	408064053\nT	0	2	7	10	12	15	16	18	19	20	22	23	24	25	26	27	28	29	30	31	33	34\nT	0	7150928	7968361	9497016	9915557	10279383	12764360	13156135	13176953	13664857	15064144	16806352	17306046	20110712	27592349	32267743	41543280	42184688	63147134	156418219	173874539	259952318\nT	1	2	7	10	12	15	16	18	19	20	22	23	24	25	26	27	28	29	30	31	33	34\nT	1	15700965	16747634	21309119	21860957	23123360	32125857	32621323	32780112	33481242	35404997	38035309	38863327	45539711	57580684	66779973	86031470	88777779	126201036	288585715	320907869	536944701\nT	2	2	7	10	12	15	16	18	19	20	22	23	24	25	26	27	28	29	30	31	33	34\nT	2	12327122	13464516	21938326	22315995	22980858	34381013	34845499	34923579	35629122	37541431	40441158	41155029	47575006	56850055	67157491	81303427	82701114	107816455	211304464	225844063	402654804\nT	3	2	7	10	12	16	17	18	19	20	22	23	24	25	26	27	28	29	30	31	32	33	35	37\nT	3	9517667	10204076	14633823	14895993	16216321	17806602	18117567	24472543	24980689	26033303	26526517	27045569	29140019	31959426	34268293	42132538	42516537	49906434	52707544	68382012	81511176	157912662	341748792\nT	4	2	7	10	12	16	17	18	19	20	22	23	24	25	26	27	28	29	30	31	32	33	35	37\nT	4	10751427	11865006	14815475	15221451	16835015	18692541	19098981	22637358	23203825	24504679	24968627	25446850	27948370	31183503	33566747	41198084	41506119	49548116	51444146	68093788	84243145	177174411	370204385\nT	5	2	7	8	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	35	36	37\nT	5	11208161	11481349	12662716	14357081	15127902	15232455	15586653	15603082	16269182	16628872	20405352	20865121	21807191	21891949	22116066	22895462	24111407	24420599	26923338	29483616	31679343	36597073	38572553	45864509	49971937	65285762	78605752	164724060	172158393	363893062\nT	6	2	6	7	8	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	6	21226295	21231473	21486581	22828698	25035835	26231869	26333563	26778695	26791436	27582499	27924370	33144331	33703105	34944188	35020314	35309653	36292627	37735354	38168204	41663624	45074841	49032159	56043301	59040919	70030791	78583588	105770298	127714201	127714281	287481014	302337472	661344805\nT	7	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nT	7	14990101	14993810	14995642	15193125	16277418	16277433	18285613	19333851	19400092	19732548	19742112	20308614	20618785	24588043	25099593	26195668	26261657	26490626	27354234	28620620	28932548	31790276	34846530	37733310	42315244	44736471	53291171	57296378	74975866	90654102	90654896	191165277	200358568	436279692\nT	8	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39\nT	8	17402192	17406190	17408339	17574193	18583135	18583238	20523162	21739884	21802669	22160197	22166336	22647347	22921479	27062725	27625951	28782616	28844488	29068647	29976371	31132327	31451104	34439908	35280111	41366035	45405523	47950281	57161137	61102435	74500656	85425406	97081699	132286340	132407095	193968699	215943483	483868823\nT	9	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39\nT	9	13310468	13315044	13317688	13457393	14310377	14312751	16067743	17272350	17316723	17589728	17594899	17953532	18197002	21484105	21985367	23100841	23146761	23319726	24095101	25137953	25375340	28020304	28706396	34311259	36768092	38964882	46686931	49003700	59362545	68676767	76324495	103528768	103595892	148746814	169084109	356503124\nT	10	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39\nT	10	12371437	12374498	12376200	12482240	13199850	13204609	14678916	15822821	15859935	16121972	16125853	16429100	16622958	19890765	20259552	21281560	21312811	21467276	22160332	23033319	23243258	25655970	26202176	32039450	33678736	35580130	42553708	44458023	53950604	62244064	69450640	94060513	94141475	136085591	153086921	325091195\nT	11	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39\nT	11	17518149	17521849	17524617	17647148	18491497	18502979	20455387	21731687	21777899	22094310	22099769	22500453	22728552	27095750	27582244	28671986	28713839	28907321	29736562	30730307	30999453	34072303	34778940	43390198	44676278	46927565	55904911	58805959	72017803	82311854	93535490	127051096	127159930	186258969	207530651	442713743\nT	12	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39\nT	12	18529226	18532962	18535845	18671659	19562372	19578959	21888221	23074421	23119106	23393208	23398856	23851213	24130346	28185368	28811414	29982339	30026146	30216031	31092205	32264175	32540487	35745496	36579546	45397049	46566606	49117198	58716610	61745047	75322664	86527820	97501203	132718078	132817306	192525110	217623448	461573446\nT	13	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nT	13	18633318	18639293	18646229	18784359	19657892	19684360	21994327	23242154	23289200	23545709	23557030	23639747	24155929	28360506	28995781	30172197	30217237	30417906	31305807	31830112	32756919	35996944	36879855	45596070	46728339	49226286	55245723	61676760	73422096	84083597	95702643	101141664	124966224	144481085	188509013	221548566	304992416	452450375\nT	14	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nT	14	18543548	18550400	18557696	18699703	19620627	19654852	21817846	23076925	23136864	23373810	23384334	23475769	24077892	28021922	28632855	29815175	29892917	30089844	30947131	31528579	32475070	35622858	36477878	44929347	46011748	48484547	54383677	60861514	71849557	82372308	93221448	98676699	121635474	140489615	183964290	216190109	298012129	438278721\nT	15	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nT	15	18468787	18474212	18483024	18617315	19533461	19584701	21821490	23092127	23139770	23365588	23377062	23480324	24103947	28101389	28722697	29909868	29965526	30162308	31006498	31605858	32587558	35839936	36680980	45187534	46235193	48691324	54645065	60960667	72048848	82558080	93403532	98951105	121835704	140715448	184257789	215850920	296226723	426489703\nT	16	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nT	16	17818800	17824560	17835766	17948037	18759497	18825097	20967416	22252933	22294360	22512979	22524571	22630432	23163986	27087993	27666431	28833215	28880776	29067348	29872753	30396160	31383678	34511445	35265690	43521099	44512568	46863049	52625023	58437894	69103011	79258943	89791248	95315756	117238334	136123492	177841605	208664324	284353475	409915120\nT	17	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nT	17	18967098	18971687	18986952	19097327	19902151	19982432	22105868	23404463	23450121	23670867	23683771	23809364	24372827	28460779	29017574	30189951	30244669	30440705	31252555	31797977	32810607	36016660	36773392	45325169	46336227	48699645	54717263	60657641	71989235	82251966	93823492	100083047	123004770	142790665	186579398	220348207	298006722	426180510\nT	18	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nT	18	18776822	18782124	18798331	18904975	19703132	19811039	21943209	23161049	23203667	23410907	23425487	23562596	24074312	24579367	28633516	29798977	29853197	30046896	30852534	31447431	32545858	35589568	36470659	44662958	45694828	48063465	54129340	59900948	70685775	77876622	92113732	98405361	115756426	135342530	165910155	207809838	286863179	417839987\nT	19	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nT	19	19168811	19173736	19195993	19305071	20126476	20279058	22422797	23623864	23673300	23879486	23896707	24066422	24644259	25299882	29235390	30404997	30472956	30690810	31496775	32115738	33333840	36411150	37313924	45535917	46601367	48920064	55204153	60950321	71773237	79015444	93274285	99734505	117018625	136901819	167518949	210525697	287566763	414558878\nT	20	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nT	20	19563740	19568585	19590054	19696648	20548495	20759800	22863081	24023242	24069356	24275637	24295617	24482257	25161143	25950511	29570366	30728448	30794827	31016752	31812197	32493268	33834055	36880722	37802480	45812664	46889410	49239815	55665069	61466450	72001719	79379357	93486220	100132072	117552069	137481283	168677292	212345516	289142039	414781384\nT	21	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nT	21	18953143	18960036	18989592	19089248	19901539	20184688	22259802	23276536	23330084	23526301	23550130	23783123	24540638	25459921	28723346	29861874	29951962	30191191	30979116	31633514	33120832	36092327	36968383	44598941	45614588	47883414	54316659	59761441	69803243	76949848	90495679	97190425	113933910	133115345	163024674	205775522	278017747	397907213\nT	22	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nT	22	19270802	19279601	19301034	19405920	20203043	20538050	22491422	23415988	23471974	23664745	23687899	23947905	24792259	25871612	28780397	29860597	29957535	30200105	30984555	31694186	33287443	36151172	37044068	44385578	45414947	47629889	54195351	59574160	69368529	76510904	89842150	96749906	113280185	132622340	162836606	206694097	278425168	398567828\nT	23	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nT	23	19685672	19693608	19715759	19819649	20664842	21099856	23006661	23810643	23865883	24054302	24078892	24386723	25392588	26617580	29162141	30249182	30353307	30602779	31382006	32097322	33938778	36854052	37735052	44870153	45933700	48178150	55213968	60602327	70197011	77458523	90943633	98160963	114941543	134579943	165682046	207422344	276729728	400789890\nT	24	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nT	24	20195487	20204668	20229439	20331324	21198308	21747158	23616181	24328235	24378178	24564949	24593717	24928217	26036831	27384769	29554678	30672418	30771575	31033936	31830385	32593150	34700855	37542923	38441524	45315658	46425723	48779256	56117506	61590605	70849035	78380511	91660655	99211646	116188179	135565290	167580980	208588871	279909415	404920164\nT	25	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nT	25	20774663	20786462	20826023	20915003	21878086	22740063	24889051	25513942	25571706	25746059	25779551	26166457	27602219	29149014	31036206	32184264	32298844	32581751	33391791	34249676	36758356	39828034	40762135	47536645	48732192	51168215	59354949	65033030	74175990	81958782	95673899	103752974	121147919	140917148	173894333	214302890	285839559	405109268\nT	26	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nT	26	20542512	20556262	20597957	20692757	21637944	22661323	24700635	25200319	25259503	25435458	25479236	25969118	27449868	29126055	30654228	31812029	31933380	32242708	33065824	33880109	36612117	39498064	40455623	46878962	48114935	50558758	58733126	64320259	73030186	80978800	94047250	102504710	119473577	138572555	171425483	210545401	282655605	398431539\nT	27	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nT	27	21569768	21583213	21626711	21726256	22713609	23966603	25904270	26260950	26320368	26487213	26535679	27096595	28856761	30633883	31885932	33035840	33172229	33507835	34317787	35174038	38169217	41267242	42277147	48504304	49786693	52283647	61368484	67059520	75696326	84062795	97621252	106887201	124461650	144415048	179100388	218821065	294183597	409775796\nT	28	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nT	28	21989174	22005350	22060723	22177825	23250237	24760469	26486932	26760047	26831002	26999933	27058463	27721835	29687245	31316224	32412130	33555465	33723268	34090454	34912791	35809423	38997427	42358465	43403690	49237161	50587731	53120417	62924556	68689664	76800801	85470088	98951855	108943160	126540634	146499907	182477875	220930094	297891600	412372510\nT	29	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nT	29	21945940	21962831	22014730	22139859	23222140	25038840	26561616	26696928	26766322	26936629	27001444	27759009	29927780	31434832	32334272	33461594	33627021	33987310	34811304	35767393	39176412	42682216	43742872	49129779	50530977	53048876	63408141	69078085	76615170	85507596	98649515	109351506	126627673	146293278	183189307	219793235	295645724	404563427\nT	30	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nT	30	22599600	22620875	22678793	22831733	23997607	26150018	27463683	27550505	27631171	27814021	27893436	28758840	31136322	32449564	33326282	34479352	34664022	35077045	35935416	36891985	40495439	44344305	45461018	50601207	52063366	54675972	65856464	71744131	78957150	88194594	101461524	113037387	130442967	150404025	188747300	224823883	301903685	409919039\nT	31	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nT	31	23106912	23127741	23193840	23363323	24577538	27150842	28160150	28208212	28302370	28496220	28590894	29589011	32245692	33255520	34054885	35260121	35467446	35894100	36771615	37779443	41516426	45754958	46919452	51643758	53190285	55814435	67818533	73789842	80451497	90090417	103229633	115738785	133049563	153291201	193519164	228322634	306144314	411530436\nT	32	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nT	32	22857065	22882299	22959446	23141886	24327702	27015258	27697560	27730991	27834609	28029994	28153213	29268748	31932546	32640171	33417493	34589477	34815295	35280862	36172870	37201167	40901943	45259125	46448748	50711525	52308724	54893674	67051930	72889577	78886938	88807673	101135157	114347257	130686697	150150593	190366905	222473695	298392301	399378593\nT	33	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nT	33	23248216	23272929	23353574	23569446	24865250	27895946	28404899	28439106	28544017	28757683	28890220	30205219	32977202	33507879	34358943	35555806	35785763	36299106	37212553	38320363	42233274	46843483	48115827	52260734	53936677	56625135	69570681	75574693	81360787	91797110	104233938	118630411	134739482	154614364	196214478	227187914	302917755	402241893\nT	34	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nT	34	23946726	23971303	24060601	24294720	25564684	28902311	29233868	29269047	29383684	29611233	29771243	31180294	33899744	34259639	35121573	36367465	36602931	37082829	38015011	39142034	43175943	47826377	49116163	53100229	54869330	57635231	70850808	76837332	82411396	93326070	105547022	120960705	136351045	156823046	199800148	230481613	307819033	406625602\nT	35	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nT	35	24389288	24413366	24520986	24835953	26077296	29401902	29626704	29672229	29805843	30101750	30287083	31923688	34633699	34927819	35796901	36992934	37254978	37848893	38936457	40132191	44250420	49089163	50506453	54352517	56252445	59008407	72985676	79122322	84655022	96095211	108378696	124736503	139851525	160918720	204470736	235460739	312268886	408624492\nT	36	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nT	36	24650820	24675409	24789394	25099034	26396207	29811094	29923371	29974063	30111525	30418455	30617078	32470332	34975825	35143656	36056218	37241961	37521143	38090786	39147216	40361578	44668462	49432751	50930092	54624863	56671013	59486310	73663553	79664783	84985006	97162116	108977707	126782324	140727119	161750124	205866925	235954324	312136079	405628317\nT	37	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nT	37	25823872	25852369	26083937	26437825	27725868	31264239	31325523	31382032	31602459	31942987	32220439	34190081	36518791	36640046	37570716	38858380	39202628	39827898	40958035	42344703	46763644	51434526	53117995	56900583	59131989	62092034	76540007	82835789	88350064	101302499	113114718	132132511	145786754	167454162	212995824	243565076	320747639	412973854\nT	38	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nT	38	26637157	26667030	26823612	27157275	28466450	31872222	31916926	31967654	32169288	32511917	32775449	34928235	36930440	37044989	37978179	39245958	39577721	40142692	41261869	42731402	47256849	51675005	53444023	57201708	59563859	62629305	76951748	83229393	88865309	102578289	114020097	133886723	147288360	169385332	214185419	248091166	328939963	424101589\nT	39	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nT	39	26931942	26968852	27143403	27522741	28822565	32135810	32179905	32232789	32453900	32871882	33185727	35396494	37143135	37262936	38234039	39462135	39828127	40476169	41646978	43219949	47789697	51901642	53708154	57431648	60045162	63160572	77137743	83479725	89143567	103139291	114411606	134662592	147672071	169404450	213663856	246366832	324607180	414414227\nT	40	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nT	40	26446410	26480247	26647403	27049530	28363925	31563241	31607750	31666062	31887140	32308588	32657937	35023469	36494332	36617052	37585432	38814907	39192616	39789751	40983191	42701381	47322761	51143456	53053513	56732427	59434829	62590077	76301819	82516945	88121202	102588828	113436784	133839285	146254871	167771487	211482716	242956726	319692346	406151646\nT	41	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nT	41	26566811	26600840	26777604	27215865	28527623	31715825	31769267	31840317	32066004	32542607	32938455	35531456	36712880	36847959	37806575	39064030	39482406	40084263	41321819	43203096	47955708	51546730	53512456	57163769	60062039	63252481	76861086	83223821	88855138	103972606	114437565	135231553	147527426	169483599	213266421	245164059	319668171	401545984\nT	42	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nT	42	28604660	28640136	28861095	29347482	30747695	33893340	33947824	34026091	34325825	34862166	35319712	38017653	38982944	39122882	40106523	41448534	41961404	42600042	43966440	46029369	51101403	54354163	56616698	60376550	63624044	67052594	80878762	87684119	93786053	109934694	120650973	142560269	155377815	178414669	224293873	257505400	335738893	421789591\nT	43	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nT	43	28474189	28512123	28784368	29324042	30680379	33789799	33848067	33940014	34271540	34872938	35429952	38073189	38871702	39030436	40060397	41400654	41952892	42596933	44059078	46295138	51366842	54360753	56756267	60500233	64029843	67517970	80843669	87822234	93996310	110355625	120998936	142567537	155382853	178438359	223659192	256301581	332405117	414986687\nT	44	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nT	44	29337511	29386049	29635909	30195917	31639652	34666995	34726957	34818725	35140684	35809189	36391071	39114429	39670867	39832515	40808931	42173678	42889867	43453365	44977396	47431359	52570682	55256063	57745256	61476197	65299011	68917672	81911895	89142920	95508327	112409855	123119237	144912048	158047383	181369479	226619431	258339313	334642074	415745368\nT	45	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nT	45	29435749	29480420	29764063	30341904	31789877	34623777	34691328	34808906	35166529	35905855	36557329	39178834	39586171	39748619	40761197	42123453	42909325	43454132	45038190	47703305	52880506	55226107	57721826	61403216	65591851	69278197	81657790	88991746	95411002	112225606	123074082	144360214	157750521	180952642	225659641	257494498	332882520	414358810\nT	46	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nT	46	30334819	30389673	30640897	31272440	32710825	35355178	35424149	35541230	35890868	36735963	37424729	39943615	40265785	40450040	41430243	42727234	43545271	44095285	45788211	48604064	53647186	55728951	58312897	61888981	66512717	70279840	82217037	89718162	96295125	113273055	124563881	146132302	159723707	183459111	228027950	260794003	336345140	418423495\nT	47	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nT	47	30499832	30548539	30802293	31473626	33035127	35538882	35606069	35737228	36094351	37023194	37768180	40115005	40350965	40523199	41507789	42858328	43690343	44260319	46056373	49078433	54122648	55773923	58529634	62106751	67114824	71014327	82294303	90077559	96824431	113698048	125550047	146539528	160673919	184250820	228377294	260720243	334507940	413615713\nT	48	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nT	48	31344641	31398627	31649057	32292409	33882131	36432755	36502611	36628194	36970381	37917819	38685027	41079026	41262907	41466401	42471797	43836568	44673658	45196236	46977623	49878425	55472528	56863217	59748403	63416781	68666955	72686971	84145303	92041768	98941077	116549320	128671188	149567382	164687126	189358466	229740319	267463929	341988796	422454539\nT	49	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nT	49	32243446	32292240	32566163	33234365	34887486	36961006	37038247	37198674	37550105	38626962	39442368	41386101	41527671	41733537	42782785	44077854	44925732	45480603	47455840	50569429	55628203	56735432	59669655	63256996	69018272	73195767	83363435	91618624	98805681	115424386	128260610	148721639	164109310	188569410	228326654	266044148	338824505	416165160\nT	50	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nT	50	32514433	32564408	32836428	33519600	35196252	37203994	37281838	37415017	37782637	38911307	39748178	41499114	41633124	41828654	42872211	44179894	45091231	45680147	47717565	50883531	55784670	56795906	59979380	63491446	69511002	73818841	83702285	92439040	99825807	116229342	129933592	150989191	167042342	192200799	231886057	269928699	342051939	418004660\nT	51	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nT	51	33042932	33095621	33366661	34065748	35804542	37642886	37724675	37864181	38227137	39396171	40275015	41812367	41927873	42140469	43178986	44513635	45424098	46044070	48154682	51393924	56174327	56959317	60359391	63833045	70141996	74635380	83937128	92862401	100530174	116662150	131181121	151978553	168695766	193409870	232539561	269659358	340477809	413273930\nT	52	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nT	52	34434905	34500074	34802993	35560536	37427583	39198423	39288359	39448217	39842290	41095461	41997927	43423981	43547561	43768089	44892872	46258242	47293024	47931005	50184361	53622402	58314460	59091826	62824573	66313138	73115667	77882671	87014828	96533793	104640689	121011141	136599864	157845389	175438341	201192483	240562489	278468373	348270878	418915645\nT	53	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nT	53	34056543	34122737	34422815	35336709	37627015	39321302	39424955	39603083	40035030	41482920	42466059	43599378	43731724	43973125	45263702	46724913	47845452	48511356	51031708	54796646	59247646	59855101	64027264	67539711	74799003	79876679	88160935	98077459	106299112	121695069	138485011	159132252	177193983	202159533	239746432	275914997	340961954	406373098\nT	54	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nT	54	34831151	34906199	35218713	36201772	38673692	40175062	40274046	40473012	40915580	42515532	43527997	44560697	44688050	44928900	46223970	47638903	48871368	49630169	52394964	56170098	59044203	60899982	65407885	68646925	76376342	81615089	89467524	100056648	108588998	123106345	140913931	161424498	180085191	203703972	242233078	278743111	341835416	403282987\nT	55	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nT	55	36273952	36345128	36732502	37792543	40541232	42039233	42169610	42401510	42899256	44707393	45858454	46901690	47027434	47301365	48758096	50229063	51509314	52311039	55416860	59549565	62690019	64620042	69601871	72916815	81394368	87017490	95544001	107011855	116084484	131676495	151028994	173023340	192775066	218145848	257913815	295100345	358884802	420014940\nT	56	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nT	56	36779433	36862181	37243169	38305818	40982015	42084378	42218490	42493228	42989650	44852722	45876481	46677800	46802336	47073500	48533022	49918750	51393240	52245248	55423164	59408440	62003738	63960564	69324424	72393842	81317572	87167481	94655397	106494514	116045217	130519305	151573657	173361485	194264153	219007686	257412499	294947977	355241190	412335515\nT	57	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nT	57	37434699	37508532	37913064	38992855	41843692	42770550	42911806	43178954	43711448	45649197	46600228	47230110	47351713	47629532	49191851	50560335	52034694	52917163	56309469	60291225	62489666	64503312	70292038	73295048	82478817	88628189	95656954	108144972	118134312	132064407	154062772	175810428	197516947	222065269	260199878	297628367	356091546	410275968\nT	58	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nT	58	38490132	38573910	38925731	40033504	43142057	43917444	44070557	44346926	44780315	46860243	47790256	48309106	48424618	48699757	50375197	51713193	53085105	53917537	57491057	61554369	63438765	65467107	71538596	74432189	84294862	90815375	97373165	110137012	120552138	134500377	158233742	180611675	203590871	228406357	266585660	304554939	362671253	416061022\nT	59	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nT	59	38772449	38857047	39223660	40380551	43514309	44099860	44270072	44566357	45009717	47187045	48030893	48468284	48581167	48898696	50662622	51958974	53426440	54305668	58149210	62140101	63847047	65919209	72519741	75251039	85398549	92206388	98628384	112042896	122949160	136485687	161506988	184646810	209079540	234176999	271264160	308955181	363954295	413382825\nT	60	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nT	60	40064340	40161646	40499100	41611385	44545825	44974265	45124650	45428021	45864449	47911536	48681142	49071496	49187000	49471204	51262631	52530406	54066731	54966862	59007169	62700697	64242076	66379292	73393158	76007908	86278551	93463311	99854120	113800511	125372322	138579952	165020990	188864380	214848595	240308998	277938709	317376197	372858069	422439420\nT	61	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nT	61	39946806	40038325	40414432	41609505	44526038	44827088	44987245	45326375	45760149	47799508	48472905	48788973	48902044	49209922	51097285	52315085	53943717	54955555	59024952	62427967	63806073	66053926	73378549	75829296	86049584	93457204	99882591	114084860	126203028	138505014	165821660	190162683	216701278	241862984	277423811	316550277	367174608	411974815\nT	62	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nT	62	40318799	40421893	40767636	42031213	44915023	45198454	45374413	45725511	46149072	48149294	48852709	49180864	49295904	49633360	51581476	52733556	54459857	55463312	59584962	62933002	64309036	66678035	74287774	76699489	86702516	94463290	101122625	115589172	128012777	140409550	168904525	194597258	222275270	248487037	282616425	321937250	369460590	409963501\nT	63	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nT	63	42496577	42595990	42912666	44290501	47405758	47562920	47769442	48143752	48534215	50704147	51299533	51568624	51682309	52045544	54200241	55368958	57135244	58184440	62767958	65994755	67219781	69758963	78012989	80366314	90894249	99356698	106148631	121709638	135027599	147083203	177921371	205025747	234516111	261472730	295825447	336712365	383130937	422091912\nT	64	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nT	64	42515704	42621154	42988344	44505341	47618538	47721976	47947634	48361184	48778674	50873403	51408461	51644614	51781666	52159207	54150908	55633205	57521500	58621366	63061363	66144136	67334627	70128655	78647553	80745318	90760582	99874736	106672820	122402325	136014470	147666717	179374667	207666478	237402429	263843863	296038371	335548896	378466333	414461086\nT	65	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nT	65	42797603	42918047	43277750	44893026	47988278	48061392	48307563	48765303	49172735	51348852	51838541	52086422	52226927	52632282	54727562	56179834	58200553	59366802	63971153	66974416	68157652	71023622	80195153	82150277	92054985	101519755	108675582	124726748	138682569	150273803	182591703	211636054	241546520	267998122	298401229	336818029	376387857	409117557\nT	66	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nT	66	44285857	44417335	44828772	46713406	50258742	50303938	50548621	51083909	51511845	53853866	54303168	54551796	54694767	55112841	57515899	59006570	61197489	62433668	67554546	70320332	71574153	74645808	84559231	86442990	96506204	106683271	114281084	131160140	145715702	157168739	191409858	222672457	254182750	280774786	309382207	346887811	383018382	412382271\nT	67	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nT	67	44830933	44991738	45397298	47535206	51088800	51118102	51409708	52011777	52431793	54844308	55278190	55567057	55722999	56167747	58682076	60114960	62488087	63794029	68844104	71588612	72889771	76093005	86553617	88447678	97880010	108525100	116518883	133487061	148024696	160071765	195012841	228004802	259455959	286897672	312994224	348536342	381162455	407469719\nT	68	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nT	68	45301546	45527429	45889213	48182998	51653268	51668023	51988005	52610751	53090419	55599352	55990864	56347865	56506366	56964616	59499951	60888378	63527031	64945828	70213602	72741016	74049830	77374151	88285958	90201498	99281208	110485764	118660958	136249079	151269641	162920283	199524903	234195974	266795921	293276526	317615204	351908467	381468366	404680011\nT	69	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nT	69	47154346	47335445	47744133	50147664	53436239	53443066	53806342	54502790	54954321	57421734	57786463	58113227	58267057	58765561	61470895	62869970	65596497	67091554	72124582	74242633	76281183	79808509	91005251	93009568	102036492	113977438	122911510	140529894	156481349	168439187	207018958	243801987	277822594	305861541	327985980	363150309	389092335	409493768\nT	70	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nT	70	47631728	47876193	48224633	50954239	54255074	54259222	54644781	55349092	55825329	58252386	58551748	58985126	59164042	59708933	62546652	63890146	66908901	68543220	73478329	75381417	77433692	81174181	92954117	94937138	103469888	116048242	125108131	143235668	159722698	171615695	211793637	249729992	284328897	311434531	332317917	365681123	389930046	408723281\nT	71	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nT	71	48074912	48304959	48683658	51581128	54847772	54849575	55275203	56059291	56568733	59109210	59389954	59802215	59966530	60505139	63567741	64972282	68128115	69824125	74918886	76790643	78875125	82982970	95359255	97290330	105581558	118885168	128193596	146790691	163719093	175454595	217030684	255455170	290138224	315510329	334723909	366546436	388399811	405230442\nT	72	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nT	72	49184241	49434774	49784827	52776377	55812949	55814207	56264331	57041940	57549624	59952659	60209904	60651941	60804942	61366524	64475495	65893368	69181051	70947034	75916836	77673663	79840323	84124907	96817563	98814134	106869837	120869058	130472162	149424844	167060411	179127599	223190487	264058238	299895146	325185432	343115978	374228791	394135300	409299070\nT	73	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nT	73	50301913	50582977	50945026	54313784	57323198	57324110	57818497	58700652	59257726	61673359	61905840	62396781	62569896	63166287	66481561	67873383	71547854	73377567	78288051	80057295	82327495	86931563	100224070	102359627	110069039	124861830	135092406	154294046	172562710	185018646	230905409	273642398	309839898	334937365	350053450	380342550	396161675	408148536\nT	74	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nT	74	50220771	50498433	50900049	54435117	57167216	57167862	57715662	58660268	59204682	61414951	61637200	62119995	62290724	62925801	66396454	67785495	71546240	73428198	77912406	79601855	81962673	86873359	99651835	102378059	109317590	124601423	134828307	153954835	172438846	185006786	232252878	276884645	313146759	338597399	351989528	381944854	395367853	405359540\nT	75	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nT	75	53491647	53690181	53919126	56457933	58254178	58254702	58948358	60019404	60701790	63712152	63886376	64361882	64465583	65065908	67434814	69029098	74364203	77075550	83871034	85932175	88720000	94418037	113654572	116730634	128761086	150622037	168743918	199073601	226312957	241783494	301885717	334593538	366171258	378981096	387429653	407749964	412068441	413717611\nT	76	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nT	76	53197664	53407923	53631380	56104613	57629388	57629805	58195950	59057390	59574186	61369754	61484991	61960386	62072164	62636616	65099678	66406134	70638438	72492214	76607885	78232271	80859212	85826211	100268517	103297213	110725460	129720823	143629829	168375296	194432549	210396892	277372855	316465730	353847300	368210648	376827142	405264730	411049799	412307432\nT	77	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nT	77	54724661	54950301	55157591	57551418	58925184	58925547	59438839	60181762	60641398	62027386	62127102	62620155	62730901	63282097	65857768	67040744	70875989	72396347	75635030	77134795	79519053	84427611	96832675	99655354	105071316	122244043	133583741	154862934	176976074	192363024	255132930	307336697	346408809	369205775	377910758	406081523	414811290	417794982\nT	78	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nT	78	54429482	54698518	54901023	57909287	59408346	59408755	59933224	60702191	61186140	62479548	62577994	63121137	63255286	63809656	66613340	67783965	71790921	73295683	76064409	77475636	79859517	85006377	96572888	99480084	103872781	120301289	130309178	149858294	169839567	184347740	243149398	302708905	339954066	366163017	373310446	396732938	403692466	407786547\nT	79	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nT	79	55109291	55364739	55564828	58516023	59805273	59805652	60390704	61202584	61698824	62904548	62999033	63518167	63641641	64248181	67073526	68266330	72303408	73738054	76217726	77706409	80086879	85540444	96745412	99690823	103502799	120007323	129609101	148707761	168307019	182498106	240899249	305524822	342244073	370812952	376713323	397854514	403027145	406870118\nT	80	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nT	80	57415621	57676453	57838977	60727436	61858108	61858463	62440591	63206101	63731534	64861608	64942587	65515647	65642531	66253229	69009542	70200530	74395917	75812317	78144661	79660822	82105889	87644078	98841160	101989473	105651058	122645931	132594025	152011332	172405128	186837349	248422499	318049210	356674343	384813836	389965551	410628033	414772037	417998977\nT	81	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nT	81	58035631	58269696	58434650	61264518	62161602	62161932	62761064	63542057	64024738	64967783	65052047	65559862	65685936	66297861	69088345	70361440	74523161	75900637	77822553	79383545	81844567	87758252	98655807	101895021	105188730	122517783	132139870	151586114	172318001	186657914	249544458	321349576	358555374	384743555	388962753	407286549	410132654	412453173\nT	82	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nT	82	58304082	58566487	58713165	61596707	62439346	62439755	63047452	63803856	64249405	65051873	65125650	65686055	65837504	66481281	69327276	70614609	74744824	76012618	77715302	79323169	81848179	87905742	98432065	101809913	104845323	122074468	131817401	151282516	171814333	186503950	250145854	323806870	361580979	387963442	391173843	406779495	408616269	410149508\nT	83	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nT	83	60217741	60509082	60654978	63781400	64578227	64578631	65282348	66107493	66592653	67352442	67423164	68024457	68180344	68866191	71829282	73329356	77779994	79048778	80584898	82363338	84965371	91717387	102332055	105988849	108567865	126599284	136316158	156631846	177465277	192565660	257465981	333155292	369749848	395965715	398359539	410526242	411698108	412705904\nT	84	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nT	84	61708151	61969252	62109505	65245395	65964407	65964752	66686884	67478186	67921719	68615366	68685138	69240705	69390623	70121643	73142421	74668508	78959522	80185964	81607892	83417387	86001671	93170161	103390668	107056873	109534678	127858467	137424364	157931371	179398602	194315894	261667554	339354881	377888558	403050303	405249722	417508499	418257430	418888538\nT	85	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nT	85	62276249	62540903	62667317	65882719	66470142	66470499	67229369	68026953	68528879	69119171	69184810	69749479	69913323	70650470	73651079	75252448	79849529	81012878	82133980	83956907	86607759	94026294	104181780	107945097	110159543	128824635	138103971	158676670	180264759	194995016	263603625	341892033	377522534	398208473	399640505	407657009	408122340	408517748\nT	86	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nT	86	62514955	62823569	62946230	66234774	66777137	66777542	67619283	68401105	68868187	69351689	69416345	70059455	70225924	70991790	74067791	75897499	80438363	81486204	82420496	84277683	87165238	95227692	104471565	108501933	110353445	129129326	137904838	158641044	180196341	194521054	263474575	342663872	375826933	394922829	395928012	401599977	401910489	402169491\nT	87	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nT	87	65693988	65972544	66098337	69539898	70009103	70009540	70868445	71724739	72186326	72637360	72705294	73304345	73466435	74241565	77467148	79418449	84137458	85190792	86000200	87888367	90830597	99497261	108954664	113021402	114773564	134622745	143414268	165100114	187680233	202048928	274137573	355477112	389534803	406415124	407159931	411328996	411555993	411740920\nT	88	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nT	88	68404055	68686586	68803603	72229586	72646163	72646486	73520655	74325674	74767290	75133384	75195823	75813159	75977506	76784816	80047393	82067678	86756984	87692265	88346543	90395400	93328265	102486351	111325194	115606093	117179912	137359530	145957561	168120340	191081611	205509486	280873509	364671674	396261758	410403758	410856222	413420691	413551857	413659286\nT	89	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nT	89	69681130	69980683	70084756	73434824	73789948	73790348	74723555	75489428	75932088	76235736	76295659	76955470	77128018	77952348	81144378	83348773	88042970	88894185	89398619	91438573	94548037	104097753	112263681	116723176	118170653	138481890	146905024	168985589	192147662	206556286	281613869	365069810	393763536	405260555	405553901	407310223	407377056	407429769\nT	90	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nT	90	70717288	71016880	71100309	74584125	74907607	74908033	75904315	76646362	77058647	77314538	77364415	78023916	78200552	79051141	82351379	84739045	89351310	90091174	90514240	92539017	95590204	105758627	113352419	117838162	119194675	139608903	147706072	169843242	193068748	206859183	282597240	365594151	392185173	401359573	401551976	402741707	402771646	402794529\nT	91	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nT	91	75007955	75336887	75420141	79036168	79366000	79366497	80425208	81154858	81596169	81867910	81913232	82642571	82817805	83635948	87105216	89775830	94595719	95420556	95803117	97807479	101115323	112030466	119815662	124545949	125833996	147331754	155517658	178603689	202903033	216306086	294201802	377319500	404159292	411901505	412033112	412845089	412861572	412873283\nT	92	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nT	92	77000592	77317006	77389934	81228436	81507415	81507866	82607648	83352341	83795348	84089848	84134191	84845913	85055655	85998180	89565070	92317127	97103493	97999818	98291037	100580040	103939201	115017967	122545960	127593853	128883839	150365288	158838674	181845437	206102344	220011454	296378816	377957797	400420389	406452513	406538486	407082098	407089440	407094685\nT	93	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nT	93	80940716	81253751	81320556	85001604	85257600	85258175	86468291	87169867	87579701	87741508	87783128	88507915	88692776	89656074	93258472	96304639	100995965	101588012	101813208	104004548	107287999	119284958	125967672	130899578	132039730	153806125	161761259	185045351	209411364	222218046	299643154	380257499	400644596	404955096	405015046	405400229	405404143	405406953\nT	94	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nT	94	84026217	84292924	84342444	87507424	87704041	87704453	88835321	89400344	89611428	89904663	89937666	90616752	90816378	91858410	95281962	98297670	102759060	103308578	103489430	105829073	109077472	120993460	127597389	132656686	133706037	155972359	163950028	187815705	213015422	225692542	305197119	385975155	406180499	409480639	409516946	409746718	409749476	409751283\nT	95	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nT	95	88982890	89240009	89281366	91988312	92173971	92174380	93135324	93600471	93754325	94001109	94030798	94755191	94945435	95872453	99222694	102236476	106421440	106808451	106962287	109260264	112639676	124643990	130436107	135639057	136535982	158492965	166602018	190414489	215597264	228078701	307040471	387299014	406067357	408576724	408602942	408763762	408765169	408766092\nT	96	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nT	96	94673288	94850902	94875954	96876620	96997675	96997869	97734891	98051559	98163686	98335244	98357185	98976103	99144626	99953841	103022406	105896229	109510214	109761173	109875933	111987412	115149214	127034829	131946847	136968000	137787084	159253067	167170078	191195897	216543749	228761989	309830717	390678865	407717183	409843541	409855220	409931360	409932642	409933471\nT	97	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nT	97	101412891	101520576	101533163	102672013	102751943	102752155	103195331	103377191	103435241	103555749	103569236	104184122	104348675	105089146	107925591	110480002	113751590	113918891	114027647	116069043	119186265	130580425	134811026	139872813	140570178	161256299	169078664	192976590	218158751	230559599	309553183	388825963	405073885	406908316	406916395	406964011	406964477	406964799\nT	98	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nT	98	109284399	109299429	109301972	109512767	109524606	109524632	109617504	109650158	109658416	109694985	109701550	110172370	110326214	110997126	113432282	115636282	118097181	118211836	118306891	120281222	123117097	133525619	136709191	141608281	142292133	161178204	169209897	192688639	217553484	230360428	308205075	386063922	399962314	401411799	401415205	401436667	401437200	401437529\nT	99	2	7	8	10	11	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nT	99	126472390	126472393	126472411	126472414	126472415	126473217	126473295	126952613	127096378	127730205	130316494	132541874	135151479	135251560	135340005	137099485	139729305	149711531	153055260	157586622	158103860	176372472	184834185	209567922	235089982	247425034	323828010	393041955	404601432	405656754	405658043	405664865	405665003	405665078\nG	0	2	7	10	12	15	16	18	19	20	22	23	24	25	26	27	28	29	30	31	33	34\nG	0	13916519	14950910	16974316	17516426	18129354	21384864	21745103	21812746	22350317	24166788	26251014	26949232	31317835	44664839	49462582	68023598	71284896	113182914	293153681	353225694	528721163\nG	1	2	7	10	12	15	16	18	19	20	22	23	24	25	26	27	28	29	30	31	33	34\nG	1	8751111	9588889	12703554	12905186	13472865	18184899	18546236	18640101	19186517	21177116	22860732	23440321	25467613	33803034	43659574	52994200	54288283	74646517	177909718	187725828	347187600\nG	2	2	7	10	12	15	16	18	19	20	22	23	24	25	26	27	28	29	30	31	33	34\nG	2	11047540	11970325	17453779	17673381	18179711	25939259	26335491	26386088	27036733	29667181	31699293	32389833	35937680	45555893	58497382	70578704	72372790	95803263	207782571	217755042	415795802\nG	3	2	7	10	12	16	17	18	19	20	22	23	24	25	26	27	28	29	30	31	32	33	35	37\nG	3	11755301	12491063	16243304	16418883	18449515	19681163	20023988	23706540	24306113	25922314	26484046	27123364	28936559	32487079	35385432	42463217	43000911	52149416	56955010	74912665	87066795	178668966	435245189\nG	4	2	7	10	12	16	17	18	19	20	22	23	24	25	26	27	28	29	30	31	32	33	35	37\nG	4	14484944	15978046	19654691	19927927	22585153	23920584	24388757	26532119	27222587	29190234	29706695	30286445	32368677	36384931	39273878	45690938	46069384	55167228	58104937	75037665	88790102	182318216	432438530\nG	5	2	6	7	8	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	5	13259731	13268907	13991592	15538829	17601001	17759475	17892099	18067889	18142760	18969095	19780920	21790556	22723751	23167056	23389094	23806885	24776547	26412092	26714413	28850435	31169128	33892383	37174550	38935622	45883797	50095222	64079410	72450763	72464048	147871497	151793819	346744611\nG	6	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	6	12094342	12106646	12110865	12682344	14102924	14102929	16175022	16345325	16455437	16602034	16653000	17321346	18061522	19563766	20419837	20819018	20994452	21343407	22231683	23600310	23836955	25858629	27999273	30370875	32894410	34409223	40398530	43442515	54649286	62001093	62014300	125616822	129349319	301073852\nG	7	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nG	7	14229606	14243616	14248743	14764091	16122490	16122502	18266934	18536965	18641492	18805382	18842367	19507843	20173166	21912702	22720004	23329895	23486475	23810486	24756491	26159856	26423601	28526132	31017204	33663102	36332789	38165154	45001164	48416997	61253105	70265610	70277497	146667708	151679943	343771762\nG	8	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39\nG	8	14891502	14898155	14903564	15375039	16679313	16679338	19029344	19279343	19370562	19528920	19563999	20212307	20883601	22616899	23526183	24130026	24283089	24617004	25591796	27020814	27267396	29436727	30730381	34938335	37322454	39207315	46263035	48963086	58524372	65457137	71305187	95522500	95533952	134724121	151610287	341816658\nG	9	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39\nG	9	16247042	16252704	16258171	16725977	18008935	18009079	20653528	21003497	21087110	21252216	21279478	21890054	22514494	24461683	25480934	26133872	26265114	26586713	27557419	29005488	29243416	31595314	32990896	37816396	39973704	42002411	49509425	52198496	62367658	70095406	76304783	102293213	102314302	144348114	164972655	364209402\nG	10	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39\nG	10	20062552	20067710	20072555	20509471	21785832	21788494	24660679	25023887	25104167	25285803	25310560	25962598	26579815	28879840	29962327	30692892	30819889	31136024	32205143	33694998	33961694	36542056	38054731	44131396	46162118	48416759	57016007	60436621	72344689	81289179	89460393	120344459	120359328	171360921	193385965	441939404\nG	11	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39\nG	11	17265049	17270561	17275885	17690411	18992420	18998883	21602813	21942475	22014579	22149934	22179734	22837066	23542521	25357648	26401893	26963046	27091259	27432926	28403859	29901727	30122914	32437054	33887788	39329979	40748920	42725348	50213607	52892355	63332439	70742353	76967178	103082934	103100237	145178261	165682042	367959049\nG	12	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39\nG	12	17283879	17291294	17298357	17690029	19062177	19070714	21546098	21820568	21889460	22011386	22043575	22742452	23444600	25151398	26095234	26650373	26771759	27141833	28077219	29574664	29782870	32072955	33403660	38815353	40099467	42009620	49324357	51943970	62344922	69353884	75581590	101298327	101309892	143402989	163555678	354672686\nG	13	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nG	13	18254811	18264476	18273760	18648752	20018838	20032690	22703395	22967798	23032792	23154981	23182569	23363814	24345439	26355278	27416498	27994921	28108537	28469095	29421354	30234200	31144058	33555326	34995279	40584738	41907745	43904322	48450901	53938858	62322281	70674327	77823109	82595611	100553548	113791422	148508714	173816723	243463754	366944963\nG	14	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nG	14	18568510	18578701	18594896	18971523	20276793	20295789	23065329	23349528	23416567	23530724	23558211	23747689	24774889	26822041	27906822	28487705	28602041	28956864	29919987	30739332	31692078	34156107	35684274	41318726	42713982	44669756	49360519	54895575	63374355	71956739	79202576	84171899	102391313	116096312	151752299	177785401	248490219	371478596\nG	15	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nG	15	19658357	19670434	19685717	20049427	21419848	21445306	24393030	24679475	24744645	24859093	24887879	25096842	26151477	28237534	29357684	30019821	30135992	30526240	31509657	32366985	33382745	36006386	37572741	43446556	44871359	46998484	51970325	57788531	66659860	75886241	83407981	88769670	108007948	122225528	160559191	187731601	263296970	386663840\nG	16	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nG	16	19606519	19617754	19632164	19969323	21304043	21339965	24143845	24474922	24537562	24651096	24679449	24893239	25922040	28027106	29089761	29723828	29836319	30209341	31150953	32000208	32981583	35565091	37067389	42854923	44183736	46212550	51131042	56766100	65506890	74297772	81834299	87078822	105718526	119898100	156850638	184574976	257591077	379598403\nG	17	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nG	17	19258321	19269584	19285936	19599200	20890283	20941378	23688223	23987390	24046838	24151841	24178916	24406197	25413374	27447070	28486786	29107801	29218561	29581870	30500771	31331781	32305049	34850171	36327420	41928733	43219067	45156467	50015296	55413936	63828888	72404628	79650039	84925362	102791507	116536119	152177605	179081047	248416103	366505596\nG	18	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nG	18	20448263	20460814	20480276	20778636	22123972	22192019	24919889	25220685	25280867	25386382	25413281	25664037	26528585	26852138	29747056	30412795	30525422	30908516	31826973	32711380	33762131	36276453	37805383	43449045	44816146	46805770	51880890	57448152	66027122	72024548	82346990	87883379	102249880	118981866	151023734	182199707	255439527	379023081\nG	19	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nG	19	20636469	20649285	20676159	20978688	22350223	22444932	25291617	25597711	25656420	25761507	25790623	26064181	26992809	27362833	30256267	30947053	31061767	31464747	32383975	33285076	34404506	37041208	38648489	44297963	45676463	47713320	52980661	58614565	67266747	73427335	83920860	89704165	104429095	121274268	154072506	185951563	259925085	385069239\nG	20	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nG	20	20643943	20656621	20686140	20972287	22366519	22496278	25255114	25547009	25606776	25707980	25739817	26037139	27030169	27499613	30174554	30831926	30955340	31371660	32257767	33209263	34383110	36935734	38543712	43977026	45360275	47336406	52635793	58100583	66480120	72551310	82784742	88660985	103022684	119559225	151870404	183022341	254477695	375309649\nG	21	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nG	21	22019490	22034160	22071321	22353125	23771887	23941159	26597290	26912102	26974089	27075923	27110234	27428951	28492847	29033754	31592183	32280560	32422274	32848398	33738985	34747443	35984551	38617507	40278649	45700663	47133944	49138664	54859653	60470449	69054145	75397154	86030142	92305301	107165664	124520340	157844659	191224704	264944611	391793444\nG	22	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nG	22	21679892	21693653	21729916	21995592	23403078	23621239	26121776	26373069	26433595	26529276	26564819	26918277	27996678	28633077	30932655	31583737	31736345	32178030	33027690	34049938	35372009	37910665	39514294	44667230	46068811	47999797	53732070	59132099	67320858	73532514	83644243	90122383	104375241	120880687	152892567	185397473	255957355	380283379\nG	23	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nG	23	21590191	21604539	21644864	21907133	23311255	23581746	25947283	26172132	26230345	26323379	26358815	26742317	27853970	28559206	30621300	31267940	31414340	31862401	32680574	33721720	35133303	37624894	39215181	44103343	45453715	47383451	53203660	58483788	66391594	72596610	82434605	89229929	103300569	119322687	151318388	182869208	249233168	374695444\nG	24	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nG	24	21955436	21970584	22018181	22269062	23735710	24095099	26375158	26557660	26616630	26704914	26744871	27168799	28362718	29155481	31030035	31675443	31827146	32301673	33099167	34218034	35791218	38270295	39897722	44633944	45998495	47961350	54081278	59423473	67191033	73572692	83462620	90612978	104899941	121226784	154265212	186539110	254428760	381175601\nG	25	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nG	25	21977044	21997285	22065915	22257026	24024251	24545433	26998932	27183000	27246963	27338356	27384783	27866951	29196650	30059765	31721689	32414272	32586804	33114170	33922457	35118075	36864348	39358575	41035190	45607733	47037016	49050868	55430055	60773572	68325461	74929414	84568428	92140650	106401014	122073505	154935035	185652587	253180967	372943688\nG	26	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nG	26	22944931	22981723	23055111	23250915	25119126	25833186	28036625	28184581	28253299	28340727	28391961	28949844	30467068	31426601	32951620	33632926	33829278	34384933	35183045	36421933	38349559	41011466	42693992	47161915	48631786	50723082	57711932	63102394	70700700	77581286	87567457	95951490	110472132	126677330	160492599	192105264	261284022	379401357\nG	27	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nG	27	23088278	23111305	23192945	23389248	25331958	26160896	28125044	28237881	28304381	28391243	28449315	29066741	30614287	31573040	32912775	33615551	33833283	34404359	35189501	36474302	38491244	41165867	42881528	47114206	48638216	50707992	57998012	63382975	70750239	77868902	87640302	96341974	110925353	127144490	161436268	193150459	264051132	380892426\nG	28	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nG	28	23192558	23220233	23316082	23518038	25576169	26574178	28242201	28309547	28380382	28466008	28531665	29220428	30868887	31736379	32947831	33654242	33890720	34506237	35278600	36571130	38678826	41483412	43231088	47144075	48653827	50763088	58435730	63805070	70801511	78105360	87655310	97028716	111365373	127307327	161771594	192613798	263417024	375679936\nG	29	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nG	29	23480811	23510944	23618251	23837576	26000621	27182959	28520517	28576280	28653672	28741022	28814696	29628634	31323962	32076473	33221942	33932091	34184187	34833445	35582223	36901854	39098768	42110998	43820668	47476302	48988043	51084681	59200397	64644001	71320665	78802272	88060032	98305960	112267467	127911799	162461959	192401860	262067933	369545490\nG	30	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nG	30	24002103	24034017	24157044	24408592	26722602	28164314	29264322	29292068	29372662	29470535	29553472	30407686	32225743	32851909	34034193	34749247	35019319	35691484	36451708	37807363	40142077	43321717	45128386	48591773	50179361	52399467	60947352	66450986	72907359	80774351	90200623	100943120	115281664	131142934	167129800	197122414	268758974	376321377\nG	31	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nG	31	24986515	25022772	25159136	25445882	28001921	29679531	30517687	30545710	30636834	30740399	30832220	31858734	33742790	34242353	35405011	36152478	36447124	37208570	37998165	39405166	41827248	45220757	47083108	50392111	52073272	54312013	63521829	69175408	75449437	83803215	93172688	105220767	119285167	135617263	172415757	202763874	274729818	380351488\nG	32	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nG	32	24985738	25020015	25173533	25467452	27908218	29685840	30233566	30254304	30351644	30461305	30562611	31640835	33529532	33888826	35003675	35765211	36073307	36836060	37621390	38964478	41405264	44928321	46825542	49900097	51594865	53867487	63307510	68885332	74865092	83464421	92732949	105605202	119252739	135554771	172713399	202476222	274341420	377397493\nG	33	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nG	33	25076568	25114181	25286433	25617073	28164899	30104231	30490896	30512674	30621751	30739654	30857519	32055519	33889861	34168955	35347234	36090911	36415714	37247394	38047542	39435370	41963703	45456504	47415975	50416390	52163718	54508531	64010626	69653529	75499027	84503928	93512157	107196388	120333986	136281056	173553609	202222047	272672209	371234980\nG	34	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nG	34	26191507	26231992	26440773	26813661	29522114	31656420	31933204	31959611	32083475	32212808	32347871	33684642	35497236	35738803	36991450	37752576	38102879	38980187	39824522	41292875	43935497	47559463	49703920	52681150	54546341	56995539	67022123	72866844	78837484	88532922	97695522	112716102	125576614	142459938	181377246	211244314	284178624	384915627\nG	35	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nG	35	26461071	26502884	26751006	27175453	29762758	31804106	31938916	31968189	32103962	32247106	32403634	33835662	35557512	35738684	36904474	37658366	38031540	38970474	39837900	41307860	43892494	47477274	49617670	52469458	54426305	56809436	66852144	72619679	78465955	88380329	97137605	112918388	124956911	141799124	180134986	209629549	280287905	374463325\nG	36	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nG	36	26804845	26850746	27134451	27598558	30117921	32190478	32261210	32293829	32457078	32613075	32789342	34331850	35852632	36024008	37178664	37936514	38329644	39363751	40304967	41777291	44404996	47838749	50113546	53013175	55025835	57468543	67467812	73428595	79388262	89833144	98312689	114601645	126357591	143705113	182330613	211728970	282503168	374760793\nG	37	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nG	37	26853892	26905016	27216932	27735658	30203464	32340758	32368367	32405311	32573608	32751890	32945248	34551144	35959831	36126202	37299050	38064237	38475473	39521857	40478775	42010310	44738422	47995123	50320069	53187785	55358545	57846534	67807187	73713934	79620461	90544958	99001090	116003024	127448543	144578503	183313872	212588345	282205238	371153123\nG	38	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nG	38	26802935	26856342	27161651	27690476	29982723	31998289	32017614	32054331	32226061	32417227	32623743	34253701	35482398	35654399	36766829	37542031	37960398	38963159	39931291	41553094	44266727	47319705	49606857	52422331	54627510	57138295	66792160	72647863	78522779	89635974	97722710	115094252	126027488	143060227	180306534	210573087	279454635	366394559\nG	39	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nG	39	27760117	27821721	28173040	28766477	30989745	33096363	33112341	33153365	33350043	33554313	33790140	35489047	36572753	36760504	37888071	38714232	39183600	40210540	41210117	42857421	45728235	48634324	51053023	53926445	56266234	58882030	68598338	74623615	80658801	92455595	100557631	118724753	129689994	147252116	185362378	216247314	286145339	372140780\nG	40	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nG	40	29017864	29078460	29441591	30102928	32252606	34372490	34389111	34434399	34635914	34865183	35129704	36914813	37929153	38136600	39284698	40148369	40632385	41718381	42830415	44538365	47577602	50427658	52963786	55982028	58488055	61282426	71265147	77605737	83925618	96562616	104969572	124086122	135648630	154127996	194019490	225917378	298830028	386163175\nG	41	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nG	41	29288838	29354100	29764594	30543691	32638828	34619562	34639555	34690873	34932465	35211432	35519274	37348986	38164642	38413624	39588463	40388324	40939582	42102025	43249993	45112938	48123485	50692697	53439011	56384045	59139789	61932022	71485965	77961149	84365780	97193175	105379522	124490650	135633455	153859273	192385980	223514911	291599211	370834502\nG	42	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nG	42	29316331	29380228	29834976	30672816	32668347	34587428	34608591	34663494	34911268	35204182	35539704	37344467	38039273	38308940	39469921	40281055	40825239	41972692	43157957	45088877	48148380	50442802	53241966	56193461	59020804	61856268	71017915	77519273	83911898	97134245	105164561	124416281	135506824	153654258	191643023	222625289	290377711	369000365\nG	43	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nG	43	30331173	30403990	30914850	31821287	33752625	35654669	35677254	35740812	36026663	36355528	36738707	38586816	39210876	39494481	40712860	41550117	42179825	43365438	44640668	46710136	49914153	52074819	55122246	58155864	61223491	64197947	73399789	80225752	86931697	100883855	109203706	129021699	140658608	159575036	198450402	230190448	299005480	379037362\nG	44	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nG	44	30449129	30528927	31065180	32045012	33895902	35758385	35782752	35850047	36151680	36509733	36929323	38664861	39163924	39480075	40592639	41435496	42327979	43330423	44599220	46833403	50062603	52086213	55189463	58209841	61427469	64444617	73178764	80055394	86747454	100778153	109130820	128904775	140551049	159173151	196941853	227589411	294260931	368631578\nG	45	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nG	45	31395551	31479201	32057337	33096347	34866283	36640830	36666723	36749032	37083285	37492812	37944058	39692896	40156997	40493665	41641931	42456719	43420328	44457384	45872232	48204390	51497605	53457366	56753843	59828641	63304912	66391429	75172296	82246782	89122308	103707475	112356122	132750605	144689771	164087762	201727288	233569388	300070302	374490635\nG	46	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nG	46	31676105	31756812	32348161	33425913	35089427	36731715	36761075	36847541	37200352	37638499	38122705	39773984	40198345	40558047	41655629	42436108	43448273	44486218	45926690	48354542	51615267	53334724	56690702	59732261	63412151	66476523	74937406	82049704	88973088	103697001	112514112	133243917	145264236	164966457	201381322	233740510	298509781	372211494\nG	47	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nG	47	31979765	32062992	32705696	33865761	35512846	37043107	37073835	37165770	37536181	38018874	38536476	40065903	40470765	40891704	41991669	42780562	43838899	44880205	46389550	48980530	52178162	53751198	57301076	60328441	64304916	67468317	75536157	82794194	89907418	104751177	114166276	135294613	147687970	167527389	203838233	235979342	299693734	370951104\nG	48	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nG	48	33280826	33370785	34034580	35246907	36851231	38240602	38273759	38377051	38781105	39305166	39859268	41255632	41650780	42062966	43176124	43945953	45101739	46164488	47739719	50217205	53460195	54785841	58504778	61747819	65981295	69279261	76999671	84547615	92010128	106913947	116824768	138061072	151012217	171076610	204128426	239272253	302548652	373793623\nG	49	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nG	49	33447968	33535557	34210410	35434398	36895648	38237778	38271188	38370873	38772837	39332038	39893216	41186844	41540741	41945863	43043528	43845354	45010644	46035878	47626766	50145115	53399481	54557647	58308938	61554502	65898598	69259725	76804419	84493036	91988192	106937901	117262105	138742009	152238007	173149959	206001715	241292588	303172891	372705815\nG	50	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nG	50	33757339	33847046	34512420	35743617	37186377	38394698	38426874	38529348	38925501	39498605	40082205	41177625	41547176	41948585	43040045	43841713	45061163	46043209	47661131	50218202	53346848	54384793	58199760	61424313	65981775	69373626	76472326	84203157	91676056	106558613	117267769	138893503	152620049	173492582	205695380	240821198	302527253	371055574\nG	51	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nG	51	35082533	35184766	35891107	37166086	38638226	39749867	39784908	39897495	40326395	40960159	41567663	42570961	42920589	43351775	44491138	45306040	46654994	47659117	49365594	52098435	55176303	56195687	60292938	63588970	68573032	72144474	79028262	87343420	95233857	110541571	122238558	144809680	159258913	180901507	213388332	248597222	309791110	376757954\nG	52	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nG	52	36118680	36229891	36975193	38301847	39805608	40853851	40890876	41003401	41443141	42107654	42743957	43651340	44001092	44457604	45635856	46480658	47871438	48909023	50652478	53441980	56508887	57491902	61779152	65111543	70347541	74084789	80911431	89456625	97656620	113157358	125659480	148779640	164056171	186226343	218871395	255090887	315826679	380257798\nG	53	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nG	53	37116666	37240124	38097997	39666656	41382238	42417403	42460541	42594381	43080390	43836513	44533522	45347211	45763202	46265565	47606551	48515801	50093629	51194761	53152507	56136019	59259728	60179339	64929627	68389460	74139182	78180563	84777871	93993298	102620357	118160990	131819013	155091674	170901108	193487118	226135136	262017998	320158721	380418340\nG	54	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nG	54	38014796	38142308	39051855	40753596	42578852	43482953	43535015	43690578	44173553	45030294	45785521	46521296	46921096	47484105	48846137	49740309	51326625	52511983	54588640	57691931	59913988	61698818	66718500	70080107	76293868	80435634	87047602	96560157	105459788	121072413	135649897	159663337	176221541	198424034	231102209	267113511	324022681	382217430\nG	55	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nG	55	38845871	38985804	39950894	41738088	43624725	44414303	44471799	44647044	45163840	46110365	46872207	47541375	47943346	48520870	49953410	50832560	52532927	53757206	55940087	59115421	61257599	63031446	68362458	71696620	78174903	82588008	89038906	99094933	108290623	123954242	139552822	164177202	181503635	203721100	235745592	271382247	325550330	379979373\nG	56	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nG	56	39425439	39573831	40494850	42144892	43987250	44647446	44711165	44897169	45418010	46387241	47127865	47735563	48114751	48653925	50089599	50949268	52730806	53953573	56213532	59397426	61450921	63241047	68665743	71994429	78755548	83219811	89661995	100088646	109432570	125204967	141575006	167181751	184949508	207752789	239759403	276204218	329975643	382518692\nG	57	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nG	57	40665437	40820693	41814279	43495501	45431604	46014668	46078653	46284918	46827633	47822560	48585633	49137809	49513051	50087109	51610962	52489151	54441130	55714963	58024072	61322544	63345665	65193711	70966714	74404868	81439443	86216132	92675274	103510353	113487868	129749119	147271757	173859988	193061510	215965733	247470446	284880154	336413838	385811895\nG	58	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nG	58	40522773	40688794	41652454	43369362	45394123	45801523	45867518	46075739	46586397	47604890	48265099	48723064	49094529	49655354	51249108	52056461	53844747	54998807	57667500	60437558	62085100	63749565	70320589	73519600	80700418	85504364	91626557	102686094	112636701	128431325	146451224	173681808	192970482	215643449	245565258	281840676	330293028	376502906\nG	59	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nG	59	41915172	42094980	43063938	44736332	46759919	47092148	47163215	47396784	47903011	48954505	49604510	50051470	50394871	50941539	52590264	53393646	55256674	56438836	59196914	61961855	63631434	65362631	72142284	75368243	82732706	87847367	94183074	105582171	115968063	132227306	151380066	180104570	200618819	223657601	252655418	289188799	335493151	378851484\nG	60	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nG	60	42046904	42221961	43098887	44664982	46454508	46671510	46745846	46982634	47460695	48420246	49029373	49410752	49761395	50319698	51948204	52688502	54635489	55807674	58548176	61182952	62744900	64479699	71496954	74692002	82044418	87232773	93837872	105399094	116090835	132592134	152417110	182573308	203839559	226750858	254319603	291560369	334375830	373358127\nG	61	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nG	61	43523058	43711363	44596903	46188123	48139713	48336416	48411206	48650572	49100314	50085658	50697653	51082733	51428803	51987485	53706990	54489465	56432128	57612323	60521244	63197492	64760157	66601584	73710275	77061349	84676065	90234635	97148140	109054204	120154812	137285902	158206781	189526453	212133610	235910832	263955468	302650139	345887603	385347645\nG	62	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nG	62	44238351	44431659	45312617	46963505	48893564	49023468	49102782	49372465	49820169	50803512	51383668	51746149	52100102	52680836	54495804	55227797	57251308	58445715	61491429	63992144	65561827	67430755	75042806	78269196	85796679	91616660	98945049	111389910	122861678	140042463	162034030	195215488	218586098	242086026	268444973	305864138	344909264	379010074\nG	63	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nG	63	44201047	44410339	45293909	47002895	48876133	48973012	49063383	49350601	49809647	50766524	51357892	51747029	52108759	52687363	54599775	55281234	57438014	58686257	61751322	64208140	65781336	67795333	75611838	78930656	86228629	92303209	99916806	112429553	124116046	141663521	164289582	198971880	222686509	246772894	270913456	308321903	342665260	372127805\nG	64	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nG	64	47126904	47352997	48260123	50076504	52147507	52202704	52295596	52602906	53052029	54078039	54651888	55006248	55415063	56034450	57887630	58763341	60984552	62283873	65192101	68095392	69722562	71835511	80024386	82729406	90533653	97939152	106185372	119503472	132024641	150509230	175257096	212559274	238141236	264036986	288968589	328448659	362834516	391430239\nG	65	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nG	65	47782780	48021731	48912758	50866863	52852140	52886782	52995841	53352272	53799297	54811034	55364415	55730362	56205355	56853869	58823581	59615640	62079928	63369339	66334814	69195101	70928639	73095699	81649919	84447314	92135516	99778592	108767675	122314246	135052923	154031266	179448447	218832676	244509498	270837007	293537800	331055582	361625057	386972916\nG	66	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nG	66	49024132	49307185	50371521	52667040	54899521	54922259	55049766	55437401	55894568	56945796	57572987	57973705	58424946	59214563	61416800	62253344	64783686	66224298	69259658	72240390	74156360	76502443	85494536	88454226	96114531	104354066	113781233	127824395	140869590	160975818	187733489	229351042	255331658	281883321	303086696	337215490	365522819	388194387\nG	67	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nG	67	49779983	50107037	51221729	53672108	56024221	56037415	56178979	56644282	57134360	58314084	58921483	59355546	59799354	60569754	62845634	63685679	66423108	67952933	71191717	74165724	76084094	78518326	87962489	90906415	98677118	107261346	117228534	131749327	145073054	165604043	193179906	236187254	262633911	288783414	308329702	341477322	366615791	386503382\nG	68	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nG	68	50821731	51174869	52298592	54753312	56956071	56965756	57125179	57671585	58155915	59305263	59934924	60394790	60845676	61603654	63896457	64743649	67647392	69159809	72332117	75442441	77525601	79994376	89662271	92766883	100348590	109288583	119913096	134373587	147663754	169378862	197293859	241888348	268275953	295220454	312936498	344093435	366929453	384973283\nG	69	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nG	69	50615760	50981017	52064935	54606759	56770742	56774836	56953837	57506641	58007208	59179779	59778094	60268343	60723385	61520283	63903064	64732611	67710870	69261797	72018549	74492773	77582609	80201820	90287628	93277974	100649544	109884617	120830589	135641758	149326345	171084928	200154375	246156658	272482187	297609746	313620984	343202281	362923327	378069445\nG	70	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nG	70	52775243	53180538	54273864	57078364	59303189	59305864	59500322	60099065	60584734	61736418	62301861	62833045	63311199	64164935	66722307	67524629	70650347	72225809	74985011	77468209	80831264	83575809	93928193	97124381	104585238	114494267	126383476	141388495	155952126	178783098	209842913	258497616	285790022	311036549	325818673	355852343	373283837	386413109\nG	71	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nG	71	52925702	53363223	54485795	57408926	59498910	59500390	59714315	60390135	60911505	62063544	62658788	63248512	63751265	64623776	67274478	68039347	71469511	73086557	75792994	78307886	81844497	84737398	95530131	98808451	106069577	116378882	128587269	143666003	158580044	182051549	214046443	264079355	290813197	315094500	327663818	355968554	369588305	379741858\nG	72	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nG	72	54721461	55172543	56210322	59129135	61036520	61037856	61269810	61932240	62443108	63529999	64081133	64700353	65162572	66062156	68814588	69561723	73082943	74728158	77342447	79892570	83637066	86749627	97870926	101340676	108377689	119339252	132041330	147870958	163368605	187736422	222092878	274385178	301787427	324979633	336373478	363271426	375546440	384668170\nG	73	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nG	73	55074049	55585425	56641352	59888949	61760584	61761467	62019184	62720157	63234721	64255121	64821887	65514087	66009888	66984467	69880266	70616760	74355473	76033941	78510186	81151684	85077992	88302664	99745970	103381162	110114759	121683024	134874233	150863490	166625327	191597830	227329669	281206444	307878040	330987926	340616716	364744702	374539135	381714491\nG	74	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nG	74	55442849	55978745	56973010	59997301	61634289	61634941	61892160	62583694	63075275	63994503	64491457	65207090	65661276	66597082	69324393	69998939	73789570	75362004	77628965	80204555	84217860	87393112	97031418	102269312	108646275	120239332	133666647	149687847	165441970	191560359	227767527	283742038	309273309	331404357	339791482	361804429	370139563	376069540\nG	75	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nG	75	56278294	56664412	57327417	59804618	61217912	61219799	61686321	62849458	63400135	64750149	65100517	66330461	66661424	67987733	70989881	71943793	78722596	81172570	84321601	88564572	95188220	99601334	116062575	123739551	134517566	151865779	173650046	196856425	220448109	247638630	289053864	320665272	343297815	354127013	359709767	375475581	378863486	380028069\nG	76	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nG	76	58258993	58653037	59283157	61651628	62815995	62816695	63105609	63813311	64235993	65050409	65416410	66220604	66575006	67521525	70032554	70751741	75395033	76912424	79068295	82190799	87235064	90772375	102617927	109411576	116992540	132022643	150479752	171756618	194148367	227198839	275306040	318186166	344152910	358110352	363944192	383326150	387334769	388273733\nG	77	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nG	77	57508546	57911040	58478304	60819106	61846062	61846485	62096685	62646706	63034001	63659247	64004009	64711021	65077610	65985216	68400291	69022747	72845160	74147702	75903095	78631467	82806672	86149093	95493847	101472157	107312902	120172617	135452035	153464943	171643902	203483416	247894433	305240211	330802719	348838749	354170528	373468694	378341884	380120991\nG	78	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nG	78	58796318	59267862	59922757	62831774	63988339	63988749	64245961	64806402	65212700	65770062	66153074	66847125	67266130	68237812	70931970	71544150	75294541	76500159	78146184	80740360	84843481	88360306	97194559	103014276	108285904	120636402	135188856	152055237	168856224	200197621	242756213	311262369	335278813	355660951	360268725	377043362	381063692	383252682\nG	79	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nG	79	61256808	61756063	62371598	65267698	66356148	66356582	66648522	67271572	67720812	68323371	68679147	69434310	69861608	70837393	73571892	74191523	78180427	79399702	81050472	83805985	88006430	91729494	100574627	106618354	111585183	124265574	138768809	156069741	172521251	204051072	247518221	322390124	345783883	367883744	372094663	387069491	390538608	392799939\nG	80	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nG	80	60733431	61206747	61751919	64484431	65361666	65362068	65653473	66218476	66634066	67125631	67459016	68181095	68569110	69541552	72179850	72793358	76585423	77722273	79084122	81848349	85960600	89763973	98024692	104093752	108599438	120867377	135023695	151817825	167888863	198920763	242442127	319970834	341918471	363127064	366405344	378988976	381402464	383144061\nG	81	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nG	81	60936524	61408609	61907969	64549524	65271408	65271854	65575064	66134646	66554391	66955332	67266531	68030668	68423975	69381438	71988247	72611204	76518869	77554891	78711347	81537503	85721174	89726943	97504160	103721143	107907558	120364909	134299295	151188279	167262888	198234834	242851480	322375344	342950447	360340226	362651456	372224782	373784878	374903524\nG	82	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nG	82	63645267	64146657	64620327	67313553	67943127	67943584	68246748	68786813	69220251	69546646	69854105	70647406	71052568	72013549	74643381	75264218	79348711	80303802	81320694	84201969	88596080	92801493	100346689	107002969	110925623	123769159	138118680	155558067	171982328	204553577	251076231	334659904	353765095	369870395	371586915	379701104	380583051	381250328\nG	83	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nG	83	63859980	64390650	64860677	67702966	68326281	68326743	68665638	69226684	69661449	69984081	70286405	71110677	71554086	72579120	75316448	75985341	80093683	81023632	82055046	85160779	89701970	94071907	101410917	108373658	112238517	124967710	139909890	157093958	173351106	206005642	251764521	333722877	351920901	367445761	368848302	376416550	376876076	377206573\nG	84	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nG	84	66501333	67042189	67486521	70377304	70937669	70938113	71290295	71843696	72280291	72566962	72859497	73698825	74130814	75179563	77931617	78638395	82851961	83768716	84680593	87821196	92543798	97255272	104353175	111701719	115327499	128538001	143649812	161557050	178393506	212051351	260038938	343902999	361345422	375230048	376303309	382287829	382569925	382777910\nG	85	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nG	85	68782721	69340149	69770947	72771499	73310122	73310637	73705399	74265135	74720345	74992401	75275341	76176525	76623179	77754855	80656325	81430372	85782832	86656813	87560206	90931225	95846799	100961699	107893698	115696333	119102554	132798418	148284724	166749060	184074139	218370178	267454280	352636208	368778381	383385220	384220886	389233049	389413024	389544379\nG	86	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nG	86	69441077	70010845	70410548	73365933	73792039	73792547	74187317	74737836	75175127	75381506	75639424	76521399	76971508	78087935	80840265	81630967	85947606	86716902	87432722	90774958	95607717	100868783	107164456	114996034	118220350	131584105	146942555	164980942	182091859	216135691	265133347	348800097	363078906	373140113	373615391	376236144	376347515	376428658\nG	87	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nG	87	73141760	73745529	74155928	77263942	77688556	77689299	78137915	78733264	79200758	79394619	79667765	80687471	81187901	82372672	85295506	86172689	90849299	91598595	92337490	96027519	101297491	106944895	113088986	121766249	124786875	138869379	154964281	173984454	191493683	226709131	277661828	363413615	376762926	386653923	387022444	388944467	389012621	389061463\nG	88	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nG	88	74753979	75363624	75722028	78839392	79210467	79211021	79669459	80192753	80651158	80821274	81073450	82052983	82519656	83736611	86681666	87650004	92085512	92806450	93461114	97116479	102404007	108253128	114031088	122739230	125508502	139687503	155417377	174550125	192398213	227116708	278607987	362420456	374967001	383635017	383877439	385113651	385160468	385193909\nG	89	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nG	89	75554608	76173692	76493353	79552716	79890821	79891456	80369530	80879981	81359076	81506050	81725593	82763226	83213907	84408755	87381876	88362034	92899841	93555601	94141136	97716245	103105475	109152219	114527640	123358159	125880309	140163099	155368267	174544867	192413325	226209135	277977728	359646858	371467826	377611172	377751132	378489950	378515989	378533428\nG	90	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nG	90	81820635	82457270	82772971	85966924	86251473	86252058	86764088	87273270	87746729	87868287	88104165	89159923	89638566	90910839	94092290	95171468	99741273	100398243	100952839	104768194	110636011	117065265	122196175	131818620	134445026	149332436	165845085	185661768	204973357	239904614	295136463	378638720	389796256	394228310	394303207	394687056	394699745	394707652\nG	91	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nG	91	81821709	82465674	82737318	85920104	86199710	86200332	86742038	87197614	87696517	87788411	87990011	89126992	89601734	90933408	94099369	95231023	99801687	100317962	100837266	104827020	110604017	117118385	121676567	131369738	133744289	148134150	164019659	183419258	201589344	235386407	287453899	366399893	374517637	377353376	377400085	377648191	377654667	377658906\nG	92	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nG	92	86286336	86941844	87194444	90565387	90812463	90813155	91397992	91830316	92330530	92416230	92595281	93718570	94244077	95669596	98867647	100098636	104602841	105112312	105603628	109769553	115437017	122333344	126644148	136641113	138685958	153481892	169479377	189243650	208273410	241186303	295116244	371651226	380238684	382327453	382358802	382523628	382525962	382527252\nG	93	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nG	93	89335319	89959675	90170692	93379444	93618124	93618972	94226503	94651765	95144260	95212886	95369986	96558105	97076864	98463800	101740263	103071912	107655523	108081182	108553670	112723876	118756172	125846400	129689767	139930236	141945927	156717941	172886133	192472168	211029564	243476981	295955851	369164215	375447590	377018830	377038836	377143172	377144319	377144958\nG	94	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nG	94	95468127	95971113	96128124	98703537	98872972	98873485	99381734	99709248	99773376	100166729	100307186	101384620	101808566	103092981	106105998	107449641	111598883	111977609	112405904	116384440	122134251	129307146	132790820	142904403	144717409	159551308	175585757	195926003	214904931	247598940	301406769	374930564	381088030	382024852	382036057	382097004	382097517	382097798\nG	95	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nG	95	100306062	100712353	100832342	103096922	103223559	103223972	103674900	103953685	104008572	104351892	104469148	105450876	105859994	107101373	110085057	111406714	115303468	115614191	116010424	119956237	125758016	132881491	136034039	146321934	147949061	162624188	179321539	199440849	218759636	250912594	305907050	378417942	383880956	384472608	384481121	384527169	384527662	384527911\nG	96	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nG	96	107674226	107921756	107986365	109555644	109627962	109628169	109949933	110117781	110153551	110389080	110465771	111288320	111659491	112745784	115413826	116586580	119861990	120067125	120450803	124140113	129501639	136258010	138761099	148770017	150156002	164245372	181005928	201256348	220682213	253332425	308704250	382068361	385734687	386113026	386117277	386138905	386139191	386139377\nG	97	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nG	97	116837221	116945329	116972195	117845541	117877793	117877885	118075774	118166673	118185753	118326995	118371102	119083215	119446269	120420981	122842992	123980445	126840938	126996707	127381257	130896044	135838387	142545883	144764847	154568792	155879289	169709105	186547802	207448283	227170187	260513108	315904023	388836811	391890608	392173019	392174954	392185393	392185729	392185930\nG	98	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nG	98	125968388	125980897	125984067	126134156	126138865	126138880	126176379	126191392	126194188	126230672	126243484	126855469	127169404	127912493	129996410	130854981	133174809	133298961	133631531	136681194	141177458	146834098	148535578	157577509	158660153	171125874	187927049	208199336	227634865	260352721	315311635	386064188	388713090	388911312	388912367	388918559	388918663	388918709\nG	99	2	7	8	10	11	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nG	99	136021299	136021300	136021313	136021315	136021316	136023083	136023728	136727002	137092385	137878717	140193280	141144254	143586104	143687626	144027316	146999143	151419994	157123283	158674895	167226947	168178589	180261862	196911444	217636821	237230553	267726919	321909576	383527876	385619397	385743045	385743539	385746210	385746292	385746324\nC	0	2	7	10	12	15	16	18	19	20	22	23	24	25	26	27	28	29	30	31	33	34\nC	0	15851864	17137152	19586680	20357468	21132758	25329180	25860994	25907856	26674220	29063102	32114000	33052946	38345920	54765528	61882982	82649721	85263430	131470028	343833081	383709228	587612129\nC	1	2	7	10	12	15	16	18	19	20	22	23	24	25	26	27	28	29	30	31	33	34\nC	1	8455839	9338202	11895162	12148966	12725393	16557319	17029003	17089426	17820534	19997809	21838284	22549612	24408982	33071382	44330589	52971897	53870900	72879348	171784641	177035248	336681351\nC	2	2	7	10	12	15	16	18	19	20	22	23	24	25	26	27	28	29	30	31	33	34\nC	2	8995019	9840655	13961251	14191844	14632133	19620609	20057494	20081323	20792052	23334504	25439800	26145248	29081006	38069040	50668944	60699906	61700009	81761140	180491253	184928122	367443285\nC	3	2	7	10	12	16	17	18	19	20	22	23	24	25	26	27	28	29	30	31	32	33	35	37\nC	3	8483491	9040894	11657256	11817574	13498984	14436085	14752422	17129432	17688954	19064620	19544798	20107353	21773616	25010639	27358481	33040410	33419016	40939432	43108233	56018922	66214815	129742079	321827384\nC	4	2	7	10	12	16	17	18	19	20	22	23	24	25	26	27	28	29	30	31	32	33	35	37\nC	4	8969685	9999685	12406588	12609913	14579458	15472332	15832146	17361628	17912443	19433185	19800358	20228750	21919770	25149725	27189171	31749819	31991270	38665591	39714137	50604032	60672209	119287872	290565548\nC	5	2	7	8	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	35	36	37\nC	5	10944409	11437090	12582441	14545795	14826662	14915003	15124914	15169122	15628651	16227412	18356099	19239771	19842171	20008948	20322116	21210645	22643898	22927699	25093181	27692126	29878398	32944495	34952938	41859058	44729655	57423491	66715866	133895415	137968272	333056441\nC	6	2	6	7	8	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	6	12685517	12686618	13061980	14059866	16188585	16472719	16544774	16776089	16801719	17163140	17636795	19633510	20545744	21153060	21276518	21549970	22500909	23782162	24058094	26298467	29069823	31344043	34324895	36391401	43553663	46203607	58771633	68788829	68791300	139807057	144644781	353167599\nC	7	2	5	6	7	8	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37\nC	7	16056142	16057206	16057985	16436604	17532414	19938344	20441483	20509427	20746775	20768159	21127297	21672280	23792822	24822398	25669338	25793000	26087241	27163400	28656399	28979442	31516902	34941085	37658889	40801937	43470880	52194992	55443813	70854681	82878901	82881553	170544705	176769296	429854539\nC	8	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39\nC	8	15617213	15618477	15619558	15945876	16954016	16954075	19452355	19962374	20020778	20248181	20265402	20584510	21104279	23274890	24271264	25127934	25238157	25505663	26552571	27973403	28258266	30773047	32331371	36983623	39770771	42316559	50760450	53203707	63827385	73849745	79703551	109000817	109030286	153773963	181127855	402956413\nC	9	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39\nC	9	11352955	11354161	11355106	11586189	12339774	12340648	14309336	14794443	14830914	14996569	15007499	15226224	15587305	17269796	18053087	18748974	18820751	19007239	19790679	20864958	21054179	22988559	24094834	27862449	29534953	31441999	37642137	39021284	46461868	53987029	57739321	78326251	78343079	109032427	127947318	278987026\nC	10	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39\nC	10	16903865	16905757	16907272	17182759	18182524	18188407	20914615	21420407	21469907	21671215	21687452	22040169	22531957	24771705	25834737	26681444	26773843	27044223	28060093	29539626	29791536	32463589	33999811	39677571	41525270	44151155	52945133	55259737	66297185	76647586	82551070	112803461	112824776	158519699	188522889	409207725\nC	11	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39\nC	11	17466276	17468032	17469369	17733820	18631454	18639575	21424594	21813526	21858085	22046442	22061399	22376885	22866225	25072994	26253593	26990107	27082479	27346094	28378832	29839087	30085087	32657951	34294016	40246885	41796462	44407394	53126717	55287796	66361486	76685872	82583731	112776979	112790583	158312173	189241105	406102935\nC	12	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39\nC	12	14963101	14964690	14966757	15217496	16047978	16059044	18488679	18822165	18864492	19018050	19033630	19368592	19843687	21755382	22771923	23386370	23469996	23721364	24640130	25966009	26176564	28471909	29944727	35127850	36414650	38604449	46191007	47949700	57611697	66317572	71215115	97091987	97105078	136238393	163113285	343132941\nC	13	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nC	13	15709172	15710855	15714099	15941837	16762234	16777702	19231744	19615902	19656180	19802612	19817553	19912537	20540431	22538861	23554155	24234637	24314053	24563348	25489496	26067630	27050844	29409153	30885305	36172555	37465341	39705719	44070223	49047336	56518500	65944731	71627034	76545616	93513520	104807977	138831960	157771667	227108454	350890699\nC	14	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nC	14	15934222	15936213	15941074	16177877	17003737	17030831	19551290	19985749	20025060	20164465	20180205	20284219	20954325	22965589	24019404	24716929	24797481	25050234	25977406	26572298	27604207	30019795	31560878	36893506	38212841	40459090	44896868	49908383	57437716	67089996	72798305	77885130	95039182	106536816	141370975	160543245	230870368	351106019\nC	15	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nC	15	16569528	16571545	16577491	16813894	17671144	17711162	20359182	20786192	20828637	20961887	20978665	21099249	21826217	23901555	24992832	25699489	25781720	26043660	26993659	27611747	28683019	31210599	32872451	38314262	39659659	41960110	46569073	51718835	59497303	69481773	75405009	80724422	98410511	110305605	146655367	166627721	238630295	356575921\nC	16	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nC	16	17158079	17160665	17167944	17383852	18252399	18303802	20991762	21434709	21474192	21609876	21627852	21757799	22469401	24606618	25685304	26439504	26521948	26790534	27717181	28362325	29473521	32011419	33606009	39188829	40503760	42829912	47568616	52743349	60640166	70653305	76815932	82244550	100103344	112345008	149014663	170030519	242161299	359525892\nC	17	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nC	17	17207286	17209451	17217043	17417963	18251022	18321642	20931855	21344271	21379068	21510610	21527088	21664014	22328154	24398432	25494497	26212795	26290972	26550860	27459049	28065270	29188089	31662493	33223027	38671509	39953038	42234145	46943607	51965786	59747001	69559256	75662496	81071165	98584093	110685632	146685167	167847905	238134915	357644078\nC	18	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nC	18	17475781	17478192	17488396	17689816	18546492	18635693	21158256	21568642	21607162	21732427	21750643	21907571	22542321	22813439	25729840	26436488	26524201	26796689	27690898	28352924	29499486	31923548	33558180	38925162	40254797	42494561	47311657	52343687	60030644	66375573	76081813	81728469	96527915	110097991	142124541	166838928	238095342	358109516\nC	19	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nC	19	18191674	18194276	18205786	18402091	19267305	19394322	22026380	22439913	22476974	22600028	22619093	22793227	23449170	23797837	26694646	27467284	27554079	27836949	28731583	29398776	30673690	33150494	34822946	40301457	41634418	43944106	48959960	54106063	61938668	68497244	78409551	84247688	99324238	113133163	145471622	171261533	242757364	364416366\nC	20	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nC	20	18149677	18152221	18171287	18370014	19289474	19457563	22016779	22414987	22455372	22575306	22598886	22813894	23519658	23937981	26714177	27462792	27559057	27879833	28745859	29497008	30823895	33289061	34965512	40354563	41687800	43969842	49067363	54216514	61974213	68550403	78379121	84421876	99433042	113420171	145976374	171923635	243111122	362571982\nC	21	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nC	21	18388538	18391406	18409279	18601264	19509803	19717209	22187329	22534690	22574380	22689500	22714015	22946025	23697299	24234647	26788698	27515889	27622872	27942881	28794494	29571888	30976306	33334847	35005892	40224836	41543588	43789035	48962585	53999280	61623103	68156644	77865144	84003084	98784246	112499805	144519159	170877377	240908679	360283525\nC	22	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nC	22	18202953	18206120	18226325	18409301	19336266	19601643	21962609	22278271	22316022	22431232	22458474	22706171	23487052	24109346	26478892	27190298	27298128	27619481	28440954	29233332	30741931	33017957	34655588	39688546	40998875	43203496	48442299	53382035	60776751	67220579	76766724	82947438	97445631	111118631	142713315	169052725	237648539	355951945\nC	23	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nC	23	18685831	18689341	18718308	18905577	19867024	20186751	22405513	22678398	22718932	22830094	22867393	23144996	23990831	24703107	26812769	27525690	27649244	28008677	28822432	29693704	31314787	33499115	35160326	40029038	41370859	43608737	49017413	53970740	61257998	67843722	77332014	83806823	98366927	112044532	143899580	169865978	235957292	357729941\nC	24	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nC	24	19327895	19331818	19363702	19550399	20550956	20964156	23090028	23337865	23380167	23492950	23532162	23823988	24734496	25566545	27457689	28200040	28336491	28707748	29524374	30416844	32279088	34361997	36053240	40812298	42190164	44494433	50151780	55166489	62379323	69166681	78796830	85566367	100338123	114210550	146793463	172996944	241025460	361883475\nC	25	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nC	25	19773638	19779237	19821156	19980295	21093137	21675667	23985873	24272974	24318430	24432212	24475379	24802917	25803057	26697307	28450298	29246234	29400497	29794139	30609130	31590007	33643239	35719678	37471581	42129464	43577316	45965273	51907506	56998249	64147564	71140243	80741561	87929410	102832900	116569597	149391833	174824831	243173774	362283140\nC	26	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nC	26	19994164	19999701	20043327	20206715	21447574	22202693	24420160	24583312	24629761	24737909	24781933	25163639	26345440	27344817	28986819	29748523	29922889	30323783	31132721	32167005	34370417	36514151	38285738	42896191	44389682	46802916	53112115	58239537	65373625	72595111	82353928	90086167	105131481	119121076	152595696	178276785	248065891	365155262\nC	27	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nC	27	20411057	20417326	20468286	20636391	21982752	22929950	24793868	24914330	24964708	25066260	25118849	25552416	26885664	27875573	29284487	30052136	30243662	30675776	31459791	32532730	34899882	37106611	38901400	43194236	44713006	47111009	53816183	58898048	65728463	73127309	82731734	90999302	105833344	119776858	153257434	178535102	248557412	361139553\nC	28	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nC	28	20658146	20665936	20718269	20901689	22352567	23483449	25104061	25179087	25230711	25333430	25392026	25889501	27371456	28285607	29573808	30318558	30531768	30987642	31757475	32837748	35312898	37658986	39466707	43478589	45031967	47453968	54593882	59675913	66189830	73737997	83312275	91991204	106918292	120876250	154895097	180129969	250868222	360048150\nC	29	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nC	29	21039165	21046939	21108266	21293565	22819250	24190678	25559139	25613284	25665392	25770578	25835296	26369035	27919609	28723909	29949511	30760862	30985635	31430753	32192246	33286896	35894915	38341329	40167755	44040654	45627717	48106178	55606803	60718735	67072129	74927559	84563595	93876920	108899571	122955638	157838665	183326578	255426004	364961229\nC	30	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nC	30	21348307	21359048	21429268	21640474	23356149	24946005	26039160	26071061	26135065	26244026	26318947	26957469	28645944	29328454	30563388	31345596	31592666	32091258	32848324	33990525	36725696	39372346	41282475	44909824	46546366	49078163	57048892	62244896	68318460	76530803	86118034	96295608	111190346	125441778	161251587	186370844	258655003	365111817\nC	31	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nC	31	21298203	21308886	21384270	21605456	23327464	25143890	25982771	26007445	26070815	26185475	26269657	26976940	28692184	29234174	30439315	31234371	31480205	31996055	32752103	33870805	36631752	39390502	41236910	44702561	46347001	48890426	57052335	62230107	68018960	76315107	85728961	96456730	110918827	124954068	160639934	184878854	256000341	358780792\nC	32	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nC	32	21982241	21993308	22077124	22324677	24170198	26122494	26722916	26738174	26807104	26936226	27028495	27846824	29659489	30094934	31316048	32091075	32358046	32924297	33697617	34879161	37694238	40660196	42609287	45899334	47661160	50262544	58881645	64148072	69850037	78528591	88028497	99706067	114034792	128559255	165407003	190323466	262924401	364650846\nC	33	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nC	33	22651321	22664529	22765097	23056503	24952196	27126575	27528043	27545529	27621341	27760716	27878882	28833355	30568594	30908260	32126055	32939522	33212916	33853564	34653531	35884934	38798160	41769999	43748168	46958863	48793082	51429389	60326120	65616367	71161920	80291943	89503101	102124814	116031604	130674334	167739583	192157605	263688618	362193958\nC	34	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nC	34	23045925	23062146	23176810	23508733	25493032	27963460	28191800	28212998	28302674	28451954	28591488	29662814	31478108	31721586	32990919	33844467	34148443	34818518	35657121	36921321	39979288	43065268	45178906	48324759	50264467	52995387	62314945	67703836	73181307	82851483	92222275	106113177	119551361	134777180	172920586	197195837	269468846	365068922\nC	35	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nC	35	23459627	23474659	23598183	23944949	25888249	28262529	28382194	28405013	28499911	28658909	28806263	29963624	31714708	31918383	33157190	33963825	34277172	34966764	35832121	37098986	40140311	43253300	45419095	48474865	50499702	53235243	62721087	68083596	73530070	83499203	92793745	107251551	120368215	135619013	174230817	198565483	271111482	366416895\nC	36	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nC	36	24198116	24216399	24357896	24747602	26677547	29201251	29263460	29289007	29393888	29573259	29749030	30987536	32638389	32826285	34110814	34960132	35284683	36021301	36895773	38259781	41433827	44520688	46733777	49837151	51987886	54867033	64656963	70206168	75721878	86435654	95870354	111544402	124655444	140632471	180626398	206051702	280461030	375532410\nC	37	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nC	37	24286428	24304591	24461348	24888165	26779244	29241521	29276807	29303106	29416693	29603187	29792803	31169241	32560660	32756494	34004633	34846090	35178130	35951736	36836501	38220922	41396571	44259066	46542561	49584638	51773103	54680516	64174563	69660551	75183819	86126734	95158388	111314334	123802630	139634103	178883344	203745057	276223067	366779954\nC	38	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nC	38	25339204	25360692	25642065	26139960	27970080	30342990	30365616	30395381	30565626	30786455	31028976	32485700	33776259	34021500	35244883	36088785	36495618	37253852	38180698	39770200	42996493	45754654	48224992	51263037	53726992	56652468	66307184	71959041	77665330	89274456	98446477	115433921	127999098	144358151	183567307	210441900	284250590	373835957\nC	39	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nC	39	25470493	25493444	25674709	26228587	27994605	30311303	30329657	30362995	30498086	30736664	30976089	32503750	33570323	33810025	35030955	35856431	36235267	37039174	38002025	39622954	42840978	45402001	47855143	50892242	53422629	56454842	65849615	71608384	77398584	89336267	98448002	116051730	128412836	144961122	184219041	210867716	284303373	372847187\nC	40	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nC	40	26276789	26302858	26501745	27095255	28795297	31138501	31158577	31196616	31347509	31629891	31896223	33488906	34419768	34679880	35925481	36789582	37185961	37978838	39047489	40712818	44141270	46478936	49016616	52115507	54869924	58067031	67519222	73371624	79330378	91869033	101173162	119366612	131894137	148835180	188423620	215416858	288150352	372579590\nC	41	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nC	41	26727753	26758183	26978471	27636121	29387638	31769950	31790617	31830440	32001558	32289319	32583671	34230806	35065375	35364476	36674233	37536757	37971779	38819198	39869772	41652195	45204372	47404046	50113712	53242302	56043786	59321972	68650373	74741320	80798619	93849575	103183114	122107416	134689785	152043016	192402382	219600261	293003861	378013952\nC	42	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nC	42	26781551	26810711	27051153	27769991	29451564	31700482	31722873	31771232	31947255	32284076	32618294	34298119	34991957	35313057	36547886	37413676	37862195	38719986	39819599	41699575	45242749	47288321	49960944	53103968	56096705	59362655	68426561	74572205	80580830	93781701	102941386	121689086	134176855	151556690	191106628	218227742	289245701	369629768\nC	43	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nC	43	27145547	27177475	27432325	28230548	29849671	32017620	32043170	32092099	32285015	32649735	33014700	34655085	35236353	35606526	36836208	37687854	38149793	39017665	40163275	42147618	45743588	47470004	50291890	53356618	56475871	59805048	68565021	74847084	80947024	94320190	103519213	122606074	135106416	152211062	191196400	218158352	287715726	367281484\nC	44	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nC	44	27560079	27595706	27879413	28775213	30427295	32580808	32609132	32663682	32874751	33282017	33674421	35292516	35811419	36210261	37388386	38257180	38908973	39722007	40937312	43086939	46695699	48392117	51400555	54547035	57896096	61286054	70021991	76488278	82803949	96469572	106031103	125474286	138418395	155929749	195348885	222393041	292514148	371078021\nC	45	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nC	45	29167624	29205155	29506210	30495562	32078862	34177794	34209892	34268909	34502275	34978009	35417645	37005982	37472910	37872341	39073067	39923285	40632708	41451910	42788415	45128298	48750821	50314746	53488503	56602247	60310726	63795769	72493922	79324167	85873772	100034335	110072807	130233066	143462392	161916452	201833492	230183008	300838956	380359855\nC	46	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nC	46	29243223	29283545	29603473	30612836	32183738	34188319	34222573	34289712	34535549	35064960	35537446	37031389	37394018	37830059	38981917	39836433	40582290	41368293	42712242	45165707	48727469	50093434	53340072	56339895	60234830	63709585	72000127	78865630	85392296	99458454	109611712	129840641	143097102	161803771	200200630	228230885	296294528	374376412\nC	47	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nC	47	30345275	30388023	30730488	31819314	33379060	35357608	35391711	35458315	35723398	36288291	36799138	38195888	38528364	38971545	40123234	41042989	41822541	42633092	44044379	46578715	50146430	51379836	54690114	57817666	61922822	65514807	73605836	80671404	87451861	101603974	112221478	132534863	146368500	165321668	203661446	232029802	299972073	377229702\nC	48	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nC	48	29817574	29865177	30223553	31336772	32948935	34688139	34726360	34802874	35089942	35734329	36263393	37500370	37812107	38259773	39417828	40265585	41109842	41916295	43416671	45826740	49353309	50333573	53770502	56857065	61244304	64847614	72325094	79489432	86288357	100124740	111034689	131029251	144999877	164027117	197530635	229472655	293662239	366469967\nC	49	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nC	49	30912598	30962290	31334299	32480506	34013399	35646112	35684080	35761579	36057655	36708769	37263783	38427039	38722251	39190739	40315030	41192310	42083810	42906215	44404661	46930147	50423339	51352256	54859052	58037860	62558224	66252945	73719366	81106406	88138817	102404075	113785256	134637705	149003566	168581609	202818718	235097852	301324610	375969511\nC	50	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nC	50	32533906	32590536	32990063	34176165	35789919	37296981	37338013	37434422	37756513	38477026	39031760	40030484	40333374	40792730	42055268	42916823	43906861	44718506	46353500	49031508	52476095	53290170	57108588	60335384	65289517	69322115	76380283	84260970	91776463	106169176	118719985	140084205	155193293	175343194	209546541	242392280	307526392	380137677\nC	51	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nC	51	32351152	32408391	32796929	34054910	35662144	36961567	37002501	37089975	37413067	38147469	38702004	39549824	39854171	40358134	41538970	42394276	43434696	44268815	45895965	48608885	51808652	52554022	56540321	59613291	64782508	68762933	75376045	83401089	90893882	105026161	118131719	139601636	155137844	175554319	209178434	241415720	304642180	374307663\nC	52	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nC	52	32746950	32811594	33232751	34539906	36249674	37507238	37553386	37651549	37991967	38801176	39368883	40152627	40448523	40958369	42198250	43081800	44172442	45043698	46777716	49567754	52789690	53492995	57612390	60751425	66169312	70331360	76828253	85208508	93015251	107216926	121109581	143165815	159214234	179883427	213315896	245455239	307104240	373297894\nC	53	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nC	53	34560620	34629458	35098670	36574266	38585093	39888666	39938538	40044305	40399669	41260877	41881652	42606834	42930527	43512818	44911313	45873294	47054747	47957850	49796966	52820210	56121639	56799448	61351684	64622197	70369329	74834530	81413795	90362293	98566891	113073223	128096023	150997567	167971086	189395746	223356735	255954187	317614805	381823886\nC	54	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nC	54	34308450	34383832	34886849	36511251	38703066	39808577	39868244	39998674	40356942	41392052	42060281	42724567	43069694	43659230	45067251	46006785	47260879	48324876	50345529	53475105	55684556	57260664	62144787	65217340	71588152	76121625	82519521	91834859	100284213	114444034	130456189	153676654	171008728	191694021	225589120	258309350	315922045	375188647\nC	55	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nC	55	34633383	34717543	35221369	36884733	39054239	39981026	40047139	40186576	40567055	41667041	42315904	42881790	43197613	43800921	45268724	46135694	47468149	48505863	50628355	53740474	55780986	57390067	62436296	65421089	71937778	76566219	82683188	92290043	100847798	114672278	131315066	154644639	172295558	193085782	225537813	257240882	311764042	366767890\nC	56	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nC	56	35519241	35604383	36097685	37712874	39898138	40657840	40729508	40884966	41285034	42455376	43097004	43577216	43866528	44452278	45961793	46810483	48243112	49326555	51506442	54640567	56569346	58198032	63451262	66333536	73189269	78042747	84018071	94040304	102949842	116712237	134366160	158180918	176644169	197485738	229490948	261785425	314366761	366426164\nC	57	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nC	57	36530480	36621704	37127254	38824384	41097458	41780578	41854737	42026242	42416158	43573302	44198426	44630928	44948936	45561477	47157524	48005053	49542363	50653282	52967516	56066880	57930105	59645012	65283571	68181845	75185365	80322124	86496512	97014485	106350143	120501323	139349136	164954910	184549934	206608451	238848308	271691634	323905561	374420492\nC	58	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nC	58	36872707	36970790	37559746	39277638	41619734	42151223	42233304	42418727	42829598	44023673	44621706	44996463	45292631	45892642	47551704	48405872	49890341	50984363	53609641	56377808	58001704	59649116	66046139	68901031	75989229	81251401	87298184	98270047	108038380	122214224	141695464	168199933	188276195	210105962	240984725	273749681	322317727	368039173\nC	59	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nC	59	37728537	37825391	38308171	40044572	42441095	42882875	42973181	43159714	43528335	44760630	45292852	45632548	45939790	46538885	48223321	49060576	50511134	51601442	54344291	57019984	58575956	60300221	66659678	69482497	76847880	82371019	88536004	99680613	109726747	123701907	144529514	171930140	193008681	214675786	245525345	278975702	326969484	371476720\nC	60	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nC	60	38229218	38340895	38812883	40461266	42704804	42988537	43076549	43278419	43647740	44830185	45324531	45641874	45928229	46515534	48271390	49029475	50586434	51702548	54543457	57112708	58632814	60410954	67036357	69842973	77405947	83208291	89412260	100933877	111484192	125624840	147741180	176762038	198966273	221299092	251028817	285637302	330297616	370714034\nC	61	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nC	61	38713062	38821323	39277927	40980104	43203146	43419537	43508104	43712455	44042049	45179331	45619133	45903283	46178510	46797292	48561453	49285189	50817625	51949825	54799589	57160674	58597302	60379537	67191490	69924381	77322382	83265326	89722956	101388772	112149407	126464534	149289938	179429674	202559005	225037931	253374971	287098460	328681769	365778780\nC	62	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nC	62	39369670	39487617	39943498	41726022	44062629	44235184	44335666	44573582	44904970	46089695	46511101	46798436	47079955	47727762	49630827	50317472	51936491	53094537	56108457	58432504	59925701	61800487	68919370	71670843	79227752	85455237	92418635	104325523	115450232	130230934	153946812	185967800	209615170	233329381	260595575	295396879	334416254	368876215\nC	63	2	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41\nC	63	40527453	40645970	41108759	42918554	45274543	45391176	4549704