#!/bin/bash
#test examples

# 1) simulation of single-end reads of 35bp with 10X using the built-in combined quality profile

../src/art_illumina -i ./testSeq.fa -o ./single_end_com -l 35 -f 10

# 2) simulation of single-end reads of 35bp with 10X using the built-in seperated quality profiles for A, C, G, and T 

../src/art_illumina -i ./testSeq.fa -o ./single_end_sep -l 35 -f 10 -sp

# 3) simulation of paired-end reads of 50bp with the mean fragment size 500 and standard deviation 10
#    using the built-in combined read quality profiles

../src/art_illumina -i ./testSeq.fa -o ./paired_end_com -l 50 -f 10 -p -m 500 -s 10

# 4) simulation of paired-end reads of 50bp with the mean fragment size 500 and standard deviation 10
#   using the built-in seperated quality profiles for A, C, G, and T 

../src/art_illumina -i ./testSeq.fa -o ./single_end_sep -l 50 -f 10 -p -m 500 -s 10 -sp
