#define MAX_LEN 200
#include <ctype.h>
#include <string.h>
#include <stdio.h>
#include <math.h>
#include <R.h>

int find_se_info(int pos,char cigar[],int rec[]){
        int len=strlen(cigar);
        int i=0,j=1,k=0;

        char *s=(char *)malloc(len*sizeof(char));
        int temp_old,temp_new=pos-1;

	rec[0]=pos;
        for (i=0;i<len;i++){
                if (isalpha(cigar[i])) {
                        s[k]='\0';
                        if (cigar[i]=='M' || cigar[i]=='N' || cigar[i]=='D' || cigar[i]=='X' || cigar[i]=='='){
                                temp_old=temp_new;
                                temp_new=temp_new+atoi(s);
                        }
                        if (cigar[i]=='N'){
                                rec[j]=temp_old; rec[j+1]=temp_new+1;
                                j=j+2; 
                        }
                        k=0;
                }
                else{
                        s[k]=cigar[i]; k++; 
                }
        }
        rec[j]=temp_new; 

	free(s);

	return(j+1);
}	

int find_read_index(int p[4],int start[],int end[],int n,int index[4]){
	int j,i;
	
	for (j=0;j<4;j++){
		if (p[j]<start[0] || p[j]>end[n-1]){
			index[j]=-1;
			break;
		}
		else{
			for (i=0;i<n;i++){
				if (start[i]<=p[j] && end[i]>=p[j]){
					index[j]=i;
					break;
				}	
			}
		}
	}

	if (index[0]<0 || index[1]<0 || index[2]<0 || index[3]<0){
		return 0;
	}
	else{
		return 1;
	}
}

int compare_rec(int a[],int b[],int n){
	int i,flag=1;

	for (i=0;i<n;i++){
		if (a[i]!=b[i]){
			flag=0;
			break;
		}
	}	
	
	return flag;
}	
	


int frag_len_i(int pos_1,char cigar_1[],int pos_2,char cigar_2[],int start[],int end[],int n){
        int x;
	int *length_exon=(int *)malloc(n*sizeof(int));
	int i,flag;
	
	int rec_1[MAX_LEN],rec_2[MAX_LEN];

	for (i=0;i<MAX_LEN;i++){
                rec_1[i]=0; rec_2[i]=0;
	}

        for (i=0;i<n;i++){
                length_exon[i]=end[i]-start[i]+1;
        }	
	
	int n_1=find_se_info(pos_1,cigar_1,rec_1),n_2=find_se_info(pos_2,cigar_2,rec_2),index[4];
	int *a=(int *)malloc(n_1*sizeof(int)),*b=(int *)malloc(n_2*sizeof(int));
	int lr_se[4]={rec_1[0],rec_1[n_1-1],rec_2[0],rec_2[n_2-1]};	

	for (i=0;i<4;i++){
                index[i]=-1;
        }

	if (n_1<=(2*n) && n_2<=(2*n)){
		flag=find_read_index(lr_se,start,end,n,index);				
		if (flag==1){
			if (n_1==2*(index[1]-index[0]+1) && n_2==2*(index[3]-index[2]+1)){
				for (i=0;i<(n_1/2);i++){
					a[2*i]=start[index[0]+i];
					a[2*i+1]=end[index[0]+i];
				}
				a[0]=rec_1[0]; a[n_1-1]=rec_1[n_1-1];

                                for (i=0;i<(n_2/2);i++){
                                        b[2*i]=start[index[2]+i];
                                        b[2*i+1]=end[index[2]+i];
                                }
                                b[0]=rec_2[0]; b[n_2-1]=rec_2[n_2-1];

				if (compare_rec(a,rec_1,n_1)==1 && compare_rec(b,rec_2,n_2)==1){
					x=0;
					for (i=index[0];i<=index[3];i++){
						x=x+length_exon[i];					
					}
					x=x-(rec_1[0]-start[index[0]])-(end[index[3]]-rec_2[n_2-1]);
					return x;
				}
				else{
					return 0;
				}
			}
			else{
				return 0;
			}			
		}
		else{
			return 0;
		}				
	}
	else{
		return 0;
	}		

	free(length_exon); free(a); free(b);
}

void extract_frag_len(int *pos,char **cigar,int *start,int *end,int *m,int *n,int *frag_len){
	int i;

	for (i=0;i<*m;i++){
		frag_len[i]=frag_len_i(pos[2*i],cigar[2*i],pos[2*i+1],cigar[2*i+1],start,end,*n);
	}
}

double **allocate2dDoubleArray(int line,int column){
	double **DoubleArray=(double **)malloc(line*sizeof(double *));
        for (int i=0;i<line;i++){
	        DoubleArray[i]=(double *)malloc(column*sizeof(double));
	}
	return DoubleArray;
}

void deallocate2dDoubleArray(double **array, int line) {     
	for(int i=0;i<line;i++) {
		free(array[i]);
	}

	free(array);     
}

void EM_model_C(int *n_p,int *k_p,double *read_vec,double *epsilon_p,double *p_new){
	int n=*n_p,k=*k_p;
	double epsilon=*epsilon_p;
	int i,j;
	double x,y;

	double **weight=allocate2dDoubleArray(n,k); 
	for (i=0;i<n;i++){
		for (j=0;j<k;j++){
			weight[i][j]=read_vec[i+n*j];
		}
	}

	double *temp_factor=(double *)malloc(n*sizeof(double));
	for (i=0;i<n;i++){
		x=0.0;
		for (j=0;j<k;j++){
			if (weight[i][j]>0.0){
				x=x+1.0;
			}
		}
		temp_factor[i]=(1.0/x);	
	}	

	double *p_old=(double *)malloc(k*sizeof(double));
	for (j=0;j<k;j++){
		x=0.0;
		for (i=0;i<n;i++){
			if (weight[i][j]>0.0){
				x=x+temp_factor[i];
			}	
		}
		p_old[j]=x/n;
		p_new[j]=p_old[j];
	}

	double diff=epsilon+1.0;
	double **temp=allocate2dDoubleArray(n,k);

	while (diff>epsilon){
		for (i=0;i<n;i++){
			x=0.0;
			for (j=0;j<k;j++){
                	        temp[i][j]=p_old[j]*weight[i][j];
				x=x+temp[i][j];
			}
			for (j=0;j<k;j++){
                                temp[i][j]=temp[i][j]/x;
                        }
        	}
		
		y=0.0;
		for (j=0;j<k;j++){
			x=0.0;
			for (i=0;i<n;i++){
				x=x+temp[i][j];
			}
			p_new[j]=x/n;
			y=y+p_new[j];
		}

		if (y!=1.0){
			for (j=0;j<k;j++){
				p_new[j]=p_new[j]/y;
			}
		}

		y=0.0;
		for (j=0;j<k;j++){
			y=y+pow(p_old[j]-p_new[j],2.0);
		}
		diff=sqrt(y);

		for (j=0;j<k;j++){
			p_old[j]=p_new[j];
		}
	}

	deallocate2dDoubleArray(weight,n); deallocate2dDoubleArray(temp,n);
	free(temp_factor); free(p_old);
}

