\name{pie_compare}
\alias{pie_compare}
\title{
Comparison of estimated isoform usages of a gene between two groups by pie plots
}
\description{
\code{pie_compare} creates a pdf file in which two pie plots are presented side by side, separated by a legend.
Each of the two pie plots represents the estimated isoform usage of the gene in each group
and the estimated isoform usage is calculated as the average (in either Euclidean or Aitchison geometry) of the estimated isoform usages in \code{estimates.file} for the samples in the group.
}
\usage{
pie_compare(gene.name, n1, estimates.file = "estimates.txt",
            geometry = "Euclidean", adjust.weight = 1e-300,
            output.file = 
            paste("Pieplot_", gene.name, ".pdf", sep = ""),
            group.name = c("1", "2"),
            output.screen=FALSE)
}
\arguments{
  \item{gene.name}{
	Name of the gene.
}
  \item{n1}{
	Number of samples in the first group.
}
  \item{estimates.file}{
	The path (either relative or full) of the tab-delimited text file (with header) 
	which contains the estimated isoform usages of genes in \code{gene.name} in both two groups,
	e.g., the output file ``estimates.txt'' by function \code{\link{IUTA}}.
}
  \item{geometry}{
        In which geometry the average of the estimated isoform usages in each group is calculated.
	It can be either ``Eucliden'' or ``Aitchison''.
	The default is ``Euclidean'', i.e., the average in the normal sense.
	See "References" for details of Aitchison geometry.
}
  \item{adjust.weight}{
	A small positive value that is used to replace the zero entries (if any) of the estimated isoform usages (from \code{estimates.file}) when \code{geometry="Aitchison"}.
 	The purpose of such adjustments is to make the isometric logratio transformation (ilr) applicable to the estimated isoform usages,
	which is an essential step when calculating the average of the estimated isoform usages in Aitchison geometry.
	The default is \eqn{10^{-2}}.
	See "References" for details of ilr transformation.
}
  \item{output.file}{
	The path (either relative or full) of the output pdf file. See ``Details'' for the details of the output pdf file.  
}
  \item{group.name}{
        A character vector of the names of the two groups.
        The first (second) element is the name of the first (second) group.
        The default names are "1" and "2".
}
  \item{output.screen}{
	Whether to print the pie plot(s) on screen.
	The default is \code{FALSE} (not to print on screen).
}	
}
\details{
The \code{pie_compare} is similar to \code{\link{bar_compare}}.
Like  \code{\link{bar_compare}}, \code{pie_compare} takes a tab-delimited text file with path \code{estimates.file},
which contains the estimated isoform usages for the gene \code{gene.name} in samples from two groups,
and compare the isoform usages in the two groups graphically.
The difference is that \code{pie_compare} creates pie plots of the averages of the estimated isoform usages in the two groups
while \code{\link{bar_compare}} creates bar plots of the estimated isoform usages in all samples of the two groups.
See the ``Details'' of \code{\link{bar_compare}} for the format of text file with path \code{estimates.file}.

Note that when no estimates is recorded in the text file with path \code{estimates.file} for the gene \code{gene.name} in group one (two),
then the output pdf file with path \code{output.file} contains only one pie plot for group two (one).
Also note that no percentage labels for isoforms with relative abundances less than 0.005 (to avoid overlapped labels).
}
\value{
	No value is returned by \code{pie_compare}.
}
\references{
Pawlowsky-Glahn, V. and Egozcue, J. J. (2001). 
Geometric approach to statistical analysis on the simplex. 
\emph{Stochastic Environmental Research and Risk Assessment}, \bold{15(5)}, 384--398.

Egozcue, J. J., Pawlowsky-Glahn, V., Mateu-Figueras, G., and Barcel\'{o}-Vidal,C. (2003).
Isometric logratio transformations for compositional data analysis.
\emph{Mathematical Geology}, \bold{35(3)}, 279--300.
}
\author{
Liang Niu
}
\seealso{
\code{\link{IUTA}}
}
\examples{
## read the sample tab-delimied file with
## the estimated isoform usage information
estimates<-system.file("sampleoutput","estimates.txt",package="IUTA")

## plot the pie plots to comapre the isoform usages
## of gene "Frmd5" between two groups
pie_compare("Mrpl15",n1=3,estimates,output.screen=TRUE)

## now the "Pieplot_Frmd5.pdf" is
## in the current directory

## remember to delete the pdf file
file.remove("Pieplot_Mrpl15.pdf")
}

