\name{bar_compare}
\alias{bar_compare}
\title{
Comparison of estimated isoform usages of a gene between two groups of samples by a bar plot
}
\description{
\code{bar_compare} creates a pdf file with a bar plot in which vertical bars that represent the same isoform are juxtaposed in the same column.
Each column represents an isoform of the gene and each bar in the column represents the estimated relative abundance of the corresponding isoform in a sample.
Bars for different sample groups are differently colored. 
See ``Details'' for the details of the output bar plot.
}
\usage{
bar_compare(gene.name, n1, estimates.file = "estimates.txt",
            output.file = 
            paste("Barplot_", gene.name, ".pdf", sep = ""),
            legend.pos = "topright", group.name = c("1","2"),
            output.screen = FALSE)
}
\arguments{
  \item{gene.name}{
	Name of the gene whose estimated isoform usages are used to create the bar plot.
}
  \item{n1}{
	Number of samples in the first group.
}
  \item{estimates.file}{
	The path (either relative or full) of the tab-delimited text file (with header) 
	which contains the estimated isoform usages for gene \code{gene.name} in the samples,
	e.g., the output file ``estimates.txt'' for isoform usages from \code{\link{IUTA}} function.
	See ``Details'' for the format of the tab-delimited text file. 
}
  \item{output.file}{
	The path (either relative or full) of the output pdf file. See ``Details'' for the details of the output pdf file.  
}
  \item{legend.pos}{
        The location of the legend of the bar plot. 
	It is a keyword from the list \code{``bottomright''}, \code{``bottom''}, \code{``bottomleft''}, \code{``left''}, \code{``topleft''}, \code{``top''}, \code{``topright''}, \code{``right''} and \code{``center''}.
	The defult is \code{``topright''}.
}
  \item{group.name}{
	A character vector of the names of the two groups.
        The first (second) element is the name of the first (second) group.
        The default names are "1" and "2".
}
  \item{output.screen}{
	Whether to print the bar plot on screen.
	The default is \code{FALSE} (not to print on screen).
}	
}
\details{
The tab-delimied text file with path \code{estimates.file} (with header) should contain \eqn{2+n_1+n_2} columns:
the first two columns are the gene name (column 1) and the isoform (column 2);
the next \eqn{n_1} columns are the estimates of the relative isoform abundance of the isoform from samples in group one;
the last \eqn{n_2} columns are the estimates of the relative isoform abundance of the isoform from samples in group two.
Such a file can be obtained by \code{\link{IUTA}}.

\code{bar_compare} first checks the tab-delimited text file with path \code{estimates.file} to see if there is any records for the gene \code{gene.name}.
If there is no record or the estimated relative abundances are all \code{NA}s for all the isoforms of the gene in all the samples,
\code{bar_compare} stops with an error message "NO data for the input gene!";
otherwise \code{bar_compare} plots a bar plot using all the valid (not \code{NA}) estimated isoform usages and saves the plot in a output pdf file with path \code{output.file}.
In the bar plot, there are \eqn{K} columns that represent the \eqn{K} isoforms of the gene.
In each column, there are \eqn{a+b} juxposed vertical bars, where \eqn{a} (\eqn{b}) is the number of valid estimated isoform usages in group one (two);
each bar represents the relative abundance of the corresponding isoform in a sample;
the \eqn{a} bars for samples in group one are colored in red and the  \eqn{b} bars for samples in group two are colored in green.
The title of the plot include the gene name \code{gene.name} and the information of \eqn{a} and \eqn{b}.
Note that the order of the samples represented by the \eqn{a+b} bars in each column is identical for all the columns.
}
\value{
	No value is returned by \code{bar_compare}.
}
\author{
Liang Niu
}
\seealso{
\code{\link{IUTA}}
}
\examples{
## read the sample tab-delimied file with
## the estimated isoform usage information
estimates<-system.file("sampleoutput","estimates.txt",package="IUTA")

## plot the bar plots to comapre the isoform usages
## of gene "Frmd5" between two groups
bar_compare("Mrpl15",n1=3,estimates,legend.pos="topleft",output.screen=TRUE)

## now the "Barplot_Frmd5.pdf" is
## in the current directory

## remember to delete the pdf file
file.remove("Barplot_Mrpl15.pdf")
}

