\name{IUTA-package}
\alias{IUTA-package}
\docType{package}
\title{
Isoform Usage Two-step Analysis
}
\description{
Package \code{IUTA-package} performs a two-step analysis to detect genes with differential isoform usages (set of relative abundances of isoforms) between two samples.
In addition to the main function \code{\link{IUTA}}, it also provide a function \code{\link{GetGeneGtf}} to generate a GTF file suitable for \code{IUTA} and two functions
i.e., \code{\link{bar_compare}} and \code{\link{pie_compare}},
to present a gene's isoform usages between two groups.
}
\details{
\tabular{ll}{
Package: \tab IUTA\cr
Type: \tab Package\cr
Version: \tab 1.0\cr
Date: \tab 2013-08-20\cr
License: \tab GPL (>=2)\cr
}

\code{\link{pie_compare}} provides a comparison of isoform usages of a gene between two groups by two pie plots.

\code{\link{bar_compare}} provides a comparison of isoform usages of a gene between two groups of samples by a bar plot.

\code{\link{IUTA}} takes BAM files from two groups of samples and a GTF file of the related species and tests for differential isoform usages (set of isoform relative abundances) for the inquired genes.

\code{\link{GetGeneGtf}} creates a new GTF file (with correct gene id) from a input GTF file and a gene-transcript reference file.
}
\author{
Liang Niu

Maintainer: Liang Niu <niul@niehs.nih.gov>
}
\references{
Liang Niu, Weichun Huang, David M. Umbach and Leping Li (2013).
IUTA: a tool for effectively detecting differential isoform usage from RNA-Seq data,
in preparation.

See \url{http://mblab.wustl.edu/GTF22.html} for the details of Gene transfer format (GTF) and \url{http://samtools.sourceforge.net/SAMv1.pdf} for the details of Sequence Alignment/Map (SAM) format. The BAM format is the compressed binary version of SAM format.
}
\keyword{ package }
