SKK_BF_u <-
function(data.1,data.2,log.p=FALSE){
        data.1<-as.vector(data.1)
        data.2<-as.vector(data.2)

        N1<-length(data.1)
        N2<-length(data.2)

        x1.bar<-mean(data.1)
        x2.bar<-mean(data.2)

        S1<-var(data.1)
        S2<-var(data.2)

        D.hat<-S1/N1+S2/N2
        var.hat<-2-2*(S1/D.hat)^2/((N1-1)*N1^2)-2*(S2/D.hat)^2/((N2-1)*N2^2)

        T<-((x1.bar-x2.bar)^2/D.hat-1)/sqrt(var.hat*2)
        p.value<-pnorm(T,lower.tail=F,log.p=log.p)

        return(p.value)
}
