SKK_BF <-
function(data.1,data.2,log.p=FALSE){
	N1<-nrow(data.1)
	N2<-nrow(data.2)
	p<-ncol(data.1)

	x1.bar<-colMeans(data.1)
	x2.bar<-colMeans(data.2)

	S1<-s.temp(data.1-matrix(rep(x1.bar,N1),nrow=N1,byrow=T))
	S2<-s.temp(data.2-matrix(rep(x2.bar,N2),nrow=N2,byrow=T))

	D.hat<-diag(diag(S1))/N1+diag(diag(S2))/N2
	R<-diag(1/sqrt(diag(D.hat)))%*%(S1/N1+S2/N2)%*%diag(1/sqrt(diag(D.hat)))

	var.hat<-2*matrix.trace(R%*%R)/p-2*(matrix.trace(diag(1/diag(D.hat))%*%S1))^2/(p*(N1-1)*N1^2)-2*(matrix.trace(diag(1/diag(D.hat))%*%S2))^2/(p*(N2-1)*N2^2)
	c.pn<-1+matrix.trace(R%*%R)/(sqrt(p)^3)

	T<-as.numeric((t(as.matrix(x1.bar-x2.bar))%*%diag(1/diag(D.hat))%*%as.matrix(x1.bar-x2.bar)-p)/sqrt(p*var.hat*c.pn))
	p.value<-pnorm(T,lower.tail=F,log.p=log.p)
	
	return(p.value)
}
