KY_BF <-
function(data.1,data.2,log.p=FALSE){
	N1<-nrow(data.1)
	N2<-nrow(data.2)
	p<-ncol(data.1)

	x1.bar<-colMeans(data.1)
	x2.bar<-colMeans(data.2)
	
	S1<-s.temp(data.1-matrix(rep(x1.bar,N1),nrow=N1,byrow=T))
	S2<-s.temp(data.2-matrix(rep(x2.bar,N2),nrow=N2,byrow=T))
	
	S<-(S1/N1+S2/N2)

	if (is.na(rcond(S))){
		return(NA)
	}
	else if (rcond(S)<.Machine$double.eps){
		return(NA)
	}
	else{
		T2.stat<-matrix(x1.bar-x2.bar,nrow=1)%*%solve(S)%*%matrix(x1.bar-x2.bar,ncol=1)
		
		S1.S.inv<-(S1%*%solve(S))
		S2.S.inv<-(S2%*%solve(S))
		d<-(p*(p+1))/((matrix.trace(S1.S.inv%*%S1.S.inv)+matrix.trace(S1.S.inv)^2)/(N1^2*(N1-1))+(matrix.trace(S2.S.inv%*%S2.S.inv)+matrix.trace(S2.S.inv)^2)/(N2^2*(N2-1)))

		if (d<min(N1-1,N2-1) | d>(N1+N2-2)){
			return(NA)
		}
		else{
			adj.T2.stat<-T2.stat*(d-p+1)/(d*p)
			p.value<-pf(adj.T2.stat,p,d-p+1,lower.tail=F,log.p=log.p)
			return(p.value)
		}
	}
}
