GetGeneGtf <-
function(gene.file.name,transcript.gtf.name,out.gtf.name="modified.gtf"){
	gene.file<-read.delim(gene.file.name,stringsAsFactors=FALSE,header=FALSE,comment.char="#",col.names=c("ID","gene"))
	gene.file<-unique(gene.file[complete.cases(gene.file),,drop=FALSE])
	gene.file<-gene.file[gene.file$ID!="" & gene.file$gene!="",,drop=FALSE]
	gene.file$gene<-gsub(" ","_",gene.file$gene)
	
	transcript.gtf<-read.delim(transcript.gtf.name,stringsAsFactors=FALSE,header=FALSE,comment.char="#",col.names=paste("C",1:9,sep=""))

	gtf.9<-strsplit(transcript.gtf[,9]," |;")
	order.trans.id<-match("transcript_id",gtf.9[[1]])+1
	transcript<-unlist(lapply(gtf.9,"[",order.trans.id))
	unique.transcript<-unique(transcript)

	temp<-gene.file$ID[gene.file$ID %in% unique.transcript]; exclude.1<-unique(temp[duplicated(temp) | duplicated(temp,fromLast=TRUE)]);
	exclude.2<-setdiff(unique.transcript,gene.file$ID)
	exclude<-union(exclude.1,exclude.2)
	if (length(exclude)>0){
		transcript.gtf<-transcript.gtf[!(transcript %in% exclude),]; transcript<-transcript[!(transcript %in% exclude)];	
	}

	gene.ref<-gene.file$gene[match(transcript,gene.file$ID)]
	transcript.gtf[,9]<-paste("gene_id ",gene.ref,"; transcript_id ",transcript,";",sep="")

	write.table(transcript.gtf,out.gtf.name,quote=FALSE,row.names=FALSE,col.names=FALSE,sep="\t")

        if (length(exclude.1)>0){
                warning("Found transcript(s) in annotation that belong to different genes! These transcripts are removed from the gene annotation!")
        }
        if (length(exclude.2)>0){
                warning("found transcript(s) in annotation but not in reference! These transcripts are removed from the gene annotation!")
        }
}
