CQ_BF <-
function(data.1,data.2,log.p=FALSE){
		n1<-nrow(data.1)
		n2<-nrow(data.2)
		p<-ncol(data.1)
	
		if (min(n1,n2)<2){
			return("sampe size too small!")
		}
		else{
			temp<-0
			for (i in 1:(n1-1)){
					for (j in (i+1):n1){
						temp<-temp+sum(data.1[i,]*data.1[j,])
					}
			}
			term.1<-(2*temp)/(n1*(n1-1))
					
			temp<-0
			for (i in 1:(n2-1)){
					for (j in (i+1):n2){
						temp<-temp+sum(data.2[i,]*data.2[j,])
					}
			}
			term.2<-(2*temp)/(n2*(n2-1))					

			x1.bar<-colSums(data.1)/n1
			x2.bar<-colSums(data.2)/n2
			term.3<-2*sum(x1.bar*x2.bar)
			
			Tn<-term.1+term.2-term.3
		
			temp<-0
			for (j in 1:(n1-1)){
				for (k in (j+1):n1){
					if (n1==2){
						x1.bar.jk<-rep(0,p)
					}
					else{
						x1.bar.jk<-(colSums(data.1)-data.1[j,]-data.1[k,])/(n1-2)
					}
					temp<-temp+sum(diag(matrix(data.1[j,]-x1.bar.jk,ncol=1)%*%matrix(data.1[j,],nrow=1)%*%matrix(data.1[k,]-x1.bar.jk,ncol=1)%*%matrix(data.1[k,],nrow=1)))
				}	
			}
			tr.sigma1.sq<-(2*temp)/(n1*(n1-1))
			
			temp<-0
			for (j in 1:(n2-1)){
				for (k in (j+1):n2){
					if (n2==2){
						x2.bar.jk<-rep(0,p)
					}
					else{
						x2.bar.jk<-(colSums(data.2)-data.2[j,]-data.2[k,])/(n2-2)
					}
					temp<-temp+sum(diag(matrix(data.2[j,]-x2.bar.jk,ncol=1)%*%matrix(data.2[j,],nrow=1)%*%matrix(data.2[k,]-x2.bar.jk,ncol=1)%*%matrix(data.2[k,],nrow=1)))
				}
			}
			tr.sigma2.sq<-(2*temp)/(n2*(n2-1))
			
			temp.1<-mat.or.vec(p,p)
			for (l in 1:n1){
				x1.bar.l<-(colSums(data.1)-data.1[l,])/(n1-1)
				temp.1<-temp.1+matrix(data.1[l,]-x1.bar.l,ncol=1)%*%matrix(data.1[l,],nrow=1)
			}
			temp.2<-mat.or.vec(p,p)
			for (k in 1:n2){
				x2.bar.k<-(colSums(data.2)-data.2[k,])/(n2-1)
				temp.2<-temp.2+matrix(data.2[k,]-x2.bar.k,ncol=1)%*%matrix(data.2[k,],nrow=1)
			}				
			tr.sigma12<-sum(diag(temp.1%*%temp.2))/(n1*n2)
		
			sigma.hat.sq<-2*tr.sigma1.sq/(n1*(n1-1))+2*tr.sigma2.sq/(n2*(n2-1))+4*tr.sigma12/(n1*n2)
			sigma.hat<-sqrt(sigma.hat.sq)
			
			return(pnorm(Tn/sigma.hat,lower.tail=F,log.p=log.p))
		}
}
